#!/bin/bash
work=Work
if [ $#  -lt  4 ] || [ $# -gt 6 ]; then
cat <<EOF
 Usage: ./showBremFunc.sh  media  E1 E2 step [norm func]
   This shows brems funciton (f= k dsigma/dk (mb) but
   the unit depend on norm )
   where k= Eg/Ek; Ek being the electron kinetic energy.
   k vs f is kept in Work/fbrems.func  as numerical data
   and graph is in Work/fbrems.png. 
   (old ones, if any,  will be deleted)

   media: such as Fe BGO Air ...
   E1 E2: kinetic energy of electron; form E1 to E2
    step:  log10 step of energy
    norm:  normalization.   (default =1)
           1--> / r.l 
           2--> mb/ingredient
           3--> /(g/cm^2)
           4--> /cm
           5--> area normlization.  Integral (kmin,1) of dsigma/dk=1
    func:  Brems func by Tsai-->1; by Moch & Kotz-->3(default is 1)"
EOF
exit
fi
   
media=$1;  E1=$2; E2=$3; step=$4;
norm=1 
func=1 
if [ $# -ge 5 ]; then
    norm=$5
fi
if [ $# -eq 6 ]; then
    func=$6
fi
# echo input: $media $nevent $E1 $E2 $step

nbin=`awk  'END {nbin=int(log(E2/E1)/log(10.)/step)+1;print nbin}'   E1=$E1 E2=$E2 step=$step /dev/null`
Ek=$E1

rm -f $work/fbrems.png
rm -f $work/fbrems.func

make -f DrawBremsFunc${func}.mk
for f in $(seq 1 $nbin); do
  echo ${f}-th energy=$Ek 

  echo $norm $media $Ek t | ./drawbrems${func}.out >> $work/fbrems.func
  echo " " >> $work/fbrems.func
  Ek=`awk 'END {Ek=Ek*10.**step;print Ek}' Ek=$Ek step=$step /dev/null`
done

echo "Ek=${E1}" > $work/gnuplot.com
echo "step=${step}"  >> $work/gnuplot.com
echo "media=\"${media}\""  >> $work/gnuplot.com
cat fbrems.gp >> $work/gnuplot.com
echo  set output  \"$work/fbrems.png\" >>$work/gnuplot.com
echo  rep  >>$work/gnuplot.com

gnuplot $work/gnuplot.com
