c     *****************
      subroutine eptotcbH(vmin, vmax, ans)
c     ****************
*     implicit none

      real*8 vmin, vmax, ans
c
c        integration of bremsung function from vmin to vmax.
c
      external  epBremSH
      real*8    epBremSH

      real*8 v1, v2,  ans1

      ans=0.
      v2=vmax
      v1 = 0.  
      do while (v1 .ne. vmin)
         v1=max( v2/4.0d0,  vmin)
         call k16pGaussLeg(epBremSH, v1, v2, 16,  ans1)
         ans=ans+ans1
         v2=v1
      enddo
      end
c    *************************
      real*8 function epPairSH(x)
c    *************************
      implicit none
#include "Zmedia.h"
#include "ZBPgene.h"

      real*8 x


      real*8 epPairH


      call epBPZpartH(media)

      epPairSH = epPairH(Egme, x)
      end

c    *************************
      real*8 function epBremSH(x)
c    *************************
      implicit none
#include "Zmedia.h"
#include "ZBPgene.h"

      real*8 x

      real*8 epBremH

      call epBPZpartH(media)

      epBremSH = epBremH(Eeme, x)
      end
c
c     *****************
      subroutine eptotcpH(vmin, vmax, ans)
c     ****************
      implicit none
c        integralation of pair-cre function
      real*8 vmin, vmax, ans
c
c
      external  epPairSH
      real*8    epPairSH

      real*8   ans1, ans2, d, vt


      d=(vmax-vmin)/30.d0
      vt=vmax-d
      call k16pGaussLeg(epPairSH, vmin, vt, 10,  ans1)
      call k16pGaussLeg(epPairSH, vt, vmax, 10,  ans2)
      ans=ans1+ans2
      end
c
c
c     **************
      real*8 function epBrSolvH(v)
c     **************
      implicit none
c
c          used to solve total-cross-section * u = integral of
c          brem function from min to v.
c
c
c
      common/upsic/upsi,vmax
      real*8 upsi, vmax
      
      real*8 v
      
      real*8 ans

      call eptotcbH(v, vmax, ans)

      epBrSolvH = ans/upsi-1.d0
      end



c     **************
      real*8 function epPrSolvH(v)
c     **************
      implicit none
c
c          used to solve total-cross-section * u = integral of
c          pair function from min to v.
c
c
c
      common/upsic/upsi,vmax
      real*8 upsi, vmax

      real*8 v
      
      real*8 ans

      call eptotcpH(v, vmax, ans)
      epPrSolvH = 2*ans/upsi-1.d0
      end
