      subroutine epBrHSampP(media, Ee, prob)
      implicit none
#include "Zmedia.h"
c        Brems sampling at LPM energies.
      record /epmedia/media
      real*8 Ee
      real*8 prob  ! output probability of Brems / X0

      real*8 ale

      if(Ee .lt. media.cnst.BrEe1H/media.rhoc) then
         call cerrorMsg(
     *      'Energy is too low for LPM brems', 0)

      elseif(Ee .lt. media.cnst.BrEe2H) then
         ale=log10(Ee)
         call kintp3(media.tbl.BrTXH,
     *   1, media.cnst.BrneH, media.cnst.BrLEe1H,
     *   media.cnst.BrdEH, ale, prob) 

      else
c          use  1/sqrt(E) low
         prob = media.tbl.BrTXH(media.cnst.BrneH)/
     *         sqrt((Ee/media.cnst.BrEe2H))
      endif
      end
c     ************
      subroutine epBrHSampE(media, Ee, Eg)
c     ************
      implicit none
#include "Zglobalc.h"
#include "Zmedia.h"
#include "Zmass.h"

      record /epmedia/media
      real*8 Ee,  Eg

      real*8 u, ale, us, ans, sqrtvm, Ek
      real*8 error

      call rndc(u)
      Ek = Ee - masele
      ale = log10(Ee)
      if(Ee .lt. media.cnst.BrEe2H2) then
         if(u .gt. media.cnst.BrU1H) then
c          region A
c&&&&&&&&&&&&&
c            call k4ptdi(media.tbl.BrSTHA, 
c     *        media.cnst.Brnu1H, 
c     *        media.cnst.BrneH2,
c     *        media.cnst.Brnu1H, 
c     *        media.cnst.BrU1H,
c     *        media.cnst.BrLEe1H,
c     *        media.cnst.BrdU1H,
c     *        media.cnst.BrdEH2, u,  ale,  ans)  
            call kpolintp2(media.cnst.BrU1H, 1,  media.cnst.BrdU1H,
     *         media.cnst.BrLEe1H, 1,  media.cnst.BrdEH2, 
     *         media.tbl.BrSTHA, media.cnst.Brnu1H, 
     *         media.cnst.Brnu1H,  media.cnst.BrneH2,
     *           3, 3, u, ale, ans, error)
c&&&&&&&&&&&&
c             sqrtvm = sqrt(media.cnst.BrEgminH/media.rhoc/Ee)
            sqrtvm = sqrt(media.cnst.BrEgminH*Ek/media.rhoc/Ee)
            Eg =
     *      ( (1.d0-u) * ans + sqrtvm)**2 * Ee
         else
c          region B
            us= u**(1./media.cnst.BrPow)
c&&&&&&&&&&&&&&
c            call k4ptdi(media.tbl.BrSTHB, 
c     *        media.cnst.Brnu2H,
c     *        media.cnst.BrneH2,
c     *        media.cnst.Brnu2H,
c     *        media.cnst.BrU3H,
c     *        media.cnst.BrLEe1H,
c     *        media.cnst.BrdU2H,
c     *        media.cnst.BrdEH2, us,  ale,  ans)  
            call kpolintp2(media.cnst.BrU3H, 1,  media.cnst.BrdU2H,
     *         media.cnst.BrLEe1H, 1,  media.cnst.BrdEH2, 
     *         media.tbl.BrSTHB, media.cnst.Brnu2H,
     *         media.cnst.Brnu2H,  media.cnst.BrneH2,
     *           3, 3, us, ale, ans, error)
c&&&&&&&&&&&&&&
c            Eg= exp(- ans*u )*(Ee-masele)
            Eg= exp(- ans*u )*Ek
         endif
      else
c           use rejection method; employ cosmos function
c           neglect  Eg/Ee< 1.e-6
         call csetLPMCnst(media.s1, media.logs1, 
c     *     max(1.d-6, media.cnst.BrEgminH/media.rhoc/Ee),
     *     max(media.cnst.BrEgminH,
     *         media.cnst.BrEgminH*Ek/media.rhoc/Ee),
     *      media.X0g*Tokgpm2)     ! X0g in kg/m^2
         call cbremErgLPM(Ee, media.rho*media.rhoc*Tokgpm3, Eg)  ! rho in kg/m^3
      endif
      end
