      real*8 function epPrgenex(x)
      implicit none
#include "Zmedia.h"
#include "Zmass.h"
#include "ZBPgene.h"

c
c         epPrgenex. in mb
c
c        Generic pair function for the entire energy region.
c  This must be called after epBPGeneini has been called
c  and  /BPgene/ common variable has been set.

c  The common variables to be set is Egme.
c
c
c  This may be used for integration of Pair function.
c  The functions in various energy regions are smoothly connected
c  as much as possilbe.  Especially the LPM function is
c  normalized to the complete screening function at x=0.75 and
c  Eg = PairEgmaxL  when  it is used at high energies.
c     
      real*8 x  !  input Ee/Eg. 
      real*8 epPrgene
      real*8 Eg

      Eg= Egme * masele
      epPrgenex = epPrgene(Eg, x)

      end

c     **********************************
      real*8 function epPrgene(Eg, x)
      implicit none
c
c     Generic pair creation function for entire energy region.
c     The same note as for epPrgenex
c
c     Eg < PairNonSc ==> Original B.H is modified
c     Eg < PairScrE  ==> partial screening only 
c     PairWcrE< Ee < PairEgmaxL===>complete sc. 
c     Ee < Eg2H      ===> complete sc.+ LPM  table
c     Ee > Ee2H      ===> comp. + LPM  by rejection
c
c
#include "Zglobalc.h"
#include "ZbasicCnst.h"
#include "Zmedia.h"
#include "Zmass.h"
#include "ZBPgene.h"

      real*8  Eg  ! input. electron energy in GeV.
      real*8  x   ! input. x = Ee/Eg.



      real*8  epPairS, epPairSH
      real*8  epCompScrPr
c
      integer i
      real*8 f, normf

      if(Eg .lt. media.cnst.PairEgmin) then
         f  = 0.
      elseif(Eg .le.  media.cnst.PrScrE) then
c           partil screening or no screening
         f = epPairS(x)
      elseif(Eg .le. media.cnst.PairEgmaxL .and.
     *       Eg .gt.   media.cnst.CompScrE) then
c          complete screening without LPM
         f = 0
         do i = 1, media.noOfElem
            f = f +
     *           epCompScrPr(media.elem(i).Z, x)*media.No(i)
         enddo
      else
c          complete screening +  LPM
         call  epNormLPMp(normf)
         f = epPairSH(x)*normf
      endif
      epPrgene = f
      end
c     ************************************
      subroutine epPrgeneTX(xmin, xmax, tx)
      implicit none
#include "Zglobalc.h"
#include "ZbasicCnst.h"
#include "Zmedia.h"
#include "Zmass.h"
#include "ZBPgene.h"


      real*8  xmin  ! input.  Ee/Eg min.
      real*8  xmax  ! input.  Ee/Eg max.
      real*8  tx    ! output.  Integral of pair function from
                    !         x= xmin to xmax
      external epPrgenex
      real*8   epPrgenex,  ans1, ans2
      real*8  Eg, d,  vt

      Eg = Egme *masele

      d=(xmax-xmin)/20.d0
      vt=xmax-d
      call k16pGaussLeg(epPrgenex, xmin, vt, 16,  ans1)
      call k16pGaussLeg(epPrgenex, vt, xmax, 16,  ans2)
      tx = ans1+ans2

      end
c     **************
      real*8 function epPrgeneSolv(v)
c     **************
      implicit none

c          used to solve total-cross-section * u = integral of
c          pair function from min to v.
c
c
c
      common/upsic/upsi,vmax
      real*8 upsi, vmax

      real*8 v

      real*8 ans

      call epPrgeneTX(v, vmax, ans)

      epPrgeneSolv = ans/upsi-1.d0

      end
