c
c  open cylinder
c                                        
c  bottom circle center is at (0,0,0).  hight is directed to Z.
c      
c
c
c   Data format in config is:
c       ox oy oz  r  h  sa  ea
c
c      where (ox,oy,oz) is the origin in the world coord.
c            r: radius of the cylinder  cm
c            h: height of the //        cm
c           sa: starting angle (deg)  0 is the x-axis. counter clock wise.
c           ea: ending angle (deg).  sa=0 ea=360 means cyl.
c              sa may be > ea.
c      
      subroutine eprocyl(comp)
       implicit none
#include "Zglobalc.h"
#include "Zep3Vec.h"
#include "Zcnfig.h"
c
c         interface to read configuration data for "ocyl"
c
       record /Component/ comp  ! output. to recieve the config data.
       character*150 msg
 
       integer ir, ih, isa, iea, 
     * ircossa, irsinsa,  ircosea, irsinea
       parameter( ir = 1,  ih = 2,  isa=3, iea=4,
     *   ircossa=5, irsinsa=6, ircosea=7, irsinea=8)

       real*8 r, h, sa, ea
c
c           read open cylinder data as 'new-*'
c           ocyl has 4 volume attributes and the direction cosines
c           of the  h (1~6)
c
c             next is mandatory
        call eprpst(comp, 4, 8, 1, 6)
c
c           next is optional
c           check some values
        r = Volat( comp.vol + ir)
        h = Volat( comp.vol + ih)
        sa= Volat( comp.vol + isa)
        ea= Volat( comp.vol + iea)
        if(r  .le. 0. .or. h .le. 0. .or. sa .lt. 0. 
     *      .or. ea .gt. 360.) then
           write(msg, *) comp.cn, '-th component: r=', r,
     *    ' h=', h, ' sa=',sa, ' ea=',ea,
     *    ' for ocyl;  invalid'
           call cerrorMsg(msg, 0)
        endif
c             compute const for later use.
        Volat( comp.vol + ircossa) = r*cos(sa*Torad)
        Volat( comp.vol + irsinsa) = r*sin(sa*Torad)
        Volat( comp.vol + ircosea) = r*cos(ea*Torad)
        Volat( comp.vol + irsinea) = r*sin(ea*Torad)
       end
c   ***************************************
      subroutine epbocyl(comp, pos, dir, length, icon)
       implicit none
#include "Zglobalc.h"
#include "ZepTrackp.h"
#include "Zep3Vec.h"
#include "Zcnfig.h"
#include "ZepPos.h"
#include "ZepDirec.h"
#include "Zepdebug.h"

c
c        find length to the boundary of 'comp' from 'pos'
c        with direction cos 'dir'
c     'pos' and 'dir' are given in this 'comp' local coordinate.
c 
 

       record /Component/comp  ! input. you can extract volume parameters
                               !  by Volat( comp.vol + 1), etc
       record /epPos/ pos   ! input.  position.
       record /epDirec/ dir  ! input. direction cosinse

       real*8  length !  output length cm from pos to the boundary
       integer icon  ! output 0: length obtained. pos    is inside
                     !        1:  //                        outside
                     !       -1: the line dose not cross the volume

       common /Zocyl/  where
       integer where   ! 1 top, 3; cut part sa; 4; cut part ea; 6 bottom

 
       integer ir, ih, isa, iea, 
     * ircossa, irsinsa,  ircosea, irsinea
       parameter( ir = 1,  ih = 2,  isa=3, iea=4,
     *   ircossa=5, irsinsa=6, ircosea=7, irsinea=8)

       real*8 r, h, sa, ea

       integer  jcon, kcon
c
       record /epPos/ p1, p2, p3, p4, xp

       real*8   l, angs,  angx
       logical isinside
       real*8 x
       isinside(x) = mod(ea-sa+360.d0, 360.d0) .ge.
     *               mod(x-sa+360.d0, 360.d0)


       r = Volat( comp.vol + ir)
       h = Volat( comp.vol + ih)
       sa= Volat( comp.vol + isa)
       ea= Volat( comp.vol + iea)

       where = 0

       call kxplcy(pos.x, pos.y, pos.z, dir.x, dir.y, dir.z, r, h,
     *  length,    icon, where)
c  output:
c     length: x-sing point is at pos + length*dir ( el>=0)
c   icon : output. 0 the point is in the cyl. length is obtained
c                  1 the point is outside of the cyl. length is
c                     obtained.
c                 -1 no x-ing point
c   where: output. 1  x-ing point is on x-y  top plane.
c                  2  //             on the side.
c                  6  //             on      bottom.
c                 -1  no x-ing point
       

       if( sa .eq. 0. and. ea .eq. 360.d0 ) then
c           full cyl. 
          return     ! **********
       elseif( icon .eq. -1 ) then
c               no x-point
          return     ! ***********
       elseif(icon .eq. 1) then
          xp.x = pos.x + length*dir.x
          xp.y = pos.y + length*dir.y
          angx = atan2(xp.y, xp.x)*Todeg
          if( isinside(angx) ) goto 100

c               x.p  may be on the cut part
          p1.x = Volat( comp.vol + ircossa)
          p1.y = Volat( comp.vol + irsinsa)
          p1.z = 0.
             
          p2.x = p1.x
          p2.y = p1.y
          p2.z = h

          p3.x = 0.d0
          p3.y = 0.d0
          p3.z = h

          p4.x = 0.d0
          p4.y = 0.d0
          p4.z = 0.d0
          call epxpLand4vp(p1, p2, p3, p4, pos, dir, l, kcon, jcon)
          if(kcon .le. 4) then
             length = l
             where = 3
             goto 100
          endif
c               x.p  may be on the other cut part
          p1.x = Volat( comp.vol + ircosea)
          p1.y = Volat( comp.vol + irsinea)
          p1.z = 0.
             
          p2.x = 0.
          p2.y = 0.
          p2.z = 0.
          
          p3.x = 0.d0
          p3.y = 0.d0
          p3.z = h
          
          p4.x = p1.x
          p4.y = p1.y
          p4.z = h
          call epxpLand4vp(p1, p2, p3, p4, pos, dir, l, kcon, jcon)
          if(kcon .le. 4) then
             length = l
             where = 4
             goto 100
          else
             icon = -1
          endif
       else
c           icon = 0;  pos is inside of the cyl.
c          
          angs = atan2(pos.y, pos.x)*Todeg
          if(isinside(angs)) then
             xp.x = pos.x + length*dir.x
             xp.y = pos.y + length*dir.y
             angx = atan2(xp.y, xp.x)*Todeg
             if(isinside(angx)) goto 100
          endif
          p1.x = Volat( comp.vol + ircossa)
          p1.y = Volat( comp.vol + irsinsa)
          p1.z = 0.
             
          p2.x = p1.x
          p2.y = p1.y
          p2.z = h

          p3.x = 0.d0
          p3.y = 0.d0
          p3.z = h

          p4.x = 0.d0
          p4.y = 0.d0
          p4.z = 0.d0
          call epxpLand4vp(p1, p2, p3, p4, pos, dir, l, kcon, jcon)
          if(kcon .le. 4) then
             length = l
             where = 3
             if(.not. isinside(angs)) then
                icon = 1
             endif
             goto 100
          endif
c               x.p  may be on the cut part
          p1.x = Volat( comp.vol + ircosea)
          p1.y = Volat( comp.vol + irsinea)
          p1.z = 0.
             
          p2.x = 0.
          p2.y = 0.
          p2.z = 0.

          p3.x = 0.d0
          p3.y = 0.d0
          p3.z = h

          p4.x = p1.x
          p4.y = p1.y
          p4.z = h
          call epxpLand4vp(p1, p2, p3, p4, pos, dir, l, kcon, jcon)
          if(kcon .le. 4) then
             length = l
             where = 4
             if(.not.isinside(angs)) then
                icon = 1
             endif
          else
             icon = -1
          endif                      
       endif
 100   continue
       end          
       subroutine epqocyl(whichpart)
       implicit none
c         inquire the pos. of x.p 
       integer whichpart ! output. 1; top, 
                        !         2: side (full cyl)
                        !         3: cut sa:
                        !         4: cut ea;
                        !         6: bottom  
        common /Zocyl/  where
        integer where   ! 1 top, 3; cut part sa; 4; cut part ea; 6 bottom
       
       whichpart = where
       end

c      **********************************
      subroutine epsocyl(comp, pos, icon)
      implicit none
#include "Zglobalc.h"
#include "Zep3Vec.h"
#include "Zcnfig.h"
#include "ZepPos.h"
c
c           judge if a given 'pos' is inside 'comp'
c         
      record /Component/ comp !input component
      record /epPos/ pos  ! input. position in  local coord.
      integer icon  ! output. 0--> pos is inside
                    !         1-->        outside

 
       integer ir, ih, isa, iea,
     * ircossa, irsinsa,  ircosea, irsinea
       parameter( ir = 1,  ih = 2,  isa=3, iea=4,
     *   ircossa=5, irsinsa=6, ircosea=7, irsinea=8)

       real*8 r, h, sa, ea
c

       real*8   ang 

       logical isinside
       real*8 x
       isinside(x) = mod(ea-sa+360.d0, 360.d0) .ge.
     *               mod(x-sa+360.d0, 360.d0)

       r = Volat( comp.vol + ir)
       h = Volat( comp.vol + ih)
       sa= Volat( comp.vol + isa)
       ea= Volat( comp.vol + iea)

       if( pos.z .lt. 0.d0 ) then
          icon = 1
       elseif( pos.z .gt. h ) then
          icon = 1
       elseif(pos.x**2+ pos.y**2 .gt. r**2) then
          icon = 1
       else
          ang = atan2(pos.y, pos.x)* Todeg
          if(isinside(ang)) then
             icon =0
          else
             icon = 1
          endif
       endif

      end
c     **************************************
      subroutine epenvlpocyl(comp, org, abc)
      implicit none

#include "Zep3Vec.h"
#include "Zcnfig.h"
#include "ZepPos.h"

c
c        give the envloping box of the component
c
      record /Component/ comp  ! input.   component.
      record /epPos/ org       ! output.  origin of the enveloping box
                               !          in local coord. 
      record /ep3Vec/ abc      ! output.  a,b,c of the box

 
       integer ir, ih, isa, iea,
     * ircossa, irsinsa,  ircosea, irsinea
       parameter( ir = 1,  ih = 2,  isa=3, iea=4, 
     *   ircossa=5, irsinsa=6, ircosea=7, irsinea=8)

       real*8 r, h, sa, ea
       logical isinside
       real*8 x, xs, ys, xe, ye
       isinside(x) = mod(ea-sa+360.d0, 360.d0) .ge.
     *               mod(x-sa+360.d0, 360.d0)





       r = Volat( comp.vol + ir)
       h = Volat( comp.vol + ih)
       sa= Volat( comp.vol + isa)
       ea= Volat( comp.vol + iea)
       xs = Volat( comp.vol + ircossa)
       ys = Volat( comp.vol + irsinsa)
       xe = Volat( comp.vol + ircosea)
       ye = Volat( comp.vol + irsinea)

       if(isinside(180.d0)) then
          org.x = -r
       else
          org.x = min(xs, xe, 0.d0)
       endif
       if(isinside(270.d0) )then
          org.y = -r
       else
          org.y = min(ys, ye, 0.d0)
       endif
       org.z = 0.d0

       if(isinside(0.d0)) then
          abc.x = r - org.x
       else
          abc.x = max(xs, xe, 0.d0) - org.x
       endif

       if(isinside(90.d0)) then
          abc.y = r - org.y
       else
          abc.y = max(ys, ye, 0.d0) - org.y
       endif
       abc.z = h
       NVTX = 0
      end
c     *************************************
      subroutine epatlococyl(comp, loc)
      implicit none
#include "Zep3Vec.h"
#include "Zcnfig.h"

      record /Component/ comp ! input.
      integer loc(4)
 
      integer i

      do i = 1, 4
         loc(i) = i
      enddo
      end

