      subroutine epSetSTblCns(media, cnst)
      implicit none
#include "Zmedia.h"
#include "Zmass.h"

      record /epmedia/media  ! input. 
      record /SmpCnst/ cnst   ! output. must be media.cnst

c   
c   Actual sampling table sizes are fixed here.
c   If they exceed the maximum availabe size, 
c   error will be issued to stop the execution. 
c   
c         Energy above which we can use complete screening 
c       cross-sections. evaluate at Eg/Ee=x= 0.99.
c       30 is marging.  This can be applied to pair creation, too.

      cnst.CompScrE =  !  30.0*( 0.05*0.99/0.01/media.Zeff**0.333)
c     *              150.0/media.Zeff**0.333
     *              150.0/media.Z**0.333
c
      cnst.BrEemaxS  = 100.e-3   ! use Seltzer data at < this E
c      cnst.BremEgmin =  cnst.BrEemaxS*1.e-6  ! Eg min  10 keV
      cnst.BremEgmin =  1.d-5 ! min Eg/Ee  Ee > Seltzer 
                            !      (Ee > Seltzer region=10GeV)
      cnst.BrEgminS = 1.d-4    ! Eg/Ee min for Seltzer case
c
c       For Seltzer data
c   
      cnst.BrEeminS = masele+ 5.0d-6  ! below this, brems is neglected  (Ek=5keV)
      cnst.BrLEeminS = log10(cnst.BrEeminS-masele)  ! this is in K.E
c       Next can be changed from 10 MeV to 1GeV
c       see epCreBrSTblS.f in Util/Elemag where we can
c       switch the table from Seltzer to Partial screening one.
c       Generally, for higher Z material lower energy is better.
c       the glitch is order of 1 % for many cases.



c          table size for Energy; Seltzer region
      cnst.BrTXTS = mxBrTXS
c     *   log10( (cnst.BrEemaxS-masele)/(cnst.BrEeminS-masele))*20
      cnst.BrES = cnst.BrTXTS

      cnst.BrUminSA = 0.1d0
      cnst.BrUmaxSA = 1.0
c      cnst.BrUszSA = 20
      cnst.BrUszSA = 51
      cnst.BrdUSA =
     *    (cnst.BrUmaxSA-cnst.BrUminSA)/
     *      (cnst.BrUszSA-1)


      cnst.BrdETXS = 
     *  log10((cnst.BrEemaxS-masele)/(cnst.BrEeminS-masele))/
     *                (cnst.BrTXTS-1)

      cnst.BrdES =
     *   log10( (cnst.BrEemaxS-masele)/(cnst.BrEeminS-masele))/
     *    ( cnst.BrES-1)

      cnst.BrUszSB = 51
      cnst.BrUminSB = 0.
      cnst.BrUmaxSB = cnst.BrUminSA**0.25d0
      cnst.BrdUSB =
     *   (cnst.BrUmaxSB-cnst.BrUminSB)/
     *     (cnst.BrUszSB-1) 

c
c   +++++++++++++++++++++++++++++++Old version++(before release; 1998.Nov.14)
c   after 2010. March. v.8.82 revived
c            100MeV     CompScrE       EemaxL          BrEe2H
c                        BrScrE
c     <--------|-----------|--------------|---------------|--------->
c     Seltzer    Partial       Comp.Scr     CompScr+LPM    CompScr+LPM
c                Screening     rejection    by Table       by rejection
c                Table 
c
c
c            if CompScrE > EemaxL (say, Pb)
c       
c             100MeV     EemaxL     CompScrE         BrEe2H
c                        BrScrE
c     <--------|-----------|----------|---------------|--------->
c     Seltzer    Partial           CompScr+LPM          CompScr+LPM
c               Screening           by Table            by rejection
c               Table 
c    ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
c
c   3 Sampling tables will be created:

c     Seltzer region   Ee < BrEemaxS                              T
c     Partial screening region Ee <  BrScrE                       T
c     complete screening region   BrScrE  < Ee < EemaxL           R
c     (may not exist)
c     C.S + LPM region            EemaxL  <  Ee<  BrEe2H          T
c
c     BrScrE is determined by min(ComScrE, EemaxL)
c     EemaxL is the energy below which the LPM works 
c     only for Eg/Ee < 10^-5, so that we may neglect the effect.
c
c      combining both, we may judge as follows:
c 
c     Ee < EemaxS    ==> Seltzer table (normally <100 MeV)
c     Ee < ScrE      ==> partial screening  by table
c     Ee < EemaxL    ===> complete sc. only by rejection (may not exits)
c     Ee < Ee2H      ===> complete sc.+ LPM  table
c     Ee > Ee2H      ===> comp. + LPM  by rejection
c===================================================================
c


c           ordinary brems region
c
      cnst.BremEemin = 31.62d-3  !  below this, don't make table for screened
c                                   cross sec. (managed by Seltzer tab)
      cnst.BremLEemin = log10(cnst.BremEemin)
c         LPM effect at small x=Eg/Ee appears at this Ee
c         so that cross section without LPM should not be
c         used above this.
c      cnst.BremEemaxL  = 5 * 11.35/media.rho === old version
c         below this we can use complete screening cross sett
c        
      cnst.BremEemaxL  =  10 * 11.35/media.rho
c
c         If this is < CompScrE, we make this = CompScrE
c         and not apply LPM  below CompScrE.  
c         ( change from v8.82).  (For Pb, this is 10 GeV while
c         CompScrE is 30.  For Fe, 15 vs 50 GeV)
      cnst.BremEemaxL  = max( cnst.BremEemaxL, cnst.CompScrE)
c         we may use screened brems cross-section below BrScrE
c         without LPM correction
      cnst.BrScrE = cnst.CompScrE
c      cnst.BremTXTL = 
c     *   log10(cnst.BrScrE/cnst.BremEemin)*10
      cnst.BremTXTL = mxBrTXL
c     *   log10(cnst.CompScrE/cnst.BremEemin)*10
      cnst.BremEsize = cnst.BremTXTL

      cnst.BremUminLA = 0.1d0
      cnst.BremUmaxLA = 1.0
c      cnst.BremUszLA = 20
      cnst.BremUszLA = 51
      cnst.BremdULA =
     *    (cnst.BremUmaxLA-cnst.BremUminLA)/
     *      (cnst.BremUszLA-1)



      cnst.BremdETXL = 
c     *  log10(cnst.CompScrE/cnst.BremEemin)/
     *  log10(cnst.BrScrE/cnst.BremEemin)/
     *                (cnst.BremTXTL-1)

      cnst.BremdEL =
c     *   log10(cnst.CompScrE/cnst.BremEemin)/
c     *   log10(cnst.BrScrE/cnst.BremEemin)/
     *   log10(cnst.BrScrE/cnst.BremEemin)/
     *    ( cnst.BremEsize-1)

c      cnst.BremUszLB = 21
      cnst.BremUszLB = 51
      cnst.BremUminLB = 0.
      cnst.BremUmaxLB = cnst.BremUminLA**0.25d0
      cnst.BremdULB =
     *   (cnst.BremUmaxLB-cnst.BremUminLB)/
     *     (cnst.BremUszLB-1) 

c      ------------------------------------
      cnst.PairEgmin =  1.023d-3
      cnst.PairNonSc = 8.d-3

      cnst.PairLEgmin = log10(cnst.PairEgmin) 

c         LPM effect  appears at this Eg
c         so that cross section without LPM should not be
c         used above this.
      cnst.PairEgmaxL = 3000.*11.35/media.rho

c         we should use screened pair cross-section below this
c           probably always  CompScrE < PairEgmaxL
      cnst.PrScrE = min(cnst.CompScrE,  cnst.PairEgmaxL)

      cnst.PairTXTL = 
c     *   log10(cnst.PrScrE/cnst.PairEgmin)*10
     * mxPrTXL             
      cnst.PairEsize = cnst.PairTXTL
      cnst.PairUminLA  = 0.05d0
      cnst.PairUmaxLA = 1.
c      cnst.PairUszLA = 21
      cnst.PairUszLA = 51
      cnst.PairdULA = 
     *  (cnst.PairUmaxLA-cnst.PairUminLA)/
     *  (cnst.PairUszLA-1) 

      cnst.PairdETXL =
     *  log10(cnst.PrScrE/cnst.PairEgmin)/
     *   (cnst.PairTXTL-1)

      cnst.PairUminLB = 0.
      cnst.PairUmaxLB =   cnst.PairUminLA**0.25d0
c      cnst.PairUszLB = 21
      cnst.PairUszLB = 51
      cnst.PairdULB =
     * (cnst.PairUmaxLB-cnst.PairUminLB)/
     *   (cnst.PairUszLB-1)

      cnst.PairdELA = 
     * log10(cnst.PrScrE/ cnst.PairEgmin) /
     *  (cnst.PairEsize-1)

      cnst.PairdELB=
     *      sqrt( log10(cnst.PrScrE/cnst.PairEgmin) )
     *     /( cnst.PairEsize-1)

c      --------------------------------------------------

c              LPM region; Brems

      cnst.BrEe1H =  cnst.BremEemaxL 
c      cnst.BrEgminH =max( 1.d-4, cnst.BrEe1H*1.d-5) ! x< 1.d-5 is neglecteda
      cnst.BrEgminH =  cnst.BremEgmin   !  vmin  Eg/Ee  10^-5
      cnst.BrLEe1H = log10( cnst.BrEe1H )
      cnst.BrneH = 51

      cnst.BrdEH = .10d0  ! log E step
c              last 2  means  for 2D table
      cnst.BrneH2 = 51
c      cnst.BrdEH2 = 0.075d0
      cnst.BrdEH2 = 0.05d0
c       cnst.BrdEH= log10(cnst.BrEe2H/cnst.BrEe1H)/(cnst.BrneH-1)
c       inverse of the above;  Pb: thie is 1000TeV, Air at sea level
c       3x10^19eV,   This is used when getting x-sectio
      cnst.BrEe2H =10.d0**( cnst.BrdEH *(cnst.BrneH-1)) *
     * cnst.BrEe1H
c        next is used when sampling energy. could be low
c       if Ee > this, rejection method will work
c       Pb: 3.2TeV; Air sea: 4x10^16eV 
c                   Air 20 km: 4x10^17eV
      cnst.BrEe2H2 =10.d0**( cnst.BrdEH2 *(cnst.BrneH2-1)) *
     * cnst.BrEe1H
c      cnst.BrdU1H= 0.05d0
      cnst.BrdU1H= 0.025d0

      cnst.BrU1H=0.2d0
      cnst.BrU2H=1.0d0
      cnst.Brnu1H=(cnst.BrU2H-cnst.BrU1H+1.d-9)/cnst.BrdU1H+1
c           ....................
c                                 
      cnst.BrPow = 4.0
      cnst.BrU3H = .0
      cnst.BrU4H = cnst.BrU1H**(1.d0/cnst.BrPow)
c      cnst.Brnu2H = 16
      cnst.Brnu2H = 51
      cnst.BrdVU2H = cnst.Brnu2H-1
      cnst.BrdU2H =  (cnst.BrU4H - cnst.BrU3H)/cnst.BrdVU2H


c           LPM region, pair

      cnst.PrEg1H =  cnst.PairEgmaxL 
      cnst.PrLEg1H = log10( cnst.PrEg1H )
c     cnst.PrneH = 25
      cnst.PrneH = 51
      cnst.PrdU1H= 0.025d0
      cnst.PrdEH = .1d0  ! log E step

      cnst.PrU1H=0.
      cnst.PrU2H=1.0
      cnst.Prnu1H=(cnst.PrU2H-cnst.PrU1H+1.d-9)/cnst.PrdU1H+1
      cnst.PrEg2H =10.d0**( cnst.PrdEH *(cnst.PrneH-1)) *  
     * cnst.PrEg1H
c            for muon 
      call epSetmuSTab(media, cnst)
      end
