c      ***************************************************************
c      *                                                             *
c      * Sepics: A  Standard program which uses EPICS
c      *                                                             *
c      ***************************************************************
c
       subroutine sepics(ngen)
       implicit none
       integer ngen  ! output. # of events generated in this run

       integer icon

c             init sepics, epics
       call sopen

c             generate showers until required # or
c             time lack
c          *** until loop*** 
       do while (.true.)
          call s1set(icon)

          if         (icon .ne. 0)
     *                       goto 10
       enddo
 10    continue
c             end of all events or time lacks
       call epeaev
       call sclose(ngen)
       end
c      ****************
       subroutine sopen
       implicit none
c              read control parameters
#include  "ZsepManager.h"
#include  "ZepDirec.h"
#include  "ZepTrackp.h"
#include  "ZepPos.h"
#include  "Zep3Vec.h"
#include  "Zsparm.h"
#include  "Zswk.h"

        character*150 msg
        character*100 cosmosparam
        integer i, klena, n
c
        cosmosparam  = ' '
        read(*, *, end=100) EpicsFile, ConfigFile, SepicsFile, cont,
     *   cosmosparam

        call sparmr(SepicsFile)
c          check DCInp
        if(InputA .eq. 'fix') then
           if(abs( DCInp.x**2 + DCInp.y**2 + DCInp.z**2 - 1.d0)
     *        .gt. 1.d-3) then
              call cerrorMsg('sum of DCInp**2 is far from 1', 0)
           else
c              normalize so
              call epadjdir(DCInp)
           endif
        endif
c
c                   init epics
        if(cosmosparam .ne. ' ') then
           call epicosmos(cosmosparam)
        endif

        call epiaev(EpicsFile, ConfigFile)

        if(Trace .and. Nevent .gt. 20) then
           call cerrorMsg('********* Warning **********',1)
           call cerrorMsg(
     *     'Do you really want to take trace on so many events ?',
     *     1)
           call cerrorMsg(
     *     'If not, make "Trace f" in epicsfile', 1)
        endif
c              incident energy sampling. initializaiton 
c           check primary and outprimary
        if( trim(PrimaryFile) == trim(OutPrimaryFile) ) then
           if( Light == 21 ) then
              write(0, *)  ' PrimaryFile=OutPrimaryFile when'  
              write(0, *) ' Light=', Light
              stop
           endif
        endif
c           PrimaryFile may contain: e.g     ../Input/+primary 
c            or /-filename.   
        call epSeePMfile(PrimaryFile, Inp1ry)

        if(Inp1ry .eq. 0 ) then
           !  primary is ordinary one
           Inpxyz = 0
           Inpdir = 0
           Inperg  = 0
           Inptime = 0
           Inpdisk = 0
           Inpwgt = 0
           Inpwl = 0
           Inppol = 0
           Inpmass =0
           Inpcn = 0
           Inpuser = 0
!           InpLight = 0
           call ciniSPrim(PrimaryFile)
        else
           ! primary  is in +xxx or -xxx file
           call epLightIOreadIni
        endif

c            inquire form
        call epqfrm(formx)
        if(formx .eq. 'cyl') then
           call epqcyl(rcyl)
        elseif(formx .eq. 'pipe' ) then
           call epqpip(rpipi, rpipo)
        endif


        call epqcnf(orgw, abcw)

c        call epqworld(nwld, wstruct) 
c
        if(.not. cont) then
c               to keep first exEcution date: get date & time
c             call kqymd(pdatE0)
c             call kqhms(ptimE0)
        endif
c
c                initialize random no.
ccc          if(cont) then
ccc              call scontr(IoCont)
ccc         else
              if(Ir1(2) .ge. 0) then
                 call rnd1i(Ir1)
              else
                 call cmkSeed(0, Ir1)
                 call rnd1i(Ir1)
              endif
ccc          endif
          return
c         ---------------- Error -----------------
 100      continue
          write(msg, *) 'EpicsFile=',EpicsFile
          call cerrorMsg(msg, 1)
          write(msg, *) 'ConfigFile=', ConfigFile
          call cerrorMsg(msg, 1)
          write(msg, *) ' SepicsFile=',  SepicsFile
          call cerrorMsg(msg, 1)
          write(msg, *) ' cont info=', cont
          call cerrorMsg(msg, 1)
          write(msg,*) ' no control parameters'
          call cerrorMsg(msg, 0)
       end
      

       subroutine ssetip3( aTrack, icon)
       implicit none
#include  "ZsepManager.h"
#include  "ZepTrack.h"
#include  "Zsparm.h"
#include  "Zcode.h"
       record /epTrack/ aTrack
       integer  icon  ! output. 0  -- go ahead.   1-- call  this again to set multiple 1ries
c                      -1--> EOF
       integer  nf, fc
       integer code, subcode, chg 
       real*8 erg, xin, yin, zin, wx, wy, wz, u, norm
       integer maxfn
       integer::totalcn
       parameter (maxfn = 15)
       character*20 field(maxfn)

 10    continue
       buf = ' '
       subcode = 0

      if(Inp1ry < 0 ) then
c     read(Ioprim,  end= 100 )  buf
         read(Ioprim,  end = 100)  code,
     *        subcode, chg, erg,  xin, yin, zin,
     *        wx, wy, wz, 
     *        aTrack.wl, aTrack.p.mass,  aTrack.cn
         if( code == -1000 ) then
                ! read dE of each comp.
            call epLightIOreaddE(totalcn,0)  ! 0 no need to alloc
            icon = 1
            return              !************************
         endif
         aTrack.p.code = code
      else
          read(Ioprim, '(a)', end= 100 )  buf
          call kgetField(buf, field, maxfn, nf)
          if(nf .eq. 0 )  then
             if( Inpmul .eq. 1) then
c                ! read dE   ; head trip ?? not needed
c                call epLightIOreaddE(totalcn, 0)
                icon = 1
                return          !****************
             else
c     neglect blank line          
                goto 10
             endif
          endif
          
          fc = 1
          read(field(fc), *) code
          if(Inpsubcode .eq. 1) then
             fc = fc + 1
             read(field(fc), *)  subcode
          endif
          fc = fc + 1
          read(field(fc), *)  chg
          if(Inperg .gt. 0) then
             fc = fc + 1 
             read(field(fc), *)   erg
          endif
          if( Inpxyz .gt. 0 ) then
             fc = fc + 1
             read( field(fc), *)   xin
             fc = fc + 1
             read( field(fc), *)   yin
             fc = fc + 1
             read( field(fc), *)   zin
          endif

          if( Inpdir .gt. 0 ) then
             fc = fc + 1
             read( field(fc), *)   wx
             fc = fc + 1
             read( field(fc), *)   wy
             fc = fc + 1
             read( field(fc), *)   wz
c              the acuracy of input data may not be enough
             norm = sqrt( wx**2 + wy**2 + wz**2 )
             wx = wx/norm
             wy = wy/norm
             wz = wz/norm
          endif

          if( Inpwgt  >  0 ) then
             fc = fc + 1          
             read( field(fc), *)  aTrack.wgt
          endif

          if( Inpwl  >  0 ) then
             fc = fc + 1          
             read( field(fc), *)  aTrack.wl
          endif
          
          if( Inppol  >  0 ) then
             fc = fc + 1          
             read( field(fc), *)  aTrack.pol
          endif
          
          if(Inpmass > 0 ) then
             fc = fc + 1
             read( field(fc), *)  aTrack.p.mass
          endif

          if( Inpcn  >  0 ) then
             fc = fc + 1          
             read( field(fc), *)  aTrack.cn
          endif

          if( Inptime .gt. 0 ) then
             fc = fc + 1
             read( field(fc), *)   aTrack.t 
             aTrack.t = aTrack.t*29.98d0 ! cm (t is nsec)
          endif

          if( Inpuser .gt. 0 ) then
             fc = fc + 1
             read( field(fc), *)   aTrack.user
          endif

c         check number of field; some redandant field may exist at the last part, so
c         nf many not be equal to fc. but must be nf >= fc
          if(nf .lt.  fc) then
             call cerrorMsg(
     *      'No. of fields in primary data is too few', 1)
             call cerrorMsg('data given is', 1)
             call cerrorMsg(buf, 1)
             stop 9999
          endif
       endif

       if(subcode .eq. 0 .and.  chg .eq. 0) then
          call rndc(u)
          if(code .eq. kkaon) then
             if(u .lt. 0.5) then
                subcode = k0l
             else
                subcode = k0s
             endif
          elseif(code .eq. knuc) then
             if(u .lt. 0.5) then
                subcode = antip
             else
                subcode = regptcl
             endif
          endif
       endif

       call cmkptc( code, subcode, chg, aTrack.p)

       if(Inpxyz .eq. 1) then
          aTrack.pos.x = xin
          aTrack.pos.y = yin
          aTrack.pos.z = zin
c            for safety
          PosInp.x = xin
          PosInp.y = yin
          PosInp.z = zin
       endif
       if(Inpdir .eq. 1) then
          aTrack.w.x = wx
          aTrack.w.y = wy
          aTrack.w.z = wz
c            for safety also set next
          DCInp.x = wx
          DCInp.y = wy
          DCInp.z = wz
       endif

       aTrack.p.fm.p(4)  =  erg
        ! >>>>>>>>>>>>>light
       if( code > 0 .or. code == kchgPath ) then
          if(Inperg .eq. 1) then
             aTrack.p.fm.p(4) =  aTrack.p.fm.p(4) + aTrack.p.mass
          endif
       endif
        !<<<<<<<<<<<<<<<<<<
       icon = 0
       return
 100   icon = -1
       end

       subroutine  s1set(icon)
       implicit none
#include  "ZsepManager.h"
#include  "ZepTrackp.h"
#include  "ZepPos.h"
#include  "ZepDirec.h"
#include  "Zep3Vec.h"
#include  "Zsparm.h"
#include  "Zswk.h"
      integer icon
      character*80 msg

      integer jcon


      if(nevc .ge. Nevent) then
         icon=1
      else
c                 get random no. for this event
         call rnd1s(Ir1st)
         if(LogIr) then
c             record Seed in err out
            write(msg, *) Ir1st, nevc + 1
            call cerrorMsg(msg, 1)
         endif
c                 init 1 event. (clear arrays etc)
         call epi1ev(jcon)



         if(jcon .ne. 0) then
c                    jcon=0-->user set the incident
c                    set incident ptcl(s) by sepics
            call ssetip(icon)
         else
            icon = 0       ! this is needed 2004. May 2
         endif



         if(icon .eq. 0) then
c                  check time using stack area data
            call stimec(icon)
         endif
         if(icon .eq. 0) then
c              time and incident are available  for the generation
c              generate 1 event
            call epgen
c              end of 1 event
            call epe1ev
            call se1ev
         endif
      endif
      end
c     ****************
      subroutine se1ev
      implicit none
c             end of 1 event
#include  "ZepPos.h"
#include  "Zep3Vec.h"
#include  "Zswk.h"
          nevc=nevc+1
       end
c     ***************
       subroutine sqtevn(nev)
       implicit none
#include  "ZepPos.h"
#include  "Zep3Vec.h"
#include  "ZepDirec.h"
#include  "Zsparm.h"
#include  "Zswk.h"

      integer nev, icon

c           inquire total # of events created
          nev=nevc
          return
c      *****************
       entry sqcont(icon)
          if(cont) then
             icon=1
          else
             icon=0
          endif
       end
      subroutine ssetip( icon )
      implicit none
#include  "ZsepManager.h"
#include  "ZepTrackp.h"
      integer icon  !  output.  0
      integer eventn
      icon = 0
      
      if( Light == 22 ) then
            ! must read primary and 1st col info.
         call epLightIOread1stCol(eventn,icon)
         if(icon /= 0 ) return
      endif

      if( Inpmul .eq. 1) then
c            multiple particles are incident; icon = 1--> end of a bunch
         do while ( icon .eq. 0 )
            call ssetip2( icon )
         enddo
         if(icon .eq. 1) icon = 0
      else
         call ssetip2( icon )
      endif
      end

      subroutine ssetip2( icon )
      implicit none
#include  "Zcode.h"
#include  "ZsepManager.h"
#include  "ZepTrackp.h"
#include  "ZepTrack.h"
#include  "Zep3Vec.h"
#include  "Zswk.h"
#include  "Zsparm.h"
#include  "Zglobalc.h"
      
      record /epTrack/ aTrack
      record /epTrack/InciTrack, bTrack
      integer ns, i, j, icon
      logical ok
      real*8 sume, theta, phi, r
      record /epPos/ org, rxyz
      record /epDirec/ norm
      character*40 msg
      real(8):: wl0 


c             set incident ptcl
c               fix energy (momentum yet)
      if(Inp1ry .eq. 0 ) then
         call sfixe(aTrack)
         if( aTrack.p.code == klight ) then
            call epLightE2wl(aTrack.p.fm.p(4), 1.d0, wl0, wl0)
            aTrack.wl = wl0
         endif
         icon = 0
      else
         call ssetip3(aTrack, icon)

         if(icon .ne. 0) return ! ************ EOF or end of 1 bunch of incidents
      endif

c               fix position
      ok = .false.


c      do while (.not. ok)
         if(Inpxyz .eq. 0) then
            call sfixp(aTrack)
         endif
c               fix angle
         if(Inpdir .eq. 0) then
            call sfixa(aTrack)
         endif

         if(Inpxyz .eq. 0.) then
            if(InputP .eq. 'fix') then
               aTrack.pos=PosInp
               aTrack.w.x = DCInp.x
               aTrack.w.y = DCInp.y
               aTrack.w.z = DCInp.z
            elseif(InputP .eq. 'usph' .or. InputP .eq. 'g->sph'
     *           .or. InputP .eq. 'u->sph' ) then
c                normal vector is the particle position to the center
               call epqwcoord(org, rxyz)
               norm.x =-( aTrack.pos.x - org.x )
               norm.y =-( aTrack.pos.y - org.y )
               norm.z =-( aTrack.pos.z - org.z )
               call epadjdir(norm)
c                  convert direction cos to world coord.
               call ctransVectZ(norm, DCInp, aTrack.w)
            elseif(InputP(2:3) .eq. '+z') then
               aTrack.w.x = DCInp.x
               aTrack.w.y = DCInp.y
               aTrack.w.z = DCInp.z
            elseif(InputP(2:3) .eq. '-z') then
               aTrack.w.x = DCInp.x
               aTrack.w.y = DCInp.y
               aTrack.w.z = -DCInp.z
            elseif(InputP(2:3) .eq. '+y') then              
               aTrack.w.x = DCInp.x
               aTrack.w.y = DCInp.z
               aTrack.w.z = DCInp.y
            elseif(InputP(2:3) .eq. '-y') then              
               aTrack.w.x = DCInp.x
               aTrack.w.y = -DCInp.z
               aTrack.w.z = DCInp.y
            elseif(InputP(2:3) .eq. '+x') then              
               aTrack.w.x = DCInp.z
               aTrack.w.y = DCInp.x
               aTrack.w.z = DCInp.y
            elseif(InputP(2:3) .eq. '-x') then              
               aTrack.w.x = -DCInp.z
               aTrack.w.y = DCInp.x
               aTrack.w.z = DCInp.y
            elseif(InputP .eq. 'g->sph2'
     *        .or. InputP .eq. 'u->sph2' ) then
c
c              DCInp gives teta and phi .  opening angle is 90 deg
               call epqwcoord(org, rxyz)
                            ! rxyz.x= should be the radius of the sphere
               r = rxyz.x -EpsLeng
               theta = acos(-DCInp.z)*Todeg
               phi = atan2(-DCInp.y, -DCInp.x)*Todeg
               if(InputP .eq. 'g->sph2') then
                  call epgonSphere(1, Hwhm, r, 
     *              theta, phi, 90.0d0, aTrack.pos)
               else
                  call epgonSphere(1, -1.0d0, r, 
     *              theta, phi, 90.0d0, aTrack.pos)
               endif
               aTrack.pos.x = aTrack.pos.x + org.x
               aTrack.pos.y = aTrack.pos.y + org.y
               aTrack.pos.z = aTrack.pos.z + org.z
               aTrack.w = DCInp
            else
               write(msg,*)' InputP=',InputP, ' and ',
     *             InputA,' incompatible'
               call cerrorMsg(msg, 0)
            endif
         endif
c      enddo
c               fix others

      call sfixo(aTrack)

c               set them
c      if(Inpdisk .eq. 0) then
       !>>>>>>>>>>>>>light
      if( Inpcn > 0 ) then
         ! if Cn is given, the coordinate is assumed to be local
         ! so that eppush is ok
         call eppush(aTrack)
      else
         call epputTrack(aTrack)
      endif
       !<<<<<<<<<<<<<<
c      else
c         call epputTrk2(Inpdisk, aTrack)   ! not used now v9.00
c      endif
      InciTrack = aTrack
      return
c      *****************
       entry stimec(icon)
c      *****************
c         icon=0---> time available;  currently no check
           icon = 0
       return
c      ***************
       entry epqInci(bTrack)
       bTrack = InciTrack
       end
       subroutine sclose(nev)
       implicit none
#include  "ZepManager.h"
#include  "ZsepManager.h"
#include  "ZepPos.h"
#include  "ZepDirec.h"
#include  "Zep3Vec.h"
#include  "Zsparm.h"
#include  "Zswk.h"

      integer nev
      character*150 msg

c               end of all events
cc          call scontw(IoCont)
cc          call timepc(6)
c              inquire # of events created in this run
          call epqevn(nev)  
c              print message
c             get  current random no.
          call rnd1s(Ir1)
          write(msg,*) ' # created in this run=',nev,
     *     ' current total #=',nevc,
     *     ' destination #=',Nevent,
     *     ' next ir=', Ir1
          if(MsgLevel -1 .ge. 0) then
             call cerrorMsg(msg, 1)
          endif
          call epcloseStackDisk  ! delete stack disk if used
       end
      subroutine sfixe(aTrack)
       implicit none
#include  "ZsepManager.h"

#include  "ZepTrack.h"
#include  "ZepTrackp.h"
#include  "Zep3Vec.h"
#include  "Zcnfig.h"
#include  "Zswk.h"
#include  "Zsparm.h"
#if defined NEXT486
#define IMAG_P dimag
#elif defined PCLinux 
#define IMAG_P dimag
#else
#define IMAG_P imag
#endif


       record /epTrack/ aTrack
       real*8 u, r,   dx, dy, cs, sn
       real*8 st, pw
       record /epPos/ org, rxyz
       logical ok
       character*70 msg
ccc       real*8 fai


c           sample incident particle
       
       call epsampPtcl(aTrack.p)
       return
c      *******************
       entry sfixp(aTrack)
c      *******************
c          sample incident x,y,z position;  world coord.
       if(InputP .eq. 'fix') then
#if defined IBMAIX
          call epsubpos(PosInp, aTrack.pos)
#else
          aTrack.pos = PosInp
#endif
       elseif( (InputP(1:2) .eq. 'u-' .and. InputP(1:3) .ne. 'u->')
     *       .or.   InputP(1:2) .eq. 'u+' ) then
c            uniform in Xrange, Yrange,  Zrange        
          call rndc(u)
          aTrack.pos.x
     *        = ( IMAG_P(Xrange) - real(Xrange) )* u
     *          + real(Xrange)
          call rndc(u)          
          aTrack.pos.y
     *        = ( IMAG_P(Yrange) - real(Yrange) )* u
     *          + real(Yrange)
          call rndc(u)           
          aTrack.pos.z
     *        = ( IMAG_P(Zrange) - real(Zrange) )* u
     *          + real(Zrange)

       elseif(InputP .eq. 'usph') then
          call epqwcoord(org, rxyz)
                         ! rxyz.x= should be the radius of the sphere
          r = rxyz.x -EpsLeng
c                                  teta       phi      o.a
          call epuonSphere(1, r, PosInp.x, PosInp.y, PosInp.z,
     *       aTrack.pos)
          aTrack.pos.x = aTrack.pos.x + org.x
          aTrack.pos.y = aTrack.pos.y + org.y
          aTrack.pos.z = aTrack.pos.z + org.z
c            angle is later fixed.
       elseif(InputP .eq. 'g->sph') then
c
c           PosInp.x = teta, PosInp.y = phi, PosInp.z = opening angl
c           Instead of ProfR,  R * sin(O.A) is used.
c     
          if(PosInp.z .gt. 90.) then
             call cerrorMsg("Zinp > 90 for InputP=g->sph", 0)
          endif
          call epqwcoord(org, rxyz)
                            ! rxyz.x= should be the radius of the sphere
          r = rxyz.x -EpsLeng

          call epgonSphere(1, Hwhm, r, PosInp.x, PosInp.y, PosInp.z,
     *       aTrack.pos)

          aTrack.pos.x = aTrack.pos.x + org.x
          aTrack.pos.y = aTrack.pos.y + org.y
          aTrack.pos.z = aTrack.pos.z + org.z
c            angle is later fixed.
       elseif(InputP .eq. 'g->sph2') then
c               this case you  InpDir!=0 or DCInp must be given
c               wait until angle is given                   
       elseif(InputP .eq. 'u->sph') then
          if(PosInp.z .gt. 90.) then
             call cerrorMsg("Zinp > 90 for InputP=u->sph", 0)
          endif
          call epqwcoord(org, rxyz)
                            ! rxyz.x= should be the radius of the sphere
          r = rxyz.x -EpsLeng
c            For  negative HWHM, uniform distribution is employed
          call epgonSphere(1, -1.0d0, r, PosInp.x, PosInp.y, PosInp.z,
     *       aTrack.pos)

          aTrack.pos.x = aTrack.pos.x + org.x
          aTrack.pos.y = aTrack.pos.y + org.y
          aTrack.pos.z = aTrack.pos.z + org.z
c            angle is later fixed.
c  
       elseif( InputP .eq. 'u->sph2') then
c               this case  InpDir!=0 or DCInp must be given
c               wait until angle is given                   
c  
       elseif(InputP(1:1) .eq. 'g') then
c                  gaussian density beam
          call epGaussb(Hwhm, ProfR, dx, dy)
          if(InputP(3:3) .eq.  'z') then
c                 around Xinp, Yinp
             aTrack.pos.x = PosInp.x + dx
             aTrack.pos.y = PosInp.y + dy
             aTrack.pos.z = PosInp.z
          elseif(InputP(3:3) .eq. 'y') then
             aTrack.pos.x = PosInp.x + dx
             aTrack.pos.y = PosInp.y
             aTrack.pos.z = PosInp.z + dy
          elseif(InputP(3:3) .eq. 'x') then
             aTrack.pos.x = PosInp.x
             aTrack.pos.y = PosInp.y + dx
             aTrack.pos.z = PosInp.z + dy
          else
             write(msg,*) ' InputP=',InputP, ' invalid'
             call cerrorMsg(msg,  1)
             call cerrorMsg("see sepicsfile in FirstKiss",0)
          endif
       else
          write(msg,*) ' InputP=',InputP, ' invalid'
          call cerrorMsg(msg,  1)
          call cerrorMsg("see sepicsfile in FirstKiss",0)
       endif
       return
c       ****************************************
        entry sfixa(aTrack)
c          DCInp is fixed. aTrack.w is not yet  given
        if(InputA .eq. 'fix' ) then
c          nothing to do; DCInp is used.
        else
           if(InputA .eq. 'is') then
              call rndc(u)
              DCInp.z= ( IMAG_P(CosNormal) - real(CosNormal) )* u
     *          + real(CosNormal)
           elseif(InputA(1:3) .eq. 'cos') then
              read(InputA(4:12), *) pw
              call rndc(u)
              if(pw .ne. -1.d0) then
                 DCInp.z=
     *             ( (IMAG_P(CosNormal)**(pw+1.d0) - 
     *             real(CosNormal)**(pw+1.d0))* u
     *             + real(CosNormal)**(pw+1.d0))**(1.d0/(pw+1.d0))
              else
                 DCInp.z =(IMAG_P(CosNormal)/real(CosNormal))**u *
     *             real(CosNormal)
              endif
           else
              write(msg,*) ' InputA=',InputA, ' not supported'
              call cerrorMsg(msg, 0)
           endif
c
ccc           call rndc(fai)
c           fai= (fai+1.)*3.14159265 
c           cs = cos(fai)
ccc           sn = sin(fai)
c
           call kcossn(cs,sn)
           st= sqrt( 1.d0 - DCInp.z**2)
           DCInp.x = st * cs
           DCInp.y = st * sn
        endif
        return
c        ***************************
        entry sfixo(aTrack)
c              fix time of incidence
        if( Inptime .eq. 0 ) then
           aTrack.t = 0.d0
        endif
c           fix momentum 
        call epe2p(aTrack)  ! direction & e--> px,py,pz
       end
c           for ibm
       subroutine epsubpos(inp, out)
       implicit none
#include "ZepPos.h"
       record /epPos/ inp, out
       out =inp
       end
      
c      *********************
       subroutine scontw(io)
       implicit none
#include  "ZsepManager.h"
#include  "ZepPos.h"
#include  "ZepDirec.h"
#include  "Zep3Vec.h"
#include  "Zsparm.h"
#include  "Zswk.h"
      integer io

      character*2 qmk1/" '"/, qmk2/"',"/

c
               write(io, *) nevc, Ir1st,
     *         qmk1,pdatE0,qmk2, qmk1, ptimE0,qmk2
               call sparmw(io)
               return
c
c      ******************
       entry scontr(io)
               read(io, *, end=100) nevc, Ir1, pdatE0,
     *               ptimE0
               call rnd1r(Ir1)
               rewind io
               return
  100      continue
           stop 'no cont information'
       end
