      real*8 function epPair(Egme,  x)
      implicit none
#include "Zglobalc.h"
#include "ZbasicCnst.h"
#include "Zbpfunc.h"
c         This is by Nelson et al. No brems func included

c          compute differentical pair creation cross-section
c          at low energies where no LPM effect exists.
c        Before calling this, epBPZpart must have been called
c        to give the Z
c        epPair =  dsigma/dx   in mb
c
      real*8 Egme ! input  Eg
      real*8 x    ! input  Ee/Eg.   me/Eg =< x <= 1.-me/Eg
      
      real*8 phi1, phi2, fz, gzai
      real*8 epPairLowE

      if(Egme .ge. NonScEme) then
         delta = 136./(x*(1.-x))/Egme/Z13
         if(delta .lt. 1.) then
            phi1 = (0.625*delta - 3.242)*delta + 20.867
            phi2 = (-0.086*delta -1.930)*delta + 20.209
         else
            phi1 = 21.12 - 4.184*log(delta + 0.952)
            phi2 = phi1
         endif
c
         if(Egme .lt. 25.0) then         
c         if(Egme .lt. 97.8) then         ! nelson original
c              Eg < 0.05 GeV
            fz = lnZ83
c///////////
c         else
c            fz = lnZ83 + 8*cf
c         endif
         elseif( Egme .lt. 150) then
            fz = lnZ83 + 8*cf* ((Egme-25.0)/(150.0-25.0))**0.5
         else
            fz = lnZ83 + 8*cf
         endif
c///////////////
         
         gzai = log(1440./Z23)/ (log(183./Z13)-cf)

         epPair = Z*(Z+gzai)*
     *        (  (x**2 + (1-x)**2)* (phi1 - fz/2)  
     *        +
     *        2.d0/3.d0 * x*(1-x)*(phi2 -fz/2)
     *        )
c            alpha *r0**2 epPair
         epPair =max( ar02 * epPair, 0.d0) ! in mb
      else
      
c           B.H's original formulat down to threshold
         epPair = epPairLowE(Egme, x)
         epPair = epPair * BHnorm * Z**2 * ar02
      endif
      end
c     ***********************************
      real*8 function epBrem(Eeme, x)
      real*8 Eeme
      real*8 x
c        this is dummy;
      epBrem = 0.
      call cerrorMsg(
     * 'epBrem not avail in Nelson pair formula', 0)
      end
c     ***************************
      subroutine epBPZpart(media, zin)
      implicit none
#include "Zglobalc.h"
#include "ZbasicCnst.h"
#include "Zmedia.h"
#include "Zbpfunc.h"
#include "Zmass.h"

c        compute Z  part of the pair and brems diff. 
c        corss-section (single Atom)
      record /epmedia/media
      real*8 zin

c
c       The computed results are put in the common block
c       /bpzpart/

      real*8 zd, xnorm, temp
      real*8 epPair, epPairLowE

      real*8 sz, epCoulombC
      data xnorm/0.5/

      NonScEme = media.cnst.PairNonSc/masele  ! non screening region
      BHnorm = 1.
      Z =  zin
      zd = Z
      
      Z13 = zd**(1.d0/3.d0)
      Z23 = Z13**2

c        Coulomb correction fucntion
      sz =( Z/137.d0 ) **2
      cf = epCoulombC(sz)

      lnZ43 = log(zd)*4.d0/3.d0
      lnZ83 = 2* lnZ43
      temp = epPair(NonScEme, xnorm)/
     *    (  epPairLowE(NonScEme, xnorm) * Z**2 * ar02 )
      BHnorm = temp 
      end



