c    This is to manage a new non-default  volume/shape which is not
c    included in Epics.

      subroutine epbNew(comp,  posl, dirl, length, icon)
      implicit none
#include "ZepPos.h"
#include "ZepDirec.h"
#include "Zep3Vec.h"
#include "Zcnfig.h"
      record /Component/comp  ! input. given component
      record /epPos/ posl  ! input. position given in local coord.
      record /epDirec/ dirl ! input. direction cos. given in
                            !   local  coordinate
      real*8  length  ! output. minimum length to the boundary of 'comp'
c                          from posl with dirl
      integer icon    ! output.
c                       0-->length obtained. pos  is  inside 
c                       1-->length obtained. pos  is  outside
c                      -1-->not cross 

c           compute the minimum length to the boundary
      if(comp.struc(1:8) .eq. 'cap') then
         call epbcap(comp, posl, dirl,  length, icon)
      elseif(comp.struc(1:8) .eq. 'ellips') then
         call epbellips(comp, posl, dirl, length, icon)
      elseif(comp.struc(1:8) .eq. 'angle') then
         call epbangle(comp, posl, dirl, length, icon)
c---  elseif(comp.struc(1:8) .eq. '%2') then
c---     call epb%2(comp, posl, dirl,  length, icon)
      else
         call cerrorMsg(comp.struc(1:8), 1)
         call cerrorMsg(' is not supported: epbNew. Maybe', 1)
         call cerrorMsg(
     *   " You haven't done mkNewVolume 'your-config-file'", 0)
      endif

      end
c     ***********************************
      subroutine epsNew(comp, pos, icon)
      implicit none
#include "Zep3Vec.h"
#include "Zcnfig.h"
#include "ZepPos.h"
c             see if pos is inside the comp component

      record /Component/  comp
      record /epPos/pos  ! input. given point
      integer icon  !   output.  0-->inside. 1-->outside

      if(comp.struc(1:8) .eq. 'cap')  then
         call epscap(comp, pos, icon)
      elseif(comp.struc(1:8) .eq. 'ellips') then
         call epsellips(comp, pos, icon)
      elseif(comp.struc(1:8) .eq. 'angle') then
         call epsangle(comp, pos, icon)
c---  elseif(comp.struc(1:8) .eq. '%2')  then
c---     call eps%2(comp, pos, icon)
      else
         call cerrorMsg(comp.struc(1:8), 1)
         call cerrorMsg(' is not supported: epsNew', 0)
      endif
         
      end
c     ***********************************
      subroutine eprNew(comp, shape)
      implicit none
#include "Zep3Vec.h"
#include "Zcnfig.h"
      
      record /Component/ comp  ! input/output. where config data is put

      character*(*)  shape     ! input.  config data has this shape
c            read configuration data 

      if(shape(1:8)  .eq. 'cap') then
         call eprcap(comp)
      elseif(shape(1:8) .eq. 'ellips') then
         call eprellips(comp)
      elseif(shape(1:8) .eq. 'angle') then
         call eprangle(comp)
c---  elseif(shape(1:8)  .eq. '%2') then
c---     call epr%2(comp)
      else
         call cerrorMsg(shape(1:8), 1)
         call cerrorMsg(' is not supported: eprNew ', 0)
      endif

      end
c     ***********************************
      subroutine epenvlpNew(comp,  orig, abc)
      implicit none
#include "Zep3Vec.h"
#include "Zcnfig.h"
#include "ZepPos.h"

c         returns  box parameters which envelopes the
c         given component comp. (local cordinate).
c         
      record /Component/ comp  ! input. given component
      record /epPos/ orig      ! output. origin
      record /ep3Vec/ abc      ! output. a,b,c of the box.

      if(comp.struc(1:8) .eq. 'cap') then
         call epenvlpcap(comp, orig, abc)
      elseif(comp.struc(1:8) .eq. 'ellips') then
         call epenvlpellips(comp, orig, abc)
      elseif(comp.struc(1:8) .eq. 'angle') then
         call epenvlpangle(comp, orig, abc)
c---  elseif(comp.struc(1:8) .eq. '%2') then
c---     call epenvlp%2(comp, orig, abc)
      else
         call cerrorMsg(comp.struc(1:8), 1)
         call cerrorMsg(' is not supported: epenvlpNew', 0)
      endif
      end
c     ***********************************
      subroutine epatlocNew(comp, loc)
      implicit none
#include "Zep3Vec.h"
#include "Zcnfig.h"
c
c         
      record /Component/ comp  ! input. given component
      integer loc(*)     !  output. loc(i) is the location of the 
                         !  attribute given in the i-th position in
                         !  the config file. It's value is in 
                         !  Volat( comp.vol + loc(i)).
                         !  loc size must be >= comp.Nattributes
      if(comp.struc(1:8) .eq. 'cap') then
         call epatloccap(comp, loc)
      elseif(comp.struc(1:8) .eq. 'ellips') then
         call epatlocellips(comp, loc)
      elseif(comp.struc(1:8) .eq. 'angle') then
         call epatlocangle(comp, loc)
c---  elseif(comp.struc(1:8) .eq. '%2') then
c---     call epatloc%2(comp, loc)
      else
         call cerrorMsg(comp.struc(1:8), 1)
         call cerrorMsg(' is not supported: epatlocNew', 0)
      endif
      end

