c     ****************************************************************
c     *                                                              *
c     * epdedxNone: gives -de/dx  (gev/(g/cm2)) of non e+/e-
c     *                                                              *
c
c
c
      subroutine epdedxNone(media, aPtcl, dedt)
      implicit none
#include "Zmedia.h"
#include "Zcode.h"
#include "Zptcl.h"
#include "Zmass.h"
      real*8 emass, emass2 
      include "ZdEdxSpec.h"
c       MeV unit electron mass.
      parameter(emass = masele*1000., emass2=emass**2)

      record /epmedia/media         ! input. 
      record /ptcl/aPtcl        ! input. a particle

      real*8 dedt               ! output. Energy loss rate.   GeV / (g/cm2). 

 
      real*8  E,  mass,  Beta2, x, full, restricted, temp
      real*8  wm, wlg, u, delta, atomicEbrem, atomicEbremCut
      real*8 bbbeta2, lindbeta2, truebeta2
      real*8 bbbeta, lindbeta 
      real*8 logbbbeta, loglindbeta
      real*8 a, b, c, xx, gra, gb2, g, integ
      parameter (bbbeta = 0.1d0,  lindbeta = 0.005d0, gra=5.d0/3.d0)
      parameter (bbbeta2 = bbbeta**2, lindbeta2=lindbeta**2)
      parameter (logbbbeta =-2.302585093E+00,
c     *           loglindbeta =-4.605170186E+00)
     *           loglindbeta =-5.298317367E+00)
      parameter (a = (1.+gra)/2.d0/(logbbbeta-loglindbeta),
     *           b = 2*a*loglindbeta + 1.) 

c
c               energy in MeV unit
      E = aPtcl.fm.p(4)*1000.
      mass= aPtcl.mass*1000.
      g = E/mass
      truebeta2 = 1. -(1.0d0/g)**2
      if(truebeta2 .lt. bbbeta2) then
c            fix at beta=0.1
         Beta2 = bbbeta2
         E = mass*(1. + Beta2/2)
         g = E/mass
      else
         Beta2 = truebeta2
      endif
c     
      gb2 = Beta2 * g**2   !  g^2 b^2

c          x=log10(p/mc)  = log10(g*beta)
      x=log10( gb2 ) / 2


c             max kinetic energy of knock-on
      wm = 2* emass * gb2
     *     /(1.0 + 2.0*g*(emass/mass) +(emass/mass)**2)
      Tupper = wm/1000.         !  in GeV; used in Urban
c        wm in unit of Me
      u = wm/emass 
c          first compute full average dE/dx
c           sh.a/Beta2( sh.b +ln(2*g^2b^2wm/m) -2Beta^2 -delta
c                 +spin_term )
c 
      full = media.sh.b +  log(2*u*gb2) -2.0*Beta2 
      atomicEbrem = 0.
c            assume spin 0 particle is only pi, K
      if(aPtcl.code .ne. kpion .and. aPtcl.code .ne. kkaon) then
c          spin 1/2 term; (almost negligible)
         full = full +  (wm/E)**2/4.
         if(aPtcl.code .eq. kmuon .and. E .gt. 5000. ) then
c            atomic electron brems term.  at 5GeV, ~0.4 % 100GeV 2%
c            so we neglect below 5GeV
c               sh.a*alpha/(2pi) (log(2g)-1/3 log(2u)log^2(2u)
c                assuming sh.a/Beta2 = sh.a at E>5GeV
c                compute effect without sh.a and add later to full
            temp = log(2*u)
            atomicEbrem = 
     *       0.00116*(log(2*g)-0.3333*temp)*temp*temp
         endif
      endif
c             see if restricted energy is requested
      atomicEbremCut = 0.
      if(wm .gt. media.sh.w0) then
c             yes. requested
c                subtract average loss rate from  Ek>w0 region
c                loss for Ek>w0
         integ = log(wm/media.sh.w0) - Beta2*(1.0-media.sh.w0/wm)
c            assume spin 0 particle is only pi, K
         if(aPtcl.code .ne. kpion .and. aPtcl.code .ne. kkaon) then
c               mu, p, etc. spin = 1/2
            integ = integ + ((wm/E)**2-(media.sh.w0/E)**2)/4.
            if(aPtcl.code .eq. kmuon  .and. E .gt. 5000. ) then
c                 Integ(0~wm) =Integ(0~w0) + Integ(w0~wm)
c             so  Integ(w0~wm) = Ineg(0~wm)-Integ(0~w0)
               temp = log(2*media.sh.w0/emass)
               atomicEbremCut = atomicEbrem-
     *          0.00116*(log(2*g)-0.3333*temp)*temp*temp
            endif               
         endif
      else
         integ = 0.
      endif
      call epdEdxDenC(media, g, delta)
      full = full -delta + atomicEbrem
      restricted = full - integ  - atomicEbremCut

      dedt = media.sh.a/Beta2*restricted  


      if(truebeta2 .lt. bbbeta2) then
         c = log(dedt) + ( a* logbbbeta - b )*logbbbeta
         if( truebeta2 .gt.  lindbeta2) then
            xx = log( truebeta2 )/2.
            dedt =exp( (-a*xx + b)*xx + c)
         else
            dedt = exp( (-a*loglindbeta + b)* loglindbeta + c) *
     *             sqrt(truebeta2)/lindbeta
         endif
      endif
c         x  Z**2 and to GeV unit
      dedt=dedt * aPtcl.charge**2 * 1.d-3
c///////////////
c      write(22,*) sngl( aPtcl.fm.p(4)  - aPtcl.mass), sngl(dedt),
c     *            sngl(sqrt(truebeta2))
c///////////////
      end
c     *********************
c        For the organic scintillator, the energy loss by
c      heavy particles or slow particles is not converted to
c      photons  as efficiently as the one by relativistic electrons.
c      This subroutine gives a correction factor for the energy loss,
c      so that you can get effective energy loss by multiplying
c      cf by the true energy loss.
      subroutine epOrgCorrec(media, aPtcl, dedx, cf)
      implicit none
#include "Zmedia.h"
#include "Zptcl.h"
#include "Zmass.h"

      record /epmedia/ media  ! input.
      record /ptcl/ aPtcl   ! input.
      real*8  dedx   ! input.  dE/dx (GeV/(g/cm^2) for the partcle
      real*8  cf     ! output. correction factor. dE_eff = cf x dE_true

      real*8 c1
      c1 = media.BirksC1
c      if( abs( aPtcl.charge ) .gt. 1)  then
c        c1 = c1 * media.BirksCC
c      endif
c      cf = 1./(1. + c1 * dedx + media.BirksC2 * dedx**2)
c        at present, we don't use above two factors
c 
      cf = 1./(1. + c1 * dedx)
      end
      subroutine epGetQuenchCf(dedx, Bircs, cf)
      implicit none
      real*8  dedx  ! input.  dE/dx (GeV/(g/cm^2) for the partcle
      real*8  Bircs(3) !  input. Bircs correction factor
      real*8  cf      ! output. correction factor. dE_eff = cf x dE_true

c      if( abs( aPtcl.charge ) .gt. 1)  then
c        c1 = c1 * media.BirksCC
c      endif
c      cf = 1./(1. + c1 * dedx + media.BirksC2 * dedx**2)
c        at present, we don't use above two factors
c 
      real*8 cc,c1, c2
      c1 = Bircs(2)
c      if( Bircs(1) .gt. 0.  .and. Bircs(1) .ne. 1.) then
c         c1 = c1 * Bircs(1)      
c      endif
c     cf = 1./(1. + c1 * dedx + Birks(3) * dedx**2)
      cf = 1./(1. + c1 * dedx)
      end

