       subroutine epprmr(dsn)
       implicit none
#include  "ZepTrackp.h"
#include  "ZepManager.h"
c
c             read epics file
c
            character*(*) dsn
            integer io,  icon, klena, i
            character*190 msg
            logical epgetParmN
            character*24 vname
            character*100 vvalue
            integer mediadirc
            
            mediadirc = 0 

            call copenf(iowk, dsn, icon)
            if(icon .ne. 0) then
               call cerrorMsg(dsn, 0)
               call cerrorMsg('above file not exits', 1)
            endif

c            read baisc parameters; find separater
            call afsep(iowk)
            do while( epgetParmN(iowk, vname, vvalue ) )
               if(vname .eq. 'AngleB') then
                  call arprml(vvalue, AngleB)
               elseif( vname .eq. 'DtMax' ) then
                  call arprmr(vvalue, DtMax)
               elseif( vname .eq. 'Eabsorb') then
                  call arprmi(vvalue,  Eabsorb)
               elseif( vname .eq. 'Eanihi' ) then
                  call arprmr(vvalue,  Eanihi)
               elseif( vname .eq. 'Ecut') then
                  call arprmr(vvalue, Ecut)
               elseif( vname .eq. 'EdepDedx' ) then
                  call arprml(vvalue, EdepdEdx)
               elseif( vname .eq. 'ElowerBndPair') then
                  call arprmr( vvalue, ElowerBndPair)
               elseif( vname .eq. 'EminElec' ) then
                  call arprmr(vvalue, EminElec)
               elseif( vname .eq. 'EminGamma') then
                  call arprmr(vvalue, EminGamma)
               elseif( vname .eq. 'Es' ) then
                  call arprmr(vvalue, Escat)
               elseif( vname .eq. 'EupperBndCS ') then
                  call arprmr(vvalue, EupperBndCS)
               elseif( vname .eq. 'IncGp') then
                  call arprmi(vvalue, IncGp)
               elseif( vname .eq. 'IoTrace') then
                  call arprmi(vvalue, IoTrace)
               elseif( vname .eq. 'Knckon' ) then
                  call arprml(vvalue, Knckon)
               elseif( vname .eq. 'Molier' ) then
                  call arprml(vvalue, Moliere)
               elseif( vname .eq. 'Photo') then
                  call arprml(vvalue, Photo)
               elseif( vname .eq. 'RecoilKeMin') then
                  call arprmr(vvalue, RecoilKEmin)
               elseif( vname .eq. 'Tcoef' ) then
                  call arprmr(vvalue, Tcoef)
               elseif( vname .eq. 'Tmin') then
                  call arprmr(vvalue, Tmin)
               elseif( vname .eq. 'Trace') then
                  if(.not. Trace) then
                     call arprml(vvalue, Trace)
                  endif
               elseif( vname .eq. 'TimeStruc') then
                  call arprml(vvalue, TimeStruc)
               elseif( vname .eq. 'MagField' ) then
                  call arprmi(vvalue, MagField)
               elseif( vname .eq. 'Bxu' ) then
                  call arprmr(vvalue, Bxu)
               elseif( vname .eq. 'Byu' ) then
                  call arprmr(vvalue, Byu)
               elseif( vname .eq. 'Bzu' ) then
                  call arprmr(vvalue, Bzu)
               elseif( vname .eq. 'ElecField') then
                  call arprmi(vvalue, ElecField)
               elseif( vname .eq. 'Exu') then
                  call arprmr(vvalue, Exu)
               elseif( vname .eq. 'Eyu') then
                  call arprmr(vvalue, Eyu)
               elseif( vname .eq. 'Ezu') then
                  call arprmr(vvalue, Ezu)
               elseif( vname .eq. 'FreeC' ) then
                  call arprml(vvalue, FreeC)
               elseif( vname .eq. 'EpsLeng') then
                  call arprmr(vvalue, EpsLeng)
               elseif( vname .eq. 'ALateCor') then
                  call arprmi(vvalue,ALateCor)
               elseif( vname .eq. 'Sync' ) then
                  call arprmi(vvalue, Sync)
               elseif( vname .eq. 'SyncLoop') then
                  call arprmr(vvalue, SyncLoop)
               elseif( vname .eq. 'MagPair' ) then
                  call arprmi(vvalue, MagPair)
               elseif( vname .eq. 'MuNI') then
                  call arprmi(vvalue, MuNI)
               elseif( vname .eq. 'MuBr') then
                  call arprmi(vvalue, MuBr)
               elseif( vname .eq. 'MuPr') then
                  call arprmi(vvalue, MuPr)
               elseif( vname .eq. 'KEmin' ) then
                  call arprmr(vvalue, KEmin)
               elseif( vname .eq. 'MsgLevel') then
                  call arprmi(vvalue, MsgLevel)
               elseif( vname .eq. 'MediaDir' ) then
                  mediadirc = mediadirc + 1
                  if(mediadirc .gt. MaxMediaDir) then
                     write(0,*) ' too many MediaDir'
                     stop 9789
                  endif
                  call arprmc(vvalue, MediaDir(mediadirc))
               elseif( vname .eq. 'TraceDir') then
                  call  arprmc(vvalue, TraceDir)
               elseif( vname .eq. 'Excom1' ) then
                  call arprmr(vvalue, Excom1) 
               elseif( vname .eq. 'Excom2' ) then
                  call arprmr(vvalue, Excom2) 
               elseif( vname .eq. 'LPMeffect' ) then
                  call arprml(vvalue, LPMeffect)                 
               else
                  write(0,*) ' epicsfile parameter: ', vname,
     *                 ' is undefined '
                  if( vname .eq. "epHooks" ) then
                     write(0,*)
     *                "Now, this must be placed in sepicsfile"
                  endif
                  stop 0000
               endif
            enddo
            close(iowk)
            write(msg,*) ' epics parameters have been read from ',
     *      dsn(1:klena(dsn))
            call cerrorMsg(msg, 1)
            return
c      *************
       entry epprmw(io)
            write(io,*)'----------------------'
            call awprml(io,'AngleB', AngleB)
            call awprmr(io,'DtMax', DtMax)
            call awprmi(io,'Eabsorb', Eabsorb)
            call awprmr(io,'Eanihi', Eanihi)
            call awprmr(io,'Ecut ', Ecut)
            call awprml(io,'EdepDedx', EdepdEdx)
            call awprmr(io,'ElowerBndPair ', ElowerBndPair)
            call awprmr(io,'EminElec', EminElec)
            call awprmr(io,'EminGamma', EminGamma)
            call awprmr(io,'Es   ', Escat)
            call awprmr(io,'EupperBndCS ', EupperBndCS)
            call awprmi(io,'IncGp', IncGp)
            call awprmi(io,'IoTrace', IoTrace)
            call awprml(io,'Knckon', Knckon)
            call awprml(io,'Molier', Moliere)
            call awprml(io,'Photo', Photo)
            call awprmr(io,'RecoilKeMin', RecoilKEmin)
            call awprmr(io,'Tcoef' , Tcoef)
            call awprmr(io,'Tmin' , Tmin)
            call awprml(io,'Trace' , Trace)
            call awprml(io,'TimeStruc' , TimeStruc)
            call awprml(io,'FreeC' , FreeC)
            call awprmr(io, 'EpsLeng', EpsLeng)
            call awprmi(io, 'ALateCor', ALateCor)             
            call awprmi(io, 'Sync',     Sync)
            call awprmr(io, 'SyncLoop',     SyncLoop)
            call awprmi(io, 'MagPair',     MagPair)
            call awprmi(io, 'MuNI', MuNI)
            call awprmi(io, 'MuBr', MuBr)
            call awprmi(io, 'MuPr', MuPr)
            call awprmr(io, 'KEmin', KEmin)
            call awprmi(io, 'MsgLevel', MsgLevel)
            call awprmr(io, 'Excom1', Excom1)
            call awprmr(io, 'Excom2', Excom2)
            call awprml(io, 'LPMeffect', LPMeffect)
            do i = 1, MaxMediaDir
               call awprmc(io, 'MediaDir', MediaDir(i))
            enddo
            call awprmc(io, 'TraceDir', TraceDir)

      end
c      ************
       subroutine  epcmp1
c      ************
       implicit none
#include "ZepTrackp.h"
#include "ZepTrackv.h"
#include "Zmass.h"
c             compute something using basic parameters
c
       if(ALateCor .eq. 2 .or.
     *        ( ALateCor .eq. 1 .and. .not. Moliere)) then
c          angular latelaral correlation will be taken at
c          multiple scattering. use standard trucation
          Tcoefx = Tcoef
          Tminx = Tmin
       else
c            no correlation will be considered so make
c          truncation length shorter
          Tcoefx = Tcoef/2
          Tminx = Tmin/2
       endif
       if(KEmin .eq. 0.) then
          KEmin = EminElec - masele
       endif
       if( RecoilKEmin .eq. 0.) then
          RecoilKEmin =EminElec - masele
       endif
       end
