c
c           initialize xsection calculation.
c  many intermediate values such as npercm3 etc are
c  dep. on rhoc but final quantities are indep. of rhoc
c
      subroutine epixsec(media)
      implicit none
#include "Zmedia.h"
c
      record /epmedia/media   ! in/out.  
c

c      
      real*8 shp
      integer i, j


      do j = 1, media.noOfElem
         shp = xsecmin          ! (say 10mb)
         do i = 1, nxsec
            call cxp2xAXsec(media.elem(j).A, shp,
     *                      media.elem(j).sigma(i))
            shp = shp + xsecstep
         enddo
      enddo


      end

      subroutine epgetxs(model, pj, media, xs, mfp, icon)
      implicit none
#include "Zptcl.h"
#include "Zcode.h"
#include "Zmedia.h"
#include "ZepTrackp.h"
c   
      character*16 model    ! input. Active interaction model.
      record /ptcl/ pj      ! input.  a particle (hadronic)
      record /epmedia/ media  ! input
      real*8 xs             ! output. obtained cross-section for the
                            !  media. in mb
      real*8 mfp            ! output. obtained  mean free path in kg/m2
      integer icon          !  0. xs is obtained.
                            !  -1. xs is almost 0
                            !  1,  xs is almost infinity
                            !  2, muon; treat outside (will not happen)
      real*8  mbTocm2
      parameter (mbTocm2=1.d-27)
      character*120 msg
      logical useOwnXs   
      integer ka, i,  ica, jcon, ia, j
      real*8 ke, s, tga, tgz, u, sumns
      real*8  eps/0.001/
      integer pjmassn
      record /ptcl/dumproton
      character*8 mediasave
      integer iconsave
      real*8  Esave, small
      real*8  xssave, mfpsave
      data    small/1.d-3/
      save 
c           in many case, knockon process takes place 
c       many times and during such process, E dose not
c       change much so that  the nuclear interaction
c       mfp may be taken unchanged. 
c             This is not good for QGSJET2; xsection
c            calculation routine must be called each time
c      if( pj.charge .ne. 0 ) then
c         if( abs(Esave-pj.fm.p(4))/Esave .lt. small ) then
c            if(mediasave .eq. media.name .and. 
c     *           pj.code .eq. ka  .and. 
c     *           pj.charge .eq. ica ) then
c               mfp = mfpsave
c               xs = xssave
c               icon =iconsave
c               return  ! *********************************
c           endif
c         endif
c      endif
      mediasave = media.name
      Esave = pj.fm.p(4)

      ke = Esave - pj.mass         
      ka = pj.code
      ica = pj.charge

      if( model .eq. "dpmjet3" ) then
         if( ka .ge. kpion .and. ka .le. knuc ) then
            if( ke  .lt.  5.0d0 ) then
               useOwnXs = .true.
c                total Xs must be used to include elastic scatt.
               sumns=0. 
               do i =1, media.noOfElem
                  call ctotx(pj, media.elem(i).A,  xs)
                  media.nsigma(i) = xs*media.npercm3(i)
                  sumns = sumns + media.nsigma(i)
               enddo
               media.sumns = sumns
            else
               useOwnXs= .false.
            endif
         else
            useOwnXs= .false.
         endif
      elseif( model .eq. "qgsjet2" ) then
         if( (ka .ge. kpion .and. ka .le. knuc) .or. 
     *      ka .eq. kgnuc ) then
            useOwnXs = .true.
c            this is for A target;
            sumns=0. 
            do i =1, media.noOfElem
               tga = media.elem(i).A
c               ia =tga +0.5
               ia =tga 
               call rndc(u)
               if(u .lt.  tga - ia ) then
                  ia = min(ia + 1, 209)
               endif
               call cxsecQGS(pj, ia, xs)               
               media.nsigma(i) = xs*media.npercm3(i)
               sumns = sumns + media.nsigma(i)
            enddo
            media.sumns = sumns
         elseif(ka .eq. kgzai .or. ka .eq. ksigma .or.
     *           ka .eq. kbomega    .or. ka .eq.  klambda .or.
     *           ka .eq. klambdac ) then
            useOwnXs = .true.
            dumproton = pj
            call cmkptc(knuc, -1, 1, dumproton)
            sumns=0. 
            do i =1, media.noOfElem
               tga = media.elem(i).A
c               ia =tga +0.5
               ia =tga 
               call rndc(u)
               if(u .lt.  tga - ia ) then
                  ia = min(ia + 1, 209)
               endif
               call cxsecQGS(dumproton, ia, xs)               
               media.nsigma(i) = xs*media.npercm3(i)
               sumns = sumns + media.nsigma(i)
            enddo
            media.sumns = sumns
         else
            useOwnXs = .false.
         endif
      elseif( model .eq. 'gheisha' ) then
         if(ica .ge. 2 ) then
            useOwnXs=.false.
         elseif( ka .lt. kpion .or. ka .gt. knuc ) then
            useOwnXs=.false.
         else
            useOwnXs =.true.
            sumns=0. 
            do i =1, media.noOfElem
               tga = media.elem(i).A
               tgz = media.elem(i).Z
               call cxsecGheisha(pj, tga,  tgz, xs)
               media.nsigma(i) = xs*media.npercm3(i)
               sumns = sumns + media.nsigma(i)
            enddo
            media.sumns = sumns
         endif
      else
         useOwnXs=.false.
      endif

      if(.not. useOwnXs) then
         if( ka .eq. kgnuc ) then
            useOwnXs = .true.
            sumns = 0.
            pjmassn = pj.subcode
            do i = 1, media.noOfElem
               call cAAXsec(pjmassn, media.elem(i).A, ke,  xs)
               media.nsigma(i) = xs*media.npercm3(i)
               sumns = sumns + media.nsigma(i)
            enddo
            media.sumns = sumns
         endif
      endif
c
c
c      useOwnXs=T means use Xsection supplied by the
c         respective code. or total xsec is needed
c      so that xs has been computed already above.
c
      icon = 0
      if( .not. useOwnXs ) then
         if(ka .eq. kpion .or. ka .eq. keta) then
            if(ica .ge. 0) then ! pi+, 0.
               call cpiPluspXsec(ke, xs)
            else
               call cpiMinuspXsec(ke, xs)
            endif
         else
            if (ka .eq. kkaon) then
               if(ica .ge. 0) then
                  call ckPluspXsec(ke, xs)
               else
                  call ckMinuspXsec(ke, xs)
               endif
            elseif (ka .eq. kmuon) then
c                muon interaction is treaed later.  
               xs = 1
               icon = 2
            elseif (ka .eq. knuc) then
               if(pj.subcode .eq. antip) then
                  if(ke .gt. eps) then
                     call cpbarpXsec(ke, xs)
                  else
                     icon = 1
                  endif
               else
                  call cppXsec(ke, xs)
               endif
            elseif(ka .eq. kneumu) then
               icon = -1
            elseif(ka .eq. kneue) then
               icon = -1
            elseif(ka .eq. kdmes) then
C                 d meson; use mean free path for kaon
               call ckPluspXsec(ke, xs)
            elseif (ka .eq. knnb) then
c             nn~ instant decay
               icon = -1
            elseif (ka .eq. kddb) then
c              dd~ instant decay. xs =0
               icon = -1
            elseif (ka .eq. kgzai .or. ka .eq. ksigma .or.
     *           ka .eq. kbomega    ) then
c                 use proton x-section
               call cppXsec(ke, xs)
            elseif ( ka .eq.  klambda .or. ka .eq. klambdac) then
c               use proton x-section
               call cppXsec(ke, xs)
            else
               write(msg,*) ' epgetxs:  strange ptcl: ka=',ka
               call cerrorMsg(msg, 0)
            endif
         endif
      endif
c     

      if(icon .eq. 0 .and. .not. useOwnXs ) then
         sumns = 0.
         do i = 1, media.noOfElem
            if( media.elem(i).A .ne. 1.0 ) then
c               convert proton target cross-section into
c               target media.elem(i).A target ; it is
c               already computed and stored in media.elem(i).sigma(j)
c               j=1:  xsecmin
c               j=2:  xsecmin+xsecstep
c               j=j:  xsecmin+ (j-1)*xsecstep
               if( xs .ge. xsecmin ) then
                  j = min( int( (xs - xsecmin )/xsecstep ), nxsec-2)
                  s = ( media.elem(i).sigma(j+2) - 
     *                  media.elem(i).sigma(j+1) )
     *                * ( xs- ( xsecmin+j*xsecstep )  ) / xsecstep 
     *                 + media.elem(i).sigma(j+1)
               else
c                  write(0,*)
c     *             ' too small xs in epgetxs in epixsec is', xs
c                  write(0,*) ' ka=',ka, ' charge=', ica, ' K.E=',ke
c                  stop
                  s = media.elem(i).A*xs
               endif
            else
               s = xs
            endif
            media.nsigma(i) = s*media.npercm3(i)   ! in mb/cm3
            sumns = sumns + media.nsigma(i)
         enddo
         media.sumns = sumns
      endif



      if(icon .eq. 0) then
c           prop to rhoc so next two are indep. of rhoc
         xssave = media.sumns/media.nd      ! mb/cm3 /(1/cm3)
         mfpsave = 10.*media.rho/(media.sumns*mbTocm2)   ! in kg/m2. Not in g/cm2
                                          ! to be consistent with other  part.
         xs = xssave
         mfp = mfpsave
      endif
      iconsave = icon
      end

      subroutine epfixTarget(model, media)
      implicit none
#include "Zmedia.h"
c         
c
c       Fix the target element, 
c  
      character*16 model    ! input. Active interaction model.
      record /epmedia/media   ! input/output.  colElem, colA, colZ
      real*8 xs   ! output. x-section on selected target element (mb)
c      integer ia, iz        ! output target mass number and charge; now  
c      xs                    they are put colA and colZ colXs
      real*8 u, csigma
      integer  j, ia


      if( media.noOfElem .eq. 1 ) then
         j = 1
      else
         call rndc(u)
         u = u* media.sumns
         csigma = 0.
         do j = 1, media.noOfElem
            csigma = csigma + media.nsigma(j)
            if(u .le. csigma)  goto 10
         enddo
         call cerrorMsg('should not come here; epfixTarget',0)
      endif
 10   continue
      media.colElem = j
c          int value is taken.
      if(model .eq. "dpmjet3" ) then
         ia = media.elem(j).A  + 0.5
      else
         call rndc(u)
         ia = media.elem(j).A
         if(u .lt. media.elem(j).A -ia ) then
            ia = ia + 1
         endif
      endif
      media.colZ = media.elem(j).Z
      media.colA = ia
      media.colXs = media.nsigma(j)/media.npercm3(j)
      end
      subroutine epfixTarget2(model, media)
      implicit none
#include "Zmedia.h"
      character*16 model    ! input. Active interaction model.
c          This may be used for small basic cross
c     section case so that the xA cross section is
c     propotinal to A. (for gamma A/ mu A)
c         

      record /epmedia/media   ! input/output  colElem, colA, colZ are output
      integer ia
      real*8 u, sum
      integer j

      if(media.noOfElem .eq. 1) then
         j = 1
      else
         call rndc(u)
         sum = 0.
         do j = 1, media.noOfElem
            sum = sum + media.w(j)
            if(u .le. sum) goto 10
         enddo
         call cerrorMsg('should not come here; epfixTarget2',0)
      endif
 10   continue
      media.colElem = j
c          int value is taken.
      if(model .eq. "dpmjet3" ) then
         ia = media.elem(j).A  + 0.5
      else
         call rndc(u)
         ia = media.elem(j).A 
         if(u .lt. media.elem(j).A -ia ) then
            ia = ia + 1
         endif
      endif
      media.colZ = media.elem(j).Z
      media.colA = ia
      media.colXs = media.nsigma(j)/media.npercm3(j)
      end
