c  test ksort1 (comb-sort for arbitray data structure with 1 key)
c
!     implicit none
!     integer nrec, l, intv, i, k
!     external keycmp
!     common /cmp/ a
!     parameter (intv=4, nrec =10000)
!     real a(intv, nrec), rand
!
!     do  i=1, intv
!          do  l = 1, nrec
!               a(i, l)=rand(0)
!          enddo
!     enddo
!     do  l=1, 10
!          write(*,*) (a(k,l), k=1, intv)
!     enddo
!     write(*,*) ' --------------------'
c         ****************************************
!     call ksort1(0, nrec, 3, 'a', keycmp)
c         ****************************************
!     do l=1, 10
!              write(*, *) (a(k,l), k=1, intv)
!     enddo 
!     write(*,*) ' ------------------'
!     do l=nrec-10, nrec
!              write(*, *) (a(k,l),k=1, intv)
!     enddo 
!     end
c ***************************************************
!     integer function keycmp(i, j, keyp)
!     implicit none    
!     common /cmp/ a
!     integer intv, nrec
!     parameter (intv=4, nrec =10000)
!     real a(intv, nrec), x
!     integer i, j,  keyp
!     integer k
!
!     if(a(keyp, i) .gt. a(keyp, j)) then
!             do k=1, intv
!                x=a(k,i)
!                a(k,i)=a(k,j)
!                a(k,j)=x
!              enddo
!              keycmp=1
!     elseif(a(keyp, i) .eq. a(keyp,j)) then
!              keycmp=0
!     else
!              keycmp=-1
!     endif
!     end  
c*********************************************************************************
c Sort data with an arbitrary structure using 1 key
c  Usage:
c         call ksort1(noff, nrec, keyp, ad, judge)
c
c     noff:  integer input. noff+1 is the first record position where sort
c            is to be started.
c            In a normal application, give 0. (fisrt record in the data)
c     nrec:  integer input. # of records  in the data to be sorted.
c            Data structure may be arbirary.  nrec records from noff+1-th record
c            will be sorted. 
c     keyp:  keyp-th field in a record is the key to be used for sorting.
c            (keyp should be positive integer ; 1,...)
c       ad: 'a' or 'd' to specify the ascending or descending sort.
c    judge:  integer function name which has the following calling sequence.
c            intval=judge(i, j, keyp)
c            This function should compare the i-th and j-th record of the data
c            (for keyp-th field), and 
c               if the i-th record is > the j-the  record then
c                    1) exchange the i-th and j-th record,
c                    2) give 1 to the function value
c               elseif both are equal
c                    1) give 0 to the function value
c               else (i.e., i-th < j-th) 
c                    1) give -1 to the function value
c
c            Example of how to construct judge is shown in the above
c            test program. (The name 'keycmp' is used; it must be declared
c            external)
c
c************************** note ************************************************
c    If the data is 1 dimensional real or integer array,
c       use kcsr1 or kcsi1.  They are much faster and simpler in usage.
c    If the data is multidimensional real or integer array,
c       the user may use kcsr2 or kcsi2.  They are much simpler in usage.
c       However, the speed is almost comparable with this one. (Sometimes,
c       this is faster).
c********************************************************************************
c  Method:  comb-sort (see Nikkei-byte; Nov. 1991)
      subroutine ksort1(noff, nrec, keyp,  ad, judge)
      implicit none

      integer nrec, keyp, judge, noff
      character*(*) ad

      integer i, j, k, gap, imax
      real  sf/1.30/
      logical exch, more

      gap=nrec
!             
      more=.true.
      do while( more )
         gap=float(gap)/sf
         if(gap .le. 0) then
              gap=1
         elseif(gap .eq. 9 .or. gap .eq. 10) then
              gap=11
         endif
         imax=nrec - gap
         exch = .false.
         do j=1, imax
              k=j+gap
              if(ad .eq. 'a') then
                   i=judge(j+noff, k+noff, keyp)
              else
                   i=judge(k+noff, j+noff, keyp)
              endif     
              if(i .eq. 1) exch=.true.
         enddo
         more=exch .or. gap .ne. 1
      enddo
      end










