c     ****************************************
c     *                                                              *
c     * epmulScat: multiple Coulomb scattering
c     *                                                              *
c     ****************************************
c
c
      subroutine epmulScat(mediax,  theta)
      implicit none
c       Using  cTrack and Move, compute scattering angle 
c
#include "Zglobalc.h"
#include "ZepTrackp.h"  
#include "ZepTrackv.h"  

       
      record /epmedia/mediax  ! input. Media where scattering occurs
      real*8 theta         ! output. sampled angle in radian.
c
c            
c
      integer cond

      integer ic

c             sample theta
      if(Move.dl .gt. 0.) then
c     
         if(Moliere) then
c          Cosmos unit must be used.
            ic = cTrack.p.charge  !  *2 --> *4 conversion
            call epmoliere(mediax, theta, cond)
            if(cond .ne. 0) then
               call epang2(Move.dt, 
     *              cTrack.p.fm.p(4)*Move.Track.p.fm.p(4),
     *              theta)
            endif
         else
            call epmulGauss(theta)
         endif
      else
         theta = 0.
      endif
      end
      subroutine epang2(t, e2, teta)
      implicit none
c              simple  gaussian  approx. obsolute but
c         usable.
#include "ZepTrackp.h"
      real*8 t  ! input. path length in r.l
      real*8 e2 ! input  E1 x E2  at path head and end
      real*8 teta ! output.  sampled angle in radian

      real*8 u
      call rndc(u)
           
      teta=Escat*sqrt(max(-log(u)*t/e2, 0.d0))
      end
c     **************************
      subroutine epmulGauss(teta)
      implicit none
c        Moliere theory of multiple scattering angle.
c        This is a modified version from the one used in Cosmos
c
#include "Zglobalc.h"
#include "ZepTrackp.h"
#include "ZepTrackv.h"

      real*8 teta ! output. sampled spatial angle in radain.

      real*8 tetarms, g1, g2, u, beta2
      integer nc
      real*8 hpi 
      parameter(hpi = pi/2.)

      g1 = cTrack.p.fm.p(4)/cTrack.p.mass
      g2 = Move.Track.p.fm.p(4)/cTrack.p.mass
      beta2 = 1.d0 - 1.d0/g1/g2
      if(beta2 .le. 0.) then
         tetarms = 0.
      else
         if(Move.dt .gt. 1.d-3) then
            tetarms = Escat/cTrack.p.fm.p(4)*abs(cTrack.p.charge) *
     *        sqrt(Move.dt/beta2)*(1.0 + 0.038*log(Move.dt))
c     *        sqrt(Move.dt/beta2)
         else
            tetarms = Escat/cTrack.p.fm.p(4)*
     *          abs(cTrack.p.charge) * sqrt(Move.dt/beta2)
         endif
      endif
      teta = pi
      nc = 0
      do while(teta .gt. hpi)
         if(nc .gt. 10) then
c              tetarms seems too large
            teta = u**0.1 * hpi  ! give some value 
         else
            call rndc(u)
            teta = sqrt(-log(u))* tetarms
            nc = nc +1
         endif
      enddo
      end
c     ***************************************
      subroutine epmoliere(mediax, teta, cond)
      implicit none
c        Moliere theory of multiple scattering angle.
c        This is a modified version from the one used in Cosmos
c     change: interface.   y teta > pi/2 dose not appear.
#include "Zglobalc.h"
#include "Zmass.h"
#include "ZepTrackv.h"

      record /epmedia/mediax  ! input. media 
      real*8 teta ! output. sampled spatial angle in radain.
      integer cond ! output. 0 ok. non-0. Moliere theory not applicable

      real*8 hpi2
      parameter (hpi2 = (pi/2)**2 )

      real*8  b, xc2
      common /Zmoliere/ b, xc2

      real*8  gbeta2, beta2, massratio2
      common /Zcmedia/  gbeta2, beta2,  massratio2

      
c     *********************
      real*8 xa2, bp,  u
      real*8 a0, a1, a2,  sum, ra2, ra2inv
      real*8 g1  !  gamma factor at the path head
      real*8 g2  !  gamma factor at the path end
      integer icon
      real*8 rejf1, rejf21, rejf22
      real*8 x
c       
c      rejection function for redueced angle < 1.8
c          x is square of reduced angle better than 0.2 %
       rejf1(x)= ((0.1217176d-01*x + 0.3054916d-01)*x -0.2524543d0)*x
     *          + 0.9990352d0          
c
c              at 0 < x = 1/angle^2 < 0.15
       rejf21(x) =(( -162.1568*x + 44.48334)*x + 0.3907116)*x 
     *      + 0.4399338              

c             at  x = 1/angle^2 > 0.15
       rejf22(x) = (( 71.23819*x - 49.61906)*x + 10.77501)*x+ 0.2001145      
c

c ------------------------------------

      g1 = cTrack.p.fm.p(4)/cTrack.p.mass
      g2 = Move.Track.p.fm.p(4)/cTrack.p.mass
      gbeta2=(g1 - 1.d0/g1) * (g2 - 1.d0/g2)
      beta2 = 1.d0 - 1.d0/g1/g2
      massratio2= (masele/cTrack.p.mass)**2  ! (me/m)^2
c    ............................

c          get Xc^2
      call epkaic2(mediax,   xc2)
c          get Xa^2
      call epkaia2(mediax,   xa2)

c          b -log(b) = b'
      bp = log(xc2/xa2/1.167)

      if(bp .lt. 3.395) then
c         Moliere theory cannot be appliled; use Gaussian later
c         (almost no scattering)
         cond = 1
      else
         cond = 0
         call epblogb(bp, b, icon)
         a0 = max(1.d0 - 5/b, 0.d0)  ! use single scattering term if b<=5. 
         icon = 1               ! make 0 if no rejection
c           the sampling function decomposition is explained in Test/....tex
c                                                            |  Cosmos |
         do while (icon .ne. 0)
            a1 = 5.21062/b
            a2 = 0.7128/b
            sum = a0 + a1 + a2
            call rndc(u)
            if(a0/sum  .gt. u) then
c              sample reduced angle from exp(-x) dx where x = reduced
c              angle^2.
               call rndc(u)
               ra2 = -log(u)
               icon = 0
            elseif( (a0+a1)/sum .gt. u) then
c                 sample reduced angle from exp(-x) dx (same as above but
c                in the region of ra < 1.8
               call rndc(u)
               ra2 = -log(1.-u/1.04076)

c                 rejection function
               call rndc(u)
               if(u .lt. rejf1(ra2)) then
                  icon = 0
               endif
            else
c                 sample reduced angle from 2xc2 x^-4dx
               call rndc(u)
               ra2 = 3.24/u
c                   rejection function
               call rndc(u)
               ra2inv = 1./ra2
               if(ra2inv .lt. 0.15) then
                  if(u .lt. rejf21(ra2inv)) then
                     icon = 0
                  endif
               elseif(u .lt. rejf22(ra2inv)) then
                  icon = 0
               endif
            endif
            teta = ra2 * xc2 * b !  actually  theta ^ 2
            if(teta .ge. hpi2 ) icon = 1
         enddo
         teta = sqrt(teta)
      endif
      end 
c     *******************
      subroutine  epqmoliere(bb,  xxc2)
c     ******************
      implicit none
      real*8 bb, xxc2
      real*8  b, xc2
      common /Zmoliere/ b, xc2


c            inquire the latest consts for Moliere function.
c      You can make reduced angle from theta by
c          reduced angle^2 = theta^2/b/xc2
      bb = b
      xxc2 = xc2
      end

c     ***************************
      subroutine epblogb(c, b, cond)
      implicit none
c        solve  B - log(B) = c
c
      real*8 c ! input.   c>=1.
      real*8 b ! output.  solved b >=1. (b <1 is discarded)
      integer cond ! output. 0 if ok.
                   !         1 if c < 1.
      if(c .lt .1) then
         cond = 1
      else
c         b = 0.7 + 1.32 *c -  0.01451* c*c
          b =(((-0.3733404E-04*c + 0.1902303E-02)*c -0.3841290E-01 )*c
     *         + 1.431932)*c +     0.5200487 
      endif
      end
c     ***************************
      subroutine epkaia2(mediax,   xa2)
      implicit none
#include "Zglobalc.h"
#include "ZepTrackv.h"

c        compute Xa^2; assume the Xa^2 is weakly
c       dependent on Z, we use average Z=zave for
c       calculation.
c
      record /epmedia/mediax
 
      real*8 xa2   !  output. Xa^2.

      real*8  gbeta2, beta2, massratio2
      common /Zcmedia/  gbeta2, beta2, massratio2
      
      real*8   alpha, const, large
      parameter (alpha = 1./137., const = (1.13*alpha)**2 )
      parameter (large = (pi/2.)**2)

      if(gbeta2 .le. 0.) then
         xa2 = large
      else
         xa2 = const * mediax.Zeff**0.66666 * massratio2 *
     *   (1.13 * beta2 + 3.76*(alpha*cTrack.p.charge*mediax.Zeff)**2)
     *    /gbeta2
      endif
      end
c
      subroutine epkaic2(mediax, xc2)
      implicit none
#include "Zglobalc.h"
#include "ZepTrackv.h"


c
c   note: we neglect atomic electron contribution because it is
c         considered in Moller or Bhabha scattering.
c
c         compute Xc^2 = 4Pi r_0^2 N0 z^2 rho Z^2/A  * integral
c        0 to leng of 1/beta**4/gamma**2  (radian^2)/massratio2
      
      record /epmedia/mediax ! input. media
      real*8 xc2   ! output. Xc^2 in radian^2

      real*8  gbeta2, beta2, massratio2
      common /Zcmedia/ gbeta2, beta2, massratio2

      real*8 r0, avoganum, const, large
      parameter (r0=2.817d-15, avoganum=6.022d23)
      parameter (const = 4.*pi* r0**2 * avoganum*1.d3, 
     *    large = (pi/2)**2)
c
c
c      integeral 0 to leng of  1/(beta**4 E**2)
c      is approximated as  leng/(beta1**2 gamma1 beta2**2 gamma2)
c      Note: bata**2 *gamma = gamma - 1/gamma
c
      if(gbeta2 .le. 1.d-7) then
         xc2 = large
      else

c              rho is kg/m^3  length is in m because of Cosmos
c             rho*1000    dl/100.  = rho*dl*10
         xc2 = const* cTrack.p.charge**2 * mediax.Z2eff/mediax.Aeff *
     *         mediax.rho*mediax.rhoc* Move.dl *10./gbeta2 *
     *         massratio2
      endif
      end



