c      ***************************************************************
c      *                                                             *
c      * Sepics: A  Standard program which uses EPICS
c      *                                                             *
c      ***************************************************************
c
       subroutine sepics(ngen)
       implicit none
       integer ngen  ! output. # of events generated in this run

       integer icon

c             init sepics, epics
          call sopen
c             generate showers until required # or
c             time lack
c          *** until loop*** 
          do while (.true.)
             call s1set(icon)
          if         (icon .ne. 0)
     *                       goto 10
          enddo
   10     continue
c             end of all events or time lacks
          call epeaev
          call sclose(ngen)
       end
       subroutine sopen
       implicit none
c              read control parameters
#include  "Zsdef.h"
#include  "Zsparm.h"
#include  "Zswk.h"

        character*150 msg
c
          read(*, *, end=100) EpicsFile, ConfigFile, SepicsFile, cont

          call sparmr(SepicsFile)
c

c                   init epics
          call epiaev(EpicsFile, ConfigFile)

c              incident energy sampling. initializaiton 
          call ciniSPrim(PrimaryFile)
c
c            inquire form
          call epqfrm(form)
          if(form .eq. 'cyl') then
             call epqcyl(rcyl)
          elseif(form .eq. 'pip' ) then
             call epqpip(rpipi, rpipo)
          endif
          call epqcnf(wxmin, wymin, wzmin,
     *                wxmax, wymax, wzmax)
          call epqworld(nwld) 
c
          if(.not. cont) then
c               to keep first exEcution date: get date & time
c             call kqymd(pdatE0)
c             call kqhms(ptimE0)
c            get version #
             call epqvn(vn)
          endif
c
c                initialize random no.
ccc          if(cont) then
ccc              call scontr(IoCont)
ccc         else
              call rnd1i(Ir1)
ccc          endif
c          write(*,*) ' ------ ', vn, '------- '
c                init. timer
ccc          call timei( Ddate, Dtime, JobTime )
          return
c
  100     continue
          write(msg, *) 'EpicsFile=',EpicsFile
          call cerrorMsg(msg, 1)
          write(msg, *) 'ConfigFile=', ConfigFile
          call cerrorMsg(msg, 1)
          write(msg, *) ' SepicsFile=',  SepicsFile
          call cerrorMsg(msg, 1)
          write(msg, *) ' cont info=', cont
          call cerrorMsg(msg, 1)
          write(msg,*) ' no control parameters'
          call cerrorMsg(msg, 0)
       end
       subroutine  s1set(icon)
       implicit none
#include  "Zsdef.h"
#include  "Zsparm.h"
#include  "Zswk.h"
      integer icon

      integer jcon

           if(nevc .ge. Nevent) then
              icon=1
           else
c                 get random no. for this event
              call rnd1s(Ir1st)
c                 init 1 event. (clear arrays etc)
              call epi1ev(jcon)
              if(jcon .ne. 0) then
c                    jcon=0-->user set the incident
c                    set incident ptcl(s) by sepics
                  call ssetip
              endif
              call stimec(icon)
c                  check time using stack area data
              if(icon .eq. 0) then
c                     time is available for the generation
c                     generate 1 event
                   call epgen
c                     end of 1 event
                   call epe1ev
                   call se1ev
              endif
          endif
       end
       subroutine se1ev
       implicit none
c             end of 1 event
#include  "Zsdef.h"
#include  "Zsparm.h"
          nevc=nevc+1
       end
c      ***************
       subroutine sqtevn(nev)
       implicit none
#include  "Zsdef.h"
#include  "Zswk.h"
#include  "Zsparm.h"

      integer nev, icon

c           inquire total # of events created
          nev=nevc
          return
c      *****************
       entry sqcont(icon)
          if(cont) then
             icon=1
          else
             icon=0
          endif
       end
       subroutine ssetip
       implicit none
#include  "Zepdef.h"
#include  "Zsdef.h"
#include  "Zswk.h"
#include  "Zsparm.h"


      integer ns, i, j, icon
      real*8 sume

c             set incident ptcl
c               fix energy
           call sfixe
c               fix position
           call sfixp
c               fix angle
           call sfixa
c               fix others
           call sfixo
c               set them
           call epputp(kin, icin, ein, xin, yin, zin,
     *     w1in, w2in, w3in, tin, ain, InciSubCode)
           return
c      *****************
       entry stimec(icon)
c      *****************
c         icon=0---> time available
c             ^=1---> no //
c              inquire current stack index
           call epqstn(ns)
c              inquire energy
           sume=0.
            do   i=1, ns
              call epqske(i, ein)
              sume=sume+ein
            enddo
c             estimate time for energy:   BaseTime=time for 1gev
           j=sume* BaseTime
c             see if more cpu time available
c           call timec(j, icon)
           icon = 0
       end
       subroutine sclose(nev)
       implicit none
#include  "Zsdef.h"
#include  "Zsparm.h"

      integer nev
      character*150 msg

c               end of all events
cc          call scontw(IoCont)
cc          call timepc(6)
c              inquire # of events created in this run
          call epqevn(nev)
c              print message
c             get  current random no.
          call rnd1s(Ir1)
          write(msg,*) ' # created in this run=',nev,
     *     ' current total #=',nevc,
     *     ' destination #=',Nevent,
     *     ' next ir=', Ir1
          call cerrorMsg(msg, 1)
       end
       subroutine sfixe
       implicit none
#include  "Zepdef.h"
#include  "Zsdef.h"
#include  "Zswk.h"
#include  "Zsparm.h"

      real*8 u, r, fcos, fsin, ux, uy, uz, zmax, dx, dy, cs, sn
      real*8 st
      save zmax

      character*70 msg


c              sample incident energy, ptcl
      call epsampPtcl(kin, InciSubCode, icin,  ain, ein)
       return
c      *************************************
       entry sfixp
c       sample incident x,y,z position
       if(InputP .eq. 'fix') then
          xin=Xinp
          yin=Yinp
          zin=Zinp
       elseif(InputP(1:1) .eq. 'u') then
          if(form .eq. 'cyl' ) then
             call rndc(u)
             r= rcyl*sqrt(u)
             call rndc(u)
             call kcossn(fcos, fsin)
             ux=r*fcos
             uy=r*fsin
             call rndc(u)
             zmax= wzmax
             uz= (wzmax-wzmin)*u + wzmin

          elseif(form .eq. 'box') then
             call rndc(ux)
             call rndc(uy)
             call rndc(uz)
             ux = (wxmax-wxmin)*ux  + wxmin
             uy = (wymax-wymin)*uy  + wymin
             uz=  (wzmax-wzmin)*uz  + wzmin
             zmax= wzmax

          elseif(form .eq. 'pipe') then
             call rndc(u)
             r=sqrt( 
     *            (rpipo**2-rpipi**2)*u + rpipi**2
     *             )
             
             call rndc(u)
             call kcossn(fcos, fsin)
             ux=r*fcos
             uy=r*fsin
             call rndc(u)
             zmax= wzmax
             uz=(wzmax-wzmin)*u + wzmin

          else
c                    world  must be given
c             if(nwld .eq. 0) then
c                call cerrorMsg(
c     *          'world must be given to use uxy etc',  0)
c             else
                call rndc(ux)
                call rndc(uy)
                call rndc(uz)
                ux =( wxmax- wxmin) * ux + wxmin
                uy =( wymax- wymin) * uy + wymin
                zmax= wzmax
                uz = (wzmax-wzmin) *uz + wzmin
c             endif
          endif
          if(InputP .eq. 'uxy') then
             xin = ux
             yin = uy
             zin = min(max(Zinp, wzmin), wzmax)
          elseif(InputP .eq. 'uxz') then
c             if(form .eq. 'box' .or. nwld .gt. 0) then
             if(form .eq. 'box' .or. form .eq. 'mix') then
                xin =ux
                zin =uz
                yin =min(max(Yinp, wymin), wymax)
             else
                msg='may be world must be given for uxz'
                call cerrorMsg(msg, 0)
             endif
          elseif(InputP .eq. 'uyz') then
c             if(form .eq.'box'.or. nwld .gt. 0) then
             if(form .eq.'box'.or. form .eq. 'mix') then
                xin=min(max(Xinp, wxmin), wxmax)
                yin=uy
                zin=uz
             else
                msg='Maybe world must be give for uyz'
                call cerrorMsg(msg, 0)
             endif
          elseif(InputP .eq. 'uxyz') then
             xin=ux
             yin=uy
             zin=uz
          endif
       elseif(InputP(1:1) .eq. 'g') then
c                        gaussian density beam
          call agausb(Hwhm, ProfR, dx, dy)
          if(InputP .eq.  'gxy') then
c                 around Xinp, Yinp
             xin=Xinp + dx
             yin=Yinp + dy
             zin=min(max(Zinp,wzmin), wzmax)
          elseif(form .eq. 'box' .or.  form .eq. 'mix')then
c     *        nwld .gt. 0) then
             if(InputP .eq. 'gxz') then
                  xin=Xinp + dx
                  yin=min(max(Yinp,wymin), wymax)
                  zin=Zinp + dy
              elseif(InputP .eq. 'gyz') then
                  xin=min(max(Xinp, wxmin), wxmax)
                  yin=Yinp + dx
                  zin=Zinp + dy
               endif
            else
               call  cerrorMsg(
     *          'gxz, gyz need box, or world', 0)
            endif
         else
            write(msg,*) ' InputP=',InputP, ' invalid'
            call cerrorMsg(msg,  0)
         endif
         return
c       ****************************************
        entry sfixa
        if(InputA .eq. 'fix') then
           w1in=DCInpX
           w2in=DCInpY
           w3in=DCInpZ
        elseif(InputA .eq. 'is') then
           call rndc(u)
           DCInpZ= ( dimag(CosNormal) - real(CosNormal) )* u
     *          + real(CosNormal)
           call kcossn(cs,sn)
           st= sqrt( 1.d0 - DCInpZ**2)
           DCInpX=st * cs
           DCInpY=st * sn
c            convert to each surface case
           if(InputP(2:3) .eq. 'xy') then
              w1in=DCInpX
              w2in=DCInpY
              if(zin .eq. wzmin) then
                 w3in=DCInpZ
              else
                 w3in=-DCInpZ
              endif
           elseif(InputP(2:3) .eq. 'xz' ) then
              w1in=DCInpX
              w3in=DCInpY
              if(yin .eq. wymin) then
                 w2in=DCInpZ
              else
                 w2in=-DCInpZ
              endif
           elseif(InputP(2:3) .eq. 'yz' ) then
              w2in=DCInpX
              w3in=DCInpY
              if(xin .eq. wxmin) then
                 w1in=DCInpZ
              else
                 w1in=-DCInpZ
              endif
           elseif(InputP .eq. 'fix') then
c                      user must be sure that CosNormal
c                      give correct angle
              w1in=DCInpX
              w2in=DCInpY
              w3in=DCInpZ
           else
              write(msg,*)' InputP=',InputP, ' and ',
     *             InputA,' incompatible'
              call cerrorMsg(msg, 0)
           endif
        else
           write(msg,*) ' InputA=',InputA, ' not supported'
           call cerrorMsg(msg, 0)
        endif
        return
c        ***************************
      entry sfixo
c              fix time of incidence
           tin=0.d0
cccc?           InciSubCode=InciSubCode
       end
       subroutine scontw(io)
       implicit none
#include  "Zsdef.h"
#include  "Zswk.h"
#include  "Zsparm.h"
      integer io

           character*2 qmk1/2h '/, qmk2/2h',/

c
               write(io, *) nevc, Ir1st,
     *         qmk1,pdatE0,qmk2, qmk1, ptimE0,qmk2,
     *          qmk1, vn, qmk1
               call sparmw(io)
               return
c
c      ******************
       entry scontr(io)
               read(io, *, end=100) nevc, Ir1, pdatE0,
     *               ptimE0, vn
               call rnd1r(Ir1)
               rewind io
               return
  100      continue
           stop 'no cont information'
       end
