#include "ZsubstRec.h"
#include "Zunionmap.h"
c   How to manage:
c Interaction length sampling
c  1) when a particle is popped up in Epics (say, let it be
c     popped.p)
c      call ep2cosPtcl(popped.p)  
c       This sets the particle info in a common area contained in
c       Zepics2cos.h
c  2) Smple the path for the interaction of the
c     particle, inform the Media by
c      call ep2cosCond(Aeff, Zeff).
c         This sets TrackBefMov using info in Zepics2cos.h
c         and also sets Target A and Z.
c  3) call ciniSmplInL.  This initializes interaction length
c                        sampling. (Cosmos Function)
c
c  4) call csampNEPIntL. This actually samples interaction length.
c         We don't use Cosmos knock-on process (histrical reason), we
c         add the knock process as the competing processes.
c   From version 7. this is replaced by epsmpNEPIntL.
c
c -----------------
c Interaction 
c     Knock-on is managed within Epics
c    Nuclear interaction:
c      call ep2cosPtcl(cTrack). This sets current particle as
c                               a Cosmos particle.
c      call ep2cosCond2(ia, iz). sets A,Z, 
c      call cinteNEP    This makes interaction
c      call eppushPtcl.  push ptcle  into epics area.
c
c  
c       ********************************************
c
c       interface routines between epics and cosmos
c 
c       ********************************************
c
c            one pass routine to set cosmos param.
c
c               make a cosmos particle.
       subroutine ep2cosPtcl(aPtclin)
       implicit none
#include "Zepi2cos.h"
       record /ptcl/aPtclin

       aPtcl = aPtclin

       end
c       *****************************
c       subroutine ep2cosCond(tmass, zchg)
       subroutine ep2cosCond
        implicit none
#include "Zepi2cos.h"
#include "Zcode.h"
cc       real*8 tmass, zchg 
#ifdef UNIONMAP
       TrackBefMove.p = aPtcl
#else
       TrackBefMove.p.fm = aPtcl.fm
       TrackBefMove.p.mass = aPtcl.mass
       TrackBefMove.p.charge = aPtcl.charge
       TrackBefMove.p.code = aPtcl.code
       TrackBefMove.p.subcode = aPtcl.subcode
#endif

c             This is not used in m.f.p calculation from v7.
cc       TargetMassN = tmass
cc       TargetAtomicN = zchg
       FromEpics = .true.   !  don't use knock-on func in Cosmos
       end
c       ********************* reset some of the cond for Cosmos
       subroutine ep2cosCondr
        implicit none
#include "Zepi2cos.h"
        FromEpics =.false.
        end

c      **********************************
       subroutine ep2cosCond2(ia, iz)
       implicit none
#include "Zepi2cos.h"
       integer ia, iz  ! input. target nucleon number and Z

#ifdef  UNIONMAP
       MovedTrack.p = aPtcl
#else
       MovedTrack.p.fm = aPtcl.fm
       MovedTrack.p.charge = aPtcl.charge
       MovedTrack.p.mass = aPtcl.mass
       MovedTrack.p.code = aPtcl.code
       MovedTrack.p.subcode = aPtcl.subcode
#endif
c                 actually no track inf. needed
       TargetNucleonNo = ia
       TargetProtonNo =  iz
       end
c     ***************************
      subroutine eppushPtcl(cTrack)
c            push Cosmos made ptlcs in the stack area
      implicit none
#include "Zepi2cos.h"      
#define  PTCL
#include "ZepTrack.h"
#undef   PTCL
      record /epTrack/ cTrack  ! input. some track info is extracted
                              ! from here. interacting parent

      record /epTrack/ nTrack 
      real*8  p, sump2, adj

      integer i

      nTrack.pos.x = cTrack.pos.x
      nTrack.pos.y = cTrack.pos.y
      nTrack.pos.z = cTrack.pos.z
      nTrack.t = cTrack.t
      nTrack.user = cTrack.user
      nTrack.cn = cTrack.cn

      do i = 1, Nproduced
c/////////////
c         if(Pwork(i).code .ge. 3) then
c            write(0,*) ' code chg KE=',
c     *      Pwork(i).code, Pwork(i).charge,
c     *       Pwork(i).fm.p(4)-Pwork(i).mass
c         endif
c//////////////
         p = Pwork(i).fm.p(4)**2 - Pwork(i).mass**2
         if(p .le. 0.) then
            p = 0.
            Pwork(i).fm.p(4) = Pwork(i).mass
#ifdef SUBSTREC
            nTrack.p = Pwork(i)
#else
            call epsubptcl(Pwork(i), nTrack.p)
#endif
            nTrack.w.x = 0.
            nTrack.w.y = 0.
            nTrack.w.z = 1.
         else
            sump2 = Pwork(i).fm.p(1)**2
     *       +  Pwork(i).fm.p(2)**2
     *       +  Pwork(i).fm.p(3)**2
c            this may not be the same as p because, pi0<->pic
c            k0<->kch exchange to conserve total charge in Cosmos
c            ; because mass is changed. adjust it otherwise
c            direction cos may become inconsistent and
c            boundary error might happen
c
            adj = sqrt(p/sump2)
            Pwork(i).fm.p(1) =Pwork(i).fm.p(1)* adj
            Pwork(i).fm.p(2) =Pwork(i).fm.p(2)* adj
            Pwork(i).fm.p(3) =Pwork(i).fm.p(3)* adj
#ifdef SUBSTREC
            nTrack.p = Pwork(i)
#else
            call epsubptcl(Pwork(i), nTrack.p)
#endif
            p = sqrt(p)
            nTrack.w.x = Pwork(i).fm.p(1)  / p
            nTrack.w.y = Pwork(i).fm.p(2)  / p
            nTrack.w.z = Pwork(i).fm.p(3)  / p
         endif
         call eppush(nTrack)
      enddo
      end
c         for ibm
      subroutine epsubptcl(inp, out)
      implicit none
#include   "Zptcl.h"
      record /ptcl/ inp, out
      out = inp
      end

c           fix interaction type choosing the smallest path.
c           This is a modified version of cfixProc in Cosmos.
c           The difference is due to the atmosphere and other
c           constant density material  
      subroutine epfixProc(den, gramcm2, proc)
      implicit none
#include  "Zglobalc.h"
#include  "Ztrack.h"
#include  "Ztrackv.h"
      real*8  den     ! input.  denstiy g/cm^3
      real*8  gramcm2 ! output. path length in g/cm2
      character*8  proc ! output. process id characters

      real*8 len, minlen
c     
      integer i

c     
      minlen = Infty


      do i = 1, NumberOfInte
         if(.not. IntInfArray(i).decay) then
c              convert kg/m2 into length in m
c            IntInfArray(i).length = IntInfArray(i).thickness*0.1/den/100.
            len = IntInfArray(i).thickness*0.001d0/den
         else
            len = IntInfArray(i).length
         endif


         if(i .eq. 1 .or.  len .lt. minlen) then
               ProcessNo = i
               IntInfArray(i).length = len
               minlen = len
         endif
      enddo

      if(IntInfArray(ProcessNo).decay) then
         IntInfArray(ProcessNo).thickness =
c     *     IntInfArray(ProcessNo).length*100. * den*10. ! cm g/cm3*10-> kg/m2
     *      IntInfArray(ProcessNo).length*1000. * den   !  in kg/m2
      endif
      gramcm2 = IntInfArray(ProcessNo).thickness * 0.1   ! in g/cm2
      proc = IntInfArray(ProcessNo).process
      end
c     *********************************************
      subroutine epsampPtcl(aPtcl)
#include "Zptcl.h"
      integer fin
      record /ptcl/ aPtcl  ! output. E, code, subcode, mass, charge

      call csampPrimary(aPtcl, fin)
      

      end
c          dummy routine which will never used but is needed
c          to bypass the problem of unresolved external ref.
      subroutine chookTrace
      end

      subroutine epsmpNEPIntL(media)
      implicit none
#include  "Zglobalc.h"
#include  "Zcode.h"
#include  "Ztrackp.h"
#include  "Ztrack.h"
#include  "Ztrackv.h"
#include  "Zheavyp.h"
#include  "Zelemagp.h"
#include  "Zevhnp.h"
#include  "Zevhnv.h"
#include  "Zcmuint.h"
#include  "Zmedia.h"
c     **************************************************
c
      record /epmedia/ media  ! input.

      real*8 mfp, ek,  xs, et, mass


c        m.f.p (kg/m**2) = abn /xsec(mb)
c        parameter (aira=14.5, abogn=6.02e23, abn=aira*1.e28/abogn)
      real*8 abogn, toabn
      parameter (abogn=6.02d23, toabn=1.d28/abogn)
      real*8 collkgram, u, length
      real*8  eps/1.e-8/, smallxs/1.e-10/, largexs/1.e10/
      integer subcode, icon

      et = TrackBefMove.p.fm.p(4)
      mass = TrackBefMove.p.mass
      ek = max(et - mass, eps)    ! avoid 0 energy.


      call cdecayLeng(TrackBefMove, length)

      if(length .ne. Infty) then
         call csetIntInf(length, .true., 'decay')
      endif

      if( TrackBefMove.p.code .eq. kmuon) return   ! ****************

      call epgetxs(ActiveMdl, TrackBefMove.p, media, xs, mfp,  icon)
      if(icon .eq. 0) then
         call rndc(u)
         collkgram = -mfp*log(u)
      elseif(icon .eq. -1) then
         collkgram = Infty
      elseif(icon .eq. 1) then
         collkgram = 0.
      elseif(icon .eq. 2) then
c           heavy xs.  this case we directory obtain the
c        AA' cross-section. In case of gheisha and
c             A<=4, it has been treated already.
c
         write(0,*) ' we should not come here'
         write(0,*) ' proj. cod, Ee=',TrackBefMove.p.code,
     *    TrackBefMove.p.fm.p(4), ' media=',media.name
         stop
      endif
c  &&&&&&  confirmed o.k
c      write(*,*) ' media=',media.name, ' ek=',ek,' mfp=', mfp
c  &&&&
      call csetIntInf(collkgram, .false., 'coll')            
      end
