      subroutine epGetEffZA(media)
      implicit none
#include  "Zglobalc.h"
#include  "ZbasicCnst.h"
#include  "Zmedia.h"

      record /epmedia/media  ! input.  should contain basic media info. 
                           ! output. other info is computed here.

      integer i, nc, j
      real*8 sum, Lrad, Lradp, f, cs
c
c     &&&&&&&&&&&&&&&&&&&&&&&&&&         
c       some trial to get Zeff so that it (as a sigle virtual atom)
c       gives the same r.l obtained for complex material.
c       This gives almost the same Zeff as obtained in this prog.
c       (normally within 1 %).
c&      record /media/mediax
c&      common /Zmedia/ mediax
c&      real*8 newz
c&      integer icon
c&      real*8 epsolverl
c&      external epsolverl
c     &&&&&&&&&&&&&&&&&&&&&&&&&&&

      media.A = 0.
      media.Z = 0.
      media.Z2 = 0.
      nc = media.noOfElem
      sum = 0.
      do i = 1, nc
         sum = sum + media.No(i)
      enddo
c &&&&&&&&&& from  v7.0 we use normalized No(i).  and this leads to  the 
c      change of the  cross-section (in mb) (new one  is  old one / sum(old No)).
c      and also change of mbto* constant.  However, there is no change
c      in the sampling table and actual simuations.
c
      do i = 1, nc
         media.No(i) = media.No(i)/sum
      enddo
      sum = 0.
      do i = 1, nc
         media.A = media.A + media.No(i)* media.elem(i).A
         media.Z = media.Z + media.No(i)* media.elem(i).Z
         media.Z2 = media.Z2 + media.No(i)* media.elem(i).Z**2
      enddo

      do i = 1, nc
         media.w(i) = media.No(i)* media.elem(i).A/media.A
         media.npercm3(i) =N0/media.elem(i).A *media.w(i)*media.rho
      enddo

      sum = 0.
c
c         Since many of cross-sections depend primarily on
c         Z**2/A, we take effective Z**2/A first and  
c         multiply it by Aeff to get effective Z**2 and
c         further get effective Z by sqrt(Zeff**2)
c         For the cross-sections which depend on Z/A,
c         we use effective Z/A directly.
      sum = 0.
      do i =1, nc
         sum = sum + media.w(i)*media.elem(i).A
      enddo
      media.Aeff = sum
c         get effective Z**2/A
      sum = 0
      do i = 1, nc
         sum = sum + media.w(i)*media.elem(i).Z**2/
     *         media.elem(i).A
      enddo
      media.Z2byAeff = sum

      media.Z2eff = media.Z2byAeff * media.Aeff
      media.Zeff = sqrt(media.Z2eff)
c  &&&&&&&&&&&&&&&
c      write(*,*) ' meida.No', ( media.No(i), i=1,nc )
c      write(*,*) ' meida.w ', ( media.w(i), i=1,nc )
c      write(*,*) ' A,Z, Aeff, Zeff=', media.A, media.Z, media.Aeff,
c     *   media.Zeff
c &&&&&&&&&&&&&&&&
      media.LogZ = log(media.Zeff)
      media.Zeff3 = media.Zeff**(1.d0/3.d0)

      media.ZbyAeff = 0.
      do i = 1,nc
         media.ZbyAeff = media.ZbyAeff +
     *             media.w(i)*media.elem(i).Z/media.elem(i).A
      enddo
c            for photo electric effect
      sum = 0.
      do i = 1, nc
         sum = sum + 
     *        media.w(i)*media.elem(i).Z**5/media.elem(i).A
      enddo
      media.Z5byAeff = sum


c         compute radiation length X0g(g/cm2) and  X0 (cm)
      call epX0(media)
c         g/cm^2 to cm
      media.gtocm = media.X0/media.X0g

c           this may be used when summing each
c           element contribution
      media.mbtoPgrm = 1.d-27 *N0/media.A
      media.mbtoPcm =  media.mbtoPgrm * media.rho
      media.mbtoPX0 =  media.mbtoPgrm *media.X0g

c         <Z/A> must be used explicitly for crosssections with Z
      media.basearea = pir02 * media.ZbyAeff * N0*1.d-27 * media.X0g
c
c           this may be used when we approximate
c      a compound or molecule as one element
      media.mbtoPgrm2 = 1.d-27*N0/media.Aeff
      media.mbtoPcm2 =  media.mbtoPgrm2 * media.rho
      media.mbtoPX02 =  media.mbtoPgrm2 * media.X0g
c  &&&&&&&&&&&&&&&&&&&&&&&&
c        get Zeff for compound/molecule so that Zeff and Aeff as a
c        single atom gives  the same X0 as above.
c&      mediax = media
c&      write(*,*) ' X0=', media.X0, ' X0g=',media.X0g
c&      write(*,*) ' Zeff=',media.Zeff, ' Aeff=',media.Aeff
c&      call kbchop(epsolverl, 1.d0,  140.d0, 0.001d0, newz, icon)
c&       write(*,*) ' newz=',newz
c  &&&&&&&&&&&&&&&&&&&&&&&
c       ------------LPM -----------;
c        these are not atom base. but media base.
      media.s1 = (media.Zeff**(1.d0/3.d0)/183.0d0)**2
      media.logs1 = log(media.s1)
c       -----------complete screening cross-sec. coeff.

c        const used in the complete screening cross-sec.
c      f(y)dy ~dy (4/3(1-y)/y + y)C1 + (1-y)/y C2
c
      media.cScrC1 = 0.
      media.cScrC2 = 0.
c

      do i = 1, media.noOfElem
         call epGetLrad(media.elem(i).Z, Lrad, Lradp, f)
         media.cScrC1 =  media.cScrC1  + 
     *     ( media.elem(i).Z**2 *(Lrad-f) +
     *            media.elem(i).Z*Lradp) * media.No(i)
         media.cScrC2 = media.cScrC2  + 
     *      (media.elem(i).Z**2  + media.elem(i).Z)/9.d0
     *       * media.No(i)
      enddo
c       f(y) ~ (4/3C1+ C2)(1-y)/y + yC1; main term
      media.cScrMain = 4.*media.cScrC1/3.d0 + media.cScrC2
c          plasma energy in GeV
      media.wp = 28.816d-9 *sqrt(media.rho*media.Z/media.A)
c        no. of ingredient /cm^3
      media.nd = media.rho*N0/media.A
c
c           make cross-section table: for 10 mb to 100 mb
c
      media.ndensity = 1.d-27*media.rho*N0/media.A
      end
c   &&&&&&&&&&&&&&&&&&&&&&&&&
c&      real*8 function epsolverl(z)
c&      implicit none
c&#include  "Zmedia.h"
c&       real*8 z
c&       record /epmedia/ mediax
c&       common /Zmedia/ mediax
c&
c&       real*8 x0g
c&       call epX01(z, mediax.Aeff, x0g)
c&
c&       epsolverl = x0g/mediax.X0g -1.d0
c&       end
c  &&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&

       
