      real*8 function epCompScrPr(z, y)
c         complete screening cross-section by Tsai for pair creation.
      implicit none
#include "Zglobalc.h"
#include "ZbasicCnst.h"
      
      real*8 z ! input. atomic number of the media
      real*8 y ! input. Ee/Eg
c         output.  dsigma/dy in mb.

      real*8 Lrad, Lradp, z2, f

      real*8 zsave
      save f, zsave, Lrad, Lradp, z2
      data zsave /0./

      if(zsave .ne. z) then
         zsave = z
         call epGetLrad(z, Lrad, Lradp, f)
         z2 = z*z
      endif

      epCompScrPr = 4* ar02 * (
     *          (4./3.*y*y- 4./3.*y + 1) * (
     *            z2 * (Lrad-f) +  z*Lradp )
     *       -   y*(1-y)*(z2 + z)/9.)

      end

          

