c         test brmxxt etc
c*include $elmag
c         call elmgmd('g10 ', .true., 0)
c         ec=.1e-3
c         w=225.e-6
c         do 100 i=1, 601,100
c            e=3.01e-3 * 10.**( (i-1)*.01)
c            call pairt(e, t)
c           call bremst(e, ec, t)
c            do 20 j=1, 10000
c               call paire(e, e1)
c              call bremse(e,ec, e1)
c               write(13) e1/e
c   20      continue
c           write(13) 1.e50
c  100  continue
c        end
c*include brmgtt
c*include $epdef
c*include $elmag
c     *********************** gbremst ********************************
c     *                                                              *
c     *      brems and pair.          energy in gev. path in r.l     *
c     *                                                              *
c     *  bremst:  samples path for brems                             *
c     *  bremse:  samples energy of brems gamma                      *
c     *  pairt:   samples path for pair creation                     *
c     *  paire:   samples energy of pair electron (higher energy)    *
c     *  elmgmd:  specify the media                                  *
c     *                                                              *
c     ********************* tested 84.04.27 *********************k.k**
c
c
c   /usage/          call bremst(ee,ec,t)
c                    call bremse(ee,ec,beg)
c
c                    call pairt(eg,t)
c                    call paire(eg,e1)
c
c                    call elmgmd(matter, knocn, jput)
c
c      ee:  electron energy
c      ec:  cut-off energy of brems gamma
c       t:  sampled path
c     beg:  sampled gamma energy
c      eg:  gamma energy
c      e1:  sampled electron energy (higher energy in pair)
c
c   matter:  8 character data to specify the media.  such as
c           'pb', 'fe', 'w' 'air'.
c   jput:  if non 0, physical const such as x0, x0ing, ecrit
c          cconst are used as given in common,  else const defined
c          in each program are used.
c
c  *** note ***
c
c          to call bremse, or paire, bremst or pairt must have
c        been called.
c
c
c
      subroutine bremst(eein,ec,t)
       implicit none
c
c
#include  "Zelmag.h"
c
      external epblkemg

      character*8 mat
      logical Knckon
      real*8  eein, ec, t
      real*8 egin, bego, e1o

      real*8 abogn, abognr, ee, beg, eg, e1

      integer jput
c
      character*8 matter/'  '/
      parameter (abogn=6.022e23, abognr=abogn*1.e-27)
      character*99 msg
c
c
      ee=sngl(eein)
      if(matter .eq. 'pb') then
           call brmpbt(ee, ec, t)
      elseif(matter .eq. 'fe') then
           call brmfet(ee, ec, t)
      elseif(matter .eq. 'scin') then
           call brmsct(ee, ec, t)
      elseif(matter .eq. 'si') then
         call brmsit(ee,ec,t)
      elseif(matter .eq. 'bgo') then
         call brmbgot(ee, ec, t)
      elseif(matter .eq. 'csi') then
         call brmcst(ee,ec,t)
      elseif(matter .eq. 'h2o') then
         call brmH2Ot(ee,ec, t)
      elseif(matter .eq. 'c') then
         call brmCarbont(ee,ec, t)
      elseif(matter .eq. 'lixe') then
           call brmxet(ee, ec, t)
      elseif(matter .eq. 'liar') then
           call brmart(ee, ec, t)
      elseif(matter .eq. 'cu') then
           call brmcut(ee, ec, t)
      elseif(matter .eq. 'g10') then
         call brmgtt(ee, ec, t)
      elseif(matter .eq. 'air' .or. matter .eq. 'sp') then
           call brmAirt(ee, ec, t)
      elseif(matter .eq. 'g5') then
           call brmg5t(ee,ec,t)
      elseif(matter .eq. 'al') then
           call brmalt(ee,ec,t)
      elseif(matter .eq. 'w') then
           call brmwt(ee, ec, t)
      else
           write(msg,
     *    '('' matter='',a,'' not ready for brem and pair'')')
     *     matter
           call cerrorMsg(msg, 0)
      endif
      return
c
c     ************
      entry bremse(eein,ec,bego)
c     ************
c
c
      ee=eein
      if(matter .eq. 'pb') then
           call brmpbe(ee, ec, beg)
      elseif(matter .eq. 'fe') then
           call brmfee(ee, ec, beg)
      elseif(matter .eq. 'scin') then
           call brmsce(ee, ec, beg)
      elseif(matter .eq. 'si') then
         call brmsie(ee, ec, beg)
      elseif(matter .eq. 'bgo') then
         call brmbgoe(ee, ec, beg) 
      elseif(matter .eq. 'h2o') then
         call brmH2Oe(ee, ec, beg) 
      elseif(matter .eq. 'c') then
         call brmCarbone(ee, ec, beg) 
      elseif(matter .eq. 'csi')then
           call brmcse(ee, ec, beg)
      elseif(matter .eq. 'lixe') then
           call brmxee(ee, ec, beg)
      elseif(matter .eq. 'liar') then
           call brmare(ee, ec, beg)
      elseif(matter .eq. 'cu') then
           call brmcue(ee, ec, beg)
      elseif(matter .eq. 'g10') then
           call brmgte(ee, ec, beg)
      elseif(matter .eq. 'air' .or. matter .eq. 'sp') then
c           call brmAire(ee, ec, beg)
      elseif(matter .eq. 'g5') then
           call brmg5e(ee, ec, beg)
      elseif(matter .eq. 'al')then
           call brmale(ee, ec, beg)
      elseif(matter .eq. 'w') then
           call brmwe(ee, ec, beg)
      else
           write(msg,
     *     '('' matter='',a,'' not ready for brem and pair'')')
     *     matter
           call cerrorMsg(msg, 0)
      endif
      if( ee-beg .le. emass) then
          beg=ee-emass - 1.e-8
      endif
      bego=beg
      return
c
c
c
c     ***********
      entry pairt(egin,t)
c     ***********
c
c
      eg=sngl(egin)
      if(matter .eq. 'pb') then
           call prcpbt(eg, t)
      elseif(matter .eq. 'fe') then
           call prcfet(eg, t)
      elseif(matter .eq. 'scin') then
         call prcsct(eg, t)
      elseif(matter .eq. 'bgo') then
         call prcbgot(eg, t)
      elseif(matter .eq. 'si') then
           call prcsit(eg, t)
      elseif(matter .eq. 'csi' ) then
           call prccst(eg, t)
      elseif(matter .eq. 'h2o' ) then
           call prcH2Ot(eg, t)
      elseif(matter .eq. 'c' ) then
           call prcCarbont(eg, t)
      elseif(matter .eq. 'lixe') then
           call prcxet(eg, t)
      elseif(matter .eq. 'liar') then
c           call prcart(eg, t)
      elseif(matter .eq. 'cu') then
           call prccut(eg, t)
      elseif(matter .eq. 'g10') then
           call prcgtt(eg, t)
      elseif(matter .eq. 'air' .or. matter .eq. 'sp') then
c           call prcAirt(eg, t)
      elseif(matter .eq. 'g5') then
           call prcg5t(eg, t)
      elseif(matter .eq. 'al' ) then
           call prcalt(eg, t)
      elseif(matter .eq. 'w') then
           call prcwt(eg,  t)

      else
           write(msg,
     *     '('' matter='',a,'' not ready for brem and pair'')')
     *     matter
           call cerrorMsg(msg, 0)
      endif
      return
c
c     ***********
      entry paire(egin,e1o)
c     ***********
c
c
      eg=sngl(egin)
      if(matter .eq. 'pb') then
           call prcpbe(eg, e1)
      elseif(matter .eq. 'fe') then
           call prcfee(eg, e1)
      elseif(matter .eq. 'scin') then
         call prcsce(eg, e1)
      elseif(matter .eq. 'bgo') then
         call prcbgoe(eg, e1)
      elseif(matter .eq. 'csi' ) then
           call prccse(eg,  e1)
      elseif(matter .eq. 'h2o' ) then
           call prcH2Oe(eg,  e1)
      elseif(matter .eq. 'c' ) then
           call prcCarbone(eg,  e1)
      elseif(matter .eq. 'lixe') then
           call prcxee(eg,  e1)
      elseif(matter .eq. 'liar') then
c           call prcare(eg,  e1)
      elseif(matter .eq. 'si') then
           call prcsie(eg, e1)
      elseif(matter .eq. 'cu') then
           call prccue(eg, e1)
      elseif(matter .eq. 'g10') then
           call prcgte(eg, e1)
      elseif(matter .eq. 'air' .or. matter .eq. 'sp') then
c           call prcAire(eg, e1)
      elseif(matter .eq. 'g5') then
           call prcg5e(eg, e1)
      elseif(matter .eq. 'al' ) then
           call prcale(eg,  e1)
      elseif(matter .eq. 'w') then
           call prcwe(eg,  e1)
      else
           write(msg,
     *     '('' matter='',a,'' not ready for brem and pair'')')
     *     matter
           call cerrorMsg(msg, 0)
      endif
      if(e1 .lt. eg/2) then
         e1=eg/2
      elseif(eg-e1 .le. emass)then
         e1=eg-emass - 1.e-8
      endif
      e1o=e1
c
      return
c
c
c     ***********
      entry elmgmd(mat,Knckon, jput)
c     ***********
c
      matter=mat
      if(jput .eq. 0) then
          if(mat .eq. 'pb') then
             call emctpb(Knckon)
          elseif(mat .eq. 'fe') then
             call emctfe(Knckon)
          elseif(mat .eq. 'scin') then
             call emctsc(Knckon)
          elseif(mat .eq. 'si') then
             call emctsi(Knckon)
          elseif(mat .eq. 'bgo') then
             call emctbgo(Knckon)
          elseif(mat .eq. 'h2o') then
             call emctH2O(Knckon)
          elseif(mat .eq. 'c') then
             call emctCarbon(Knckon)
          elseif(mat .eq. 'liar') then
             call emctar(Knckon)
          elseif(mat .eq. 'cu') then
             call emctcu(Knckon)
          elseif(mat .eq. 'csi' ) then
             call emctcs(Knckon)
          elseif(mat .eq. 'g10') then
             call emctgt(Knckon)
          elseif(mat .eq. 'air' .or. matter .eq. 'sp') then
              call emctAir(Knckon)
              if(matter .eq. 'sp') then
                 rho = 1.205d-8
                 x0 = 3.d8
                 x0sq = x0*x0
              endif
          elseif(mat .eq. 'g5') then
             call emctg5(Knckon)
          elseif(mat .eq. 'al' ) then
             call emctal(Knckon)
          elseif(mat .eq. 'w') then
             call emctw(Knckon)
          elseif(mat .eq. 'lixe') then
             call emctxe(Knckon)
          else
             write(msg,'('' undefined matter='',a)') mat
             call cerrorMsg(msg, 0)
          endif
c             if ghmfp is devided by cross-section in mb
c             ===> m.f.p in r.l
          ghmfp=amassn/abognr/x0ing
c             to convert xs for gp into ga
          if(amassn .eq. 1.) then
             ashad=1.
          else
             ashad=amassn*.75
          endif
          zbya=zchrg/amassn
      endif
      end
c     ****************************************************************
c     *                                                              *
c     *   compton scattering in any matter. e in gev. length in r.l  *
c     *                                                              *
c     *  compt:  samples path for compton scattering                 *
c     *  compe:  samples energy of compton electron                  *
c     *  compa:  samples angle of compton scattering                 *
c     *                                                              *
c     ****************************************************************
c
c
c  /usage/
c              call compt(eg, t)
c              call compe(eg, eg1, ee)
c              call compa(cosg, cose)
c
c     eg:  gamma ray energy
c      t:  sampled path
c    eg1:  sampled gamma ray energy after scattering
c     ee:  sampled electron energy //
c   cosg:  cos of scattered gamma ray to the incident direction
c   cose:  cos of //        electron    //
c
c  *** note ***
c     before calling these, cconst must be fixed.
c     compe must be called after compt.
c     compa must be called after compe.
c
c
      subroutine compt(eg,t)
       implicit none
#include  "Zelmag.h"
       real*8 eg, t

       real*8 u, tp

      real*8  degcl, egc1, egc2, dugc, ugc1, ugc2
      integer negc,  nugc
c     -----------------------------------------------------------
c                              negc=log10(egc2/egc1)/degcl + 1(or 2)
      parameter (degcl=1./4., egc1=.1e-3, egc2=100.e-3, negc=13,
     * dugc=.05,
     * ugc1=0., ugc2=1., nugc=(ugc2-ugc1+.0001)/dugc+1)
c
      real*8 uec2( 273)
      real*8 eg1, ee1,  cosg, cose, egc1l, g, ale, v, vmin, vl, r
      real*8 u1, u2, vmin1, cose2
      integer i
      real*8 eg1sv, egsv
      save g, eg1sv, egsv
c     -----------------------------------------------------------
c
c         energy of gamma=
c       0.1000e-03  0.1778e-03  0.3162e-03  0.5623e-03  0.1000e-02
c       0.1778e-02  0.3162e-02  0.5623e-02  0.1000e-01  0.1778e-01
c       0.3162e-01  0.5623e-01  0.1000
c         log10 step= 0.250000
c         log10 gamma energy boundary
      data egc1l/-4.000000/
c    *                     , egc2l/-1.000000/
c
c
c
c           uec2(j,i)=v
c           from u= 0.0    to 1.0000 step= 0.0500
c           from log10(e)=-4.000000 to -1.000000 step=  0.2500
c           dim. of u and e=  21  13
c

c
      data ( uec2 (i),i=   1,  72)/
     11.00000,0.99009,0.97964,0.96857,0.95682,0.94425,0.93084,0.91642,
     20.90093,0.88431,0.86665,0.84820,0.82950,0.81116,0.79387,0.77792,
     30.76352,0.75053,0.73882,0.72829,0.71871,1.00000,0.98497,0.96924,
     40.95273,0.93534,0.91696,0.89746,0.87669,0.85452,0.83090,0.80582,
     50.77949,0.75244,0.72556,0.69981,0.67600,0.65451,0.63534,0.61836,
     60.60317,0.58962,1.00000,0.97812,0.95540,0.93178,0.90712,0.88133,
     70.85427,0.82579,0.79576,0.76412,0.73086,0.69617,0.66060,0.62509,
     80.59087,0.55913,0.53059,0.50537,0.48329,0.46393,0.44689,1.00000,
     90.96921,0.93753,0.90486,0.87112,0.83620,0.80003,0.76251,0.72360/
      data ( uec2 (i),i=  73, 144)/
     10.68332,0.64179,0.59937,0.55672,0.51485,0.47502,0.43839,0.40568,
     20.37708,0.35232,0.33094,0.31241,1.00000,0.95813,0.91535,0.87163,
     30.82694,0.78128,0.73469,0.68723,0.63906,0.59044,0.54182,0.49379,
     40.44721,0.40304,0.36225,0.32555,0.29328,0.26536,0.24144,0.22100,
     50.20350,1.00000,0.94505,0.88931,0.83286,0.77585,0.71848,0.66103,
     60.60387,0.54751,0.49255,0.43969,0.38971,0.34333,0.30117,0.26360,
     70.23071,0.20235,0.17816,0.15764,0.14030,0.12563,1.00000,0.93057,
     80.86061,0.79048,0.72063,0.65161,0.58413,0.51898,0.45699,0.39899,
     90.34567,0.29753,0.25483,0.21755,0.18545,0.15812,0.13505,0.11569/
      data ( uec2 (i),i= 145, 216)/
     10.09951,0.08601,0.07476,1.00000,0.91535,0.83063,0.74661,0.66425,
     20.58466,0.50905,0.43859,0.37423,0.31664,0.26606,0.22238,0.18519,
     30.15388,0.12775,0.10608,0.08821,0.07351,0.06145,0.05156,0.04346,
     41.00000,0.89991,0.80040,0.70286,0.60896,0.52053,0.43925,0.36642,
     50.30270,0.24816,0.20228,0.16422,0.13298,0.10753,0.08691,0.07026,
     60.05685,0.04608,0.03743,0.03048,0.02491,1.00000,0.88457,0.77054,
     70.66017,0.55610,0.46087,0.37646,0.30386,0.24304,0.19312,0.15276,
     80.12049,0.09487,0.07463,0.05870,0.04617,0.03634,0.02864,0.02260,
     90.01787,0.01416,1.00000,0.86945,0.74131,0.61901,0.50627,0.40635/
      data ( uec2 (i),i= 217, 273)/
     10.32111,0.25081,0.19430,0.14971,0.11497,0.08811,0.06745,0.05160,
     20.03948,0.03020,0.02312,0.01771,0.01358,0.01042,0.00801,1.00000,
     30.85457,0.71280,0.57951,0.45972,0.35710,0.27298,0.20639,0.15494,
     40.11583,0.08638,0.06432,0.04786,0.03560,0.02648,0.01970,0.01466,
     50.01091,0.00813,0.00606,0.00452,1.00000,0.83992,0.68497,0.54172,
     60.41646,0.31297,0.23148,0.16950,0.12338,0.08952,0.06483,0.04691,
     70.03393,0.02453,0.01774,0.01283,0.00928,0.00671,0.00486,0.00352,
     80.00255/
c
c


c
c
c
      equivalence (tprob,tp)
c

c
c
c         total cross-section of compton scattering /(radiation length)
c
c             tp* 3/8 /cconst= total cross section normalized
c             by thomson cross section.
c             cconst=3/8  * thomson * n0 * z/a * x0ing
c
      egsv = eg
c
      g  =eg/emass
      if(g .lt. .1) then
          tp=(  (5.2*g-2.)*g +1. )*2.66666*cconst
      else
          tp=(  (1. - (g+1.)*2/g**2)*log(g*2+1.) + .5 + 4./g -
     *        1./(g*2+1.)**2/2 ) /g * cconst
      endif
c
      call rndc(u)
      t= - log(u)/tp
      return
c
c
c
c
c
c     ***********
      entry compe(eg,eg1,ee1)
c     ***********
c
c
c        give phton and electron energy
c
c
      if(eg .le. egc2 .and. eg .ge. egc1) then
          ale=log10(eg)
          call rndc(u)
c         v=tdint4(uec2, nugc, negc, ugc1, egc1l, dugc, degcl, u, ale)
          call k4ptdi(uec2, nugc, negc, nugc, ugc1, egc1l,
     *    dugc, degcl, u, ale, v)
      elseif(eg .gt. egc2) then
c           very high energy.  vmin=small
c           use (v + 1/v) dv  from vmin to 1
          vmin=1./(g*2+1.)
c           fix v or 1/v
          vl=log(vmin)
          r=.5/( .5 -vl )
          call rndc(u)
          if(u .lt. r) then
               call rndc(u1)
               call rndc(u2)
               if(u1 .gt. u2) then
                   v=u1
               else
                   v=u2
               endif
               if(v .lt. vmin) then
                   v=vmin
               endif
          else
               call rndc(u)
               v=exp(u*vl)
          endif
      else
c              very small energy; use v at egc1 and compress it
          call rndc(u)
c         v=tdint4(uec2, nugc, negc, ugc1, egc1l, dugc, degcl, u, egc1l)
          call k4ptdi(uec2, nugc, negc, nugc, ugc1, egc1l,
     *    dugc, degcl, u, egc1l,  v)
          vmin1= 1./(1. + egc1/emass*2)
          vmin=1./(g*2+1.)
          v=(1.-v)/(1.-vmin1)*(vmin-1.) + 1.
      endif
      eg1=eg*v
      ee1 = eg - eg1 + emass
      eg1sv = eg1
      return
c
c     ***********
      entry compa(cosg,cose)
c     ***********
c
c        give cos of phton and electron
c
      cosg=(1.d0/egsv - 1.d0/eg1sv) * emass + 1.d0
c           tan(el)=cot(gm/2)/(1+g);
c           cot(t/2)=  +-sqrt( (1+cos(t))/(1-cos(t)) ) so that
      cose2=(1.d0-cosg) / (  1.d0-cosg +(1.d0+cosg)/(1.d0+g)**2 )
c           electron angle is always 0 to 90 deg.
      cose=sqrt(cose2)
      return
      end
