	subroutine epUrban(avededx, dx, erg, mass, de)
	implicit none
#include "Zurban.h"
c    By using Urban model, energy loss is calculated with 
c    full fluctuation; this is consistent with Landau/Vavilov/Gaussina
c    theory if the all delta ray is taken into account.  
c    ***************
c   This must be called after epUrban0 has been called to fix the 
c   medium.
c    ***************

c
	real*8 avededx  ! input. average dE/dx in GeV/cm.
	real*8 dx       ! input. pass lengnth in cm for which energy loss
                        !        is to be sampled.
        real*8 erg      ! input. total energy of the charged particle in GeV.
	real*8 mass     ! input. mass of the particle in GeV.
	real*8 de       ! output. sampled energy loss for pass dx in GeV.
              
	real*8 gamma, beta2, gbeta2
        integer i
        real*8 mgb2
c
	if(erg -mass .le. 1.d-6 .or. dx .le. 0.) then
	   de = 0.
	else
	   gamma = erg/mass
	   beta2 = 1.0d0 - 1./gamma**2
	   gbeta2 = gamma**2 * beta2
	   mgb2 = mass*gbeta2 * 2

	   do i = 1, 2
	      MacroSigma(i) = avededx* OscStr(i)/ExcitErg(i) * 
     *        (  log(mgb2/ExcitErg(i)) - beta2 ) /
     *       (  log(mgb2/AveIoniz   ) - beta2 )  * (1.-ExToIoniz)
	   enddo
	   MacroSigma(3) = avededx * PreSigma3
	   do i = 1, 3
	      AveN(i) = MacroSigma(i) * dx
	   enddo	
c             GEANT considers the very thin case specially
c            (like epUrbanThin below), but this seems no good.
c             We don't use such version.
c	if(AveN(1)+ AveN(2) + AveN(3) .lt. 4.6) then
c               ! no energy loss probability is > 0.01. treat specially
c      	   call epUrbanThin(avededx*dx)
c        else
           call epUrbanNorm
c        endif
	   de = ElossTotal
	endif
        end 
c       ------------------------------------------------
        subroutine epUrbanThin(avede)
	implicit none
#include "Zurban.h"
	real*8 avede  ! input. <dE/dX> *dX
c          very thin pass case.
c          interaction is assumed to be with outer electrons only.
c          Their energy level is 10 eV.
        integer i
	real*8 u
c
	AveNThin = avede/EOuter
	call kpoisn(AveNThin, NThin)
	ElossTotal = 0.
	do i = 1, NThin
	   call rndc(u)	
	   ElossTotal = ElossTotal + EOuter/
     *         (1. - u*Emax/(Emax + EOuter))
        enddo
        end
c       --------------------------
        subroutine epUrbanNorm
	implicit none
#include "Zurban.h"
	integer i
	real*8 u, logAlfa, temp


c          sample actual number of excitation and ionization.
        do i = 1, 3
   	    call kpoisn(AveN(i), Ncoll(i))
c ////////////
c	    write(0, *) ' Ncoll(i)=', Ncoll(i)
c ////////////
        enddo
c         energy loss due to exciteation.
        ElossByExcit = Ncoll(1) * ExcitErg(1)  +  
     *               Ncoll(2) * ExcitErg(2)
c ///////////
c	write(0,*) ' ElossByExcit=', ElossByExcit
c //////////

c          now loss by ionization.
        if(Ncoll(3) .lt. LargeN3) then
	    ElossByIoniz = 0.
	    do i = 1, Ncoll(3)
	        call rndc(u)
     	        ElossByIoniz  = ElossByIoniz +
     *          AveIoniz/(1.0 - u *EmaxByEmaxI)
	    enddo
c //////////////
c	    write(0,*) ' ElossByIoniz=', ElossByIoniz
c ///////////
        else
            Alfa = (Ncoll(3) + Smallc2)*EmaxI/
     *       (Smallc2*EmaxI+ Ncoll(3)*AveIoniz)

            logAlfa = log(Alfa)

            PAtype = EmaxI*(Alfa-1.)/Emax/Alfa

            AveElossAtype = AveIoniz *Alfa *logAlfa/(Alfa -1.0)

            SigmaElossA2 = AveIoniz2 * Alfa *
     *        (1. - Alfa* (logAlfa/(Alfa-1.0))**2 )

c             average number of A type col.
            AveAtype = Ncoll(3) * PAtype
            SigmaAtype = sqrt(max(AveAtype * (1.0d0 - PAtype), 0.d0) )
c            sample number of Atype from poisson
c            call kpoisn(AveAtype, NAtype)
            call kgauss(AveAtype, SigmaAtype, temp)
	    NAtype =max( temp + 0.5d0, 0.d0)
c             average energy loss by NAtype coll.
	    AveElossByNAtype = NAtype * AveElossAtype
            SigmaByNAtype = sqrt(NAtype * SigmaElossA2)
c              sample from Gaussian
            call kgauss(AveElossByNAtype, SigmaByNAtype, ElossByAtype)
	
            ElossByBtype = 0.
	    NBtype = Ncoll(3) - NAtype 
	    do i = 1, NBtype
	       call rndc(u)
	       ElossByBtype = ElossByBtype + 
     *         Alfa*AveIoniz / 
     *         ( 1.0 - u *(EmaxI - Alfa*AveIoniz)/EmaxI)
            enddo
            ElossByIoniz = ElossByAtype + ElossByBtype
        endif
	ElossTotal = ElossByExcit + ElossByIoniz
        end


        subroutine epUrban0(edelta, avez, avez2, ionizP)
        implicit none
#include "Zurban.h"
c         Whenever medium is chaged, this must be called before
c         epUrban is called.
c
        real*8 edelta  ! input. cut off energy above which delta ray production
                       !        is explicitly treated.
        real*8 avez    ! input. average Z of the medium.  avez= 
                       !        niZi/sum(ni)  
              	       !     where  ni the number of charge Zi's element.
        real*8 avez2   ! input. effective average Z of the medium.
	real*8 ionizP  ! input. average inonization potential. may be
        	       !        approximated by 16Z**0.9 eV, but
            	       !        kexpot will give an accuate value.
c
        LargeN3 = 16
	ExToIoniz = 0.4
        EOuter = 10.d-9   ! 10 eV for outer electron ionization

        Zeff = avez
	AveIoniz = ionizP
	AveIoniz2 = AveIoniz**2
	Emax = edelta
	EmaxI = Emax + AveIoniz
	IEmaxI = AveIoniz * EmaxI
	EmaxByEmaxI = Emax/EmaxI

	Smallc2 = LargeN3

	PreSigma3 = EmaxByEmaxI/ ( AveIoniz * log(EmaxI/AveIoniz) )
     *    * ExToIoniz
	if(Zeff .le. 2.) then
	    OscStr(2) = 0.
	else	
	    OscStr(2) = 2./Zeff
        endif
	OscStr(1) = 1. - OscStr(2)
        ExcitErg(2) = 10.d-9 * avez2  ! approx K-shell energy in GeV.
        ExcitErg(1) = 
     *   (AveIoniz/ExcitErg(2)**OscStr(2))**(1./OscStr(1))
c /////////////
c	write(0, *) ' ExcitErg1,2=', ExcitErg(1), ExcitErg(2)
c //////////
        end
