c     implicit none
c     real*8 e, dedt
c     integer i
c     call dedxi('pb  ', 225.d-6,  .true.)
c     do 100 i=1, 300
c        e=1.e-9*10.**( (i-1) /20.)
c        call dedx(e+.511d-3,-1, dedt)
c        write(*, *)sngl(e), sngl(dedt)
c 100  continue
c      end
c     ****************************************************************
c     *                                                              *
c     * dedx:  gives -de/dx  (gev/(g/cm2)           of electrons     *
c     *        if knock-on process is not to be included,            *
c     *        -de/dx by sternheimer is computed else                *
c     *        -de/dx by sternheimer - (-de/dx(recoil k.e > w) )     *
c     *        is computed.                                          *
c     *   ********** use prededx for making const *******
c     *                                                              *
c     ************************ tested 87.09.19 ********************k.k
c
c /usage/  call dedx(e, ic, dedt)
c          call dedxi(matter, w, Knckon)
c -- input--
c        e: total energy of electron in gev
c       ic: charge. -1 if electron. 1 if positron
c   matter: 4byte character to specify the media. 'pb  ', 'si  ' etc
c        w: kinetic energy of recoil electron in gev.  k.e>w is not
c           included as energy loss so that it should be treated by
c           producing the recoil electron actually.  (usually, w=.255e-3
c           will be better.
c   Knckon: if t, knock-on process is considered for energy > w
c           so that only knock-on electrons of energy < w is
c           included in energy loss.  if f, all knockon electrons
c           are considred as energy loss.
c
c        recomended critical energy
c               w=.25 mev      if no knock-on considred
c   pb          5.8   mev          7.2
c    w          6.3                7.7
c   fe         17.0               20.0
c   si         30.0               37.0
c   g5         13.1               15.0
c  air         70                 70.
c  lixe(liq ze) 9.5               10.0
c  scinti      74.                80.
c  liar        27.1               34.
c -- output --
c     dedt; energy loss /(g/cm2) (gev)
c
c  *** note ***
c      before calling this, dedxi must have been called.
c
c
c
      subroutine dedx(eini, ic, dedt)
       implicit none
c
c$$$$$$$$$$$$$$$$$$$$$
c         common /$$$/ $d
c$$$$$$$$$$$$$$$$$$
c
#include  "Zdedx.h"
c
      real*8 eini, dedt
      integer ic
      external epblkde

      real*8 emass, emassg
      real*8 ek, ein, e, gi, Beta2, x, a, b, c, cb, x0, x1
      real*8 dltx, wm, wlg
c
      data emass/.511/, emassg/.511e-3/

c
           ek=eini-emassg
           ein=eini
         if(jdef(midx) .ne.0 .and.  ek .le. peake(midx)) then
              dedt=peak(midx)*sqrt(ek/peake(midx))
         else
c                  energy in mev unit
              e=ein*1000
              gi=emass/e
              Beta2= 1. - gi**2
c                  x=log10(p/mc)
              x=log10(e**2 - .2611)/2 + .29
              a=stha(midx)
              b=sthb(midx)
              c=sthc(midx)
              cb=-c
              x0=sthx0(midx)
              x1=sthx1(midx)
              if(x .lt. x0) then
c                    4.605x - dlt
                  dltx=4.605*x
              elseif(x .lt. x1) then
                  dltx=cb - (x1-x)**3 * sthsa(midx)
              else
                  dltx=cb
              endif
c$$$$$$$$$$$$$$$$$$$
c             if($d .eq. 0.) then
c                 dltx=4.605*x
c             endif
c$$$$$$$$$$$$$$$$
              wm=e- emass
              if(Knckon) then
                   if(wm .gt. w0) then
                       wlg=wlg0
                   else
                       wlg=log(wm)
                   endif
              else
                   wlg=log(wm)
              endif
              if(ic .eq. -1) then
                  dedt=a/Beta2 * (b + 1.12+wlg-Beta2 +dltx)
              else
                  dedt=a/Beta2 *( b+.693+wlg -2*Beta2 + dltx)
              endif
c                            convert it to gev/(g/cm2)
              dedt=dedt *1.e-3
          endif
c^^^       endif
        end
c
c      ***********
       subroutine dedxi(matter, w0in,  knck)
       implicit none
c      ***********
c
#include  "Zdedx.h"
      logical knck
      character*(*) matter
      real*8  w0in
      
      real*8 etemp, dedto, e, dedt
      integer i
      character*80 msg
      external epblkde
c
          midx=0
          w0=w0in
          Knckon=knck

c          *** until loop*** 
          do while (.true.)

              midx=midx+1
              if(midx .gt. nm) then
                  write(msg, '('' matter='',a8,
     *           '' not defiend in dedxi'')') matter
                  call cerrorMsg(msg, 0)
              endif
          if         (matter .eq. med(midx))
     *                       goto 100
          enddo
  100     continue
c              log(w*1000.)
          wlg0=log(w0) + 6.907

        if(jdef(midx) .eq. 0) then
          dedto=-1.e37
           do   i=1, 300
             e=1.e-9*10.**( (i-1) /20.)
             etemp=e+.511e-3
             call dedx(etemp,     1, dedt)
             if(dedt .lt. dedto .and. dedt .gt. 0.) then
                   peak(midx)=dedt
                   peake(midx)=e
                   goto 201
             else
                   dedto=dedt
             endif
           enddo
  201     continue
c         do 300 i=1, 8
c            etemp=e/ (4.0**(1./i)) + .511e-3
c            call dedx(etemp, 1, dedt)
c            if(dedt .gt. 0.) goto 301
c 300     continue
c         write(*,*) ' : peak=',peak(midx), ' at ',peake(midx)
c         etemp=e+.511e-3
c         dedt=peak(midx)
c 301     continue
c         peak(midx)=dedt
c         peake(midx)=etemp - .511e-3
          jdef(midx)=1
        endif
c         write(*,*) ' peak=',peak(midx), ' at ',peake(midx)
      end

