c      implicit none
c      external epblkde
c      real*8 etemp, amass, dedt, e, w0in
c      integer i
c      logical knock
c      w0in = 1.d
c      knock = .true.
c      call dedxi( 'pb', w0in, knock)
c      call dedx2i('pb')
c      amass=    105.659e-3
cc     amass=    938.659e-3
c      do 100 i=1, 200
c         e=      1.e-6* 10.**((i-1)/20.0)
c         etemp=e+amass
c         call dedx2(etemp,   amass, dedt)
c         write(*,*) sngl(e), sngl(dedt)
c 100  continue
c       end
c     ****************************************************************
c     *                                                              *
c     * dedx2: gives -de/dx  (gev/(g/cm2)) of non e+/e-
c     *                                                              *
c     ************************ tested 87.09.19 ********************k.k
c
c /usage/  call dedx2(e,amass, dedt)  ! must be called after dedx2i
c          call dedx2i(matter)  ! must be called after dedxi
c -- input--
c        e: total energy of ptcl     in gev
c    amass: mass in gev
c   matter: 4byte character to specify the media. 'pb  ', 'si  ' etc

c -- output --
c     dedt; energy loss / (g/cm2) in gev unit.
c
c  *** note ***
c      before calling this, dedx2i must have been called.
c
c
c
      subroutine dedx2(eini, amassi, dedt)
       implicit none
c
c
#include  "Zdedx.h"
c
      real*8 eini, amassi, dedt
c      real*8 w
c      logical knockon
c
      real*8 etemp, ek, dedtp
c
         ek=eini-amassi
c              peak kinetic energy shift with mass
         if(jdef2(midx) .ne. 0 .and.
     *          ek .le. peak2e(midx)*amassi/105.6e-3 ) then
              if(abs(amassi-105.6e-3) .lt. 1.e-3) then
                  dedt=peak2(midx)*sqrt(ek/peak2e(midx))
              else
                  etemp=peak2e(midx)*amassi/105.6e-3+amassi
                  call dedx2a(etemp, amassi, dedtp)
                  dedt=dedtp*sqrt(ek/(etemp-amassi))
              endif
         else
              call dedx2a(eini, amassi, dedt)
         endif
      end
c
      subroutine dedx2a(eini, amassi, dedt)
       implicit none
c
c
#include  "Zdedx.h"
c
      real*8 eini, amassi, dedt

      real*8 emass, emass2
      parameter(emass=.511, emass2=emass**2)
      real*8  e, amass, ein, gi, Beta2, x, a, b, c, cb, x0
      real*8 dltx, p2, wm, wlg,  x1
c
           ein=eini
c
c                  energy in mev unit
          e=ein*1000.
          amass=amassi*1000.
          gi=amass/e
          if(gi .ge. 1.) then
              dedt=.01
          else
            Beta2= 1. - gi**2
c                x=log10(p/mc)
            x=log10((e/amass)**2 - 1.) / 2
            a=stha(midx)
            b=sthb(midx)
            c=sthc(midx)
            cb=-c
            x0=sthx0(midx)
            x1=sthx1(midx)
            if(x .lt. x0) then
c                  4.605x - dlt
                dltx=4.605*x
            elseif(x .lt. x1) then
                dltx=cb - (x1-x)**3 * sthsa(midx)
            else
                dltx=cb
            endif
            p2=e**2 -amass**2
            wm=2*emass*p2/( amass**2+ emass2+ emass*e*2)
            if(Knckon) then
               if(wm .gt. w0) then
                  wlg=wlg0
               else
                  wlg=log(wm)
               endif
            else
               wlg=log(wm)
            endif

            dedt=a/Beta2 *( b+.693+wlg -2*Beta2 + dltx)
        endif
        dedt=dedt *1.e-3
       end
c
c      ***********
       subroutine dedx2i(matter)
       implicit none
c      ***********
#include  "Zdedx.h"
      character*(*) matter
c
      real*8 etemp, e, amass, dedto, dedt

      integer i
      character*80 msg

          midx=0

c          *** until loop*** 
          do while (.true.)
              midx=midx+1
              if(midx .gt. nm) then
                  write(msg, '('' matter='',a4,
     *           '' not defiend in dedx2i'')') matter
                  call cerrorMsg(msg, 0)
              endif
          if         (matter .eq. med(midx))
     *                       goto 100
          enddo
  100     continue
c

          if(jdef2(midx) .eq. 0) then
              dedto=-1.e37
c                  take mass as 105 mev tentatively.
              amass=    105.659e-3
               do   i=1, 300
                 e=1.e-9*10.**( (i-1) /20.)
                 etemp=e+amass
                 call dedx2(etemp, amass,   dedt)
                 if(dedt .lt. dedto .and. dedt .gt. 0.) then
                       peak2(midx)=dedt
                       peak2e(midx)=e
                       goto 201
                 else
                       dedto=dedt
                 endif
               enddo
  201        continue
              do   i=1, 4
                etemp=e/ (2.0**(1./i)) + amass
                call dedx2(etemp,amass, dedt)
                if(dedt .gt. 0.) goto 301
              enddo
             write(msg, *) ' : peak=',peak2(midx), ' at ',peak2e(midx)
             call cerrorMsg(msg, 0)
             etemp=e+amass
             dedt=peak2(midx)
  301        continue
             peak2(midx)=dedt
             peak2e(midx)=etemp - amass
             jdef2(midx)=1
         endif
c        write(*,*) ' peak2=',peak2(midx), ' at ',peak2e(midx)
      end
