c     ************************ for si*********************************
c     *                                                              *
c     *  brmsit:  samples path for brems                             *
c     *  brmsie:  samples energy of brems gamma                      *
c     *  prcsit:  samples path for pair creation                     *
c     *  prcsie:  samples energy of pair electron (higher energy)    *
c     *  emctsi:  set const in common for si                         *
c     *                                                              *
c     *********************** tested          ********************k.k*
c
c      material   z     a     rho     t0 (g/cm2)  t0 (cm)    ec
c         si      14   28.09  2.42    21.73        8.98      30.0
c                                 (n)
c brems:
c        electron energy:      1mev to 50 gev
c        brems gamma energy:   .1mev or more
c           if electron energy is < 1mev,  sampled path is set to be
c        very large one so that real brems may not take place before
c        the death by energy loss.
c pair:
c        gamma energy:         3mev to 100gev
c           if gamma energy is < 3mev, sampled path is set to be
c        very large one so that real pair creation may not take place
c        before compton or another process takes place.
c
c
c
c
c   /usage/          call brmsit(ee,ec,t)
c                    call brmsie(ee,ec,beg)
c
c                    call prcsit(eg,t)
c                    call prcsie(eg,e1)
c
c      ee:  incident electron energy
c      ec:  cut-off energy of brems gamma (used if complete screening
c           cross section is to be used).
c       t:  sampled path
c     beg:  sampled gamma energy
c      eg:  incident gamma energy
c      e1:  sampled electron energy (higher energy in pair)
c
c  *** note ***
c
c          before calling brmsie, brmsit must have been called.
c          //             prcsie, prcsit //
c
c          by the parameters in $elmag the user can control:
c
c        ee  --------------10gev------->  (if usees=t, escb instead 10
c     scorec=t       p.s    !
c     lcorec=t              !    l.c
c     scorec=f       c.s    !
c     lcorec=f              !    c.s
c
c        eg  --------------50gev-- tev---> (if usees=t, escp instead 50)
c     scorec=t       p.s    ! c.s !
c     lcorec=t              ! c.s ! l.c
c     scorec=f       c.s    ! c.s !
c     lcorec=f              !     ! c.s
c
c
c
c
      subroutine brmsit(ee,ec,t)
       implicit none
c
c
#include  "Zelmag.h"
#include  "Zemdef.h"
c
c
      integer i
      logical screen,landau
c
c
c
c ------------------------- partical screening ----------------------
c           *** electron ***
c
c           ! egmin (gev)  for brems.
      data egmnl/.1e-3/
c
      parameter (eblmin=1.e-3, eblmax=50.,  nbtcl=15)
      dimension tcbl(nbtcl)
c
c             brem:   region a
c
      parameter (eela1=eblmin, eela2=eblmax,neela=15,
     * uela1=.05, uela2=1., nuela=16, duela=(uela2-uela1)/(nuela-1) )
      dimension bla(nuela *neela)
c
c             brem:  region b  (sqrt(u))
      parameter (eelb1=eblmin, eelb2=eblmax, neelb=neela,
     * uelb1=0.,  uelb2=.2236068, nuelb=16,
     * duelb=(uelb2-uelb1)/(nuelb-1) )
      dimension blb(nuelb* neelb)
c           ** gamma ***
c
c                 total cross-section
      parameter (eplmin=3.e-3, eplmax=100., nptcl=16)
      dimension tcpl(nptcl)
c
c          pair: region a
      parameter ( egla1=eplmin,  egla2=eplmax, negla=16,
     *   ugla1=.05, ugla2=1., nugla=16,dugla=(ugla2-ugla1)/(nugla-1) )
      dimension pla(nugla* negla)
c
c            pair: region b     sqrt(log10(e)) sqrt(u)
      parameter (eglb1=eplmin, eglb2=eplmax, neglb=11,
     *  uglb1=0., uglb2=.2236068, nuglb=16,
     *  duglb=(uglb2-uglb1)/(nuglb-1))
      dimension plb(nuglb* neglb)
c
c
c      -------------------- landau ------------------------------
c not to be used now
c          **** electron ****
c
      data egmnh/1.e-3/
c     parameter ( eeh1=5., eeh2=300.e3, neeh=16,dueh1=.1,
c    *  ueh1=0., ueh2=.7, nueh1=(ueh2-ueh1+.00001)/dueh1+1)
c                       ! pass landau case
      parameter ( eeh1=1.e7, eeh2=300.e3, neeh=16,dueh1=.1,
     *  ueh1=0., ueh2=.7, nueh1=(ueh2-ueh1+.00001)/dueh1+1)
      dimension  tcbh(neeh)
      dimension  be1(nueh1* neeh)
c
c                         sqrt(1-.7)
      parameter (ueh3=0., ueh4=0.5477225,
     *nueh2=11, dvueh2=nueh2-1, dueh2=(ueh4 - ueh3)/dvueh2)
      dimension be2(nueh2*neeh)
c
c
c         *** gamma ****
c
      parameter ( egh1=5000., egh2=300.e3,negh=7, dugh2=.1,
     * ugh3=0., ugh4=1., nugh2=(ugh4-ugh3+.00001)/dugh2+1)
      dimension tcph(negh)
      dimension vp(nugh2 *negh)
c
c
c     ---------------------------------------------------------
      data debtcl/ 0.335641/
      data deela/ 0.335641/
      data deelb/ 0.335641/
      data deptcl/ 0.301525/
      data degla/ 0.301525/
      data deglb/ 0.212671/
c        electron energy=
c      0.10000e-02 0.21659e-02 0.46912e-02 0.10161e-01 0.22007e-01
c      0.47665e-01 0.10324     0.22361     0.48431      1.0490
c       2.2720      4.9209      10.658      23.085      50.000
c       log10 step=  0.3356
c
c      log10 of electron energy boundary
      data  etcbl1/-3.000000/
c    *     ,etcbl2/ 1.698970/
c
      data (tcbl  (i),i=   1,  15)/
     1 1.2077, 2.4577, 3.7166, 4.9505, 6.1457, 7.3025, 8.4264, 9.5241,
     210.6027,11.6683,12.7261,13.7790,14.8291,15.8777,16.9257/
c
c       brem: region a
c        electron energy=
c      0.10000e-02 0.21659e-02 0.46912e-02 0.10161e-01 0.22007e-01
c      0.47665e-01 0.10324     0.22361     0.48431      1.0490
c       2.2720      4.9209      10.658      23.085      50.000
c       log10 step=  0.3356
c
c      log10 of electron energy boundary
      data  eela1l/-3.000000/
c    *     ,eela2l/ 1.698970/
c
c
c            bla(iu,ie)=log(v/vmin)/(1.-u)
c            u=0.050 to 1.000 step= 0.0633
c            log10(e)= -3.0000 to   1.6990 step= 0.3356
c
      data (bla   (i),i=   1,  72)/
     1 1.4837, 1.3980, 1.3354, 1.2858, 1.2448, 1.2100, 1.1796, 1.1526,
     2 1.1286, 1.1071, 1.0873, 1.0691, 1.0524, 1.0368, 1.0221, 1.0094,
     3 2.4969, 2.3291, 2.2187, 2.1363, 2.0706, 2.0162, 1.9710, 1.9336,
     4 1.8988, 1.8678, 1.8404, 1.8190, 1.7997, 1.7821, 1.7673, 1.7522,
     5 3.3652, 3.1757, 3.0550, 2.9671, 2.9026, 2.8508, 2.8104, 2.7748,
     6 2.7451, 2.7193, 2.6970, 2.6771, 2.6596, 2.6452, 2.6319, 2.6194,
     7 4.2170, 4.0298, 3.9149, 3.8338, 3.7739, 3.7258, 3.6883, 3.6581,
     8 3.6335, 3.6131, 3.5962, 3.5825, 3.5701, 3.5609, 3.5528, 3.5447,
     9 5.0591, 4.8831, 4.7715, 4.6937, 4.6386, 4.5974, 4.5662, 4.5418/
      data (bla   (i),i=  73, 144)/
     1 4.5232, 4.5082, 4.4963, 4.4869, 4.4787, 4.4726, 4.4666, 4.4634,
     2 5.8889, 5.7165, 5.6071, 5.5344, 5.4838, 5.4478, 5.4215, 5.4021,
     3 5.3877, 5.3764, 5.3679, 5.3615, 5.3562, 5.3528, 5.3495, 5.3468,
     4 6.7010, 6.5278, 6.4199, 6.3505, 6.3043, 6.2725, 6.2503, 6.2344,
     5 6.2231, 6.2151, 6.2086, 6.2042, 6.2013, 6.1989, 6.1969, 6.1951,
     6 7.4966, 7.3193, 7.2121, 7.1459, 7.1034, 7.0757, 7.0568, 7.0440,
     7 7.0353, 7.0291, 7.0248, 7.0219, 7.0193, 7.0179, 7.0178, 7.0160,
     8 8.2787, 8.0951, 7.9890, 7.9262, 7.8876, 7.8633, 7.8477, 7.8377,
     9 7.8309, 7.8264, 7.8232, 7.8212, 7.8195, 7.8190, 7.8177, 7.8177/
      data (bla   (i),i= 145, 216)/
     1 9.0505, 8.8604, 8.7563, 8.6975, 8.6629, 8.6419, 8.6291, 8.6209,
     2 8.6160, 8.6126, 8.6105, 8.6095, 8.6084, 8.6076, 8.6082, 8.6071,
     3 9.8152, 9.6203, 9.5192, 9.4645, 9.4336, 9.4158, 9.4053, 9.3990,
     4 9.3951, 9.3927, 9.3914, 9.3905, 9.3900, 9.3895, 9.3892, 9.3893,
     510.5760,10.3774,10.2799,10.2293,10.2020,10.1871,10.1787,10.1738,
     610.1710,10.1692,10.1683,10.1678,10.1673,10.1674,10.1671,10.1670,
     711.3343,11.1336,11.0402,10.9940,10.9701,10.9574,10.9505,10.9469,
     810.9448,10.9435,10.9432,10.9424,10.9427,10.9429,10.9429,10.9423,
     912.0917,11.8903,11.8013,11.7592,11.7383,11.7278,11.7223,11.7196/
      data (bla   (i),i= 217, 240)/
     111.7180,11.7174,11.7168,11.7168,11.7166,11.7160,11.7163,11.7163,
     212.8490,12.6479,12.5636,12.5253,12.5071,12.4984,12.4939,12.4919,
     312.4908,12.4905,12.4901,12.4899,12.4898,12.4900,12.4901,12.4897/
c
c       brem: region b
c        electron energy=
c      0.10000e-02 0.21659e-02 0.46912e-02 0.10161e-01 0.22007e-01
c      0.47665e-01 0.10324     0.22361     0.48431      1.0490
c       2.2720      4.9209      10.658      23.085      50.000
c       log10 step=  0.3356
c
c      log10 of electron energy boundary
      data  eelb1l/-3.000000/
c    *     ,eelb2l/ 1.698970/
c
c
c            blb(iu,ie)=log(v/vmin)/(1.-u)
c            sqrt(u)=0.0   to 0.224 step= 0.0149
c            log10(e)= -3.0000 to   1.6990 step= 0.3356
c
      data (blb   (i),i=   1,  72)/
     1 1.5872, 1.5863, 1.5834, 1.5787, 1.5722, 1.5641, 1.5542, 1.5429,
     2 1.5301, 1.5160, 1.5007, 1.4844, 1.4669, 1.4487, 1.4294, 1.4095,
     3 2.8063, 2.8017, 2.7886, 2.7692, 2.7456, 2.7188, 2.6897, 2.6589,
     4 2.6264, 2.5928, 2.5580, 2.5224, 2.4858, 2.4486, 2.4106, 2.3721,
     5 3.7329, 3.7227, 3.7007, 3.6736, 3.6436, 3.6113, 3.5768, 3.5405,
     6 3.5024, 3.4627, 3.4215, 3.3789, 3.3352, 3.2900, 3.2441, 3.1969,
     7 4.5695, 4.5562, 4.5334, 4.5073, 4.4782, 4.4465, 4.4122, 4.3753,
     8 4.3363, 4.2948, 4.2513, 4.2058, 4.1584, 4.1093, 4.0584, 4.0062,
     9 5.3705, 5.3572, 5.3372, 5.3137, 5.2870, 5.2571, 5.2241, 5.1884/
      data (blb   (i),i=  73, 144)/
     1 5.1496, 5.1080, 5.0637, 5.0167, 4.9674, 4.9156, 4.8618, 4.8062,
     2 6.1560, 6.1443, 6.1271, 6.1062, 6.0818, 6.0539, 6.0225, 5.9876,
     3 5.9496, 5.9082, 5.8635, 5.8153, 5.7646, 5.7106, 5.6538, 5.5945,
     4 6.9347, 6.9248, 6.9099, 6.8911, 6.8685, 6.8419, 6.8118, 6.7777,
     5 6.7399, 6.6983, 6.6526, 6.6028, 6.5494, 6.4918, 6.4305, 6.3660,
     6 7.7102, 7.7019, 7.6889, 7.6716, 7.6502, 7.6247, 7.5951, 7.5609,
     7 7.5224, 7.4789, 7.4307, 7.3779, 7.3203, 7.2582, 7.1920, 7.1218,
     8 8.4843, 8.4774, 8.4655, 8.4493, 8.4286, 8.4034, 8.3731, 8.3377,
     9 8.2970, 8.2508, 8.1992, 8.1423, 8.0803, 8.0130, 7.9411, 7.8648/
      data (blb   (i),i= 145, 216)/
     1 9.2577, 9.2518, 9.2409, 9.2251, 9.2044, 9.1783, 9.1466, 9.1091,
     2 9.0657, 9.0163, 8.9607, 8.8990, 8.8316, 8.7587, 8.6807, 8.5979,
     310.0308,10.0256,10.0152, 9.9994, 9.9778, 9.9505, 9.9168, 9.8768,
     4 9.8300, 9.7767, 9.7165, 9.6499, 9.5769, 9.4980, 9.4136, 9.3245,
     510.8037,10.7990,10.7888,10.7725,10.7498,10.7206,10.6847,10.6416,
     610.5913,10.5336,10.4687,10.3967,10.3182,10.2332,10.1428,10.0472,
     711.5766,11.5723,11.5618,11.5446,11.5206,11.4895,11.4509,11.4047,
     811.3505,11.2884,11.2187,11.1412,11.0568,10.9660,10.8693,10.7676,
     912.3495,12.3453,12.3343,12.3162,12.2906,12.2575,12.2161,12.1665/
      data (blb   (i),i= 217, 240)/
     112.1084,12.0419,11.9670,11.8842,11.7942,11.6974,11.5949,11.4872,
     213.1224,13.1182,13.1067,13.0874,13.0602,13.0248,12.9807,12.9277,
     312.8656,12.7945,12.7146,12.6265,12.5309,12.4286,12.3202,12.2066/
c
c       pair: total x-section
c        gamm energy=
c      0.30000e-02 0.60068e-02 0.12027e-01 0.24082e-01 0.48219e-01
c      0.96549e-01 0.19332     0.38708     0.77504      1.5518
c       3.1072      6.2215      12.457      24.943      49.943
c       100.00
c       log10 step=  0.3015
c
c      log10 of gamma energy boundary
      data  etcpl1/-2.522879/
c    *     ,etcpl2/ 2.000000/
c
      data (tcpl  (i),i=   1,  16)/
     1 0.0501, 0.1413, 0.2448, 0.3518, 0.4560, 0.5512, 0.6277, 0.6814,
     2 0.7169, 0.7392, 0.7528, 0.7608, 0.7654, 0.7680, 0.7695, 0.7703/
c
c       pair: region a
c
c         energy of gamma=
c        0.300e-02   0.601e-02   0.120e-01   0.241e-01   0.482e-01
c        0.965e-01   0.193       0.387       0.775        1.55
c         3.11        6.22        12.5        24.9        49.9
c         100.
c         log10 step= 0.301525
c
c         log10 of eg boundary
      data  egla1l/-2.522879/
c    *     ,egla2l/ 2.000000/
c
c
c         pla(iu,ie)=(v-.5)/(1.-u)
c         u=0.050 to1.000   step= 0.0633
c            log10(e)= -2.5229 to   2.0000 step= 0.3015
c
      data (pla   (i),i=   1,  72)/
     1 0.2892, 0.2754, 0.2672, 0.2613, 0.2570, 0.2535, 0.2507, 0.2484,
     2 0.2466, 0.2452, 0.2439, 0.2429, 0.2421, 0.2418, 0.2421, 0.2414,
     3 0.3823, 0.3691, 0.3614, 0.3562, 0.3524, 0.3496, 0.3474, 0.3456,
     4 0.3442, 0.3432, 0.3425, 0.3417, 0.3415, 0.3411, 0.3415, 0.3407,
     5 0.4280, 0.4172, 0.4113, 0.4076, 0.4051, 0.4034, 0.4024, 0.4016,
     6 0.4012, 0.4008, 0.4009, 0.4006, 0.4006, 0.4006, 0.4008, 0.4007,
     7 0.4535, 0.4454, 0.4415, 0.4395, 0.4385, 0.4381, 0.4381, 0.4384,
     8 0.4391, 0.4397, 0.4402, 0.4409, 0.4414, 0.4413, 0.4415, 0.4418,
     9 0.4689, 0.4634, 0.4613, 0.4609, 0.4611, 0.4619, 0.4632, 0.4642/
      data (pla   (i),i=  73, 144)/
     1 0.4656, 0.4665, 0.4681, 0.4686, 0.4699, 0.4697, 0.4730, 0.4711,
     2 0.4790, 0.4757, 0.4755, 0.4765, 0.4782, 0.4803, 0.4828, 0.4850,
     3 0.4875, 0.4896, 0.4914, 0.4927, 0.4957, 0.4965, 0.4972, 0.4967,
     4 0.4861, 0.4855, 0.4873, 0.4899, 0.4933, 0.4972, 0.5009, 0.5046,
     5 0.5079, 0.5117, 0.5148, 0.5174, 0.5191, 0.5208, 0.5220, 0.5218,
     6 0.4917, 0.4936, 0.4974, 0.5018, 0.5065, 0.5114, 0.5164, 0.5208,
     7 0.5252, 0.5298, 0.5334, 0.5366, 0.5394, 0.5414, 0.5426, 0.5424,
     8 0.4960, 0.5000, 0.5051, 0.5105, 0.5163, 0.5219, 0.5275, 0.5331,
     9 0.5380, 0.5430, 0.5472, 0.5508, 0.5539, 0.5560, 0.5577, 0.5577/
      data (pla   (i),i= 145, 216)/
     1 0.4993, 0.5046, 0.5105, 0.5168, 0.5229, 0.5294, 0.5356, 0.5414,
     2 0.5469, 0.5520, 0.5568, 0.5607, 0.5639, 0.5665, 0.5677, 0.5683,
     3 0.5015, 0.5076, 0.5142, 0.5210, 0.5277, 0.5342, 0.5407, 0.5471,
     4 0.5528, 0.5583, 0.5632, 0.5672, 0.5708, 0.5730, 0.5747, 0.5752,
     5 0.5032, 0.5097, 0.5165, 0.5236, 0.5306, 0.5374, 0.5440, 0.5505,
     6 0.5565, 0.5622, 0.5671, 0.5716, 0.5748, 0.5774, 0.5786, 0.5796,
     7 0.5041, 0.5111, 0.5181, 0.5253, 0.5324, 0.5393, 0.5462, 0.5525,
     8 0.5588, 0.5645, 0.5695, 0.5741, 0.5774, 0.5799, 0.5815, 0.5822,
     9 0.5048, 0.5118, 0.5190, 0.5262, 0.5334, 0.5405, 0.5473, 0.5540/
      data (pla   (i),i= 217, 256)/
     1 0.5602, 0.5658, 0.5711, 0.5756, 0.5790, 0.5816, 0.5835, 0.5838,
     2 0.5052, 0.5123, 0.5196, 0.5267, 0.5340, 0.5411, 0.5479, 0.5547,
     3 0.5610, 0.5665, 0.5719, 0.5760, 0.5797, 0.5823, 0.5845, 0.5847,
     4 0.5054, 0.5126, 0.5199, 0.5271, 0.5343, 0.5415, 0.5483, 0.5550,
     5 0.5613, 0.5671, 0.5722, 0.5765, 0.5803, 0.5828, 0.5845, 0.5852/
c
c
c       pair: region b
c
c         energy of gamma=
c        0.300e-02   0.333e-02   0.455e-02   0.766e-02   0.159e-01
c        0.405e-01   0.127       0.494        2.35        13.8
c         100.
c         sqrt(log10) step= 0.212671
c
c         use 0 for e-side at interpolation
c         with sqrt(log10(e)-eglb1l)
      data  eglb1l/-2.522879/
c
c
c         plb(iu,ie)=v
c         sqrt(u)=0.0   to0.224   step= 0.0149
      data (plb   (i),i=   1,  72)/
     1 0.8297, 0.8246, 0.8214, 0.8180, 0.8146, 0.8112, 0.8079, 0.8043,
     2 0.8007, 0.7971, 0.7935, 0.7899, 0.7861, 0.7824, 0.7786, 0.7747,
     3 0.8465, 0.8447, 0.8417, 0.8383, 0.8349, 0.8314, 0.8278, 0.8242,
     4 0.8205, 0.8168, 0.8131, 0.8092, 0.8054, 0.8015, 0.7975, 0.7934,
     5 0.8877, 0.8869, 0.8848, 0.8821, 0.8789, 0.8755, 0.8719, 0.8683,
     6 0.8646, 0.8607, 0.8568, 0.8527, 0.8487, 0.8446, 0.8403, 0.8361,
     7 0.9333, 0.9325, 0.9306, 0.9279, 0.9249, 0.9215, 0.9180, 0.9144,
     8 0.9106, 0.9068, 0.9028, 0.8987, 0.8946, 0.8904, 0.8860, 0.8816,
     9 0.9678, 0.9670, 0.9649, 0.9622, 0.9593, 0.9561, 0.9528, 0.9494/
      data (plb   (i),i=  73, 144)/
     1 0.9458, 0.9422, 0.9384, 0.9345, 0.9305, 0.9264, 0.9222, 0.9178,
     2 0.9874, 0.9864, 0.9844, 0.9820, 0.9795, 0.9769, 0.9740, 0.9710,
     3 0.9678, 0.9646, 0.9613, 0.9577, 0.9541, 0.9503, 0.9464, 0.9425,
     4 0.9960, 0.9950, 0.9934, 0.9916, 0.9896, 0.9876, 0.9853, 0.9829,
     5 0.9802, 0.9775, 0.9746, 0.9716, 0.9683, 0.9651, 0.9615, 0.9579,
     6 0.9990, 0.9983, 0.9972, 0.9960, 0.9945, 0.9929, 0.9912, 0.9894,
     7 0.9873, 0.9851, 0.9827, 0.9803, 0.9776, 0.9748, 0.9719, 0.9687,
     8 0.9998, 0.9994, 0.9987, 0.9979, 0.9969, 0.9957, 0.9945, 0.9930,
     9 0.9914, 0.9896, 0.9878, 0.9857, 0.9835, 0.9811, 0.9785, 0.9757/
      data (plb   (i),i= 145, 176)/
     1 1.0000, 0.9997, 0.9993, 0.9987, 0.9979, 0.9971, 0.9961, 0.9949,
     2 0.9934, 0.9920, 0.9903, 0.9883, 0.9862, 0.9840, 0.9816, 0.9790,
     3 1.0000, 0.9998, 0.9996, 0.9991, 0.9985, 0.9976, 0.9966, 0.9955,
     4 0.9942, 0.9927, 0.9911, 0.9893, 0.9872, 0.9850, 0.9827, 0.9802/
c
c    ---------------     $$$   landau correction region $$$     ----
c
c         not used yet
c
c    ------------------------------------------------
c       total prob. equivalenced to common
c
      equivalence (tprob,tp)
c

c
c                         complete screening pair x-sxec.
c                         0.703 =(7/9-b)*rx0 =.773*rx0
      data rx0/0.99/, ctpc/.773/,  cep/10.e5/
c       rx0=x0(true)/x0(in nishimura text)=5.82/6.4
c       cep:  minimum energy for landau correction for pair.
c          default esbc espc
      data esbin/10./,  espin/50./
c
c
      if(ee .lt. eblmin) then
          t=1.e36
      else
          if(.not. usees) then
             esb=esbin
          else
             esb=min(escb, eblmax)
          endif
          if(ee .gt. esb) then
              screen=.false.
              if(lcorec .and. ee .gt. eeh1) then
                  if(ee .gt. eeh2) then
                       write(6,'('' ee > eeh2 in brmsit: ee='',g12.4)')
     *                 ee
                       stop
                  endif
                  landau=.true.
                  ale=log10(ee)
c                 tp=fintp3(tcbh, eeh1l, deelh, neeh, ale)*rx0
                  call kintp3(tcbh, 1, neeh, eeh1l, deelh, ale, tp)
                  tp=tp*rx0
              else
                  landau=.false.
c                     complete screening cross-section
                  vc=ec/ee
                  tp=(-1.3603*(log(vc)-vc)-vc*vc*.5-.8603 )*rx0
              endif
          else
              landau=.false.
              if(scorec) then
                  screen=.true.
                  ale=log10(ee)
c                 tp=fintp3(tcbl, etcbl1, debtcl, nbtcl,  ale)
                  call kintp3(tcbl, 1, nbtcl, etcbl1, debtcl,  ale, tp)
              else
                  screen=.false.
c                     complete screening cross-section
                  vc=ec/ee
                  tp=(-1.3603*(log(vc)-vc)-vc*vc*.5-.8603 )*rx0
              endif
          endif
c
          call rndc(u)
          t =-log(u)/tp
      endif
      return
c
c     ************
      entry brmsie(ee,ec,beg)
c     ************
c
      call rndc(u)
      if(screen) then
c           partial screening
         if(u .gt. uela1) then
c                  region a
c              beg=exp( tdint4(bla, nuela, neela, uela1, eela1l, duela,
c    *         deela, u,  ale)*(1.-u) ) *egmnl
               call k4ptdi(bla, nuela, neela, nuela, uela1, eela1l,
     *         duela, deela, u, ale, ans)
               beg=exp( ans*(1.-u))*egmnl
         else
c                  region b
               us=sqrt(u)
c              beg=exp( tdint4(blb, nuelb, neelb, uelb1, eelb1l,duelb,
c    *         deelb, us, ale)) * egmnl
               call k4ptdi(blb, nuelb, neelb, nuelb, uelb1, eelb1l,
     *         duelb, deelb, us, ale, ans)
               beg=exp(ans)*egmnl
         endif
      elseif(landau) then
         if(u .lt. ueh2) then
c              beg=exp( tdint4(be1, nueh1, neeh, ueh1, eeh1l, dueh1,
c    *         deelh, u,  ale)  ) * egmnh
               call k4ptdi(be1, nueh1, neeh, nueh1,  ueh1, eeh1l,
     *         dueh1, deelh, u,  ale, ans)
               beg=exp( ans ) *egmnh
         else
               us=sqrt(1.-u)
c              beg=   ( tdint4(be2, nueh2, neeh, ueh3, eeh1l, dueh2,
c    *         deelh, us,  ale)*(1.-u)+ sqrt(egmnh/ee) )**2 *ee
               call k4ptdi(be2, nueh2, neeh, nueh2,  ueh3, eeh1l,
     *         dueh2, deelh, us,  ale, ans)
               beg=  (ans*(1.-u) + sqrt(egmnh/ee) )**2*ee
         endif
      else
c               complete screening
          a=u*tp
          if(a .le. 1.) then
             v=exp(-a)
             if(a .gt. .1) then
                 v=((.06366*a-.1447407)*a+1.014176)*v
             endif
          else
             v=exp(-(a+0.8603)/1.3603)
             if(a .le. 6.) then
                 v=((((2.050445e-3*a-3.53209e-2)*a+.228937)*a-.684076)*a
     *           +1.841734)*v
             endif
          endif
          beg=ee*v
      endif
      return
c
c
c     ***********
      entry prcsit(eg,t)
c     ***********
c
c
c
      if(eg .le. emass2) then
          t=1.e37
      elseif(eg .lt. eplmin .and. scorec) then
          tp=( (eg-emass2)/(eplmin-emass2) )**3 * tcpl(1)
          call rndc(u)
          t =-log(u)/tp
          landau=.false.
          screen=.true.
      else
          if(.not. usees) then
             esp=espin
          else
             esp=min(escp, eplmax)
          endif
          if(eg .gt. esp) then
              screen=.false.
              if(eg .gt. cep   .and. lcorec) then
                  landau=.true.
                  ale=log10(eg)
c                 tp=fintp3(tcph, egh1l, deghl, negh, ale)*rx0
                  call kintp3(tcph, 1, negh,  egh1l,  deghl,   ale, tp)
              else
                  landau=.false.
c                     complete screening cross-section
                  tp=ctpc
              endif
          else
              landau=.false.
              if(scorec) then
                  screen=.true.
                  ale=log10(eg)
c                 tp=fintp3(tcpl, etcpl1, deptcl, nptcl, ale)
                  call kintp3(tcpl, 1,nptcl,  etcpl1, deptcl,  ale, tp)
              else
                  screen=.false.
c                     complete screening cross-section
                  tp=ctpc
              endif
          endif
          call rndc(u)
          t =-log(u)/tp
      endif
      return
c
c
c     ***********
      entry prcsie(eg,e1)
c     ***********
c
c
c
      call rndc(u)
      if(screen) then
c           partial screening
         if(u .ge. ugla1) then
c                   region a
c               e1=(tdint4(pla, nugla, negla, ugla1, egla1l, dugla,
c    *          degla, u,    ale) *(1.-u) + .5 )*eg
                call k4ptdi(pla, nugla, negla,nugla,  ugla1, egla1l,
     *          dugla, degla, u,   ale, ans)
                e1=(ans*(1.-u) + .5)*eg
         else
c                   region b
                us=sqrt(u)
                ex=sqrt(ale-eglb1l)

                call k4ptdi(plb, nuglb, neglb,nuglb,  uglb1, 0.d0,
     *          duglb, deglb, us,  ale, ans)
                e1=ans*eg
         endif
      elseif(landau) then
c        e1= tdint4(vp, nugh2, negh, ugh3, egh1l, dugh2,
c    *   deghl, u,  ale) * eg
         call k4ptdi(vp, nugh2, negh, nugh2, ugh3, egh1l,
     *   dugh2, deghl, u,  ale, ans)
         e1=ans*eg
      else
c                complete screening
         e1=(((.0441223*u-.173755)*u-.3708608)*u+1.)*eg
      endif
      return
c
c     ************
      entry emctsi(Knckon)
c     ************
c
c               cconst=for compton=3/8*thomson*n0*z/a*x0ing
c               to convert cross-section in compt into /(r.l).
      cconst=1.625
      x0=8.98
      x0ing=21.73
      x0sq=80.64
      if(Knckon) then
         ecrit=30.0e-3
      else
         ecrit=37.e-3
      endif
c         moller scat
      constm=3.25
      rho = 2.42
c
      zchrg=14.
      zchrg2 = 196.
      amassn=28.09
      ionizP = 172.25d-9
      end
