
c     *                                                              *
c     *  brmfet:  samples path for brems                             *
c     *  brmfee:  samples energy of brems gamma                      *
c     *  prcfet:  samples path for pair creation                     *
c     *  prcfee:  samples energy of pair electron (higher energy)    *
c     *  emctfe:  set const in common area for fe                    *
c     *                                                              *
c     *********************** tested 84.05.04 ********************k.k*
c
c      material   z     a     rho     t0 (g/cm2)  t0 (cm)    ec
c         fe      26    55.85  7.86   13.7         1.74     17.0
c                                  (n)13.9
c brems:
c        electron energy:      1mev to 300tev
c        brems gamma energy:   .1mev or more
c           if electron energy is < 1mev,  sampled path is set to be
c        very large one so that real brems may not take place before
c        the death by energy loss.
c pair:
c        gamma energy:         3mev to 300tev
c           if gamma energy is < 3mev, sampled path is set to be
c        very large one so that real pair creation may not take place
c        before compton or another process takes place.
c
c
c
c
c   /usage/          call brmfet(ee,ec,t)
c                    call brmfee(ee,ec,beg)
c
c                    call prcfet(eg,t)
c                    call prcfee(eg,e1)
c
c      ee:  incident electron energy
c      ec:  cut-off energy of brems gamma (used if complete screening
c           cross section is to be used).
c       t:  sampled path
c     beg:  sampled gamma energy
c      eg:  incident gamma energy
c      e1:  sampled electron energy (higher energy in pair)
c
c  *** note ***
c
c          before calling brmfee, brmfet must have been called.
c          //             prcfee, prcfet //
c
c          by the parameters in $$elmag the user can control:
c
c        ee  --------------10gev------->  (if usees=t, escb instead 10
c     scorec=t       p.s    !
c     lcorec=t              !    l.c
c     scorec=f       c.s    !
c     lcorec=f              !    c.s
c
c        eg  -------------100gev-10tev---> (if usees=t, escp instead 100
c     scorec=t       p.s    ! c.s !
c     lcorec=t              ! c.s ! l.c
c     scorec=f       c.s    ! c.s !
c     lcorec=f              !     ! c.s
c
c
c
c
      subroutine brmfet(ee,ec,t)
       implicit none
c
c
#include  "Zelmag.h"
#include  "Zemdef.h"
c
c
      integer i
      logical screen,landau
      save screen,landau
c
c
c
c ------------------------- partical screening ----------------------
c           *** electron ***
c
c           ! egmin (gev)  for brems.
      data egmnl/.1e-3/
c
      parameter (eblmin=1.e-3, eblmax=10.,  nbtcl=13)
      dimension tcbl(nbtcl)
c
c             brem:   region a
c
      parameter (eela1=eblmin, eela2=eblmax,neela=13,
     * uela1=.05, uela2=1., nuela=16, duela=(uela2-uela1)/(nuela-1) )
      dimension bla(nuela* neela)
c
c             brem:  region b  (sqrt(u))
      parameter (eelb1=eblmin, eelb2=eblmax, neelb=neela,
     * uelb1=0.,  uelb2=.2236068, nuelb=16,
     * duelb=(uelb2-uelb1)/(nuelb-1) )
      dimension blb(nuelb* neelb)
c           ** gamma ***
c
c                 total cross-section
      parameter (eplmin=3.e-3, eplmax=300., nptcl=16)
      dimension tcpl(nptcl)
c
c          pair: region a
      parameter ( egla1=eplmin,  egla2=eplmax, negla=16,
     *   ugla1=.05, ugla2=1., nugla=16,dugla=(ugla2-ugla1)/(nugla-1) )
      dimension pla(nugla* negla)
c
c            pair: region b     sqrt(log10(e)) sqrt(u)
      parameter (eglb1=eplmin, eglb2=eplmax, neglb=11,
     *  uglb1=0., uglb2=.2236068, nuglb=16,
     *  duglb=(uglb2-uglb1)/(nuglb-1))
      dimension plb(nuglb* neglb)
c
c      -------------------- landau ------------------------------
c          **** electron ****
c
      data egmnh/1.e-3/
      parameter ( eeh1=5., eeh2=300.e3, neeh=16,dueh1=.1,
     *  ueh1=0., ueh2=.7, nueh1=(ueh2-ueh1+.00001)/dueh1+1)
      dimension  tcbh(neeh)
      dimension  be1(nueh1* neeh)
c
c                         sqrt(1-.7)
      parameter (ueh3=0., ueh4=0.5477225,
     *nueh2=11, dvueh2=nueh2-1, dueh2=(ueh4 - ueh3)/dvueh2)
      dimension be2(nueh2*neeh)
c
c
c         *** gamma ****
c
      parameter ( egh1=5000., egh2=300.e3,negh=7, dugh2=.1,
     * ugh3=0., ugh4=1., nugh2=(ugh4-ugh3+.00001)/dugh2+1)
      dimension tcph(negh)
      dimension vp(nugh2* negh)
c
c
c     ---------------------------------------------------------
c
      data debtcl/ 0.333333/
      data deela/ 0.333333/
      data deelb/ 0.333333/
      data deptcl/ 0.333333/
      data degla/ 0.333333/
      data deglb/ 0.223607/
c
c        electron energy=
c      0.10000e-02 0.21544e-02 0.46416e-02 0.10000e-01 0.21544e-01
c      0.46416e-01 0.10000     0.21544     0.46416      1.0000
c       2.1544      4.6416      10.000
c       log10 step=  0.3333
c
c      log10 of electron energy boundary
      data  etcbl1/-3.000000/
c    *     ,etcbl2/ 1.000000/
c
      data (tcbl  (i),i=   1,  13)/
     1 1.3843, 2.6615, 3.8612, 5.0229, 6.1562, 7.2669, 8.3571, 9.4289,
     210.4867,11.5347,12.5768,13.6148,14.6506/
c
c       brem: region a
c        electron energy=
c      0.10000e-02 0.21544e-02 0.46416e-02 0.10000e-01 0.21544e-01
c      0.46416e-01 0.10000     0.21544     0.46416      1.0000
c       2.1544      4.6416      10.000
c       log10 step=  0.3333
c
c      log10 of electron energy boundary
      data  eela1l/-3.000000/
c    *     ,eela2l/ 1.000000/
c
c
c            bla(iu,ie)=log(v/vmin)/(1.-u)
c            u=0.050 to 1.000 step= 0.0633
c            log10(e)= -3.0000 to   1.0000 step= 0.3333
c
      data (bla   (i),i=   1,  72)/
     1 1.4825, 1.3968, 1.3343, 1.2849, 1.2442, 1.2094, 1.1793, 1.1526,
     2 1.1290, 1.1075, 1.0878, 1.0698, 1.0534, 1.0384, 1.0239, 1.0049,
     3 2.4906, 2.3252, 2.2167, 2.1356, 2.0711, 2.0188, 1.9757, 1.9371,
     4 1.9035, 1.8755, 1.8558, 1.8340, 1.8148, 1.7985, 1.7832, 1.7687,
     5 3.3584, 3.1736, 3.0562, 2.9726, 2.9096, 2.8627, 2.8212, 2.7859,
     6 2.7566, 2.7316, 2.7101, 2.6911, 2.6742, 2.6595, 2.6476, 2.6354,
     7 4.2080, 4.0275, 3.9152, 3.8366, 3.7759, 3.7304, 3.6937, 3.6642,
     8 3.6402, 3.6207, 3.6043, 3.5908, 3.5790, 3.5694, 3.5602, 3.5541,
     9 5.0464, 4.8759, 4.7649, 4.6890, 4.6339, 4.5931, 4.5624, 4.5385/
      data (bla   (i),i=  73, 144)/
     1 4.5197, 4.5051, 4.4931, 4.4840, 4.4763, 4.4703, 4.4656, 4.4608,
     2 5.8706, 5.7009, 5.5924, 5.5200, 5.4697, 5.4338, 5.4077, 5.3881,
     3 5.3737, 5.3626, 5.3538, 5.3475, 5.3425, 5.3379, 5.3347, 5.3328,
     4 6.6755, 6.5042, 6.3964, 6.3273, 6.2809, 6.2491, 6.2268, 6.2109,
     5 6.1993, 6.1910, 6.1848, 6.1802, 6.1768, 6.1742, 6.1715, 6.1711,
     6 7.4642, 7.2878, 7.1806, 7.1142, 7.0716, 7.0437, 7.0245, 7.0118,
     7 7.0027, 6.9966, 6.9921, 6.9890, 6.9867, 6.9856, 6.9840, 6.9833,
     8 8.2395, 8.0565, 7.9503, 7.8872, 7.8484, 7.8240, 7.8081, 7.7977,
     9 7.7909, 7.7863, 7.7833, 7.7812, 7.7797, 7.7790, 7.7787, 7.7775/
      data (bla   (i),i= 145, 208)/
     1 9.0049, 8.8154, 8.7111, 8.6520, 8.6170, 8.5959, 8.5828, 8.5747,
     2 8.5695, 8.5661, 8.5639, 8.5624, 8.5619, 8.5610, 8.5598, 8.5604,
     3 9.7639, 9.5691, 9.4677, 9.4127, 9.3816, 9.3636, 9.3530, 9.3465,
     4 9.3428, 9.3402, 9.3390, 9.3381, 9.3372, 9.3376, 9.3359, 9.3366,
     510.5190,10.3205,10.2227,10.1718,10.1442,10.1290,10.1204,10.1155,
     610.1125,10.1108,10.1101,10.1094,10.1092,10.1088,10.1098,10.1085,
     711.2718,11.0711,10.9774,10.9308,10.9066,10.8940,10.8868,10.8832,
     810.8809,10.8798,10.8795,10.8788,10.8784,10.8784,10.8786,10.8783/
c
c       brem: region b
c        electron energy=
c      0.10000e-02 0.21544e-02 0.46416e-02 0.10000e-01 0.21544e-01
c      0.46416e-01 0.10000     0.21544     0.46416      1.0000
c       2.1544      4.6416      10.000
c       log10 step=  0.3333
c
c      log10 of electron energy boundary
      data  eelb1l/-3.000000/
c    *     ,eelb2l/ 1.000000/
c
c
c            blb(iu,ie)=log(v/vmin)/(1.-u)
c            sqrt(u)=0.0   to 0.224 step= 0.0149
c            log10(e)= -3.0000 to   1.0000 step= 0.3333
c
      data (blb   (i),i=   1,  72)/
     1 1.5872, 1.5863, 1.5834, 1.5787, 1.5720, 1.5637, 1.5539, 1.5424,
     2 1.5296, 1.5154, 1.4999, 1.4835, 1.4660, 1.4476, 1.4284, 1.4084,
     3 2.7994, 2.7946, 2.7811, 2.7616, 2.7376, 2.7108, 2.6817, 2.6508,
     4 2.6185, 2.5851, 2.5506, 2.5151, 2.4788, 2.4418, 2.4042, 2.3661,
     5 3.7210, 3.7104, 3.6880, 3.6609, 3.6312, 3.5991, 3.5650, 3.5292,
     6 3.4916, 3.4524, 3.4119, 3.3698, 3.3266, 3.2824, 3.2368, 3.1905,
     7 4.5527, 4.5389, 4.5163, 4.4904, 4.4617, 4.4304, 4.3967, 4.3606,
     8 4.3221, 4.2814, 4.2387, 4.1941, 4.1474, 4.0991, 4.0490, 3.9976,
     9 5.3487, 5.3352, 5.3154, 5.2922, 5.2660, 5.2367, 5.2045, 5.1692/
      data (blb   (i),i=  73, 144)/
     1 5.1313, 5.0905, 5.0471, 5.0012, 4.9530, 4.9019, 4.8492, 4.7940,
     2 6.1292, 6.1174, 6.1004, 6.0798, 6.0559, 6.0285, 5.9978, 5.9637,
     3 5.9265, 5.8860, 5.8420, 5.7950, 5.7449, 5.6921, 5.6360, 5.5770,
     4 6.9026, 6.8928, 6.8781, 6.8597, 6.8375, 6.8116, 6.7821, 6.7487,
     5 6.7116, 6.6706, 6.6254, 6.5767, 6.5234, 6.4664, 6.4059, 6.3418,
     6 7.6729, 7.6648, 7.6519, 7.6349, 7.6139, 7.5890, 7.5598, 7.5264,
     7 7.4881, 7.4452, 7.3975, 7.3450, 7.2881, 7.2265, 7.1607, 7.0910,
     8 8.4417, 8.4349, 8.4233, 8.4074, 8.3871, 8.3621, 8.3322, 8.2971,
     9 8.2568, 8.2112, 8.1599, 8.1035, 8.0418, 7.9749, 7.9035, 7.8275/
      data (blb   (i),i= 145, 208)/
     1 9.2098, 9.2040, 9.1933, 9.1778, 9.1573, 9.1315, 9.1000, 9.0629,
     2 9.0198, 8.9706, 8.9155, 8.8543, 8.7872, 8.7147, 8.6371, 8.5547,
     3 9.9776, 9.9726, 9.9623, 9.9467, 9.9253, 9.8981, 9.8646, 9.8249,
     4 9.7785, 9.7254, 9.6656, 9.5994, 9.5268, 9.4483, 9.3644, 9.2757,
     510.7453,10.7407,10.7305,10.7144,10.6918,10.6628,10.6271,10.5843,
     610.5342,10.4769,10.4123,10.3409,10.2625,10.1782,10.0881, 9.9930,
     711.5129,11.5087,11.4982,11.4811,11.4572,11.4263,11.3879,11.3419,
     811.2881,11.2263,11.1570,11.0799,10.9960,10.9056,10.8095,10.7082/
c
c       pair: total x-section
c        gamm energy=
c      0.30000e-02 0.64633e-02 0.13925e-01 0.30000e-01 0.64633e-01
c      0.13925     0.30000     0.64633      1.3925      3.0000
c       6.4633      13.925      30.000      64.633      139.25
c       300.00
c       log10 step=  0.3333
c
c      log10 of gamma energy boundary
      data  etcpl1/-2.522879/
c    *     ,etcpl2/ 2.477121/
c
      data (tcpl  (i),i=   1,  16)/
     1 0.0484, 0.1540, 0.2736, 0.3944, 0.5089, 0.6029, 0.6680, 0.7094,
     2 0.7343, 0.7485, 0.7564, 0.7607, 0.7630, 0.7642, 0.7648, 0.7651/
c
c       pair: region a
c
c         energy of gamma=
c        0.300e-02   0.646e-02   0.139e-01   0.300e-01   0.646e-01
c        0.139       0.300       0.646        1.39        3.00
c         6.46        13.9        30.0        64.6        139.
c         300.
c         log10 step= 0.333333
c
c         log10 of eg boundary
      data  egla1l/-2.522879/
c    *     ,egla2l/ 2.477121/
c
c
c         pla(iu,ie)=(v-.5)/(1.-u)
c         u=0.050 to1.000   step= 0.0633
c            log10(e)= -2.5229 to   2.4771 step= 0.3333
c
      data (pla   (i),i=   1,  72)/
     1 0.2821, 0.2687, 0.2607, 0.2548, 0.2505, 0.2471, 0.2443, 0.2420,
     2 0.2403, 0.2388, 0.2375, 0.2365, 0.2362, 0.2354, 0.2357, 0.2351,
     3 0.3866, 0.3734, 0.3658, 0.3607, 0.3569, 0.3541, 0.3520, 0.3504,
     4 0.3490, 0.3482, 0.3474, 0.3466, 0.3464, 0.3460, 0.3464, 0.3457,
     5 0.4337, 0.4233, 0.4178, 0.4146, 0.4123, 0.4110, 0.4101, 0.4095,
     6 0.4094, 0.4091, 0.4092, 0.4092, 0.4093, 0.4096, 0.4094, 0.4095,
     7 0.4588, 0.4515, 0.4485, 0.4469, 0.4466, 0.4465, 0.4471, 0.4479,
     8 0.4485, 0.4495, 0.4504, 0.4512, 0.4516, 0.4522, 0.4529, 0.4526,
     9 0.4735, 0.4692, 0.4679, 0.4681, 0.4691, 0.4705, 0.4724, 0.4741/
      data (pla   (i),i=  73, 144)/
     1 0.4763, 0.4776, 0.4797, 0.4811, 0.4817, 0.4811, 0.4785, 0.4842,
     2 0.4832, 0.4817, 0.4828, 0.4851, 0.4880, 0.4910, 0.4946, 0.4978,
     3 0.5011, 0.5040, 0.5072, 0.5096, 0.5113, 0.5125, 0.5132, 0.5136,
     4 0.4903, 0.4918, 0.4952, 0.4995, 0.5039, 0.5087, 0.5134, 0.5178,
     5 0.5221, 0.5265, 0.5300, 0.5333, 0.5358, 0.5376, 0.5383, 0.5387,
     6 0.4955, 0.4994, 0.5044, 0.5099, 0.5155, 0.5212, 0.5267, 0.5322,
     7 0.5373, 0.5422, 0.5463, 0.5501, 0.5531, 0.5549, 0.5566, 0.5567,
     8 0.4993, 0.5045, 0.5106, 0.5169, 0.5233, 0.5296, 0.5358, 0.5416,
     9 0.5471, 0.5526, 0.5572, 0.5612, 0.5645, 0.5670, 0.5686, 0.5687/
      data (pla   (i),i= 145, 216)/
     1 0.5018, 0.5080, 0.5147, 0.5214, 0.5282, 0.5348, 0.5413, 0.5476,
     2 0.5537, 0.5589, 0.5640, 0.5682, 0.5714, 0.5739, 0.5756, 0.5761,
     3 0.5034, 0.5101, 0.5171, 0.5241, 0.5311, 0.5380, 0.5448, 0.5513,
     4 0.5573, 0.5629, 0.5679, 0.5721, 0.5757, 0.5784, 0.5796, 0.5805,
     5 0.5044, 0.5113, 0.5185, 0.5257, 0.5327, 0.5397, 0.5466, 0.5533,
     6 0.5593, 0.5652, 0.5703, 0.5746, 0.5783, 0.5808, 0.5825, 0.5830,
     7 0.5049, 0.5121, 0.5193, 0.5266, 0.5338, 0.5409, 0.5477, 0.5545,
     8 0.5607, 0.5665, 0.5715, 0.5760, 0.5797, 0.5823, 0.5835, 0.5844,
     9 0.5053, 0.5125, 0.5197, 0.5271, 0.5343, 0.5413, 0.5483, 0.5550/
      data (pla   (i),i= 217, 256)/
     1 0.5613, 0.5671, 0.5722, 0.5765, 0.5803, 0.5828, 0.5845, 0.5851,
     2 0.5054, 0.5128, 0.5200, 0.5274, 0.5345, 0.5417, 0.5486, 0.5552,
     3 0.5616, 0.5675, 0.5726, 0.5770, 0.5806, 0.5833, 0.5845, 0.5855,
     4 0.5056, 0.5129, 0.5202, 0.5274, 0.5347, 0.5419, 0.5488, 0.5555,
     5 0.5618, 0.5675, 0.5726, 0.5770, 0.5811, 0.5833, 0.5854, 0.5857/
c
c
c       pair: region b
c
c         energy of gamma=
c        0.300e-02   0.337e-02   0.475e-02   0.846e-02   0.189e-01
c        0.533e-01   0.189       0.846        4.75        33.7
c         300.
c         sqrt(log10) step= 0.223607
c
c         use 0 for e-side at interpolation
c         with sqrt(log10(e)-eglb1l)
      data  eglb1l/-2.522879/
c
c
c         plb(iu,ie)=v
c         sqrt(u)=0.0   to0.224   step= 0.0149
      data (plb   (i),i=   1,  72)/
     1 0.8297, 0.8125, 0.8108, 0.8085, 0.8057, 0.8027, 0.7996, 0.7964,
     2 0.7930, 0.7896, 0.7862, 0.7826, 0.7791, 0.7754, 0.7718, 0.7680,
     3 0.8482, 0.8410, 0.8380, 0.8347, 0.8313, 0.8278, 0.8243, 0.8207,
     4 0.8170, 0.8134, 0.8096, 0.8058, 0.8020, 0.7981, 0.7942, 0.7903,
     5 0.8925, 0.8912, 0.8885, 0.8853, 0.8818, 0.8782, 0.8746, 0.8707,
     6 0.8669, 0.8630, 0.8589, 0.8549, 0.8508, 0.8466, 0.8424, 0.8380,
     7 0.9396, 0.9385, 0.9363, 0.9334, 0.9301, 0.9266, 0.9231, 0.9194,
     8 0.9156, 0.9117, 0.9077, 0.9037, 0.8995, 0.8952, 0.8909, 0.8865,
     9 0.9730, 0.9719, 0.9697, 0.9669, 0.9639, 0.9609, 0.9576, 0.9542/
      data (plb   (i),i=  73, 144)/
     1 0.9508, 0.9472, 0.9435, 0.9396, 0.9356, 0.9316, 0.9274, 0.9232,
     2 0.9904, 0.9893, 0.9872, 0.9851, 0.9827, 0.9801, 0.9774, 0.9746,
     3 0.9716, 0.9684, 0.9652, 0.9619, 0.9583, 0.9547, 0.9508, 0.9469,
     4 0.9973, 0.9964, 0.9949, 0.9934, 0.9915, 0.9896, 0.9875, 0.9853,
     5 0.9829, 0.9804, 0.9777, 0.9749, 0.9719, 0.9687, 0.9654, 0.9620,
     6 0.9994, 0.9987, 0.9979, 0.9969, 0.9957, 0.9942, 0.9927, 0.9910,
     7 0.9892, 0.9873, 0.9852, 0.9829, 0.9804, 0.9779, 0.9751, 0.9721,
     8 0.9999, 0.9996, 0.9990, 0.9984, 0.9975, 0.9965, 0.9953, 0.9941,
     9 0.9926, 0.9909, 0.9892, 0.9873, 0.9851, 0.9829, 0.9803, 0.9777/
      data (plb   (i),i= 145, 176)/
     1 1.0000, 0.9998, 0.9994, 0.9989, 0.9983, 0.9975, 0.9965, 0.9953,
     2 0.9939, 0.9925, 0.9908, 0.9889, 0.9870, 0.9848, 0.9823, 0.9798,
     3 1.0000, 0.9999, 0.9996, 0.9992, 0.9986, 0.9977, 0.9968, 0.9957,
     4 0.9944, 0.9929, 0.9913, 0.9894, 0.9874, 0.9853, 0.9828, 0.9803/
c    ---------------     $$$   landau correction region $$$     ----
c
      data deelh/ 0.318543/
      data deghl/ 0.296359/
c
c          energy of electron
c        5.000       10.41       21.68       45.14       94.00
c        195.7       407.6       848.7       1767.       3680.
c        7663.      0.1596e+05  0.3323e+05  0.6919e+05  0.1441e+06
c       0.3000e+06
c         log10 step= 0.318543
c
c         log10 of electron energy boundary
      data eeh1l/ 0.698970/
c    *     ,eeh2l/ 5.477121/
c
      data (tcbh  (i),i=   1,  16)/
     1 10.4555, 10.9323, 10.8842, 10.4297,  9.7302,  8.8974,  7.9967,
     2  7.0691,  6.1397,  5.2285,  4.3602,  3.5570,  2.8367,  2.2140,
     3  1.6923,  1.2710/
c
c          be1(iu,ie)= log(v/vmin)
c          from u=0.0   to 0.700 step=0.100
c          from log10(e)=  0.6990 to  5.4771 step  0.3185
c          dim. of u=  8 dim of e= 16
c
      data (   be1(i),i=   1,  54)/
     1  8.51719,  7.39347,  6.44368,  5.59229,  4.77912,  3.98204,
     2  3.19205,  2.40105,  9.25067,  8.07978,  7.09681,  6.21298,
     3  5.36638,  4.53475,  3.70715,  2.89615,  9.98414,  8.81799,
     4  7.83836,  6.95781,  6.11458,  5.28316,  4.47211,  3.64969,
     5 10.71761,  9.59645,  8.64846,  7.79882,  6.98371,  6.19425,
     6  5.41254,  4.58829, 11.45109, 10.40007,  9.50126,  8.69790,
     7  7.93550,  7.19988,  6.45201,  5.63720, 12.18456, 11.21853,
     8 10.37923,  9.63077,  8.93432,  8.25073,  7.53818,  6.74105,
     9 12.91803, 12.04575, 11.26976, 10.58931,  9.95321,  9.31662/
      data (   be1(i),i=  55, 108)/
     1  8.63872,  7.86354, 13.65150, 12.87784, 12.17426, 11.56013,
     2 10.97593, 10.38060,  9.73473,  8.98269, 14.38498, 13.71060,
     3 13.08661, 12.52987, 11.99068, 11.43070, 10.81341, 10.08379,
     4 15.11845, 14.54501, 13.99831, 13.49119, 12.98771, 12.45764,
     5 11.86522, 11.15622, 15.85192, 15.37748, 14.89948, 14.43482,
     6 13.96208, 13.45673, 12.88538, 12.19454, 16.58540, 16.20032,
     7 15.78418, 15.35592, 14.90944, 14.42461, 13.87072, 13.19534,
     8 17.31886, 17.01038, 16.64861, 16.25208, 15.82675, 15.35861,
     9 14.81900, 14.15641, 18.05234, 17.80635, 17.49007, 17.12239/
      data (   be1(i),i= 109, 128)/
     1 16.71530, 16.26042, 15.73200, 15.07967, 18.78581, 18.58867,
     2 18.31053, 17.96687, 17.57431, 17.12985, 16.61002, 15.96583,
     3 19.51929, 19.35971, 19.11060, 18.78650, 18.40697, 17.97153,
     4 17.45903, 16.82118/
c
c         be2(iu,ie)= (sqrt(v) -sqrtv)/(1.-u)
c          from sqrt(1-u)=0.0   to 0.548 step= 0.055
c          from log10(e)= 0.698970 to 5.477121 step  0.3185
c
      data (   be2(i),i=   1,  63)/
     1  0.0634,  0.0637,  0.0645,  0.0660,  0.0681,  0.0711,  0.0751,
     2  0.0803,  0.0874,  0.0967,  0.1094,  0.0664,  0.0666,  0.0674,
     3  0.0687,  0.0706,  0.0733,  0.0768,  0.0814,  0.0874,  0.0955,
     4  0.1063,  0.0777,  0.0779,  0.0788,  0.0802,  0.0822,  0.0850,
     5  0.0886,  0.0933,  0.0994,  0.1073,  0.1178,  0.0957,  0.0960,
     6  0.0970,  0.0988,  0.1012,  0.1044,  0.1086,  0.1138,  0.1204,
     7  0.1289,  0.1399,  0.1201,  0.1206,  0.1220,  0.1243,  0.1274,
     8  0.1314,  0.1363,  0.1424,  0.1499,  0.1593,  0.1713,  0.1511,
     9  0.1519,  0.1541,  0.1573,  0.1614,  0.1663,  0.1722,  0.1794/
      data (   be2(i),i=  64, 126)/
     1  0.1880,  0.1985,  0.2117,  0.1890,  0.1904,  0.1939,  0.1984,
     2  0.2037,  0.2098,  0.2169,  0.2252,  0.2350,  0.2467,  0.2610,
     3  0.2340,  0.2364,  0.2418,  0.2481,  0.2548,  0.2622,  0.2705,
     4  0.2800,  0.2910,  0.3039,  0.3193,  0.2856,  0.2900,  0.2979,
     5  0.3062,  0.3145,  0.3233,  0.3328,  0.3434,  0.3554,  0.3693,
     6  0.3855,  0.3431,  0.3500,  0.3611,  0.3715,  0.3815,  0.3915,
     7  0.4021,  0.4137,  0.4265,  0.4411,  0.4580,  0.4127,  0.4164,
     8  0.4299,  0.4422,  0.4536,  0.4649,  0.4764,  0.4887,  0.5021,
     9  0.5171,  0.5342,  0.4857,  0.4873,  0.5016,  0.5155,  0.5281/
      data (   be2(i),i= 127, 176)/
     1  0.5403,  0.5525,  0.5653,  0.5790,  0.5941,  0.6111,  0.5589,
     2  0.5595,  0.5728,  0.5877,  0.6012,  0.6140,  0.6267,  0.6397,
     3  0.6535,  0.6685,  0.6852,  0.6295,  0.6299,  0.6405,  0.6559,
     4  0.6699,  0.6832,  0.6960,  0.7091,  0.7227,  0.7373,  0.7536,
     5  0.6943,  0.6948,  0.7021,  0.7170,  0.7312,  0.7445,  0.7574,
     6  0.7702,  0.7836,  0.7978,  0.8135,  0.7525,  0.7532,  0.7568,
     7  0.7705,  0.7844,  0.7975,  0.8102,  0.8228,  0.8358,  0.8496,
     8  0.8648/
c
c
c         energy of gamma
c        5000.       9893.      0.1957e+05  0.3873e+05  0.7663e+05
c       0.1516e+06  0.3000e+06
c       log10 step= 0.296359
c
c       log10 of gamma energy boundary
      data egh1l/ 3.698970/
c    *     ,egh1l/ 5.477121/
c
      data (tcph  (i),i=   1,   7)/
     1  0.7753,  0.7741,  0.7747,  0.7559,  0.7058,  0.6257,  0.5273/
c
c        table of v
c        from u= 0.0    to  1.0000 step  0.1000
c        from log10(e)= 3.698970 to 5.477121 step  0.2964
c
      data (   vp (i),i=   1,  72)/
     1 1.0000, 0.9602, 0.9183, 0.8740, 0.8274, 0.7782, 0.7265, 0.6723,
     2 0.6161, 0.5586, 0.5000, 1.0000, 0.9603, 0.9184, 0.8741, 0.8271,
     3 0.7775, 0.7255, 0.6713, 0.6154, 0.5582, 0.5000, 1.0000, 0.9602,
     4 0.9181, 0.8735, 0.8268, 0.7778, 0.7262, 0.6723, 0.6164, 0.5588,
     5 0.5000, 1.0000, 0.9611, 0.9201, 0.8772, 0.8318, 0.7834, 0.7318,
     6 0.6773, 0.6200, 0.5605, 0.5000, 1.0000, 0.9637, 0.9258, 0.8852,
     7 0.8414, 0.7936, 0.7418, 0.6860, 0.6265, 0.5641, 0.5000, 1.0000,
     8 0.9680, 0.9339, 0.8961, 0.8540, 0.8071, 0.7549, 0.6976, 0.6352,
     9 0.5687, 0.5000, 1.0000, 0.9730, 0.9428, 0.9081, 0.8686, 0.8222/
      data (   vp (i),i=  73,  77)/
     1 0.7700, 0.7110, 0.6454, 0.5743, 0.5000/
c
c    -------------------                  ------------------
c       total prob. equivalenced to common
c
      equivalence (tprob,tp)
c

c
c
c                      0.762 =(7/9-b)*rx0 =.773*rx0
      data rx0/0.986/, ctpc/.762/,  cep/ 5.e3/
c       rx0=x0(true)/x0(in nishimura text)=13.7/13.9
c       cep: min. energy for landau correc for pair
c            default esbc    espc
      data esbin/10./,  espin/100./
c
c
      if(ee .lt. eblmin) then
          t=1.e36
      else
          if(.not. usees) then
             esb=esbin
          else
             esb=min(escb, eblmax)
          endif
          if(ee .gt. esb) then
              screen=.false.
              if(lcorec .and. ee .gt. eeh1) then
                  if(ee .gt. eeh2) then
                       write(6,'('' ee > eeh2 in brmfet: ee='',g12.4)')
     *                 ee
                       stop
                  endif
                  landau=.true.
                  ale=log10(ee)
c                 tp=fintp3(tcbh, eeh1l, deelh, neeh, ale)*rx0
                  call kintp3(tcbh, 1, neeh, eeh1l, deelh, ale, tp)
                  tp=tp*rx0
              else
                  landau=.false.
c                     complete screening cross-section
                  vc=ec/ee
                  tp=(-1.3603*(log(vc)-vc)-vc*vc*.5-.8603 )*rx0
              endif
          else
              landau=.false.
              if(scorec) then
                  screen=.true.
                  ale=log10(ee)
c                 tp=fintp3(tcbl, etcbl1, debtcl, nbtcl,  ale)
                  call kintp3(tcbl, 1, nbtcl, etcbl1, debtcl,  ale, tp)
              else
                  screen=.false.
c                     complete screening cross-section
                  vc=ec/ee
                  tp=(-1.3603*(log(vc)-vc)-vc*vc*.5-.8603 )*rx0
              endif
          endif
c
          call rndc(u)
          t =-log(u)/tp
      endif
      return
c
c     ************
      entry brmfee(ee,ec,beg)
c     ************
c
      call rndc(u)
      if(screen) then
c           partial screening
         if(u .gt. uela1) then
c                  region a
c              beg=exp( tdint4(bla, nuela, neela, uela1, eela1l, duela,
c    *         deela, u,  ale)*(1.-u) ) *egmnl
               call k4ptdi(bla, nuela, neela, nuela, uela1, eela1l,
     *         duela, deela, u, ale, ans)
               beg=exp( ans*(1.-u))*egmnl
         else
c                  region b
               us=sqrt(u)
c              beg=exp( tdint4(blb, nuelb, neelb, uelb1, eelb1l,duelb,
c    *         deelb, us, ale)) * egmnl
               call k4ptdi(blb, nuelb, neelb, nuelb, uelb1, eelb1l,
     *         duelb, deelb, us, ale, ans)
               beg=exp(ans)*egmnl
         endif
      elseif(landau) then
         if(u .lt. ueh2) then
c              beg=exp( tdint4(be1, nueh1, neeh, ueh1, eeh1l, dueh1,
c    *         deelh, u,  ale)  ) * egmnh
               call k4ptdi(be1, nueh1, neeh, nueh1,  ueh1, eeh1l,
     *         dueh1, deelh, u,  ale, ans)
               beg=exp( ans ) *egmnh
         else
               us=sqrt(1.-u)
c              beg=   ( tdint4(be2, nueh2, neeh, ueh3, eeh1l, dueh2,
c    *         deelh, us,  ale)*(1.-u)+ sqrt(egmnh/ee) )**2 *ee
               call k4ptdi(be2, nueh2, neeh, nueh2,  ueh3, eeh1l,
     *         dueh2, deelh, us,  ale, ans)
               beg=  (ans*(1.-u) + sqrt(egmnh/ee) )**2*ee
         endif
      else
c               complete screening
          a=u*tp
          if(a .le. 1.) then
             v=exp(-a)
             if(a .gt. .1) then
                 v=((.06366*a-.1447407)*a+1.014176)*v
             endif
          else
             v=exp(-(a+0.8603)/1.3603)
             if(a .le. 6.) then
                 v=((((2.050445e-3*a-3.53209e-2)*a+.228937)*a-.684076)*a
     *           +1.841734)*v
             endif
          endif
          beg=ee*v
      endif
      return
c
c
c     ***********
      entry prcfet(eg,t)
c     ***********
c
c
c
      if(eg .le. emass2) then
          t=1.e37
      elseif(eg .lt. eplmin .and. scorec) then
          tp=( (eg-emass2)/(eplmin-emass2) )**3 * tcpl(1)
          call rndc(u)
          t =-log(u)/tp
          landau=.false.
          screen=.true.
      else
          if(.not. usees) then
             esp=espin
          else
             esp=min(escp, eplmax)
          endif
          if(eg .gt. esp) then
              screen=.false.
              if(eg .gt. cep  .and. lcorec) then
                  landau=.true.
                  ale=log10(eg)
c                 tp=fintp3(tcph, egh1l, deghl, negh, ale)*rx0
                  call kintp3(tcph, 1, negh,  egh1l,  deghl,   ale, tp)
                  tp=tp*rx0
              else
                  landau=.false.
c                     complete screening cross-section
                  tp=ctpc
              endif
          else
              landau=.false.
              if(scorec) then
                  screen=.true.
                  ale=log10(eg)
c                 tp=fintp3(tcpl, etcpl1, deptcl, nptcl, ale)
                  call kintp3(tcpl, 1,nptcl,  etcpl1, deptcl,  ale, tp)
              else
                  screen=.false.
c                     complete screening cross-section
                  tp=ctpc
              endif
          endif
          call rndc(u)
          t =-log(u)/tp
      endif
      return
c
c
c     ***********
      entry prcfee(eg,e1)
c     ***********
c
c
c
      call rndc(u)
      if(screen) then
c           partial screening
         if(u .ge. ugla1) then
c                   region a
c               e1=(tdint4(pla, nugla, negla, ugla1, egla1l, dugla,
c    *          degla, u,    ale) *(1.-u) + .5 )*eg
                call k4ptdi(pla, nugla, negla,nugla,  ugla1, egla1l,
     *          dugla, degla, u,   ale, ans)
                e1=(ans*(1.-u) + .5)*eg
         else
c                   region b
                us=sqrt(u)
                ex=sqrt(ale-eglb1l)
                call k4ptdi(plb, nuglb, neglb,nuglb,  uglb1, 0.d0,
     *          duglb, deglb, us,  ale, ans)
                e1=ans*eg
         endif
      elseif(landau) then
c        e1= tdint4(vp, nugh2, negh, ugh3, egh1l, dugh2,
c    *   deghl, u,  ale) * eg
         call k4ptdi(vp, nugh2, negh, nugh2, ugh3, egh1l,
     *   dugh2, deghl, u,  ale, ans)
         e1=ans*eg
      else
c                complete screening
         e1=(((.0441223*u-.173755)*u-.3708608)*u+1.)*eg
      endif
      return
c
c     ************
      entry emctfe(Knckon)
c     ************
c
c         see for def. emctpb
      cconst=.957
      x0=1.74
      x0ing=13.7
      x0sq=3.0276
      if(Knckon) then
          ecrit=17.0e-3
      else
          ecrit=20.e-3
      endif
      constm=1.913
      rho = 7.86
c
      zchrg=26.
      zchrg2 = 676.
      amassn=55.85
      ionizP = 285.42d-9
      end
