c     ************************ for H2O*********************************
c     *                                                              *
c     *  brmH2Ot:  samples path for brems                             *
c     *  brmH2Oe:  samples energy of brems gamma                      *
c     *  prcH2Ot:  samples path for pair creation                     *
c     *  prcH2Oe:  samples energy of pair electron (higher energy)    *
c     *  emctH2O:  set const in common for H2O                         *
c     *                                                              *
c
c      material   z     a     rho     t0 (g/cm2)  t0 (cm)    ec
c         H2O     7.22 57.0   1.0     36.08        36.1     72.1
c brems:
c        electron energy:      1 MeV to 5000TeV
c        brems gamma energy:   .1mev or more
c           if electron energy is < 1mev,  sampled path is set to be
c        very large one so that real brems may not take place before
c        the death by energy loss.
c pair:
c        gamma energy:         3 MeV to 5000 TeV
c           if gamma energy is < 3MeV, sampled path is set to be
c        very large one so that real pair creation may not take place
c        before compton or another process takes place.
c
c
c
c
c   /usage/          call brmH2Ot(ee,ec,t)
c                    call brmH2Oe(ee,ec,beg)
c
c                    call prcH2Ot(eg,t)
c                    call prcH2Oe(eg,e1)
c
c      ee:  incident electron energy
c      ec:  cut-off energy of brems gamma (used if complete screening
c           cross section is to be used).
c       t:  sampled path
c     beg:  sampled gamma energy
c      eg:  incident gamma energy
c      e1:  sampled electron energy (higher energy in pair)
c
c  *** note ***
c
c          before calling brmH2Oe, brmH2Ot must have been called.
c          //             prcH2Oe, prcH2Ot //
c
c          by the parameters in $elmag the user can control:
c
c        ee  -------------- 5gev------->  (if usees=t, escb instead 5)
c     scorec=t       p.s    !
c     lcorec=t              !    l.c
c     scorec=f       c.s    !
c     lcorec=f              !    c.s
c
c        eg  --------------50gev--5tev---> (if usees=t, escp instead 50)
c     scorec=t       p.s    ! c.s !
c     lcorec=t              ! c.s ! l.c
c     scorec=f       c.s    ! c.s !
c     lcorec=f              !     ! c.s
c
c
c
c
      subroutine brmH2Ot(ee,ec,t)
      implicit none
c
c
#include  "Zelmag.h"
#include  "Zemdef.h"
c
      integer i
      logical screen,landau
      save screen,landau
c
c ------------------------- partical screening ----------------------
c           *** electron ***
c
c           ! egmin (gev)  for brems.
      data egmnl/.1e-3/
c
      parameter (eblmin=1.e-3, eblmax=50., nbtcl=40)
      dimension tcbl(nbtcl)
c
c             brem:   region a
c
      parameter (eela1=eblmin, eela2=eblmax,neela=20,
     * uela1=.05, uela2=1., nuela=20, duela=(uela2-uela1)/(nuela-1) )
      dimension bla(nuela * neela)
c
c             brem:  region b  (sqrt(u))
      parameter (eelb1=eblmin, eelb2=eblmax, neelb=neela,
     * uelb1=0.,  uelb2=.2236068, nuelb=20,
     * duelb=(uelb2-uelb1)/(nuelb-1) )
      dimension blb(nuelb * neelb)
c
c           ** gamma ***
c
c                 total cross-section
      parameter (eplmin=3.e-3, eplmax= 30., nptcl=16)
      dimension tcpl(nptcl)
c
c          pair: region a
      parameter ( egla1=eplmin,  egla2=eplmax, negla=16,
     *   ugla1=.05, ugla2=1., nugla=16,dugla=(ugla2-ugla1)/(nugla-1) )
      dimension pla(nugla *  negla)
c
c            pair: region b     sqrt(log10(e)) sqrt(u)
      parameter (eglb1=eplmin, eglb2=eplmax, neglb=15,
     *  uglb1=0., uglb2=.2236068, nuglb=16,
     *  duglb=(uglb2-uglb1)/(nuglb-1))
      dimension plb(nuglb * neglb)
c
c -------------------------------------------------------------------

c
c      -------------------- landau ------------------------------

c          **** electron ****
c
      data egmnh/1.e-4/
      parameter (eeh1=50., eeh2 = 5000.e3, neeh=25, dueh1=.1,
     *  ueh1=0., ueh2=.7, nueh1=(ueh2-ueh1+.00001)/dueh1+1)
      dimension  tcbh(neeh)
      dimension  be1(nueh1 * neeh)
c
c                         sqrt(1-.7)
      parameter (ueh3=0., ueh4=0.5477225,
     *nueh2=11, dvueh2=nueh2-1, dueh2=(ueh4 - ueh3)/dvueh2)
      dimension be2(nueh2 * neeh)
c
c
c         *** gamma ****
c
      parameter ( egh1=10000., egh2= 5000.e3, negh=20, dugh2=.1,
     * ugh3=0., ugh4=1., nugh2=(ugh4-ugh3+.00001)/dugh2+1)
      dimension tcph(negh)
      dimension vp(nugh2 * negh)
c
c      -------------------- landau ------------------------------
      data debtcl/  .120486/
      data deela/  .247314/
      data deelb/  .247314/
      data deptcl/  .266667/
      data degla/  .266667/
      data deglb/  .142857/
c        electron energy=
c       .10000E-02  .13197E-02  .17417E-02  .22986E-02  .30335E-02
c       .40034E-02  .52835E-02  .69728E-02  .92022E-02  .12144E-01
c       .16027E-01  .21152E-01  .27915E-01  .36840E-01  .48619E-01
c       .64165E-01  .84680E-01  .11176      .14749      .19464    
c       .25688      .33901      .44741      .59046      .77925    
c       1.0284      1.3572      1.7912      2.3639      3.1197    
c       4.1171      5.4335      7.1708      9.4635      12.489    
c       16.483      21.753      28.708      37.887      50.000    
c       log10 step=   .1205
c
c      log10 of electron energy boundary
      data  etcbl1/-3.000000/
c    *     ,etcbl2/ 1.698970/
c
           data ( tcbl(i), i= 1,  40)/
     1  1.0564, 1.4745, 1.9094, 2.3629, 2.8243, 3.2899, 3.7558, 4.2186,
     2  4.6769, 5.1291, 5.5748, 6.0139, 6.4466, 6.8729, 7.2934, 7.7079,
     3  8.1182, 8.5232, 8.9240, 9.3215, 9.7156,10.1066,10.4955,10.8821,
     4 11.2667,11.6499,12.0320,12.4129,12.7931,13.1725,13.5512,13.9294,
     5 14.3073,14.6848,15.0620,15.4391,15.8160,16.1928,16.5695,16.9462  
     * /   
c
c       brem: region a
c        electron energy=
c       .10000E-02  .17673E-02  .31234E-02  .55200E-02  .97557E-02
c       .17241E-01  .30471E-01  .53852E-01  .95173E-01  .16820    
c       .29726      .52536      .92848      1.6409      2.9000    
c       5.1252      9.0579      16.008      28.292      50.000    
c       log10 step=   .2473
c
c      log10 of electron energy boundary
      data  eela1l/-3.000000/
c    *     ,eela2l/ 1.698970/
c
c
c            bla(iu,ie)=alog(v/vmin)/(1.-u)
c            u= .050 to 1.000 step=  .0500
c            log10(e)= -3.0000 to   1.6990 step=  .2473
c
           data ( bla(i), i= 1,  119)/
     1   1.4842,  1.4128,  1.3591,  1.3150,  1.2766,  1.2461,  1.2173,
     2   1.1905,  1.1691,  1.1465,  1.1289,  1.1107,  1.0936,  1.0802,
     3   1.0644,  1.0536,  1.0358,  1.0194,  1.0183,  1.0052,  2.2573,
     4   2.1278,  2.0371,  1.9659,  1.9076,  1.8587,  1.8160,  1.7809,
     5   1.7466,  1.7167,  1.6897,  1.6623,  1.6438,  1.6190,  1.6021,
     6   1.5811,  1.5728,  1.5587,  1.5346,  1.5234,  2.9057,  2.7517,
     7   2.6450,  2.5641,  2.4987,  2.4431,  2.3974,  2.3594,  2.3247,
     8   2.2908,  2.2675,  2.2456,  2.2256,  2.2037,  2.1888,  2.1731,
     9   2.1598,  2.1510,  2.1360,  2.1227,  3.5365,  3.3740,  3.2614,
     a   3.1803,  3.1134,  3.0627,  3.0195,  2.9840,  2.9544,  2.9278,
     b   2.9036,  2.8814,  2.8635,  2.8478,  2.8306,  2.8168,  2.8039,
     c   2.7979,  2.7789,  2.7768,  4.1618,  4.0003,  3.8914,  3.8132,
     d   3.7526,  3.7030,  3.6650,  3.6304,  3.6035,  3.5783,  3.5587,
     e   3.5413,  3.5269,  3.5109,  3.5011,  3.4878,  3.4789,  3.4672,
     f   3.4635,  3.4615,  4.7822,  4.6275,  4.5235,  4.4487,  4.3907,
     g   4.3463,  4.3090,  4.2785,  4.2559,  4.2357,  4.2200,  4.2067,
     h   4.1919,  4.1851,  4.1749,  4.1657,  4.1607,  4.1634,  4.1449   
     * /   
           data ( bla(i), i= 120,  238)/
     1   4.1467,  5.3969,  5.2503,  5.1481,  5.0749,  5.0203,  4.9785,
     2   4.9455,  4.9191,  4.9000,  4.8827,  4.8682,  4.8585,  4.8502,
     3   4.8416,  4.8344,  4.8328,  4.8269,  4.8151,  4.8155,  4.8160,
     4   6.0066,  5.8607,  5.7619,  5.6912,  5.6388,  5.6007,  5.5703,
     5   5.5471,  5.5299,  5.5151,  5.5054,  5.4981,  5.4890,  5.4825,
     6   5.4794,  5.4736,  5.4752,  5.4703,  5.4583,  5.4648,  6.6061,
     7   6.4619,  6.3625,  6.2939,  6.2450,  6.2078,  6.1810,  6.1620,
     8   6.1452,  6.1338,  6.1238,  6.1178,  6.1131,  6.1078,  6.1011,
     9   6.0985,  6.0958,  6.0905,  6.0940,  6.0941,  7.1984,  7.0510,
     a   6.9514,  6.8852,  6.8371,  6.8043,  6.7788,  6.7623,  6.7483,
     b   6.7382,  6.7285,  6.7229,  6.7200,  6.7171,  6.7135,  6.7129,
     c   6.7132,  6.7160,  6.7118,  6.7067,  7.7804,  7.6307,  7.5321,
     d   7.4655,  7.4203,  7.3893,  7.3660,  7.3496,  7.3392,  7.3295,
     e   7.3245,  7.3196,  7.3150,  7.3139,  7.3127,  7.3080,  7.3119,
     f   7.3067,  7.2919,  7.3066,  8.3557,  8.2018,  8.1035,  8.0386,
     g   7.9963,  7.9662,  7.9465,  7.9327,  7.9229,  7.9165,  7.9090,
     h   7.9073,  7.9043,  7.9004,  7.9021,  7.9010,  7.8976,  7.8951   
     * /   
           data ( bla(i), i= 239,  357)/
     1   7.8972,  7.8970,  8.9262,  8.7691,  8.6691,  8.6068,  8.5656,
     2   8.5388,  8.5207,  8.5080,  8.5004,  8.4945,  8.4903,  8.4858,
     3   8.4860,  8.4831,  8.4843,  8.4830,  8.4807,  8.4757,  8.4741,
     4   8.4803,  9.4916,  9.3301,  9.2317,  9.1726,  9.1343,  9.1100,
     5   9.0922,  9.0825,  9.0741,  9.0688,  9.0673,  9.0658,  9.0628,
     6   9.0598,  9.0584,  9.0572,  9.0595,  9.0519,  9.0713,  9.0589,
     7  10.0542,  9.8903,  9.7937,  9.7358,  9.6987,  9.6771,  9.6625,
     8   9.6536,  9.6471,  9.6422,  9.6413,  9.6392,  9.6382,  9.6381,
     9   9.6375,  9.6375,  9.6391,  9.6291,  9.6430,  9.6343, 10.6149,
     a  10.4472, 10.3514, 10.2977, 10.2644, 10.2428, 10.2300, 10.2230,
     b  10.2167, 10.2133, 10.2122, 10.2108, 10.2088, 10.2100, 10.2100,
     c  10.2071, 10.2109, 10.2108, 10.2255, 10.2074, 11.1740, 11.0052,
     d  10.9114, 10.8580, 10.8282, 10.8088, 10.7975, 10.7902, 10.7871,
     e  10.7830, 10.7833, 10.7816, 10.7820, 10.7799, 10.7811, 10.7814,
     f  10.7767, 10.7868, 10.7762, 10.7791, 11.7327, 11.5618, 11.4715,
     g  11.4205, 11.3918, 11.3749, 11.3664, 11.3584, 11.3547, 11.3543,
     h  11.3521, 11.3513, 11.3488, 11.3485, 11.3509, 11.3467, 11.3518   
     * /   
           data ( bla(i), i= 358,  400)/
     1  11.3495, 11.3573, 11.3499, 12.2910, 12.1198, 12.0306, 11.9831,
     2  11.9568, 11.9414, 11.9315, 11.9270, 11.9245, 11.9229, 11.9217,
     3  11.9216, 11.9199, 11.9175, 11.9226, 11.9237, 11.9214, 11.9254,
     4  11.9182, 11.9201, 12.8489, 12.6769, 12.5911, 12.5455, 12.5221,
     5  12.5077, 12.5005, 12.4966, 12.4951, 12.4903, 12.4928, 12.4887,
     6  12.4892, 12.4901, 12.4914, 12.4881, 12.4886, 12.4893, 12.4773,
     7  12.4900                                                         
     * /   

c
c       brem: region b
c        electron energy=
c       .10000E-02  .17673E-02  .31234E-02  .55200E-02  .97557E-02
c       .17241E-01  .30471E-01  .53852E-01  .95173E-01  .16820    
c       .29726      .52536      .92848      1.6409      2.9000    
c       5.1252      9.0579      16.008      28.292      50.000    
c       log10 step=   .2473
c
c      log10 of electron energy boundary
      data  eelb1l/-3.000000/
c    *     ,eelb2l/ 1.698970/
c
c
c            blb(iu,ie)=alog(v/vmin)/(1.-u)
c            sqrt(u)= .000 to  .224 step=  .0118
c            log10(e)= -3.0000 to   1.6990 step=  .2473
c
           data ( blb(i), i= 1,  119)/
     1   1.5872,-10.1959,  1.5844,  1.5813,  1.5781,  1.5719,  1.5655,
     2   1.5592,  1.5512,  1.5415,  1.5317,  1.5202,  1.5085,  1.4967,
     3   1.4831,  1.4692,  1.4551,  1.4409,  1.4246,  1.4099,  2.5308,
     4   2.5285,  2.5231,  2.5121,  2.4993,  2.4843,  2.4653,  2.4460,
     5   2.4263,  2.4036,  2.3809,  2.3566,  2.3318,  2.3074,  2.2812,
     6   2.2544,  2.2280,  2.2009,  2.1731,  2.1444,  3.2629,  3.2588,
     7   3.2456,  3.2282,  3.2086,  3.1851,  3.1604,  3.1352,  3.1082,
     8   3.0804,  3.0519,  3.0225,  2.9910,  2.9610,  2.9288,  2.8955,
     9   2.8624,  2.8297,  2.7959,  2.7608,  3.9138,  3.9060,  3.8905,
     a   3.8707,  3.8470,  3.8232,  3.7977,  3.7705,  3.7414,  3.7114,
     b   3.6805,  3.6487,  3.6157,  3.5817,  3.5464,  3.5113,  3.4734,
     c   3.4371,  3.3978,  3.3603,  4.5266,  4.5168,  4.5011,  4.4806,
     d   4.4592,  4.4352,  4.4094,  4.3831,  4.3537,  4.3246,  4.2922,
     e   4.2599,  4.2253,  4.1895,  4.1537,  4.1151,  4.0765,  4.0364,
     f   3.9946,  3.9526,  5.1198,  5.1100,  5.0942,  5.0756,  5.0552,
     g   5.0332,  5.0086,  4.9822,  4.9551,  4.9250,  4.8939,  4.8605,
     h   4.8260,  4.7889,  4.7517,  4.7117,  4.6715,  4.6297,  4.5860   
     * /   
           data ( blb(i), i= 120,  238)/
     1   4.5420,  5.7024,  5.6926,  5.6788,  5.6622,  5.6438,  5.6219,
     2   5.5996,  5.5745,  5.5476,  5.5176,  5.4867,  5.4536,  5.4181,
     3   5.3812,  5.3430,  5.3032,  5.2618,  5.2186,  5.1734,  5.1278,
     4   6.2793,  6.2714,  6.2576,  6.2431,  6.2257,  6.2060,  6.1838,
     5   6.1599,  6.1332,  6.1047,  6.0741,  6.0412,  6.0060,  5.9696,
     6   5.9303,  5.8880,  5.8454,  5.8008,  5.7542,  5.7052,  6.8529,
     7   6.8450,  6.8332,  6.8207,  6.8044,  6.7859,  6.7648,  6.7411,
     8   6.7146,  6.6874,  6.6558,  6.6233,  6.5883,  6.5508,  6.5105,
     9   6.4684,  6.4230,  6.3770,  6.3272,  6.2765,  7.4247,  7.4188,
     a   7.4089,  7.3955,  7.3803,  7.3618,  7.3419,  7.3194,  7.2941,
     b   7.2660,  7.2346,  7.2011,  7.1651,  7.1264,  7.0848,  7.0400,
     c   6.9931,  6.9439,  6.8921,  6.8375,  7.9955,  7.9896,  7.9797,
     d   7.9693,  7.9541,  7.9367,  7.9169,  7.8945,  7.8693,  7.8413,
     e   7.8089,  7.7754,  7.7370,  7.6971,  7.6528,  7.6064,  7.5562,
     f   7.5034,  7.4493,  7.3903,  8.5657,  8.5598,  8.5519,  8.5420,
     g   8.5274,  8.5100,  8.4902,  8.4679,  8.4417,  8.4126,  8.3803,
     h   8.3444,  8.3047,  8.2620,  8.2160,  8.1664,  8.1141,  8.0574   
     * /   
           data ( blb(i), i= 239,  357)/
     1   7.9990,  7.9387,  9.1356,  9.1316,  9.1238,  9.1119,  9.0993,
     2   9.0820,  9.0622,  9.0388,  9.0116,  8.9813,  8.9478,  8.9094,
     3   8.8682,  8.8226,  8.7747,  8.7216,  8.6654,  8.6076,  8.5444,
     4   8.4808,  9.7053,  9.7013,  9.6935,  9.6836,  9.6700,  9.6527,
     5   9.6319,  9.6085,  9.5802,  9.5476,  9.5127,  9.4729,  9.4289,
     6   9.3802,  9.3289,  9.2734,  9.2146,  9.1521,  9.0855,  9.0180,
     7  10.2749, 10.2709, 10.2650, 10.2532, 10.2396, 10.2223, 10.2015,
     8  10.1760, 10.1465, 10.1126, 10.0752, 10.0326,  9.9869,  9.9361,
     9   9.8813,  9.8217,  9.7600,  9.6942,  9.6238,  9.5515, 10.8444,
     a  10.8405, 10.8346, 10.8247, 10.8091, 10.7918, 10.7689, 10.7423,
     b  10.7116, 10.6764, 10.6364, 10.5922, 10.5433, 10.4891, 10.4318,
     c  10.3695, 10.3030, 10.2336, 10.1610, 10.0842, 11.4139, 11.4100,
     d  11.4041, 11.3942, 11.3786, 11.3593, 11.3363, 11.3085, 11.2755,
     e  11.2390, 11.1962, 11.1490, 11.0982, 11.0418, 10.9805, 10.9152,
     f  10.8453, 10.7721, 10.6956, 10.6154, 11.9834, 11.9814, 11.9736,
     g  11.9617, 11.9471, 11.9277, 11.9027, 11.8737, 11.8393, 11.8003,
     h  11.7560, 11.7057, 11.6515, 11.5927, 11.5287, 11.4586, 11.3869   
     * /   
           data ( blb(i), i= 358,  400)/
     1  11.3096, 11.2294, 11.1462, 12.5529, 12.5509, 12.5431, 12.5312,
     2  12.5156, 12.4951, 12.4689, 12.4377, 12.4020, 12.3615, 12.3144,
     3  12.2622, 12.2045, 12.1418, 12.0748, 12.0031, 11.9276, 11.8460,
     4  11.7630, 11.6766, 13.1224, 13.1204, 13.1125, 13.1006, 13.0840,
     5  13.0615, 13.0352, 13.0028, 12.9647, 12.9215, 12.8726, 12.8186,
     6  12.7573, 12.6919, 12.6220, 12.5469, 12.4675, 12.3838, 12.2975,
     7  12.2067                                                         
     * /   
c
c       pair: total x-section
c        gamm energy=
c       .30000E-02  .55435E-02  .10244E-01  .18929E-01  .34977E-01
c       .64633E-01  .11943      .22069      .40781      .75357    
c       1.3925      2.5731      4.7547      8.7859      16.235    
c       30.000    
c       log10 step=   .2667
c
c      log10 of gamma energy boundary
      data  etcpl1/-2.522879/
c    *     ,etcpl2/ 1.477121/
c
           data ( tcpl(i), i= 1,  16)/
     1    .0489,   .1253,   .2119,   .3030,   .3941,   .4821,   .5621,
     2    .6281,   .6769,   .7109,   .7338,   .7487,   .7582,   .7641,
     3    .7678,   .7700                                                
     * /   
c
c       pair: region a
c
c         energy of gamma=
c         .300E-02    .554E-02    .102E-01    .189E-01    .350E-01
c         .646E-01    .119        .221        .408        .754    
c         1.39        2.57        4.75        8.79        16.2    
c         30.0    
c         log10 step=  .266667
c
c         log10 of eg boundary
      data  egla1l/-2.522879/
c    *     ,egla2l/ 1.477121/
c
c
c         pla(iu,ie)=(v-.5)/(1.-u)
c         u= .050 to1.000   step=  .0633
c            log10(e)= -2.5229 to   1.4771 step=  .2667
c
           data ( pla(i), i= 1,  119)/
     1    .2908,   .2767,   .2698,   .2635,   .2579,   .2552,   .2525,
     2    .2497,   .2491,   .2465,   .2450,   .2453,   .2457,   .2415,
     3    .2389,   .2432,   .3748,   .3620,   .3546,   .3485,   .3447,
     4    .3415,   .3403,   .3372,   .3369,   .3343,   .3333,   .3349,
     5    .3333,   .3301,   .3333,   .3327,   .4192,   .4090,   .4020,
     6    .3985,   .3956,   .3935,   .3925,   .3913,   .3897,   .3898,
     7    .3901,   .3904,   .3910,   .3921,   .3956,   .3891,   .4459,
     8    .4371,   .4326,   .4297,   .4277,   .4281,   .4271,   .4276,
     9    .4261,   .4267,   .4274,   .4285,   .4303,   .4267,   .4303,
     a    .4286,   .4625,   .4560,   .4531,   .4509,   .4511,   .4513,
     b    .4516,   .4537,   .4544,   .4553,   .4566,   .4584,   .4566,
     c    .4603,   .4566,   .4583,   .4730,   .4688,   .4675,   .4673,
     d    .4684,   .4697,   .4713,   .4714,   .4737,   .4742,   .4780,
     e    .4761,   .4780,   .4818,   .4780,   .4810,   .4805,   .4788,
     f    .4780,   .4796,   .4816,   .4838,   .4867,   .4882,   .4925,
     g    .4930,   .4968,   .4988,   .5019,   .5007,   .4968,   .5013,
     h    .4865,   .4862,   .4882,   .4905,   .4946,   .4980,   .5022   
     * /   
           data ( pla(i), i= 120,  238)/
     1    .5055,   .5076,   .5129,   .5142,   .5161,   .5193,   .5180,
     2    .5295,   .5222,   .4917,   .4927,   .4963,   .5005,   .5055,
     3    .5099,   .5153,   .5201,   .5240,   .5268,   .5306,   .5326,
     4    .5358,   .5422,   .5460,   .5403,   .4953,   .4988,   .5040,
     5    .5088,   .5144,   .5197,   .5244,   .5303,   .5356,   .5402,
     6    .5436,   .5486,   .5518,   .5505,   .5466,   .5544,   .4987,
     7    .5035,   .5091,   .5142,   .5204,   .5262,   .5333,   .5383,
     8    .5448,   .5483,   .5532,   .5566,   .5624,   .5662,   .5624,
     9    .5648,   .5009,   .5059,   .5128,   .5196,   .5262,   .5325,
     a    .5386,   .5443,   .5494,   .5562,   .5595,   .5645,   .5677,
     b    .5664,   .5780,   .5721,   .5026,   .5082,   .5153,   .5222,
     c    .5291,   .5357,   .5421,   .5482,   .5539,   .5588,   .5658,
     d    .5685,   .5730,   .5742,   .5781,   .5771,   .5026,   .5104,
     e    .5165,   .5236,   .5305,   .5373,   .5439,   .5502,   .5561,
     f    .5640,   .5689,   .5724,   .5782,   .5820,   .5782,   .5803,
     g    .5047,   .5116,   .5177,   .5249,   .5319,   .5389,   .5456,
     h    .5522,   .5584,   .5641,   .5689,   .5724,   .5782,   .5820   
     * /   
           data ( pla(i), i= 239,  256)/
     1    .5782,   .5824,   .5047,   .5116,   .5189,   .5262,   .5334,
     2    .5404,   .5474,   .5541,   .5606,   .5666,   .5720,   .5763,
     3    .5782,   .5821,   .5782,   .5837                              
     * /   
c
c
c       pair: region b
c
c         energy of gamma=
c         .300E-02    .314E-02    .362E-02    .458E-02    .636E-02
c         .971E-02    .163E-01    .300E-01    .607E-01    .135    
c         .330        .884        2.61        8.44        30.0    
c         sqrt(log10) step=  .142857
c
c         use 0 for e-side at interpolation
c         with sqrt(log10(e)-eglb1l)
      data  eglb1l/-2.522879/
c
c
c         plb(iu,ie)=v
c         sqrt(u)= .000 to .224   step=  .0149
           data ( plb(i), i= 1,  119)/
     1    .8297,   .8264,   .8239,   .8200,   .8161,   .8136,   .8097,
     2    .8058,   .8033,   .7994,   .7955,   .7917,   .7878,   .7840,
     3    .7801,   .7762,   .8375,   .8355,   .8329,   .8289,   .8263,
     4    .8223,   .8184,   .8157,   .8118,   .8078,   .8039,   .8012,
     5    .7973,   .7933,   .7894,   .7854,   .8589,   .8582,   .8554,
     6    .8525,   .8497,   .8455,   .8427,   .8385,   .8357,   .8315,
     7    .8273,   .8245,   .8203,   .8161,   .8119,   .8077,   .8884,
     8    .8877,   .8861,   .8831,   .8801,   .8770,   .8740,   .8694,
     9    .8664,   .8619,   .8588,   .8543,   .8497,   .8467,   .8421,
     a    .8376,   .9197,   .9189,   .9172,   .9140,   .9123,   .9090,
     b    .9041,   .9008,   .8976,   .8943,   .8894,   .8861,   .8812,
     c    .8779,   .8730,   .8680,   .9474,   .9465,   .9448,   .9413,
     d    .9395,   .9360,   .9325,   .9290,   .9255,   .9220,   .9168,
     e    .9133,   .9098,   .9046,   .9011,   .8958,   .9686,   .9677,
     f    .9659,   .9622,   .9604,   .9567,   .9531,   .9512,   .9476,
     g    .9439,   .9402,   .9348,   .9311,   .9274,   .9238,   .9183,
     h    .9830,   .9820,   .9801,   .9783,   .9745,   .9726,   .9688   
     * /   
           data ( plb(i), i= 120,  238)/
     1    .9650,   .9632,   .9594,   .9556,   .9518,   .9481,   .9443,
     2    .9400,   .9363,   .9916,   .9906,   .9887,   .9868,   .9849,
     3    .9810,   .9791,   .9772,   .9733,   .9695,   .9676,   .9637,
     4    .9604,   .9565,   .9527,   .9489,   .9962,   .9952,   .9933,
     5    .9914,   .9894,   .9875,   .9856,   .9836,   .9797,   .9778,
     6    .9739,   .9720,   .9686,   .9657,   .9618,   .9579,   .9984,
     7    .9975,   .9955,   .9955,   .9936,   .9916,   .9897,   .9877,
     8    .9858,   .9838,   .9800,   .9780,   .9746,   .9717,   .9688,
     9    .9658,   .9994,   .9984,   .9984,   .9965,   .9965,   .9945,
     a    .9926,   .9906,   .9887,   .9867,   .9848,   .9828,   .9789,
     b    .9770,   .9745,   .9716,   .9998,   .9988,   .9988,   .9988,
     c    .9969,   .9949,   .9949,   .9930,   .9910,   .9891,   .9871,
     d    .9852,   .9832,   .9813,   .9793,   .9759,   .9999,   .9990,
     e    .9990,   .9990,   .9970,   .9970,   .9951,   .9951,   .9931,
     f    .9912,   .9892,   .9872,   .9853,   .9833,   .9814,   .9775,
     g   1.0000,   .9990,   .9990,   .9990,   .9990,   .9971,   .9971,
     h    .9951,   .9931,   .9931,   .9912,   .9892,   .9873,   .9853   
     * /   
           data ( plb(i), i= 239,  240)/
     1    .9814,   .9795                                                
     * /   
c
c
c    ---------------     $$$   landau correction region $$$     ----
c      media=H2O  z=  7.22 a= 14.33 rho=     1.00    
c       0*** constant used in landau effect
c         z=   7.22 a=  14.33 rho=   1.00 x0= 36.634cm= 36.634g/cm**2 
c       s1= .112E-03 ln(s1)=-9.10      const in eq.60 of migdal= .351E+05
c       gamma cut off energy = .100E-03gev

      data deelh/  .208333/
      data deghl/  .142051/
c
c          energy of electron
c        50.00       80.78       130.5       210.8       340.6    
c        550.3       889.1       1436.       2321.       3749.    
c        6058.       9787.       .1581E+05   .2554E+05   .4127E+05
c        .6668E+05   .1077E+06   .1740E+06   .2812E+06   .4543E+06
c        .7339E+06   .1186E+07   .1916E+07   .3095E+07   .5000E+07
c         log10 step=  .208333
c
c         log10 of electron energy boundary
      data eeh1l/ 1.698970/
c    *     ,eeh2l/ 6.698970/
c
           data ( tcbh(i), i= 1,  25)/
     1  14.1379, 13.7486, 13.2708, 12.7361, 12.1641, 11.5670, 10.9529,
     2  10.3333,  9.7055,  9.0761,  8.4453,  7.8159,  7.1897,  6.5691,
     3   5.9576,  5.3589,  4.7786,  4.2234,  3.6972,  3.2062,  2.7540,
     4   2.3440,  1.9772,  1.6536,  1.3727                              
     * /   
c
c          be1(iu,ie)= alog(v/vmin)
c          from u= .000 to  .700 step= .100
c          from log10(e)=  1.6990 to  6.6990 step   .2083
c          dim. of u=  8 dim of e= 25
c
           data (   be1(i), i= 1,  102)/
     1  13.12236, 11.64569, 10.44387,  9.33930,  8.26373,  7.19825,
     2   6.13320,  5.07905, 13.60207, 12.16212, 10.98560,  9.90871,
     3   8.86187,  7.82347,  6.79037,  5.76026, 14.08177, 12.68665,
     4  11.54244, 10.49859,  9.48600,  8.48108,  7.48692,  6.48090,
     5  14.56148, 13.21632, 12.10948, 11.10257, 10.12725,  9.16074,
     6   8.21033,  7.23087, 15.04118, 13.75073, 12.68249, 11.71471,
     7  10.78118,  9.85828,  8.94902,  7.99586, 15.52089, 14.28735,
     8  13.26166, 12.33377, 11.43995, 10.56558,  9.69523,  8.77043,
     9  16.00060, 14.82724, 13.84351, 12.95775, 12.10543, 11.27758,
     a  10.44662,  9.54807, 16.48030, 15.36817, 14.42688, 13.58473,
     b  12.77704, 11.99593, 11.19885, 10.32535, 16.96000, 15.91116,
     c  15.01471, 14.21154, 13.45188, 12.71287, 11.95016, 11.10144,
     d  17.43971, 16.45562, 15.60276, 14.84144, 14.13008, 13.43022,
     e  12.69587, 11.87182, 17.91942, 16.99982, 16.19264, 15.47728,
     f  14.80908, 14.14295, 13.43774, 12.63495, 18.39912, 17.54586,
     g  16.78393, 16.11504, 15.48572, 14.85151, 14.17309, 13.39042,
     h  18.87883, 18.09208, 17.37834, 16.75393, 16.16041, 15.55404      
     * /   
           data (   be1(i), i= 103,  200)/
     1  14.89917, 14.13498, 19.35853, 18.63916, 17.97516, 17.39078,
     2  16.82843, 16.24820, 15.61483, 14.86873, 19.83824, 19.18435,
     3  18.57406, 18.02551, 17.48982, 16.93379, 16.31781, 15.58789,
     4  20.31794, 19.73123, 19.17106, 18.65239, 18.14275, 17.60690,
     5  17.00831, 16.29320, 20.79765, 20.27553, 19.76264, 19.27503,
     6  18.78524, 18.26754, 17.68457, 16.98316, 21.27735, 20.81745,
     7  20.34791, 19.88812, 19.41871, 18.91607, 18.34580, 17.65608,
     8  21.75706, 21.35573, 20.92759, 20.49115, 20.03848, 19.54909,
     9  18.99128, 18.31353, 22.23676, 21.88939, 21.49714, 21.08372,
     a  20.64703, 20.16994, 19.62194, 18.95351, 22.71647, 22.41634,
     b  22.05882, 21.66483, 21.24192, 20.77458, 20.23716, 19.57556,
     c  23.19617, 22.93610, 22.60946, 22.23532, 21.82442, 21.36685,
     d  20.83619, 20.18233, 23.67588, 23.45188, 23.15211, 22.79473,
     e  22.39426, 21.94497, 21.42015, 20.77254, 24.15558, 23.96167,
     f  23.68636, 23.34386, 22.95340, 22.50922, 21.99002, 21.34670,
     g  24.63529, 24.46597, 24.21035, 23.88124, 23.49911, 23.06217,
     h  22.54702, 21.90944                                              
     * /   
c
c         be2(iu,ie)= (sqrt(v) -sqrtv)/(1.-u)
c          from sqrt(1-u)= .000 to  .548 step=  .055
c          from log10(e)= 1.698970 to 6.698970 step   .2083
c
           data (   be2(i), i= 1,  119)/
     1    .0313,   .0316,   .0319,   .0327,   .0338,   .0353,   .0373,
     2    .0399,   .0434,   .0482,   .0550,   .0366,   .0368,   .0372,
     3    .0382,   .0395,   .0411,   .0433,   .0462,   .0501,   .0552,
     4    .0624,   .0430,   .0431,   .0439,   .0450,   .0465,   .0484,
     5    .0509,   .0542,   .0584,   .0640,   .0716,   .0508,   .0510,
     6    .0520,   .0534,   .0552,   .0574,   .0603,   .0639,   .0686,
     7    .0748,   .0830,   .0601,   .0605,   .0617,   .0634,   .0656,
     8    .0682,   .0716,   .0757,   .0809,   .0876,   .0966,   .0710,
     9    .0717,   .0733,   .0755,   .0781,   .0811,   .0849,   .0896,
     a    .0954,   .1029,   .1126,   .0838,   .0848,   .0871,   .0898,
     b    .0928,   .0965,   .1008,   .1060,   .1125,   .1207,   .1312,
     c    .0987,   .1003,   .1032,   .1066,   .1102,   .1144,   .1193,
     d    .1252,   .1324,   .1414,   .1527,   .1159,   .1182,   .1222,
     e    .1262,   .1306,   .1353,   .1409,   .1474,   .1554,   .1651,
     f    .1774,   .1357,   .1392,   .1441,   .1490,   .1540,   .1595,
     g    .1657,   .1730,   .1818,   .1923,   .2054,   .1581,   .1631,
     h    .1694,   .1752,   .1809,   .1872,   .1941,   .2021,   .2116   
     * /   
           data (   be2(i), i= 120,  238)/
     1    .2230,   .2369,   .1834,   .1905,   .1982,   .2049,   .2115,
     2    .2184,   .2261,   .2348,   .2452,   .2574,   .2721,   .2132,
     3    .2213,   .2306,   .2383,   .2458,   .2535,   .2619,   .2715,
     4    .2825,   .2953,   .3107,   .2476,   .2556,   .2666,   .2754,
     5    .2838,   .2922,   .3014,   .3116,   .3231,   .3368,   .3529,
     6    .2854,   .2935,   .3059,   .3159,   .3253,   .3345,   .3442,
     7    .3551,   .3675,   .3814,   .3979,   .3263,   .3342,   .3481,
     8    .3595,   .3695,   .3794,   .3899,   .4015,   .4141,   .4286,
     9    .4454,   .3698,   .3779,   .3929,   .4051,   .4162,   .4269,
     a    .4381,   .4498,   .4631,   .4777,   .4949,   .4154,   .4228,
     b    .4397,   .4528,   .4646,   .4761,   .4876,   .5000,   .5132,
     c    .5284,   .5451,   .4622,   .4689,   .4869,   .5013,   .5137,
     d    .5256,   .5377,   .5501,   .5635,   .5788,   .5958,   .5095,
     e    .5152,   .5342,   .5493,   .5626,   .5749,   .5873,   .5997,
     f    .6135,   .6285,   .6455,   .5562,   .5609,   .5804,   .5964,
     g    .6099,   .6229,   .6354,   .6484,   .6620,   .6764,   .6931,
     h    .6018,   .6054,   .6248,   .6413,   .6556,   .6686,   .6812   
     * /   
           data (   be2(i), i= 239,  275)/
     1    .6942,   .7074,   .7221,   .7386,   .6452,   .6477,   .6665,
     2    .6838,   .6984,   .7114,   .7240,   .7371,   .7500,   .7645,
     3    .7806,   .6859,   .6871,   .7052,   .7225,   .7371,   .7504,
     4    .7631,   .7758,   .7892,   .8028,   .8183,   .7237,   .7238,
     5    .7408,   .7579,   .7728,   .7862,   .7988,   .8110,   .8241,
     6    .8380,   .8530                                                
     * /   
c
c
c         energy of gamma
c        .1000E+05   .1387E+05   .1924E+05   .2668E+05   .3700E+05
c        .5132E+05   .7117E+05   .9871E+05   .1369E+06   .1899E+06
c        .2633E+06   .3652E+06   .5065E+06   .7025E+06   .9744E+06
c        .1351E+07   .1874E+07   .2599E+07   .3605E+07   .5000E+07
c       log10 step=  .142051
c
c       log10 of gamma energy boundary
      data egh1l/ 4.000000/
c    *     ,egh1l/ 6.698970/
c
           data (  tcph(i), i= 1,  20)/
     1    .7778,   .7778,   .7778,   .7778,   .7778,   .7778,   .7778,
     2    .7778,   .7778,   .7777,   .7771,   .7756,   .7709,   .7594,
     3    .7424,   .7174,   .6853,   .6469,   .6034,   .5565            
     * /   
c
c        table of v
c        from u=  .0000 to  1.0000 step   .1000
c        from log10(e)= 4.000000 to 6.698970 step   .1421
c
           data (   vp(i), i= 1,  119)/
     1   1.0000,   .9604,   .9185,   .8735,   .8267,   .7778,   .7261,
     2    .6714,   .6157,   .5581,   .5000,  1.0000,   .9604,   .9185,
     3    .8735,   .8267,   .7778,   .7261,   .6714,   .6157,   .5581,
     4    .5000,  1.0000,   .9604,   .9185,   .8735,   .8267,   .7778,
     5    .7261,   .6714,   .6157,   .5581,   .5000,  1.0000,   .9604,
     6    .9185,   .8735,   .8267,   .7778,   .7261,   .6714,   .6157,
     7    .5581,   .5000,  1.0000,   .9604,   .9185,   .8735,   .8267,
     8    .7778,   .7261,   .6714,   .6157,   .5581,   .5000,  1.0000,
     9    .9604,   .9185,   .8735,   .8267,   .7778,   .7261,   .6714,
     a    .6157,   .5581,   .5000,  1.0000,   .9595,   .9175,   .8735,
     b    .8257,   .7769,   .7241,   .6704,   .6138,   .5562,   .5000,
     c   1.0000,   .9595,   .9175,   .8726,   .8257,   .7759,   .7251,
     d    .6724,   .6147,   .5591,   .5000,  1.0000,   .9595,   .9175,
     e    .8726,   .8257,   .7778,   .7261,   .6714,   .6157,   .5571,
     f    .5000,  1.0000,   .9604,   .9185,   .8745,   .8276,   .7778,
     g    .7271,   .6724,   .6167,   .5591,   .5000,  1.0000,   .9604,
     h    .9185,   .8745,   .8276,   .7778,   .7261,   .6714,   .6167   
     * /   
           data (   vp(i), i= 120,  220)/
     1    .5591,   .5000,  1.0000,   .9604,   .9185,   .8745,   .8276,
     2    .7778,   .7271,   .6733,   .6167,   .5591,   .5000,  1.0000,
     3    .9604,   .9194,   .8755,   .8286,   .7798,   .7280,   .6733,
     4    .6177,   .5591,   .5000,  1.0000,   .9614,   .9204,   .8765,
     5    .8315,   .7827,   .7310,   .6772,   .6196,   .5601,   .5000,
     6   1.0000,   .9624,   .9224,   .8794,   .8345,   .7866,   .7349,
     7    .6792,   .6216,   .5620,   .5000,  1.0000,   .9634,   .9253,
     8    .8833,   .8394,   .7915,   .7388,   .6841,   .6245,   .5630,
     9    .5000,  1.0000,   .9653,   .9282,   .8882,   .8442,   .7964,
     a    .7446,   .6890,   .6284,   .5649,   .5000,  1.0000,   .9673,
     b    .9321,   .8931,   .8501,   .8032,   .7515,   .6938,   .6323,
     c    .5669,   .5000,  1.0000,   .9692,   .9360,   .8989,   .8569,
     d    .8101,   .7583,   .7007,   .6372,   .5698,   .5000,  1.0000,
     e    .9712,   .9399,   .9048,   .8638,   .8169,   .7651,   .7065,
     f    .6421,   .5728,   .5000                                       
     * /   

c
c       total prob. equivalenced to common
c
      equivalence (tprob,tp)
c

c
c                         complete screening pair x-sxec.
c                         0.778 =(7/9-b)*rx0 =.773*rx0
      data rx0/1.0/, ctpc/.778/,  cep/50.e3/
c       cep:  minimum energy for landau correction for pair.
c          default esbc espc
      data esbin/5./,  espin/50./
c
c
      if(ee .lt. eblmin) then
          t=1.e36
      else
          if(.not. usees) then
             esb=esbin
          else
             esb=min(escb, eblmax)
          endif
          if(ee .gt. esb) then
              screen=.false.
              if(lcorec .and. ee .gt. eeh1) then
                  if(ee .gt. eeh2) then
                       write(6,'('' ee > eeh2 in brmH2Ot: ee='',g12.4)')
     *                 ee
                       stop
                  endif
                  landau=.true.
                  ale=log10(ee)
c                 tp=fintp3(tcbh, eeh1l, deelh, neeh, ale)*rx0
                  call kintp3(tcbh, 1, neeh, eeh1l, deelh, ale, tp)
                  tp=tp*rx0
              else
                  landau=.false.
c                     complete screening cross-section
                  vc=ec/ee
                  tp=(-1.3603*(log(vc)-vc)-vc*vc*.5-.8603 )*rx0
              endif
          else
              landau=.false.
              if(scorec) then
                  screen=.true.
                  ale=log10(ee)
c                 tp=fintp3(tcbl, etcbl1, debtcl, nbtcl,  ale)
                  call kintp3(tcbl, 1, nbtcl, etcbl1, debtcl,  ale, tp)
              else
                  screen=.false.
c                     complete screening cross-section
                  vc=ec/ee
                  tp=(-1.3603*(log(vc)-vc)-vc*vc*.5-.8603 )*rx0
              endif
          endif
c
          call rndc(u)
          t =-log(u)/tp
      endif
      return
c
c     ************
      entry brmH2Oe(ee,ec,beg)
c     ************
c
      call rndc(u)
      if(screen) then
c           partial screening
         if(u .gt. uela1) then
c                  region a
c              beg=exp( tdint4(bla, nuela, neela, uela1, eela1l, duela,
c    *         deela, u,  ale)*(1.-u) ) *egmnl
               call k4ptdi(bla, nuela, neela, nuela, uela1, eela1l,
     *         duela, deela, u, ale, ans)
               beg=exp( ans*(1.-u))*egmnl
         else
c                  region b
               us=sqrt(u)
c              beg=exp( tdint4(blb, nuelb, neelb, uelb1, eelb1l,duelb,
c    *         deelb, us, ale)) * egmnl
               call k4ptdi(blb, nuelb, neelb, nuelb, uelb1, eelb1l,
     *         duelb, deelb, us, ale, ans)
               beg=exp(ans)*egmnl
         endif
      elseif(landau) then
         if(u .lt. ueh2) then
c              beg=exp( tdint4(be1, nueh1, neeh, ueh1, eeh1l, dueh1,
c    *         deelh, u,  ale)  ) * egmnh
               call k4ptdi(be1, nueh1, neeh, nueh1,  ueh1, eeh1l,
     *         dueh1, deelh, u,  ale, ans)
               beg=exp( ans ) *egmnh
         else
               us=sqrt(1.-u)
c              beg=   ( tdint4(be2, nueh2, neeh, ueh3, eeh1l, dueh2,
c    *         deelh, us,  ale)*(1.-u)+ sqrt(egmnh/ee) )**2 *ee
               call k4ptdi(be2, nueh2, neeh, nueh2,  ueh3, eeh1l,
     *         dueh2, deelh, us,  ale, ans)
               beg=  (ans*(1.-u) + sqrt(egmnh/ee) )**2*ee
         endif
      else
c               complete screening
          a=u*tp
          if(a .le. 1.) then
             v=exp(-a)
             if(a .gt. .1) then
                 v=((.06366*a-.1447407)*a+1.014176)*v
             endif
          else
             v=exp(-(a+0.8603)/1.3603)
             if(a .le. 6.) then
                 v=((((2.050445e-3*a-3.53209e-2)*a+.228937)*a-.684076)*a
     *           +1.841734)*v
             endif
          endif
          beg=ee*v
      endif
      return
c
c
c     ***********
      entry prcH2Ot(eg,t)
c     ***********
c
c
c
      if(eg .le. emass2) then
          t=1.e37
      elseif(eg .lt. eplmin .and. scorec) then
          tp=( (eg-emass2)/(eplmin-emass2) )**3 * tcpl(1)
          call rndc(u)
          t =-log(u)/tp
          landau=.false.
          screen=.true.
      else
          if(.not. usees) then
             esp=espin
          else
             esp=min(escp, eplmax)
          endif
          if(eg .gt. esp) then
              screen=.false.
              if(eg .gt. cep   .and. lcorec) then
                  landau=.true.
                  ale=log10(eg)
c                 tp=fintp3(tcph, egh1l, deghl, negh, ale)*rx0
                  call kintp3(tcph, 1, negh,  egh1l,  deghl,   ale, tp)
                  tp=tp*rx0
              else
                  landau=.false.
c                     complete screening cross-section
                  tp=ctpc
              endif
          else
              landau=.false.
              if(scorec) then
                  screen=.true.
                  ale=log10(eg)
c                 tp=fintp3(tcpl, etcpl1, deptcl, nptcl, ale)
                  call kintp3(tcpl, 1,nptcl,  etcpl1, deptcl,  ale, tp)
              else
                  screen=.false.
c                     complete screening cross-section
                  tp=ctpc
              endif
          endif
          call rndc(u)
          t =-log(u)/tp
      endif
      return
c
c
c     ***********
      entry prcH2Oe(eg,e1)
c     ***********
c
c
c
      call rndc(u)
      if(screen) then
c           partial screening
         if(u .ge. ugla1) then
c                   region a
c               e1=(tdint4(pla, nugla, negla, ugla1, egla1l, dugla,
c    *          degla, u,    ale) *(1.-u) + .5 )*eg
                call k4ptdi(pla, nugla, negla,nugla,  ugla1, egla1l,
     *          dugla, degla, u,   ale, ans)
                e1=(ans*(1.-u) + .5)*eg
         else
c                   region b
                us=sqrt(u)
                ex=sqrt(ale-eglb1l)

                call k4ptdi(plb, nuglb, neglb,nuglb,  uglb1, 0.d0,
     *          duglb, deglb, us,  ale, ans)
                e1=ans*eg
         endif
      elseif(landau) then
c        e1= tdint4(vp, nugh2, negh, ugh3, egh1l, dugh2,
c    *   deghl, u,  ale) * eg
         call k4ptdi(vp, nugh2, negh, nugh2, ugh3, egh1l,
     *   dugh2, deghl, u,  ale, ans)
         e1=ans*eg
      else
c                complete screening
         e1=(((.0441223*u-.173755)*u-.3708608)*u+1.)*eg
      endif
      return
c
c     ************
      entry emctH2O(Knckon)
c     ************
c
c               cconst=for compton=3/8*thomson*n0*z/a*x0ing
c               to convert cross-section in compt into /(r.l).
      cconst=2.735
      x0= 36.1
      x0ing=36.1
      x0sq=1.303e3
      if(Knckon) then
         ecrit=72.e-3
      else
         ecrit=72.e-3
      endif 
c         moller scat    .3 z/a * x0ing
      constm=5.47
      rho = 1.0
c
      zchrg= 7.22
      zchrg2 = 57.0
      amassn= 14.3
      ionizP = 73.79d-9
      end
