      implicit none
#include "Zmedia.h"
#include "Zptcl.h"
#include "Zmass.h"
#include "Zcode.h"
c
c          test  dE/dx with fluctuation by M.C
c 
      record /epmedia/media
      record /ptcl/ aPtcl

      integer io, subcode, charge, code,  i
      real*8 E,  dedx, w, kepn, s1, s2
      real*8 thick, cutl 
      real*8 t, step, de, sigma, temp
      character*80 file

      io = 10
      call  cerrorMsg('To compare dE/dx with data,'
     * // 'you must give large W(say,100000)', 1)
  
      call  cerrorMsg(
     * 'Enter ptcl code(2), subcode, charge(-1), '
     *  //' w(200d-6), base file path(../../../Data/MediaPb)',1)
      
      w = 200d-6
      file = '../../../Data/Media/Pb'
      read(*, *) code,  subcode, charge, w, file
      call cerrorMsg(file,  1)
      call cerrorMsg(
     *  'Enter kinetic energy/n, thickness and cut length in g/cm^2',
     *  1)
      read(*, *)  kepn, thick, cutl
      open(io, file=file)
      call epReadMTbl(io, media)
      close(io)
      call epGetEffZA(media)
      call epExpot(media)
      call epStern(w, media, media.sh)
      call cmkptc(code, subcode, charge, aPtcl)


      do i = 1, 50000
         t =min( cutl, thick)
         step = t
         de = 0.
         if(aPtcl.code .eq. kgnuc) then
            E = kepn*aPtcl.subcode
         else
            E = kepn
         endif
         aPtcl.fm.p(4) = E +  aPtcl.mass

         do while( .true. )    ! do until
            if(aPtcl.code .eq. kelec) then
               call epdedxe(media.sh, aPtcl, dedx)
            elseif(aPtcl.code .eq. kgnuc) then
               call epdedxhvy(media.sh, aPtcl, dedx)
            else
               call epdedxNone(media.sh, aPtcl, dedx)
            endif

            call epdedxflhv(media, aPtcl, s1, s2)

            sigma = sqrt( (s1 + s2)* step)

            call kgauss(0.d0, sigma, s1, s2)
            temp = dedx*step + s1

            aPtcl.fm.p(4) = aPtcl.fm.p(4) - temp

            if( aPtcl.fm.p(4) .le. 0.) goto 10
            de = de + temp
            if( t .eq. thick ) goto 5
            temp = min(thick, t+cutl)
            step = temp - t
            t = temp
         enddo
 5       continue
         write(*,*) sngl(de)
 10      continue
      enddo
      end
