      implicit none
#include "ZepMaxdef.h"
#include "ZepTrackv.h"
#include "Zmedia.h"
#include "ZepTrackp.h"
#include "Zelmagp.h"
#include "Zmass.h"
#include "Zcode.h"


      record /epmedia/ media

      integer i, io, kkk, nev, imax
      real*8 Ee, theta, b, xc2, ra2, theta2, mf, dt, epmolieref2
      character*20 file
      logical sampling, Molsave

      dt = 0.0001
      io = 10
      call cerrorMsg(
     *  'Do sampling(T) or Draw Moliere function(F); (=T)?', 1)
      sampling = .true.
      read(*,*) sampling

      if(sampling) then
         call cerrorMsg(
     *    'Enter ptcl(2) Moliere(T) Es(19.3d-3) N(50000)',
     *    1)
         nev= 50000
      else
         call cerrorMsg('Enter ptcl(2)  Moliere(T) Es(19.3d-3)', 1)
      endif
      Moliere = .true.
      Escat = 19.3d-3
      kkk = kelec 

      read(*,*)  kkk,  Moliere, Escat, nev
           

      call  cerrorMsg(
     * 'Enter Energy, path length(0.1 r.l) and file path(BGO)',1)
      file = 'BGO'


      Move.dt = 0.1
      read(*, *) Ee, Move.dt, file


      call cerrorMsg(file,  1)

      open(io, file=file) 
      call epReadMTbl(io, media)
      call epGetEffZA(media)
      Move.dl = Move.dt* media.X0
      Move.dx = Move.dt* media.X0g
      call cmkptc(kkk, antip, 1, cTrack.p)
      cTrack.p.fm.p(4) = Ee
      Move.Track.p = cTrack.p
      Move.Track.p.fm.p(4) =
     *   max(Ee - Move.dx * 1.8d-3, cTrack.p.mass)

      if(sampling) then
         write(*, *) "#   'Moliere or Gaussian scattering test' "
         write(*, *) "#   ' reducedtheta^2' 'theta^2  "
         Molsave = Moliere
         Moliere = .true.
         call epmulScat(media, theta)
         call epqmoliere(b, xc2)
         Moliere = Molsave
         do i = 1,  nev
            call epmulScat(media, theta)
            write(*,*) sngl(theta**2/b/xc2), sngl(theta**2),
         enddo
      else
         if(Moliere) then
            call epmulScat(media, theta)
c             inquire b,xc2
            call epqmoliere(b, xc2)
            theta2  = 0.
            imax = (3.1415/2)**2/dt
            do i = 1, imax
               ra2 = theta2/b/xc2
               mf = exp(-ra2) + epmolieref2(ra2)/b
               theta2 = theta2 + dt
               write(*,*) sngl(ra2), sngl(mf), sngl(theta2)
            enddo
         endif
      endif
      end
      real*8 function epmolieref2(x)
c        2nd term of Moliere expansion of multiple scattering
c        (f0 + f1/B)x dx.  This is f1 with reduced angle square(=x)
c         f1(x) d(x)
      implicit none
      real*8 x
      real*8 keiexp


      epmolieref2 = ( keiexp(x) * (x -1) - (1.-2.* exp(-x)))
      end


