c     ************************ for w*********************************
c     *                                                              *
c     *  brmwt:   samples path for brems                             *
c     *  brmwe:   samples energy of brems gamma                      *
c     *  prcwt:   samples path for pair creation                     *
c     *  prcwe:   samples energy of pair electron (higher energy)    *
c     *  emctw:   set const in common for w                          *
c     *                                                              *
c     *********************** tested 84.05.04 ********************k.k*
c
c      material   z     a     rho     t0 (g/cm2)  t0 (cm)    ec
c          w      74   183.92  19.3    6.275      .325       6.3
c                                    (n) 6.8
c brems:
c        electron energy:      1mev to 10tev
c        brems gamma energy:   .1mev or more
c           if electron energy is < 1mev,  sampled path is set to be
c        very large one so that real brems may not take place before
c        the death by energy loss.
c pair:
c        gamma energy:         3mev to 10tev
c           if gamma energy is < 3mev, sampled path is set to be
c        very large one so that real pair creation may not take place
c        before compton or another process takes place.
c
c
c
c
c   /usage/          call brmwt(ee,ec,t)
c                    call brmwe(ee,ec,beg)
c
c                    call prcwt(eg,t)
c                    call prcwe(eg,e1)
c
c      ee:  incident electron energy
c      ec:  cut-off energy of brems gamma (used if complete screening
c           cross section is to be used).
c       t:  sampled path
c     beg:  sampled gamma energy
c      eg:  incident gamma energy
c      e1:  sampled electron energy (higher energy in pair)
c
c  *** note ***
c
c          before calling brmwe, brmwt must have been called.
c          //             prcwe, prcwt //
c
c          by the parameters in $elmag the user can control:
c
c        ee  -------------- 5gev------->  (if usees=t, escb instead 5)
c     scorec=t       p.s    !
c     lcorec=t              !    l.c
c     scorec=f       c.s    !
c     lcorec=f              !    c.s
c
c        eg  ------------- 50gev--1tev---> (if usees=t, escp instead 50)
c     scorec=t       p.s    ! c.s !
c     lcorec=t              ! c.s ! l.c
c     scorec=f       c.s    ! c.s !
c     lcorec=f              !     ! c.s
c
c
c
c
      subroutine brmwt(ee,ec,t)
       implicit none
c
c
#include  "Zelmag.h"
#include  "Zemdef.h"
c
c
      integer i
      logical screen,landau
      save screen,landau
c
c
c
c ------------------------- partical screening ----------------------
c           *** electron ***
c
c           ! egmin (gev)  for brems.
      data egmnl/.1e-3/
c
      parameter (eblmin=1.e-3, eblmax=10.,  nbtcl=13)
      dimension tcbl(nbtcl)
c
c             brem:   region a
c
      parameter (eela1=eblmin, eela2=eblmax,neela=13,
     * uela1=.05, uela2=1., nuela=16, duela=(uela2-uela1)/(nuela-1) )
      dimension bla(nuela* neela)
c
c             brem:  region b  (sqrt(u))
      parameter (eelb1=eblmin, eelb2=eblmax, neelb=neela,
     * uelb1=0.,  uelb2=.2236068, nuelb=16,
     * duelb=(uelb2-uelb1)/(nuelb-1) )
      dimension blb(nuelb* neelb)
c           ** gamma ***
c
c                 total cross-section
      parameter (eplmin=3.e-3, eplmax=300., nptcl=16)
      dimension tcpl(nptcl)
c
c          pair: region a
      parameter ( egla1=eplmin,  egla2=eplmax, negla=16,
     *   ugla1=.05, ugla2=1., nugla=16,dugla=(ugla2-ugla1)/(nugla-1) )
      dimension pla(nugla* negla)
c
c            pair: region b     sqrt(log10(e)) sqrt(u)
      parameter (eglb1=eplmin, eglb2=eplmax, neglb=11,
     *  uglb1=0., uglb2=.2236068, nuglb=16,
     *  duglb=(uglb2-uglb1)/(nuglb-1))
      dimension plb(nuglb* neglb)
c
c      -------------------- landau ------------------------------
c          **** electron ****
c
      data egmnh/1.e-3/
      parameter ( eeh1=5., eeh2=300.e3, neeh=16,dueh1=.1,
     *  ueh1=0., ueh2=.7, nueh1=(ueh2-ueh1+.00001)/dueh1+1)
      dimension  tcbh(neeh)
      dimension  be1(nueh1* neeh)
c
c                         sqrt(1-.7)
      parameter (ueh3=0., ueh4=0.5477225,
     *nueh2=11, dvueh2=nueh2-1, dueh2=(ueh4 - ueh3)/dvueh2)
      dimension be2(nueh2*neeh)
c
c
c         *** gamma ****
c
      parameter ( egh1=5000., egh2=300.e3,negh=7, dugh2=.1,
     * ugh3=0., ugh4=1., nugh2=(ugh4-ugh3+.00001)/dugh2+1)
      dimension tcph(negh)
      dimension vp(nugh2* negh)
c
c     ---------------------------------------------------------
c
      data debtcl/ 0.333333/
      data deela/ 0.333333/
      data deelb/ 0.333333/
      data deptcl/ 0.333333/
      data degla/ 0.333333/
      data deglb/ 0.223607/
c        electron energy=
c      0.10000e-02 0.21544e-02 0.46416e-02 0.10000e-01 0.21544e-01
c      0.46416e-01 0.10000     0.21544     0.46416      1.0000
c       2.1544      4.6416      10.000
c       log10 step=  0.3333
c
c      log10 of electron energy boundary
      data  etcbl1/-3.000000/
c    *     ,etcbl2/ 1.000000/
c
      data (tcbl  (i),i=   1,  13)/
     1 1.6552, 2.9400, 3.9806, 4.9511, 5.9224, 6.9030, 7.8877, 8.8707,
     2 9.8500,10.8263,11.7998,12.7713,13.7418/
c
c       brem: region a
c        electron energy=
c      0.10000e-02 0.21544e-02 0.46416e-02 0.10000e-01 0.21544e-01
c      0.46416e-01 0.10000     0.21544     0.46416      1.0000
c       2.1544      4.6416      10.000
c       log10 step=  0.3333
c
c      log10 of electron energy boundary
      data  eela1l/-3.000000/
c    *     ,eela2l/ 1.000000/
c
c
c            bla(iu,ie)=log(v/vmin)/(1.-u)
c            u=0.050 to 1.000 step= 0.0633
c            log10(e)= -3.0000 to   1.0000 step= 0.3333
c
      data (bla   (i),i=   1,  72)/
     1 1.4618, 1.3688, 1.3037, 1.2530, 1.2117, 1.1767, 1.1463, 1.1194,
     2 1.0953, 1.0733, 1.0531, 1.0361, 1.0185, 1.0105, 0.9958, 0.9795,
     3 2.4535, 2.2912, 2.1861, 2.1089, 2.0492, 2.0015, 1.9601, 1.9266,
     4 1.8969, 1.8737, 1.8521, 1.8317, 1.8139, 1.7970, 1.7832, 1.7688,
     5 3.3372, 3.1607, 3.0499, 2.9742, 2.9140, 2.8672, 2.8274, 2.7959,
     6 2.7680, 2.7444, 2.7236, 2.7058, 2.6898, 2.6768, 2.6640, 2.6540,
     7 4.2029, 4.0328, 3.9244, 3.8476, 3.7905, 3.7455, 3.7101, 3.6820,
     8 3.6591, 3.6401, 3.6248, 3.6118, 3.6010, 3.5919, 3.5839, 3.5772,
     9 5.0509, 4.8852, 4.7778, 4.7032, 4.6500, 4.6103, 4.5802, 4.5570/
      data (bla   (i),i=  73, 144)/
     1 4.5388, 4.5244, 4.5130, 4.5037, 4.4969, 4.4909, 4.4846, 4.4815,
     2 5.8774, 5.7109, 5.6047, 5.5332, 5.4835, 5.4480, 5.4222, 5.4029,
     3 5.3886, 5.3775, 5.3689, 5.3626, 5.3575, 5.3537, 5.3494, 5.3482,
     4 6.6820, 6.5125, 6.4059, 6.3369, 6.2907, 6.2589, 6.2367, 6.2208,
     5 6.2094, 6.2009, 6.1949, 6.1903, 6.1868, 6.1845, 6.1816, 6.1812,
     6 7.4691, 7.2932, 7.1864, 7.1202, 7.0776, 7.0496, 7.0306, 7.0176,
     7 7.0089, 7.0026, 6.9981, 6.9952, 6.9931, 6.9915, 6.9892, 6.9893,
     8 8.2426, 8.0595, 7.9532, 7.8902, 7.8514, 7.8269, 7.8110, 7.8007,
     9 7.7938, 7.7893, 7.7862, 7.7839, 7.7827, 7.7815, 7.7814, 7.7805/
      data (bla   (i),i= 145, 208)/
     1 9.0064, 8.8166, 8.7124, 8.6532, 8.6184, 8.5972, 8.5841, 8.5759,
     2 8.5707, 8.5676, 8.5654, 8.5640, 8.5632, 8.5626, 8.5626, 8.5617,
     3 9.7642, 9.5693, 9.4679, 9.4128, 9.3817, 9.3637, 9.3530, 9.3465,
     4 9.3428, 9.3406, 9.3390, 9.3381, 9.3375, 9.3376, 9.3359, 9.3367,
     510.5184,10.3198,10.2220,10.1712,10.1438,10.1286,10.1199,10.1150,
     610.1120,10.1105,10.1094,10.1090,10.1087,10.1088,10.1069,10.1080,
     711.2708,11.0702,10.9765,10.9299,10.9058,10.8931,10.8861,10.8824,
     810.8800,10.8788,10.8783,10.8781,10.8774,10.8769,10.8786,10.8774/
c
c       brem: region b
c        electron energy=
c      0.10000e-02 0.21544e-02 0.46416e-02 0.10000e-01 0.21544e-01
c      0.46416e-01 0.10000     0.21544     0.46416      1.0000
c       2.1544      4.6416      10.000
c       log10 step=  0.3333
c
c      log10 of electron energy boundary
      data  eelb1l/-3.000000/
c    *     ,eelb2l/ 1.000000/
c
c
c            blb(iu,ie)=log(v/vmin)/(1.-u)
c            sqrt(u)=0.0   to 0.224 step= 0.0149
c            log10(e)= -3.0000 to   1.0000 step= 0.3333
c
      data (blb   (i),i=   1,  72)/
     1 1.5872, 1.5861, 1.5826, 1.5769, 1.5691, 1.5593, 1.5478, 1.5347,
     2 1.5201, 1.5042, 1.4872, 1.4691, 1.4501, 1.4303, 1.4098, 1.3887,
     3 2.7994, 2.7901, 2.7688, 2.7425, 2.7137, 2.6831, 2.6514, 2.6186,
     4 2.5851, 2.5506, 2.5154, 2.4796, 2.4433, 2.4063, 2.3687, 2.3308,
     5 3.7210, 3.6974, 3.6698, 3.6402, 3.6089, 3.5760, 3.5414, 3.5052,
     6 3.4676, 3.4286, 3.3884, 3.3469, 3.3043, 3.2607, 3.2159, 3.1703,
     7 4.5527, 4.5288, 4.5047, 4.4781, 4.4490, 4.4178, 4.3840, 4.3482,
     8 4.3103, 4.2703, 4.2282, 4.1844, 4.1386, 4.0913, 4.0427, 3.9928,
     9 5.3487, 5.3296, 5.3093, 5.2860, 5.2599, 5.2310, 5.1992, 5.1646/
      data (blb   (i),i=  73, 144)/
     1 5.1272, 5.0875, 5.0453, 5.0005, 4.9531, 4.9038, 4.8521, 4.7984,
     2 6.1292, 6.1145, 6.0976, 6.0771, 6.0535, 6.0266, 5.9966, 5.9637,
     3 5.9271, 5.8875, 5.8448, 5.7991, 5.7498, 5.6971, 5.6420, 5.5836,
     4 6.9026, 6.8914, 6.8769, 6.8587, 6.8371, 6.8119, 6.7830, 6.7506,
     5 6.7142, 6.6740, 6.6293, 6.5807, 6.5280, 6.4717, 6.4115, 6.3479,
     6 7.6729, 7.6642, 7.6515, 7.6349, 7.6146, 7.5902, 7.5616, 7.5283,
     7 7.4906, 7.4481, 7.4007, 7.3486, 7.2918, 7.2305, 7.1652, 7.0957,
     8 8.4417, 8.4347, 8.4233, 8.4078, 8.3879, 8.3633, 8.3336, 8.2988,
     9 8.2587, 8.2133, 8.1623, 8.1059, 8.0443, 7.9777, 7.9063, 7.8305/
      data (blb   (i),i= 145, 208)/
     1 9.2098, 9.2039, 9.1935, 9.1783, 9.1579, 9.1323, 9.1011, 9.0639,
     2 9.0209, 8.9718, 8.9168, 8.8555, 8.7885, 8.7160, 8.6384, 8.5561,
     3 9.9776, 9.9726, 9.9625, 9.9470, 9.9259, 9.8986, 9.8653, 9.8255,
     4 9.7789, 9.7259, 9.6661, 9.5997, 9.5272, 9.4487, 9.3649, 9.2760,
     510.7453,10.7408,10.7307,10.7145,10.6921,10.6631,10.6272,10.5844,
     610.5343,10.4769,10.4123,10.3407,10.2623,10.1778,10.0877, 9.9925,
     711.5129,11.5087,11.4983,11.4812,11.4574,11.4263,11.3879,11.3418,
     811.2879,11.2260,11.1565,11.0793,10.9953,10.9048,10.8086,10.7073/
c
c       pair: total x-section
c        gamm energy=
c      0.30000e-02 0.64633e-02 0.13925e-01 0.30000e-01 0.64633e-01
c      0.13925     0.30000     0.64633      1.3925      3.0000
c       6.4633      13.925      30.000      64.633      139.25
c       300.00
c       log10 step=  0.3333
c
c      log10 of gamma energy boundary
      data  etcpl1/-2.522879/
c    *     ,etcpl2/ 2.477121/
c
      data (tcpl  (i),i=   1,  16)/
     1 0.0164, 0.1236, 0.2475, 0.3732, 0.4873, 0.5747, 0.6325, 0.6681,
     2 0.6891, 0.7010, 0.7075, 0.7110, 0.7129, 0.7138, 0.7143, 0.7146/
c
c       pair: region a
c
c         energy of gamma=
c        0.300e-02   0.646e-02   0.139e-01   0.300e-01   0.646e-01
c        0.139       0.300       0.646        1.39        3.00
c         6.46        13.9        30.0        64.6        139.
c         300.
c         log10 step= 0.333333
c
c         log10 of eg boundary
      data  egla1l/-2.522879/
c    *     ,egla2l/ 2.477121/
c
c
c         pla(iu,ie)=(v-.5)/(1.-u)
c         u=0.050 to1.000   step= 0.0633
c            log10(e)= -2.5229 to   2.4771 step= 0.3333
c
      data (pla   (i),i=   1,  72)/
     1 0.1475, 0.1454, 0.1436, 0.1422, 0.1409, 0.1399, 0.1390, 0.1381,
     2 0.1375, 0.1369, 0.1364, 0.1361, 0.1358, 0.1357, 0.1353, 0.1355,
     3 0.3598, 0.3470, 0.3393, 0.3339, 0.3301, 0.3270, 0.3246, 0.3228,
     4 0.3212, 0.3201, 0.3192, 0.3182, 0.3178, 0.3176, 0.3172, 0.3172,
     5 0.4224, 0.4115, 0.4055, 0.4018, 0.3993, 0.3975, 0.3964, 0.3957,
     6 0.3951, 0.3948, 0.3945, 0.3945, 0.3944, 0.3945, 0.3942, 0.3945,
     7 0.4531, 0.4453, 0.4417, 0.4398, 0.4390, 0.4387, 0.4387, 0.4388,
     8 0.4395, 0.4405, 0.4407, 0.4419, 0.4420, 0.4410, 0.4454, 0.4432,
     9 0.4708, 0.4662, 0.4650, 0.4653, 0.4664, 0.4679, 0.4699, 0.4717/
      data (pla   (i),i=  73, 144)/
     1 0.4736, 0.4750, 0.4778, 0.4792, 0.4804, 0.4816, 0.4823, 0.4813,
     2 0.4822, 0.4811, 0.4827, 0.4853, 0.4887, 0.4922, 0.4956, 0.4995,
     3 0.5028, 0.5059, 0.5087, 0.5111, 0.5129, 0.5154, 0.5161, 0.5161,
     4 0.4903, 0.4924, 0.4961, 0.5006, 0.5054, 0.5103, 0.5153, 0.5200,
     5 0.5245, 0.5287, 0.5323, 0.5352, 0.5377, 0.5400, 0.5412, 0.5418,
     6 0.4959, 0.5001, 0.5054, 0.5112, 0.5169, 0.5228, 0.5287, 0.5341,
     7 0.5395, 0.5441, 0.5486, 0.5521, 0.5550, 0.5573, 0.5585, 0.5594,
     8 0.4997, 0.5052, 0.5114, 0.5179, 0.5243, 0.5307, 0.5370, 0.5433,
     9 0.5490, 0.5542, 0.5591, 0.5631, 0.5664, 0.5689, 0.5706, 0.5707/
      data (pla   (i),i= 145, 216)/
     1 0.5022, 0.5085, 0.5153, 0.5221, 0.5289, 0.5357, 0.5424, 0.5488,
     2 0.5548, 0.5602, 0.5651, 0.5696, 0.5731, 0.5754, 0.5775, 0.5776,
     3 0.5037, 0.5105, 0.5174, 0.5246, 0.5316, 0.5385, 0.5455, 0.5520,
     4 0.5582, 0.5638, 0.5687, 0.5731, 0.5767, 0.5793, 0.5815, 0.5816,
     5 0.5045, 0.5116, 0.5188, 0.5261, 0.5332, 0.5403, 0.5472, 0.5537,
     6 0.5602, 0.5658, 0.5711, 0.5755, 0.5790, 0.5818, 0.5835, 0.5838,
     7 0.5050, 0.5122, 0.5196, 0.5267, 0.5340, 0.5411, 0.5481, 0.5547,
     8 0.5610, 0.5668, 0.5722, 0.5765, 0.5800, 0.5828, 0.5845, 0.5850,
     9 0.5054, 0.5126, 0.5199, 0.5272, 0.5345, 0.5417, 0.5486, 0.5552/
      data (pla   (i),i= 217, 256)/
     1 0.5616, 0.5675, 0.5726, 0.5770, 0.5806, 0.5833, 0.5854, 0.5857,
     2 0.5056, 0.5128, 0.5202, 0.5274, 0.5347, 0.5419, 0.5490, 0.5557,
     3 0.5618, 0.5678, 0.5730, 0.5775, 0.5811, 0.5838, 0.5854, 0.5860,
     4 0.5056, 0.5129, 0.5202, 0.5275, 0.5349, 0.5421, 0.5490, 0.5557,
     5 0.5621, 0.5678, 0.5730, 0.5775, 0.5811, 0.5838, 0.5854, 0.5862/
c
c
c       pair: region b
c
c         energy of gamma=
c        0.300e-02   0.337e-02   0.475e-02   0.846e-02   0.189e-01
c        0.533e-01   0.189       0.846        4.75        33.7
c         300.
c         sqrt(log10) step= 0.223607
c
c         use 0 for e-side at interpolation
c         with sqrt(log10(e)-eglb1l)
      data  eglb1l/-2.522879/
c
c
c         plb(iu,ie)=v
c         sqrt(u)=0.0   to0.224   step= 0.0149
      data (plb   (i),i=   1,  72)/
     1 0.8297, 0.6493, 0.6492, 0.6490, 0.6487, 0.6483, 0.6479, 0.6473,
     2 0.6467, 0.6460, 0.6452, 0.6443, 0.6434, 0.6423, 0.6412, 0.6401,
     3 0.8482, 0.7160, 0.7158, 0.7154, 0.7149, 0.7142, 0.7133, 0.7124,
     4 0.7113, 0.7100, 0.7087, 0.7072, 0.7056, 0.7038, 0.7019, 0.7000,
     5 0.8925, 0.8302, 0.8296, 0.8287, 0.8272, 0.8256, 0.8236, 0.8213,
     6 0.8188, 0.8161, 0.8132, 0.8102, 0.8070, 0.8037, 0.8003, 0.7967,
     7 0.9396, 0.9162, 0.9147, 0.9126, 0.9099, 0.9069, 0.9037, 0.9002,
     8 0.8967, 0.8929, 0.8891, 0.8851, 0.8810, 0.8769, 0.8727, 0.8684,
     9 0.9730, 0.9646, 0.9623, 0.9595, 0.9565, 0.9534, 0.9501, 0.9466/
      data (plb   (i),i=  73, 144)/
     1 0.9430, 0.9395, 0.9356, 0.9317, 0.9278, 0.9236, 0.9195, 0.9152,
     2 0.9904, 0.9870, 0.9849, 0.9825, 0.9799, 0.9773, 0.9746, 0.9717,
     3 0.9686, 0.9655, 0.9621, 0.9588, 0.9552, 0.9514, 0.9477, 0.9438,
     4 0.9973, 0.9957, 0.9942, 0.9926, 0.9908, 0.9889, 0.9868, 0.9845,
     5 0.9822, 0.9796, 0.9770, 0.9742, 0.9711, 0.9681, 0.9648, 0.9614,
     6 0.9994, 0.9986, 0.9977, 0.9967, 0.9956, 0.9942, 0.9926, 0.9910,
     7 0.9892, 0.9873, 0.9852, 0.9830, 0.9807, 0.9781, 0.9754, 0.9725,
     8 0.9999, 0.9995, 0.9990, 0.9984, 0.9975, 0.9965, 0.9954, 0.9942,
     9 0.9928, 0.9912, 0.9893, 0.9874, 0.9853, 0.9830, 0.9805, 0.9780/
      data (plb   (i),i= 145, 176)/
     1 1.0000, 0.9998, 0.9994, 0.9989, 0.9983, 0.9975, 0.9965, 0.9954,
     2 0.9941, 0.9926, 0.9909, 0.9891, 0.9870, 0.9848, 0.9825, 0.9799,
     3 1.0000, 0.9999, 0.9996, 0.9992, 0.9986, 0.9977, 0.9969, 0.9957,
     4 0.9944, 0.9930, 0.9913, 0.9894, 0.9875, 0.9853, 0.9828, 0.9803/
c
c                 -----------$$ landau region $$----------
c
      data deelh/ 0.400000/
      data deghl/ 0.200000/
c
c          energy of electron
c        1.000       2.512       6.310       15.85       39.81
c        100.0       251.2       631.0       1585.       3981.
c       0.1000e+05
c         log10 step= 0.400000
c
c         log10 of electron energy boundary
      data eeh1l/ 0.0     /
c    *     ,eeh2l/ 4.000000/
c
      data (tcbh  (i),i=   1,  11)/
     1  8.3939,  9.5032,  9.9003,  9.5316,  8.7000,  7.6518,  6.5198,
     2  5.3792,  4.2893,  3.3006,  2.4518/
c
c          be1(iu,ie)= log(v/vmin)
c          from u=0.0   to 0.700 step=0.100
c          from log10(e)=  0.0    to  4.0000 step  0.4000
c          dim. of u=  8 dim of e= 11
c
      data (   be1(i),i=   1,  54)/
     1  6.90775,  5.99390,  5.19126,  4.47939,  3.80892,  3.15837,
     2  2.51784,  1.88250,  7.82879,  6.80078,  5.91807,  5.13122,
     3  4.38435,  3.65538,  2.93087,  2.22063,  8.74982,  7.68165,
     4  6.77082,  5.95709,  5.18221,  4.42193,  3.68682,  2.94555,
     5  9.67086,  8.63996,  7.75523,  6.96617,  6.21584,  5.49754,
     6  4.77851,  4.01446, 10.59189,  9.64624,  8.82125,  8.08487,
     7  7.40497,  6.73986,  6.04966,  5.28363, 11.51293, 10.67707,
     8  9.92753,  9.27418,  8.66244,  8.04809,  7.39149,  6.63929,
     9 12.43396, 11.71891, 11.06369, 10.48764,  9.93422,  9.36463/
      data (   be1(i),i=  55,  88)/
     1  8.74134,  8.01036, 13.35499, 12.76497, 12.20858, 11.69603,
     2 11.18968, 10.65761, 10.06427,  9.35595, 14.27603, 13.81064,
     3 13.34069, 12.88083, 12.41243, 11.91040, 11.34224, 10.65475,
     4 15.19706, 14.84120, 14.44625, 14.03100, 13.59254, 13.11431,
     5 12.56624, 11.89637, 16.11810, 15.84977, 15.51697, 15.13927,
     6 14.72583, 14.26624, 13.73388, 13.07798/
c
c         be2(iu,ie)= (sqrt(v) -sqrtv)/(1.-u)
c          from sqrt(1-u)=0.0   to 0.548 step= 0.055
c          from log10(e)= 0.0      to 4.000000 step  0.4000
c
      data (   be2(i),i=   1,  63)/
     1  0.0977,  0.0981,  0.0994,  0.1018,  0.1051,  0.1098,  0.1159,
     2  0.1242,  0.1349,  0.1483,  0.1648,  0.0852,  0.0855,  0.0865,
     3  0.0882,  0.0907,  0.0940,  0.0985,  0.1043,  0.1120,  0.1220,
     4  0.1354,  0.0957,  0.0960,  0.0970,  0.0986,  0.1009,  0.1041,
     5  0.1083,  0.1136,  0.1205,  0.1294,  0.1411,  0.1213,  0.1216,
     6  0.1228,  0.1248,  0.1275,  0.1312,  0.1359,  0.1418,  0.1492,
     7  0.1586,  0.1706,  0.1592,  0.1598,  0.1616,  0.1643,  0.1680,
     8  0.1727,  0.1785,  0.1855,  0.1941,  0.2047,  0.2178,  0.2091,
     9  0.2102,  0.2131,  0.2173,  0.2224,  0.2286,  0.2358,  0.2443/
      data (   be2(i),i=  64, 121)/
     1  0.2543,  0.2663,  0.2809,  0.2703,  0.2724,  0.2775,  0.2838,
     2  0.2909,  0.2988,  0.3076,  0.3176,  0.3291,  0.3425,  0.3584,
     3  0.3409,  0.3451,  0.3535,  0.3626,  0.3718,  0.3815,  0.3919,
     4  0.4032,  0.4159,  0.4304,  0.4471,  0.4277,  0.4286,  0.4387,
     5  0.4503,  0.4616,  0.4728,  0.4845,  0.4968,  0.5103,  0.5254,
     6  0.5425,  0.5214,  0.5216,  0.5291,  0.5419,  0.5545,  0.5668,
     7  0.5793,  0.5923,  0.6061,  0.6213,  0.6383,  0.6137,  0.6139,
     8  0.6180,  0.6306,  0.6438,  0.6567,  0.6696,  0.6827,  0.6965,
     9  0.7114,  0.7279/
c
c
c         energy of gamma
c        1000.       1585.       2512.       3981.       6310.
c       0.1000e+05
c       log10 step= 0.200000
c
c       log10 of gamma energy boundary
      data egh1l/ 3.000000/
c    *     ,egh1l/ 4.000000/
c
      data (tcph  (i),i=   1,   6)/
     1  0.7747,  0.7736,  0.7772,  0.7767,  0.7660,  0.7413/
c
c        table of v
c        from u= 0.0    to  1.0000 step  0.1000
c        from log10(e)= 3.000000 to 4.000000 step  0.2000
c
      data (   vp (i),i=   1,  66)/
     1 1.0000, 0.9602, 0.9183, 0.8741, 0.8275, 0.7783, 0.7265, 0.6725,
     2 0.6163, 0.5585, 0.5000, 1.0000, 0.9603, 0.9184, 0.8743, 0.8274,
     3 0.7780, 0.7259, 0.6716, 0.6154, 0.5580, 0.5000, 1.0000, 0.9601,
     4 0.9180, 0.8733, 0.8259, 0.7764, 0.7248, 0.6709, 0.6152, 0.5579,
     5 0.5000, 1.0000, 0.9601, 0.9178, 0.8732, 0.8266, 0.7776, 0.7261,
     6 0.6724, 0.6164, 0.5584, 0.5000, 1.0000, 0.9606, 0.9190, 0.8756,
     7 0.8298, 0.7813, 0.7297, 0.6756, 0.6188, 0.5600, 0.5000, 1.0000,
     8 0.9618, 0.9220, 0.8801, 0.8352, 0.7872, 0.7356, 0.6804, 0.6223,
     9 0.5618, 0.5000/
c
c      --------------          ----------         ----------
c
c       total prob. equivalenced to common
c
      equivalence (tprob,tp)
c

c
c                         complete screening pair x-sxec.
c                         0.713 =(7/9-b)*rx0 =.773*rx0
      data rx0/0.923/, ctpc/.713/,  cep/1.e3/
c       rx0=x0(true)/x0(in nishimura text)=6.275/6.8
c       cep:  minimum energy for landau correction for pair.
c           default esbc  espc
      data esbin/5./,  espin/50./
c
c
c
      if(ee .lt. eblmin) then
          t=1.e36
      else
          if(.not. usees) then
             esb=esbin
          else
             esb=min(escb, eblmax)
          endif
          if(ee .gt. esb) then
              screen=.false.
              if(lcorec .and. ee .gt. eeh1) then
                  if(ee .gt. eeh2) then
                       write(6,'('' ee > eeh2 in brmwt: ee='',g12.4)')
     *                 ee
                       stop
                  endif
                  landau=.true.
                  ale=log10(ee)
c                 tp=fintp3(tcbh, eeh1l, deelh, neeh, ale)*rx0
                  call kintp3(tcbh, 1, neeh, eeh1l, deelh, ale, tp)
                  tp=tp*rx0
              else
                  landau=.false.
c                     complete screening cross-section
                  vc=ec/ee
                  tp=(-1.3603*(log(vc)-vc)-vc*vc*.5-.8603 )*rx0
              endif
          else
              landau=.false.
              if(scorec) then
                  screen=.true.
                  ale=log10(ee)
c                 tp=fintp3(tcbl, etcbl1, debtcl, nbtcl,  ale)
                  call kintp3(tcbl, 1, nbtcl, etcbl1, debtcl,  ale, tp)
              else
                  screen=.false.
c                     complete screening cross-section
                  vc=ec/ee
                  tp=(-1.3603*(log(vc)-vc)-vc*vc*.5-.8603 )*rx0
              endif
          endif
c
          call rndc(u)
          t =-log(u)/tp
      endif
      return
c
c     ************
      entry brmwe(ee,ec,beg)
c     ************
c
      call rndc(u)
      if(screen) then
c           partial screening
         if(u .gt. uela1) then
c                  region a
c              beg=exp( tdint4(bla, nuela, neela, uela1, eela1l, duela,
c    *         deela, u,  ale)*(1.-u) ) *egmnl
               call k4ptdi(bla, nuela, neela, nuela, uela1, eela1l,
     *         duela, deela, u, ale, ans)
               beg=exp( ans*(1.-u))*egmnl
         else
c                  region b
               us=sqrt(u)
c              beg=exp( tdint4(blb, nuelb, neelb, uelb1, eelb1l,duelb,
c    *         deelb, us, ale)) * egmnl
               call k4ptdi(blb, nuelb, neelb, nuelb, uelb1, eelb1l,
     *         duelb, deelb, us, ale, ans)
               beg=exp(ans)*egmnl
         endif
      elseif(landau) then
         if(u .lt. ueh2) then
c              beg=exp( tdint4(be1, nueh1, neeh, ueh1, eeh1l, dueh1,
c    *         deelh, u,  ale)  ) * egmnh
               call k4ptdi(be1, nueh1, neeh, nueh1,  ueh1, eeh1l,
     *         dueh1, deelh, u,  ale, ans)
               beg=exp( ans ) *egmnh
         else
               us=sqrt(1.-u)
c              beg=   ( tdint4(be2, nueh2, neeh, ueh3, eeh1l, dueh2,
c    *         deelh, us,  ale)*(1.-u)+ sqrt(egmnh/ee) )**2 *ee
               call k4ptdi(be2, nueh2, neeh, nueh2,  ueh3, eeh1l,
     *         dueh2, deelh, us,  ale, ans)
               beg=  (ans*(1.-u) + sqrt(egmnh/ee) )**2*ee
         endif
      else
c               complete screening
          a=u*tp
          if(a .le. 1.) then
             v=exp(-a)
             if(a .gt. .1) then
                 v=((.06366*a-.1447407)*a+1.014176)*v
             endif
          else
             v=exp(-(a+0.8603)/1.3603)
             if(a .le. 6.) then
                 v=((((2.050445e-3*a-3.53209e-2)*a+.228937)*a-.684076)*a
     *           +1.841734)*v
             endif
          endif
          beg=ee*v
      endif
      return
c
c
c     ***********
      entry prcwt(eg,t)
c     ***********
c
c
c
      if(eg .le. emass2) then
          t=1.e37
      elseif(eg .lt. eplmin .and. scorec) then
          tp=( (eg-emass2)/(eplmin-emass2) )**3 * tcpl(1)
          call rndc(u)
          t =-log(u)/tp
          landau=.false.
          screen=.true.
      else
          if(.not. usees) then
             esp=espin
          else
             esp=min(escp, eplmax)
          endif
          if(eg .gt. esp) then
              screen=.false.
              if(eg .gt. cep   .and. lcorec) then
                  landau=.true.
                  ale=log10(eg)
c                 tp=fintp3(tcph, egh1l, deghl, negh, ale)*rx0
                  call kintp3(tcph, 1, negh,  egh1l,  deghl,   ale, tp)
                  tp=tp*rx0
              else
                  landau=.false.
c                     complete screening cross-section
                  tp=ctpc
              endif
          else
              landau=.false.
              if(scorec) then
                  screen=.true.
                  ale=log10(eg)
c                 tp=fintp3(tcpl, etcpl1, deptcl, nptcl, ale)
                  call kintp3(tcpl, 1,nptcl,  etcpl1, deptcl,  ale, tp)
              else
                  screen=.false.
c                     complete screening cross-section
                  tp=ctpc
              endif
          endif
          call rndc(u)
          t =-log(u)/tp
      endif
      return
c
c
c     ***********
      entry prcwe(eg,e1)
c     ***********
c
c
c
      call rndc(u)
      if(screen) then
c           partial screening
         if(u .ge. ugla1) then
c                   region a
c               e1=(tdint4(pla, nugla, negla, ugla1, egla1l, dugla,
c    *          degla, u,    ale) *(1.-u) + .5 )*eg
                call k4ptdi(pla, nugla, negla,nugla,  ugla1, egla1l,
     *          dugla, degla, u,   ale, ans)
                e1=(ans*(1.-u) + .5)*eg
         else
c                   region b
                us=sqrt(u)
                ex=sqrt(ale-eglb1l)

                call k4ptdi(plb, nuglb, neglb,nuglb,  uglb1, 0.d0,
     *          duglb, deglb, us,  ale, ans)
                e1=ans*eg
         endif
      elseif(landau) then
c        e1= tdint4(vp, nugh2, negh, ugh3, egh1l, dugh2,
c    *   deghl, u,  ale) * eg
         call k4ptdi(vp, nugh2, negh, nugh2, ugh3, egh1l,
     *   dugh2, deghl, u,  ale, ans)
         e1=ans*eg
      else
c                complete screening
         e1=(((.0441223*u-.173755)*u-.3708608)*u+1.)*eg
      endif
      return
c
c     ***********
      entry emctw(Knckon)
c     ***********
c
c          see emctpb for cconst
      cconst=.379
      x0=.325
      x0ing=6.275
      x0sq=.105625
      if(Knckon) then
         ecrit=6.3e-3
      else
         ecrit=7.7e-3
      endif
      constm=.757
      rho = 19.3
c
      zchrg=74.
      zchrg2 = 5476.
      amassn=183.92
      ionizP = 748.2d-9
      end
