c     ************************ for pb*********************************
c     *                                                              *
c     *  brmpbt:  samples path for brems                             *
c     *  brmpbe:  samples energy of brems gamma                      *
c     *  prcpbt:  samples path for pair creation                     *
c     *  prcpbe:  samples energy of pair electron (higher energy)    *
c     *  emctpb:  set const in common for pb                         *
c     *                                                              *
c     *********************** tested 84.04.28 ********************k.k*
c
c      material   z     a     rho     t0 (g/cm2)  t0 (cm)    ec
c         pb      82   207.2  11.35    5.82        0.513     5.8
c                                 (n)  6.4         .57
c brems:
c        electron energy:      1mev to 300tev
c        brems gamma energy:   .1mev or more
c           if electron energy is < 1mev,  sampled path is set to be
c        very large one so that real brems may not take place before
c        the death by energy loss.
c pair:
c        gamma energy:         3mev to 300tev
c           if gamma energy is < 3mev, sampled path is set to be
c        very large one so that real pair creation may not take place
c        before compton or another process takes place.
c
c
c
c
c   /usage/          call brmpbt(ee,ec,t)
c                    call brmpbe(ee,ec,beg)
c
c                    call prcpbt(eg,t)
c                    call prcpbe(eg,e1)
c
c      ee:  incident electron energy
c      ec:  cut-off energy of brems gamma (used if complete screening
c           cross section is to be used).
c       t:  sampled path
c     beg:  sampled gamma energy
c      eg:  incident gamma energy
c      e1:  sampled electron energy (higher energy in pair)
c
c  *** note ***
c
c          before calling brmpbe, brmpbt must have been called.
c          //             prcpbe, prcpbt //
c
c          by the parameters in $elmag the user can control:
c
c        ee  -------------- 5gev------->  (if usees=t, escb instead 5)
c     scorec=t       p.s    !
c     lcorec=t              !    l.c
c     scorec=f       c.s    !
c     lcorec=f              !    c.s
c
c        eg  --------------50gev--5tev---> (if usees=t, escp instead 50)
c     scorec=t       p.s    ! c.s !
c     lcorec=t              ! c.s ! l.c
c     scorec=f       c.s    ! c.s !
c     lcorec=f              !     ! c.s
c
c
c
c
      subroutine brmpbt(ee,ec,t)
       implicit none
c
c
#include  "Zelmag.h"
#include  "Zemdef.h"
c
      integer i
      logical screen,landau
      save screen,landau
c
c
c
c
c ------------------------- partical screening ----------------------
c           *** electron ***
c
c           ! egmin (gev)  for brems.
      data egmnl/.1e-3/
c
      parameter (eblmin=1.e-3, eblmax=10.,  nbtcl=13)
      dimension tcbl(nbtcl)
c
c             brem:   region a
c
      parameter (eela1=eblmin, eela2=eblmax,neela=13,
     * uela1=.05, uela2=1., nuela=16, duela=(uela2-uela1)/(nuela-1) )
      dimension bla(nuela* neela)
c
c             brem:  region b  (sqrt(u))
      parameter (eelb1=eblmin, eelb2=eblmax, neelb=neela,
     * uelb1=0.,  uelb2=.2236068, nuelb=16,
     * duelb=(uelb2-uelb1)/(nuelb-1) )
      dimension blb(nuelb* neelb)
c           ** gamma ***
c
c                 total cross-section
      parameter (eplmin=3.e-3, eplmax=300., nptcl=16)
      dimension tcpl(nptcl)
c
c          pair: region a
      parameter ( egla1=eplmin,  egla2=eplmax, negla=16,
     *   ugla1=.05, ugla2=1., nugla=16,dugla=(ugla2-ugla1)/(nugla-1) )
      dimension pla(nugla* negla)
c
c            pair: region b     sqrt(log10(e)) sqrt(u)
      parameter (eglb1=eplmin, eglb2=eplmax, neglb=11,
     *  uglb1=0., uglb2=.2236068, nuglb=16,
     *  duglb=(uglb2-uglb1)/(nuglb-1))
      dimension plb(nuglb* neglb)
c
c
c      -------------------- landau ------------------------------
c
c          **** electron ****
c
      data egmnh/1.e-3/
      parameter ( eeh1=5., eeh2=300.e3, neeh=16,dueh1=.1,
     *  ueh1=0., ueh2=.7, nueh1=(ueh2-ueh1+.00001)/dueh1+1)
      dimension  tcbh(neeh)
      dimension  be1(nueh1* neeh)
c
c                         sqrt(1-.7)
      parameter (ueh3=0., ueh4=0.5477225,
     *nueh2=11, dvueh2=nueh2-1, dueh2=(ueh4 - ueh3)/dvueh2)
      dimension be2(nueh2*neeh)
c
c
c         *** gamma ****
c
      parameter ( egh1=5000., egh2=300.e3,negh=7, dugh2=.1,
     * ugh3=0., ugh4=1., nugh2=(ugh4-ugh3+.00001)/dugh2+1)
      dimension tcph(negh)
      dimension vp(nugh2 *negh)
c
c
c     ---------------------------------------------------------
c
      data debtcl/ 0.333333/
      data deela/ 0.333333/
      data deelb/ 0.333333/
      data deptcl/ 0.333333/
      data degla/ 0.333333/
      data deglb/ 0.223607/
c
c        electron energy=
c      0.10000e-02 0.21544e-02 0.46416e-02 0.10000e-01 0.21544e-01
c      0.46416e-01 0.10000     0.21544     0.46416      1.0000
c       2.1544      4.6416      10.000
c       log10 step=  0.3333
c
c      log10 of electron energy boundary
      data  etcbl1/-3.000000/
c    *     ,etcbl2/ 1.000000/
c
      data (tcbl  (i),i=   1,  13)/
     1 1.6616, 2.9406, 3.9589, 4.9034, 5.8508, 6.8106, 7.7771, 8.7437,
     2 9.7076,10.6689,11.6278,12.5850,13.5412/
c
c       brem: region a
c        electron energy=
c      0.10000e-02 0.21544e-02 0.46416e-02 0.10000e-01 0.21544e-01
c      0.46416e-01 0.10000     0.21544     0.46416      1.0000
c       2.1544      4.6416      10.000
c       log10 step=  0.3333
c
c      log10 of electron energy boundary
      data  eela1l/-3.000000/
c    *     ,eela2l/ 1.000000/
c
c
c            bla(iu,ie)=log(v/vmin)/(1.-u)
c            u=0.050 to 1.000 step= 0.0633
c            log10(e)= -3.0000 to   1.0000 step= 0.3333
c
      data (bla   (i),i=   1,  72)/
     1 1.4559, 1.3613, 1.2956, 1.2447, 1.2034, 1.1683, 1.1378, 1.1111,
     2 1.0870, 1.0649, 1.0466, 1.0282, 1.0103, 1.0022, 0.9887, 0.9715,
     3 2.4432, 2.2813, 2.1768, 2.1014, 2.0408, 1.9937, 1.9533, 1.9199,
     4 1.8914, 1.8682, 1.8463, 1.8258, 1.8078, 1.7911, 1.7766, 1.7628,
     5 3.3302, 3.1555, 3.0448, 2.9694, 2.9096, 2.8630, 2.8255, 2.7921,
     6 2.7644, 2.7404, 2.7199, 2.7021, 2.6869, 2.6734, 2.6620, 2.6508,
     7 4.1990, 4.0301, 3.9221, 3.8461, 3.7882, 3.7434, 3.7083, 3.6803,
     8 3.6575, 3.6387, 3.6234, 3.6101, 3.5991, 3.5901, 3.5827, 3.5759,
     9 5.0491, 4.8839, 4.7765, 4.7025, 4.6493, 4.6098, 4.5795, 4.5564/
      data (bla   (i),i=  73, 144)/
     1 4.5384, 4.5240, 4.5124, 4.5037, 4.4960, 4.4900, 4.4846, 4.4811,
     2 5.8766, 5.7107, 5.6042, 5.5330, 5.4833, 5.4479, 5.4219, 5.4027,
     3 5.3882, 5.3772, 5.3689, 5.3626, 5.3575, 5.3537, 5.3494, 5.3481,
     4 6.6817, 6.5123, 6.4057, 6.3369, 6.2907, 6.2589, 6.2367, 6.2208,
     5 6.2094, 6.2009, 6.1949, 6.1903, 6.1868, 6.1845, 6.1816, 6.1812,
     6 7.4689, 7.2931, 7.1864, 7.1202, 7.0776, 7.0493, 7.0306, 7.0176,
     7 7.0089, 7.0026, 6.9981, 6.9952, 6.9931, 6.9915, 6.9892, 6.9893,
     8 8.2425, 8.0593, 7.9530, 7.8902, 7.8514, 7.8269, 7.8112, 7.8007,
     9 7.7939, 7.7893, 7.7862, 7.7839, 7.7827, 7.7815, 7.7814, 7.7805/
      data (bla   (i),i= 145, 208)/
     1 9.0062, 8.8165, 8.7122, 8.6532, 8.6184, 8.5972, 8.5841, 8.5759,
     2 8.5707, 8.5676, 8.5654, 8.5640, 8.5632, 8.5626, 8.5626, 8.5617,
     3 9.7641, 9.5691, 9.4677, 9.4127, 9.3816, 9.3636, 9.3530, 9.3465,
     4 9.3428, 9.3402, 9.3390, 9.3381, 9.3372, 9.3376, 9.3359, 9.3366,
     510.5183,10.3196,10.2218,10.1710,10.1436,10.1283,10.1197,10.1147,
     610.1120,10.1102,10.1094,10.1086,10.1082,10.1080,10.1069,10.1078,
     711.2707,11.0700,10.9762,10.9297,10.9055,10.8928,10.8857,10.8820,
     810.8800,10.8788,10.8783,10.8781,10.8774,10.8769,10.8786,10.8772/
c
c       brem: region b
c        electron energy=
c      0.10000e-02 0.21544e-02 0.46416e-02 0.10000e-01 0.21544e-01
c      0.46416e-01 0.10000     0.21544     0.46416      1.0000
c       2.1544      4.6416      10.000
c       log10 step=  0.3333
c
c      log10 of electron energy boundary
      data  eelb1l/-3.000000/
c    *     ,eelb2l/ 1.000000/
c
c
c            blb(iu,ie)=log(v/vmin)/(1.-u)
c            sqrt(u)=0.0   to 0.224 step= 0.0149
c            log10(e)= -3.0000 to   1.0000 step= 0.3333
c
      data (blb   (i),i=   1,  72)/
     1 1.5872, 1.5859, 1.5824, 1.5763, 1.5683, 1.5580, 1.5460, 1.5324,
     2 1.5173, 1.5009, 1.4834, 1.4649, 1.4455, 1.4254, 1.4045, 1.3831,
     3 2.7994, 2.7875, 2.7635, 2.7355, 2.7058, 2.6746, 2.6424, 2.6094,
     4 2.5754, 2.5408, 2.5056, 2.4698, 2.4332, 2.3964, 2.3590, 2.3211,
     5 3.7210, 3.6915, 3.6636, 3.6338, 3.6023, 3.5692, 3.5345, 3.4983,
     6 3.4607, 3.4216, 3.3814, 3.3399, 3.2974, 3.2537, 3.2092, 3.1637,
     7 4.5527, 4.5252, 4.5011, 4.4744, 4.4453, 4.4139, 4.3802, 4.3442,
     8 4.3063, 4.2661, 4.2242, 4.1802, 4.1348, 4.0877, 4.0394, 3.9891,
     9 5.3487, 5.3278, 5.3075, 5.2840, 5.2579, 5.2289, 5.1970, 5.1624/
      data (blb   (i),i=  73, 144)/
     1 5.1253, 5.0854, 5.0431, 4.9985, 4.9511, 4.9019, 4.8504, 4.7967,
     2 6.1292, 6.1138, 6.0966, 6.0762, 6.0524, 6.0257, 5.9958, 5.9625,
     3 5.9263, 5.8866, 5.8441, 5.7982, 5.7489, 5.6964, 5.6412, 5.5827,
     4 6.9026, 6.8911, 6.8764, 6.8583, 6.8367, 6.8114, 6.7826, 6.7502,
     5 6.7138, 6.6735, 6.6290, 6.5804, 6.5277, 6.4713, 6.4111, 6.3476,
     6 7.6729, 7.6639, 7.6513, 7.6348, 7.6143, 7.5900, 7.5613, 7.5282,
     7 7.4904, 7.4479, 7.4005, 7.3484, 7.2916, 7.2303, 7.1650, 7.0955,
     8 8.4417, 8.4346, 8.4232, 8.4078, 8.3878, 8.3631, 8.3335, 8.2986,
     9 8.2586, 8.2131, 8.1622, 8.1057, 8.0441, 7.9775, 7.9062, 7.8304/
      data (blb   (i),i= 145, 208)/
     1 9.2098, 9.2039, 9.1934, 9.1783, 9.1579, 9.1323, 9.1009, 9.0639,
     2 9.0209, 8.9718, 8.9166, 8.8554, 8.7885, 8.7158, 8.6383, 8.5559,
     3 9.9776, 9.9726, 9.9625, 9.9470, 9.9257, 9.8986, 9.8652, 9.8253,
     4 9.7789, 9.7259, 9.6661, 9.5997, 9.5270, 9.4486, 9.3647, 9.2759,
     510.7453,10.7408,10.7306,10.7145,10.6921,10.6631,10.6272,10.5844,
     610.5343,10.4769,10.4123,10.3405,10.2621,10.1777,10.0875, 9.9924,
     711.5129,11.5087,11.4983,11.4812,11.4574,11.4263,11.3879,11.3418,
     811.2878,11.2260,11.1563,11.0791,10.9951,10.9047,10.8084,10.7072/
c
c       pair: total x-section
c        gamm energy=
c      0.30000e-02 0.64633e-02 0.13925e-01 0.30000e-01 0.64633e-01
c      0.13925     0.30000     0.64633      1.3925      3.0000
c       6.4633      13.925      30.000      64.633      139.25
c       300.00
c       log10 step=  0.3333
c
c      log10 of gamma energy boundary
      data  etcpl1/-2.522879/
c    *     ,etcpl2/ 2.477121/
c
      data (tcpl  (i),i=   1,  16)/
     1 0.0090, 0.1155, 0.2394, 0.3653, 0.4792, 0.5658, 0.6229, 0.6580,
     2 0.6787, 0.6903, 0.6967, 0.7002, 0.7020, 0.7029, 0.7034, 0.7036/
c
c       pair: region a
c
c         energy of gamma=
c        0.300e-02   0.646e-02   0.139e-01   0.300e-01   0.646e-01
c        0.139       0.300       0.646        1.39        3.00
c         6.46        13.9        30.0        64.6        139.
c         300.
c         log10 step= 0.333333
c
c         log10 of eg boundary
      data  egla1l/-2.522879/
c    *     ,egla2l/ 2.477121/
c
c
c         pla(iu,ie)=(v-.5)/(1.-u)
c         u=0.050 to1.000   step= 0.0633
c            log10(e)= -2.5229 to   2.4771 step= 0.3333
c
      data (pla   (i),i=   1,  72)/
     1 0.0926, 0.0921, 0.0916, 0.0912, 0.0909, 0.0905, 0.0902, 0.0900,
     2 0.0898, 0.0895, 0.0893, 0.0891, 0.0892, 0.0893, 0.0896, 0.0890,
     3 0.3512, 0.3390, 0.3315, 0.3262, 0.3222, 0.3193, 0.3169, 0.3151,
     4 0.3135, 0.3122, 0.3114, 0.3105, 0.3102, 0.3095, 0.3091, 0.3094,
     5 0.4192, 0.4082, 0.4022, 0.3983, 0.3958, 0.3941, 0.3928, 0.3919,
     6 0.3915, 0.3910, 0.3909, 0.3909, 0.3908, 0.3905, 0.3907, 0.3906,
     7 0.4516, 0.4437, 0.4400, 0.4381, 0.4371, 0.4367, 0.4368, 0.4369,
     8 0.4374, 0.4383, 0.4384, 0.4401, 0.4395, 0.4424, 0.4426, 0.4410,
     9 0.4700, 0.4654, 0.4641, 0.4644, 0.4655, 0.4667, 0.4689, 0.4706/
      data (pla   (i),i=  73, 144)/
     1 0.4725, 0.4750, 0.4767, 0.4783, 0.4794, 0.4806, 0.4813, 0.4803,
     2 0.4818, 0.4807, 0.4824, 0.4849, 0.4883, 0.4918, 0.4952, 0.4992,
     3 0.5025, 0.5056, 0.5084, 0.5106, 0.5123, 0.5149, 0.5151, 0.5158,
     4 0.4901, 0.4922, 0.4961, 0.5006, 0.5054, 0.5103, 0.5151, 0.5200,
     5 0.5245, 0.5284, 0.5323, 0.5352, 0.5374, 0.5400, 0.5412, 0.5417,
     6 0.4959, 0.5001, 0.5053, 0.5112, 0.5169, 0.5228, 0.5287, 0.5341,
     7 0.5395, 0.5441, 0.5486, 0.5521, 0.5553, 0.5573, 0.5590, 0.5595,
     8 0.4997, 0.5052, 0.5115, 0.5179, 0.5243, 0.5309, 0.5372, 0.5433,
     9 0.5490, 0.5542, 0.5591, 0.5631, 0.5664, 0.5689, 0.5706, 0.5708/
      data (pla   (i),i= 145, 216)/
     1 0.5022, 0.5085, 0.5153, 0.5221, 0.5291, 0.5357, 0.5424, 0.5488,
     2 0.5548, 0.5602, 0.5651, 0.5696, 0.5731, 0.5754, 0.5775, 0.5777,
     3 0.5037, 0.5105, 0.5174, 0.5246, 0.5316, 0.5387, 0.5455, 0.5520,
     4 0.5582, 0.5638, 0.5691, 0.5736, 0.5770, 0.5793, 0.5815, 0.5817,
     5 0.5045, 0.5116, 0.5188, 0.5261, 0.5332, 0.5403, 0.5472, 0.5537,
     6 0.5602, 0.5658, 0.5711, 0.5755, 0.5790, 0.5818, 0.5835, 0.5839,
     7 0.5050, 0.5123, 0.5196, 0.5269, 0.5341, 0.5411, 0.5481, 0.5547,
     8 0.5610, 0.5668, 0.5722, 0.5765, 0.5803, 0.5828, 0.5845, 0.5851,
     9 0.5054, 0.5126, 0.5199, 0.5272, 0.5345, 0.5417, 0.5486, 0.5554/
      data (pla   (i),i= 217, 256)/
     1 0.5616, 0.5675, 0.5726, 0.5770, 0.5811, 0.5835, 0.5854, 0.5858,
     2 0.5056, 0.5128, 0.5202, 0.5275, 0.5349, 0.5419, 0.5490, 0.5557,
     3 0.5618, 0.5678, 0.5730, 0.5775, 0.5811, 0.5838, 0.5854, 0.5861,
     4 0.5056, 0.5129, 0.5203, 0.5275, 0.5349, 0.5421, 0.5490, 0.5557,
     5 0.5621, 0.5681, 0.5730, 0.5775, 0.5811, 0.5842, 0.5854, 0.5863/
c
c
c       pair: region b
c
c         energy of gamma=
c        0.300e-02   0.337e-02   0.475e-02   0.846e-02   0.189e-01
c        0.533e-01   0.189       0.846        4.75        33.7
c         300.
c         sqrt(log10) step= 0.223607
c
c         use 0 for e-side at interpolation
c         with sqrt(log10(e)-eglb1l)
      data  eglb1l/-2.522879/
c
c
c         plb(iu,ie)=v
c         sqrt(u)=0.0   to0.224   step= 0.0149
      data (plb   (i),i=   1,  72)/
     1 0.8297, 0.5930, 0.5930, 0.5928, 0.5927, 0.5925, 0.5923, 0.5920,
     2 0.5916, 0.5912, 0.5908, 0.5903, 0.5898, 0.5892, 0.5887, 0.5880,
     3 0.8482, 0.6769, 0.6768, 0.6765, 0.6762, 0.6757, 0.6751, 0.6744,
     4 0.6736, 0.6728, 0.6718, 0.6707, 0.6695, 0.6683, 0.6669, 0.6655,
     5 0.8925, 0.8107, 0.8103, 0.8095, 0.8084, 0.8071, 0.8055, 0.8036,
     6 0.8015, 0.7992, 0.7968, 0.7942, 0.7914, 0.7884, 0.7853, 0.7822,
     7 0.9396, 0.9075, 0.9065, 0.9046, 0.9024, 0.8998, 0.8968, 0.8937,
     8 0.8903, 0.8867, 0.8831, 0.8792, 0.8753, 0.8713, 0.8671, 0.8629,
     9 0.9730, 0.9614, 0.9595, 0.9570, 0.9541, 0.9510, 0.9478, 0.9443/
      data (plb   (i),i=  73, 144)/
     1 0.9408, 0.9371, 0.9335, 0.9295, 0.9256, 0.9214, 0.9173, 0.9130,
     2 0.9904, 0.9861, 0.9840, 0.9817, 0.9792, 0.9766, 0.9738, 0.9708,
     3 0.9679, 0.9646, 0.9614, 0.9579, 0.9543, 0.9506, 0.9468, 0.9428,
     4 0.9973, 0.9954, 0.9940, 0.9924, 0.9906, 0.9886, 0.9866, 0.9842,
     5 0.9819, 0.9794, 0.9767, 0.9739, 0.9709, 0.9679, 0.9646, 0.9613,
     6 0.9994, 0.9986, 0.9977, 0.9967, 0.9954, 0.9941, 0.9926, 0.9909,
     7 0.9892, 0.9873, 0.9852, 0.9830, 0.9806, 0.9781, 0.9754, 0.9725,
     8 0.9999, 0.9995, 0.9990, 0.9984, 0.9975, 0.9965, 0.9954, 0.9941,
     9 0.9928, 0.9912, 0.9893, 0.9874, 0.9853, 0.9830, 0.9805, 0.9780/
      data (plb   (i),i= 145, 176)/
     1 1.0000, 0.9998, 0.9994, 0.9989, 0.9983, 0.9975, 0.9965, 0.9954,
     2 0.9941, 0.9926, 0.9909, 0.9891, 0.9870, 0.9848, 0.9825, 0.9799,
     3 1.0000, 0.9999, 0.9996, 0.9992, 0.9986, 0.9977, 0.9969, 0.9957,
     4 0.9944, 0.9930, 0.9913, 0.9894, 0.9875, 0.9853, 0.9828, 0.9803/
c
c    ---------------     $$$   landau correction region $$$     ----
c
      data deelh/ 0.318543/
      data deghl/ 0.296359/
c
c          energy of electron
c        5.000       10.41       21.68       45.14       94.00
c        195.7       407.6       848.7       1767.       3680.
c        7663.      0.1596e+05  0.3323e+05  0.6919e+05  0.1441e+06
c       0.3000e+06
c         log10 step= 0.318543
c
c         log10 of electron energy boundary
      data eeh1l/ 0.698970/
c    *     ,eeh2l/ 5.477121/
c
      data (tcbh  (i),i=   1,  16)/
     1 10.1186, 10.1680,  9.7790,  9.1165,  8.3038,  7.4172,  6.5007,
     2  5.5852,  4.6987,  3.8655,  3.1085,  2.4458,  1.8833,  1.4232,
     3  1.0581,  0.7758/
c
c          be1(iu,ie)= log(v/vmin)
c          from u=0.0   to 0.700 step=0.100
c          from log10(e)=  0.6990 to  5.4771 step  0.3185
c          dim. of u=  8 dim of e= 16
c
      data (   be1(i),i=   1,  54)/
     1  8.51719,  7.42710,  6.50089,  5.67237,  4.88273,  4.10839,
     2  3.34465,  2.59751,  9.25067,  8.15563,  7.22597,  6.39409,
     3  5.60041,  4.82400,  4.07026,  3.30214,  9.98414,  8.92820,
     4  8.02593,  7.22041,  6.45143,  5.71673,  4.98129,  4.20094,
     5 10.71761,  9.72907,  8.87399,  8.10947,  7.39811,  6.70820,
     6  5.99904,  5.21939, 11.45109, 10.54663,  9.74964,  9.04526,
     7  8.39374,  7.74809,  7.06773,  6.29899, 12.18456, 11.37364,
     8 10.64205, 10.00715,  9.40895,  8.80380,  8.15248,  7.40052,
     9 12.91803, 12.20503, 11.55177, 10.97720, 10.42444,  9.85502/
      data (   be1(i),i=  55, 108)/
     1  9.23115,  8.49832, 13.65150, 13.03860, 12.46475, 11.94178,
     2 11.42760, 10.88898, 10.28984,  9.57615, 14.38498, 13.87291,
     3 13.37145, 12.89209, 12.41068, 11.89799, 11.32034, 10.62440,
     4 15.11845, 14.70080, 14.26362, 13.82242, 13.36774, 12.87656,
     5 12.31711, 11.63687, 15.85192, 15.51647, 15.13636, 14.72900,
     6 14.29633, 13.82217, 13.27755, 12.61068, 16.58540, 16.31778,
     7 15.98553, 15.60813, 15.19483, 14.73532, 14.20296, 13.54697,
     8 17.31886, 17.10503, 16.81381, 16.46161, 16.06410, 15.61560,
     9 15.09249, 14.44520, 18.05234, 17.88005, 17.62082, 17.28893/
      data (   be1(i),i= 109, 128)/
     1 16.90474, 16.46609, 15.95095, 15.31060, 18.78581, 18.64471,
     2 18.40991, 18.09622, 17.72295, 17.29169, 16.78241, 16.14745,
     3 19.51929, 19.40117, 19.18575, 18.88586, 18.52122, 18.09561,
     4 17.59073, 16.95985/
c
c         be2(iu,ie)= (sqrt(v) -sqrtv)/(1.-u)
c          from sqrt(1-u)=0.0   to 0.548 step= 0.055
c          from log10(e)= 0.698970 to 5.477121 step  0.3185
c
      data (   be2(i),i=   1,  63)/
     1  0.0811,  0.0814,  0.0823,  0.0838,  0.0860,  0.0890,  0.0930,
     2  0.0982,  0.1049,  0.1138,  0.1256,  0.0937,  0.0940,  0.0949,
     3  0.0965,  0.0988,  0.1019,  0.1059,  0.1111,  0.1178,  0.1264,
     4  0.1376,  0.1143,  0.1147,  0.1159,  0.1178,  0.1205,  0.1240,
     5  0.1286,  0.1343,  0.1415,  0.1506,  0.1623,  0.1424,  0.1429,
     6  0.1445,  0.1470,  0.1504,  0.1548,  0.1602,  0.1668,  0.1749,
     7  0.1850,  0.1976,  0.1778,  0.1786,  0.1809,  0.1844,  0.1889,
     8  0.1943,  0.2007,  0.2085,  0.2177,  0.2289,  0.2427,  0.2204,
     9  0.2218,  0.2255,  0.2304,  0.2362,  0.2429,  0.2506,  0.2595/
      data (   be2(i),i=  64, 126)/
     1  0.2699,  0.2824,  0.2973,  0.2699,  0.2724,  0.2781,  0.2849,
     2  0.2923,  0.3004,  0.3094,  0.3195,  0.3311,  0.3446,  0.3605,
     3  0.3253,  0.3297,  0.3381,  0.3471,  0.3563,  0.3658,  0.3760,
     4  0.3872,  0.3998,  0.4142,  0.4308,  0.3940,  0.3949,  0.4047,
     5  0.4157,  0.4265,  0.4373,  0.4486,  0.4607,  0.4740,  0.4889,
     6  0.5060,  0.4676,  0.4678,  0.4759,  0.4882,  0.5002,  0.5120,
     7  0.5241,  0.5368,  0.5505,  0.5657,  0.5829,  0.5424,  0.5426,
     8  0.5484,  0.5611,  0.5739,  0.5864,  0.5990,  0.6121,  0.6260,
     9  0.6411,  0.6580,  0.6158,  0.6160,  0.6193,  0.6315,  0.6446/
      data (   be2(i),i= 127, 176)/
     1  0.6575,  0.6703,  0.6835,  0.6973,  0.7122,  0.7288,  0.6842,
     2  0.6846,  0.6857,  0.6961,  0.7089,  0.7218,  0.7346,  0.7476,
     3  0.7611,  0.7757,  0.7917,  0.7461,  0.7464,  0.7468,  0.7539,
     4  0.7657,  0.7781,  0.7905,  0.8032,  0.8163,  0.8304,  0.8459,
     5  0.8005,  0.8010,  0.8011,  0.8045,  0.8144,  0.8258,  0.8376,
     6  0.8498,  0.8624,  0.8760,  0.8909,  0.8469,  0.8471,  0.8473,
     7  0.8482,  0.8552,  0.8652,  0.8761,  0.8875,  0.8995,  0.9125,
     8  0.9269/
c
c
c         energy of gamma
c        5000.       9893.      0.1957e+05  0.3873e+05  0.7663e+05
c       0.1516e+06  0.3000e+06
c       log10 step= 0.296359
c
c       log10 of gamma energy boundary
      data egh1l/ 3.698970/
c    *     ,egh1l/ 5.477121/
c
      data (tcph  (i),i=   1,   7)/
     1  0.7784,  0.7666,  0.7247,  0.6504,  0.5542,  0.4515,  0.3550/
c
c        table of v
c        from u= 0.0    to  1.0000 step  0.1000
c        from log10(e)= 3.698970 to 5.477121 step  0.2964
c
      data (   vp (i),i=   1,  72)/
     1 1.0000, 0.9600, 0.9178, 0.8728, 0.8258, 0.7766, 0.7251, 0.6712,
     2 0.6153, 0.5581, 0.5000, 1.0000, 0.9606, 0.9189, 0.8755, 0.8296,
     3 0.7812, 0.7296, 0.6755, 0.6187, 0.5599, 0.5000, 1.0000, 0.9627,
     4 0.9240, 0.8828, 0.8385, 0.7906, 0.7388, 0.6834, 0.6246, 0.5631,
     5 0.5000, 1.0000, 0.9668, 0.9317, 0.8934, 0.8508, 0.8038, 0.7517,
     6 0.6946, 0.6330, 0.5675, 0.5000, 1.0000, 0.9718, 0.9407, 0.9053,
     7 0.8648, 0.8188, 0.7666, 0.7079, 0.6431, 0.5730, 0.5000, 1.0000,
     8 0.9767, 0.9495, 0.9171, 0.8788, 0.8340, 0.7818, 0.7218, 0.6538,
     9 0.5790, 0.5000, 1.0000, 0.9811, 0.9573, 0.9277, 0.8915, 0.8480/
      data (   vp (i),i=  73,  77)/
     1 0.7962, 0.7351, 0.6644, 0.5849, 0.5000/
c
c       total prob. equivalenced to common
c
      equivalence (tprob,tp)
c

c
c                         complete screening pair x-sxec.
c                         0.703 =(7/9-b)*rx0 =.773*rx0
      data rx0/0.909/, ctpc/.703/,  cep/5.e3/
c       rx0=x0(true)/x0(in nishimura text)=5.82/6.4
c       cep:  minimum energy for landau correction for pair.
c          default esbc espc
      data esbin/5./,  espin/50./
c
c
      if(ee .lt. eblmin) then
          t=1.e36
      else
          if(.not. usees) then
             esb=esbin
          else
             esb=min(escb, eblmax)
          endif
          if(ee .gt. esb) then
              screen=.false.
              if(lcorec .and. ee .gt. eeh1) then
                  if(ee .gt. eeh2) then
                       write(6,'('' ee > eeh2 in brmpbt: ee='',g12.4)')
     *                 ee
                       stop
                  endif
                  landau=.true.
                  ale=log10(ee)
c                 tp=fintp3(tcbh, eeh1l, deelh, neeh, ale)*rx0
                  call kintp3(tcbh, 1, neeh, eeh1l, deelh, ale, tp)
                  tp=tp*rx0
              else
                  landau=.false.
c                     complete screening cross-section
                  vc=ec/ee
                  tp=(-1.3603*(log(vc)-vc)-vc*vc*.5-.8603 )*rx0
              endif
          else
              landau=.false.
              if(scorec) then
                  screen=.true.
                  ale=log10(ee)
c                 tp=fintp3(tcbl, etcbl1, debtcl, nbtcl,  ale)
                  call kintp3(tcbl, 1, nbtcl, etcbl1, debtcl,  ale, tp)
              else
                  screen=.false.
c                     complete screening cross-section
                  vc=ec/ee
                  tp=(-1.3603*(log(vc)-vc)-vc*vc*.5-.8603 )*rx0
              endif
          endif
c
          call rndc(u)
          t =-log(u)/tp
      endif
      return
c
c     ************
      entry brmpbe(ee,ec,beg)
c     ************
c
      call rndc(u)
      if(screen) then
c           partial screening
         if(u .gt. uela1) then
c                  region a
c              beg=exp( tdint4(bla, nuela, neela, uela1, eela1l, duela,
c    *         deela, u,  ale)*(1.-u) ) *egmnl
               call k4ptdi(bla, nuela, neela, nuela, uela1, eela1l,
     *         duela, deela, u, ale, ans)
               beg=exp( ans*(1.-u))*egmnl
         else
c                  region b
               us=sqrt(u)
c              beg=exp( tdint4(blb, nuelb, neelb, uelb1, eelb1l,duelb,
c    *         deelb, us, ale)) * egmnl
               call k4ptdi(blb, nuelb, neelb, nuelb, uelb1, eelb1l,
     *         duelb, deelb, us, ale, ans)
               beg=exp(ans)*egmnl
         endif
      elseif(landau) then
         if(u .lt. ueh2) then
c              beg=exp( tdint4(be1, nueh1, neeh, ueh1, eeh1l, dueh1,
c    *         deelh, u,  ale)  ) * egmnh
               call k4ptdi(be1, nueh1, neeh, nueh1,  ueh1, eeh1l,
     *         dueh1, deelh, u,  ale, ans)
               beg=exp( ans ) *egmnh
         else
               us=sqrt(1.-u)
c              beg=   ( tdint4(be2, nueh2, neeh, ueh3, eeh1l, dueh2,
c    *         deelh, us,  ale)*(1.-u)+ sqrt(egmnh/ee) )**2 *ee
               call k4ptdi(be2, nueh2, neeh, nueh2,  ueh3, eeh1l,
     *         dueh2, deelh, us,  ale, ans)
               beg=  (ans*(1.-u) + sqrt(egmnh/ee) )**2*ee
         endif
      else
c               complete screening
          a=u*tp
          if(a .le. 1.) then
             v=exp(-a)
             if(a .gt. .1) then
                 v=((.06366*a-.1447407)*a+1.014176)*v
             endif
          else
             v=exp(-(a+0.8603)/1.3603)
             if(a .le. 6.) then
                 v=((((2.050445e-3*a-3.53209e-2)*a+.228937)*a-.684076)*a
     *           +1.841734)*v
             endif
          endif
          beg=ee*v
      endif
      return
c
c
c     ***********
      entry prcpbt(eg,t)
c     ***********
c
c
c
      if(eg .le. emass2) then
          t=1.e37
      elseif(eg .lt. eplmin .and. scorec) then
          tp=( (eg-emass2)/(eplmin-emass2) )**3 * tcpl(1)
          call rndc(u)
          t =-log(u)/tp
          landau=.false.
          screen=.true.
      else
          if(.not. usees) then
             esp=espin
          else
             esp=min(escp, eplmax)
          endif
          if(eg .gt. esp) then
              screen=.false.
              if(eg .gt. cep   .and. lcorec) then
                  landau=.true.
                  ale=log10(eg)
c                 tp=fintp3(tcph, egh1l, deghl, negh, ale)*rx0
                  call kintp3(tcph, 1, negh,  egh1l,  deghl,   ale, tp)
                  tp=tp*rx0
              else
                  landau=.false.
c                     complete screening cross-section
                  tp=ctpc
              endif
          else
              landau=.false.
              if(scorec) then
                  screen=.true.
                  ale=log10(eg)
c                 tp=fintp3(tcpl, etcpl1, deptcl, nptcl, ale)
                  call kintp3(tcpl, 1,nptcl,  etcpl1, deptcl,  ale, tp)
              else
                  screen=.false.
c                     complete screening cross-section
                  tp=ctpc
              endif
          endif
          call rndc(u)
          t =-log(u)/tp
      endif
      return
c
c
c     ***********
      entry prcpbe(eg,e1)
c     ***********
c
c
c
      call rndc(u)
      if(screen) then
c           partial screening
         if(u .ge. ugla1) then
c                   region a
c               e1=(tdint4(pla, nugla, negla, ugla1, egla1l, dugla,
c    *          degla, u,    ale) *(1.-u) + .5 )*eg
                call k4ptdi(pla, nugla, negla,nugla,  ugla1, egla1l,
     *          dugla, degla, u,   ale, ans)
                e1=(ans*(1.-u) + .5)*eg
         else
c                   region b
                us=sqrt(u)
                ex=sqrt(ale-eglb1l)

                call k4ptdi(plb, nuglb, neglb,nuglb,  uglb1, 0.d0,
     *          duglb, deglb, us,  ale, ans)
                e1=ans*eg
         endif
      elseif(landau) then
c        e1= tdint4(vp, nugh2, negh, ugh3, egh1l, dugh2,
c    *   deghl, u,  ale) * eg
         call k4ptdi(vp, nugh2, negh, nugh2, ugh3, egh1l,
     *   dugh2, deghl, u,  ale, ans)
         e1=ans*eg
      else
c                complete screening
         e1=(((.0441223*u-.173755)*u-.3708608)*u+1.)*eg
      endif
      return
c
c     ************
      entry emctpb(Knckon)
c     ************
c
c               cconst=for compton=3/8*thomson*n0*z/a*x0ing
c               to convert cross-section in compt into /(r.l).
      cconst=.345
      x0=.513
      x0ing=5.82
      x0sq=.263169
      if(Knckon) then
         ecrit=5.8e-3
      else
         ecrit=7.2e-3
      endif
c         moller scat
      constm=.691
      rho = 11.35
c
      zchrg=82.
      zchrg2 = 6724.
      amassn=207.2
      ionizP = 825.8d-9
      end
