
c     ************************ for csi********************************
c     *                                                              *
c     *  brmcst:  samples path for brems                             *
c     *  brmcse:  samples energy of brems gamma                      *
c     *  prccst:  samples path for pair creation                     *
c     *  prccse:  samples energy of pair electron (higher energy)    *
c     *  emctcs:  set const in common for cs                         *
c     *                                                              *
c     *********************** tested 94.04.28 ********************k.k*
c
c      material   z     a     rho     t0 (g/cm2)  t0 (cm)    ec
c         csi     54   130.   4.53                 1.786
c
c brems:
c        electron energy:      1mev to 1000tev
c        brems gamma energy:   .1mev or more
c           if electron energy is < 1mev,  sampled path is set to be
c        very large one so that real brems may not take place before
c        the death by energy loss.
c pair:
c        gamma energy:         2mev to1000tev
c           if gamma energy is < 2mev, sampled path is set to be
c        very large one so that real pair creation may not take place
c        before compton or another process takes place.
c
c
c
c
c   /usage/          call brmcst(ee,ec,t)
c                    call brmcse(ee,ec,beg)
c
c                    call prccst(eg,t)
c                    call prccse(eg,e1)
c
c      ee:  incident electron energy
c      ec:  cut-off energy of brems gamma (used if complete screening
c           cross section is to be used).
c       t:  sampled path
c     beg:  sampled gamma energy
c      eg:  incident gamma energy
c      e1:  sampled electron energy (higher energy in pair)
c
c  *** note ***
c
c          before calling brmcse, brmcst must have been called.
c          //             prccse, prccst //
c
c          by the parameters in $elmag the user can control:
c
c        ee  --------------10gev------->  (if usees=t, escb instead 5)
c     scorec=t       p.s    !
c     lcorec=t              !    l.c
c     scorec=f       c.s    !
c     lcorec=f              !    c.s
c
c        eg  --------------50gev--50tev--> (if usees=t, escp instead 50)
c     scorec=t       p.s    ! c.s !
c     lcorec=t              ! c.s ! l.c
c     scorec=f       c.s    ! c.s !
c     lcorec=f              !     ! c.s
c
c
c
c
      subroutine brmcst(ee,ec,t)
       implicit none
c
c
#include  "Zelmag.h"
#include  "Zemdef.h"


c
      integer i
      logical screen,landau
      save screen,landau
c
c
c
c
c ------------------------- partical screening ----------------------
c           *** electron ***
c
c           ! egmin (gev)  for brems.
      data egmnl/.1e-3/
c
      parameter (eblmin=1.e-3, eblmax=10., nbtcl=14)
      dimension tcbl(nbtcl)
c
c             brem:   region a
c
      parameter (eela1=eblmin, eela2=eblmax,neela=14,
     * uela1=.05, uela2=1., nuela=16, duela=(uela2-uela1)/(nuela-1) )
      dimension bla(nuela *neela)
c
c             brem:  region b  (sqrt(u))
      parameter (eelb1=eblmin, eelb2=eblmax, neelb=neela,
     * uelb1=0.,  uelb2=.2236068, nuelb=16,
     * duelb=(uelb2-uelb1)/(nuelb-1) )
      dimension blb(nuelb* neelb)
c           ** gamma ***
c
c
c                 total cross-section
      parameter (eplmin=2.0e-3, eplmax= 10., nptcl=15)
      dimension tcpl(nptcl)
c
c          pair: region a
      parameter ( egla1=eplmin,  egla2=eplmax, negla=15,
     *   ugla1=.05, ugla2=1., nugla=16,dugla=(ugla2-ugla1)/(nugla-1) )
      dimension pla(nugla* negla)
c
c            pair: region b     sqrt(log10(e)) sqrt(u)
      parameter (eglb1=eplmin, eglb2=eplmax, neglb=14,
     *  uglb1=0., uglb2=.2236068, nuglb=16,
     *  duglb=(uglb2-uglb1)/(nuglb-1))
      dimension plb(nuglb* neglb)
c
c
c      -------------------- landau ------------------------------
c          **** electron ****
c
      data egmnh/1.e-3/
      parameter ( eeh1=1.e1, eeh2= 1.e6,  neeh=16,dueh1=.1,
     *  ueh1=0., ueh2=.7, nueh1=(ueh2-ueh1+.00001)/dueh1+1)
      dimension  tcbh(neeh)
      dimension  be1(nueh1* neeh)
c
c                         sqrt(1-.7)
      parameter (ueh3=0., ueh4=0.5477225,
     *nueh2=11, dvueh2=nueh2-1, dueh2=(ueh4 - ueh3)/dvueh2)
      dimension be2(nueh2*neeh)
c
c
c         *** gamma ****
c
      parameter ( egh1=5.e4, egh2= 1.e6, negh=10,dugh2=.1,
     * ugh3=0., ugh4=1., nugh2=(ugh4-ugh3+.00001)/dugh2+1)
      dimension tcph(negh)
      dimension vp(nugh2* negh)
c
c
c     ---------------------------------------------------------
      data debtcl/ 0.307692/
      data deela/ 0.307692/
      data deelb/ 0.307692/
      data deptcl/ 0.264212/
      data degla/ 0.264212/
      data deglb/ 0.147944/
c        electron energy=
c      0.10000e-02 0.20309e-02 0.41246e-02 0.83768e-02 0.17013e-01
c      0.34551e-01 0.70170e-01 0.14251     0.28943     0.58780
c       1.1938      2.4245      4.9239      10.000
c       log10 step=  0.3077
c
c      log10 of electron energy boundary
      data  etcbl1/-3.000000/
c    *     ,etcbl2/ 1.000000/
c
      data (tcbl  (i),i=   1,  14)/
     1 1.6010, 2.8040, 3.8315, 4.7989, 5.7533, 6.7077, 7.6603, 8.6081,
     2 9.5497,10.4856,11.4177,12.3467,13.2738,14.1997/
c
c       brem: region a
c        electron energy=
c      0.10000e-02 0.20309e-02 0.41246e-02 0.83768e-02 0.17013e-01
c      0.34551e-01 0.70170e-01 0.14251     0.28943     0.58780
c       1.1938      2.4245      4.9239      10.000
c       log10 step=  0.3077
c
c      log10 of electron energy boundary
      data  eela1l/-3.000000/
c    *     ,eela2l/ 1.000000/
c
c
c            bla(iu,ie)=log(v/vmin)/(1.-u)
c            u=0.050 to 1.000 step= 0.0633
c            log10(e)= -3.0000 to   1.0000 step= 0.3077
c
      data (bla   (i),i=   1,  72)/
     1 1.4733, 1.3840, 1.3202, 1.2702, 1.2291, 1.1940, 1.1637, 1.1368,
     2 1.1127, 1.0907, 1.0702, 1.0505, 1.0350, 1.0162, 0.9905, 0.9959,
     3 2.4056, 2.2450, 2.1403, 2.0623, 2.0009, 1.9517, 1.9089, 1.8752,
     4 1.8454, 1.8187, 1.7942, 1.7764, 1.7587, 1.7431, 1.7268, 1.7137,
     5 3.2179, 3.0395, 2.9275, 2.8463, 2.7879, 2.7391, 2.6982, 2.6656,
     6 2.6370, 2.6124, 2.5908, 2.5717, 2.5551, 2.5409, 2.5278, 2.5161,
     7 4.0126, 3.8373, 3.7290, 3.6504, 3.5912, 3.5451, 3.5082, 3.4783,
     8 3.4540, 3.4336, 3.4166, 3.4024, 3.3905, 3.3806, 3.3720, 3.3637,
     9 4.7949, 4.6278, 4.5184, 4.4428, 4.3873, 4.3457, 4.3137, 4.2888/
      data (bla   (i),i=  73, 144)/
     1 4.2693, 4.2533, 4.2406, 4.2305, 4.2220, 4.2148, 4.2096, 4.2046,
     2 5.5632, 5.3964, 5.2889, 5.2160, 5.1644, 5.1273, 5.0995, 5.0787,
     3 5.0629, 5.0507, 5.0412, 5.0341, 5.0282, 5.0236, 5.0191, 5.0167,
     4 6.3129, 6.1450, 6.0377, 5.9674, 5.9194, 5.8859, 5.8620, 5.8445,
     5 5.8318, 5.8222, 5.8153, 5.8099, 5.8060, 5.8033, 5.8003, 5.7984,
     6 7.0466, 6.8745, 6.7673, 6.6995, 6.6548, 6.6248, 6.6040, 6.5897,
     7 6.5794, 6.5720, 6.5668, 6.5632, 6.5601, 6.5587, 6.5568, 6.5555,
     8 7.7675, 7.5890, 7.4822, 7.4171, 7.3759, 7.3492, 7.3315, 7.3197,
     9 7.3115, 7.3062, 7.3024, 7.2996, 7.2975, 7.2959, 7.2953, 7.2946/
      data (bla   (i),i= 145, 216)/
     1 8.4783, 8.2930, 8.1873, 8.1253, 8.0878, 8.0644, 8.0493, 8.0396,
     2 8.0334, 8.0293, 8.0266, 8.0244, 8.0238, 8.0223, 8.0216, 8.0216,
     3 9.1818, 8.9908, 8.8870, 8.8289, 8.7948, 8.7744, 8.7620, 8.7542,
     4 8.7494, 8.7465, 8.7443, 8.7434, 8.7424, 8.7417, 8.7415, 8.7411,
     5 9.8808, 9.6852, 9.5842, 9.5299, 9.4993, 9.4818, 9.4714, 9.4652,
     6 9.4614, 9.4594, 9.4580, 9.4571, 9.4566, 9.4566, 9.4551, 9.4558,
     710.5768,10.3780,10.2804,10.2299,10.2027,10.1876,10.1792,10.1745,
     810.1715,10.1701,10.1690,10.1682,10.1681,10.1676,10.1670,10.1676,
     911.2713,11.0707,10.9769,10.9304,10.9061,10.8934,10.8864,10.8828/
      data (bla   (i),i= 217, 224)/
     110.8804,10.8793,10.8789,10.8781,10.8784,10.8784,10.8786,10.8779/
c
c       brem: region b
c        electron energy=
c      0.10000e-02 0.20309e-02 0.41246e-02 0.83768e-02 0.17013e-01
c      0.34551e-01 0.70170e-01 0.14251     0.28943     0.58780
c       1.1938      2.4245      4.9239      10.000
c       log10 step=  0.3077
c
c      log10 of electron energy boundary
      data  eelb1l/-3.000000/
c    *     ,eelb2l/ 1.000000/
c
c
c            blb(iu,ie)=log(v/vmin)/(1.-u)
c            sqrt(u)=0.000 to 0.224 step= 0.0149
c            log10(e)= -3.0000 to   1.0000 step= 0.3077
c
      data (blb   (i),i=   1,  72)/
     1 1.5872, 1.5861, 1.5830, 1.5779, 1.5708, 1.5619, 1.5513, 1.5391,
     2 1.5255, 1.5105, 1.4943, 1.4771, 1.4590, 1.4399, 1.4201, 1.3996,
     3 2.7212, 2.7156, 2.7004, 2.6790, 2.6538, 2.6260, 2.5964, 2.5654,
     4 2.5332, 2.4999, 2.4658, 2.4310, 2.3954, 2.3592, 2.3225, 2.2853,
     5 3.5873, 3.5735, 3.5485, 3.5201, 3.4894, 3.4571, 3.4230, 3.3873,
     6 3.3502, 3.3117, 3.2720, 3.2310, 3.1890, 3.1460, 3.1020, 3.0570,
     7 4.3651, 4.3474, 4.3231, 4.2962, 4.2669, 4.2354, 4.2015, 4.1657,
     8 4.1276, 4.0877, 4.0458, 4.0022, 3.9569, 3.9099, 3.8617, 3.8120,
     9 5.1060, 5.0895, 5.0683, 5.0443, 5.0175, 4.9879, 4.9556, 4.9206/
      data (blb   (i),i=  73, 144)/
     1 4.8831, 4.8429, 4.8003, 4.7557, 4.7088, 4.6594, 4.6084, 4.5552,
     2 5.8301, 5.8161, 5.7981, 5.7767, 5.7523, 5.7247, 5.6939, 5.6602,
     3 5.6234, 5.5837, 5.5408, 5.4952, 5.4466, 5.3953, 5.3416, 5.2851,
     4 6.5462, 6.5348, 6.5192, 6.5001, 6.4776, 6.4516, 6.4223, 6.3895,
     5 6.3530, 6.3132, 6.2695, 6.2221, 6.1713, 6.1166, 6.0586, 5.9972,
     6 7.2584, 7.2491, 7.2355, 7.2180, 7.1971, 7.1722, 7.1436, 7.1108,
     7 7.0739, 7.0324, 6.9866, 6.9365, 6.8821, 6.8233, 6.7608, 6.6943,
     8 7.9687, 7.9610, 7.9488, 7.9328, 7.9126, 7.8882, 7.8592, 7.8254,
     9 7.7868, 7.7431, 7.6944, 7.6406, 7.5822, 7.5190, 7.4512, 7.3792/
      data (blb   (i),i= 145, 216)/
     1 8.6781, 8.6716, 8.6606, 8.6452, 8.6252, 8.6002, 8.5700, 8.5346,
     2 8.4938, 8.4471, 8.3950, 8.3372, 8.2739, 8.2055, 8.1322, 8.0544,
     3 9.3870, 9.3815, 9.3711, 9.3559, 9.3353, 9.3092, 9.2776, 9.2399,
     4 9.1962, 9.1462, 9.0900, 9.0277, 8.9593, 8.8855, 8.8065, 8.7227,
     510.0957,10.0908,10.0807,10.0651,10.0437,10.0163, 9.9826, 9.9423,
     6 9.8954, 9.8417, 9.7812, 9.7141, 9.6407, 9.5613, 9.4764, 9.3867,
     710.8043,10.7999,10.7898,10.7736,10.7510,10.7219,10.6859,10.6428,
     810.5925,10.5349,10.4698,10.3979,10.3190,10.2341,10.1436,10.0479,
     911.5129,11.5087,11.4983,11.4812,11.4574,11.4264,11.3881,11.3419/
      data (blb   (i),i= 217, 224)/
     111.2881,11.2263,11.1566,11.0797,10.9957,10.9053,10.8090,10.7077/
c
c       pair: total x-section
c        gamm energy=
c      0.20000e-02 0.36749e-02 0.67523e-02 0.12407e-01 0.22797e-01
c      0.41888e-01 0.76967e-01 0.14142     0.25985     0.47746
c      0.87731      1.6120      2.9619      5.4424      10.000
c       log10 step=  0.2642
c
c      log10 of gamma energy boundary
      data  etcpl1/-2.698970/
c    *     ,etcpl2/ 1.000000/
c
      data (tcpl  (i),i=   1,  15)/
     1 0.0104, 0.0592, 0.1480, 0.2456, 0.3446, 0.4409, 0.5270, 0.5948,
     2 0.6439, 0.6781, 0.7009, 0.7157, 0.7251, 0.7310, 0.7346/
c
c       pair: region a
c
c         energy of gamma=
c        0.200e-02   0.367e-02   0.675e-02   0.124e-01   0.228e-01
c        0.419e-01   0.770e-01   0.141       0.260       0.477
c        0.877        1.61        2.96        5.44        10.0
c         log10 step= 0.264212
c
c         log10 of eg boundary
      data  egla1l/-2.698970/
c    *     ,egla2l/ 1.000000/
c
c
c         pla(iu,ie)=(v-.5)/(1.-u)
c         u=0.050 to1.000   step= 0.0633
c            log10(e)= -2.6990 to   1.0000 step= 0.2642
c
      data (pla   (i),i=   1,  72)/
     1 0.2535, 0.2661, 0.2804, 0.2967, 0.3152, 0.3371, 0.3629, 0.3941,
     2 0.4329, 0.4821, 0.5476, 0.6402, 0.7832, 1.0419, 1.7088,-6.5930,
     3 0.2924, 0.2802, 0.2726, 0.2671, 0.2629, 0.2596, 0.2569, 0.2547,
     4 0.2529, 0.2515, 0.2503, 0.2496, 0.2488, 0.2487, 0.2484, 0.2480,
     5 0.3796, 0.3663, 0.3585, 0.3534, 0.3495, 0.3467, 0.3445, 0.3426,
     6 0.3413, 0.3404, 0.3394, 0.3388, 0.3383, 0.3382, 0.3378, 0.3377,
     7 0.4228, 0.4117, 0.4055, 0.4017, 0.3992, 0.3973, 0.3961, 0.3954,
     8 0.3948, 0.3946, 0.3942, 0.3942, 0.3941, 0.3942, 0.3940, 0.3940,
     9 0.4482, 0.4395, 0.4354, 0.4332, 0.4321, 0.4314, 0.4313, 0.4316/
      data (pla   (i),i=  73, 144)/
     1 0.4320, 0.4325, 0.4328, 0.4333, 0.4336, 0.4342, 0.4340, 0.4343,
     2 0.4641, 0.4581, 0.4556, 0.4547, 0.4546, 0.4551, 0.4564, 0.4573,
     3 0.4589, 0.4596, 0.4616, 0.4623, 0.4624, 0.4652, 0.4659, 0.4644,
     4 0.4750, 0.4713, 0.4707, 0.4716, 0.4731, 0.4748, 0.4773, 0.4794,
     5 0.4816, 0.4842, 0.4859, 0.4876, 0.4883, 0.4885, 0.4864, 0.4914,
     6 0.4832, 0.4820, 0.4835, 0.4861, 0.4894, 0.4928, 0.4963, 0.4998,
     7 0.5037, 0.5066, 0.5096, 0.5116, 0.5136, 0.5145, 0.5133, 0.5169,
     8 0.4892, 0.4907, 0.4941, 0.4983, 0.5029, 0.5075, 0.5121, 0.5166,
     9 0.5210, 0.5252, 0.5289, 0.5320, 0.5345, 0.5364, 0.5371, 0.5372/
      data (pla   (i),i= 145, 216)/
     1 0.4940, 0.4974, 0.5022, 0.5073, 0.5129, 0.5184, 0.5237, 0.5290,
     2 0.5337, 0.5387, 0.5429, 0.5465, 0.5493, 0.5513, 0.5525, 0.5528,
     3 0.4977, 0.5024, 0.5080, 0.5139, 0.5201, 0.5262, 0.5321, 0.5380,
     4 0.5433, 0.5482, 0.5527, 0.5566, 0.5601, 0.5624, 0.5636, 0.5641,
     5 0.5002, 0.5059, 0.5121, 0.5187, 0.5252, 0.5317, 0.5382, 0.5443,
     6 0.5499, 0.5552, 0.5599, 0.5641, 0.5674, 0.5699, 0.5716, 0.5719,
     7 0.5020, 0.5083, 0.5151, 0.5219, 0.5287, 0.5355, 0.5422, 0.5485,
     8 0.5545, 0.5599, 0.5647, 0.5691, 0.5724, 0.5749, 0.5766, 0.5772,
     9 0.5033, 0.5101, 0.5170, 0.5241, 0.5311, 0.5379, 0.5446, 0.5513/
      data (pla   (i),i= 217, 240)/
     1 0.5573, 0.5629, 0.5679, 0.5721, 0.5757, 0.5784, 0.5796, 0.5806,
     2 0.5042, 0.5111, 0.5182, 0.5254, 0.5325, 0.5395, 0.5464, 0.5530,
     3 0.5590, 0.5648, 0.5699, 0.5746, 0.5780, 0.5808, 0.5825, 0.5827/
c
c
c       pair: region b
c
c         energy of gamma=
c        0.200e-02   0.210e-02   0.245e-02   0.315e-02   0.448e-02
c        0.705e-02   0.123e-01   0.236e-01   0.503e-01   0.119
c        0.309       0.890        2.84        10.0
c         sqrt(log10) step= 0.147944
c
c         use 0 for e-side at interpolation
c         with sqrt(log10(e)-eglb1l)
      data  eglb1l/-2.698970/
c
c
c         plb(iu,ie)=v
c         sqrt(u)=0.000 to0.224   step= 0.0149
      data (plb   (i),i=   1,  72)/
     1 0.7445, 0.7444, 0.7444, 0.7443, 0.7442, 0.7441, 0.7440, 0.7437,
     2 0.7435, 0.7432, 0.7429, 0.7425, 0.7422, 0.7418, 0.7413, 0.7409,
     3 0.7571, 0.7570, 0.7570, 0.7570, 0.7569, 0.7569, 0.7567, 0.7566,
     4 0.7565, 0.7562, 0.7561, 0.7559, 0.7556, 0.7555, 0.7551, 0.7549,
     5 0.7911, 0.6187, 0.6185, 0.6184, 0.6182, 0.6179, 0.6175, 0.6171,
     6 0.6166, 0.6160, 0.6155, 0.6148, 0.6140, 0.6133, 0.6124, 0.6115,
     7 0.8377, 0.7636, 0.7632, 0.7624, 0.7615, 0.7602, 0.7588, 0.7571,
     8 0.7553, 0.7532, 0.7510, 0.7486, 0.7461, 0.7435, 0.7408, 0.7379,
     9 0.8859, 0.8579, 0.8566, 0.8547, 0.8522, 0.8495, 0.8464, 0.8432/
      data (plb   (i),i=  73, 144)/
     1 0.8398, 0.8363, 0.8326, 0.8289, 0.8251, 0.8212, 0.8172, 0.8132,
     2 0.9275, 0.9181, 0.9154, 0.9121, 0.9087, 0.9050, 0.9014, 0.8976,
     3 0.8938, 0.8898, 0.8857, 0.8816, 0.8775, 0.8732, 0.8688, 0.8644,
     4 0.9584, 0.9544, 0.9511, 0.9479, 0.9444, 0.9410, 0.9374, 0.9338,
     5 0.9300, 0.9262, 0.9222, 0.9181, 0.9140, 0.9099, 0.9055, 0.9011,
     6 0.9784, 0.9757, 0.9731, 0.9701, 0.9671, 0.9641, 0.9608, 0.9575,
     7 0.9540, 0.9505, 0.9468, 0.9430, 0.9392, 0.9352, 0.9310, 0.9268,
     8 0.9898, 0.9879, 0.9856, 0.9833, 0.9807, 0.9781, 0.9753, 0.9724,
     9 0.9693, 0.9662, 0.9629, 0.9595, 0.9559, 0.9522, 0.9484, 0.9445/
      data (plb   (i),i= 145, 216)/
     1 0.9957, 0.9942, 0.9925, 0.9907, 0.9886, 0.9864, 0.9841, 0.9817,
     2 0.9792, 0.9764, 0.9735, 0.9705, 0.9673, 0.9640, 0.9605, 0.9569,
     3 0.9983, 0.9973, 0.9961, 0.9948, 0.9932, 0.9915, 0.9896, 0.9876,
     4 0.9854, 0.9831, 0.9806, 0.9781, 0.9753, 0.9725, 0.9694, 0.9662,
     5 0.9994, 0.9988, 0.9979, 0.9969, 0.9957, 0.9944, 0.9929, 0.9912,
     6 0.9895, 0.9875, 0.9855, 0.9833, 0.9808, 0.9784, 0.9757, 0.9728,
     7 0.9998, 0.9994, 0.9988, 0.9980, 0.9971, 0.9961, 0.9949, 0.9935,
     8 0.9919, 0.9904, 0.9885, 0.9865, 0.9844, 0.9821, 0.9795, 0.9768,
     9 0.9999, 0.9996, 0.9993, 0.9987, 0.9979, 0.9971, 0.9960, 0.9948/
      data (plb   (i),i= 217, 224)/
     1 0.9934, 0.9918, 0.9901, 0.9883, 0.9862, 0.9840, 0.9816, 0.9790/
c
c    ---------------     $$$   landau correction region $$$     ----
c
      data deelh/ 0.333333/
      data deghl/ 0.144559/
c
c          energy of electron
c        10.00       21.54       46.42       100.0       215.4
c        464.2       1000.       2154.       4642.      0.1000e+05
c       0.2154e+05  0.4642e+05  0.1000e+06  0.2154e+06  0.4642e+06
c       0.1000e+07
c         log10 step= 0.333333
c
c         log10 of electron energy boundary
      data eeh1l/ 1.000000/
c    *     ,eeh2l/ 6.000000/
c
      data (tcbh  (i),i=   1,  16)/
     1 10.9592, 10.9433, 10.4752,  9.7384,  8.8594,  7.9112,  6.9368,
     2  5.9633,  5.0193,  4.1529,  3.3358,  2.6147,  2.0711,  1.5542,
     3  1.1463,  0.9467/
c
c          be1(iu,ie)= log(v/vmin)
c          from u=0.000 to 0.700 step=0.100
c          from log10(e)=  1.0000 to  6.0000 step  0.3333
c          dim. of u=  8 dim of e= 16
c
      data (   be1(i),i=   1,  54)/
     1  9.21034,  8.03680,  7.05197,  6.16630,  5.31780,  4.48444,
     2  3.65465,  2.84370,  9.97787,  8.80589,  7.82215,  6.93757,
     3  6.09019,  5.25449,  4.44143,  3.61934, 10.74540,  9.61972,
     4  8.66856,  7.81583,  6.99756,  6.20688,  5.42502,  4.60094,
     5 11.51292, 10.46109,  9.56170,  8.75732,  7.99573,  7.26284,
     6  6.51662,  5.70264, 12.28045, 11.31834, 10.48179,  9.73655,
     7  9.04517,  8.36606,  7.65693,  6.86178, 13.04798, 12.18471,
     8 11.41516, 10.74306, 10.11432,  9.48380,  8.81059,  8.03852,
     9 13.81551, 13.05607, 12.36354, 11.76055, 11.18546, 10.59710/
      data (   be1(i),i=  55, 108)/
     1  9.95673,  9.20871, 14.58304, 13.92806, 13.32111, 12.77593,
     2 12.24533, 11.69268, 11.08133, 10.35632, 15.35056, 14.80175,
     3 14.27337, 13.77762, 13.28304, 12.75949, 12.17226, 11.46684,
     4 16.11809, 15.66760, 15.20686, 14.74996, 14.28175, 13.77732,
     5 13.20331, 12.50342, 16.88562, 16.52531, 16.12524, 15.70485,
     6 15.26055, 14.77475, 14.21570, 13.52769, 17.65315, 17.36748,
     7 17.01999, 16.63026, 16.20653, 15.73563, 15.18840, 14.50961,
     8 18.42067, 18.18518, 17.86739, 17.48770, 17.06027, 16.57426,
     9 15.99567, 15.25515, 19.18820, 18.99937, 18.71616, 18.35684/
      data (   be1(i),i= 109, 128)/
     1 17.94144, 17.46306, 16.88971, 16.15022, 19.95573, 19.80145,
     2 19.54388, 19.20184, 18.79561, 18.32191, 17.75021, 17.00804,
     3 20.72327, 20.56775, 20.27406, 19.87041, 19.37880, 18.77802,
     4 17.98843, 16.77670/
c
c         be2(iu,ie)= (sqrt(v) -sqrtv)/(1.-u)
c          from sqrt(1-u)=0.000 to 0.548 step= 0.055
c          from log10(e)= 1.000000 to 6.000000 step  0.3333
c
      data (   be2(i),i=   1,  63)/
     1  0.0651,  0.0654,  0.0661,  0.0674,  0.0693,  0.0719,  0.0754,
     2  0.0800,  0.0860,  0.0940,  0.1048,  0.0764,  0.0767,  0.0775,
     3  0.0789,  0.0809,  0.0837,  0.0872,  0.0919,  0.0979,  0.1057,
     4  0.1160,  0.0950,  0.0953,  0.0964,  0.0981,  0.1006,  0.1038,
     5  0.1079,  0.1131,  0.1197,  0.1280,  0.1389,  0.1206,  0.1211,
     6  0.1226,  0.1249,  0.1280,  0.1320,  0.1370,  0.1431,  0.1506,
     7  0.1600,  0.1719,  0.1532,  0.1541,  0.1564,  0.1598,  0.1640,
     8  0.1690,  0.1751,  0.1823,  0.1910,  0.2016,  0.2148,  0.1934,
     9  0.1950,  0.1987,  0.2036,  0.2091,  0.2154,  0.2227,  0.2311/
      data (   be2(i),i=  64, 126)/
     1  0.2411,  0.2530,  0.2674,  0.2413,  0.2441,  0.2500,  0.2567,
     2  0.2639,  0.2716,  0.2802,  0.2899,  0.3011,  0.3142,  0.3297,
     3  0.2960,  0.3012,  0.3100,  0.3189,  0.3278,  0.3369,  0.3468,
     4  0.3577,  0.3700,  0.3841,  0.4005,  0.1285,  0.2763,  0.3543,
     5  0.3781,  0.3932,  0.4059,  0.4180,  0.4306,  0.4442,  0.4594,
     6  0.4766,  0.0459,  0.0576,  0.1560,  0.3285,  0.3984,  0.4376,
     7  0.4647,  0.4865,  0.5063,  0.5257,  0.5459,  0.0364,  0.0474,
     8  0.1244,  0.3468,  0.4430,  0.4951,  0.5294,  0.5558,  0.5785,
     9  0.5997,  0.6212,  0.0281,  0.0380,  0.1076,  0.3554,  0.4808/
      data (   be2(i),i= 127, 176)/
     1  0.5470,  0.5892,  0.6204,  0.6460,  0.6692,  0.6918,  0.0072,
     2  0.0081,  0.0115,  0.0225,  0.0659,  0.2770,  0.4241,  0.5200,
     3  0.5882,  0.6408,  0.6844,  0.0054,  0.0060,  0.0089,  0.0186,
     4  0.0605,  0.2708,  0.4390,  0.5477,  0.6242,  0.6823,  0.7296,
     5  0.0039,  0.0044,  0.0067,  0.0149,  0.0536,  0.2491,  0.4398,
     6  0.5624,  0.6479,  0.7119,  0.7633,  0.0010,  0.0011,  0.0013,
     7  0.0017,  0.0026,  0.0046,  0.0102,  0.0277,  0.1148,  0.3130,
     8  0.4632/
c
c
c         energy of gamma
c       0.5000e+05  0.6975e+05  0.9729e+05  0.1357e+06  0.1893e+06
c       0.2641e+06  0.3684e+06  0.5139e+06  0.7169e+06  0.1000e+07
c       log10 step= 0.144559
c
c       log10 of gamma energy boundary
      data egh1l/ 4.698970/
c    *     ,egh1l/ 6.000000/
c
      data (tcph  (i),i=   1,  10)/
     1  0.7461,  0.7205,  0.6872,  0.6473,  0.6021,  0.5535,  0.5035,
     2  0.4535,  0.4051,  0.3592/
c
c        table of v
c        from u= 0.0000 to  1.0000 step  0.1000
c        from log10(e)= 4.698970 to 6.000000 step  0.1446
c
      data (   vp (i),i=   1,  72)/
     1 1.0000, 0.9616, 0.9214, 0.8791, 0.8342, 0.7859, 0.7344, 0.6794,
     2 0.6215, 0.5614, 0.5000, 1.0000, 0.9629, 0.9244, 0.8833, 0.8391,
     3 0.7912, 0.7394, 0.6839, 0.6250, 0.5633, 0.5000, 1.0000, 0.9648,
     4 0.9280, 0.8882, 0.8448, 0.7972, 0.7454, 0.6891, 0.6287, 0.5652,
     5 0.5000, 1.0000, 0.9669, 0.9319, 0.8936, 0.8511, 0.8040, 0.7520,
     6 0.6949, 0.6331, 0.5676, 0.5000, 1.0000, 0.9693, 0.9367, 0.8993,
     7 0.8578, 0.8112, 0.7590, 0.7012, 0.6379, 0.5702, 0.5000, 1.0000,
     8 0.9718, 0.9407, 0.9052, 0.8647, 0.8186, 0.7664, 0.7078, 0.6430,
     9 0.5730, 0.5000, 1.0000, 0.9742, 0.9450, 0.9111, 0.8716, 0.8261/
      data (   vp (i),i=  73, 110)/
     1 0.7739, 0.7146, 0.6482, 0.5759, 0.5000, 1.0000, 0.9766, 0.9493,
     2 0.9169, 0.8783, 0.8335, 0.7813, 0.7213, 0.6534, 0.5788, 0.5000,
     3 1.0000, 0.9788, 0.9532, 0.9221, 0.8848, 0.8405, 0.7885, 0.7280,
     4 0.6587, 0.5817, 0.5000, 1.0000, 0.9809, 0.9569, 0.9271, 0.8908,
     5 0.8472, 0.7953, 0.7343, 0.6638, 0.5846, 0.5000/
c
c       total prob. equivalenced to common
c
      equivalence (tprob,tp)
c

c
c                         complete screening pair x-sxec.
c                         0.734 =(7/9-b)*rx0 =.773*rx0
      data rx0/0.951/, ctpc/.743/,  cep/5.e3/
c       rx0=x0(true)/x0(in nishimura text)
c       cep:  minimum energy for landau correction for pair.
c          default esbc espc
      data esbin/5./,  espin/50./
c
c
      if(ee .lt. eblmin) then
          t=1.e36
      else
          if(.not. usees) then
             esb=esbin
          else
             esb=min(escb, eblmax)
          endif
          if(ee .gt. esb) then
              screen=.false.
              if(lcorec .and. ee .gt. eeh1) then
                  if(ee .gt. eeh2) then
                       write(6,'('' ee > eeh2 in brmcst: ee='',g12.4)')
     *                 ee
                       stop
                  endif
                  landau=.true.
                  ale=log10(ee)
c                 tp=fintp3(tcbh, eeh1l, deelh, neeh, ale)*rx0
                  call kintp3(tcbh, 1, neeh, eeh1l, deelh, ale, tp)
                  tp=tp*rx0
              else
                  landau=.false.
c                     complete screening cross-section
                  vc=ec/ee
                  tp=(-1.3603*(log(vc)-vc)-vc*vc*.5-.8603 )*rx0
              endif
          else
              landau=.false.
              if(scorec) then
                  screen=.true.
                  ale=log10(ee)
c                 tp=fintp3(tcbl, etcbl1, debtcl, nbtcl,  ale)
                  call kintp3(tcbl, 1, nbtcl, etcbl1, debtcl,  ale, tp)
              else
                  screen=.false.
c                     complete screening cross-section
                  vc=ec/ee
                  tp=(-1.3603*(log(vc)-vc)-vc*vc*.5-.8603 )*rx0
              endif
          endif
c
          call rndc(u)
          t =-log(u)/tp
      endif
      return
c
c     ************
      entry brmcse(ee,ec,beg)
c     ************
c
      call rndc(u)
      if(screen) then
c           partial screening
         if(u .gt. uela1) then
c                  region a
c              beg=exp( tdint4(bla, nuela, neela, uela1, eela1l, duela,
c    *         deela, u,  ale)*(1.-u) ) *egmnl
               call k4ptdi(bla, nuela, neela, nuela, uela1, eela1l,
     *         duela, deela, u, ale, ans)
               beg=exp( ans*(1.-u))*egmnl
         else
c                  region b
               us=sqrt(u)
c              beg=exp( tdint4(blb, nuelb, neelb, uelb1, eelb1l,duelb,
c    *         deelb, us, ale)) * egmnl
               call k4ptdi(blb, nuelb, neelb, nuelb, uelb1, eelb1l,
     *         duelb, deelb, us, ale, ans)
               beg=exp(ans)*egmnl
         endif
      elseif(landau) then
         if(u .lt. ueh2) then
c              beg=exp( tdint4(be1, nueh1, neeh, ueh1, eeh1l, dueh1,
c    *         deelh, u,  ale)  ) * egmnh
               call k4ptdi(be1, nueh1, neeh, nueh1,  ueh1, eeh1l,
     *         dueh1, deelh, u,  ale, ans)
               beg=exp( ans ) *egmnh
         else
               us=sqrt(1.-u)
c              beg=   ( tdint4(be2, nueh2, neeh, ueh3, eeh1l, dueh2,
c    *         deelh, us,  ale)*(1.-u)+ sqrt(egmnh/ee) )**2 *ee
               call k4ptdi(be2, nueh2, neeh, nueh2,  ueh3, eeh1l,
     *         dueh2, deelh, us,  ale, ans)
               beg=  (ans*(1.-u) + sqrt(egmnh/ee) )**2*ee
         endif
      else
c               complete screening
          a=u*tp
          if(a .le. 1.) then
             v=exp(-a)
             if(a .gt. .1) then
                 v=((.06366*a-.1447407)*a+1.014176)*v
             endif
          else
             v=exp(-(a+0.8603)/1.3603)
             if(a .le. 6.) then
                 v=((((2.050445e-3*a-3.53209e-2)*a+.228937)*a-.684076)*a
     *           +1.841734)*v
             endif
          endif
          beg=ee*v
      endif
      return
c
c
c     ***********
      entry prccst(eg,t)
c     ***********
c
c
c
      if(eg .le. emass2) then
          t=1.e37
      elseif(eg .lt. eplmin .and. scorec) then
          tp=( (eg-emass2)/(eplmin-emass2) )**3 * tcpl(1)
          call rndc(u)
          t =-log(u)/tp
          landau=.false.
          screen=.true.
      else
          if(.not. usees) then
             esp=espin
          else
             esp=min(escp, eplmax)
          endif
          if(eg .gt. esp) then
              screen=.false.
              if(eg .gt. cep   .and. lcorec) then
                  landau=.true.
                  ale=log10(eg)
c                 tp=fintp3(tcph, egh1l, deghl, negh, ale)*rx0
                  call kintp3(tcph, 1, negh,  egh1l,  deghl,   ale, tp)
                  tp=tp*rx0
              else
                  landau=.false.
c                     complete screening cross-section
                  tp=ctpc
              endif
          else
              landau=.false.
              if(scorec) then
                  screen=.true.
                  ale=log10(eg)
c                 tp=fintp3(tcpl, etcpl1, deptcl, nptcl, ale)
                  call kintp3(tcpl, 1,nptcl,  etcpl1, deptcl,  ale, tp)
              else
                  screen=.false.
c                     complete screening cross-section
                  tp=ctpc
              endif
          endif
          call rndc(u)
          t =-log(u)/tp
      endif
      return
c
c
c     ***********
      entry prccse(eg,e1)
c     ***********
c
c
c
      call rndc(u)
      if(screen) then
c           partial screening
         if(u .ge. ugla1) then
c                   region a
c               e1=(tdint4(pla, nugla, negla, ugla1, egla1l, dugla,
c    *          degla, u,    ale) *(1.-u) + .5 )*eg
                call k4ptdi(pla, nugla, negla,nugla,  ugla1, egla1l,
     *          dugla, degla, u,   ale, ans)
                e1=(ans*(1.-u) + .5)*eg
         else
c                   region b
                us=sqrt(u)
                ex=sqrt(ale-eglb1l)
                call k4ptdi(plb, nuglb, neglb,nuglb,  uglb1, 0.d0,
     *          duglb, deglb, us,  ale, ans)
                e1=ans*eg
         endif
      elseif(landau) then
c        e1= tdint4(vp, nugh2, negh, ugh3, egh1l, dugh2,
c    *   deghl, u,  ale) * eg
         call k4ptdi(vp, nugh2, negh, nugh2, ugh3, egh1l,
     *   dugh2, deghl, u,  ale, ans)
         e1=ans*eg
      else
c                complete screening
         e1=(((.0441223*u-.173755)*u-.3708608)*u+1.)*eg
      endif
      return
c
c     ************
      entry emctcs(Knckon)
c     ************
c
c               cconst=for compton=3/8*thomson*n0*z/a*x0ing
c               to convert cross-section in compt into /(r.l).
      cconst=.502
      x0=1.786
      x0ing=8.05
      x0sq=3.19
      if(Knckon) then
         ecrit=11.e-3
      else
         ecrit=11.e-3
      endif
c         moller scat   .3*z/a * x0ing
      constm=1.00
      rho = 4.53
c
      zchrg=54.
      zchrg2 = 2919.
      amassn=130.0
      ionizP = 554.7d-9
      end



