c     ************************ for ar*********************************
c     *                                                              *
c     *  brmart:  samples path for brems                             *
c     *  brmare:  samples energy of brems gamma                      *
c     *  prcart:  samples path for pair creation                     *
c     *  prcare:  samples energy of pair electron (higher energy)    *
c     *  emctar:  set const in common for ar                         *
c     *                                                              *
c     *********************** tested 88.10.13 ********************k.k*
c
c      material   z     a     rho     t0 (g/cm2)  t0 (cm)    ec
c         ar      18   39.95  1.40    19.44      13.89     27.1  mev
c brems:
c        electron energy:      1mev to 10tev
c        brems gamma energy:   .1mev or more
c           if electron energy is < 1mev,  sampled path is set to be
c        very large one so that real brems may not take place before
c        the death by energy loss.
c pair:
c        gamma energy:         3mev to 10tev
c           if gamma energy is < 3mev, sampled path is set to be
c        very large one so that real pair creation may not take place
c        before compton or another process takes place.
c
c
c
c
c   /usage/          call brmart(ee,ec,t)
c                    call brmare(ee,ec,beg)
c
c                    call prcart(eg,t)
c                    call prcare(eg,e1)
c
c      ee:  incident electron energy
c      ec:  cut-off energy of brems gamma (used if complete screening
c           cross section is to be used).
c       t:  sampled path
c     beg:  sampled gamma energy
c      eg:  incident gamma energy
c      e1:  sampled electron energy (higher energy in pair)
c
c  *** note ***
c
c          before calling brmare, brmart must have been called.
c          //             prcare, prcart //
c
c          by the parameters in $elmag the user can control:
c
c        ee  -------------100gev------10tevif usees=t, escb instead 100
c     scorec=t       p.s    !
c     lcorec=t              !    l.c
c     scorec=f       c.s    !
c     lcorec=f              !    c.s
c
c        eg  --------------10gev--10tev    (if usees=t, escp instead 10)
c     scorec=t       p.s    ! c.s
c     lcorec=t              ! c.s
c     scorec=f       c.s    ! c.s
c     lcorec=f              !
c
c
c
c
      subroutine brmart(ee,ec,t)
       implicit none
c
c
#include  "Zelmag.h"
#include  "Zemdef.h"
c
      integer i
      logical screen,landau
      save screen, landau
c
c ------------------------- partical screening ----------------------
c           *** electron ***
c
c           ! egmin (gev)  for brems.
      data egmnl/.1e-3/
c
      parameter (eblmin=1.e-3, eblmax=100., nbtcl=16)
      dimension tcbl(nbtcl)
c
c             brem:   region a
c
      parameter (eela1=eblmin, eela2=eblmax,neela=16,
     * uela1=.05, uela2=1., nuela=16, duela=(uela2-uela1)/(nuela-1) )
      dimension bla(nuela *neela)
c
c             brem:  region b  (sqrt(u))
      parameter (eelb1=eblmin, eelb2=eblmax, neelb=neela,
     * uelb1=0.,  uelb2=.2236068, nuelb=16,
     * duelb=(uelb2-uelb1)/(nuelb-1) )
      dimension blb(nuelb* neelb)
c           ** gamma ***
c
c                 total cross-section
      parameter (eplmin=3.e-3, eplmax=100., nptcl=16)
      dimension tcpl(nptcl)
c
c          pair: region a
      parameter ( egla1=eplmin,  egla2=eplmax, negla=16,
     *   ugla1=.05, ugla2=1., nugla=16,dugla=(ugla2-ugla1)/(nugla-1) )
      dimension pla(nugla* negla)
c
c            pair: region b     sqrt(log10(e)) sqrt(u)
      parameter (eglb1=eplmin, eglb2=eplmax, neglb=11,
     *  uglb1=0., uglb2=.2236068, nuglb=16,
     *  duglb=(uglb2-uglb1)/(nuglb-1))
      dimension plb(nuglb* neglb)
c
c      -------------------- landau ------------------------------
c          **** electron ****
c
      data egmnh/1.e-3/
      parameter ( eeh1=5., eeh2= 10.e3, neeh=16,dueh1=.1,
     *  ueh1=0., ueh2=.7, nueh1=(ueh2-ueh1+.00001)/dueh1+1)
      dimension  tcbh(neeh)
      dimension  be1(nueh1* neeh)
c
c                         sqrt(1-.7)
      parameter (ueh3=0., ueh4=0.5477225,
     *nueh2=11, dvueh2=nueh2-1, dueh2=(ueh4 - ueh3)/dvueh2)
      dimension be2(nueh2*neeh)
c
c
c         *** gamma ****
c
      parameter ( egh1=5000., egh2=300.e3,negh=7, dugh2=.1,
     * ugh3=0., ugh4=1., nugh2=(ugh4-ugh3+.00001)/dugh2+1)
c
c
c     ---------------------------------------------------------
      data debtcl/ 0.333333/
      data deela/ 0.333333/
      data deelb/ 0.333333/
      data deptcl/ 0.301525/
      data degla/ 0.301525/
      data deglb/ 0.212671/
c        electron energy=
c      0.10000e-02 0.21544e-02 0.46416e-02 0.10000e-01 0.21544e-01
c      0.46416e-01 0.10000     0.21544     0.46416      1.0000
c       2.1544      4.6416      10.000      21.544      46.416
c       99.999
c       log10 step=  0.3333
c
c      log10 of electron energy boundary
      data  etcbl1/-3.000000/
c    *     ,etcbl2/ 2.000000/
c
      data (tcbl  (i),i=   1,  16)/
     1 1.2757, 2.5318, 3.7662, 4.9675, 6.1359, 7.2716, 8.3792, 9.4638,
     210.5312,11.5867,12.6351,13.6788,14.7199,15.7597,16.7988,17.8376/
c
c       brem: region a
c        electron energy=
c      0.10000e-02 0.21544e-02 0.46416e-02 0.10000e-01 0.21544e-01
c      0.46416e-01 0.10000     0.21544     0.46416      1.0000
c       2.1544      4.6416      10.000      21.544      46.416
c       99.999
c       log10 step=  0.3333
c
c      log10 of electron energy boundary
      data  eela1l/-3.000000/
c    *     ,eela2l/ 2.000000/
c
c
c            bla(iu,ie)=log(v/vmin)/(1.-u)
c            u=0.050 to 1.000 step= 0.0633
c            log10(e)= -3.0000 to   2.0000 step= 0.3333
c
      data (bla   (i),i=   1,  72)/
     1 1.4835, 1.3979, 1.3354, 1.2860, 1.2451, 1.2101, 1.1800, 1.1531,
     2 1.1293, 1.1075, 1.0883, 1.0698, 1.0534, 1.0384, 1.0239, 1.0106,
     3 2.4913, 2.3248, 2.2155, 2.1336, 2.0684, 2.0154, 1.9698, 1.9329,
     4 1.8985, 1.8682, 1.8438, 1.8217, 1.8025, 1.7851, 1.7699, 1.7557,
     5 3.3558, 3.1681, 3.0488, 2.9635, 2.8987, 2.8483, 2.8071, 2.7737,
     6 2.7439, 2.7186, 2.6962, 2.6769, 2.6596, 2.6448, 2.6312, 2.6198,
     7 4.2034, 4.0186, 3.9049, 3.8247, 3.7648, 3.7171, 3.6799, 3.6498,
     8 3.6254, 3.6054, 3.5887, 3.5749, 3.5628, 3.5532, 3.5444, 3.5374,
     9 5.0405, 4.8663, 4.7552, 4.6785, 4.6231, 4.5821, 4.5509, 4.5267/
      data (bla   (i),i=  73, 144)/
     1 4.5078, 4.4929, 4.4809, 4.4713, 4.4637, 4.4578, 4.4513, 4.4481,
     2 5.8650, 5.6937, 5.5847, 5.5119, 5.4613, 5.4253, 5.3989, 5.3796,
     3 5.3650, 5.3536, 5.3452, 5.3386, 5.3333, 5.3292, 5.3273, 5.3238,
     4 6.6711, 6.4988, 6.3909, 6.3216, 6.2752, 6.2434, 6.2210, 6.2051,
     5 6.1936, 6.1853, 6.1789, 6.1747, 6.1714, 6.1686, 6.1665, 6.1651,
     6 7.4610, 7.2842, 7.1769, 7.1107, 7.0682, 7.0401, 7.0211, 7.0081,
     7 6.9994, 6.9930, 6.9886, 6.9856, 6.9831, 6.9815, 6.9814, 6.9797,
     8 8.2375, 8.0544, 7.9482, 7.8851, 7.8465, 7.8218, 7.8061, 7.7957,
     9 7.7890, 7.7845, 7.7815, 7.7791, 7.7777, 7.7766, 7.7761, 7.7755/
      data (bla   (i),i= 145, 216)/
     1 9.0038, 8.8142, 8.7100, 8.6509, 8.6160, 8.5948, 8.5818, 8.5734,
     2 8.5683, 8.5652, 8.5629, 8.5613, 8.5607, 8.5602, 8.5598, 8.5593,
     3 9.7633, 9.5687, 9.4672, 9.4123, 9.3812, 9.3631, 9.3523, 9.3462,
     4 9.3421, 9.3398, 9.3382, 9.3376, 9.3367, 9.3360, 9.3359, 9.3361,
     510.5187,10.3203,10.2225,10.1716,10.1442,10.1290,10.1202,10.1153,
     610.1125,10.1108,10.1097,10.1092,10.1087,10.1088,10.1084,10.1084,
     711.2718,11.0713,10.9774,10.9309,10.9066,10.8940,10.8871,10.8832,
     810.8811,10.8798,10.8795,10.8788,10.8784,10.8784,10.8786,10.8783,
     912.0240,11.8226,11.7331,11.6906,11.6696,11.6588,11.6533,11.6504/
      data (bla   (i),i= 217, 256)/
     111.6488,11.6480,11.6479,11.6473,11.6472,11.6472,11.6482,11.6471,
     212.7760,12.5749,12.4899,12.4513,12.4331,12.4241,12.4197,12.4175,
     312.4165,12.4159,12.4157,12.4154,12.4151,12.4153,12.4157,12.4152,
     413.5283,13.3283,13.2480,13.2130,13.1970,13.1898,13.1862,13.1845,
     513.1838,13.1834,13.1832,13.1832,13.1830,13.1825,13.1861,13.1829/
c
c       brem: region b
c        electron energy=
c      0.10000e-02 0.21544e-02 0.46416e-02 0.10000e-01 0.21544e-01
c      0.46416e-01 0.10000     0.21544     0.46416      1.0000
c       2.1544      4.6416      10.000      21.544      46.416
c       99.999
c       log10 step=  0.3333
c
c      log10 of electron energy boundary
      data  eelb1l/-3.000000/
c    *     ,eelb2l/ 2.000000/
c
c
c            blb(iu,ie)=log(v/vmin)/(1.-u)
c            sqrt(u)=0.000 to 0.224 step= 0.0149
c            log10(e)= -3.0000 to   2.0000 step= 0.3333
c
      data (blb   (i),i=   1,  72)/
     1 1.5872, 1.5863, 1.5834, 1.5787, 1.5722, 1.5639, 1.5542, 1.5428,
     2 1.5300, 1.5159, 1.5006, 1.4841, 1.4668, 1.4484, 1.4293, 1.4093,
     3 2.7994, 2.7947, 2.7816, 2.7623, 2.7387, 2.7120, 2.6830, 2.6522,
     4 2.6200, 2.5865, 2.5519, 2.5163, 2.4801, 2.4430, 2.4051, 2.3668,
     5 3.7210, 3.7108, 3.6888, 3.6618, 3.6319, 3.5997, 3.5655, 3.5293,
     6 3.4914, 3.4520, 3.4111, 3.3688, 3.3254, 3.2807, 3.2349, 3.1881,
     7 4.5527, 4.5393, 4.5168, 4.4906, 4.4617, 4.4301, 4.3961, 4.3596,
     8 4.3207, 4.2797, 4.2366, 4.1913, 4.1443, 4.0955, 4.0451, 3.9932,
     9 5.3487, 5.3354, 5.3154, 5.2920, 5.2655, 5.2359, 5.2032, 5.1676/
      data (blb   (i),i=  73, 144)/
     1 5.1292, 5.0880, 5.0440, 4.9974, 4.9486, 4.8975, 4.8438, 4.7885,
     2 6.1292, 6.1175, 6.1003, 6.0794, 6.0552, 6.0274, 5.9963, 5.9618,
     3 5.9241, 5.8829, 5.8386, 5.7912, 5.7406, 5.6871, 5.6310, 5.5717,
     4 6.9026, 6.8928, 6.8779, 6.8592, 6.8367, 6.8104, 6.7804, 6.7468,
     5 6.7092, 6.6680, 6.6225, 6.5731, 6.5200, 6.4626, 6.4019, 6.3376,
     6 7.6729, 7.6647, 7.6517, 7.6344, 7.6133, 7.5880, 7.5585, 7.5247,
     7 7.4863, 7.4430, 7.3951, 7.3427, 7.2854, 7.2238, 7.1578, 7.0879,
     8 8.4417, 8.4348, 8.4231, 8.4069, 8.3863, 8.3613, 8.3312, 8.2960,
     9 8.2555, 8.2096, 8.1585, 8.1018, 8.0401, 7.9732, 7.9016, 7.8256/
      data (blb   (i),i= 145, 216)/
     1 9.2098, 9.2039, 9.1930, 9.1774, 9.1568, 9.1308, 9.0993, 9.0621,
     2 9.0190, 8.9697, 8.9145, 8.8533, 8.7862, 8.7137, 8.6360, 8.5536,
     3 9.9776, 9.9724, 9.9621, 9.9465, 9.9251, 9.8977, 9.8642, 9.8245,
     4 9.7781, 9.7248, 9.6651, 9.5987, 9.5262, 9.4477, 9.3639, 9.2752,
     510.7453,10.7407,10.7304,10.7141,10.6917,10.6627,10.6268,10.5840,
     610.5340,10.4766,10.4121,10.3405,10.2623,10.1780,10.0880, 9.9928,
     711.5129,11.5085,11.4981,11.4811,11.4571,11.4262,11.3878,11.3418,
     811.2881,11.2263,11.1568,11.0799,10.9960,10.9056,10.8095,10.7082,
     912.2804,12.2762,12.2654,12.2474,12.2220,12.1888,12.1478,12.0984/
      data (blb   (i),i= 217, 256)/
     112.0407,11.9745,11.9002,11.8178,11.7283,11.6321,11.5300,11.4228,
     213.0480,13.0439,13.0324,13.0133,12.9863,12.9510,12.9071,12.8543,
     312.7926,12.7219,12.6426,12.5550,12.4599,12.3581,12.2503,12.1372,
     413.8155,13.8113,13.7992,13.7789,13.7503,13.7127,13.6660,13.6098,
     513.5441,13.4690,13.3847,13.2919,13.1913,13.0840,12.9705,12.8519/
c
c       pair: total x-section
c        gamm energy=
c      0.30000e-02 0.60068e-02 0.12027e-01 0.24082e-01 0.48219e-01
c      0.96549e-01 0.19332     0.38708     0.77504      1.5518
c       3.1072      6.2215      12.457      24.943      49.943
c       100.00
c       log10 step=  0.3015
c
c      log10 of gamma energy boundary
      data  etcpl1/-2.522879/
c    *     ,etcpl2/ 2.000000/
c
      data (tcpl  (i),i=   1,  16)/
     1 0.0499, 0.1427, 0.2477, 0.3559, 0.4613, 0.5562, 0.6311, 0.6833,
     2 0.7176, 0.7391, 0.7521, 0.7597, 0.7641, 0.7666, 0.7680, 0.7688/
c
c       pair: region a
c
c         energy of gamma=
c        0.300e-02   0.601e-02   0.120e-01   0.241e-01   0.482e-01
c        0.965e-01   0.193       0.387       0.775        1.55
c         3.11        6.22        12.5        24.9        49.9
c         100.
c         log10 step= 0.301525
c
c         log10 of eg boundary
      data  egla1l/-2.522879/
c    *     ,egla2l/ 2.000000/
c
c
c         pla(iu,ie)=(v-.5)/(1.-u)
c         u=0.050 to1.000   step= 0.0633
c            log10(e)= -2.5229 to   2.0000 step= 0.3015
c
      data (pla   (i),i=   1,  72)/
     1 0.2874, 0.2737, 0.2656, 0.2597, 0.2553, 0.2518, 0.2490, 0.2468,
     2 0.2450, 0.2435, 0.2423, 0.2413, 0.2408, 0.2399, 0.2395, 0.2398,
     3 0.3818, 0.3685, 0.3608, 0.3556, 0.3517, 0.3489, 0.3466, 0.3448,
     4 0.3435, 0.3424, 0.3415, 0.3409, 0.3404, 0.3403, 0.3399, 0.3400,
     5 0.4277, 0.4169, 0.4110, 0.4073, 0.4049, 0.4033, 0.4020, 0.4013,
     6 0.4010, 0.4005, 0.4005, 0.4006, 0.4006, 0.4006, 0.4008, 0.4004,
     7 0.4533, 0.4453, 0.4415, 0.4395, 0.4385, 0.4381, 0.4381, 0.4387,
     8 0.4391, 0.4397, 0.4402, 0.4409, 0.4414, 0.4418, 0.4415, 0.4419,
     9 0.4688, 0.4634, 0.4614, 0.4609, 0.4613, 0.4619, 0.4632, 0.4642/
      data (pla   (i),i=  73, 144)/
     1 0.4653, 0.4668, 0.4681, 0.4686, 0.4702, 0.4700, 0.4674, 0.4719,
     2 0.4790, 0.4760, 0.4757, 0.4768, 0.4787, 0.4810, 0.4832, 0.4859,
     3 0.4881, 0.4903, 0.4922, 0.4951, 0.4963, 0.4975, 0.4982, 0.4977,
     4 0.4863, 0.4858, 0.4878, 0.4907, 0.4942, 0.4980, 0.5020, 0.5055,
     5 0.5096, 0.5130, 0.5159, 0.5184, 0.5210, 0.5227, 0.5239, 0.5232,
     6 0.4919, 0.4940, 0.4980, 0.5024, 0.5074, 0.5122, 0.5172, 0.5218,
     7 0.5266, 0.5307, 0.5346, 0.5380, 0.5407, 0.5423, 0.5435, 0.5436,
     8 0.4963, 0.5004, 0.5056, 0.5111, 0.5168, 0.5227, 0.5284, 0.5338,
     9 0.5388, 0.5439, 0.5480, 0.5517, 0.5548, 0.5570, 0.5587, 0.5586/
      data (pla   (i),i= 145, 216)/
     1 0.4995, 0.5049, 0.5108, 0.5171, 0.5235, 0.5298, 0.5360, 0.5418,
     2 0.5474, 0.5526, 0.5576, 0.5612, 0.5645, 0.5670, 0.5687, 0.5690,
     3 0.5017, 0.5079, 0.5144, 0.5211, 0.5279, 0.5346, 0.5411, 0.5473,
     4 0.5531, 0.5586, 0.5636, 0.5677, 0.5711, 0.5735, 0.5756, 0.5757,
     5 0.5032, 0.5098, 0.5167, 0.5238, 0.5307, 0.5376, 0.5442, 0.5508,
     6 0.5568, 0.5626, 0.5675, 0.5716, 0.5751, 0.5779, 0.5796, 0.5799,
     7 0.5042, 0.5111, 0.5182, 0.5253, 0.5324, 0.5393, 0.5462, 0.5528,
     8 0.5590, 0.5645, 0.5699, 0.5741, 0.5777, 0.5803, 0.5815, 0.5824,
     9 0.5048, 0.5119, 0.5191, 0.5262, 0.5334, 0.5405, 0.5475, 0.5540/
      data (pla   (i),i= 217, 256)/
     1 0.5602, 0.5658, 0.5711, 0.5756, 0.5790, 0.5818, 0.5835, 0.5839,
     2 0.5052, 0.5123, 0.5196, 0.5269, 0.5341, 0.5411, 0.5481, 0.5547,
     3 0.5610, 0.5668, 0.5719, 0.5765, 0.5800, 0.5828, 0.5845, 0.5848,
     4 0.5054, 0.5126, 0.5199, 0.5272, 0.5343, 0.5415, 0.5483, 0.5552,
     5 0.5613, 0.5671, 0.5722, 0.5765, 0.5803, 0.5828, 0.5845, 0.5853/
c
c
c       pair: region b
c
c         energy of gamma=
c        0.300e-02   0.333e-02   0.455e-02   0.766e-02   0.159e-01
c        0.405e-01   0.127       0.494        2.35        13.8
c         100.
c         sqrt(log10) step= 0.212671
c
c         use 0 for e-side at interpolation
c         with sqrt(log10(e)-eglb1l)
      data  eglb1l/-2.522879/
c
c
c         plb(iu,ie)=v
c         sqrt(u)=0.000 to0.224   step= 0.0149
      data (plb   (i),i=   1,  72)/
     1 0.8297, 0.8217, 0.8190, 0.8159, 0.8125, 0.8093, 0.8058, 0.8023,
     2 0.7989, 0.7953, 0.7917, 0.7880, 0.7844, 0.7806, 0.7768, 0.7730,
     3 0.8465, 0.8439, 0.8405, 0.8371, 0.8336, 0.8301, 0.8265, 0.8229,
     4 0.8191, 0.8154, 0.8117, 0.8079, 0.8040, 0.8001, 0.7961, 0.7922,
     5 0.8877, 0.8868, 0.8845, 0.8816, 0.8784, 0.8750, 0.8714, 0.8676,
     6 0.8638, 0.8600, 0.8560, 0.8520, 0.8479, 0.8437, 0.8396, 0.8353,
     7 0.9333, 0.9325, 0.9305, 0.9277, 0.9246, 0.9212, 0.9177, 0.9140,
     8 0.9103, 0.9064, 0.9024, 0.8983, 0.8942, 0.8900, 0.8856, 0.8812,
     9 0.9678, 0.9668, 0.9648, 0.9620, 0.9591, 0.9560, 0.9527, 0.9493/
      data (plb   (i),i=  73, 144)/
     1 0.9457, 0.9421, 0.9382, 0.9343, 0.9303, 0.9262, 0.9220, 0.9177,
     2 0.9874, 0.9864, 0.9844, 0.9820, 0.9795, 0.9767, 0.9739, 0.9709,
     3 0.9678, 0.9646, 0.9612, 0.9577, 0.9540, 0.9503, 0.9464, 0.9424,
     4 0.9960, 0.9950, 0.9934, 0.9916, 0.9896, 0.9876, 0.9853, 0.9829,
     5 0.9803, 0.9775, 0.9746, 0.9716, 0.9684, 0.9652, 0.9617, 0.9580,
     6 0.9990, 0.9983, 0.9972, 0.9960, 0.9945, 0.9931, 0.9912, 0.9894,
     7 0.9873, 0.9853, 0.9828, 0.9804, 0.9777, 0.9749, 0.9720, 0.9689,
     8 0.9998, 0.9994, 0.9987, 0.9979, 0.9969, 0.9958, 0.9945, 0.9930,
     9 0.9914, 0.9897, 0.9879, 0.9858, 0.9835, 0.9812, 0.9786, 0.9759/
      data (plb   (i),i= 145, 176)/
     1 1.0000, 0.9998, 0.9993, 0.9987, 0.9979, 0.9971, 0.9961, 0.9949,
     2 0.9936, 0.9920, 0.9903, 0.9884, 0.9864, 0.9840, 0.9817, 0.9790,
     3 1.0000, 0.9998, 0.9996, 0.9991, 0.9985, 0.9976, 0.9966, 0.9955,
     4 0.9942, 0.9927, 0.9911, 0.9893, 0.9872, 0.9850, 0.9827, 0.9802/
      data deelh/ 0.220069/
c     data deghl/ 0.296359/
c
c          energy of electron
c        5.000       8.299       13.78       22.87       37.95
c        63.00       104.6       173.6       288.1       478.2
c        793.7       1317.       2187.       3630.       6025.
c       0.1000e+05
c         log10 step= 0.220069
c
c         log10 of electron energy boundary
      data eeh1l/ 0.698970/
c    *     ,eeh2l/ 4.000000/
c
      data (tcbh  (i),i=   1,  16)/
     1 10.5210, 11.2080, 11.8077, 12.2005, 12.3409, 12.2385, 11.9461,
     2 11.5199, 11.0027, 10.4247,  9.8129,  9.1772,  8.5293,  7.8749,
     3  7.2190,  6.5663/
c
c          be1(iu,ie)= log(v/vmin)
c          from u=0.000 to 0.700 step=0.100
c          from log10(e)=  0.6990 to  4.0000 step  0.2201
c          dim. of u=  8 dim of e= 16
c
      data (   be1(i),i=   1,  54)/
     1  8.51719,  7.38696,  6.43260,  5.57676,  4.75902,  3.95724,
     2  3.16245,  2.37080,  9.02392,  7.82597,  6.82392,  5.92129,
     3  5.05528,  4.20394,  3.35876,  2.51619,  9.53065,  8.27439,
     4  7.23101,  6.28737,  5.37898,  4.48416,  3.59480,  2.70577,
     5 10.03737,  8.74331,  7.67299,  6.70240,  5.76611,  4.84270,
     6  3.92363,  3.00594, 10.54410,  9.23659,  8.15666,  7.17641,
     7  6.23013,  5.29649,  4.36462,  3.44750, 11.05083,  9.75311,
     8  8.68018,  7.70698,  6.76798,  5.84014,  4.92087,  4.00795,
     9 11.55755, 10.28794,  9.23506,  8.28193,  7.36372,  6.45429/
      data (   be1(i),i=  55, 108)/
     1  5.56398,  4.65841, 12.06428, 10.83591,  9.81234,  8.88840,
     2  7.99951,  7.12474,  6.26607,  5.37207, 12.57101, 11.39319,
     3 10.40534,  9.51671,  8.66228,  7.83134,  7.00522,  6.12667,
     4 13.07773, 11.95707, 11.00943, 10.16013,  9.34565,  8.55945,
     5  7.76576,  6.90550, 13.58446, 12.52510, 11.62043, 10.81087,
     6 10.04365,  9.30100,  8.53889,  7.69836, 14.09118, 13.09642,
     7 12.23698, 11.46855, 10.75121, 10.04819,  9.31604,  8.49593,
     8 14.59791, 13.66995, 12.85650, 12.13497, 11.46342, 10.79684,
     9 10.09278,  9.29296, 15.10464, 14.24520, 13.47833, 12.80667/
      data (   be1(i),i= 109, 128)/
     1 12.17644, 11.54292, 10.86489, 10.08479, 15.61137, 14.82162,
     2 14.10562, 13.48047, 12.88726, 12.28346, 11.62930, 10.86802,
     3 16.11809, 15.39805, 14.73667, 14.15342, 13.59305, 13.01577,
     4 12.38334, 11.63973/
c
c         be2(iu,ie)= (sqrt(v) -sqrtv)/(1.-u)
c          from sqrt(1-u)=0.000 to 0.548 step= 0.055
c          from log10(e)= 0.698970 to 4.000000 step  0.2201
c
      data (   be2(i),i=   1,  63)/
     1  0.0552,  0.0554,  0.0564,  0.0585,  0.0611,  0.0647,  0.0696,
     2  0.0758,  0.0836,  0.0938,  0.1071,  0.0465,  0.0468,  0.0476,
     3  0.0490,  0.0511,  0.0539,  0.0578,  0.0631,  0.0703,  0.0799,
     4  0.0922,  0.0429,  0.0431,  0.0438,  0.0449,  0.0466,  0.0489,
     5  0.0521,  0.0564,  0.0623,  0.0703,  0.0815,  0.0433,  0.0435,
     6  0.0441,  0.0451,  0.0466,  0.0487,  0.0515,  0.0553,  0.0604,
     7  0.0673,  0.0770,  0.0467,  0.0469,  0.0475,  0.0485,  0.0500,
     8  0.0520,  0.0548,  0.0584,  0.0632,  0.0698,  0.0788,  0.0527,
     9  0.0529,  0.0535,  0.0546,  0.0562,  0.0583,  0.0612,  0.0649/
      data (   be2(i),i=  64, 126)/
     1  0.0698,  0.0763,  0.0852,  0.0609,  0.0611,  0.0619,  0.0631,
     2  0.0649,  0.0673,  0.0704,  0.0744,  0.0796,  0.0864,  0.0956,
     3  0.0714,  0.0717,  0.0726,  0.0741,  0.0761,  0.0789,  0.0823,
     4  0.0868,  0.0924,  0.0997,  0.1094,  0.0842,  0.0846,  0.0857,
     5  0.0876,  0.0901,  0.0932,  0.0972,  0.1021,  0.1084,  0.1163,
     6  0.1267,  0.0994,  0.1000,  0.1016,  0.1039,  0.1069,  0.1106,
     7  0.1151,  0.1207,  0.1276,  0.1363,  0.1474,  0.1174,  0.1182,
     8  0.1204,  0.1233,  0.1270,  0.1313,  0.1365,  0.1428,  0.1504,
     9  0.1600,  0.1719,  0.1382,  0.1395,  0.1425,  0.1462,  0.1506/
      data (   be2(i),i= 127, 176)/
     1  0.1556,  0.1616,  0.1686,  0.1771,  0.1874,  0.2003,  0.1622,
     2  0.1641,  0.1681,  0.1729,  0.1781,  0.1839,  0.1906,  0.1984,
     3  0.2077,  0.2189,  0.2327,  0.1894,  0.1923,  0.1977,  0.2035,
     4  0.2096,  0.2163,  0.2238,  0.2324,  0.2425,  0.2546,  0.2692,
     5  0.2198,  0.2242,  0.2312,  0.2382,  0.2453,  0.2529,  0.2612,
     6  0.2707,  0.2816,  0.2944,  0.3097,  0.2534,  0.2598,  0.2687,
     7  0.2770,  0.2851,  0.2936,  0.3027,  0.3129,  0.3246,  0.3381,
     8  0.3541/
c
c
c         energy of gamma
c        5000.       9893.      0.1957e+05  0.3873e+05  0.7663e+05
c       0.1516e+06  0.3000e+06
c       log10 step= 0.296359
c
c       log10 of gamma energy boundary
c     data egh1l/ 3.698970/
c    *     ,egh1l/ 5.477121/
c
c
c       total prob. equivalenced to common
c
      equivalence (tprob,tp)
c

c
c                         complete screening pair x-sxec.
c                         0.773 =(7/9-b)*rx0 =.773*rx0
c      data rx0/1.000/, ctpc/.773/
      data rx0/1.000/, ctpc/.703/,  cep/10.e3/
c       rx0=x0(true)/x0(in nishimura text)
c       cep:  minimum energy for landau correction for pair.
c          default esbc espc
      data esbin/1./,  espin/10./
c
c
      if(ee .lt. eblmin) then
          t=1.e36
      else
          if(.not. usees) then
             esb=esbin
          else
             esb=min(escb, eblmax)
          endif
          if(ee .gt. esb) then
              screen=.false.
              if(lcorec .and. ee .gt. eeh1) then
                  if(ee .gt. eeh2) then
                       write(6,'('' ee > eeh2 in brmart: ee='',g12.4)')
     *                 ee
                       stop
                  endif
                  landau=.true.
                  ale=log10(ee)
c                 tp=fintp3(tcbh, eeh1l, deelh, neeh, ale)*rx0
                  call kintp3(tcbh, 1, neeh, eeh1l, deelh, ale, tp)
                  tp=tp*rx0
              else
                  landau=.false.
c                     complete screening cross-section
                  vc=ec/ee
                  tp=(-1.3603*(log(vc)-vc)-vc*vc*.5-.8603 )*rx0
              endif
          else
              landau=.false.
              if(scorec) then
                  screen=.true.
                  ale=log10(ee)
c                 tp=fintp3(tcbl, etcbl1, debtcl, nbtcl,  ale)
                  call kintp3(tcbl, 1, nbtcl, etcbl1, debtcl,  ale, tp)
              else
                  screen=.false.
c                     complete screening cross-section
                  vc=ec/ee
                  tp=(-1.3603*(log(vc)-vc)-vc*vc*.5-.8603 )*rx0
              endif
          endif
c
          call rndc(u)
          t =-log(u)/tp
      endif
      return
c
c     ************
      entry brmare(ee,ec,beg)
c     ************
c
      call rndc(u)
      if(screen) then
c           partial screening
         if(u .gt. uela1) then
c                  region a
c              beg=exp( tdint4(bla, nuela, neela, uela1, eela1l, duela,
c    *         deela, u,  ale)*(1.-u) ) *egmnl
               call k4ptdi(bla, nuela, neela, nuela, uela1, eela1l,
     *         duela, deela, u, ale, ans)
               beg=exp( ans*(1.-u))*egmnl
         else
c                  region b
               us=sqrt(u)
c              beg=exp( tdint4(blb, nuelb, neelb, uelb1, eelb1l,duelb,
c    *         deelb, us, ale)) * egmnl
               call k4ptdi(blb, nuelb, neelb, nuelb, uelb1, eelb1l,
     *         duelb, deelb, us, ale, ans)
               beg=exp(ans)*egmnl
         endif
      elseif(landau) then
         if(u .lt. ueh2) then
c              beg=exp( tdint4(be1, nueh1, neeh, ueh1, eeh1l, dueh1,
c    *         deelh, u,  ale)  ) * egmnh
               call k4ptdi(be1, nueh1, neeh, nueh1,  ueh1, eeh1l,
     *         dueh1, deelh, u,  ale, ans)
               beg=exp( ans ) *egmnh
         else
               us=sqrt(1.d0-u)
c              beg=   ( tdint4(be2, nueh2, neeh, ueh3, eeh1l, dueh2,
c    *         deelh, us,  ale)*(1.-u)+ sqrt(egmnh/ee) )**2 *ee
               call k4ptdi(be2, nueh2, neeh, nueh2,  ueh3, eeh1l,
     *         dueh2, deelh, us,  ale, ans)
               beg=  (ans*(1.-u) + sqrt(egmnh/ee) )**2*ee
         endif
      else
c               complete screening
          a=u*tp
          if(a .le. 1.) then
             v=exp(-a)
             if(a .gt. .1) then
                 v=((.06366*a-.1447407)*a+1.014176)*v
             endif
          else
             v=exp(-(a+0.8603)/1.3603)
             if(a .le. 6.) then
                 v=((((2.050445e-3*a-3.53209e-2)*a+.228937)*a-.684076)*a
     *           +1.841734)*v
             endif
          endif
          beg=ee*v
      endif
      return
c
c
c     ***********
      entry prcart(eg,t)
c     ***********
c
c
c
      if(eg .le. emass2) then
          t=1.e37
      elseif(eg .lt. eplmin .and. scorec) then
          tp=( (eg-emass2)/(eplmin-emass2) )**3 * tcpl(1)
          call rndc(u)
          t =-log(u)/tp
          landau=.false.
          screen=.true.
      else
          if(.not. usees) then
             esp=espin
          else
             esp=min(escp, eplmax)
          endif
          if(eg .gt. esp) then
              screen=.false.
              if(eg .gt. cep   .and. lcorec) then
                  landau=.true.
                  ale=log10(eg)
c                  tp=fintp3(tcph, egh1l, deghl, negh, ale)*rx0
                  call kintp3(tcph, 1, negh,  egh1l,  deghl,   ale, tp)
              else
                  landau=.false.
c                     complete screening cross-section
                  tp=ctpc
              endif
          else
              landau=.false.
              if(scorec) then
                  screen=.true.
                  ale=log10(eg)
c                 tp=fintp3(tcpl, etcpl1, deptcl, nptcl, ale)
                  call kintp3(tcpl, 1,nptcl,  etcpl1, deptcl,  ale, tp)
              else
                  screen=.false.
c                     complete screening cross-section
                  tp=ctpc
              endif
          endif
          call rndc(u)
          t =-log(u)/tp
      endif
      return
c
c
c     ***********
      entry prcare(eg, e1)
c     ***********
c
c
c
      call rndc(u)
      if(screen) then
c           partial screening
         if(u .ge. ugla1) then
c                   region a
c               e1=(tdint4(pla, nugla, negla, ugla1, egla1l, dugla,
c    *          degla, u,    ale) *(1.-u) + .5 )*eg
                call k4ptdi(pla, nugla, negla,nugla,  ugla1, egla1l,
     *          dugla, degla, u,   ale, ans)
                e1=(ans*(1.-u) + .5)*eg
         else
c                   region b
                us=sqrt(u)
                ex=sqrt(ale-eglb1l)
                call k4ptdi(plb, nuglb, neglb,nuglb,  uglb1, 0.d0,
     *          duglb, deglb, us,  ale, ans)
                e1=ans*eg
         endif
      elseif(landau) then
c         e1= tdint4(vp, nugh2, negh, ugh3, egh1l, dugh2,
c     *   deghl, u,  ale) * eg
         call k4ptdi(vp, nugh2, negh, nugh2, ugh3, egh1l,
     *    dugh2, deghl, u,  ale, ans)
         e1=ans*eg
      else
c                complete screening
         e1=(((.0441223*u-.173755)*u-.3708608)*u+1.)*eg
      endif
      return
c
c     ************
      entry emctar(Knckon)
c     ************
c
c               cconst=for compton=3/8*thomson*n0*z/a*x0ing
c               to convert cross-section in compt into /(r.l).
c      material   z     a     rho     t0 (g/cm2)  t0 (cm)    ec
c         ar      18   39.95  1.40    19.44      13.89     29.35 mev
      cconst=1.311
      x0=13.89
      x0ing=19.44
      x0sq=192.93
      if(Knckon) then
         ecrit=27.10
      else
         ecrit=33.40e-3
      endif
c         moller scat ( .3*z/a*x0ing )
      constm=2.628
c
      rho = 1.40
      zchrg=18.
      zchrg2 = 324.
      amassn=39.95
      end
