c     ************************ for al ********************************
c     *                                                              *
c     *  brmalt:  samples path for brems                             *
c     *  brmale:  samples energy of brems gamma                      *
c     *  prcalt:  samples path for pair creation                     *
c     *  prcale:  samples energy of pair electron (higher energy)    *
c     *  emctal:  set const in common area for fe                    *
c     *                                                              *
c     *********************** tested          ********************k.k*
c
c      material   z     a     rho     t0 (g/cm2)  t0 (cm)    ec
c         al      13    26.98 2.70    24.01       8.9        32.9
c
c brems:
c        electron energy:      1mev to
c        brems gamma energy:   .1mev or more
c           if electron energy is < 1mev,  sampled path is set to be
c        very large one so that real brems may not take place before
c        the death by energy loss.
c pair:
c        gamma energy:         2mev to
c           if gamma energy is < 3mev, sampled path is set to be
c        very large one so that real pair creation may not take place
c        before compton or another process takes place.
c
c
c
c
c   /usage/          call brmalt(ee,ec,t)
c                    call brmale(ee,ec,beg)
c
c                    call prcalt(eg,t)
c                    call prcale(eg,e1)
c
c      ee:  incident electron energy
c      ec:  cut-off energy of brems gamma (used if complete screening
c           cross section is to be used).
c       t:  sampled path
c     beg:  sampled gamma energy
c      eg:  incident gamma energy
c      e1:  sampled electron energy (higher energy in pair)
c
c  *** note ***
c
c          before calling brmale, brmalt must have been called.
c          //             prcale, prcalt //
c
c          by the parameters in $$elmag the user can control:
c
c        ee  --------------10gev------->  (if usees=t, escb instead 10
c     scorec=t       p.s    !
c     lcorec=t              !    l.c
c     scorec=f       c.s    !
c     lcorec=f              !    c.s
c
c        eg  -------------100gev-10tev---> (if usees=t, escp instead 100
c     scorec=t       p.s    ! c.s !
c     lcorec=t              ! c.s ! l.c
c     scorec=f       c.s    ! c.s !
c     lcorec=f              !     ! c.s
c
c
c
c
      subroutine brmalt(ee,ec,t)
       implicit none
c
c
#include  "Zelmag.h"
#include  "Zemdef.h"
c
c
c ------------------------- partical screening ----------------------
c           *** electron ***
c
      integer i
      logical screen,landau
      save screen, landau

c           ! egmin (gev)  for brems.
      data egmnl/.1e-3/
c
      parameter (eblmin=1.e-3, eblmax=10., nbtcl=14)
      dimension tcbl(nbtcl)
c
c             brem:   region a
c
      parameter (eela1=eblmin, eela2=eblmax,neela=14,
     * uela1=.05, uela2=1., nuela=16, duela=(uela2-uela1)/(nuela-1) )
      dimension bla(nuela* neela)
c
c             brem:  region b  (sqrt(u))
      parameter (eelb1=eblmin, eelb2=eblmax, neelb=neela,
     * uelb1=0.,  uelb2=.2236068, nuelb=16,
     * duelb=(uelb2-uelb1)/(nuelb-1) )
      dimension blb(nuelb* neelb)
c
c           ** gamma ***
c
c                 total cross-section
      parameter (eplmin=2.0e-3, eplmax= 10., nptcl=15)
      dimension tcpl(nptcl)
c
c          pair: region a
      parameter ( egla1=eplmin,  egla2=eplmax, negla=15,
     *   ugla1=.05, ugla2=1., nugla=16,dugla=(ugla2-ugla1)/(nugla-1) )
      dimension pla(nugla* negla)
c
c            pair: region b     sqrt(log10(e)) sqrt(u)
      parameter (eglb1=eplmin, eglb2=eplmax, neglb=14,
     *  uglb1=0., uglb2=.2236068, nuglb=16,
     *  duglb=(uglb2-uglb1)/(nuglb-1))
      dimension plb(nuglb* neglb)
c
c -------------------------------------------------------------------
      data debtcl/ 0.307692/
      data deela/ 0.307692/
      data deelb/ 0.307692/
      data deptcl/ 0.264212/
      data degla/ 0.264212/
      data deglb/ 0.147944/



c        electron energy=
c      0.10000e-02 0.20309e-02 0.41246e-02 0.83768e-02 0.17013e-01
c      0.34551e-01 0.70170e-01 0.14251     0.28943     0.58780
c       1.1938      2.4245      4.9239      10.000
c       log10 step=  0.3077
c
c      log10 of electron energy boundary
      data  etcbl1/-3.000000/
c    *     ,etcbl2/ 1.000000/
c
      data (tcbl  (i),i=   1,  14)/
     1 1.1888, 2.3286, 3.4887, 4.6317, 5.7433, 6.8203, 7.8669, 8.8871,
     2 9.8873,10.8730,11.8487,12.8183,13.7837,14.7468/
c
c       brem: region a
c        electron energy=
c      0.10000e-02 0.20309e-02 0.41246e-02 0.83768e-02 0.17013e-01
c      0.34551e-01 0.70170e-01 0.14251     0.28943     0.58780
c       1.1938      2.4245      4.9239      10.000
c       log10 step=  0.3077
c
c      log10 of electron energy boundary
      data  eela1l/-3.000000/
c    *     ,eela2l/ 1.000000/
c
c
c            bla(iu,ie)=alog(v/vmin)/(1.-u)
c            u=0.050 to 1.000 step= 0.0633
c            log10(e)= -3.0000 to   1.0000 step= 0.3077
c
      data (bla   (i),i=   1,  72)/
     1 1.4837, 1.3980, 1.3354, 1.2858, 1.2448, 1.2098, 1.1793, 1.1523,
     2 1.1283, 1.1067, 1.0873, 1.0691, 1.0524, 1.0368, 1.0221, 1.0090,
     3 2.4224, 2.2579, 2.1497, 2.0685, 2.0037, 1.9499, 1.9050, 1.8652,
     4 1.8332, 1.8024, 1.7744, 1.7485, 1.7292, 1.7115, 1.6961, 1.6804,
     5 3.2214, 3.0328, 2.9115, 2.8240, 2.7558, 2.7050, 2.6617, 2.6277,
     6 2.5973, 2.5712, 2.5480, 2.5274, 2.5097, 2.4932, 2.4790, 2.4662,
     7 4.0041, 3.8139, 3.6954, 3.6145, 3.5525, 3.5041, 3.4649, 3.4328,
     8 3.4067, 3.3846, 3.3665, 3.3507, 3.3379, 3.3271, 3.3171, 3.3084,
     9 4.7782, 4.5980, 4.4854, 4.4068, 4.3497, 4.3061, 4.2727, 4.2466/
      data (bla   (i),i=  73, 144)/
     1 4.2259, 4.2094, 4.1959, 4.1850, 4.1760, 4.1683, 4.1622, 4.1576,
     2 5.5437, 5.3703, 5.2596, 5.1853, 5.1327, 5.0947, 5.0664, 5.0452,
     3 5.0289, 5.0165, 5.0067, 4.9989, 4.9927, 4.9884, 4.9838, 4.9812,
     4 6.2962, 6.1236, 6.0148, 5.9442, 5.8960, 5.8622, 5.8381, 5.8205,
     5 5.8075, 5.7980, 5.7910, 5.7852, 5.7813, 5.7781, 5.7758, 5.7738,
     6 7.0339, 6.8588, 6.7512, 6.6834, 6.6387, 6.6087, 6.5879, 6.5733,
     7 6.5632, 6.5558, 6.5507, 6.5470, 6.5437, 6.5424, 6.5409, 6.5392,
     8 7.7585, 7.5789, 7.4720, 7.4069, 7.3658, 7.3392, 7.3214, 7.3096,
     9 7.3015, 7.2958, 7.2920, 7.2893, 7.2875, 7.2862, 7.2859, 7.2846/
      data (bla   (i),i= 145, 216)/
     1 8.4725, 8.2872, 8.1815, 8.1197, 8.0822, 8.0586, 8.0437, 8.0340,
     2 8.0280, 8.0237, 8.0210, 8.0194, 8.0182, 8.0173, 8.0166, 8.0160,
     3 9.1785, 8.9877, 8.8840, 8.8258, 8.7919, 8.7713, 8.7591, 8.7513,
     4 8.7463, 8.7432, 8.7415, 8.7403, 8.7395, 8.7389, 8.7390, 8.7381,
     5 9.8792, 9.6839, 9.5830, 9.5287, 9.4981, 9.4805, 9.4703, 9.4641,
     6 9.4606, 9.4582, 9.4566, 9.4561, 9.4556, 9.4549, 9.4551, 9.4547,
     710.5765,10.3779,10.2804,10.2299,10.2027,10.1876,10.1792,10.1742,
     810.1715,10.1698,10.1690,10.1682,10.1678,10.1676,10.1670,10.1675,
     911.2718,11.0713,10.9774,10.9309,10.9066,10.8940,10.8871,10.8832/
      data (bla   (i),i= 217, 224)/
     110.8811,10.8798,10.8795,10.8788,10.8784,10.8784,10.8786,10.8783/
c
c       brem: region b
c        electron energy=
c      0.10000e-02 0.20309e-02 0.41246e-02 0.83768e-02 0.17013e-01
c      0.34551e-01 0.70170e-01 0.14251     0.28943     0.58780
c       1.1938      2.4245      4.9239      10.000
c       log10 step=  0.3077
c
c      log10 of electron energy boundary
      data  eelb1l/-3.000000/
c    *     ,eelb2l/ 1.000000/
c
c
c            blb(iu,ie)=alog(v/vmin)/(1.-u)
c            sqrt(u)=0.000 to 0.224 step= 0.0149
c            log10(e)= -3.0000 to   1.0000 step= 0.3077
c
      data (blb   (i),i=   1,  72)/
     1 1.5872, 1.5863, 1.5834, 1.5787, 1.5722, 1.5641, 1.5542, 1.5429,
     2 1.5301, 1.5160, 1.5007, 1.4844, 1.4670, 1.4487, 1.4294, 1.4095,
     3 2.7212, 2.7169, 2.7050, 2.6868, 2.6644, 2.6387, 2.6106, 2.5807,
     4 2.5493, 2.5165, 2.4826, 2.4479, 2.4122, 2.3760, 2.3389, 2.3013,
     5 3.5873, 3.5779, 3.5568, 3.5301, 3.5004, 3.4681, 3.4340, 3.3980,
     6 3.3603, 3.3211, 3.2806, 3.2386, 3.1957, 3.1515, 3.1065, 3.0604,
     7 4.3651, 4.3522, 4.3291, 4.3024, 4.2727, 4.2405, 4.2059, 4.1689,
     8 4.1299, 4.0886, 4.0453, 4.0003, 3.9534, 3.9050, 3.8551, 3.8039,
     9 5.1060, 5.0926, 5.0714, 5.0469, 5.0194, 4.9887, 4.9553, 4.9190/
      data (blb   (i),i=  73, 144)/
     1 4.8799, 4.8383, 4.7940, 4.7472, 4.6982, 4.6472, 4.5943, 4.5393,
     2 5.8301, 5.8177, 5.7993, 5.7772, 5.7519, 5.7230, 5.6910, 5.6557,
     3 5.6171, 5.5755, 5.5310, 5.4834, 5.4331, 5.3800, 5.3245, 5.2666,
     4 6.5462, 6.5354, 6.5194, 6.4995, 6.4760, 6.4488, 6.4178, 6.3834,
     5 6.3456, 6.3038, 6.2588, 6.2100, 6.1580, 6.1024, 6.0434, 5.9814,
     6 7.2584, 7.2493, 7.2352, 7.2169, 7.1948, 7.1688, 7.1388, 7.1048,
     7 7.0668, 7.0244, 6.9779, 6.9269, 6.8715, 6.8121, 6.7490, 6.6822,
     8 7.9687, 7.9610, 7.9483, 7.9314, 7.9103, 7.8848, 7.8551, 7.8206,
     9 7.7813, 7.7370, 7.6878, 7.6337, 7.5745, 7.5108, 7.4427, 7.3705/
      data (blb   (i),i= 145, 216)/
     1 8.6781, 8.6714, 8.6598, 8.6438, 8.6231, 8.5977, 8.5670, 8.5312,
     2 8.4898, 8.4429, 8.3903, 8.3323, 8.2688, 8.2002, 8.1267, 8.0489,
     3 9.3870, 9.3812, 9.3704, 9.3547, 9.3339, 9.3075, 9.2756, 9.2376,
     4 9.1937, 9.1434, 9.0872, 9.0249, 8.9565, 8.8826, 8.8035, 8.7196,
     510.0957,10.0907,10.0802,10.0643,10.0428,10.0152, 9.9814, 9.9410,
     6 9.8941, 9.8402, 9.7797, 9.7125, 9.6391, 9.5597, 9.4750, 9.3852,
     710.8043,10.7996,10.7894,10.7730,10.7504,10.7212,10.6852,10.6420,
     810.5918,10.5341,10.4691,10.3973,10.3186,10.2338,10.1432,10.0477,
     911.5129,11.5085,11.4980,11.4810,11.4571,11.4260,11.3876,11.3416/
      data (blb   (i),i= 217, 224)/
     111.2879,11.2261,11.1568,11.0799,10.9959,10.9056,10.8095,10.7082/
c
c       pair: total x-section
c        gamm energy=
c      0.20000e-02 0.36749e-02 0.67523e-02 0.12407e-01 0.22797e-01
c      0.41888e-01 0.76967e-01 0.14142     0.25985     0.47746
c      0.87731      1.6120      2.9619      5.4424      10.000
c       log10 step=  0.2642
c
c      log10 of gamma energy boundary
      data  etcpl1/-2.698970/
c    *     ,etcpl2/ 1.000000/
c
      data (tcpl  (i),i=   1,  15)/
     1 0.0077, 0.0746, 0.1576, 0.2486, 0.3421, 0.4332, 0.5197, 0.5949,
     2 0.6523, 0.6933, 0.7214, 0.7401, 0.7521, 0.7597, 0.7645/
c
c       pair: region a
c
c         energy of gamma=
c        0.200e-02   0.367e-02   0.675e-02   0.124e-01   0.228e-01
c        0.419e-01   0.770e-01   0.141       0.260       0.477
c        0.877        1.61        2.96        5.44        10.0
c         log10 step= 0.264212
c
c         log10 of eg boundary
      data  egla1l/-2.698970/
c    *     ,egla2l/ 1.000000/
c
c
c         pla(iu,ie)=(v-.5)/(1.-u)
c         u=0.050 to1.000   step= 0.0633
c            log10(e)= -2.6990 to   1.0000 step= 0.2642
c
      data (pla   (i),i=   1,  72)/
     1 0.1279, 0.1250, 0.1226, 0.1208, 0.1192, 0.1180, 0.1168, 0.1159,
     2 0.1151, 0.1144, 0.1139, 0.1135, 0.1133, 0.1129, 0.1126, 0.1128,
     3 0.3253, 0.3112, 0.3028, 0.2969, 0.2925, 0.2891, 0.2864, 0.2841,
     4 0.2824, 0.2809, 0.2798, 0.2788, 0.2780, 0.2779, 0.2776, 0.2773,
     5 0.3923, 0.3794, 0.3720, 0.3670, 0.3635, 0.3608, 0.3587, 0.3571,
     6 0.3560, 0.3551, 0.3541, 0.3535, 0.3530, 0.3529, 0.3525, 0.3528,
     7 0.4295, 0.4189, 0.4130, 0.4094, 0.4070, 0.4055, 0.4043, 0.4036,
     8 0.4031, 0.4031, 0.4027, 0.4030, 0.4030, 0.4030, 0.4028, 0.4028,
     9 0.4520, 0.4436, 0.4395, 0.4373, 0.4362, 0.4359, 0.4358, 0.4360/
      data (pla   (i),i=  73, 144)/
     1 0.4365, 0.4371, 0.4376, 0.4379, 0.4385, 0.4388, 0.4386, 0.4390,
     2 0.4664, 0.4604, 0.4580, 0.4572, 0.4574, 0.4580, 0.4591, 0.4603,
     3 0.4614, 0.4627, 0.4639, 0.4647, 0.4659, 0.4666, 0.4668, 0.4669,
     4 0.4760, 0.4721, 0.4713, 0.4717, 0.4729, 0.4746, 0.4766, 0.4787,
     5 0.4810, 0.4829, 0.4844, 0.4871, 0.4880, 0.4890, 0.4892, 0.4887,
     6 0.4832, 0.4812, 0.4820, 0.4839, 0.4865, 0.4894, 0.4923, 0.4952,
     7 0.4987, 0.5012, 0.5038, 0.5059, 0.5069, 0.5097, 0.5104, 0.5105,
     8 0.4886, 0.4891, 0.4916, 0.4951, 0.4992, 0.5033, 0.5074, 0.5118,
     9 0.5158, 0.5192, 0.5224, 0.5253, 0.5272, 0.5296, 0.5303, 0.5309/
      data (pla   (i),i= 145, 216)/
     1 0.4931, 0.4956, 0.4998, 0.5045, 0.5096, 0.5148, 0.5198, 0.5247,
     2 0.5293, 0.5339, 0.5376, 0.5407, 0.5432, 0.5450, 0.5448, 0.5473,
     3 0.4966, 0.5008, 0.5061, 0.5117, 0.5174, 0.5234, 0.5291, 0.5346,
     4 0.5397, 0.5447, 0.5489, 0.5528, 0.5559, 0.5581, 0.5597, 0.5596,
     5 0.4995, 0.5046, 0.5107, 0.5169, 0.5231, 0.5296, 0.5356, 0.5416,
     6 0.5472, 0.5523, 0.5569, 0.5612, 0.5642, 0.5665, 0.5677, 0.5685,
     7 0.5014, 0.5074, 0.5139, 0.5206, 0.5273, 0.5338, 0.5402, 0.5466,
     8 0.5523, 0.5580, 0.5628, 0.5667, 0.5702, 0.5725, 0.5746, 0.5747,
     9 0.5029, 0.5094, 0.5162, 0.5231, 0.5300, 0.5368, 0.5435, 0.5498/
      data (pla   (i),i= 217, 240)/
     1 0.5560, 0.5616, 0.5664, 0.5706, 0.5741, 0.5769, 0.5786, 0.5788,
     2 0.5038, 0.5106, 0.5176, 0.5248, 0.5318, 0.5388, 0.5455, 0.5520,
     3 0.5582, 0.5639, 0.5687, 0.5731, 0.5767, 0.5794, 0.5806, 0.5815/
c
c
c       pair: region b
c
c         energy of gamma=
c        0.200e-02   0.210e-02   0.245e-02   0.315e-02   0.448e-02
c        0.705e-02   0.123e-01   0.236e-01   0.503e-01   0.119
c        0.309       0.890        2.84        10.0
c         sqrt(log10) step= 0.147944
c
c         use 0 for e-side at interpolation
c         with sqrt(log10(e)-eglb1l)
      data  eglb1l/-2.698970/
c
c
c         plb(iu,ie)=v
c         sqrt(u)=0.000 to0.224   step= 0.0149
      data (plb   (i),i=   1,  72)/
     1 0.7445, 0.6307, 0.6305, 0.6303, 0.6301, 0.6296, 0.6292, 0.6286,
     2 0.6280, 0.6273, 0.6265, 0.6257, 0.6247, 0.6236, 0.6225, 0.6215,
     3 0.7571, 0.6734, 0.6733, 0.6729, 0.6723, 0.6716, 0.6709, 0.6699,
     4 0.6689, 0.6676, 0.6664, 0.6650, 0.6635, 0.6619, 0.6602, 0.6585,
     5 0.7911, 0.7585, 0.7578, 0.7565, 0.7548, 0.7528, 0.7507, 0.7483,
     6 0.7457, 0.7430, 0.7402, 0.7373, 0.7344, 0.7314, 0.7282, 0.7251,
     7 0.8377, 0.8351, 0.8318, 0.8284, 0.8249, 0.8214, 0.8178, 0.8143,
     8 0.8107, 0.8070, 0.8032, 0.7995, 0.7957, 0.7919, 0.7880, 0.7841,
     9 0.8859, 0.8851, 0.8831, 0.8803, 0.8772, 0.8738, 0.8702, 0.8667/
      data (plb   (i),i=  73, 144)/
     1 0.8629, 0.8590, 0.8551, 0.8511, 0.8471, 0.8429, 0.8387, 0.8344,
     2 0.9275, 0.9267, 0.9249, 0.9222, 0.9191, 0.9159, 0.9123, 0.9087,
     3 0.9049, 0.9011, 0.8971, 0.8930, 0.8888, 0.8847, 0.8803, 0.8759,
     4 0.9584, 0.9575, 0.9555, 0.9528, 0.9498, 0.9467, 0.9432, 0.9397,
     5 0.9360, 0.9323, 0.9284, 0.9245, 0.9204, 0.9162, 0.9120, 0.9076,
     6 0.9784, 0.9774, 0.9754, 0.9728, 0.9700, 0.9670, 0.9640, 0.9607,
     7 0.9573, 0.9538, 0.9502, 0.9464, 0.9426, 0.9386, 0.9345, 0.9303,
     8 0.9898, 0.9888, 0.9869, 0.9846, 0.9823, 0.9796, 0.9769, 0.9740,
     9 0.9710, 0.9679, 0.9646, 0.9612, 0.9576, 0.9539, 0.9501, 0.9461/
      data (plb   (i),i= 145, 216)/
     1 0.9957, 0.9947, 0.9931, 0.9913, 0.9892, 0.9870, 0.9847, 0.9823,
     2 0.9797, 0.9769, 0.9740, 0.9709, 0.9677, 0.9643, 0.9609, 0.9571,
     3 0.9983, 0.9976, 0.9963, 0.9949, 0.9933, 0.9916, 0.9896, 0.9876,
     4 0.9854, 0.9830, 0.9804, 0.9777, 0.9749, 0.9719, 0.9688, 0.9654,
     5 0.9994, 0.9989, 0.9979, 0.9969, 0.9957, 0.9942, 0.9928, 0.9911,
     6 0.9891, 0.9872, 0.9850, 0.9827, 0.9802, 0.9777, 0.9749, 0.9719,
     7 0.9998, 0.9994, 0.9988, 0.9980, 0.9971, 0.9960, 0.9946, 0.9933,
     8 0.9917, 0.9900, 0.9880, 0.9861, 0.9839, 0.9815, 0.9789, 0.9762,
     9 0.9999, 0.9996, 0.9993, 0.9987, 0.9978, 0.9970, 0.9959, 0.9946/
      data (plb   (i),i= 217, 224)/
     1 0.9932, 0.9917, 0.9899, 0.9880, 0.9860, 0.9837, 0.9812, 0.9786/
c      -------------------- landau ------------------------------
c          **** electron ****
c
      data egmnh/1.e-3/
      parameter ( eeh1=5.e1, eeh2= 1.e6,  neeh=16,dueh1=.1,
     *  ueh1=0., ueh2=.7, nueh1=(ueh2-ueh1+.00001)/dueh1+1)
      dimension  tcbh(neeh)
      dimension  be1(nueh1* neeh)
c
c                         sqrt(1-.7)
      parameter (ueh3=0., ueh4=0.5477225,
     *nueh2=11, dvueh2=nueh2-1, dueh2=(ueh4 - ueh3)/dvueh2)
      dimension be2(nueh2*neeh)
c
c
c         *** gamma ****
c
      parameter ( egh1=5.e4, egh2= 1.e6, negh=10,dugh2=.1,
     * ugh3=0., ugh4=1., nugh2=(ugh4-ugh3+.00001)/dugh2+1)
      dimension tcph(negh)
      dimension vp(nugh2* negh)
c
c
c     ---------------------------------------------------------
      data deelh/ 0.286735/
      data deghl/ 0.144559/
c
c          energy of electron
c        50.00       96.76       187.3       362.4       701.3
c        1357.       2627.       5083.       9837.      0.1904e+05
c       0.3684e+05  0.7129e+05  0.1380e+06  0.2670e+06  0.5167e+06
c       0.1000e+07
c         log10 step= 0.286735
c
c         log10 of electron energy boundary
      data eeh1l/ 1.698970/
c    *     ,eeh2l/ 6.000000/
c
      data (tcbh  (i),i=   1,  16)/
     1 11.9269, 11.5171, 10.9049, 10.1709,  9.3710,  8.5370,  7.6880,
     2  6.8381,  5.9963,  5.1820,  4.4029,  3.6750,  3.0114,  2.4498,
     3  1.9393,  1.5118/
c
c          be1(iu,ie)= alog(v/vmin)
c          from u=0.000 to 0.700 step=0.100
c          from log10(e)=  1.6990 to  6.0000 step  0.2867
c          dim. of u=  8 dim of e= 16
c
      data (   be1(i),i=   1,  54)/
     1 10.81978,  9.55201,  8.50045,  7.54864,  6.63179,  5.72588,
     2  4.83116,  3.93764, 11.48001, 10.25191,  9.22852,  8.30478,
     3  7.41694,  6.53894,  5.67997,  4.79450, 12.14024, 10.97205,
     4  9.99098,  9.10902,  8.26152,  7.43678,  6.61693,  5.74676,
     5 12.80048, 11.70514, 10.77528,  9.94307,  9.14681,  8.37910,
     6  7.59954,  6.75060, 13.46071, 12.44615, 11.57286, 10.79219,
     7 10.05916,  9.34357,  8.60281,  7.77829, 14.12094, 13.19219,
     8 12.37824, 11.65570, 10.98281, 10.31524,  9.61084,  8.81175,
     9 14.78117, 13.94149, 13.18895, 12.52970, 11.90950, 11.28429/
      data (   be1(i),i=  55, 108)/
     1 10.61315,  9.83901, 15.44140, 14.69260, 14.00673, 13.40633,
     2 12.83251, 12.24409, 11.60266, 10.85207, 16.10164, 15.44297,
     3 14.83010, 14.28020, 13.74439, 13.18767, 12.57250, 11.84356,
     4 16.76187, 16.19347, 15.64899, 15.14270, 14.63935, 14.10891,
     5 13.51554, 12.80445, 17.42210, 16.94226, 16.45950, 15.99107,
     6 15.51541, 15.00709, 14.43232, 13.73689, 18.08234, 17.68367,
     7 17.25714, 16.82162, 16.36990, 15.88030, 15.32120, 14.63922,
     8 18.74257, 18.41515, 18.03909, 17.63326, 17.20085, 16.72615,
     9 16.18007, 15.50935, 19.40280, 19.13216, 18.79459, 18.41089/
      data (   be1(i),i= 109, 128)/
     1 17.99023, 17.52107, 16.97449, 16.29460, 20.06303, 19.84149,
     2 19.54132, 19.18042, 18.77388, 18.31474, 17.77560, 17.10242,
     3 20.72327, 20.54077, 20.27074, 19.92865, 19.53352, 19.08246,
     4 18.55008, 17.88167/
c
c         be2(iu,ie)= (sqrt(v) -sqrtv)/(1.-u)
c          from sqrt(1-u)=0.000 to 0.548 step= 0.055
c          from log10(e)= 1.698970 to 6.000000 step  0.2867
c
      data (   be2(i),i=   1,  63)/
     1  0.0576,  0.0578,  0.0585,  0.0596,  0.0613,  0.0636,  0.0666,
     2  0.0705,  0.0757,  0.0826,  0.0919,  0.0697,  0.0700,  0.0708,
     3  0.0722,  0.0741,  0.0768,  0.0801,  0.0845,  0.0901,  0.0974,
     4  0.1071,  0.0859,  0.0863,  0.0874,  0.0892,  0.0917,  0.0948,
     5  0.0988,  0.1038,  0.1101,  0.1181,  0.1286,  0.1066,  0.1072,
     6  0.1088,  0.1112,  0.1143,  0.1181,  0.1229,  0.1287,  0.1359,
     7  0.1449,  0.1563,  0.1320,  0.1330,  0.1354,  0.1387,  0.1426,
     8  0.1474,  0.1530,  0.1597,  0.1679,  0.1779,  0.1905,  0.1627,
     9  0.1643,  0.1679,  0.1723,  0.1774,  0.1831,  0.1897,  0.1974/
      data (   be2(i),i=  64, 126)/
     1  0.2067,  0.2178,  0.2316,  0.1988,  0.2016,  0.2069,  0.2128,
     2  0.2190,  0.2258,  0.2335,  0.2423,  0.2526,  0.2648,  0.2796,
     3  0.2406,  0.2453,  0.2528,  0.2602,  0.2678,  0.2757,  0.2844,
     4  0.2943,  0.3056,  0.3188,  0.3345,  0.2874,  0.2949,  0.3051,
     5  0.3143,  0.3232,  0.3323,  0.3421,  0.3528,  0.3650,  0.3790,
     6  0.3954,  0.0843,  0.2445,  0.3355,  0.3616,  0.3772,  0.3900,
     7  0.4020,  0.4145,  0.4279,  0.4429,  0.4601,  0.0959,  0.1783,
     8  0.3647,  0.4106,  0.4339,  0.4507,  0.4653,  0.4794,  0.4940,
     9  0.5098,  0.5275,  0.0567,  0.1330,  0.3932,  0.4603,  0.4918/
      data (   be2(i),i= 127, 176)/
     1  0.5128,  0.5299,  0.5455,  0.5611,  0.5776,  0.5956,  0.0460,
     2  0.1144,  0.4174,  0.5077,  0.5481,  0.5734,  0.5929,  0.6101,
     3  0.6266,  0.6435,  0.6616,  0.0122,  0.0166,  0.0502,  0.3125,
     4  0.4648,  0.5435,  0.5926,  0.6277,  0.6559,  0.6808,  0.7044,
     5  0.0095,  0.0134,  0.0455,  0.3209,  0.4952,  0.5845,  0.6393,
     6  0.6778,  0.7081,  0.7341,  0.7584,  0.0073,  0.0106,  0.0401,
     7  0.3184,  0.5165,  0.6170,  0.6780,  0.7202,  0.7526,  0.7799,
     8  0.8050/
c
c
c         energy of gamma
c       0.5000e+05  0.6975e+05  0.9729e+05  0.1357e+06  0.1893e+06
c       0.2641e+06  0.3684e+06  0.5139e+06  0.7169e+06  0.1000e+07
c       log10 step= 0.144559
c
c       log10 of gamma energy boundary
      data egh1l/ 4.698970/
c    *     ,egh1l/ 6.000000/
c
      data (tcph  (i),i=   1,  10)/
     1  0.7737,  0.7751,  0.7736,  0.7679,  0.7553,  0.7358,  0.7081,
     2  0.6732,  0.6321,  0.5862/
c
c        table of v
c        from u= 0.0000 to  1.0000 step  0.1000
c        from log10(e)= 4.698970 to 6.000000 step  0.1446
c
      data (   vp (i),i=   1,  72)/
     1 1.0000, 0.9603, 0.9184, 0.8742, 0.8272, 0.7776, 0.7257, 0.6715,
     2 0.6155, 0.5582, 0.5000, 1.0000, 0.9602, 0.9182, 0.8736, 0.8264,
     3 0.7770, 0.7254, 0.6714, 0.6155, 0.5581, 0.5000, 1.0000, 0.9603,
     4 0.9182, 0.8736, 0.8269, 0.7779, 0.7264, 0.6724, 0.6165, 0.5588,
     5 0.5000, 1.0000, 0.9606, 0.9187, 0.8748, 0.8287, 0.7798, 0.7284,
     6 0.6742, 0.6175, 0.5593, 0.5000, 1.0000, 0.9612, 0.9201, 0.8772,
     7 0.8317, 0.7832, 0.7316, 0.6772, 0.6199, 0.5605, 0.5000, 1.0000,
     8 0.9621, 0.9224, 0.8805, 0.8356, 0.7875, 0.7358, 0.6806, 0.6224,
     9 0.5619, 0.5000, 1.0000, 0.9636, 0.9255, 0.8848, 0.8407, 0.7929/
      data (   vp (i),i=  73, 110)/
     1 0.7410, 0.6853, 0.6260, 0.5638, 0.5000, 1.0000, 0.9655, 0.9291,
     2 0.8897, 0.8464, 0.7990, 0.7471, 0.6905, 0.6298, 0.5658, 0.5000,
     3 1.0000, 0.9676, 0.9331, 0.8951, 0.8528, 0.8058, 0.7537, 0.6964,
     4 0.6343, 0.5682, 0.5000, 1.0000, 0.9700, 0.9374, 0.9008, 0.8595,
     5 0.8129, 0.7608, 0.7027, 0.6390, 0.5708, 0.5000/
c    -------------------                  ------------------
c       total prob. equivalenced to common
c
      equivalence (tprob,tp)
c

c
c
c                      0.762 =(7/9-b)*rx0 =.773*rx0
      data rx0/0.986/, ctpc/.762/,  cep/ 5.e3/
c       rx0=x0(true)/x0(in nishimura text)=13.7/13.9
c       cep: min. energy for landau correc for pair
c            default esbc    espc
      data esbin/10./,  espin/100./
c
c
      if(ee .lt. eblmin) then
          t=1.e50
      else
          if(.not. usees) then
             esb=esbin
          else
             esb=min(escb, eblmax)
          endif
          if(ee .gt. esb) then
              screen=.false.
              if(lcorec .and. ee .gt. eeh1) then
                  if(ee .gt. eeh2) then
                       write(6,'('' ee > eeh2 in brmalt: ee='',g12.4)')
     *                 ee
                       stop
                  endif
                  landau=.true.
                  ale=log10(ee)
                  call kintp3(tcbh, 1, neeh,  eeh1l, deelh, ale, tp)
                  tp = tp * rx0
c                  tp=fintp3(tcbh, eeh1l, deelh, neeh, ale)*rx0
              else
                  landau=.false.
c                     complete screening cross-section
                  vc=ec/ee
                  tp=(-1.3603*( log(vc)-vc)-vc*vc*.5-.8603 )*rx0
              endif
          else
              landau=.false.
              if(scorec) then
                  screen=.true.
                  ale=log10(ee)
                  call kintp3(tcbl, 1, nbtcl,  etcbl1, debtcl, ale, tp)
c                  tp=fintp3(tcbl, etcbl1, debtcl, nbtcl,  ale)
              else
                  screen=.false.
c                     complete screening cross-section
                  vc=ec/ee
                  tp=(-1.3603*( log(vc)-vc)-vc*vc*.5-.8603 )*rx0
              endif
          endif
c
          call rndc(u)
          t =- log(u)/tp
      endif
      return
c
c     ************
      entry brmale(ee,ec,beg)
c     ************
c
      call rndc(u)
      if(screen) then
c           partial screening
         if(u .gt. uela1) then
c                  region a

            call k4ptdi(bla, nuela, neela, nuela, uela1, eela1l,
     *           duela, deela, u, ale, ans)
c               beg=exp( tdint4(bla, nuela, neela, uela1, eela1l, duela,
c     *         deela, u,  ale)*(1.-u) ) *egmnl
               beg=exp( ans*(1.-u) ) *egmnl
         else
c                  region b
            us=sqrt(u)
            call k4ptdi(blb, nuelb, neelb, nuelb, uelb1, eelb1l,
     *           duelb, deelb, us, ale, ans)
c               beg=exp( tdint4(blb, nuelb, neelb, uelb1, eelb1l,duelb,
c     *         deelb, us, ale)) * egmnl
               beg=exp( ans) * egmnl
          endif
      elseif(landau) then
         if(u .lt. ueh2) then
            call k4ptdi(be1, nueh1, neeh, nueh1, ueh1, eeh1l, dueh1,
     *           deelh, u, ale, ans)
               beg=exp( ans  ) * egmnh
c               beg=exp( tdint4(be1, nueh1, neeh, ueh1, eeh1l, dueh1,
c     *         deelh, u,  ale)  ) * egmnh
         else
               us=sqrt(1.-u)
            call k4ptdi(be2, nueh2, neeh, nueh2, ueh3, eeh1l, dueh2,
     *           deelh, us, ale, ans)
               beg=   (ans*(1.-u)+ sqrt(egmnh/ee) )**2 *ee
c               beg=   ( tdint4(be2, nueh2, neeh, ueh3, eeh1l, dueh2,
c     *         deelh, us,  ale)*(1.-u)+ sqrt(egmnh/ee) )**2 *ee
         endif
      else
c               complete screening
          a=u*tp
          if(a .le. 1.) then
             v=exp(-a)
             if(a .gt. .1) then
                 v=((.06366*a-.1447407)*a+1.014176)*v
             endif
          else
             v=exp(-(a+0.8603)/1.3603)
             if(a .le. 6.) then
                 v=((((2.050445e-3*a-3.53209e-2)*a+.228937)*a-.684076)*a
     *           +1.841734)*v
             endif
          endif
          beg=ee*v
      endif
      return
c
c
c     ***********
      entry prcalt(eg,t)
c     ***********
c
c
c
      if(eg .lt. eplmin) then
          t=1.e37
      elseif(eg .lt. eplmin .and. scorec) then
          tp=( (eg-emass2)/(eplmin-emass2) )**3 * tcpl(1)
          call rndc(u)
          t =-log(u)/tp
          landau=.false.
          screen=.true.
      else
          if(.not. usees) then
             esp=espin
          else
             esp=min(escp, eplmax)
          endif
          if(eg .gt. esp) then
              screen=.false.
              if(eg .gt. cep  .and. lcorec) then
                  landau=.true.
                  ale=log10(eg)
                  call kintp3(tcph, 1, negh,  egh1l, deghl, ale, tp)
                  tp = tp*rx0
c                  tp=fintp3(tcph, egh1l, deghl, negh, ale)*rx0
              else
                  landau=.false.
c                     complete screening cross-section
                  tp=ctpc
              endif
          else
              landau=.false.
              if(scorec) then
                  screen=.true.
                  ale=log10(eg)
                  call kintp3(tcpl, 1, nptcl,  etcpl1, deptcl, ale, tp)
c                  tp=fintp3(tcpl, etcpl1, deptcl, nptcl, ale)
              else
                  screen=.false.
c                     complete screening cross-section
                  tp=ctpc
              endif
          endif
          call rndc(u)
          t =- log(u)/tp
      endif
      return
c
c
c     ***********
      entry prcale(eg,e1)
c     ***********
c
c
c
      call rndc(u)
      if(screen) then
c           partial screening
         if(u .ge. ugla1) then
c                   region a

            call k4ptdi(pla, nugla, negla, nugla, ugla1, egla1l,
     *      dugla,  degla,  u, ale, ans)

                e1=( ans *(1.-u) + .5 )*eg

c                e1=(tdint4(pla, nugla, negla, ugla1, egla1l, dugla,
c     *          degla, u,    ale) *(1.-u) + .5 )*eg
         else
c                   region b
                us=sqrt(u)
                ex=sqrt(ale-eglb1l)
                call k4ptdi(plb, nuglb, neglb, nuglb, uglb1, 
     *          0.d0,   duglb,  deglb,  us, ale, ans)

                e1 = ans * eg
         endif
      elseif(landau) then
                call k4ptdi(vp, nugh2, negh, nugh2, ugh3,
     *          egh1l,   dugh2,  deghl,  u, ale, ans)

         e1=  ans * eg
c         e1= tdint4(vp, nugh2, negh, ugh3, egh1l, dugh2,
c     *   deghl, u,  ale) * eg
      else
c                complete screening
         e1=(((.0441223*u-.173755)*u-.3708608)*u+1.)*eg
      endif
      return
c
c     ************
      entry emctal(Knckon)
c     ************
c
c         see for def. emctpb
      cconst=1.73
      x0=8.856
      x0ing=23.913
      x0sq=78.42
      if(Knckon) then
          ecrit=32.9e-3
      else
          ecrit=33.2e-3
      endif
      constm=3.457
c
      rho = 2.70
      zchrg=13.
      zchrg2 = 169.
      amassn=26.98
      return
      end
