c     ****************************************************************
c     *                                                              *
c     * epscat: cause electron scattering and compute new coord.     *
c     *                                                              *
c     ****************************************************************
c
c  /usage/
c         call epscat(t)
c
c      t:  path of electron in r.l.
c
c
      subroutine epscat(t)
       implicit none
c
#include  "Zglobalc.h"    
#include  "Zepdef.h"
#include  "Zepwk.h"
#include  "Zepprm.h"
#include  "Zuser.h"
#include  "Zcnfig.h"
#include  "Zelmag.h"

           real*8 t
c
           real*8 theta, wc, sint, cs, sn, wa, wb, tmp, avx, avy
           real*8 disp, g1, g2, dx, dy, r

           integer cond

c          sample theta
           if(t .gt. 0.) then
               if(Molier) then
                  call cmoliere(rho*1000.d0, zchrg, zchrg2,
     *             amassn, ic, am, ee1/am, e/am,  t*x0/100.d0,
     *             theta, cond)
                  if(cond .ne. 0) then
                     call epang2(t, e*ee1, theta)
                  endif
c oldone          call epang1(t,e*ee1, theta)
               else
                  call epang2(t, e*ee1, theta)
               endif
               if(theta .lt. 0.01) then
c                     cos
                   wc=1.-theta**2/2
                   sint=theta
               else
                   theta=min(theta, pi)
                   wc=cos(theta)
                   sint=sin(theta)
               endif
c
               call kcossn(cs, sn)
c
c                 wa,wb,wc: direction cos of scattering angle
c                             sample displacement correlated to theta
c
               wa=sint*cs
               wb=sint*sn
               tmp=t/2
               avx=tmp*wa
               avy=tmp*wb
c                   dispersion
                      disp=sqrt(t/(6.*ee1*e) )*Es*t / 2
c                     sample 2 independent gaussian variables
c                 with mean 0 and var 1
               call kgauss2(0.d0, 1.0d0, g1, g2)
               dx=g1*disp+avx
               dy=g2*disp+avy
c
c                    displacement
c
               r=sqrt(dx*dx+dy*dy)
c                    direction cos of vector r in original sys.
               if(r .gt. 0.) then
                   w1=dx/r
                   w2=dy/r
                   w3=0.
c                       transform w1,w2,w3 to original sys.
c                   call eptrn2
                   call eptransVect(wx, wy, wz, w1, w2, w3,
     *             w1, w2, w3)
c                     r is in cm.
                   r=r*x0
c                    xp etc is pos.
c                    without scattering; add scattering effect.
c                    r*w1 etc is displacement by scattering
                   xpp=r*w1 + xp
                   ypp=r*w2 + yp
                   zpp=r*w3 + zp
                else
                   xpp=xp
                   ypp=yp
                   zpp=zp
                endif
c
c                  convert scattering angle at end of path to
c                  original system
                w1=wa
                w2=wb
                w3=wc
c                  wx,  etc are new direction cosine
c                call eptrn1
                call eptransVect(wx, wy, wz, w1, w2, w3, wx, wy, wz)
c                if(cnp .le. nct) then
                if(cn .le. Det.nct) then
c                     check if position moved to another component
c                     due to scattering, if so adjust position without
c                     scattering
c                   call xyzton(cnp, xpp, ypp, zpp, cnpp)
                   call eppso2cn(cn, xpp, ypp, zpp, cnpp)
c                   if(cnp .eq. cnpp) then
                   if(cn .eq. cnpp) then
c                        if the new pos. remains in the same component
c                       update position else neglect scattering effect.
                       xp=xpp
                       yp=ypp
                       zp=zpp
                   endif
                else
c                      no scattering imposed (escaping to 'void')
                endif
            endif
      end
c     ****************************************************************
c     *                                                              *
c     * epang1: samples scattering angle by Molier theory
c     *                                                              *
c     ****************************************************************
c
c /usage/
c        call epang1(t, e1*e2, theta)
c
c     t:  electron path length in r.l.
c    e1*e2: path top and end energy
c theta:  sampled angle in radian
c
c
      subroutine epang1(t, e2, teta)
       implicit none
c
#include  "Zepdef.h"
#include  "Zelmag.h"
         real*8 t, e2, teta
c
c            used in Moliere thory
          real*8 esd/3.3e-5/
c          2 dimensional as ubscat(7,7),ubsca2(11,7)
          real*8  ubscat( 49 ),ubsca2( 77 )
          integer i
c
c                 sqrt(0.1)/10
c
          real*8 du2/3.162278e-2/
          real*8 u, sb, b, xtmp, usq
c
c      ubscat:  containes x for u=0.6 to 0.9 step 0.05 and for b=4.5 to
c               16.5 step 2.
c      ubsca2:  containes log(x) from u=0.9 to 1 step 0.01 in sqrt(1-
c        u)
c
c

      data (ubscat(i),i=   1,  49)/
     1 0.9370, 1.1119, 1.3331, 1.6267, 2.0406, 2.6703, 3.7352, 0.9313,
     2 1.0890, 1.2809, 1.5239, 1.8492, 2.3236, 3.1242, 0.9285, 1.0790,
     3 1.2593, 1.4832, 1.7753, 2.1877, 2.8587, 0.9268, 1.0734, 1.2476,
     4 1.4614, 1.7365, 2.1173, 2.7196, 0.9257, 1.0698, 1.2402, 1.4479,
     5 1.7126, 2.0745, 2.6355, 0.9249, 1.0674, 1.2351, 1.4387, 1.6965,
     6 2.0457, 2.5796, 0.9243, 1.0656, 1.2315, 1.4320, 1.6849, 2.0251,
     7 2.5398/
c
c
      data (ubsca2(i),i=   1,  72)/
     1 1.3178, 1.4751, 1.6416, 1.8340, 2.0663, 2.3518, 2.6934, 3.1142,
     2 3.6467, 4.2571, 4.6052, 1.1392, 1.2850, 1.4435, 1.6184, 1.8246,
     3 2.0805, 2.4108, 2.8389, 3.4102, 4.1338, 4.6052, 1.0504, 1.1821,
     4 1.3262, 1.4879, 1.6753, 1.9080, 2.2150, 2.6362, 3.2238, 4.0232,
     5 4.6052, 1.0005, 1.1225, 1.2553, 1.4042, 1.5766, 1.7895, 2.0734,
     6 2.4788, 3.0718, 3.9256, 4.6052, 0.9691, 1.0845, 1.2094, 1.3483,
     7 1.5087, 1.7049, 1.9674, 2.3529, 2.9440, 3.8376, 4.6052, 0.9476,
     8 1.0585, 1.1777, 1.3092, 1.4601, 1.6429, 1.8863, 2.2503, 2.8342,
     9 3.7572, 4.6052, 0.9321, 1.0397, 1.1546, 1.2806, 1.4241, 1.5963/
c
          data (ubsca2(i),i= 73, 77)/
     1     1.8234, 2.1658, 2.7384, 3.6835, 4.6052/
c
          call rndc(u)
c               by Moliere theory
          sb=log(abs(t)) +10.33
          if(sb.lt.3.) then
c                 t < 1.e-3
c                 gaussianl approx.
               teta=-log(u)*t/e2
               if(teta .lt. 0.) then
                  teta = 0.
               endif
               teta=Es*sqrt(teta)
          else
              b=(-0.01451*sb+1.32)*sb+0.7
              if(u .lt. 0.6) then
                   xtmp=((1.563*u-0.0625)*u+1.025)*u
              elseif(u .lt. .9) then
c                     2 dim. interpolation
                  call
     *            k4ptdi(ubscat, 7, 7, 7, 0.6d0, 4.5d0, 0.05d0, 
     *            2.0d0, u, b,  xtmp)
              else
                  usq=0.3162278-sqrt(1.-u)
                  call
     *             k4ptdi(ubsca2,11, 7,11, 0.d0,  4.5d0, du2,  2.d0,
     *             usq, b,   xtmp)
                  xtmp=exp(xtmp)
              endif
              teta= xtmp*esd/e2      *t*b
              if(teta .lt. 0.) then
                 teta = 0.
              else
                 teta=sqrt(teta)
              endif
          endif
       end
       subroutine epang2(t, e2, teta)
       implicit none
c                gaussian  approx.
#include  "Zelmag.h"
           real*8 t, e2, teta

           real*8 u
           call rndc(u)
           
           teta=Es*sqrt(max(-log(u)*t/e2, 0.d0))
       end
      subroutine  eptrn1
       implicit none
c
#include  "Zepdef.h"
#include  "Zepwk.h"
#include  "Zuser.h"
c
          real*8 eps, el2, em2, a, b, c, d, epsx,
     *           tmpa, tmpb, tmpc, anrm
c
          data epsx/1.d-4/

          integer j
c            signals the entry is eptrn1
          j=0
   10     continue
          el2=wx**2
          em2=wy**2
          eps=el2+em2
          d=1.+wz
          if(abs(d) .gt. epsx) then
              a=el2/d - 1.
              b=wx*wy/d
              c=em2/d - 1.
              tmpa=a*w1 + b*w2 + wx*w3
              tmpb=b*w1 + c*w2 + wy*w3
          else
              tmpa=w2
              tmpb=w1
          endif
          tmpc=wx*w1 + wy*w2 + wz*w3
c              check result
          eps=tmpa**2 + tmpb**2 + tmpc**2 - 1.d0
          if(abs(eps) .gt. epsx ) then
c                 renormalize
               anrm=sqrt(1.d0+eps)
               tmpa=tmpa/anrm
               tmpb=tmpb/anrm
               tmpc=tmpc/anrm
          endif
          if(j .eq. 0) then
              wx=tmpa
              wy=tmpb
              wz=tmpc
          else
              w1=tmpa
              w2=tmpb
              w3=tmpc
          endif
          return
c
c      ************
       entry eptrn2
c      ************
c
c            this returns answer in w1,w2,w3
c
          j=-1
          goto 10
       end
       subroutine epscel
       implicit none
c          scattering and energy loss; deflection by e and b
#include  "Zepdef.h"
#include  "Zepwk.h"
#include  "Zepprm.h"
#include  "Zuser.h"
#include  "Zelmag.h"


          real*8 dedt

          ee1=e
c              compute energy loss rate
          if(EdepDedx) then
             if(e .le. am) then
                dedt = 0.
                de = 0.
             else
                if(k .eq. kelec) then
                   call dedx(e, ic, dedt)
                else
                   call dedx2(e, am, dedt)
                   dedt=dedt*ic**2
                endif
                if(jde .eq. 2) then
c                Urban model
                   call epUrban(dedt*rho, dl, e, am, de)
                   if(de .ge. 0. .and. de .le. 10.d0) then
                   else
                      de = 0.
                   endif
c                      de= GeV  in 'dl' cm
                else
c                 to gev/r.l
                   dedt=dedt*x0ing
                endif
             endif
          else
             dedt=ecrit *ic**2
             de = dedt * dt
          endif
          if(jde .ne. 2) then
             de=dedt*dt
          endif
          e=ee1-de
          if( e  .le. am) then
             de=max(ee1- am, 0.d0)
             if(dedt .gt. 0.) then
                dt=max(de/dedt, 0.d0)
             else
                dt = 0.
             endif
             e=am
             
             if(dt .eq. 0.) then
                trunc = .false.
             else
                trunc=.true.
             endif
c             dl=dt*x0
c             xp=x + dl*wx
c             yp=y + dl*wy
c             zp=z + dl*wz
cc                cnp=cn
c         elseif(e .eq. am) then
c               trunc=.false.
c               de=0.
c               dt=0.
          endif
          if(de .ge. 0.) then
              SumDe = SumDe + de
              if(jde .ge. 1) then
                      call userde(Abort)
              endif
              call epscat(dt)
              if(MagField .ge. 1 .or. ElecField .ge. 1) then
                 call epdefl
              endif
           elseif(dt .lt. 0. .and. abs(dt) .lt.  1.d-3) then
c               negligible error
              dt = abs(dt)
              dl = abs(dl)
              de = abs(de)
              SumDe = SumDe + de
              if(jde .ge. 1) then
                      call userde(Abort)
              endif
              call epscat(dt)
              if(MagField .ge. 1 .or. ElecField .ge. 1) then
                 call epdefl
              endif
           else
              write(*, *) ' DE=', de, ' dedt',dedt, ' e=',e, 
     *       ' ee1=', ee1,
     *       ' k=', k, ' ic=',ic, ' dt=',dt, ' dl=',dl, ' am=',am
              call cerrorMsg('DE < 0', 0)
           endif
           if(Abort .ne. 0)  call epempty
      end
c     ****************************************************************
c     *                                                              *
c     * epdefl: cause charged ptcl deflection due to b and e         *
c     *                                                              *
c     ****************************************************************
c
c  /usage/
c         call epdefl
c
c
c
      subroutine epdefl
       implicit none
c
#include  "Zepdef.h"
#include  "Zepwk.h"
#include  "Zepprm.h"
#include  "Zuser.h"
#include  "Zcnfig.h"
#include  "Zelmag.h"
      end
