cc           test Photot.
c      real*8 eg, egom
c      real na, natx
c      parameter(na=6.022e23, tx=6.65e-25, natx=na*tx)
c      data em/.511e-3/
c      character*70 ttl
c      character*16 capx,capy
c      open(13,file='c2s5003.#gd.data')
c      z=54.
c      a=131.3
c      x0ing=8.134
c      write(ttl,'('' z='',f4.0,'' a='',f5.1,'' x0='',f7.2,
c    * '' g/cm2'')') z, a, x0ing
c      capx='eg/m'
c      capy='p.e.x-sec/t.xs'
c      write(13) ttl
c      write(13) capx,capy
c      call Photoi(z, a, x0ing)
c      egom=.01
c      do 100 i=1,150
c          eg=egom*em
cc                 tp/x0ing---> x-s /(g/cm2)
cc                 tp/x0ing*a/na ---> sigma(cm**2)
cc                 tp/x0ing*a/(na*tx)---> normalized by thomson x.s
c          call Photot(eg, tp, path)
c          xn=tp/x0ing * a/natx
c          write(13) sngl(egom), xn
c          egom=egom*10.**(.03333)
c 100 continue
c     write(13) 1.e50, 1.e50
c     end
c     ****************************************************************
c     *
c     * Photot: samples Photo electric effect path in r.l
c     * Photoe: gives   energy of Photo-electron
c     * Photoi: fix material  or change it
c     *
c     ****************************************************************
c
c   /usage/  call Photot(eg, tp, path)
c            call Photoe(eg, e)
c            call Photoi(z, a, x0ing)
c
c   --input--
c    eg: Photon energy in gev
c
c     z: charge of media
c     a: mass no. of ..
c x0ing:radiation length in g/cm**2
c
c   -- output --
c path: sampled path in r.l
c   tp: total x-section /r.l
c    e: Photo electron energy
c
c
c  **** note ***
c            to fix or change media, Photoi must be called first.
c            before calling Photoe, Photot must be called
c
c
       subroutine Photot(eg, tp, path)
       implicit none
       real*8 eg, tp, path

       real*8 egin, eout
       real*8 ep
c
c
       integer nm
       parameter (nm=10)
c
       dimension b0(nm), b1(nm), b2(nm), fa(nm),
     *     cnstp(nm),  cnsta(nm), zsv(nm), ek(nm),
     *     cnstl(nm)
c    *    ,the(nm)
       real*8 b0, b1, b2, fa, cnstp, cnsta, zsv, ek
       real*8 cnstl
c            e mass in gev
       real*8 emass/.511e-3/
       integer midx
       real*8 u, epi, z, a, x0ing, az
       integer i
       data zsv/nm*-1./, midx/0/
       save zsv, midx, b0, b1, b2, fa, cnstp, cnsta,
     *    ek, cnstl
c

c
       ep=eg/emass
c      if(eg .lt. the(midx)) then
       if(eg .le. 0. ) then
          tp = 0.
          path = 1.d20
       else
          call rndc(u)
          epi=1./ep
          tp= ( (b2(midx)*epi + b1(midx))*epi + b0(midx) ) *
     *       fa(midx)* cnstp(midx) * epi
          if(eg .lt. ek(midx)) then
             tp=tp/cnstl(midx)
          endif
          path=-log(u) / tp
       endif
c     else
c        call photha(ep, xs)
c        tp=xs*cnstp(midx)/2
c      endif
       tp=tp*1.2
ccc    write(*,*) ' eg=',eg,' tp=',tp
       return
c
c      ************
       entry Photoe(egin, eout)
c      ************
c
       eout=egin + cnsta(midx)
       if(eout .le. emass) then
          eout=emass*1.00001
       endif
       return
c
c      ************
       entry Photoi(z, a, x0ing)
c      ************
c
       i=1
       midx=0
        do   while (i .le. nm)
          if(z .eq. zsv(i) )  then
              midx=i
              i=nm+1
          elseif(zsv(i) .lt. 0.) then
              midx=i
              zsv(i)=z
c                  make table
              az=z/137.
              b0(i)= 1./(  ( .9663*az + 5.023) *az + .9211)
              b1(i)= (2.56*az - 2.632)*az + 1.90
              b2(i)= ( (-6.563*az+ 8.25)*az - 5.616)*az + 2.097
              fa(i)= ( .2762*az - .0288) *az + 1.083
              cnsta(i)=emass - 13.5e-9*z**2
              cnstp(i)= .6 * az**4 *z/a* x0ing
c                  eg>the  then no Photoe
c             the(i)= 10.e-3*(z/82.)**4.5
              ek(i)=13.6e-9*z**2
              cnstl(i)=(8. - z*2.5/80.)
              i=nm+1
          else
              i=i+1
          endif
        enddo
       if(midx .eq. 0) then
           stop 'Photoi has no area to store consts'
       endif
       return
       end
