c     ************************ for scinti ****************************
c     *                                                              *
c     *  brmsct:  samples path for brems                             *
c     *  brmsce:  samples energy of brems gamma                      *
c     *  prcsct:  samples path for pair creation                     *
c     *  prcsce:  samples energy of pair electron (higher energy)    *
c     *  emctsc:  set const in common for scinti                     *
c     *                                                              *
c     *********************** tested 84.04.28 ********************k.k*
c
c      material   z     a     rho     t0 (g/cm2)  t0 (cm)    ec
c                 5.61 11.15
c         scinti  3.65 6.23   1.032   43.8         42.4      74.
c          r.m.s  4.31 8.52
c brems:
c        electron energy:      1mev to 10tev
c        brems gamma energy:   .1mev or more
c           if electron energy is < 1mev,  sampled path is set to be
c        very large one so that real brems may not take place before
c        the death by energy loss.
c pair:
c        gamma energy:         3mev to 10tev
c           if gamma energy is < 3mev, sampled path is set to be
c        very large one so that real pair creation may not take place
c        before compton or another process takes place.
c
c
c
c
c   /usage/          call brmsct(ee,ec,t)
c                    call brmsce(ee,ec,beg)
c
c                    call prcsct(eg,t)
c                    call prcsce(eg,e1)
c
c      ee:  incident electron energy
c      ec:  cut-off energy of brems gamma (used if complete screening
c           cross section is to be used).
c       t:  sampled path
c     beg:  sampled gamma energy
c      eg:  incident gamma energy
c      e1:  sampled electron energy (higher energy in pair)
c
c  *** note ***
c
c          before calling brmsce, brmsct must have been called.
c          //             prcsce, prcsct //
c
c          by the parameters in $elmag the user can control:
c
c        ee  -------------- 5gev------->  (if usees=t, escb instead 5)
c     scorec=t       p.s    !
c     lcorec=t              !    l.c
c     scorec=f       c.s    !
c     lcorec=f              !    c.s
c
c        eg  --------------50gev--10tev--> (if usees=t, escp instead 50)
c     scorec=t       p.s    ! c.s !
c     lcorec=t              ! c.s !
c     scorec=f       c.s    ! c.s !
c     lcorec=f              ! c.s !
c
c
c
c
      subroutine brmsct(ee,ec,t)
       implicit none
c
c
#include  "Zelmag.h"
#include  "Zemdef.h"
c
      integer i
      logical screen,landau      
      save screen,landau      
c
c
c
c
c ------------------------- partical screening ----------------------
c           *** electron ***
c
c           ! egmin (gev)  for brems.
      data egmnl/.1e-3/
c
      parameter (eblmin=1.e-3, eblmax=10.,  nbtcl=13)
      dimension tcbl(nbtcl)
c
c             brem:   region a
c
      parameter (eela1=eblmin, eela2=eblmax,neela=13,
     * uela1=.05, uela2=1., nuela=16, duela=(uela2-uela1)/(nuela-1) )
      dimension bla(nuela* neela)
c
c             brem:  region b  (sqrt(u))
      parameter (eelb1=eblmin, eelb2=eblmax, neelb=neela,
     * uelb1=0.,  uelb2=.2236068, nuelb=16,
     * duelb=(uelb2-uelb1)/(nuelb-1) )
      dimension blb(nuelb* neelb)
c           ** gamma ***
c
c                 total cross-section
      parameter (eplmin=3.e-3, eplmax=300., nptcl=16)
      dimension tcpl(nptcl)
c
c          pair: region a
      parameter ( egla1=eplmin,  egla2=eplmax, negla=16,
     *   ugla1=.05, ugla2=1., nugla=16,dugla=(ugla2-ugla1)/(nugla-1) )
      dimension pla(nugla* negla)
c
c            pair: region b     sqrt(log10(e)) sqrt(u)
      parameter (eglb1=eplmin, eglb2=eplmax, neglb=11,
     *  uglb1=0., uglb2=.2236068, nuglb=16,
     *  duglb=(uglb2-uglb1)/(nuglb-1))
      dimension plb(nuglb* neglb)
c
c
c      -------------------- landau ------------------------------
c
c          **** electron ****
c
      data egmnh/1.e-3/
      parameter ( eeh1=5., eeh2=10.e3, neeh=16,dueh1=.1,
     *  ueh1=0., ueh2=.7, nueh1=(ueh2-ueh1+.00001)/dueh1+1)
      dimension  tcbh(neeh)
      dimension  be1(nueh1* neeh)
c
c                         sqrt(1-.7)
      parameter (ueh3=0., ueh4=0.5477225,
     *nueh2=11, dvueh2=nueh2-1, dueh2=(ueh4 - ueh3)/dvueh2)
      dimension be2(nueh2*neeh)
c
c
c         *** gamma ****
c
      parameter ( egh1=5000., egh2=10.e3,negh=7, dugh2=.1,
     * ugh3=0., ugh4=1., nugh2=(ugh4-ugh3+.00001)/dugh2+1)
      dimension tcph(negh)
      dimension vp(nugh2 *negh)
c
c
c     ---------------------------------------------------------
      data debtcl/ 0.333333/
      data deela/ 0.333333/
      data deelb/ 0.333333/
      data deptcl/ 0.333333/
      data degla/ 0.333333/
      data deglb/ 0.223607/
c        electron energy=
c      0.10000e-02 0.21544e-02 0.46416e-02 0.10000e-01 0.21544e-01
c      0.46416e-01 0.10000     0.21544     0.46416      1.0000
c       2.1544      4.6416      10.000
c       log10 step=  0.3333
c
c      log10 of electron energy boundary
      data  etcbl1/-3.000000/
c    *     ,etcbl2/ 1.000000/
c
      data (tcbl  (i),i=   1,  13)/
     1 0.9638, 2.1291, 3.4278, 4.7302, 5.9861, 7.1863, 8.3379, 9.4511,
     210.5372,11.6050,12.6615,13.7112,14.7567/
c
c       brem: region a
c        electron energy=
c      0.10000e-02 0.21544e-02 0.46416e-02 0.10000e-01 0.21544e-01
c      0.46416e-01 0.10000     0.21544     0.46416      1.0000
c       2.1544      4.6416      10.000
c       log10 step=  0.3333
c
c      log10 of electron energy boundary
      data  eela1l/-3.000000/
c    *     ,eela2l/ 1.000000/
c
c
c            bla(iu,ie)=log(v/vmin)/(1.-u)
c            u=0.050 to 1.000 step= 0.0633
c            log10(e)= -3.0000 to   1.0000 step= 0.3333
c
      data (bla   (i),i=   1,  72)/
     1 1.4830, 1.3965, 1.3331, 1.2830, 1.2414, 1.2060, 1.1751, 1.1479,
     2 1.1234, 1.1014, 1.0814, 1.0627, 1.0462, 1.0302, 1.0151, 1.0018,
     3 2.4852, 2.3140, 2.2012, 2.1169, 2.0496, 1.9937, 1.9462, 1.9048,
     4 1.8699, 1.8373, 1.8075, 1.7805, 1.7565, 1.7346, 1.7150, 1.6993,
     5 3.3389, 3.1408, 3.0128, 2.9200, 2.8496, 2.7925, 2.7475, 2.7126,
     6 2.6814, 2.6541, 2.6304, 2.6092, 2.5908, 2.5741, 2.5591, 2.5460,
     7 4.1794, 3.9800, 3.8557, 3.7704, 3.7080, 3.6578, 3.6186, 3.5865,
     8 3.5600, 3.5380, 3.5197, 3.5045, 3.4914, 3.4808, 3.4719, 3.4629,
     9 5.0130, 4.8253, 4.7100, 4.6301, 4.5725, 4.5294, 4.4965, 4.4713/
      data (bla   (i),i=  73, 144)/
     1 4.4512, 4.4355, 4.4230, 4.4125, 4.4040, 4.3975, 4.3918, 4.3876,
     2 5.8382, 5.6595, 5.5475, 5.4729, 5.4217, 5.3850, 5.3581, 5.3380,
     3 5.3229, 5.3115, 5.3027, 5.2960, 5.2906, 5.2860, 5.2829, 5.2806,
     4 6.6500, 6.4727, 6.3635, 6.2942, 6.2477, 6.2156, 6.1930, 6.1768,
     5 6.1654, 6.1571, 6.1508, 6.1464, 6.1428, 6.1399, 6.1386, 6.1366,
     6 7.4458, 7.2664, 7.1591, 7.0930, 7.0503, 7.0223, 7.0033, 6.9904,
     7 6.9815, 6.9752, 6.9709, 6.9676, 6.9652, 6.9639, 6.9632, 6.9618,
     8 8.2273, 8.0433, 7.9372, 7.8744, 7.8359, 7.8113, 7.7955, 7.7852,
     9 7.7783, 7.7739, 7.7708, 7.7687, 7.7674, 7.7660, 7.7654, 7.7650/
      data (bla   (i),i= 145, 208)/
     1 8.9977, 8.8080, 8.7040, 8.6450, 8.6100, 8.5891, 8.5760, 8.5678,
     2 8.5625, 8.5594, 8.5574, 8.5559, 8.5552, 8.5546, 8.5543, 8.5535,
     3 9.7600, 9.5653, 9.4641, 9.4091, 9.3781, 9.3601, 9.3495, 9.3430,
     4 9.3391, 9.3367, 9.3352, 9.3343, 9.3338, 9.3329, 9.3331, 9.3331,
     510.5172,10.3191,10.2213,10.1705,10.1430,10.1276,10.1192,10.1142,
     610.1114,10.1096,10.1087,10.1082,10.1076,10.1073,10.1069,10.1072,
     711.2714,11.0709,10.9771,10.9307,10.9066,10.8937,10.8868,10.8830,
     810.8809,10.8798,10.8789,10.8788,10.8784,10.8784,10.8786,10.8781/
c
c       brem: region b
c        electron energy=
c      0.10000e-02 0.21544e-02 0.46416e-02 0.10000e-01 0.21544e-01
c      0.46416e-01 0.10000     0.21544     0.46416      1.0000
c       2.1544      4.6416      10.000
c       log10 step=  0.3333
c
c      log10 of electron energy boundary
      data  eelb1l/-3.000000/
c    *     ,eelb2l/ 1.000000/
c
c
c            blb(iu,ie)=log(v/vmin)/(1.-u)
c            sqrt(u)=0.000 to 0.224 step= 0.0149
c            log10(e)= -3.0000 to   1.0000 step= 0.3333
c
      data (blb   (i),i=   1,  72)/
     1 1.5872, 1.5863, 1.5834, 1.5787, 1.5722, 1.5639, 1.5541, 1.5427,
     2 1.5299, 1.5157, 1.5004, 1.4839, 1.4664, 1.4481, 1.4288, 1.4088,
     3 2.7994, 2.7947, 2.7816, 2.7623, 2.7384, 2.7114, 2.6821, 2.6508,
     4 2.6181, 2.5841, 2.5489, 2.5128, 2.4760, 2.4382, 2.4000, 2.3609,
     5 3.7210, 3.7108, 3.6883, 3.6606, 3.6297, 3.5966, 3.5611, 3.5238,
     6 3.4846, 3.4440, 3.4018, 3.3581, 3.3133, 3.2671, 3.2201, 3.1720,
     7 4.5527, 4.5391, 4.5156, 4.4885, 4.4581, 4.4252, 4.3894, 4.3513,
     8 4.3108, 4.2679, 4.2229, 4.1758, 4.1269, 4.0763, 4.0241, 3.9704,
     9 5.3487, 5.3350, 5.3140, 5.2893, 5.2614, 5.2301, 5.1958, 5.1583/
      data (blb   (i),i=  73, 144)/
     1 5.1179, 5.0746, 5.0285, 4.9798, 4.9287, 4.8751, 4.8195, 4.7623,
     2 6.1292, 6.1170, 6.0988, 6.0767, 6.0511, 6.0217, 5.9889, 5.9525,
     3 5.9127, 5.8694, 5.8228, 5.7733, 5.7205, 5.6651, 5.6066, 5.5463,
     4 6.9026, 6.8923, 6.8765, 6.8567, 6.8329, 6.8051, 6.7734, 6.7379,
     5 6.6986, 6.6551, 6.6081, 6.5572, 6.5027, 6.4445, 6.3826, 6.3175,
     6 7.6729, 7.6643, 7.6504, 7.6322, 7.6097, 7.5831, 7.5522, 7.5170,
     7 7.4774, 7.4332, 7.3844, 7.3307, 7.2727, 7.2102, 7.1438, 7.0735,
     8 8.4417, 8.4344, 8.4219, 8.4049, 8.3834, 8.3573, 8.3263, 8.2903,
     9 8.2491, 8.2027, 8.1508, 8.0935, 8.0313, 7.9640, 7.8922, 7.8160/
      data (blb   (i),i= 145, 208)/
     1 9.2098, 9.2035, 9.1921, 9.1758, 9.1546, 9.1281, 9.0960, 9.0583,
     2 9.0146, 8.9650, 8.9095, 8.8479, 8.7806, 8.7080, 8.6301, 8.5479,
     3 9.9776, 9.9722, 9.9613, 9.9452, 9.9234, 9.8959, 9.8622, 9.8221,
     4 9.7754, 9.7221, 9.6622, 9.5958, 9.5231, 9.4446, 9.3607, 9.2720,
     510.7453,10.7403,10.7299,10.7134,10.6907,10.6615,10.6256,10.5827,
     610.5325,10.4752,10.4106,10.3390,10.2607,10.1764,10.0863, 9.9914,
     711.5129,11.5084,11.4977,11.4806,11.4566,11.4255,11.3871,11.3411,
     811.2873,11.2257,11.1563,11.0793,10.9955,10.9052,10.8091,10.7078/
c
c       pair: total x-section
c        gamm energy=
c      0.30000e-02 0.64633e-02 0.13925e-01 0.30000e-01 0.64633e-01
c      0.13925     0.30000     0.64633      1.3925      3.0000
c       6.4633      13.925      30.000      64.633      139.25
c       300.00
c       log10 step=  0.3333
c
c      log10 of gamma energy boundary
      data  etcpl1/-2.522879/
c    *     ,etcpl2/ 2.477121/
c
      data (tcpl  (i),i=   1,  16)/
     1 0.0474, 0.1414, 0.2489, 0.3606, 0.4689, 0.5677, 0.6453, 0.6976,
     2 0.7304, 0.7498, 0.7608, 0.7669, 0.7701, 0.7719, 0.7728, 0.7732/
c
c       pair: region a
c
c         energy of gamma=
c        0.300e-02   0.646e-02   0.139e-01   0.300e-01   0.646e-01
c        0.139       0.300       0.646        1.39        3.00
c         6.46        13.9        30.0        64.6        139.
c         300.
c         log10 step= 0.333333
c
c         log10 of eg boundary
      data  egla1l/-2.522879/
c    *     ,egla2l/ 2.477121/
c
c
c         pla(iu,ie)=(v-.5)/(1.-u)
c         u=0.050 to1.000   step= 0.0633
c            log10(e)= -2.5229 to   2.4771 step= 0.3333
c
      data (pla   (i),i=   1,  72)/
     1 0.2916, 0.2778, 0.2695, 0.2636, 0.2592, 0.2557, 0.2530, 0.2507,
     2 0.2488, 0.2473, 0.2462, 0.2451, 0.2446, 0.2443, 0.2434, 0.2436,
     3 0.3894, 0.3764, 0.3689, 0.3638, 0.3602, 0.3574, 0.3553, 0.3536,
     4 0.3522, 0.3514, 0.3507, 0.3499, 0.3497, 0.3493, 0.3497, 0.3490,
     5 0.4348, 0.4245, 0.4189, 0.4155, 0.4133, 0.4119, 0.4109, 0.4104,
     6 0.4101, 0.4100, 0.4099, 0.4101, 0.4099, 0.4101, 0.4103, 0.4101,
     7 0.4590, 0.4515, 0.4480, 0.4464, 0.4457, 0.4456, 0.4461, 0.4465,
     8 0.4472, 0.4479, 0.4489, 0.4494, 0.4501, 0.4503, 0.4510, 0.4508,
     9 0.4732, 0.4683, 0.4669, 0.4669, 0.4676, 0.4686, 0.4701, 0.4717/
      data (pla   (i),i=  73, 144)/
     1 0.4733, 0.4747, 0.4759, 0.4768, 0.4772, 0.4773, 0.4766, 0.4789,
     2 0.4823, 0.4799, 0.4802, 0.4814, 0.4836, 0.4861, 0.4888, 0.4914,
     3 0.4938, 0.4963, 0.4984, 0.5001, 0.5011, 0.5039, 0.5046, 0.5042,
     4 0.4889, 0.4889, 0.4912, 0.4945, 0.4981, 0.5022, 0.5064, 0.5103,
     5 0.5141, 0.5178, 0.5211, 0.5237, 0.5261, 0.5280, 0.5287, 0.5287,
     6 0.4940, 0.4966, 0.5009, 0.5057, 0.5107, 0.5160, 0.5212, 0.5260,
     7 0.5310, 0.5355, 0.5394, 0.5429, 0.5454, 0.5472, 0.5489, 0.5487,
     8 0.4979, 0.5025, 0.5079, 0.5138, 0.5198, 0.5257, 0.5317, 0.5372,
     9 0.5427, 0.5478, 0.5522, 0.5559, 0.5590, 0.5612, 0.5629, 0.5630/
      data (pla   (i),i= 145, 216)/
     1 0.5008, 0.5065, 0.5127, 0.5192, 0.5257, 0.5323, 0.5385, 0.5447,
     2 0.5504, 0.5557, 0.5605, 0.5648, 0.5679, 0.5706, 0.5718, 0.5723,
     3 0.5027, 0.5091, 0.5159, 0.5228, 0.5297, 0.5364, 0.5429, 0.5493,
     4 0.5554, 0.5610, 0.5656, 0.5702, 0.5735, 0.5760, 0.5776, 0.5781,
     5 0.5039, 0.5108, 0.5178, 0.5248, 0.5318, 0.5388, 0.5455, 0.5520,
     6 0.5582, 0.5639, 0.5687, 0.5731, 0.5767, 0.5794, 0.5806, 0.5815,
     7 0.5046, 0.5118, 0.5188, 0.5261, 0.5333, 0.5401, 0.5470, 0.5535,
     8 0.5599, 0.5655, 0.5707, 0.5751, 0.5787, 0.5813, 0.5825, 0.5834,
     9 0.5052, 0.5123, 0.5194, 0.5267, 0.5340, 0.5409, 0.5479, 0.5545/
      data (pla   (i),i= 217, 256)/
     1 0.5607, 0.5665, 0.5715, 0.5760, 0.5797, 0.5823, 0.5835, 0.5844,
     2 0.5054, 0.5126, 0.5199, 0.5271, 0.5343, 0.5415, 0.5483, 0.5550,
     3 0.5613, 0.5668, 0.5722, 0.5765, 0.5800, 0.5828, 0.5845, 0.5850,
     4 0.5056, 0.5128, 0.5200, 0.5272, 0.5345, 0.5417, 0.5486, 0.5552,
     5 0.5616, 0.5671, 0.5722, 0.5770, 0.5803, 0.5833, 0.5845, 0.5853/
c
c
c       pair: region b
c
c         energy of gamma=
c        0.300e-02   0.337e-02   0.475e-02   0.846e-02   0.189e-01
c        0.533e-01   0.189       0.846        4.75        33.7
c         300.
c         sqrt(log10) step= 0.223607
c
c         use 0 for e-side at interpolation
c         with sqrt(log10(e)-eglb1l)
      data  eglb1l/-2.522879/
c
c
c         plb(iu,ie)=v
c         sqrt(u)=0.000 to0.224   step= 0.0149
      data (plb   (i),i=   1,  72)/
     1 0.8297, 0.8272, 0.8240, 0.8206, 0.8172, 0.8138, 0.8103, 0.8067,
     2 0.8031, 0.7995, 0.7959, 0.7922, 0.7884, 0.7846, 0.7809, 0.7770,
     3 0.8482, 0.8471, 0.8446, 0.8416, 0.8383, 0.8349, 0.8313, 0.8277,
     4 0.8241, 0.8203, 0.8166, 0.8128, 0.8090, 0.8050, 0.8011, 0.7970,
     5 0.8925, 0.8918, 0.8900, 0.8875, 0.8844, 0.8812, 0.8777, 0.8741,
     6 0.8703, 0.8665, 0.8626, 0.8586, 0.8545, 0.8504, 0.8462, 0.8419,
     7 0.9396, 0.9389, 0.9369, 0.9344, 0.9315, 0.9281, 0.9247, 0.9212,
     8 0.9174, 0.9135, 0.9096, 0.9056, 0.9014, 0.8972, 0.8928, 0.8884,
     9 0.9730, 0.9721, 0.9701, 0.9675, 0.9646, 0.9616, 0.9584, 0.9550/
      data (plb   (i),i=  73, 144)/
     1 0.9516, 0.9479, 0.9442, 0.9404, 0.9365, 0.9324, 0.9281, 0.9239,
     2 0.9904, 0.9894, 0.9875, 0.9853, 0.9828, 0.9803, 0.9775, 0.9747,
     3 0.9717, 0.9686, 0.9652, 0.9619, 0.9583, 0.9546, 0.9507, 0.9468,
     4 0.9973, 0.9964, 0.9949, 0.9932, 0.9914, 0.9895, 0.9873, 0.9850,
     5 0.9824, 0.9799, 0.9771, 0.9742, 0.9710, 0.9679, 0.9645, 0.9608,
     6 0.9994, 0.9987, 0.9979, 0.9968, 0.9954, 0.9940, 0.9924, 0.9906,
     7 0.9886, 0.9865, 0.9842, 0.9819, 0.9793, 0.9765, 0.9737, 0.9707,
     8 0.9999, 0.9996, 0.9990, 0.9982, 0.9973, 0.9963, 0.9951, 0.9937,
     9 0.9921, 0.9904, 0.9886, 0.9866, 0.9845, 0.9821, 0.9796, 0.9769/
      data (plb   (i),i= 145, 176)/
     1 1.0000, 0.9998, 0.9994, 0.9988, 0.9982, 0.9974, 0.9964, 0.9952,
     2 0.9938, 0.9924, 0.9906, 0.9888, 0.9867, 0.9845, 0.9821, 0.9795,
     3 1.0000, 0.9998, 0.9996, 0.9992, 0.9985, 0.9977, 0.9968, 0.9957,
     4 0.9943, 0.9929, 0.9913, 0.9894, 0.9874, 0.9852, 0.9828, 0.9803/
c    ---------------     $$$   landau correction region $$$     ----
      data deelh/ 0.220069/
      data deghl/ 0.050172/
c
c          energy of electron
c        5.000       8.299       13.78       22.87       37.95
c        63.00       104.6       173.6       288.1       478.2
c        793.7       1317.       2187.       3630.       6025.
c       0.1000e+05
c         log10 step= 0.220069
c
c         log10 of electron energy boundary
      data eeh1l/ 0.698970/
c    *     ,eeh2l/ 4.000000/
c
      data (tcbh  (i),i=   1,  16)/
     1 10.5231, 11.1941, 11.8767, 12.5017, 12.9508, 13.1542, 13.1096,
     2 12.8587, 12.4619, 11.9642, 11.3996, 10.7923, 10.1612,  9.5144,
     3  8.8594,  8.1993/
c
c          be1(iu,ie)= log(v/vmin)
c          from u=0.000 to 0.700 step=0.100
c          from log10(e)=  0.6990 to  4.0000 step  0.2201
c          dim. of u=  8 dim of e= 16
c
      data (   be1(i),i=   1,  54)/
     1  8.51719,  7.38675,  6.43224,  5.57625,  4.75835,  3.95642,
     2  3.16147,  2.36965,  9.02392,  7.82734,  6.82624,  5.92456,
     3  5.05953,  4.20920,  3.36504,  2.52350,  9.53065,  8.26772,
     4  7.21960,  6.27123,  5.35794,  4.45810,  3.56365,  2.67137,
     5 10.03737,  8.71451,  7.62359,  6.63227,  5.67453,  4.72915,
     6  3.78851,  2.84969, 10.54410,  9.17861,  8.05703,  7.03474,
     7  6.04491,  5.06669,  4.09278,  3.11560, 11.05083,  9.66615,
     8  8.53071,  7.49435,  6.48995,  5.49683,  4.50651,  3.51963,
     9 11.55755, 10.17708,  9.04468,  8.01140,  7.01021,  6.02035/
      data (   be1(i),i=  55, 108)/
     1  5.03010,  4.05292, 12.06428, 10.70750,  9.59220,  8.57627,
     2  7.59303,  6.62004,  5.65249,  4.68583, 12.57101, 11.25193,
     3 10.16373,  9.17516,  8.22026,  7.27365,  6.34137,  5.39043,
     4 13.07773, 11.80638, 10.75226,  9.79789,  8.87839,  7.96896,
     5  7.07351,  6.14230, 13.58446, 12.36169, 11.35251, 10.43679,
     6  9.55478,  8.69075,  7.83278,  6.92338, 14.09118, 12.93409,
     7 11.96084, 11.08654, 10.24563,  9.42845,  8.60708,  7.72099,
     8 14.59791, 13.50355, 12.57436, 11.74251, 10.94705, 10.17706,
     9  9.38959,  8.52719, 15.10464, 14.07549, 13.19198, 12.40153/
      data (   be1(i),i= 109, 128)/
     1 11.65575, 10.92774, 10.17418,  9.33528, 15.61137, 14.64924,
     2 13.81269, 13.06656, 12.36906, 11.68012, 10.95712, 10.14100,
     3 16.11809, 15.22456, 14.43524, 13.73642, 13.08283, 12.42952,
     4 11.73479, 10.94047/
c
c         be2(iu,ie)= (sqrt(v) -sqrtv)/(1.-u)
c          from sqrt(1-u)=0.000 to 0.548 step= 0.055
c          from log10(e)= 0.698970 to 4.000000 step  0.2201
c
      data (   be2(i),i=   1,  63)/
     1  0.0558,  0.0561,  0.0572,  0.0589,  0.0615,  0.0650,  0.0696,
     2  0.0757,  0.0835,  0.0937,  0.1070,  0.0460,  0.0463,  0.0472,
     3  0.0488,  0.0512,  0.0545,  0.0586,  0.0640,  0.0711,  0.0804,
     4  0.0926,  0.0380,  0.0382,  0.0390,  0.0402,  0.0421,  0.0447,
     5  0.0484,  0.0533,  0.0599,  0.0684,  0.0796,  0.0340,  0.0342,
     6  0.0348,  0.0358,  0.0373,  0.0394,  0.0423,  0.0463,  0.0517,
     7  0.0592,  0.0696,  0.0334,  0.0336,  0.0341,  0.0350,  0.0363,
     8  0.0381,  0.0406,  0.0440,  0.0486,  0.0550,  0.0641,  0.0355,
     9  0.0356,  0.0361,  0.0369,  0.0382,  0.0399,  0.0423,  0.0454/
      data (   be2(i),i=  64, 126)/
     1  0.0497,  0.0556,  0.0639,  0.0396,  0.0397,  0.0403,  0.0411,
     2  0.0424,  0.0442,  0.0466,  0.0498,  0.0541,  0.0599,  0.0679,
     3  0.0456,  0.0457,  0.0463,  0.0473,  0.0488,  0.0507,  0.0533,
     4  0.0567,  0.0611,  0.0671,  0.0753,  0.0534,  0.0536,  0.0543,
     5  0.0555,  0.0572,  0.0594,  0.0623,  0.0660,  0.0708,  0.0772,
     6  0.0858,  0.0631,  0.0634,  0.0643,  0.0658,  0.0677,  0.0703,
     7  0.0736,  0.0777,  0.0830,  0.0899,  0.0991,  0.0749,  0.0753,
     8  0.0765,  0.0783,  0.0807,  0.0837,  0.0874,  0.0921,  0.0980,
     9  0.1056,  0.1155,  0.0889,  0.0895,  0.0911,  0.0934,  0.0963/
      data (   be2(i),i= 127, 176)/
     1  0.0998,  0.1041,  0.1094,  0.1160,  0.1243,  0.1350,  0.1054,
     2  0.1063,  0.1086,  0.1115,  0.1149,  0.1190,  0.1240,  0.1299,
     3  0.1372,  0.1463,  0.1579,  0.1246,  0.1261,  0.1291,  0.1328,
     4  0.1369,  0.1417,  0.1473,  0.1540,  0.1620,  0.1720,  0.1845,
     5  0.1469,  0.1490,  0.1531,  0.1577,  0.1626,  0.1681,  0.1744,
     6  0.1818,  0.1907,  0.2015,  0.2149,  0.1722,  0.1755,  0.1809,
     7  0.1864,  0.1922,  0.1984,  0.2055,  0.2137,  0.2234,  0.2351,
     8  0.2493/
c
c
c         energy of gamma
c        5000.       5612.       6300.       7071.       7937.
c        8909.      0.1000e+05
c       log10 step= 0.050172
c
c       log10 of gamma energy boundary
      data egh1l/ 3.698970/
c    *     ,egh1l/ 4.000000/
c
      data (tcph  (i),i=   1,   7)/
     1  0.7778,  0.7778,  0.7778,  0.7778,  0.7778,  0.7778,  0.7778/
c
c        table of v
c        from u= 0.0000 to  1.0000 step  0.1000
c        from log10(e)= 3.698970 to 4.000000 step  0.0502
c
      data (   vp (i),i=   1,  72)/
     1 1.0000, 0.9601, 0.9180, 0.8736, 0.8267, 0.7774, 0.7257, 0.6716,
     2 0.6156, 0.5582, 0.5000, 1.0000, 0.9601, 0.9180, 0.8736, 0.8267,
     3 0.7774, 0.7257, 0.6716, 0.6156, 0.5582, 0.5000, 1.0000, 0.9601,
     4 0.9180, 0.8736, 0.8267, 0.7774, 0.7257, 0.6716, 0.6156, 0.5582,
     5 0.5000, 1.0000, 0.9601, 0.9180, 0.8736, 0.8267, 0.7774, 0.7257,
     6 0.6716, 0.6156, 0.5582, 0.5000, 1.0000, 0.9601, 0.9180, 0.8736,
     7 0.8267, 0.7774, 0.7257, 0.6716, 0.6156, 0.5582, 0.5000, 1.0000,
     8 0.9601, 0.9180, 0.8736, 0.8267, 0.7774, 0.7257, 0.6716, 0.6156,
     9 0.5582, 0.5000, 1.0000, 0.9601, 0.9180, 0.8736, 0.8267, 0.7774/
      data (   vp (i),i=  73,  77)/
     1 0.7257, 0.6716, 0.6156, 0.5582, 0.5000/
c       total prob. equivalenced to common
c
      equivalence (tprob,tp)
c

c
c                         complete screening pair x-sxec.
c                         0.703 =(7/9-b)*rx0 =.773*rx0
      data rx0/0.909/, ctpc/.703/,  cep/5.e3/
c       rx0=x0(true)/x0(in nishimura text)=5.82/6.4
c       cep:  minimum energy for landau correction for pair.
c          default esbc espc
      data esbin/5./,  espin/50./
c
c
      if(ee .lt. eblmin) then
          t=1.e36
      else
          if(.not. usees) then
             esb=esbin
          else
             esb=min(escb, eblmax)
          endif
          if(ee .gt. esb) then
              screen=.false.
              if(lcorec .and. ee .gt. eeh1) then
                  if(ee .gt. eeh2) then
                       write(6,'('' ee > eeh2 in brmsct: ee='',g12.4)')
     *                 ee
                       landau=.false.
c                         complete screening cross-section
                       vc=ec/ee
                       tp=(-1.3603*(log(vc)-vc)-vc*vc*.5-.8603 )*rx0
                  else
                       landau=.true.
                       ale=log10(ee)
c                      tp=fintp3(tcbh, eeh1l, deelh, neeh, ale)*rx0
                      call kintp3(tcbh, 1, neeh, eeh1l, deelh, ale, tp)
                      tp=tp*rx0
                  endif
              else
                  landau=.false.
c                     complete screening cross-section
                  vc=ec/ee
                  tp=(-1.3603*(log(vc)-vc)-vc*vc*.5-.8603 )*rx0
              endif
          else
              landau=.false.
              if(scorec) then
                  screen=.true.
                  ale=log10(ee)
c                 tp=fintp3(tcbl, etcbl1, debtcl, nbtcl,  ale)
                  call kintp3(tcbl, 1, nbtcl, etcbl1, debtcl,  ale, tp)
              else
                  screen=.false.
c                     complete screening cross-section
                  vc=ec/ee
                  tp=(-1.3603*(log(vc)-vc)-vc*vc*.5-.8603 )*rx0
              endif
          endif
c
          call rndc(u)
          t =-log(u)/tp
      endif
      return
c
c     ************
      entry brmsce(ee,ec,beg)
c     ************
c
      call rndc(u)
      if(screen) then
c           partial screening
         if(u .gt. uela1) then
c                  region a
c              beg=exp( tdint4(bla, nuela, neela, uela1, eela1l, duela,
c    *         deela, u,  ale)*(1.-u) ) *egmnl
               call k4ptdi(bla, nuela, neela, nuela, uela1, eela1l,
     *         duela, deela, u, ale, ans)
               beg=exp( ans*(1.-u))*egmnl
         else
c                  region b
               us=sqrt(u)
c              beg=exp( tdint4(blb, nuelb, neelb, uelb1, eelb1l,duelb,
c    *         deelb, us, ale)) * egmnl
               call k4ptdi(blb, nuelb, neelb, nuelb, uelb1, eelb1l,
     *         duelb, deelb, us, ale, ans)
               beg=exp(ans)*egmnl
         endif
      elseif(landau) then
         if(u .lt. ueh2) then
c              beg=exp( tdint4(be1, nueh1, neeh, ueh1, eeh1l, dueh1,
c    *         deelh, u,  ale)  ) * egmnh
               call k4ptdi(be1, nueh1, neeh, nueh1,  ueh1, eeh1l,
     *         dueh1, deelh, u,  ale, ans)
               beg=exp( ans ) *egmnh
         else
               us=sqrt(1.-u)
c              beg=   ( tdint4(be2, nueh2, neeh, ueh3, eeh1l, dueh2,
c    *         deelh, us,  ale)*(1.-u)+ sqrt(egmnh/ee) )**2 *ee
               call k4ptdi(be2, nueh2, neeh, nueh2,  ueh3, eeh1l,
     *         dueh2, deelh, us,  ale, ans)
               beg=  (ans*(1.-u) + sqrt(egmnh/ee) )**2*ee
         endif
      else
c               complete screening
          a=u*tp
          if(a .le. 1.) then
             v=exp(-a)
             if(a .gt. .1) then
                 v=((.06366*a-.1447407)*a+1.014176)*v
             endif
          else
             v=exp(-(a+0.8603)/1.3603)
             if(a .le. 6.) then
                 v=((((2.050445e-3*a-3.53209e-2)*a+.228937)*a-.684076)*a
     *           +1.841734)*v
             endif
          endif
          beg=ee*v
      endif
      return
c
c
c     ***********
      entry prcsct(eg,t)
c     ***********
c
c
c
      if(eg .le. emass2) then
          t=1.e37
      elseif(eg .lt. eplmin .and. scorec) then
          tp=( (eg-emass2)/(eplmin-emass2) )**3 * tcpl(1)
          call rndc(u)
          t =-log(u)/tp
          landau=.false.
          screen=.true.
      else
          if(.not. usees) then
             esp=espin
          else
             esp=min(escp, eplmax)
          endif
          if(eg .gt. esp) then
              screen=.false.
              if(eg .gt. cep   .and. lcorec) then
                  landau=.true.
                  ale=log10(eg)
c                 tp=fintp3(tcph, egh1l, deghl, negh, ale)*rx0
                  call kintp3(tcph, 1, negh,  egh1l,  deghl,   ale, tp)
                  tp=tp*rx0
              else
                  landau=.false.
c                     complete screening cross-section
                  tp=ctpc
              endif
          else
              landau=.false.
              if(scorec) then
                  screen=.true.
                  ale=log10(eg)
c                 tp=fintp3(tcpl, etcpl1, deptcl, nptcl, ale)
                  call kintp3(tcpl, 1,nptcl,  etcpl1, deptcl,  ale, tp)
              else
                  screen=.false.
c                     complete screening cross-section
                  tp=ctpc
              endif
          endif
          call rndc(u)
          t =-log(u)/tp
      endif
      return
c
c
c     ***********
      entry prcsce(eg,e1)
c     ***********
c
c
c
      call rndc(u)
      if(screen) then
c           partial screening
         if(u .ge. ugla1) then
c                   region a
c               e1=(tdint4(pla, nugla, negla, ugla1, egla1l, dugla,
c    *          degla, u,    ale) *(1.-u) + .5 )*eg
                call k4ptdi(pla, nugla, negla,nugla,  ugla1, egla1l,
     *          dugla, degla, u,   ale, ans)
                e1=(ans*(1.-u) + .5)*eg
         else
c                   region b
                us=sqrt(u)
                ex=sqrt(ale-eglb1l)

                call k4ptdi(plb, nuglb, neglb,nuglb,  uglb1, 0.d0,
     *          duglb, deglb, us,  ale, ans)
                e1=ans*eg
         endif
      elseif(landau) then
c        e1= tdint4(vp, nugh2, negh, ugh3, egh1l, dugh2,
c    *   deghl, u,  ale) * eg
         call k4ptdi(vp, nugh2, negh, nugh2, ugh3, egh1l,
     *   dugh2, deghl, u,  ale, ans)
         e1=ans*eg
      else
c                complete screening
         e1=(((.0441223*u-.173755)*u-.3708608)*u+1.)*eg
      endif
      return
c
c     ************
      entry emctsc(Knckon)
c     ************
c
c               cconst=for compton=3/8*thomson*n0*z/a*x0ing
c               to convert cross-section in compt into /(r.l).
      cconst=3.84
      x0=42.4
      x0ing=43.8
      x0sq=1798.
      if(Knckon) then
         ecrit=74.e-3
      else
         ecrit=80.e-3
      endif
c         moller scat
c            constm=.3*z/a*x0ing
c           
      constm=6.61
      rho = 1.032
c
      zchrg= 5.61
      zchrg2 = 33.3
      amassn=11.15
      ionizP = 63.6d-9
      end
