c     ************************ for g 10 ******************************
c     *                                                              *
c     *  brmgtt:  samples path for brems                             *
c     *  brmgte:  samples energy of brems gamma                      *
c     *  prcgtt:  samples path for pair creation                     *
c     *  prcgte:  samples energy of pair electron (higher energy)    *
c     *  emctgt:  set const in common for ar                         *
c     *                                                              *
c     *********************** tested 88.10.13 ********************k.k*
c
c      material   z     a     rho     t0 (g/cm2)  t0 (cm)    ec
c       g 10     5.75  11.22  1.75    29.9        17.08    45.   mev
c brems:
c        electron energy:      1mev to 10tev
c        brems gamma energy:   .1mev or more
c           if electron energy is < 1mev,  sampled path is set to be
c        very large one so that real brems may not take place before
c        the death by energy loss.
c pair:
c        gamma energy:         3mev to 10tev
c           if gamma energy is < 3mev, sampled path is set to be
c        very large one so that real pair creation may not take place
c        before compton or another process takes place.
c
c
c
c
c   /usage/          call brmgtt(ee,ec,t)
c                    call brmgte(ee,ec,beg)
c
c                    call prcgtt(eg,t)
c                    call prcgte(eg,e1)
c
c      ee:  incident electron energy
c      ec:  cut-off energy of brems gamma (used if complete screening
c           cross section is to be used).
c       t:  sampled path
c     beg:  sampled gamma energy
c      eg:  incident gamma energy
c      e1:  sampled electron energy (higher energy in pair)
c
c  *** note ***
c
c          before calling brmgte, brmgtt must have been called.
c          //             prcgte, prcgtt //
c
c          by the parameters in $elmag the user can control:
c
c        ee  -------------100gev------10tevif usees=t, escb instead 100
c     scorec=t       p.s    !
c     lcorec=t              !    l.c
c     scorec=f       c.s    !
c     lcorec=f              !    c.s
c
c        eg  --------------10gev--10tev    (if usees=t, escp instead 10)
c     scorec=t       p.s    ! c.s
c     lcorec=t              ! c.s
c     scorec=f       c.s    ! c.s
c     lcorec=f              !
c
c
c
c
      subroutine brmgtt(ee,ec,t)
       implicit none
c
c
#include  "Zelmag.h"
#include  "Zemdef.h"
c
c
      integer i
      logical screen,landau
      save screen,landau
c
c ------------------------- partical screening ----------------------
c           *** electron ***
c
c           ! egmin (gev)  for brems.
      data egmnl/.1e-3/
c
      parameter (eblmin=1.e-3, eblmax=10., nbtcl=13)
      dimension tcbl(nbtcl)
c
c             brem:   region a
c
      parameter (eela1=eblmin, eela2=eblmax,neela=13,
     * uela1=.05, uela2=1., nuela=16, duela=(uela2-uela1)/(nuela-1) )
      dimension bla(nuela *neela)
c
c             brem:  region b  (sqrt(u))
      parameter (eelb1=eblmin, eelb2=eblmax, neelb=neela,
     * uelb1=0.,  uelb2=.2236068, nuelb=16,
     * duelb=(uelb2-uelb1)/(nuelb-1) )
      dimension blb(nuelb *neelb)
c
c           ** gamma ***
c
c                 total cross-section
      parameter (eplmin=3.e-3, eplmax= 10., nptcl=13)
      dimension tcpl(nptcl)
c
c          pair: region a
      parameter ( egla1=eplmin,  egla2=eplmax, negla=13,
     *   ugla1=.05, ugla2=1., nugla=16,dugla=(ugla2-ugla1)/(nugla-1) )
      dimension pla(nugla* negla)
c
c            pair: region b     sqrt(log10(e)) sqrt(u)
      parameter (eglb1=eplmin, eglb2=eplmax, neglb=11,
     *  uglb1=0., uglb2=.2236068, nuglb=16,
     *  duglb=(uglb2-uglb1)/(nuglb-1))
      dimension plb(nuglb* neglb)
c
c      -------------------- landau ------------------------------
c          **** electron ****
c
      data egmnh/1.e-3/
      parameter ( eeh1=5., eeh2= 20.e3, neeh=16,dueh1=.1,
     *  ueh1=0., ueh2=.7, nueh1=(ueh2-ueh1+.00001)/dueh1+1)
      dimension  tcbh(neeh)
      dimension  be1(nueh1* neeh)
c
c                         sqrt(1-.7)
      parameter (ueh3=0., ueh4=0.5477225,
     *nueh2=11, dvueh2=nueh2-1, dueh2=(ueh4 - ueh3)/dvueh2)
      dimension be2(nueh2*neeh)
c
c
c         *** gamma ****
c
      parameter ( egh1=5000., egh2= 20.e3,negh=7, dugh2=.1,
     * ugh3=0., ugh4=1., nugh2=(ugh4-ugh3+.00001)/dugh2+1)
c
c
c
c     ---------------------------------------------------------
      data debtcl/ 0.333333/
      data deela/ 0.333333/
      data deelb/ 0.333333/
      data deptcl/ 0.293573/
      data degla/ 0.293573/
      data deglb/ 0.187693/
c        electron energy=
c      0.10000e-02 0.21544e-02 0.46416e-02 0.10000e-01 0.21544e-01
c      0.46416e-01 0.10000     0.21544     0.46416      1.0000
c       2.1544      4.6416      10.000
c       log10 step=  0.3333
c
c      log10 of electron energy boundary
      data  etcbl1/-3.000000/
c    *     ,etcbl2/ 1.000000/
c
      data (tcbl  (i),i=   1,  13)/
     1 1.0131, 2.1985, 3.4874, 4.7759, 6.0172, 7.2072, 8.3515, 9.4602,
     210.5432,11.6092,12.6647,13.7139,14.7592/
c
c       brem: region a
c        electron energy=
c      0.10000e-02 0.21544e-02 0.46416e-02 0.10000e-01 0.21544e-01
c      0.46416e-01 0.10000     0.21544     0.46416      1.0000
c       2.1544      4.6416      10.000
c       log10 step=  0.3333
c
c      log10 of electron energy boundary
      data  eela1l/-3.000000/
c    *     ,eela2l/ 1.000000/
c
c
c            bla(iu,ie)=log(v/vmin)/(1.-u)
c            u=0.050 to 1.000 step= 0.0633
c            log10(e)= -3.0000 to   1.0000 step= 0.3333
c
      data (bla   (i),i=   1,  72)/
     1 1.4832, 1.3969, 1.3337, 1.2837, 1.2422, 1.2070, 1.1762, 1.1491,
     2 1.1247, 1.1026, 1.0830, 1.0648, 1.0473, 1.0319, 1.0169, 1.0037,
     3 2.4865, 2.3159, 2.2036, 2.1194, 2.0523, 1.9967, 1.9490, 1.9090,
     4 1.8724, 1.8394, 1.8146, 1.7882, 1.7645, 1.7450, 1.7266, 1.7115,
     5 3.3426, 3.1466, 3.0201, 2.9285, 2.8592, 2.8036, 2.7618, 2.7245,
     6 2.6936, 2.6671, 2.6435, 2.6229, 2.6047, 2.5881, 2.5735, 2.5608,
     7 4.1844, 3.9877, 3.8656, 3.7828, 3.7191, 3.6709, 3.6320, 3.6003,
     8 3.5743, 3.5527, 3.5349, 3.5196, 3.5069, 3.4962, 3.4878, 3.4791,
     9 5.0186, 4.8338, 4.7194, 4.6405, 4.5831, 4.5402, 4.5079, 4.4830/
      data (bla   (i),i=  73, 144)/
     1 4.4632, 4.4476, 4.4354, 4.4254, 4.4167, 4.4101, 4.4061, 4.4005,
     2 5.8438, 5.6668, 5.5553, 5.4816, 5.4304, 5.3939, 5.3670, 5.3472,
     3 5.3322, 5.3209, 5.3120, 5.3054, 5.2999, 5.2957, 5.2928, 5.2902,
     4 6.6549, 6.4784, 6.3699, 6.3003, 6.2538, 6.2217, 6.1994, 6.1834,
     5 6.1718, 6.1633, 6.1572, 6.1527, 6.1490, 6.1468, 6.1437, 6.1430,
     6 7.4492, 7.2703, 7.1630, 7.0971, 7.0544, 7.0265, 7.0074, 6.9946,
     7 6.9857, 6.9796, 6.9751, 6.9718, 6.9695, 6.9681, 6.9658, 6.9660,
     8 8.2297, 8.0457, 7.9397, 7.8769, 7.8383, 7.8137, 7.7979, 7.7876,
     9 7.7808, 7.7763, 7.7732, 7.7711, 7.7694, 7.7684, 7.7681, 7.7674/
      data (bla   (i),i= 145, 208)/
     1 8.9992, 8.8094, 8.7053, 8.6462, 8.6114, 8.5904, 8.5773, 8.5690,
     2 8.5640, 8.5608, 8.5584, 8.5570, 8.5564, 8.5554, 8.5543, 8.5549,
     3 9.7607, 9.5661, 9.4649, 9.4099, 9.3788, 9.3608, 9.3502, 9.3437,
     4 9.3399, 9.3375, 9.3361, 9.3353, 9.3344, 9.3345, 9.3331, 9.3338,
     510.5176,10.3194,10.2215,10.1708,10.1434,10.1281,10.1194,10.1145,
     610.1117,10.1099,10.1090,10.1084,10.1082,10.1073,10.1069,10.1075,
     711.2716,11.0711,10.9774,10.9307,10.9066,10.8937,10.8868,10.8832,
     810.8809,10.8798,10.8789,10.8788,10.8784,10.8784,10.8786,10.8782/
c
c       brem: region b
c        electron energy=
c      0.10000e-02 0.21544e-02 0.46416e-02 0.10000e-01 0.21544e-01
c      0.46416e-01 0.10000     0.21544     0.46416      1.0000
c       2.1544      4.6416      10.000
c       log10 step=  0.3333
c
c      log10 of electron energy boundary
      data  eelb1l/-3.000000/
c    *     ,eelb2l/ 1.000000/
c
c
c            blb(iu,ie)=log(v/vmin)/(1.-u)
c            sqrt(u)=0.000 to 0.224 step= 0.0149
c            log10(e)= -3.0000 to   1.0000 step= 0.3333
c
      data (blb   (i),i=   1,  72)/
     1 1.5872, 1.5863, 1.5834, 1.5787, 1.5722, 1.5639, 1.5542, 1.5428,
     2 1.5300, 1.5158, 1.5005, 1.4841, 1.4667, 1.4482, 1.4291, 1.4091,
     3 2.7994, 2.7947, 2.7817, 2.7624, 2.7386, 2.7117, 2.6824, 2.6513,
     4 2.6186, 2.5847, 2.5497, 2.5137, 2.4769, 2.4392, 2.4010, 2.3622,
     5 3.7210, 3.7108, 3.6885, 3.6609, 3.6304, 3.5974, 3.5623, 3.5251,
     6 3.4863, 3.4459, 3.4039, 3.3605, 3.3159, 3.2701, 3.2234, 3.1755,
     7 4.5527, 4.5392, 4.5159, 4.4890, 4.4590, 4.4263, 4.3910, 4.3531,
     8 4.3129, 4.2704, 4.2257, 4.1791, 4.1306, 4.0803, 4.0285, 3.9752,
     9 5.3487, 5.3351, 5.3144, 5.2900, 5.2623, 5.2314, 5.1973, 5.1603/
      data (blb   (i),i=  73, 144)/
     1 5.1204, 5.0775, 5.0319, 4.9835, 4.9327, 4.8798, 4.8247, 4.7677,
     2 6.1292, 6.1171, 6.0992, 6.0774, 6.0519, 6.0229, 5.9905, 5.9544,
     3 5.9149, 5.8721, 5.8261, 5.7770, 5.7249, 5.6696, 5.6120, 5.5516,
     4 6.9026, 6.8924, 6.8769, 6.8572, 6.8337, 6.8063, 6.7749, 6.7398,
     5 6.7007, 6.6579, 6.6112, 6.5608, 6.5065, 6.4483, 6.3868, 6.3221,
     6 7.6729, 7.6643, 7.6507, 7.6327, 7.6104, 7.5841, 7.5535, 7.5187,
     7 7.4794, 7.4355, 7.3867, 7.3333, 7.2754, 7.2131, 7.1469, 7.0767,
     8 8.4417, 8.4344, 8.4222, 8.4053, 8.3840, 8.3581, 8.3274, 8.2916,
     9 8.2505, 8.2042, 8.1524, 8.0954, 8.0332, 7.9660, 7.8943, 7.8182/
      data (blb   (i),i= 145, 208)/
     1 9.2098, 9.2037, 9.1923, 9.1762, 9.1551, 9.1286, 9.0967, 9.0591,
     2 9.0156, 8.9662, 8.9107, 8.8491, 8.7819, 8.7093, 8.6316, 8.5493,
     3 9.9776, 9.9722, 9.9615, 9.9455, 9.9238, 9.8963, 9.8626, 9.8225,
     4 9.7760, 9.7228, 9.6629, 9.5965, 9.5239, 9.4454, 9.3614, 9.2727,
     510.7453,10.7405,10.7300,10.7135,10.6909,10.6618,10.6259,10.5830,
     610.5328,10.4755,10.4109,10.3394,10.2611,10.1767,10.0868, 9.9917,
     711.5129,11.5084,11.4978,11.4807,11.4567,11.4256,11.3874,11.3414,
     811.2875,11.2258,11.1565,11.0795,10.9956,10.9054,10.8093,10.7080/
c
c       pair: total x-section
c        gamm energy=
c      0.30000e-02 0.58979e-02 0.11595e-01 0.22795e-01 0.44814e-01
c      0.88102e-01 0.17320     0.34051     0.66943      1.3161
c       2.5873      5.0866      9.9999
c       log10 step=  0.2936
c
c      log10 of gamma energy boundary
      data  etcpl1/-2.522879/
c    *     ,etcpl2/ 1.000000/
c
      data (tcpl  (i),i=   1,  13)/
     1 0.0482, 0.1317, 0.2268, 0.3263, 0.4246, 0.5180, 0.5993, 0.6606,
     2 0.7030, 0.7306, 0.7480, 0.7586, 0.7650/
c
c       pair: region a
c
c         energy of gamma=
c        0.300e-02   0.590e-02   0.116e-01   0.228e-01   0.448e-01
c        0.881e-01   0.173       0.341       0.669        1.32
c         2.59        5.09        10.0
c         log10 step= 0.293573
c
c         log10 of eg boundary
      data  egla1l/-2.522879/
c    *     ,egla2l/ 1.000000/
c
c
c         pla(iu,ie)=(v-.5)/(1.-u)
c         u=0.050 to1.000   step= 0.0633
c            log10(e)= -2.5229 to   1.0000 step= 0.2936
c
      data (pla   (i),i=   1,  72)/
     1 0.2914, 0.2776, 0.2693, 0.2634, 0.2591, 0.2555, 0.2528, 0.2504,
     2 0.2486, 0.2473, 0.2459, 0.2451, 0.2442, 0.2437, 0.2434, 0.2435,
     3 0.3814, 0.3681, 0.3604, 0.3553, 0.3514, 0.3486, 0.3462, 0.3445,
     4 0.3432, 0.3419, 0.3412, 0.3404, 0.3402, 0.3398, 0.3402, 0.3395,
     5 0.4266, 0.4155, 0.4094, 0.4056, 0.4032, 0.4013, 0.4002, 0.3993,
     6 0.3988, 0.3985, 0.3984, 0.3983, 0.3981, 0.3979, 0.3976, 0.3981,
     7 0.4520, 0.4435, 0.4394, 0.4370, 0.4359, 0.4353, 0.4352, 0.4355,
     8 0.4359, 0.4362, 0.4369, 0.4370, 0.4378, 0.4379, 0.4377, 0.4381,
     9 0.4674, 0.4614, 0.4591, 0.4584, 0.4585, 0.4591, 0.4601, 0.4613/
      data (pla   (i),i=  73, 144)/
     1 0.4627, 0.4638, 0.4650, 0.4659, 0.4669, 0.4673, 0.4676, 0.4680,
     2 0.4775, 0.4737, 0.4730, 0.4735, 0.4748, 0.4764, 0.4783, 0.4804,
     3 0.4827, 0.4844, 0.4867, 0.4879, 0.4888, 0.4884, 0.4920, 0.4911,
     4 0.4846, 0.4829, 0.4838, 0.4860, 0.4885, 0.4914, 0.4944, 0.4976,
     5 0.5005, 0.5038, 0.5060, 0.5080, 0.5095, 0.5099, 0.5082, 0.5129,
     6 0.4900, 0.4908, 0.4935, 0.4973, 0.5015, 0.5059, 0.5100, 0.5146,
     7 0.5184, 0.5222, 0.5256, 0.5282, 0.5305, 0.5330, 0.5337, 0.5342,
     8 0.4944, 0.4974, 0.5018, 0.5069, 0.5120, 0.5174, 0.5225, 0.5277,
     9 0.5327, 0.5371, 0.5410, 0.5444, 0.5467, 0.5482, 0.5499, 0.5509/
      data (pla   (i),i= 145, 208)/
     1 0.4979, 0.5025, 0.5079, 0.5138, 0.5199, 0.5259, 0.5317, 0.5375,
     2 0.5430, 0.5478, 0.5522, 0.5559, 0.5590, 0.5612, 0.5628, 0.5631,
     3 0.5005, 0.5061, 0.5124, 0.5188, 0.5254, 0.5317, 0.5381, 0.5442,
     4 0.5498, 0.5550, 0.5597, 0.5638, 0.5672, 0.5696, 0.5708, 0.5716,
     5 0.5024, 0.5087, 0.5153, 0.5221, 0.5290, 0.5356, 0.5422, 0.5486,
     6 0.5546, 0.5600, 0.5648, 0.5692, 0.5725, 0.5750, 0.5767, 0.5771,
     7 0.5036, 0.5102, 0.5173, 0.5243, 0.5313, 0.5382, 0.5449, 0.5513,
     8 0.5574, 0.5629, 0.5680, 0.5726, 0.5758, 0.5784, 0.5796, 0.5806/
c
c
c       pair: region b
c
c         energy of gamma=
c        0.300e-02   0.325e-02   0.415e-02   0.623e-02   0.110e-01
c        0.228e-01   0.556e-01   0.160       0.539        2.14
c         10.0
c         sqrt(log10) step= 0.187693
c
c         use 0 for e-side at interpolation
c         with sqrt(log10(e)-eglb1l)
      data  eglb1l/-2.522879/
c
c
c         plb(iu,ie)=v
c         sqrt(u)=0.000 to0.224   step= 0.0149
      data (plb   (i),i=   1,  72)/
     1 0.8297, 0.8270, 0.8238, 0.8204, 0.8170, 0.8135, 0.8101, 0.8066,
     2 0.8029, 0.7994, 0.7957, 0.7920, 0.7883, 0.7845, 0.7807, 0.7768,
     3 0.8429, 0.8417, 0.8389, 0.8357, 0.8323, 0.8289, 0.8254, 0.8218,
     4 0.8181, 0.8144, 0.8107, 0.8069, 0.8031, 0.7992, 0.7953, 0.7913,
     5 0.8769, 0.8761, 0.8741, 0.8715, 0.8684, 0.8651, 0.8616, 0.8580,
     6 0.8543, 0.8505, 0.8466, 0.8427, 0.8386, 0.8346, 0.8304, 0.8262,
     7 0.9179, 0.9173, 0.9154, 0.9129, 0.9099, 0.9066, 0.9032, 0.8995,
     8 0.8957, 0.8920, 0.8880, 0.8839, 0.8798, 0.8755, 0.8712, 0.8669,
     9 0.9535, 0.9528, 0.9508, 0.9481, 0.9451, 0.9419, 0.9386, 0.9350/
      data (plb   (i),i=  73, 144)/
     1 0.9314, 0.9275, 0.9236, 0.9197, 0.9156, 0.9114, 0.9070, 0.9026,
     2 0.9776, 0.9767, 0.9746, 0.9720, 0.9692, 0.9663, 0.9632, 0.9599,
     3 0.9565, 0.9530, 0.9493, 0.9456, 0.9417, 0.9376, 0.9336, 0.9294,
     4 0.9908, 0.9898, 0.9879, 0.9857, 0.9833, 0.9808, 0.9781, 0.9752,
     5 0.9723, 0.9692, 0.9658, 0.9625, 0.9590, 0.9553, 0.9515, 0.9475,
     6 0.9968, 0.9959, 0.9943, 0.9926, 0.9908, 0.9887, 0.9864, 0.9841,
     7 0.9816, 0.9789, 0.9760, 0.9731, 0.9699, 0.9667, 0.9631, 0.9596,
     8 0.9991, 0.9984, 0.9973, 0.9961, 0.9946, 0.9930, 0.9913, 0.9894,
     9 0.9873, 0.9851, 0.9827, 0.9801, 0.9774, 0.9746, 0.9716, 0.9684/
      data (plb   (i),i= 145, 176)/
     1 0.9998, 0.9993, 0.9986, 0.9977, 0.9966, 0.9954, 0.9941, 0.9926,
     2 0.9909, 0.9891, 0.9871, 0.9851, 0.9827, 0.9803, 0.9776, 0.9748,
     3 0.9999, 0.9996, 0.9992, 0.9985, 0.9978, 0.9968, 0.9957, 0.9945,
     4 0.9931, 0.9915, 0.9898, 0.9878, 0.9857, 0.9834, 0.9810, 0.9784/
c      ------------------------------------
      data deelh/ 0.240137/
c
c          energy of electron
c        5.000       8.692       15.11       26.27       45.66
c        79.37       138.0       239.8       416.9       724.8
c        1260.       2190.       3807.       6618.      0.1151e+05
c       0.2000e+05
c         log10 step= 0.240137
c
c         log10 of electron energy boundary
      data eeh1l/ 0.698970/
c    *     ,eeh2l/ 4.301030/
c
      data (tcbh  (i),i=   1,  16)/
     1 10.5193, 11.2627, 11.9619, 12.4624, 12.6721, 12.5877, 12.2745,
     2 11.8019, 11.2228, 10.5837,  9.9035,  9.2026,  8.4907,  7.7735,
     3  7.0572,  6.3472/
c
c          be1(iu,ie)= log(v/vmin)
c          from u=0.000 to 0.700 step=0.100
c          from log10(e)=  0.6990 to  4.3010 step  0.2401
c          dim. of u=  8 dim of e= 16
c
      data (   be1(i),i=   1,  54)/
     1  8.51719,  7.38713,  6.43289,  5.57716,  4.75953,  3.95788,
     2  3.16321,  2.37169,  9.07013,  7.86684,  6.86100,  5.95463,
     3  5.08476,  4.22947,  3.38026,  2.53363,  9.62307,  8.35193,
     4  7.29797,  6.34376,  5.42442,  4.51839,  3.61766,  2.71905,
     5 10.17600,  8.85689,  7.76865,  6.78005,  5.82511,  4.88260,
     6  3.94488,  3.00389, 10.72894,  9.38986,  8.28729,  7.28423,
     7  6.31433,  5.35649,  4.40010,  3.45321, 11.28188,  9.95082,
     8  8.85403,  7.85679,  6.89292,  5.94105,  4.99188,  4.05039,
     9 11.83481, 10.53366,  9.45827,  8.48260,  7.54105,  6.60851/
      data (   be1(i),i=  55, 108)/
     1  5.68924,  4.75906, 12.38775, 11.13205, 10.08908,  9.14584,
     2  8.23785,  7.34065,  6.45811,  5.54321, 12.94069, 11.74129,
     3 10.73821,  9.83457,  8.96490,  8.11345,  7.26890,  6.37372,
     4 13.49362, 12.35717, 11.39844, 10.53833,  9.71289,  8.91230,
     5  8.10513,  7.23220, 14.04656, 12.97808, 12.06702, 11.25181,
     6 10.47610,  9.72397,  8.95233,  8.10315, 14.59950, 13.60214,
     7 12.74089, 11.97040, 11.24872, 10.54075,  9.80361,  8.97833,
     8 15.15243, 14.22849, 13.41792, 12.69806, 12.02629, 11.35864,
     9 10.65300,  9.85106, 15.70537, 14.85663, 14.09742, 13.43093/
      data (   be1(i),i= 109, 128)/
     1 12.80390, 12.17246, 11.49566, 10.71603, 16.25830, 15.48592,
     2 14.78234, 14.16560, 13.57817, 12.97891, 12.32825, 11.56958,
     3 16.81125, 16.11499, 15.47057, 14.89843, 14.34574, 13.77485,
     4 13.14767, 12.40841/
c
c         be2(iu,ie)= (sqrt(v) -sqrtv)/(1.-u)
c          from sqrt(1-u)=0.000 to 0.548 step= 0.055
c          from log10(e)= 0.698970 to 4.301030 step  0.2401
c
      data (   be2(i),i=   1,  63)/
     1  0.0562,  0.0563,  0.0574,  0.0592,  0.0619,  0.0653,  0.0699,
     2  0.0759,  0.0837,  0.0939,  0.1072,  0.0450,  0.0452,  0.0461,
     3  0.0476,  0.0498,  0.0528,  0.0570,  0.0625,  0.0697,  0.0790,
     4  0.0912,  0.0395,  0.0397,  0.0404,  0.0415,  0.0432,  0.0455,
     5  0.0488,  0.0531,  0.0591,  0.0673,  0.0785,  0.0387,  0.0388,
     6  0.0394,  0.0404,  0.0418,  0.0438,  0.0466,  0.0503,  0.0553,
     7  0.0621,  0.0718,  0.0414,  0.0416,  0.0421,  0.0431,  0.0444,
     8  0.0464,  0.0489,  0.0524,  0.0570,  0.0633,  0.0721,  0.0469,
     9  0.0471,  0.0477,  0.0487,  0.0502,  0.0522,  0.0548,  0.0584/
      data (   be2(i),i=  64, 126)/
     1  0.0630,  0.0692,  0.0778,  0.0550,  0.0552,  0.0559,  0.0571,
     2  0.0587,  0.0609,  0.0639,  0.0676,  0.0726,  0.0791,  0.0879,
     3  0.0655,  0.0658,  0.0667,  0.0681,  0.0700,  0.0726,  0.0759,
     4  0.0801,  0.0855,  0.0926,  0.1020,  0.0786,  0.0790,  0.0802,
     5  0.0819,  0.0843,  0.0873,  0.0912,  0.0959,  0.1020,  0.1097,
     6  0.1198,  0.0946,  0.0952,  0.0967,  0.0990,  0.1019,  0.1055,
     7  0.1100,  0.1154,  0.1222,  0.1307,  0.1417,  0.1136,  0.1145,
     8  0.1167,  0.1197,  0.1233,  0.1275,  0.1326,  0.1388,  0.1464,
     9  0.1558,  0.1678,  0.1361,  0.1374,  0.1406,  0.1444,  0.1488/
      data (   be2(i),i= 127, 176)/
     1  0.1538,  0.1597,  0.1667,  0.1751,  0.1854,  0.1983,  0.1622,
     2  0.1644,  0.1687,  0.1736,  0.1788,  0.1847,  0.1914,  0.1992,
     3  0.2085,  0.2198,  0.2336,  0.1922,  0.1956,  0.2015,  0.2075,
     4  0.2137,  0.2204,  0.2280,  0.2367,  0.2469,  0.2591,  0.2738,
     5  0.2260,  0.2314,  0.2390,  0.2463,  0.2535,  0.2612,  0.2696,
     6  0.2792,  0.2902,  0.3032,  0.3187,  0.2636,  0.2715,  0.2812,
     7  0.2899,  0.2982,  0.3068,  0.3161,  0.3264,  0.3382,  0.3519,
     8  0.3681/
c
c
c         energy of gamma
c        5000.       6300.       7937.      0.1000e+05  0.1260e+05
c       0.1587e+05  0.2000e+05
c       log10 step= 0.100343
c
c       log10 of gamma energy boundary
c
c
c        table of v
c        from u= 0.0000 to  1.0000 step  0.1000
c        from log10(e)= 3.698970 to 4.301030 step  0.1003
c
c
c
c         energy of gamma
c        5000.       9893.      0.1957e+05  0.3873e+05  0.7663e+05
c       0.1516e+06  0.3000e+06
c       log10 step= 0.296359
c
c       log10 of gamma energy boundary
c
c
c       total prob. equivalenced to common
c
      equivalence (tprob,tp)
c

c
c                         complete screening pair x-sxec.
c                         0.773 =(7/9-b)*rx0 =.773*rx0
      data rx0/1.000/, ctpc/.773/, cep/10.e3/
c     data rx0/1.000/, ctpc/.703/, 
c       rx0=x0(true)/x0(in nishimura text)
c       cep:  minimum energy for landau correction for pair.
c          default esbc espc
      data esbin/1./,  espin/10./
c
c
      if(ee .lt. eblmin) then
          t=1.e36
      else
          if(.not. usees) then
             esb=esbin
          else
             esb=min(escb, eblmax)
          endif
          if(ee .gt. esb) then
              screen=.false.
              if(lcorec .and. ee .gt. eeh1) then
                  if(ee .gt. eeh2) then
                       write(6,'('' ee > eeh2 in brmgtt: ee='',g12.4)')
     *                 ee
                       stop
                  endif
                  landau=.true.
                  ale=log10(ee)
c                 tp=fintp3(tcbh, eeh1l, deelh, neeh, ale)*rx0
                  call kintp3(tcbh, 1, neeh, eeh1l, deelh, ale, tp)
                  tp=tp*rx0
              else
                  landau=.false.
c                     complete screening cross-section
                  vc=ec/ee
                  tp=(-1.3603*(log(vc)-vc)-vc*vc*.5-.8603 )*rx0
              endif
          else
              landau=.false.
              if(scorec) then
                  screen=.true.
                  ale=log10(ee)
c                 tp=fintp3(tcbl, etcbl1, debtcl, nbtcl,  ale)
                  call kintp3(tcbl, 1, nbtcl, etcbl1, debtcl,  ale, tp)
              else
                  screen=.false.
c                     complete screening cross-section
                  vc=ec/ee
                  tp=(-1.3603*(log(vc)-vc)-vc*vc*.5-.8603 )*rx0
              endif
          endif
c
          call rndc(u)
          t =-log(u)/tp
      endif
      return
c
c     ************
      entry brmgte(ee,ec,beg)
c     ************
c
      call rndc(u)
      if(screen) then
c           partial screening
         if(u .gt. uela1) then
c                  region a
c              beg=exp( tdint4(bla, nuela, neela, uela1, eela1l, duela,
c    *         deela, u,  ale)*(1.-u) ) *egmnl
               call k4ptdi(bla, nuela, neela, nuela, uela1, eela1l,
     *         duela, deela, u, ale, ans)
               beg=exp( ans*(1.-u))*egmnl
         else
c                  region b
               us=sqrt(u)
c              beg=exp( tdint4(blb, nuelb, neelb, uelb1, eelb1l,duelb,
c    *         deelb, us, ale)) * egmnl
               call k4ptdi(blb, nuelb, neelb, nuelb, uelb1, eelb1l,
     *         duelb, deelb, us, ale, ans)
               beg=exp(ans)*egmnl
         endif
      elseif(landau) then
         if(u .lt. ueh2) then
c              beg=exp( tdint4(be1, nueh1, neeh, ueh1, eeh1l, dueh1,
c    *         deelh, u,  ale)  ) * egmnh
               call k4ptdi(be1, nueh1, neeh, nueh1,  ueh1, eeh1l,
     *         dueh1, deelh, u,  ale, ans)
               beg=exp( ans ) *egmnh
         else
               us=sqrt(1.-u)
c              beg=   ( tdint4(be2, nueh2, neeh, ueh3, eeh1l, dueh2,
c    *         deelh, us,  ale)*(1.-u)+ sqrt(egmnh/ee) )**2 *ee
               call k4ptdi(be2, nueh2, neeh, nueh2,  ueh3, eeh1l,
     *         dueh2, deelh, us,  ale, ans)
               beg=  (ans*(1.-u) + sqrt(egmnh/ee) )**2*ee
         endif
      else
c               complete screening
          a=u*tp
          if(a .le. 1.) then
             v=exp(-a)
             if(a .gt. .1) then
                 v=((.06366*a-.1447407)*a+1.014176)*v
             endif
          else
             v=exp(-(a+0.8603)/1.3603)
             if(a .le. 6.) then
                 v=((((2.050445e-3*a-3.53209e-2)*a+.228937)*a-.684076)*a
     *           +1.841734)*v
             endif
          endif
          beg=ee*v
      endif
      return
c
c
c     ***********
      entry prcgtt(eg,t)
c     ***********
c
c
c
      if(eg .le. emass2) then
          t=1.e37
      elseif(eg .lt. eplmin .and. scorec) then
          tp=( (eg-emass2)/(eplmin-emass2) )**3 * tcpl(1)
          call rndc(u)
          t =-log(u)/tp
          landau=.false.
          screen=.true.
      else
          if(.not. usees) then
             esp=espin
          else
             esp=min(escp, eplmax)
          endif
          if(eg .gt. esp) then
              screen=.false.
              if(eg .gt. cep   .and. lcorec) then
                  landau=.true.
                  ale=log10(eg)
c                 tp=fintp3(tcph, egh1l, deghl, negh, ale)*rx0
                  call kintp3(tcph, 1, negh,  egh1l,  deghl,   ale, tp)
                  tp=tp*rx0
              else
                  landau=.false.
c                     complete screening cross-section
                  tp=ctpc
              endif
          else
              landau=.false.
              if(scorec) then
                  screen=.true.
                  ale=log10(eg)
c                 tp=fintp3(tcpl, etcpl1, deptcl, nptcl, ale)
                  call kintp3(tcpl, 1,nptcl,  etcpl1, deptcl,  ale, tp)
              else
                  screen=.false.
c                     complete screening cross-section
                  tp=ctpc
              endif
          endif
          call rndc(u)
          t =-log(u)/tp
      endif
      return
c
c
c     ***********
      entry prcgte(eg,e1)
c     ***********
c
c
c
      call rndc(u)
      if(screen) then
c           partial screening
         if(u .ge. ugla1) then
c                   region a
c               e1=(tdint4(pla, nugla, negla, ugla1, egla1l, dugla,
c    *          degla, u,    ale) *(1.-u) + .5 )*eg
                call k4ptdi(pla, nugla, negla,nugla,  ugla1, egla1l,
     *          dugla, degla, u,   ale, ans)
                e1=(ans*(1.-u) + .5)*eg
         else
c                   region b
                us=sqrt(u)
                ex=sqrt(ale-eglb1l)

                call k4ptdi(plb, nuglb, neglb,nuglb,  uglb1, 0.d0,
     *          duglb, deglb, us,  ale, ans)
                e1=ans*eg
         endif
      elseif(landau) then
cc       e1= tdint4(vp, nugh2, negh, ugh3, egh1l, dugh2,
cc   *   deghl, u,  ale) * eg
         call k4ptdi(vp, nugh2, negh, nugh2, ugh3, egh1l,
     *   dugh2, deghl, u,  ale, ans)
         e1=ans*eg
      else
c                complete screening
         e1=(((.0441223*u-.173755)*u-.3708608)*u+1.)*eg
      endif
      return
c
c     ************
      entry emctgt(Knckon)
c     ************
c
c               cconst=for compton=3/8*thomson*n0*z/a*x0ing
c               = .15017* z/a*x0ing
c               to convert cross-section in compt into /(r.l).
c      material   z     a     rho     t0 (g/cm2)  t0 (cm)    ec
c       g 10     5.75  11.22  1.75    29.9        17.08    45.   mev
      cconst=2.301
      x0=17.08
      x0ing=29.9
      x0sq=291.73
      if(Knckon) then
         ecrit=45.e-3
      else
         ecrit=48.e-3
      endif
c         moller scat ( .3*z/a*x0ing )
      constm=4.60
      rho = 1.75
c
      zchrg=5.75
      zchrg2 = 34.
      amassn=11.22
      ionizP = 74.8d-9
      end


