c     ************************ for cu*********************************
c     *                                                              *
c     *  brmcut:  samples path for brems                             *
c     *  brmcue:  samples energy of brems gamma                      *
c     *  prccut:  samples path for pair creation                     *
c     *  prccue:  samples energy of pair electron (higher energy)    *
c     *  emctcu:  set const in common for cu                         *
c     *                                                              *
c     *********************** tested 84.04.28 ********************k.k*
c
c      material   z     a     rho     t0 (g/cm2)  t0 (cm)    ec
c         cu      29   63.5   8.94     12.695      1.42      16.3
c brems:
c        electron energy:      1mev to  50tev
c        brems gamma energy:   .1mev or more
c           if electron energy is < 1mev,  sampled path is set to be
c        very large one so that real brems may not take place before
c        the death by energy loss.
c pair:
c        gamma energy:         3mev to  50tev
c           if gamma energy is < 3mev, sampled path is set to be
c        very large one so that real pair creation may not take place
c        before compton or another process takes place.
c
c
c
c
c   /usage/          call brmcut(ee,ec,t)
c                    call brmcue(ee,ec,beg)
c
c                    call prccut(eg,t)
c                    call prccue(eg,e1)
c
c      ee:  incident electron energy
c      ec:  cut-off energy of brems gamma (used if complete screening
c           cross section is to be used).
c       t:  sampled path
c     beg:  sampled gamma energy
c      eg:  incident gamma energy
c      e1:  sampled electron energy (higher energy in pair)
c
c  *** note ***
c
c          before calling brmcue, brmcut must have been called.
c          //             prccue, prccut //
c
c          by the parameters in $elmag the user can control:
c
c        ee  --------------10gev------->  (if usees=t, escb instead 5)
c     scorec=t       p.s    !
c     lcorec=t              !    l.c
c     scorec=f       c.s    !
c     lcorec=f              !    c.s
c
c        eg  --------------10gev--5tev---> (if usees=t, escp instead 50)
c     scorec=t       p.s    ! c.s !
c     lcorec=t              ! c.s ! l.c
c     scorec=f       c.s    ! c.s !
c     lcorec=f              !     ! c.s
c
c
c
c
      subroutine brmcut(ee,ec,t)
       implicit none
c
c
#include  "Zelmag.h"
#include  "Zemdef.h"
c
      integer i
      logical screen,landau
      save screen,landau
c
c
c
c ------------------------- partical screening ----------------------
c           *** electron ***
c
c           ! egmin (gev)  for brems.
      data egmnl/.1e-3/
c
      parameter (eblmin=1.e-3, eblmax=10., nbtcl=13)
      dimension tcbl(nbtcl)
c
c             brem:   region a
c
      parameter (eela1=eblmin, eela2=eblmax,neela=13,
     * uela1=.05, uela2=1., nuela=16, duela=(uela2-uela1)/(nuela-1) )
      dimension bla(nuela *neela)
c
c             brem:  region b  (sqrt(u))
      parameter (eelb1=eblmin, eelb2=eblmax, neelb=neela,
     * uelb1=0.,  uelb2=.2236068, nuelb=16,
     * duelb=(uelb2-uelb1)/(nuelb-1) )
      dimension blb(nuelb* neelb)
c
c           ** gamma ***
c
c                 total cross-section
      parameter (eplmin=3.e-3, eplmax= 10., nptcl=13)
      dimension tcpl(nptcl)
c
c          pair: region a
      parameter ( egla1=eplmin,  egla2=eplmax, negla=13,
     *   ugla1=.05, ugla2=1., nugla=16,dugla=(ugla2-ugla1)/(nugla-1) )
      dimension pla(nugla* negla)
c
c            pair: region b     sqrt(log10(e)) sqrt(u)
      parameter (eglb1=eplmin, eglb2=eplmax, neglb=11,
     *  uglb1=0., uglb2=.2236068, nuglb=16,
     *  duglb=(uglb2-uglb1)/(nuglb-1))
      dimension plb(nuglb* neglb)
c
c      -------------------- landau ------------------------------
c          **** electron ****
c
      data egmnh/1.e-3/
      parameter ( eeh1=5., eeh2= 20.e3, neeh=16,dueh1=.1,
     *  ueh1=0., ueh2=.7, nueh1=(ueh2-ueh1+.00001)/dueh1+1)
      dimension  tcbh(neeh)
      dimension  be1(nueh1* neeh)
c
c                         sqrt(1-.7)
      parameter (ueh3=0., ueh4=0.5477225,
     *nueh2=11, dvueh2=nueh2-1, dueh2=(ueh4 - ueh3)/dvueh2)
      dimension be2(nueh2*neeh)
c
c
c         *** gamma ****
c
      parameter ( egh1=5000., egh2= 20.e3,negh=7, dugh2=.1,
     * ugh3=0., ugh4=1., nugh2=(ugh4-ugh3+.00001)/dugh2+1)
      dimension tcph(negh)
      dimension vp(nugh2* negh)
      data debtcl/ 0.333333/
      data deela/ 0.333333/
      data deelb/ 0.333333/
      data deptcl/ 0.293573/
      data degla/ 0.293573/
      data deglb/ 0.187693/
c        electron energy=
c      0.10000e-02 0.21544e-02 0.46416e-02 0.10000e-01 0.21544e-01
c      0.46416e-01 0.10000     0.21544     0.46416      1.0000
c       2.1544      4.6416      10.000
c       log10 step=  0.3333
c
c      log10 of electron energy boundary
      data  etcbl1/-3.000000/
c    *     ,etcbl2/ 1.000000/
c
      data (tcbl  (i),i=   1,  13)/
     1 1.4190, 2.6998, 3.8882, 5.0358, 6.1572, 7.2597, 8.3431, 9.4101,
     210.4641,11.5090,12.5482,13.5836,14.6169/
c
c       brem: region a
c        electron energy=
c      0.10000e-02 0.21544e-02 0.46416e-02 0.10000e-01 0.21544e-01
c      0.46416e-01 0.10000     0.21544     0.46416      1.0000
c       2.1544      4.6416      10.000
c       log10 step=  0.3333
c
c      log10 of electron energy boundary
      data  eela1l/-3.000000/
c    *     ,eela2l/ 1.000000/
c
c
c            bla(iu,ie)=log(v/vmin)/(1.-u)
c            u=0.050 to 1.000 step= 0.0633
c            log10(e)= -3.0000 to   1.0000 step= 0.3333
c
      data (bla   (i),i=   1,  72)/
     1 1.4819, 1.3957, 1.3331, 1.2837, 1.2428, 1.2080, 1.1779, 1.1510,
     2 1.1270, 1.1055, 1.0857, 1.0670, 1.0493, 1.0327, 1.0116, 1.0054,
     3 2.4899, 2.3248, 2.2167, 2.1361, 2.0726, 2.0196, 1.9770, 1.9385,
     4 1.9051, 1.8825, 1.8583, 1.8363, 1.8174, 1.8014, 1.7849, 1.7714,
     5 3.3586, 3.1746, 3.0579, 2.9750, 2.9127, 2.8657, 2.8242, 2.7891,
     6 2.7603, 2.7352, 2.7133, 2.6947, 2.6781, 2.6638, 2.6517, 2.6396,
     7 4.2090, 4.0297, 3.9181, 3.8394, 3.7795, 3.7338, 3.6974, 3.6680,
     8 3.6441, 3.6245, 3.6082, 3.5948, 3.5829, 3.5739, 3.5647, 3.5584,
     9 5.0479, 4.8782, 4.7675, 4.6916, 4.6368, 4.5961, 4.5653, 4.5416/
      data (bla   (i),i=  73, 144)/
     1 4.5229, 4.5081, 4.4967, 4.4870, 4.4799, 4.4730, 4.4680, 4.4642,
     2 5.8720, 5.7029, 5.5944, 5.5219, 5.4722, 5.4364, 5.4102, 5.3908,
     3 5.3763, 5.3653, 5.3568, 5.3501, 5.3450, 5.3414, 5.3371, 5.3355,
     4 6.6767, 6.5057, 6.3980, 6.3288, 6.2826, 6.2507, 6.2285, 6.2125,
     5 6.2010, 6.1929, 6.1865, 6.1818, 6.1784, 6.1759, 6.1740, 6.1727,
     6 7.4650, 7.2887, 7.1814, 7.1152, 7.0726, 7.0446, 7.0256, 7.0128,
     7 7.0036, 6.9974, 6.9932, 6.9904, 6.9881, 6.9865, 6.9840, 6.9842,
     8 8.2401, 8.0570, 7.9508, 7.8877, 7.8490, 7.8244, 7.8086, 7.7984,
     9 7.7915, 7.7869, 7.7839, 7.7815, 7.7800, 7.7790, 7.7787, 7.7781/
      data (bla   (i),i= 145, 208)/
     1 9.0053, 8.8157, 8.7114, 8.6523, 8.6173, 8.5961, 8.5831, 8.5749,
     2 8.5698, 8.5666, 8.5644, 8.5629, 8.5620, 8.5614, 8.5598, 8.5606,
     3 9.7640, 9.5693, 9.4679, 9.4128, 9.3817, 9.3637, 9.3530, 9.3465,
     4 9.3428, 9.3406, 9.3390, 9.3381, 9.3372, 9.3376, 9.3359, 9.3367,
     510.5190,10.3205,10.2227,10.1718,10.1443,10.1290,10.1204,10.1155,
     610.1125,10.1108,10.1101,10.1094,10.1092,10.1088,10.1098,10.1085,
     711.2717,11.0711,10.9774,10.9307,10.9066,10.8937,10.8868,10.8832,
     810.8809,10.8798,10.8792,10.8788,10.8784,10.8784,10.8786,10.8782/
c
c       brem: region b
c        electron energy=
c      0.10000e-02 0.21544e-02 0.46416e-02 0.10000e-01 0.21544e-01
c      0.46416e-01 0.10000     0.21544     0.46416      1.0000
c       2.1544      4.6416      10.000
c       log10 step=  0.3333
c
c      log10 of electron energy boundary
      data  eelb1l/-3.000000/
c    *     ,eelb2l/ 1.000000/
c
c
c            blb(iu,ie)=log(v/vmin)/(1.-u)
c            sqrt(u)=0.000 to 0.224 step= 0.0149
c            log10(e)= -3.0000 to   1.0000 step= 0.3333
c
      data (blb   (i),i=   1,  72)/
     1 1.5872, 1.5863, 1.5834, 1.5785, 1.5720, 1.5637, 1.5537, 1.5422,
     2 1.5293, 1.5150, 1.4996, 1.4831, 1.4656, 1.4471, 1.4278, 1.4078,
     3 2.7994, 2.7945, 2.7809, 2.7611, 2.7371, 2.7100, 2.6809, 2.6500,
     4 2.6176, 2.5842, 2.5497, 2.5143, 2.4780, 2.4411, 2.4035, 2.3654,
     5 3.7210, 3.7102, 3.6876, 3.6604, 3.6306, 3.5986, 3.5645, 3.5288,
     6 3.4913, 3.4521, 3.4116, 3.3698, 3.3266, 3.2824, 3.2370, 3.1907,
     7 4.5527, 4.5387, 4.5160, 4.4901, 4.4614, 4.4303, 4.3967, 4.3606,
     8 4.3222, 4.2817, 4.2392, 4.1946, 4.1481, 4.0999, 4.0500, 3.9986,
     9 5.3487, 5.3351, 5.3153, 5.2922, 5.2660, 5.2368, 5.2046, 5.1697/
      data (blb   (i),i=  73, 144)/
     1 5.1318, 5.0911, 5.0477, 5.0021, 4.9539, 4.9030, 4.8504, 4.7955,
     2 6.1292, 6.1174, 6.1004, 6.0799, 6.0560, 6.0288, 5.9981, 5.9642,
     3 5.9271, 5.8866, 5.8430, 5.7960, 5.7462, 5.6934, 5.6374, 5.5784,
     4 6.9026, 6.8928, 6.8781, 6.8597, 6.8376, 6.8119, 6.7824, 6.7492,
     5 6.7123, 6.6714, 6.6263, 6.5775, 6.5243, 6.4675, 6.4069, 6.3428,
     6 7.6729, 7.6648, 7.6519, 7.6351, 7.6142, 7.5893, 7.5602, 7.5268,
     7 7.4885, 7.4456, 7.3981, 7.3457, 7.2888, 7.2273, 7.1615, 7.0918,
     8 8.4417, 8.4349, 8.4233, 8.4075, 8.3872, 8.3623, 8.3324, 8.2975,
     9 8.2571, 8.2115, 8.1606, 8.1040, 8.0423, 7.9755, 7.9040, 7.8281/
      data (blb   (i),i= 145, 208)/
     1 9.2098, 9.2040, 9.1933, 9.1779, 9.1574, 9.1316, 9.1003, 9.0631,
     2 9.0200, 8.9709, 8.9156, 8.8545, 8.7875, 8.7150, 8.6373, 8.5550,
     3 9.9776, 9.9726, 9.9623, 9.9467, 9.9255, 9.8982, 9.8648, 9.8251,
     4 9.7786, 9.7254, 9.6657, 9.5994, 9.5268, 9.4485, 9.3646, 9.2758,
     510.7453,10.7407,10.7305,10.7144,10.6918,10.6630,10.6271,10.5843,
     610.5343,10.4769,10.4125,10.3409,10.2627,10.1782,10.0881, 9.9930,
     711.5129,11.5087,11.4982,11.4812,11.4572,11.4263,11.3879,11.3419,
     811.2881,11.2263,11.1570,11.0799,10.9959,10.9056,10.8094,10.7081/
c
c       pair: total x-section
c        gamm energy=
c      0.30000e-02 0.58979e-02 0.11595e-01 0.22795e-01 0.44814e-01
c      0.88102e-01 0.17320     0.34051     0.66943      1.3161
c       2.5873      5.0866      9.9999
c       log10 step=  0.2936
c
c      log10 of gamma energy boundary
      data  etcpl1/-2.522879/
c    *     ,etcpl2/ 1.000000/
c
      data (tcpl  (i),i=   1,  13)/
     1 0.0474, 0.1399, 0.2446, 0.3523, 0.4569, 0.5509, 0.6246, 0.6758,
     2 0.7099, 0.7315, 0.7448, 0.7527, 0.7573/
c
c       pair: region a
c
c         energy of gamma=
c        0.300e-02   0.590e-02   0.116e-01   0.228e-01   0.448e-01
c        0.881e-01   0.173       0.341       0.669        1.32
c         2.59        5.09        10.0
c         log10 step= 0.293573
c
c         log10 of eg boundary
      data  egla1l/-2.522879/
c    *     ,egla2l/ 1.000000/
c
c
c         pla(iu,ie)=(v-.5)/(1.-u)
c         u=0.050 to1.000   step= 0.0633
c            log10(e)= -2.5229 to   1.0000 step= 0.2936
c
      data (pla   (i),i=   1,  72)/
     1 0.2795, 0.2663, 0.2582, 0.2525, 0.2482, 0.2447, 0.2421, 0.2398,
     2 0.2379, 0.2365, 0.2352, 0.2343, 0.2336, 0.2335, 0.2332, 0.2328,
     3 0.3776, 0.3642, 0.3563, 0.3510, 0.3470, 0.3441, 0.3418, 0.3401,
     4 0.3386, 0.3374, 0.3367, 0.3360, 0.3354, 0.3350, 0.3354, 0.3349,
     5 0.4247, 0.4136, 0.4075, 0.4037, 0.4011, 0.3994, 0.3983, 0.3975,
     6 0.3968, 0.3965, 0.3963, 0.3961, 0.3963, 0.3961, 0.3959, 0.3962,
     7 0.4511, 0.4428, 0.4388, 0.4367, 0.4356, 0.4353, 0.4352, 0.4355,
     8 0.4359, 0.4365, 0.4369, 0.4375, 0.4378, 0.4384, 0.4386, 0.4385,
     9 0.4673, 0.4615, 0.4593, 0.4589, 0.4591, 0.4598, 0.4607, 0.4620/
      data (pla   (i),i=  73, 144)/
     1 0.4637, 0.4647, 0.4665, 0.4673, 0.4694, 0.4702, 0.4704, 0.4692,
     2 0.4779, 0.4746, 0.4743, 0.4754, 0.4770, 0.4792, 0.4815, 0.4842,
     3 0.4865, 0.4885, 0.4913, 0.4932, 0.4945, 0.4956, 0.4967, 0.4959,
     4 0.4855, 0.4850, 0.4868, 0.4896, 0.4930, 0.4969, 0.5006, 0.5043,
     5 0.5082, 0.5114, 0.5145, 0.5171, 0.5188, 0.5200, 0.5188, 0.5221,
     6 0.4914, 0.4934, 0.4972, 0.5016, 0.5065, 0.5114, 0.5162, 0.5209,
     7 0.5256, 0.5299, 0.5336, 0.5369, 0.5395, 0.5412, 0.5424, 0.5425,
     8 0.4958, 0.4997, 0.5049, 0.5104, 0.5162, 0.5218, 0.5274, 0.5330,
     9 0.5382, 0.5429, 0.5471, 0.5511, 0.5538, 0.5559, 0.5576, 0.5577/
      data (pla   (i),i= 145, 208)/
     1 0.4991, 0.5044, 0.5104, 0.5165, 0.5229, 0.5293, 0.5353, 0.5413,
     2 0.5468, 0.5519, 0.5568, 0.5607, 0.5638, 0.5665, 0.5677, 0.5682,
     3 0.5015, 0.5075, 0.5140, 0.5208, 0.5275, 0.5342, 0.5406, 0.5468,
     4 0.5528, 0.5582, 0.5632, 0.5672, 0.5708, 0.5729, 0.5746, 0.5752,
     5 0.5030, 0.5096, 0.5165, 0.5234, 0.5304, 0.5374, 0.5440, 0.5503,
     6 0.5565, 0.5619, 0.5671, 0.5716, 0.5747, 0.5774, 0.5786, 0.5795,
     7 0.5041, 0.5109, 0.5181, 0.5251, 0.5322, 0.5391, 0.5459, 0.5525,
     8 0.5588, 0.5645, 0.5695, 0.5741, 0.5774, 0.5799, 0.5815, 0.5822/
c
c
c       pair: region b
c
c         energy of gamma=
c        0.300e-02   0.325e-02   0.415e-02   0.623e-02   0.110e-01
c        0.228e-01   0.556e-01   0.160       0.539        2.14
c         10.0
c         sqrt(log10) step= 0.187693
c
c         use 0 for e-side at interpolation
c         with sqrt(log10(e)-eglb1l)
      data  eglb1l/-2.522879/
c
c
c         plb(iu,ie)=v
c         sqrt(u)=0.000 to0.224   step= 0.0149
      data (plb   (i),i=   1,  72)/
     1 0.8297, 0.8079, 0.8064, 0.8044, 0.8019, 0.7992, 0.7963, 0.7932,
     2 0.7899, 0.7866, 0.7833, 0.7798, 0.7763, 0.7727, 0.7691, 0.7655,
     3 0.8429, 0.8297, 0.8275, 0.8248, 0.8217, 0.8185, 0.8152, 0.8117,
     4 0.8081, 0.8046, 0.8009, 0.7973, 0.7936, 0.7898, 0.7860, 0.7821,
     5 0.8769, 0.8743, 0.8709, 0.8673, 0.8638, 0.8601, 0.8564, 0.8526,
     6 0.8488, 0.8449, 0.8409, 0.8370, 0.8329, 0.8288, 0.8246, 0.8204,
     7 0.9179, 0.9167, 0.9142, 0.9110, 0.9076, 0.9040, 0.9003, 0.8965,
     8 0.8927, 0.8888, 0.8847, 0.8806, 0.8764, 0.8722, 0.8679, 0.8634,
     9 0.9535, 0.9524, 0.9500, 0.9470, 0.9439, 0.9405, 0.9369, 0.9334/
      data (plb   (i),i=  73, 144)/
     1 0.9296, 0.9257, 0.9219, 0.9179, 0.9137, 0.9095, 0.9052, 0.9007,
     2 0.9776, 0.9765, 0.9741, 0.9715, 0.9685, 0.9655, 0.9624, 0.9591,
     3 0.9557, 0.9522, 0.9485, 0.9448, 0.9409, 0.9369, 0.9329, 0.9286,
     4 0.9908, 0.9897, 0.9876, 0.9855, 0.9831, 0.9804, 0.9778, 0.9749,
     5 0.9721, 0.9689, 0.9657, 0.9624, 0.9589, 0.9552, 0.9515, 0.9475,
     6 0.9968, 0.9958, 0.9943, 0.9926, 0.9908, 0.9887, 0.9866, 0.9842,
     7 0.9818, 0.9793, 0.9765, 0.9736, 0.9705, 0.9673, 0.9640, 0.9605,
     8 0.9991, 0.9984, 0.9973, 0.9962, 0.9948, 0.9933, 0.9916, 0.9899,
     9 0.9878, 0.9857, 0.9834, 0.9810, 0.9784, 0.9757, 0.9729, 0.9699/
      data (plb   (i),i= 145, 176)/
     1 0.9998, 0.9993, 0.9986, 0.9979, 0.9969, 0.9957, 0.9945, 0.9930,
     2 0.9914, 0.9897, 0.9877, 0.9858, 0.9835, 0.9812, 0.9786, 0.9759,
     3 0.9999, 0.9996, 0.9993, 0.9987, 0.9979, 0.9970, 0.9960, 0.9948,
     4 0.9933, 0.9918, 0.9901, 0.9882, 0.9861, 0.9839, 0.9815, 0.9789/
      data deelh/ 0.240137/
      data deghl/ 0.100343/
c
c          energy of electron
c        5.000       8.692       15.11       26.27       45.66
c        79.37       138.0       239.8       416.9       724.8
c        1260.       2190.       3807.       6618.      0.1151e+05
c       0.2000e+05
c         log10 step= 0.240137
c
c         log10 of electron energy boundary
      data eeh1l/ 0.698970/
c    *     ,eeh2l/ 4.301030/
c
      data (tcbh  (i),i=   1,  16)/
     1 10.4179, 10.7742, 10.8225, 10.6102, 10.2053,  9.6710,  9.0581,
     2  8.3979,  7.7110,  7.0119,  6.3113,  5.6187,  4.9443,  4.2981,
     3  3.6896,  3.1260/
c
c          be1(iu,ie)= log(v/vmin)
c          from u=0.000 to 0.700 step=0.100
c          from log10(e)=  0.6990 to  4.3010 step  0.2401
c          dim. of u=  8 dim of e= 16
c
      data (   be1(i),i=   1,  54)/
     1  8.51719,  7.39722,  6.45005,  5.60121,  4.79068,  3.99631,
     2  3.20845,  2.42290,  9.07013,  7.91483,  6.94283,  6.06977,
     3  5.23427,  4.41426,  3.59784,  2.79823,  9.62307,  8.46299,
     4  7.48764,  6.61129,  5.77239,  4.94382,  4.13518,  3.32533,
     5 10.17600,  9.03693,  8.07635,  7.21443,  6.38857,  5.58144,
     6  4.79086,  3.97436, 10.72894,  9.63017,  8.69789,  7.86348,
     7  7.06370,  6.29464,  5.52620,  4.70973, 11.28188, 10.23685,
     8  9.34222,  8.54250,  7.78452,  7.05405,  6.31052,  5.50073,
     9 11.83481, 10.85225, 10.00138,  9.24115,  8.53287,  7.84072/
      data (   be1(i),i=  55, 108)/
     1  7.12303,  6.32489, 12.38775, 11.47347, 10.66961,  9.95759,
     2  9.29628,  8.64036,  7.94857,  7.16527, 12.94069, 12.09856,
     3 11.34434, 10.68494, 10.06611,  9.44350,  8.77666,  8.00990,
     4 13.49362, 12.72610, 12.02727, 11.41719, 10.83612, 10.24358,
     5  9.60015,  8.85039, 14.04656, 13.35363, 12.71446, 12.14886,
     6 11.60123, 11.03549, 10.41361,  9.68053, 14.59950, 13.98233,
     7 13.40299, 12.87589, 12.35760, 11.81545, 11.21306, 10.49582,
     8 15.15243, 14.61175, 14.08806, 13.59485, 13.10230, 12.58073,
     9 11.99569, 11.29306, 15.70537, 15.23804, 14.76509, 14.30310/
      data (   be1(i),i= 109, 128)/
     1 13.83301, 13.32941, 12.75962, 12.07019, 16.25830, 15.85887,
     2 15.43293, 14.99845, 14.54805, 14.06017, 13.50363, 12.82588,
     3 16.81125, 16.47267, 16.08957, 15.68043, 15.24656, 14.77154,
     4 14.22619, 13.55864/
c
c         be2(iu,ie)= (sqrt(v) -sqrtv)/(1.-u)
c          from sqrt(1-u)=0.000 to 0.548 step= 0.055
c          from log10(e)= 0.698970 to 4.301030 step  0.2401
c
      data (   be2(i),i=   1,  63)/
     1  0.0656,  0.0659,  0.0667,  0.0682,  0.0703,  0.0732,  0.0772,
     2  0.0824,  0.0893,  0.0986,  0.1112,  0.0681,  0.0684,  0.0692,
     3  0.0705,  0.0725,  0.0752,  0.0788,  0.0835,  0.0898,  0.0980,
     4  0.1091,  0.0757,  0.0759,  0.0767,  0.0781,  0.0801,  0.0829,
     5  0.0865,  0.0912,  0.0973,  0.1053,  0.1159,  0.0873,  0.0876,
     6  0.0885,  0.0901,  0.0923,  0.0953,  0.0992,  0.1042,  0.1105,
     7  0.1187,  0.1295,  0.1028,  0.1031,  0.1043,  0.1061,  0.1087,
     8  0.1121,  0.1164,  0.1219,  0.1288,  0.1375,  0.1488,  0.1219,
     9  0.1224,  0.1238,  0.1261,  0.1292,  0.1332,  0.1382,  0.1443/
      data (   be2(i),i=  64, 126)/
     1  0.1518,  0.1613,  0.1733,  0.1449,  0.1456,  0.1475,  0.1505,
     2  0.1542,  0.1589,  0.1646,  0.1715,  0.1799,  0.1902,  0.2031,
     3  0.1718,  0.1728,  0.1755,  0.1793,  0.1840,  0.1895,  0.1960,
     4  0.2038,  0.2130,  0.2242,  0.2380,  0.2027,  0.2043,  0.2081,
     5  0.2130,  0.2187,  0.2251,  0.2325,  0.2412,  0.2513,  0.2634,
     6  0.2781,  0.2376,  0.2401,  0.2454,  0.2516,  0.2584,  0.2658,
     7  0.2742,  0.2837,  0.2947,  0.3077,  0.3231,  0.2763,  0.2801,
     8  0.2872,  0.2949,  0.3029,  0.3114,  0.3207,  0.3310,  0.3429,
     9  0.3566,  0.3727,  0.3182,  0.3238,  0.3333,  0.3426,  0.3518/
      data (   be2(i),i= 127, 176)/
     1  0.3613,  0.3715,  0.3826,  0.3951,  0.4094,  0.4261,  0.3656,
     2  0.3710,  0.3829,  0.3939,  0.4043,  0.4147,  0.4257,  0.4375,
     3  0.4506,  0.4653,  0.4823,  0.4189,  0.4220,  0.4353,  0.4477,
     4  0.4593,  0.4706,  0.4822,  0.4945,  0.5080,  0.5230,  0.5401,
     5  0.4740,  0.4756,  0.4894,  0.5030,  0.5154,  0.5274,  0.5396,
     6  0.5523,  0.5660,  0.5811,  0.5982,  0.5295,  0.5300,  0.5434,
     7  0.5578,  0.5710,  0.5836,  0.5961,  0.6090,  0.6228,  0.6379,
     8  0.6548/
c
c
c         energy of gamma
c        5000.       6300.       7937.      0.1000e+05  0.1260e+05
c       0.1587e+05  0.2000e+05
c       log10 step= 0.100343
c
c       log10 of gamma energy boundary
      data egh1l/ 3.698970/
c    *     ,egh1l/ 4.301030/
c
      data (tcph  (i),i=   1,   7)/
     1  0.7739,  0.7728,  0.7742,  0.7755,  0.7764,  0.7750,  0.7721/
c
c        table of v
c        from u= 0.0000 to  1.0000 step  0.1000
c        from log10(e)= 3.698970 to 4.301030 step  0.1003
c
      data (   vp (i),i=   1,  72)/
     1 1.0000, 0.9603, 0.9184, 0.8743, 0.8277, 0.7785, 0.7267, 0.6725,
     2 0.6162, 0.5585, 0.5000, 1.0000, 0.9603, 0.9185, 0.8744, 0.8277,
     3 0.7784, 0.7266, 0.6721, 0.6160, 0.5583, 0.5000, 1.0000, 0.9603,
     4 0.9184, 0.8741, 0.8271, 0.7775, 0.7255, 0.6712, 0.6153, 0.5581,
     5 0.5000, 1.0000, 0.9602, 0.9182, 0.8736, 0.8264, 0.7769, 0.7250,
     6 0.6712, 0.6154, 0.5581, 0.5000, 1.0000, 0.9601, 0.9180, 0.8733,
     7 0.8262, 0.7768, 0.7252, 0.6713, 0.6153, 0.5581, 0.5000, 1.0000,
     8 0.9602, 0.9180, 0.8734, 0.8267, 0.7777, 0.7262, 0.6723, 0.6164,
     9 0.5588, 0.5000, 1.0000, 0.9604, 0.9182, 0.8740, 0.8277, 0.7789/
      data (   vp (i),i=  73,  77)/
     1 0.7274, 0.6734, 0.6168, 0.5589, 0.5000/
c     ---------------------------------------------------------
c
c       total prob. equivalenced to common
c
      equivalence (tprob,tp)
c

c
c                         complete screening pair x-sxec.
c                         0.703 =(7/9-b)*rx0 =.773*rx0
      data rx0/0.909/, ctpc/.703/,  cep/5.e3/
c       rx0=x0(true)/x0(in nishimura text)=5.82/6.4
c       cep:  minimum energy for landau correction for pair.
c          default esbc espc
      data esbin/5./,  espin/50./
c
c
      if(ee .lt. eblmin) then
          t=1.e36
      else
          if(.not. usees) then
             esb=esbin
          else
             esb=min(escb, eblmax)
          endif
          if(ee .gt. esb) then
              screen=.false.
              if(lcorec .and. ee .gt. eeh1) then
                  if(ee .gt. eeh2) then
                       write(6,'('' ee > eeh2 in brmcut: ee='',g12.4)')
     *                 ee
                       stop
                  endif
                  landau=.true.
                  ale=log10(ee)
c                 tp=fintp3(tcbh, eeh1l, deelh, neeh, ale)*rx0
                  call kintp3(tcbh, 1, neeh, eeh1l, deelh, ale, tp)
                  tp=tp*rx0
              else
                  landau=.false.
c                     complete screening cross-section
                  vc=ec/ee
                  tp=(-1.3603*(log(vc)-vc)-vc*vc*.5-.8603 )*rx0
              endif
          else
              landau=.false.
              if(scorec) then
                  screen=.true.
                  ale=log10(ee)
c                 tp=fintp3(tcbl, etcbl1, debtcl, nbtcl,  ale)
                  call kintp3(tcbl, 1, nbtcl, etcbl1, debtcl,  ale, tp)
              else
                  screen=.false.
c                     complete screening cross-section
                  vc=ec/ee
                  tp=(-1.3603*(log(vc)-vc)-vc*vc*.5-.8603 )*rx0
              endif
          endif
c
          call rndc(u)
          t =-log(u)/tp
      endif
      return
c
c     ************
      entry brmcue(ee,ec,beg)
c     ************
c
      call rndc(u)
      if(screen) then
c           partial screening
         if(u .gt. uela1) then
c                  region a
c              beg=exp( tdint4(bla, nuela, neela, uela1, eela1l, duela,
c    *         deela, u,  ale)*(1.-u) ) *egmnl
               call k4ptdi(bla, nuela, neela, nuela, uela1, eela1l,
     *         duela, deela, u, ale, ans)
               beg=exp( ans*(1.-u))*egmnl
         else
c                  region b
               us=sqrt(u)
c              beg=exp( tdint4(blb, nuelb, neelb, uelb1, eelb1l,duelb,
c    *         deelb, us, ale)) * egmnl
               call k4ptdi(blb, nuelb, neelb, nuelb, uelb1, eelb1l,
     *         duelb, deelb, us, ale, ans)
               beg=exp(ans)*egmnl
         endif
      elseif(landau) then
         if(u .lt. ueh2) then
c              beg=exp( tdint4(be1, nueh1, neeh, ueh1, eeh1l, dueh1,
c    *         deelh, u,  ale)  ) * egmnh
               call k4ptdi(be1, nueh1, neeh, nueh1,  ueh1, eeh1l,
     *         dueh1, deelh, u,  ale, ans)
               beg=exp( ans ) *egmnh
         else
               us=sqrt(1.-u)
c              beg=   ( tdint4(be2, nueh2, neeh, ueh3, eeh1l, dueh2,
c    *         deelh, us,  ale)*(1.-u)+ sqrt(egmnh/ee) )**2 *ee
               call k4ptdi(be2, nueh2, neeh, nueh2,  ueh3, eeh1l,
     *         dueh2, deelh, us,  ale, ans)
               beg=  (ans*(1.-u) + sqrt(egmnh/ee) )**2*ee
         endif
      else
c               complete screening
          a=u*tp
          if(a .le. 1.) then
             v=exp(-a)
             if(a .gt. .1) then
                 v=((.06366*a-.1447407)*a+1.014176)*v
             endif
          else
             v=exp(-(a+0.8603)/1.3603)
             if(a .le. 6.) then
                 v=((((2.050445e-3*a-3.53209e-2)*a+.228937)*a-.684076)*a
     *           +1.841734)*v
             endif
          endif
          beg=ee*v
      endif
      return
c
c
c     ***********
      entry prccut(eg,t)
c     ***********
c
c
c
      if(eg .le. emass2) then
          t=1.e37
      elseif(eg .lt. eplmin .and. scorec) then
          tp=( (eg-emass2)/(eplmin-emass2) )**3 * tcpl(1)
          call rndc(u)
          t =-log(u)/tp
          landau=.false.
          screen=.true.
      else
          if(.not. usees) then
             esp=espin
          else
             esp=min(escp, eplmax)
          endif
          if(eg .gt. esp) then
              screen=.false.
              if(eg .gt. cep   .and. lcorec) then
                  landau=.true.
                  ale=log10(eg)
c                 tp=fintp3(tcph, egh1l, deghl, negh, ale)*rx0
                  call kintp3(tcph, 1, negh,  egh1l,  deghl,   ale, tp)
                  tp=tp*rx0
              else
                  landau=.false.
c                     complete screening cross-section
                  tp=ctpc
              endif
          else
              landau=.false.
              if(scorec) then
                  screen=.true.
                  ale=log10(eg)
c                 tp=fintp3(tcpl, etcpl1, deptcl, nptcl, ale)
                  call kintp3(tcpl, 1,nptcl,  etcpl1, deptcl,  ale, tp)
              else
                  screen=.false.
c                     complete screening cross-section
                  tp=ctpc
              endif
          endif
          call rndc(u)
          t =-log(u)/tp
      endif
      return
c
c
c     ***********
      entry prccue(eg,e1)
c     ***********
c
c
c
      call rndc(u)
      if(screen) then
c           partial screening
         if(u .ge. ugla1) then
c                   region a
c               e1=(tdint4(pla, nugla, negla, ugla1, egla1l, dugla,
c    *          degla, u,    ale) *(1.-u) + .5 )*eg
                call k4ptdi(pla, nugla, negla,nugla,  ugla1, egla1l,
     *          dugla, degla, u,   ale, ans)
                e1=(ans*(1.-u) + .5)*eg
         else
c                   region b
                us=sqrt(u)
                ex=sqrt(ale-eglb1l)
                call k4ptdi(plb, nuglb, neglb,nuglb,  uglb1, 0.d0,
     *          duglb, deglb, us,  ale, ans)
                e1=ans*eg
         endif
      elseif(landau) then
c        e1= tdint4(vp, nugh2, negh, ugh3, egh1l, dugh2,
c    *   deghl, u,  ale) * eg
         call k4ptdi(vp, nugh2, negh, nugh2, ugh3, egh1l,
     *   dugh2, deghl, u,  ale, ans)
         e1=ans*eg
      else
c                complete screening
         e1=(((.0441223*u-.173755)*u-.3708608)*u+1.)*eg
      endif
      return
c
c     ************
      entry emctcu(Knckon)
c     ************
c
c               cconst=for compton=3/8*thomson*n0*z/a*x0ing
c               to convert cross-section in compt into /(r.l).
      cconst=.8675
      x0=1.42
      x0ing=12.695
      x0sq=2.016
      if(Knckon) then
         ecrit=16.3e-3
      else
         ecrit=21.1e-3
      endif
c         moller scat
c            constm=.3*z/a*x0ing
      constm=1.739
      rho = 8.94
c
      zchrg=29.
      zchrg2 = 841.
      amassn=63.5
      ionizP = 314.05d-3
      end
