c     ************************ for bgo********************************
c     *                                                              *
c     *  brmbgot:  samples path for brems                             *
c     *  brmbgoe:  samples energy of brems gamma                      *
c     *  prcbgot:  samples path for pair creation                     *
c     *  prcbgoe:  samples energy of pair electron (higher energy)    *
c     *  emctbgo:  set const in common 
c     *                                                              *
c     *********************** tested 84.04.28 ********************k.k*
c
c     BGO is Bi4Ge3O12
c      material   z     a     rho     t0 (g/cm2)  t0 (cm)    ec
c         bgo    62.5 155.3    7.1     7.98        1.12       
c                                
c brems:
c        electron energy:      1mev to 300tev
c        brems gamma energy:   .1mev or more
c           if electron energy is < 1mev,  sampled path is set to be
c        very large one so that real brems may not take place before
c        the death by energy loss.
c pair:
c        gamma energy:         3mev to 300tev
c           if gamma energy is < 3mev, sampled path is set to be
c        very large one so that real pair creation may not take place
c        before compton or another process takes place.
c
c
c
c
c   /usage/          call brmbgot(ee,ec,t)
c                    call brmbgoe(ee,ec,beg)
c
c                    call prcbgot(eg,t)
c                    call prcbgoe(eg,e1)
c
c      ee:  incident electron energy
c      ec:  cut-off energy of brems gamma (used if complete screening
c           cross section is to be used).
c       t:  sampled path
c     beg:  sampled gamma energy
c      eg:  incident gamma energy
c      e1:  sampled electron energy (higher energy in pair)
c
c  *** note ***
c
c          before calling brmbgoe, brmbgot must have been called.
c          //             prcbgoe, prcbgot //
c
c          by the parameters in $elmag the user can control:
c
c        ee  -------------- 5gev------->  (if usees=t, escb instead 5)
c     scorec=t       p.s    !
c     lcorec=t              !    l.c
c     scorec=f       c.s    !
c     lcorec=f              !    c.s
c
c        eg  --------------50gev--5tev---> (if usees=t, escp instead 50)
c     scorec=t       p.s    ! c.s !
c     lcorec=t              ! c.s ! l.c
c     scorec=f       c.s    ! c.s !
c     lcorec=f              !     ! c.s
c
c
c
c
      subroutine brmbgot(ee,ec,t)
       implicit none
c
c
#include  "Zelmag.h"
#include  "Zemdef.h"
c
      integer i
      logical screen,landau
      save screen,landau
c
c
c
c
c ------------------------- partical screening ----------------------
c           *** electron ***
c
c           ! egmin (gev)  for brems.
      data egmnl/.1e-3/
c
      parameter (eblmin=1.e-3, eblmax=10.,  nbtcl=13)
      dimension tcbl(nbtcl)
c
c             brem:   region a
c
      parameter (eela1=eblmin, eela2=eblmax,neela=13,
     * uela1=.05, uela2=1., nuela=16, duela=(uela2-uela1)/(nuela-1) )
      dimension bla(nuela* neela)
c
c             brem:  region b  (sqrt(u))
      parameter (eelb1=eblmin, eelb2=eblmax, neelb=neela,
     * uelb1=0.,  uelb2=.2236068, nuelb=16,
     * duelb=(uelb2-uelb1)/(nuelb-1) )
      dimension blb(nuelb* neelb)
c           ** gamma ***
c
c                 total cross-section
      parameter (eplmin=3.e-3, eplmax=300., nptcl=16)
      dimension tcpl(nptcl)
c
c          pair: region a
      parameter ( egla1=eplmin,  egla2=eplmax, negla=16,
     *   ugla1=.05, ugla2=1., nugla=16,dugla=(ugla2-ugla1)/(nugla-1) )
      dimension pla(nugla* negla)
c
c            pair: region b     sqrt(log10(e)) sqrt(u)
      parameter (eglb1=eplmin, eglb2=eplmax, neglb=11,
     *  uglb1=0., uglb2=.2236068, nuglb=16,
     *  duglb=(uglb2-uglb1)/(nuglb-1))
      dimension plb(nuglb* neglb)
c
c
c      -------------------- landau ------------------------------
c
c          **** electron ****
c
      data egmnh/1.e-3/
      parameter ( eeh1=5., eeh2=300.e3, neeh=16,dueh1=.1,
     *  ueh1=0., ueh2=.7, nueh1=(ueh2-ueh1+.00001)/dueh1+1)
      dimension  tcbh(neeh)
      dimension  be1(nueh1* neeh)
c
c                         sqrt(1-.7)
      parameter (ueh3=0., ueh4=0.5477225,
     *nueh2=11, dvueh2=nueh2-1, dueh2=(ueh4 - ueh3)/dvueh2)
      dimension be2(nueh2*neeh)
c
c
c         *** gamma ****
c
      parameter ( egh1=5000., egh2=300.e3,negh=7, dugh2=.1,
     * ugh3=0., ugh4=1., nugh2=(ugh4-ugh3+.00001)/dugh2+1)
      dimension tcph(negh)
      dimension vp(nugh2 *negh)
c
c
c     ---------------------------------------------------------
c          table for BGO
c        <Z> = 62.8  <A>=156
      data debtcl/  .333333/
      data deela/  .333333/
      data deelb/  .333333/
      data deptcl/  .293573/
      data degla/  .293573/
      data deglb/  .187693/
c        electron energy=
c       .10000E-02  .21544E-02  .46416E-02  .10000E-01  .21544E-01
c       .46416E-01  .10000      .21544      .46416      1.0000    
c       2.1544      4.6416      10.000    
c       log10 step=   .3333
c
c      log10 of electron energy boundary
      data  etcbl1/-3.000000/
c    *     ,etcbl2/ 1.000000/
c
      data (tcbl(i),i=   1,  13)/
     1 1.6325, 2.9233, 3.9960, 5.0067, 6.0124, 7.0226, 8.0327, 9.0383,
     210.0387,11.0349,12.0279,13.0185,14.0080/
c
c       brem: region a
c        electron energy=
c       .10000E-02  .21544E-02  .46416E-02  .10000E-01  .21544E-01
c       .46416E-01  .10000      .21544      .46416      1.0000    
c       2.1544      4.6416      10.000    
c       log10 step=   .3333
c
c      log10 of electron energy boundary
      data  eela1l/-3.000000/
c    *     ,eela2l/ 1.000000/
c
c
c            bla(iu,ie)=alog(v/vmin)/(1.-u)
c            u= .050 to 1.000 step=  .0633
c            log10(e)= -3.0000 to   1.0000 step=  .3333
c
      data (bla(i),i=   1,  72)/
     1 1.4685, 1.3773, 1.3142, 1.2636, 1.2221, 1.1883, 1.1559, 1.1293,
     2 1.1068, 1.0845, 1.0622, 1.0446, 1.0275, 1.0054, 1.0022,  .9893,
     3 2.4664, 2.3043, 2.1975, 2.1191, 2.0596, 2.0084, 1.9682, 1.9336,
     4 1.9063, 1.8786, 1.8591, 1.8368, 1.8216, 1.8069, 1.7843, 1.7752,
     5 3.3456, 3.1683, 3.0565, 2.9794, 2.9201, 2.8710, 2.8339, 2.7977,
     6 2.7692, 2.7447, 2.7269, 2.7069, 2.6925, 2.6827, 2.6654, 2.6556,
     7 4.2069, 4.0344, 3.9272, 3.8490, 3.7913, 3.7478, 3.7117, 3.6825,
     8 3.6598, 3.6406, 3.6252, 3.6124, 3.5989, 3.5980, 3.5775, 3.5775,
     9 5.0526, 4.8854, 4.7787, 4.7033, 4.6499, 4.6106, 4.5804, 4.5574/
      data (bla(i),i=  73, 144)/
     1 4.5401, 4.5229, 4.5106, 4.5027, 4.4959, 4.4854, 4.4815, 4.4809,
     2 5.8775, 5.7105, 5.6044, 5.5332, 5.4829, 5.4474, 5.4214, 5.4019,
     3 5.3890, 5.3773, 5.3700, 5.3622, 5.3558, 5.3519, 5.3438, 5.3476,
     4 6.6819, 6.5127, 6.4060, 6.3363, 6.2908, 6.2585, 6.2375, 6.2199,
     5 6.2106, 6.1995, 6.1933, 6.1879, 6.1853, 6.1837, 6.1759, 6.1808,
     6 7.4687, 7.2935, 7.1858, 7.1193, 7.0783, 7.0482, 7.0301, 7.0168,
     7 7.0086, 7.0008, 6.9979, 6.9932, 6.9932, 6.9899, 6.9834, 6.9890,
     8 8.2424, 8.0600, 7.9525, 7.8898, 7.8512, 7.8254, 7.8107, 7.7998,
     9 7.7948, 7.7900, 7.7880, 7.7840, 7.7841, 7.7759, 7.7888, 7.7805/
      data (bla(i),i= 145, 208)/
     1 9.0064, 8.8161, 8.7134, 8.6527, 8.6184, 8.5982, 8.5834, 8.5777,
     2 8.5728, 8.5691, 8.5639, 8.5636, 8.5584, 8.5572, 8.5701, 8.5618,
     3 9.7639, 9.5695, 9.4679, 9.4134, 9.3811, 9.3652, 9.3520, 9.3473,
     4 9.3422, 9.3403, 9.3395, 9.3354, 9.3363, 9.3343, 9.3465, 9.3369,
     510.5182,10.3205,10.2219,10.1719,10.1445,10.1293,10.1210,10.1156,
     610.1132,10.1113,10.1099,10.1063,10.1089,10.1072,10.1150,10.1083,
     711.2713,11.0706,10.9774,10.9297,10.9069,10.8943,10.8851,10.8817,
     810.8818,10.8804,10.8795,10.8811,10.8755,10.8754,10.8722,10.8777/
c
c       brem: region b
c        electron energy=
c       .10000E-02  .21544E-02  .46416E-02  .10000E-01  .21544E-01
c       .46416E-01  .10000      .21544      .46416      1.0000    
c       2.1544      4.6416      10.000    
c       log10 step=   .3333
c
c      log10 of electron energy boundary
      data  eelb1l/-3.000000/
c    *     ,eelb2l/ 1.000000/
c
c
c            blb(iu,ie)=alog(v/vmin)/(1.-u)
c            sqrt(u)= .000 to  .224 step=  .0149
c            log10(e)= -3.0000 to   1.0000 step=  .3333
c
      data (blb(i),i=   1,  72)/
     1 1.5872, 1.5850, 1.5828, 1.5781, 1.5703, 1.5608, 1.5496, 1.5366,
     2 1.5235, 1.5085, 1.4916, 1.4744, 1.4551, 1.4355, 1.4155, 1.3950,
     3 2.7994, 2.7916, 2.7749, 2.7502, 2.7229, 2.6933, 2.6622, 2.6302,
     4 2.5960, 2.5629, 2.5275, 2.4920, 2.4552, 2.4184, 2.3815, 2.3432,
     5 3.7210, 3.7035, 3.6761, 3.6473, 3.6171, 3.5838, 3.5494, 3.5137,
     6 3.4768, 3.4371, 3.3971, 3.3555, 3.3134, 3.2696, 3.2237, 3.1789,
     7 4.5527, 4.5331, 4.5087, 4.4821, 4.4538, 4.4224, 4.3888, 4.3530,
     8 4.3157, 4.2745, 4.2329, 4.1894, 4.1440, 4.0964, 4.0464, 3.9972,
     9 5.3487, 5.3310, 5.3116, 5.2881, 5.2620, 5.2330, 5.2020, 5.1665/
      data (blb(i),i=  73, 144)/
     1 5.1297, 5.0903, 5.0479, 5.0023, 4.9545, 4.9058, 4.8546, 4.8007,
     2 6.1292, 6.1154, 6.0990, 6.0787, 6.0549, 6.0283, 5.9977, 5.9650,
     3 5.9276, 5.8887, 5.8457, 5.7994, 5.7509, 5.6984, 5.6430, 5.5843,
     4 6.9026, 6.8928, 6.8774, 6.8593, 6.8377, 6.8124, 6.7832, 6.7508,
     5 6.7150, 6.6742, 6.6291, 6.5806, 6.5281, 6.4712, 6.4109, 6.3485,
     6 7.6729, 7.6651, 7.6512, 7.6356, 7.6152, 7.5901, 7.5621, 7.5289,
     7 7.4910, 7.4480, 7.4005, 7.3479, 7.2924, 7.2307, 7.1648, 7.0960,
     8 8.4417, 8.4339, 8.4240, 8.4075, 8.3881, 8.3631, 8.3331, 8.2988,
     9 8.2586, 8.2131, 8.1628, 8.1058, 8.0439, 7.9778, 7.9055, 7.8311/
      data (blb(i),i= 145, 208)/
     1 9.2098, 9.2039, 9.1941, 9.1786, 9.1583, 9.1322, 9.1012, 9.0635,
     2 9.0208, 8.9713, 8.9166, 8.8560, 8.7884, 8.7160, 8.6379, 8.5569,
     3 9.9776, 9.9717, 9.9619, 9.9474, 9.9261, 9.8990, 9.8657, 9.8257,
     4 9.7792, 9.7254, 9.6659, 9.5998, 9.5275, 9.4496, 9.3651, 9.2767,
     510.7453,10.7414,10.7315,10.7141,10.6917,10.6635,10.6268,10.5842,
     610.5348,10.4766,10.4120,10.3415,10.2625,10.1784,10.0885, 9.9923,
     711.5129,11.5089,11.4991,11.4816,11.4572,11.4268,11.3878,11.3414,
     811.2879,11.2261,11.1562,11.0794,10.9963,10.9057,10.8079,10.7078/
c
c       pair: total x-section
c        gamm energy=
c       .30000E-02  .58979E-02  .11595E-01  .22795E-01  .44814E-01
c       .88102E-01  .17321      .34051      .66943      1.3161    
c       2.5873      5.0866      10.000    
c       log10 step=   .2936
c
c      log10 of gamma energy boundary
      data  etcpl1/-2.522879/
c    *     ,etcpl2/ 1.000000/
c
      data (tcpl(i),i=   1,  13)/
     1  .0262,  .1200,  .2277,  .3381,  .4447,  .5370,  .6054,  .6522,
     2  .6826,  .7017,  .7133,  .7202,  .7242/
c
c       pair: region a
c
c         energy of gamma=
c         .300E-02    .590E-02    .116E-01    .228E-01    .448E-01
c         .881E-01    .173        .341        .669        1.32    
c         2.59        5.09        10.0    
c         log10 step=  .293573
c
c         log10 of eg boundary
      data  egla1l/-2.522879/
c    *     ,egla2l/ 1.000000/
c
c
c         pla(iu,ie)=(v-.5)/(1.-u)
c         u= .050 to1.000   step=  .0633
c            log10(e)= -2.5229 to   1.0000 step=  .2936
c
      data (pla(i),i=   1,  72)/
     1  .2027,  .1968,  .1932,  .1906,  .1872,  .1855,  .1836,  .1824,
     2  .1808,  .1805,  .1799,  .1792,  .1779,  .1754,  .1779,  .1772,
     3  .3595,  .3455,  .3378,  .3320,  .3285,  .3257,  .3222,  .3211,
     4  .3196,  .3176,  .3174,  .3171,  .3166,  .3155,  .3123,  .3150,
     5  .4152,  .4042,  .3986,  .3943,  .3918,  .3888,  .3882,  .3875,
     6  .3867,  .3855,  .3867,  .3849,  .3867,  .3831,  .3867,  .3849,
     7  .4463,  .4382,  .4333,  .4314,  .4305,  .4293,  .4296,  .4299,
     8  .4303,  .4308,  .4315,  .4326,  .4296,  .4308,  .4345,  .4320,
     9  .4646,  .4590,  .4561,  .4552,  .4555,  .4573,  .4579,  .4586/
      data (pla(i),i=  73, 144)/
     1  .4617,  .4608,  .4626,  .4652,  .4646,  .4633,  .4746,  .4660,
     2  .4770,  .4730,  .4730,  .4744,  .4759,  .4793,  .4818,  .4848,
     3  .4866,  .4890,  .4923,  .4934,  .4953,  .4991,  .4953,  .4971,
     4  .4849,  .4845,  .4876,  .4911,  .4940,  .4974,  .5016,  .5068,
     5  .5091,  .5122,  .5166,  .5193,  .5237,  .5250,  .5288,  .5244,
     6  .4914,  .4936,  .4984,  .5028,  .5080,  .5127,  .5184,  .5236,
     7  .5282,  .5317,  .5365,  .5400,  .5406,  .5419,  .5457,  .5451,
     8  .4963,  .5009,  .5063,  .5113,  .5172,  .5227,  .5294,  .5340,
     9  .5400,  .5453,  .5496,  .5523,  .5568,  .5581,  .5620,  .5598/
      data (pla(i),i= 145, 208)/
     1  .4997,  .5046,  .5114,  .5168,  .5232,  .5308,  .5367,  .5421,
     2  .5492,  .5534,  .5593,  .5604,  .5675,  .5662,  .5624,  .5699,
     3  .5025,  .5081,  .5152,  .5208,  .5276,  .5356,  .5420,  .5481,
     4  .5538,  .5587,  .5626,  .5684,  .5729,  .5741,  .5780,  .5764,
     5  .5026,  .5104,  .5164,  .5235,  .5305,  .5373,  .5439,  .5502,
     6  .5561,  .5640,  .5689,  .5723,  .5781,  .5820,  .5781,  .5804,
     7  .5047,  .5115,  .5189,  .5248,  .5319,  .5389,  .5456,  .5522,
     8  .5583,  .5640,  .5689,  .5762,  .5782,  .5820,  .5782,  .5829/
c
c
c       pair: region b
c
c         energy of gamma=
c         .300E-02    .325E-02    .415E-02    .623E-02    .110E-01
c         .228E-01    .556E-01    .160        .539        2.14    
c         10.0    
c         sqrt(log10) step=  .187693
c
c         use 0 for e-side at interpolation
c         with sqrt(log10(e)-eglb1l)
      data  eglb1l/-2.522879/
c
c
c         plb(iu,ie)=v
c         sqrt(u)= .000 to .224   step=  .0149
      data (plb(i),i=   1,  72)/
     1  .8297,  .7080,  .7080,  .7080,  .7080,  .7067,  .7054,  .7054,
     2  .7041,  .7028,  .7015,  .7002,  .6977,  .6964,  .6951,  .6925,
     3  .8429,  .7458,  .7458,  .7458,  .7445,  .7431,  .7431,  .7418,
     4  .7391,  .7378,  .7364,  .7338,  .7324,  .7297,  .7271,  .7244,
     5  .8769,  .8246,  .8231,  .8217,  .8202,  .8187,  .8172,  .8143,
     6  .8114,  .8084,  .8055,  .8025,  .7996,  .7952,  .7922,  .7893,
     7  .9179,  .8959,  .8942,  .8910,  .8894,  .8861,  .8828,  .8796,
     8  .8747,  .8714,  .8681,  .8632,  .8600,  .8551,  .8518,  .8469,
     9  .9535,  .9455,  .9420,  .9384,  .9349,  .9331,  .9296,  .9243/
      data (plb(i),i=  73, 144)/
     1  .9207,  .9172,  .9136,  .9101,  .9048,  .9012,  .8959,  .8924,
     2  .9776,  .9729,  .9711,  .9673,  .9655,  .9617,  .9580,  .9543,
     3  .9524,  .9487,  .9449,  .9412,  .9375,  .9323,  .9286,  .9239,
     4  .9908,  .9879,  .9860,  .9841,  .9822,  .9784,  .9764,  .9726,
     5  .9707,  .9668,  .9630,  .9611,  .9568,  .9529,  .9491,  .9453,
     6  .9968,  .9958,  .9939,  .9919,  .9900,  .9881,  .9861,  .9842,
     7  .9803,  .9784,  .9764,  .9725,  .9706,  .9672,  .9633,  .9604,
     8  .9991,  .9981,  .9981,  .9961,  .9942,  .9922,  .9922,  .9903,
     9  .9883,  .9864,  .9844,  .9805,  .9786,  .9766,  .9732,  .9703/
      data (plb(i),i= 145, 176)/
     1  .9998,  .9988,  .9988,  .9988,  .9968,  .9949,  .9949,  .9929,
     2  .9910,  .9890,  .9871,  .9851,  .9832,  .9812,  .9793,  .9758,
     3  .9999,  .9990,  .9990,  .9990,  .9970,  .9970,  .9951,  .9951,
     4  .9931,  .9912,  .9892,  .9892,  .9853,  .9833,  .9814,  .9794/
c    --------------------------
c     LPM region
c  media=BGO  z= 62.80 a=156.00 rho= 7.10    
c 0*** constant used in landau effect
c z=  62.80 a= 156.00 rho=   7.10 x0=  1.023cm=  7.263g/cm**2  s1= .472E-03
c  ln(s1)=-7.66      const in eq.60 of migdal= 981.    
c gamma cut off energy = .100E-02gev
      data deelh/  .240137/
      data deghl/  .100343/
c
c          energy of electron
c        5.000       8.692       15.11       26.27       45.66    
c        79.37       138.0       239.8       416.9       724.8    
c        1260.       2190.       3807.       6618.       .1151E+05
c        .2000E+05
c         log10 step=  .240137
c
c         log10 of electron energy boundary
      data eeh1l/  .698970/
c    *     ,eeh2l/ 4.301030/
c
      data (tcbh(i),i=   1,  16)/
     1 10.3591, 10.6336, 10.6059, 10.3314,  9.8857,  9.3272,  8.6986,
     2  8.0303,  7.3398,  6.6406,  5.9436,  5.2590,  4.5968,  3.9675,
     3  3.3817,  2.8449/
c
c          be1(iu,ie)= alog(v/vmin)
c          from u= .000 to  .700 step= .100
c          from log10(e)=   .6990 to  4.3010 step   .2401
c          dim. of u=  8 dim of e= 16
c
      data (   be1(i),i=   1,  54)/
     1  8.51719,  7.40250,  6.45942,  5.61508,  4.80821,  4.01915,
     2  3.23286,  2.45861,  9.07013,  7.92810,  6.96630,  6.10338,
     3  5.27712,  4.46588,  3.66593,  2.87874,  9.62307,  8.48399,
     4  7.52338,  6.66251,  5.83873,  5.02918,  4.24171,  3.44319,
     5 10.17600,  9.06395,  8.12285,  7.28108,  6.47301,  5.69090,
     6  4.92260,  4.11846, 10.72894,  9.66185,  8.75255,  7.93994,
     7  7.16498,  6.42182,  5.67329,  4.86999, 11.28188, 10.27133,
     8  9.40113,  8.62463,  7.89624,  7.19077,  6.46688,  5.66986,
     9 11.83481, 10.88918, 10.06458,  9.33051,  8.65080,  7.98257/
      data (   be1(i),i=  55, 108)/
     1  7.28255,  6.49774, 12.38775, 11.51248, 10.73377, 10.05333,
     2  9.41776,  8.78247,  8.10728,  7.33651, 12.94069, 12.13772,
     3 11.41359, 10.78362, 10.18843,  9.58496,  8.93301,  8.17765,
     4 13.49362, 12.76621, 12.10047, 11.51711, 10.95584, 10.38058,
     5  9.74998,  9.01071, 14.04656, 13.39455, 12.78927, 12.24721,
     6 11.71714, 11.16525, 10.55563,  9.83201, 14.59950, 14.02500,
     7 13.47692, 12.96946, 12.46743, 11.93860, 11.34513, 10.63766,
     8 15.15243, 14.65310, 14.15784, 13.68320, 13.20371, 12.69332,
     9 12.11724, 11.42283, 15.70537, 15.27744, 14.83127, 14.38429/
      data (   be1(i),i= 109, 128)/
     1 13.92647, 13.43202, 12.86981, 12.18701, 16.25831, 15.89421,
     2 15.49278, 15.07224, 14.63324, 14.15265, 13.60263, 12.93012,
     3 16.81124, 16.50317, 16.14222, 15.74553, 15.32057, 14.85219,
     4 14.31282, 13.65038/
c
c         be2(iu,ie)= (sqrt(v) -sqrtv)/(1.-u)
c          from sqrt(1-u)= .000 to  .548 step=  .055
c          from log10(e)=  .698970 to 4.301030 step   .2401
c
      data (   be2(i),i=   1,  63)/
     1   .0694,   .0683,   .0706,   .0721,   .0741,   .0770,   .0809,
     2   .0861,   .0928,   .1019,   .1140,   .0738,   .0751,   .0751,
     3   .0764,   .0783,   .0811,   .0847,   .0895,   .0958,   .1040,
     4   .1151,   .0831,   .0830,   .0842,   .0859,   .0879,   .0908,
     5   .0946,   .0994,   .1057,   .1139,   .1246,   .0966,   .0967,
     6   .0979,   .0995,   .1019,   .1052,   .1093,   .1144,   .1212,
     7   .1297,   .1407,   .1139,   .1142,   .1158,   .1175,   .1203,
     8   .1241,   .1288,   .1344,   .1417,   .1509,   .1625,   .1351,
     9   .1357,   .1373,   .1398,   .1432,   .1476,   .1529,   .1593/
      data (   be2(i),i=  64, 126)/
     1   .1673,   .1773,   .1897,   .1601,   .1612,   .1632,   .1666,
     2   .1707,   .1758,   .1819,   .1892,   .1981,   .2088,   .2222,
     3   .1893,   .1907,   .1936,   .1980,   .2031,   .2090,   .2160,
     4   .2243,   .2341,   .2457,   .2599,   .2224,   .2243,   .2286,
     5   .2341,   .2404,   .2474,   .2554,   .2645,   .2751,   .2878,
     6   .3029,   .2594,   .2625,   .2683,   .2754,   .2828,   .2908,
     7   .2998,   .3097,   .3212,   .3346,   .3504,   .2999,   .3043,
     8   .3124,   .3210,   .3297,   .3388,   .3486,   .3594,   .3718,
     9   .3860,   .4023,   .3476,   .3502,   .3606,   .3706,   .3805/
      data (   be2(i),i= 127, 176)/
     1   .3908,   .4016,   .4132,   .4260,   .4405,   .4576,   .4004,
     2   .4014,   .4121,   .4235,   .4346,   .4456,   .4569,   .4691,
     3   .4824,   .4976,   .5147,   .4556,   .4559,   .4656,   .4783,
     4   .4901,   .5020,   .5141,   .5267,   .5403,   .5555,   .5727,
     5   .5119,   .5120,   .5206,   .5337,   .5464,   .5587,   .5712,
     6   .5843,   .5980,   .6132,   .6302,   .5677,   .5678,   .5743,
     7   .5880,   .6011,   .6141,   .6267,   .6398,   .6534,   .6687,
     8   .6855/
c
c
c         energy of gamma
c        5000.       6300.       7937.       .1000E+05   .1260E+05
c        .1587E+05   .2000E+05
c       log10 step=  .100343
c
c       log10 of gamma energy boundary
      data egh1l/ 3.698970/
c    *     ,egh1l/ 4.301030/
c
      data (tcph(i),i=   1,   7)/
     1   .7787,   .7808,   .7803,   .7797,   .7787,   .7739,   .7659/
c
c        table of v
c        from u=  .0000 to  1.0000 step   .1000
c        from log10(e)= 3.698970 to 4.301030 step   .1003
c
      data (   vp(i),i=   1,  72)/
     1 1.0000,  .9604,  .9175,  .8735,  .8276,  .7778,  .7271,  .6714,
     2  .6167,  .5591,  .5000, 1.0000,  .9595,  .9175,  .8735,  .8267,
     3  .7769,  .7251,  .6714,  .6147,  .5571,  .5000, 1.0000,  .9595,
     4  .9185,  .8735,  .8267,  .7778,  .7251,  .6714,  .6167,  .5581,
     5  .5000, 1.0000,  .9604,  .9185,  .8735,  .8267,  .7778,  .7251,
     6  .6724,  .6157,  .5581,  .5000, 1.0000,  .9604,  .9185,  .8735,
     7  .8267,  .7788,  .7261,  .6724,  .6157,  .5591,  .5000, 1.0000,
     8  .9604,  .9185,  .8745,  .8286,  .7798,  .7280,  .6743,  .6177,
     9  .5591,  .5000, 1.0000,  .9604,  .9194,  .8765,  .8306,  .7817/
      data (   vp(i),i=  73,  77)/
     1  .7310,  .6763,  .6196,  .5601,  .5000/


c
c       total prob. equivalenced to common
c
      equivalence (tprob,tp)
c

c
c                         complete screening pair x-sxec.
c                         0.7242=(7/9-b)*rx0 =.773*rx0
      data rx0/0.934/, ctpc/.724/,  cep/5.e3/
c       rx0=x0(true)/x0(in nishimura text)=5.82/6.4
c       cep:  minimum energy for landau correction for pair.
c          default esbc espc
      data esbin/5./,  espin/50./
c
c
      if(ee .lt. eblmin) then
          t=1.e36
      else
          if(.not. usees) then
             esb=esbin
          else
             esb=min(escb, eblmax)
          endif
          if(ee .gt. esb) then
              screen=.false.
              if(lcorec .and. ee .gt. eeh1) then
                  if(ee .gt. eeh2) then
                       write(6,'('' ee > eeh2 in brmbgot: ee='',g12.4)')
     *                 ee
                       stop
                  endif
                  landau=.true.
                  ale=log10(ee)
c                 tp=fintp3(tcbh, eeh1l, deelh, neeh, ale)*rx0
                  call kintp3(tcbh, 1, neeh, eeh1l, deelh, ale, tp)
                  tp=tp*rx0
              else
                  landau=.false.
c                     complete screening cross-section
                  vc=ec/ee
                  tp=(-1.3603*(log(vc)-vc)-vc*vc*.5-.8603 )*rx0
              endif
          else
              landau=.false.
              if(scorec) then
                  screen=.true.
                  ale=log10(ee)
c                 tp=fintp3(tcbl, etcbl1, debtcl, nbtcl,  ale)
                  call kintp3(tcbl, 1, nbtcl, etcbl1, debtcl,  ale, tp)
              else
                  screen=.false.
c                     complete screening cross-section
                  vc=ec/ee
                  tp=(-1.3603*(log(vc)-vc)-vc*vc*.5-.8603 )*rx0
              endif
          endif
c
          call rndc(u)
          t =-log(u)/tp
      endif
      return
c
c     ************
      entry brmbgoe(ee,ec,beg)
c     ************
c
      call rndc(u)
      if(screen) then
c           partial screening
         if(u .gt. uela1) then
c                  region a
c              beg=exp( tdint4(bla, nuela, neela, uela1, eela1l, duela,
c    *         deela, u,  ale)*(1.-u) ) *egmnl
               call k4ptdi(bla, nuela, neela, nuela, uela1, eela1l,
     *         duela, deela, u, ale, ans)
               beg=exp( ans*(1.-u))*egmnl
         else
c                  region b
               us=sqrt(u)
c              beg=exp( tdint4(blb, nuelb, neelb, uelb1, eelb1l,duelb,
c    *         deelb, us, ale)) * egmnl
               call k4ptdi(blb, nuelb, neelb, nuelb, uelb1, eelb1l,
     *         duelb, deelb, us, ale, ans)
               beg=exp(ans)*egmnl
         endif
      elseif(landau) then
         if(u .lt. ueh2) then
c              beg=exp( tdint4(be1, nueh1, neeh, ueh1, eeh1l, dueh1,
c    *         deelh, u,  ale)  ) * egmnh
               call k4ptdi(be1, nueh1, neeh, nueh1,  ueh1, eeh1l,
     *         dueh1, deelh, u,  ale, ans)
               beg=exp( ans ) *egmnh
         else
               us=sqrt(1.-u)
c              beg=   ( tdint4(be2, nueh2, neeh, ueh3, eeh1l, dueh2,
c    *         deelh, us,  ale)*(1.-u)+ sqrt(egmnh/ee) )**2 *ee
               call k4ptdi(be2, nueh2, neeh, nueh2,  ueh3, eeh1l,
     *         dueh2, deelh, us,  ale, ans)
               beg=  (ans*(1.-u) + sqrt(egmnh/ee) )**2*ee
         endif
      else
c               complete screening
          a=u*tp
          if(a .le. 1.) then
             v=exp(-a)
             if(a .gt. .1) then
                 v=((.06366*a-.1447407)*a+1.014176)*v
             endif
          else
             v=exp(-(a+0.8603)/1.3603)
             if(a .le. 6.) then
                 v=((((2.050445e-3*a-3.53209e-2)*a+.228937)*a-.684076)*a
     *           +1.841734)*v
             endif
          endif
          beg=ee*v
      endif
      return
c
c
c     ***********
      entry prcbgot(eg,t)
c     ***********
c
c
c
      if(eg .le. emass2) then
          t=1.e37
      elseif(eg .lt. eplmin .and. scorec) then
          tp=( (eg-emass2)/(eplmin-emass2) )**3 * tcpl(1)
          call rndc(u)
          t =-log(u)/tp
          landau=.false.
          screen=.true.
      else
          if(.not. usees) then
             esp=espin
          else
             esp=min(escp, eplmax)
          endif
          if(eg .gt. esp) then
              screen=.false.
              if(eg .gt. cep   .and. lcorec) then
                  landau=.true.
                  ale=log10(eg)
c                 tp=fintp3(tcph, egh1l, deghl, negh, ale)*rx0
                  call kintp3(tcph, 1, negh,  egh1l,  deghl,   ale, tp)
                  tp=tp*rx0
              else
                  landau=.false.
c                     complete screening cross-section
                  tp=ctpc
              endif
          else
              landau=.false.
              if(scorec) then
                  screen=.true.
                  ale=log10(eg)
c                 tp=fintp3(tcpl, etcpl1, deptcl, nptcl, ale)
                  call kintp3(tcpl, 1,nptcl,  etcpl1, deptcl,  ale, tp)
              else
                  screen=.false.
c                     complete screening cross-section
                  tp=ctpc
              endif
          endif
          call rndc(u)
          t =-log(u)/tp
      endif
      return
c
c
c     ***********
      entry prcbgoe(eg,e1)
c     ***********
c
c
c
      call rndc(u)
      if(screen) then
c           partial screening
         if(u .ge. ugla1) then
c                   region a
c               e1=(tdint4(pla, nugla, negla, ugla1, egla1l, dugla,
c    *          degla, u,    ale) *(1.-u) + .5 )*eg
                call k4ptdi(pla, nugla, negla,nugla,  ugla1, egla1l,
     *          dugla, degla, u,   ale, ans)
                e1=(ans*(1.-u) + .5)*eg
         else
c                   region b
                us=sqrt(u)
                ex=sqrt(ale-eglb1l)

                call k4ptdi(plb, nuglb, neglb,nuglb,  uglb1, 0.d0,
     *          duglb, deglb, us,  ale, ans)
                e1=ans*eg
         endif
      elseif(landau) then
c        e1= tdint4(vp, nugh2, negh, ugh3, egh1l, dugh2,
c    *   deghl, u,  ale) * eg
         call k4ptdi(vp, nugh2, negh, nugh2, ugh3, egh1l,
     *   dugh2, deghl, u,  ale, ans)
         e1=ans*eg
      else
c                complete screening
         e1=(((.0441223*u-.173755)*u-.3708608)*u+1.)*eg
      endif
      return
c
c     ************
      entry emctbgo(Knckon)
c     ************
c
c               cconst=for compton=3/8*thomson*n0*z/a*x0ing
c               to convert cross-section in compt into /(r.l).
      cconst=.4398
c         these are diff. from PDT, but is adjusted by rx0 
      x0= 1.023
      x0ing= 7.263
      x0sq=1.0
c         ecrit is not used.
      if(Knckon) then
         ecrit=8.0e-3
      else
         ecrit=9.1e-3
      endif
c         moller scat
      constm=.877
c
      rho = 7.1
      zchrg=62.5
      zchrg2 = 4809.73
      amassn=155.38
      ionizP = 484.46d-9
      end
