c
c           initialize xsection calculation.
c
c
      subroutine epixsec(media)
      implicit none
#include "Zmedia.h"
c
      record /epmedia/media   ! in/out.  
c
c       After this, we can use the table as follows.
c      Given a hadron projectile particle, get hp cross-section,
c      shp (may be better to use average of hp and hn xsec).
c      
c      Find i such that  i =( shp - xsecmin)/xsecstep 
c      If i<0 --> i=0, If i>nxsec-2, i = nxsec-2
c      get sigma =
c        ( media.sigma(i+2)- media.sigma(i+1))(shp-(xsecmin+i*xsecstep))
c           + media.sigma(i+1)
c      get media.mfp = 1./( sigma /cm2Tomb* media.ndenisty) (in cm)
c
c      To fix the target element, 
c         sample u, for a given i fixed as above find j such that
c         u <=  cumsigma(j, i) 
c         Then, media.elem(j) is the  target element.
c      
      real*8 shp
      integer i, j


      do j = 1, media.noOfElem
         shp = xsecmin          ! (say 10mb)
         do i = 1, nxsec
            call cxp2xAXsec(media.elem(j).A, shp,
     *                      media.elem(j).sigma(i))
            shp = shp + xsecstep
         enddo
      enddo


      do i = 1, nxsec
         media.sigma(i) = 0.
         do j = 1, media.noOfElem
            media.sigma(i) = media.sigma(i) + 
     *         media.No(j)* media.elem(j).sigma(i)
         enddo
      enddo

      do i = 1, nxsec
         do j = 1, media.noOfElem
            media.cumsigma(j, i) =
     *           media.No(j)*media.elem(j).sigma(i)/
     *           media.sigma(i)
         enddo
      enddo

      do i = 1, nxsec
         do j = 2, media.noOfElem
            media.cumsigma(j, i) = 
     *        media.cumsigma(j, i) + media.cumsigma(j-1, i)
         enddo
c          for the safety
         media.cumsigma(media.noOfElem, i) = 1.0
      enddo
c  &&&&&&
c      write(*,*) ' name=',media.name
c      do i = 1, nxsec
c         write(*,*) ' media.sigma=', media.sigma(i)
c         write(*,*) (media.cumsigma(j, i), j=1,media.noOfElem)
c      enddo
c  &&&&&&
      end

      subroutine epgetxs(model, pj, media, xs, icon)
      implicit none
#include "Zptcl.h"
#include "Zcode.h"
#include "Zmedia.h"
#include "ZepTrackp.h"
c   
      character*16 model    ! input. Active interaction model.
      record /ptcl/ pj      ! input.  a particle (non Heavy)
      record /epmedia/ media  ! input/output    media.mbindex is output
      real*8 xs             ! output. obtained cross-section for the
                            !  media. in mb
      integer icon          !  0. xs is obtained.
                            !  -1. xs is almost 0
                            !  1,  xs is almost infinity
                            !  2,  heavy particle so you must get it
                            !  by different method. (for gheisha and
                            !  charge <=2, 0 is put)

      character*120 msg
      logical useInt2   ! historical name.  
      integer ka, i,  ica, jcon, ia
      real*8 ke, s, tga, tgz, u
      real*8  eps/0.001/
      logical conv2A
      
      

      tga = media.A      !  version 7 or later not Aeff
      tgz = media.Z
      ke = pj.fm.p(4) - pj.mass         
      ka = pj.code
      ica = pj.charge

      conv2A  = .true.   ! If T, xs is xp so we have to convert xA later
c
c      calculate  get hp cross-section, xs.
c      (may be better to use average of hp and hn xsec).
c
c      Find i (mbindex) such that  i =( xs - xsecmin)/xsecstep 
c      If i<0 --> i=0, If i>nxsec-2, i = nxsec-2
c      get sigma =
c        ( media.sigma(i+2)- media.sigma(i+1))(xs-(xsecmin+i*xsecstep))
c           + media.sigma(i+1)
c      get media.mfp = 1./( sigma /cm2Tomb* media.ndenisty) (in cm)
c
c      To fix the target element, 
c         sample u, for a given i fixed above find j such that
c         u <=  cumsigma(j, i) 
c         Then, media.elem(j) is the  target element.
c
c      useInt2=T means use Xsection supplied by the
c         respective code. or total xsec is needed
c
      useInt2 = model .eq. 'gheisha' .or.
     *          model .eq. 'dpmjet3' .or.
     *          model .eq. 'qgsjet2'


      if(useInt2) then
         if(ka .eq. kneumu .or. ka .eq. kneue) then
            useInt2 = .false.
         elseif(ka .eq. kmuon) then
            useInt2 = .false.
         elseif(ka .eq. keta ) then
            useInt2 = .false.
         elseif(ka .eq. kgnuc) then
            if(model .eq. 'dpmjet3') then
               useInt2 = .false.
            elseif(model .ne. 'qgsjet2' .and. ica .ge. 2) then
               useInt2 = .false.
            endif
         elseif(ka .ge.  kalfa .and. ka .le. khvymax) then
            useInt2 = .false.
         elseif(ka .ge. klambda ) then
            useInt2 = .false.
         endif
      endif

      icon = 0

      if(useInt2 .and. model .eq. 'dpmjet3' ) then
         useInt2 = ke  .lt.  5.0d0
c                     danger 5.0 is fixed &&&&&&&&&&
      endif

      if( useInt2 .and. model .eq. 'qgsjet2' ) then
c            this is for A target;
         ia = tga
         call rndc(u)
         if(u .lt.  tga - ia ) then
            ia = min(ia + 1, 209)
         endif
         call cxsecQGS(pj, ia, xs)
         conv2A = .false.
      elseif(useInt2 .and. model .eq. 'dpmjet3') then
c          use total X-section; target is A
         call ctotx(pj, tga,  xs)
         conv2A = .false.
      elseif(useInt2 .and. model .eq. 'gheisha') then
c          Gheisha should be used for collisions
c          it include elastic scattering;
c          so we use different cross-sections.
c          target is A
         call cxsecGheisha(pj, tga,  tgz, xs)
         conv2A = .false.
      else
         if(ka .eq. kpion .or. ka .eq. keta) then
            if(ica .ge. 0) then ! pi+, 0.
               call cpiPluspXsec(ke, xs)
            else
               call cpiMinuspXsec(ke, xs)
            endif
         elseif (ka .eq. kkaon) then
            if(ica .ge. 0) then
               call ckPluspXsec(ke, xs)
            else
               call ckMinuspXsec(ke, xs)
            endif
         elseif (ka .eq. kmuon) then
c             muon interaction is treaed later.  
            xs = 1
         elseif (ka .eq. knuc) then
           if(pj.subcode .eq. antip) then
               if(ke .gt. eps) then
                  call cpbarpXsec(ke, xs)
               else
                  icon = 1
               endif
            else
               call cppXsec(ke, xs)
            endif
         elseif(ka .eq. kgnuc ) then
            icon = 2    ! must be evaluated later
         elseif(ka .eq. kneumu) then
            icon = -1
         elseif(ka .eq. kneue) then
            icon = -1
         elseif(ka .eq. kdmes) then
C            d meson; use mean free path for kaon
            call ckPluspXsec(ke, xs)
         elseif (ka .eq. knnb) then
c             nn~ instant decay
            icon = -1
         elseif (ka .eq. kddb) then
c           dd~ instant decay. xs =0
            icon = -1
         elseif (ka .eq. kgzai .or. ka .eq. ksigma .or.
     *     ka .eq. kbomega    ) then
c               use proton x-section
            call cppXsec(ke, xs)
         elseif ( ka .eq.  klambda .or. ka .eq. klambdac) then
c               use proton x-section
            call cppXsec(ke, xs)
         else
            write(msg,*) ' epgetmfp:  strange ptcl: ka=',ka
            call cerrorMsg(msg, 0)
         endif
      endif

      if( icon .eq. 0) then
         if( .not. conv2A ) then
c                 |   |   |   |  ...   |   |
c             xs   xs                        xs
c      jcon =  0   0                         1
c       i      0   1                         nxsec+1
            call kfrge(media.sigma, 1, nxsec,  xs,  i, jcon)
            if(jcon .ne. 0 ) then
               media.mbindex = nxsec
            else
               media.mbindex =min( i+1, nxsec)
            endif
         elseif(xs .gt. 300. .and. ke .lt. KEmin) then
            media.mbindex = nxsec
            icon = 1
         else
            if(xs .ge. xsecmin) then
               i = min( int( (xs - xsecmin )/xsecstep ), nxsec-2)
               s =( media.sigma(i+2)- media.sigma(i+1))*
     *            (xs-(xsecmin+i*xsecstep)) + media.sigma(i+1)
               media.mbindex = i + 1
               xs = s
            else
               icon = -1
            endif
         endif
      endif
      end

      subroutine epfixTarget(media, ia, iz)
      implicit none
#include "Zmedia.h"

c          This must not be called for heavy particles
c        to be called for hadron interactions.
c         

c      To fix the target element, 
c         sample u, for a given i fixed as above find j such that
c         u <=  cumsigma(j, i) 
c         Then, media.elem(j) is the  target element.
      record /epmedia/media   ! input.
      integer ia, iz        ! output target mass number and charge 
      real*8 u
      integer  j


      if(media.noOfElem .eq. 1) then
         j = 1
      else
         call rndc(u)
         do j = 1, media.noOfElem
            if(u .le. media.cumsigma(j, media.mbindex))  goto 10
         enddo
         call cerrorMsg('should not come here; epfixTarget',0)
      endif
 10   continue
c          int value is taken.
c      call rndc(u)
      ia = media.elem(j).A   + 0.5
c      if(u .lt. media.elem(j).A -ia ) then
c         ia = ia + 1
c      endif
      iz = media.elem(j).Z
      end

      subroutine epfixTarget2(media, ia, iz)
      implicit none
#include "Zmedia.h"

c          This may be used for small basic cross
c     section case so that the xA cross section is
c     propotinal to A. (for gamma A)
c         

      record /epmedia/media   ! input.
      integer ia, iz        ! output target mass number and charge 
      real*8 u, sum
      integer j


      if(media.noOfElem .eq. 1) then
         j = 1
      else
         call rndc(u)
         sum = 0.
         do j = 1, media.noOfElem
            sum = sum + media.w(j)
            if(u .le. sum) goto 10
         enddo
         call cerrorMsg('should not come here; epfixTarget2',0)
      endif
 10   continue
c          int value is taken.
c      call rndc(u)
      ia = media.elem(j).A +0.5
c      if(u .lt. media.elem(j).A -ia ) then
c         ia = ia + 1
c      endif
      iz = media.elem(j).Z
      
      end

      subroutine epfixTarget3(pj, media, ia, iz)
      implicit none
#include "Zmedia.h"
#include "Zptcl.h"
#include "Zcode.h"

c          This may be used for large basic cross
c     section case  (heavy incident case)N
c         

      record /ptcl/ pj      ! input. heavy projectile.
      record /epmedia/media   ! input.
      integer ia, iz        ! output target mass number and charge 
      real*8 u
      integer  j
      integer massn
      real*8 ek, xs, csum(maxElements), sum, sum2

      if(pj.code .ne. kgnuc) then
         call cerrorMsg(
     *    'should not come here for non-heavy; epfixTarget3', 0)
      endif
      if(media.noOfElem .eq. 1) then
         j = 1
      else
         ek = pj.fm.p(4) - pj.mass
         massn = pj.subcode
         sum = 0.
         do j = 1, media.noOfElem
            call cAAXsec(massn, media.elem(j).A,  ek, xs)
            csum(j) = xs*media.No(j)
            sum = csum(j)  + sum
         enddo
         call rndc(u)
         sum2 = 0.
         do j = 1, media.noOfElem
            sum2 = sum2 + csum(j)
            if(u .lt. sum2/sum) goto 10
         enddo
         call cerrorMsg('should not come here; epFixTarget3',0)
      endif
 10   continue
c          int value is taken.
c      call rndc(u)
      ia = media.elem(j).A +0.5
c      if(u .lt. media.elem(j).A -ia ) then
c         ia = ia + 1
c      endif
      iz = media.elem(j).Z
      
      end







