c           this is to be used in epics.gem as standard one.
c      now brmxet-module is for eg cut=10kev
c     ************************ for xe*********************************
c     *                                                              *
c     *  brmxet:  samples path for brems                             *
c     *  brmxee:  samples energy of brems gamma                      *
c     *  prcxet:  samples path for pair creation                     *
c     *  prcxee:  samples energy of pair electron (higher energy)    *
c     *  emctxe:  set const in common for xe                         *
c     *                                                              *
c     *********************** tested 84.04.28 ********************k.k*
c
c      material   z     a     rho     t0 (g/cm2)  t0 (cm)    ec
c         xe      54   131.3   3.0    8.134      2.77       9.5  mev
c brems:
c        electron energy:      1mev to 10tev
c        brems gamma energy:   .1mev or more
c           if electron energy is < 1mev,  sampled path is set to be
c        very large one so that real brems may not take place before
c        the death by energy loss.
c pair:
c        gamma energy:         3mev to 10tev
c           if gamma energy is < 3mev, sampled path is set to be
c        very large one so that real pair creation may not take place
c        before compton or another process takes place.
c
c
c
c
c   /usage/          call brmxet(ee,ec,t)
c                    call brmxee(ee,ec,beg)
c
c                    call prcxet(eg,t)
c                    call prcxee(eg,e1)
c
c      ee:  incident electron energy
c      ec:  cut-off energy of brems gamma (used if complete screening
c           cross section is to be used).
c       t:  sampled path
c     beg:  sampled gamma energy
c      eg:  incident gamma energy
c      e1:  sampled electron energy (higher energy in pair)
c
c  *** note ***
c
c          before calling brmxee, brmxet must have been called.
c          //             prcxee, prcxet //
c
c          by the parameters in $elmag the user can control:
c
c        ee  --------------50gev------->  (if usees=t, escb instead 50
c     scorec=t       p.s    !
c     lcorec=t              !    l.c
c     scorec=f       c.s    !
c     lcorec=f              !    c.s
c
c        eg  --------------10gev--10tev    (if usees=t, escp instead 50)
c     scorec=t       p.s    ! c.s
c     lcorec=t              ! c.s
c     scorec=f       c.s    ! c.s
c     lcorec=f              !
c
c
c
c
      subroutine brmxet(ee,ec,t)
       implicit none
c
c
#include  "Zelmag.h"
#include  "Zemdef.h"
c
c
      integer i
      logical screen,landau
c
c
c
c ------------------------- partical screening ----------------------
c           *** electron ***
c
c           ! egmin (gev)  for brems.
      data egmnl/.1e-3/
c
      parameter (eblmin=1.e-3, eblmax=10.,  nbtcl=13)
      dimension tcbl(nbtcl)
c
c             brem:   region a
c
      parameter (eela1=eblmin, eela2=eblmax,neela=13,
     * uela1=.05, uela2=1., nuela=16, duela=(uela2-uela1)/(nuela-1) )
      dimension bla(nuela *neela)
c
c             brem:  region b  (sqrt(u))
      parameter (eelb1=eblmin, eelb2=eblmax, neelb=neela,
     * uelb1=0.,  uelb2=.2236068, nuelb=16,
     * duelb=(uelb2-uelb1)/(nuelb-1) )
      dimension blb(nuelb *neelb)
c           ** gamma ***
c
c                 total cross-section
      parameter (eplmin=3.e-3, eplmax=300., nptcl=16)
      dimension tcpl(nptcl)
c
c          pair: region a
      parameter ( egla1=eplmin,  egla2=eplmax, negla=16,
     *   ugla1=.05, ugla2=1., nugla=16,dugla=(ugla2-ugla1)/(nugla-1) )
      dimension pla(nugla *negla)
c
c            pair: region b     sqrt(log10(e)) sqrt(u)
      parameter (eglb1=eplmin, eglb2=eplmax, neglb=11,
     *  uglb1=0., uglb2=.2236068, nuglb=16,
     *  duglb=(uglb2-uglb1)/(nuglb-1))
      dimension plb(nuglb *neglb)
c
c
c      -------------------- landau ------------------------------
c          **** electron ****
c
      data egmnh/1.e-3/
      parameter ( eeh1=100., eeh2=10.e3, neeh=7,dueh1=.1,
     *  ueh1=0., ueh2=.7, nueh1=(ueh2-ueh1+.00001)/dueh1+1)
      dimension  tcbh(neeh)
      dimension  be1(nueh1* neeh)
c
c                         sqrt(1-.7)
      parameter (ueh3=0., ueh4=0.5477225,
     *nueh2=7,  dvueh2=nueh2-1, dueh2=(ueh4 - ueh3)/dvueh2)
      dimension be2(nueh2*neeh)
c
c
c         *** gamma ****
c
      parameter ( egh1=10.e3, egh2=20.e3,negh=1, dugh2=.1,
     * ugh3=0., ugh4=1., nugh2=(ugh4-ugh3+.00001)/dugh2+1)
c     dimension tcph(negh)
c     dimension vp(nugh2, negh)
c
c
c     ---------------------------------------------------------
c
      data debtcl/ 0.333333/
      data deela/ 0.333333/
      data deelb/ 0.333333/
      data deptcl/ 0.333333/
      data degla/ 0.333333/
      data deglb/ 0.223607/
c        electron energy=
c      0.10000e-02 0.21544e-02 0.46416e-02 0.10000e-01 0.21544e-01
c      0.46416e-01 0.10000     0.21544     0.46416      1.0000
c       2.1544      4.6416      10.000
c       log10 step=  0.3333
c
c      log10 of electron energy boundary
      data  etcbl1/-3.000000/
c    *     ,etcbl2/ 1.000000/
c
      data (tcbl  (i),i=   1,  13)/
     1 1.6010, 2.8942, 3.9949, 5.0380, 6.0718, 7.1056, 8.1353, 9.1580,
     210.1740,11.1849,12.1920,13.1965,14.1997/
c
c       brem: region a
c        electron energy=
c      0.10000e-02 0.21544e-02 0.46416e-02 0.10000e-01 0.21544e-01
c      0.46416e-01 0.10000     0.21544     0.46416      1.0000
c       2.1544      4.6416      10.000
c       log10 step=  0.3333
c
c      log10 of electron energy boundary
      data  eela1l/-3.000000/
c    *     ,eela2l/ 1.000000/
c
c
c            bla(iu,ie)=log(v/vmin)/(1.-u)
c            u=0.050 to 1.000 step= 0.0633
c            log10(e)= -3.0000 to   1.0000 step= 0.3333
c
      data (bla   (i),i=   1,  72)/
     1 1.4733, 1.3840, 1.3202, 1.2702, 1.2291, 1.1940, 1.1637, 1.1368,
     2 1.1127, 1.0907, 1.0702, 1.0505, 1.0350, 1.0162, 0.9905, 0.9959,
     3 2.4747, 2.3114, 2.2051, 2.1268, 2.0658, 2.0146, 1.9717, 1.9388,
     4 1.9090, 1.8819, 1.8612, 1.8416, 1.8236, 1.8074, 1.7915, 1.7781,
     5 3.3514, 3.1728, 3.0598, 2.9811, 2.9214, 2.8722, 2.8334, 2.8003,
     6 2.7717, 2.7475, 2.7265, 2.7085, 2.6927, 2.6786, 2.6661, 2.6557,
     7 4.2095, 4.0360, 3.9277, 3.8498, 3.7911, 3.7467, 3.7111, 3.6825,
     8 3.6591, 3.6401, 3.6244, 3.6113, 3.6000, 3.5910, 3.5827, 3.5762,
     9 5.0530, 4.8860, 4.7775, 4.7028, 4.6487, 4.6090, 4.5787, 4.5551/
      data (bla   (i),i=  73, 144)/
     1 4.5369, 4.5225, 4.5112, 4.5017, 4.4942, 4.4882, 4.4822, 4.4792,
     2 5.8779, 5.7105, 5.6034, 5.5319, 5.4822, 5.4465, 5.4206, 5.4011,
     3 5.3868, 5.3757, 5.3674, 5.3608, 5.3558, 5.3519, 5.3494, 5.3462,
     4 6.6816, 6.5115, 6.4046, 6.3357, 6.2897, 6.2578, 6.2355, 6.2195,
     5 6.2081, 6.2000, 6.1936, 6.1896, 6.1861, 6.1836, 6.1816, 6.1799,
     6 7.4687, 7.2927, 7.1855, 7.1194, 7.0769, 7.0487, 7.0298, 7.0169,
     7 7.0081, 7.0019, 6.9974, 6.9945, 6.9924, 6.9906, 6.9892, 6.9884,
     8 8.2424, 8.0593, 7.9530, 7.8900, 7.8512, 7.8265, 7.8108, 7.8004,
     9 7.7936, 7.7890, 7.7862, 7.7839, 7.7827, 7.7815, 7.7814, 7.7802/
      data (bla   (i),i= 145, 208)/
     1 9.0064, 8.8168, 8.7124, 8.6532, 8.6184, 8.5972, 8.5841, 8.5759,
     2 8.5707, 8.5676, 8.5654, 8.5640, 8.5632, 8.5626, 8.5626, 8.5617,
     3 9.7645, 9.5696, 9.4682, 9.4132, 9.3821, 9.3639, 9.3534, 9.3469,
     4 9.3432, 9.3406, 9.3392, 9.3381, 9.3378, 9.3376, 9.3359, 9.3369,
     510.5189,10.3203,10.2225,10.1716,10.1442,10.1288,10.1202,10.1153,
     610.1125,10.1108,10.1097,10.1090,10.1087,10.1088,10.1084,10.1084,
     711.2713,11.0707,10.9769,10.9304,10.9061,10.8934,10.8864,10.8828,
     810.8804,10.8793,10.8789,10.8781,10.8784,10.8784,10.8786,10.8779/
c
c       brem: region b
c        electron energy=
c      0.10000e-02 0.21544e-02 0.46416e-02 0.10000e-01 0.21544e-01
c      0.46416e-01 0.10000     0.21544     0.46416      1.0000
c       2.1544      4.6416      10.000
c       log10 step=  0.3333
c
c      log10 of electron energy boundary
      data  eelb1l/-3.000000/
c    *     ,eelb2l/ 1.000000/
c
c
c            blb(iu,ie)=log(v/vmin)/(1.-u)
c            sqrt(u)=0.000 to 0.224 step= 0.0149
c            log10(e)= -3.0000 to   1.0000 step= 0.3333
c
      data (blb   (i),i=   1,  72)/
     1 1.5872, 1.5861, 1.5830, 1.5779, 1.5708, 1.5619, 1.5513, 1.5391,
     2 1.5255, 1.5105, 1.4943, 1.4771, 1.4590, 1.4399, 1.4201, 1.3996,
     3 2.7994, 2.7931, 2.7767, 2.7540, 2.7278, 2.6992, 2.6687, 2.6370,
     4 2.6039, 2.5701, 2.5353, 2.4996, 2.4634, 2.4264, 2.3890, 2.3509,
     5 3.7210, 3.7061, 3.6807, 3.6523, 3.6217, 3.5893, 3.5550, 3.5192,
     6 3.4818, 3.4429, 3.4026, 3.3612, 3.3183, 3.2746, 3.2296, 3.1838,
     7 4.5527, 4.5350, 4.5115, 4.4852, 4.4565, 4.4253, 4.3920, 4.3562,
     8 4.3183, 4.2781, 4.2361, 4.1920, 4.1461, 4.0986, 4.0494, 3.9990,
     9 5.3487, 5.3329, 5.3129, 5.2897, 5.2638, 5.2349, 5.2031, 5.1685/
      data (blb   (i),i=  73, 144)/
     1 5.1312, 5.0911, 5.0486, 5.0036, 4.9562, 4.9062, 4.8545, 4.8004,
     2 6.1292, 6.1162, 6.0993, 6.0790, 6.0555, 6.0285, 5.9984, 5.9651,
     3 5.9286, 5.8888, 5.8457, 5.7999, 5.7505, 5.6979, 5.6422, 5.5840,
     4 6.9026, 6.8923, 6.8778, 6.8596, 6.8379, 6.8126, 6.7836, 6.7511,
     5 6.7145, 6.6740, 6.6295, 6.5807, 6.5280, 6.4713, 6.4113, 6.3475,
     6 7.6729, 7.6645, 7.6519, 7.6353, 7.6148, 7.5904, 7.5616, 7.5283,
     7 7.4904, 7.4479, 7.4005, 7.3484, 7.2915, 7.2301, 7.1647, 7.0953,
     8 8.4417, 8.4348, 8.4234, 8.4079, 8.3879, 8.3631, 8.3335, 8.2986,
     9 8.2586, 8.2131, 8.1622, 8.1057, 8.0441, 7.9775, 7.9060, 7.8302/
      data (blb   (i),i= 145, 208)/
     1 9.2098, 9.2040, 9.1935, 9.1783, 9.1579, 9.1323, 9.1009, 9.0639,
     2 9.0209, 8.9718, 8.9168, 8.8555, 8.7885, 8.7160, 8.6384, 8.5561,
     3 9.9776, 9.9726, 9.9625, 9.9470, 9.9257, 9.8986, 9.8653, 9.8255,
     4 9.7791, 9.7261, 9.6662, 9.5999, 9.5274, 9.4489, 9.3650, 9.2763,
     510.7453,10.7408,10.7306,10.7145,10.6921,10.6631,10.6274,10.5844,
     610.5345,10.4771,10.4125,10.3409,10.2627,10.1781,10.0881, 9.9929,
     711.5129,11.5087,11.4983,11.4812,11.4574,11.4264,11.3881,11.3419,
     811.2881,11.2263,11.1566,11.0797,10.9957,10.9053,10.8090,10.7077/
c
c       pair: total x-section
c        gamm energy=
c      0.30000e-02 0.64633e-02 0.13925e-01 0.30000e-01 0.64633e-01
c      0.13925     0.30000     0.64633      1.3925      3.0000
c       6.4633      13.925      30.000      64.633      139.25
c       300.00
c       log10 step=  0.3333
c
c      log10 of gamma energy boundary
      data  etcpl1/-2.522879/
c    *     ,etcpl2/ 2.477121/
c
      data (tcpl  (i),i=   1,  16)/
     1 0.0332, 0.1412, 0.2644, 0.3891, 0.5036, 0.5934, 0.6533, 0.6906,
     2 0.7127, 0.7253, 0.7322, 0.7359, 0.7379, 0.7389, 0.7394, 0.7397/
c
c       pair: region a
c
c         energy of gamma=
c        0.300e-02   0.646e-02   0.139e-01   0.300e-01   0.646e-01
c        0.139       0.300       0.646        1.39        3.00
c         6.46        13.9        30.0        64.6        139.
c         300.
c         log10 step= 0.333333
c
c         log10 of eg boundary
      data  egla1l/-2.522879/
c    *     ,egla2l/ 2.477121/
c
c
c         pla(iu,ie)=(v-.5)/(1.-u)
c         u=0.050 to1.000   step= 0.0633
c            log10(e)= -2.5229 to   2.4771 step= 0.3333
c
      data (pla   (i),i=   1,  72)/
     1 0.2334, 0.2251, 0.2193, 0.2150, 0.2116, 0.2089, 0.2066, 0.2048,
     2 0.2032, 0.2022, 0.2012, 0.2003, 0.1997, 0.1992, 0.1989, 0.1989,
     3 0.3754, 0.3620, 0.3542, 0.3488, 0.3450, 0.3420, 0.3398, 0.3378,
     4 0.3365, 0.3355, 0.3344, 0.3337, 0.3334, 0.3330, 0.3334, 0.3328,
     5 0.4286, 0.4179, 0.4122, 0.4086, 0.4063, 0.4048, 0.4037, 0.4033,
     6 0.4027, 0.4026, 0.4024, 0.4025, 0.4027, 0.4025, 0.4023, 0.4026,
     7 0.4562, 0.4488, 0.4453, 0.4436, 0.4430, 0.4430, 0.4432, 0.4437,
     8 0.4440, 0.4445, 0.4448, 0.4457, 0.4467, 0.4461, 0.4491, 0.4474,
     9 0.4723, 0.4679, 0.4667, 0.4670, 0.4683, 0.4700, 0.4716, 0.4736/
      data (pla   (i),i=  73, 144)/
     1 0.4755, 0.4772, 0.4786, 0.4811, 0.4823, 0.4835, 0.4842, 0.4832,
     2 0.4830, 0.4818, 0.4831, 0.4857, 0.4890, 0.4924, 0.4961, 0.4995,
     3 0.5031, 0.5062, 0.5087, 0.5111, 0.5129, 0.5139, 0.5123, 0.5163,
     4 0.4905, 0.4925, 0.4962, 0.5008, 0.5054, 0.5103, 0.5151, 0.5200,
     5 0.5243, 0.5284, 0.5323, 0.5352, 0.5374, 0.5390, 0.5383, 0.5414,
     6 0.4959, 0.5001, 0.5053, 0.5110, 0.5167, 0.5226, 0.5282, 0.5339,
     7 0.5390, 0.5438, 0.5483, 0.5521, 0.5547, 0.5569, 0.5585, 0.5589,
     8 0.4997, 0.5051, 0.5114, 0.5177, 0.5241, 0.5305, 0.5368, 0.5428,
     9 0.5485, 0.5539, 0.5587, 0.5626, 0.5658, 0.5684, 0.5696, 0.5703/
      data (pla   (i),i= 145, 216)/
     1 0.5021, 0.5085, 0.5151, 0.5219, 0.5287, 0.5355, 0.5422, 0.5485,
     2 0.5545, 0.5599, 0.5647, 0.5691, 0.5727, 0.5754, 0.5766, 0.5772,
     3 0.5036, 0.5103, 0.5174, 0.5244, 0.5314, 0.5385, 0.5453, 0.5518,
     4 0.5579, 0.5635, 0.5687, 0.5731, 0.5764, 0.5789, 0.5805, 0.5813,
     5 0.5045, 0.5115, 0.5187, 0.5259, 0.5331, 0.5401, 0.5470, 0.5537,
     6 0.5599, 0.5655, 0.5707, 0.5751, 0.5787, 0.5813, 0.5825, 0.5836,
     7 0.5050, 0.5122, 0.5194, 0.5267, 0.5340, 0.5411, 0.5479, 0.5547,
     8 0.5610, 0.5668, 0.5718, 0.5765, 0.5800, 0.5828, 0.5845, 0.5848,
     9 0.5053, 0.5126, 0.5199, 0.5272, 0.5345, 0.5415, 0.5486, 0.5552/
      data (pla   (i),i= 217, 256)/
     1 0.5616, 0.5671, 0.5726, 0.5770, 0.5806, 0.5833, 0.5845, 0.5855,
     2 0.5056, 0.5128, 0.5200, 0.5274, 0.5347, 0.5419, 0.5488, 0.5555,
     3 0.5618, 0.5675, 0.5726, 0.5775, 0.5811, 0.5838, 0.5854, 0.5858,
     4 0.5056, 0.5129, 0.5202, 0.5275, 0.5349, 0.5419, 0.5490, 0.5557,
     5 0.5618, 0.5678, 0.5730, 0.5775, 0.5811, 0.5838, 0.5854, 0.5860/
c
c
c       pair: region b
c
c         energy of gamma=
c        0.300e-02   0.337e-02   0.475e-02   0.846e-02   0.189e-01
c        0.533e-01   0.189       0.846        4.75        33.7
c         300.
c         sqrt(log10) step= 0.223607
c
c         use 0 for e-side at interpolation
c         with sqrt(log10(e)-eglb1l)
      data  eglb1l/-2.522879/
c
c
c         plb(iu,ie)=v
c         sqrt(u)=0.000 to0.224   step= 0.0149
      data (plb   (i),i=   1,  72)/
     1 0.8297, 0.7440, 0.7437, 0.7431, 0.7423, 0.7413, 0.7400, 0.7386,
     2 0.7370, 0.7353, 0.7334, 0.7313, 0.7291, 0.7268, 0.7244, 0.7218,
     3 0.8482, 0.7873, 0.7867, 0.7858, 0.7846, 0.7830, 0.7812, 0.7792,
     4 0.7770, 0.7745, 0.7720, 0.7692, 0.7664, 0.7633, 0.7602, 0.7570,
     5 0.8925, 0.8684, 0.8670, 0.8649, 0.8622, 0.8592, 0.8560, 0.8526,
     6 0.8491, 0.8454, 0.8417, 0.8379, 0.8339, 0.8300, 0.8259, 0.8218,
     7 0.9396, 0.9329, 0.9299, 0.9265, 0.9230, 0.9193, 0.9157, 0.9118,
     8 0.9080, 0.9041, 0.9000, 0.8959, 0.8918, 0.8875, 0.8831, 0.8787,
     9 0.9730, 0.9701, 0.9672, 0.9642, 0.9611, 0.9577, 0.9544, 0.9510/
      data (plb   (i),i=  73, 144)/
     1 0.9474, 0.9437, 0.9400, 0.9361, 0.9322, 0.9280, 0.9239, 0.9196,
     2 0.9904, 0.9884, 0.9863, 0.9840, 0.9815, 0.9789, 0.9761, 0.9732,
     3 0.9702, 0.9671, 0.9639, 0.9604, 0.9570, 0.9532, 0.9494, 0.9456,
     4 0.9973, 0.9960, 0.9946, 0.9930, 0.9913, 0.9893, 0.9873, 0.9850,
     5 0.9827, 0.9801, 0.9774, 0.9747, 0.9717, 0.9686, 0.9653, 0.9619,
     6 0.9994, 0.9987, 0.9979, 0.9968, 0.9956, 0.9942, 0.9927, 0.9912,
     7 0.9893, 0.9874, 0.9853, 0.9830, 0.9807, 0.9781, 0.9754, 0.9725,
     8 0.9999, 0.9996, 0.9990, 0.9984, 0.9975, 0.9965, 0.9954, 0.9941,
     9 0.9928, 0.9910, 0.9893, 0.9874, 0.9853, 0.9830, 0.9805, 0.9779/
      data (plb   (i),i= 145, 176)/
     1 1.0000, 0.9998, 0.9994, 0.9989, 0.9983, 0.9975, 0.9965, 0.9954,
     2 0.9941, 0.9925, 0.9909, 0.9891, 0.9870, 0.9848, 0.9825, 0.9799,
     3 1.0000, 0.9999, 0.9996, 0.9992, 0.9986, 0.9977, 0.9969, 0.9957,
     4 0.9944, 0.9930, 0.9913, 0.9894, 0.9875, 0.9853, 0.9828, 0.9803/
c
c    ---------------     $$$   landau correction region $$$     ----
      data deelh/ 0.333333/
c     data deghl/10.e3/
c
c          energy of electron
c        100.0       215.4       464.2       1000.       2154.
c        4642.      0.1000e+05
c         log10 step= 0.333333
c
c         log10 of electron energy boundary
      data eeh1l/ 2.000000/
c    *     ,eeh2l/ 4.000000/
c
      data (tcbh  (i),i=   1,   7)/
     1 10.2346,  9.3850,  8.4489,  7.4761,  6.4953,  5.5286,  4.6012/
c
c          be1(iu,ie)= log(v/vmin)
c          from u=0.000 to 0.700 step=0.100
c          from log10(e)=  2.0000 to  4.0000 step  0.3333
c          dim. of u=  8 dim of e=  7
c
      data (   be1(i),i=   1,  54)/
     1 11.51293, 10.41123,  9.47690,  8.64050,  7.83990,  7.07044,
     2  6.29814,  5.46729, 12.28045, 11.26447, 10.39018,  9.60858,
     3  8.87734,  8.16662,  7.43362,  6.62154, 13.04798, 12.12839,
     4 11.32078, 10.60618,  9.94341,  9.28580,  8.59132,  7.80308,
     5 13.81551, 12.99832, 12.26176, 11.62162, 11.01807, 10.40681,
     6  9.74789,  8.98498, 14.58304, 13.87063, 13.21713, 12.64139,
     7 12.08696, 11.51521, 10.88794, 10.14959, 15.35056, 14.74396,
     8 14.17369, 13.65218, 13.13904, 12.60050, 12.00065, 11.28489,
     9 16.11809, 15.61685, 15.12181, 14.64627, 14.16709, 13.65597/
      data (   be1(i),i=  55,  56)/
     1 13.07928, 12.38341/
c
c         be2(iu,ie)= (sqrt(v) -sqrtv)/(1.-u)
c          from sqrt(1-u)=0.000 to 0.548 step= 0.091
c          from log10(e)= 2.000000 to 4.000000 step  0.3333
c
      data (   be2(i),i=   1,  49)/
     1  0.1046,  0.1057,  0.1091,  0.1146,  0.1227,  0.1344,  0.1517,
     2  0.1333,  0.1352,  0.1400,  0.1471,  0.1568,  0.1703,  0.1896,
     3  0.1693,  0.1725,  0.1794,  0.1885,  0.2002,  0.2157,  0.2372,
     4  0.2127,  0.2183,  0.2281,  0.2394,  0.2533,  0.2709,  0.2945,
     5  0.2636,  0.2729,  0.2862,  0.3000,  0.3160,  0.3356,  0.3609,
     6  0.3267,  0.3361,  0.3529,  0.3692,  0.3871,  0.4084,  0.4350,
     7  0.3989,  0.4066,  0.4263,  0.4449,  0.4643,  0.4867,  0.5141/
c
c
c         energy of gamma
c       0.1000e+05
c       log10 step=*********
c
c       log10 of gamma energy boundary
c     data egh1l/ 4.000000/
c    *     ,egh1l/ 4.301030/
c
c     data (tcph  (i),i=   1,   1)/
c    1  0.7735/
c
c        table of v
c        from u= 0.0000 to  1.0000 step  0.1000
c        from log10(e)= 4.000000 to 4.301030 step********
c
c     data (   vp (i),i=   1,  11)/
c    1 1.0000, 0.9603, 0.9185, 0.8743, 0.8277, 0.7785, 0.7267, 0.6726,
c    2 0.6162, 0.5585, 0.5000/
c
c       total prob. equivalenced to common
c
      equivalence (tprob,tp)
c

c
c                         complete screening pair x-sxec.
c                         0.773 =(7/9-b)*rx0 =.773*rx0
      data rx0/1.000/, ctpc/.773/
c     data rx0/1.000/, ctpc/.703/,  cep/10.e3/
c       rx0=x0(true)/x0(in nishimura text)
c       cep:  minimum energy for landau correction for pair.
c          default esbc espc
      data esbin/1./,  espin/10./
c
c
      if(ee .lt. eblmin) then
          t=1.e36
      else
          if(.not. usees) then
             esb=esbin
          else
             esb=min(escb, eblmax)
          endif
          if(ee .gt. esb) then
              screen=.false.
              if(lcorec .and. ee .gt. eeh1) then
                  if(ee .gt. eeh2) then
                       write(6,'('' ee > eeh2 in brmxet: ee='',g12.4)')
     *                 ee
                       stop
                  endif
                  landau=.true.
                  ale=log10(ee)
c                 tp=fintp3(tcbh, eeh1l, deelh, neeh, ale)*rx0
                  call kintp3(tcbh, 1, neeh, eeh1l, deelh, ale, tp)
                  tp=tp*rx0
              else
                  landau=.false.
c                     complete screening cross-section
                  vc=ec/ee
                  tp=(-1.3603*(log(vc)-vc)-vc*vc*.5-.8603 )*rx0
              endif
          else
              landau=.false.
              if(scorec) then
                  screen=.true.
                  ale=log10(ee)
c                 tp=fintp3(tcbl, etcbl1, debtcl, nbtcl,  ale)
                  call kintp3(tcbl, 1, nbtcl, etcbl1, debtcl,  ale, tp)
              else
                  screen=.false.
c                     complete screening cross-section
                  vc=ec/ee
                  tp=(-1.3603*(log(vc)-vc)-vc*vc*.5-.8603 )*rx0
              endif
          endif
c
          call rndc(u)
          t =-log(u)/tp
      endif
      return
c
c     ************
      entry brmxee(ee,ec,beg)
c     ************
c
      call rndc(u)
      if(screen) then
c           partial screening
         if(u .gt. uela1) then
c                  region a
c              beg=exp( tdint4(bla, nuela, neela, uela1, eela1l, duela,
c    *         deela, u,  ale)*(1.-u) ) *egmnl
               call k4ptdi(bla, nuela, neela, nuela, uela1, eela1l,
     *         duela, deela, u, ale, ans)
               beg=exp( ans*(1.-u))*egmnl
         else
c                  region b
               us=sqrt(u)
c              beg=exp( tdint4(blb, nuelb, neelb, uelb1, eelb1l,duelb,
c    *         deelb, us, ale)) * egmnl
               call k4ptdi(blb, nuelb, neelb, nuelb, uelb1, eelb1l,
     *         duelb, deelb, us, ale, ans)
               beg=exp(ans)*egmnl
         endif
      elseif(landau) then
         if(u .lt. ueh2) then
c              beg=exp( tdint4(be1, nueh1, neeh, ueh1, eeh1l, dueh1,
c    *         deelh, u,  ale)  ) * egmnh
               call k4ptdi(be1, nueh1, neeh, nueh1,  ueh1, eeh1l,
     *         dueh1, deelh, u,  ale, ans)
               beg=exp( ans ) *egmnh
         else
               us=sqrt(1.-u)
c              beg=   ( tdint4(be2, nueh2, neeh, ueh3, eeh1l, dueh2,
c    *         deelh, us,  ale)*(1.-u)+ sqrt(egmnh/ee) )**2 *ee
               call k4ptdi(be2, nueh2, neeh, nueh2,  ueh3, eeh1l,
     *         dueh2, deelh, us,  ale, ans)
               beg=  (ans*(1.-u) + sqrt(egmnh/ee) )**2*ee
         endif
      else
c               complete screening
          a=u*tp
          if(a .le. 1.) then
             v=exp(-a)
             if(a .gt. .1) then
                 v=((.06366*a-.1447407)*a+1.014176)*v
             endif
          else
             v=exp(-(a+0.8603)/1.3603)
             if(a .le. 6.) then
                 v=((((2.050445e-3*a-3.53209e-2)*a+.228937)*a-.684076)*a
     *           +1.841734)*v
             endif
          endif
          beg=ee*v
      endif
      return
c
c
c     ***********
      entry prcxet(eg,t)
c     ***********
c
c
c
      if(eg .le. emass2) then
          t=1.e37
      elseif(eg .lt. eplmin .and. scorec) then
          tp=( (eg-emass2)/(eplmin-emass2) )**3 * tcpl(1)
          call rndc(u)
          t =-log(u)/tp
          landau=.false.
          screen=.true.
      else
          if(.not. usees) then
             esp=espin
          else
             esp=min(escp, eplmax)
          endif
          if(eg .gt. esp) then
              screen=.false.
              if(eg .gt. cep   .and. lcorec) then
                  landau=.true.
                  ale=log10(eg)
cc                tp=fintp3(tcph, egh1l, deghl, negh, ale)*rx0
                  call kintp3(tcph, 1, negh,  egh1l,  deghl,   ale, tp)
                  tp=tp*rx0
             else
                  landau=.false.
c                     complete screening cross-section
                  tp=ctpc
             endif
          else
              landau=.false.
              if(scorec) then
                  screen=.true.
                  ale=log10(eg)
c                 tp=fintp3(tcpl, etcpl1, deptcl, nptcl, ale)
                  call kintp3(tcpl, 1,nptcl,  etcpl1, deptcl,  ale, tp)
              else
                  screen=.false.
c                     complete screening cross-section
                  tp=ctpc
              endif
          endif
          call rndc(u)
          t =-log(u)/tp
      endif
      return
c
c
c     ***********
      entry prcxee(eg,e1)
c     ***********
c
c
c
      call rndc(u)
      if(screen) then
c           partial screening
         if(u .ge. ugla1) then
c                   region a
c               e1=(tdint4(pla, nugla, negla, ugla1, egla1l, dugla,
c    *          degla, u,    ale) *(1.-u) + .5 )*eg
                call k4ptdi(pla, nugla, negla,nugla,  ugla1, egla1l,
     *          dugla, degla, u,   ale, ans)
                e1=(ans*(1.-u) + .5)*eg
         else
c                   region b
                us=sqrt(u)
                ex=sqrt(ale-eglb1l)
c               e1=tdint4(plb, nuglb, neglb, uglb1, 0.,
c    *          duglb, deglb, us,  ex)*eg
                call k4ptdi(plb, nuglb, neglb,nuglb,  uglb1, 0.,
     *          duglb, deglb, us,  ale, ans)
                e1=ans*eg
         endif
      elseif(landau) then
cc       e1= tdint4(vp, nugh2, negh, ugh3, egh1l, dugh2,
cc   *   deghl, u,  ale) * eg
         call k4ptdi(vp, nugh2, negh, nugh2, ugh3, egh1l,
     *   dugh2, deghl, u,  ale, ans)
        e1=ans*eg
      else
c                complete screening
         e1=(((.0441223*u-.173755)*u-.3708608)*u+1.)*eg
      endif
      return
c
c     ************
      entry emctxe(Knckon)
c     ************
c
c               cconst=for compton=3/8*thomson*n0*z/a*x0ing
c               to convert cross-section in compt into /(r.l).
      cconst=.5025
      x0=2.711
      x0ing=8.134
      x0sq=7.35
      if(Knckon) then
         ecrit= 9.5e-3
      else
         ecrit=10.e-3
      endif
c         moller scat ( .3*z/a*x0ing )
      constm=1.00
c
      zchrg=54.
      amassn=131.3
      return
      end
