c     ****************************************************************
c     *
c     * mscatt: samples moller scattering path in r.l
c     * mscate: //      energy of survival and recoil electrons
c     * mscata: //      angle of survival and recoil electrons
c     *
c     ************************ tested 84.06.22 ***********************
c
c   /usage/  call mscatt(e, w, path)
c
c   --input--
c    e: electron energy in gev
c    w: minimum kinetic energy of recoil electron to be treated.
c       (around .25e-3 gev).
c
c   -- output --
c path: sampled path in r.l
c   e1: survival electron energy
c   er: recoil //                (e1>=er alwasy).
c
c cos1: cos and sin of survival electron
c cosr:       cos of recoil electron
c
c  **** note ***
c            before calling mscate, mscatt must be called and
c            befroe calling mscata, mscate must be called.
c
c            constm=.3*z/a*x0ing
c
c            in  $$elmag must have been fixed beforehand.
c
       subroutine mscatt(ein, w, path)
       implicit none
c
#include  "Zelmag.h"
c
        
        real*8 ein, w, path

        real*8 e1, er, ee, cos1, cosr, tmp
        real*8 e1sav

        real*8 em, Beta2, ep, t0, e, tp, g, u, ge, t1, e2, eps
        real*8 cos12, tr
c
c            equivalenced to common
        equivalence (tp, tprob)
c
c
        real*8 gef

        save em, e1sav, t0, Beta2, e

        gef(ep)=(1.-2*em)/Beta2 * (1. + (ep/(1.-ep))**2 +
     *           (t0/e * ep)**2
     *          - (t0*2 + emass)/e * ep/(1.-ep) )
c
       e=ein
       g=emass/e
       Beta2=1. - g**2
       t0=e-emass
       if(t0 .gt. 0.) then
          em= w/t0
       else
          em=1000.
       endif
       if(em .ge. .5) then
           path=1.e35
           tp=0.
       else
           if(em .lt. 5.e-4) then
               tp =1./w*emass * constm
           else
               tp = ( (t0/e)**2*(.5-em) + (t0*2+emass)/e *
     *         log(em/(1.-em)) +  (1.-em*2)/em/(1.-em)   )/ t0 /Beta2
     *         *emass* constm
           endif
           call rndc(u)
           path=-log(u) / tp
       endif
       return
c
c      ************
       entry mscate(ee, e1, er)
c      ************
c
       if(em .ge. .5) then
           er=emass
           e1=ee
           tr=0.
       else
           if(em .gt. .40) then
c                 approximately flat in tr/t0=(em to .5)
               call rndc(u)
               ep=em + (.5 - em) * u
            else
c                   rejection method
c                *** until loop*** 
                do while (.true.)
                    call rndc(u)
                    ep=1./ (  (1.-em*2)*u/em + 2. )
c
                    ge=gef(ep)
                    call rndc(u)
                    u=u*gef(em)
                if         ( u .lt. ge)
     *                             goto 100
                enddo
  100           continue
            endif
            tr=ep*t0
            er=tr + emass
       endif
       e1=ee-er+emass
       if(e1 .lt. emass  .or. er .lt. emass) then
           tr=(ee-emass)/2
           er=tr+emass
           e1=er
       endif
       e1sav=e1
       return
c
c      ************
       entry mscata(cos1, cosr)
c      ************
c
       t1=e1sav-emass
       e2=emass*2
       eps=t0-t1
       if(eps/(t0+e2) .lt. 0.05) then
           cos1=1.d0- eps*emass/(t0*(t0+e2))
       else
           cos12=t1*(t0+e2)/( t0*(t1+e2))
           if(cos12 .lt. 0.d0) then
c              this is due to energy loss.
              cos1=0.d0
           else
              cos1=sqrt(cos12)
           endif
       endif
c
       tmp= tr*(t0+e2)/(t0*(tr+e2) )
       if(tmp .lt. 0.) then
           cosr=0.
       else
           cosr=sqrt(tmp)
       endif
       return
       end
