c#include "BlockData/epblkemg.h"
c      implicit none
c#include <Zelmag.h>
c      integer i
c      real*8 mass, erg, tcut, path, erg2, erge, cos1, cose
c      mass = 0.106
c      erg = mass + .4d0
c      tcut = 100.d-6
c      constm = 6.61
c      do i = 1, 10000
c         call epKpath(erg, mass, tcut, path)
c         call epKerg(erg2, erge)
c         call epKang(cos1, cose)
c         write(*,*) sngl(path), sngl(erg2), sngl(erge), sngl(cos1),
c     *   sngl(cose)
c      enddo
c      end
      subroutine epKpath(erg, mass, tcut, path)
      implicit none
#include <Zelmag.h>
c       sampling for knock-on process of charged particles
c      other than e+/e-
c   epKpath: samples path
c   epKerg:  samples energy; must be called after epKpath 
c   epKang:  samples angles: must be called after epKerg
c
c Note:  epKerg and epKang assume no energy loss between two 
c        points where the path and energy/angles
c        sampling are  done, even though in the M.C
c        process the ionization loss has been taken into
c        account. This is to avoid unphysical value of
c        angles / energy.
c    
      real*8 erg   ! input  total energy of the particle in GeV.
      real*8 mass  ! input  mass of the particle in GeV.
      real*8 tcut  ! input  minimum kinetic energy of delta electrons to be
                   !        considered. in GeV 
      real*8 path  ! output sampled path length in r.l
c
      real*8 erg2  ! output scattered total energy of the particle  in GeV.
      real*8 erge  ! output recoiled total electron energy in GeV
c
      real*8 cos1  ! output. cos angle of the scattered particle
      real*8 cosr  ! output. cos angle of the recoiled electron


      real*8  u, tmax, t, beta2, g, temp,  norm, erg2save
      real*8  massSave, ergsave, p02, p12, pe2, ergesave, tcutsave

      save beta2, tmax, norm, erg2save, massSave, ergsave, t
      save ergesave, tcutsave

      logical accept
c
      massSave = mass
      ergsave = erg
      tcutsave = tcut
      g = erg/mass
      beta2 = 1.0 - 1.d0/g**2
      tmax = 2*emass*(g**2-1.)/
     *       (1.0 + 2*g* (emass/mass) + (emass/mass)**2)

      if(tcut .ge. tmax) then
         tprob = 0.
         path = 1.d35
      else
         norm = (1.0d0/tcut - 1.0d0/tmax) 
         temp = norm -
     *       beta2 * log(tmax/tcut)/tmax 
c            assume spin 0 particle is only pi, K
         if(mass .lt. 0.11 .or. mass .gt. 0.9) then
c           mu, p, etc. spin = 1/2
            temp = temp + (tmax - tcut)/erg/erg/2
         endif
         tprob = temp * emass * constm /beta2
         call rndc(u)
         path = - log(u)/tprob
      endif
      return
c
c    ***********
      entry epKerg(erg, erg2, erge)
c    **************
c       samples delta ray electron energy erge
c
c      this erg is lower than ergsave due to
c      energy loss in the path
c
      accept = .false.
      do while(.not. accept)
         call rndc(u)
         t = 1.0d0/(1.0d0/tcutsave - norm*u)
         call rndc(u)
         temp =1. - beta2*t/tmax
         if(massSave .lt. 0.11 .or. massSave .gt. 0.9) then
            temp = temp + t*t/ergsave**2/2
         endif
         if(temp .gt. u) then
            accept = .true.
         endif
      enddo
      erge = t + emass
      ergesave = erge
c     erg2 = ergsave - erge + emass
c          above will give larger energy than
c          current erg and energy eventually increase.
c          avoid it by using current erg
c 
      erg2 =max( erg - erge + emass, massSave)
      erg2save = erg2
      return
c    
c     *************
      entry epKang(cos1, cosr)
c     ************
c
c      from
c       p1cos1 + p2cos2 = p0
c       p1sin1 = p2sin2
c       E0+m = E1 + E2
c     we obtain
c       cos1 = (p0^2 + p1^2 - p2^2)/(2p0p1)
c       cos2 = (p0^2 + p2^2 - p1^2)/(2p0p2)
c        (p0^2 + p1^2 - p2^2)/2 = E0E1 -M^2 - m(E2-m)
c        (p0^2 + p2^2 - p1^2)/2 = E0E2 - mE1
c
c      p02 =abs(
       p02 =   ergsave**2 - massSave**2
       p12 =   erg2save**2 -massSave**2
       pe2 =   ergesave**2 - emass**2
       if(p12 .le. 0. ) then
          cos1 = -1.
          cosr = 1.
       else
          cos1 = (ergsave*erg2save - massSave**2 -emass*t)/
     *     sqrt(p02*p12)      
          if(cos1 .gt. 1.) then
             cos1 = 1.
          elseif(cos1 .lt. -1.) then
             cos1 = -1.
          endif
          cosr = (ergsave*(t+emass) - emass*erg2save)/
     *         sqrt(p02*pe2)      
          if(cosr .gt. 1.) then
             cosr = 1.
          elseif(cosr .lt. -1.) then
             cosr = -1.
          endif
       endif
      end





















