c     ************************ for g5*********************************
c     *                                                              *
c     *  brmg5t:  samples path for brems                             *
c     *  brmg5e:  samples energy of brems gamma                      *
c     *  prcg5t:  samples path for pair creation                     *
c     *  prcg5e:  samples energy of pair electron (higher energy)    *
c     *  emctg5:  set const in common for g5                         *
c     *                                                              *
c     *********************** tested 84.04.28 ********************k.k*
c
c      material   z     a     rho     t0 (g/cm2)  t0 (cm)    ec
c                35.76  81.54  by weighted average
c         g5     38.62  94.93  3.828  11.075       2.893    13.1
c                                 (n) 11.4         2.987
c
c      g5 composition at r.h 58 %
c         r.no./unit vol    *a      *z**2
c       ag  1.013         109.27    241377
c       br  1.007          80.48     98588
c        h  3.2             3.23         3
c        c  1.39           16.69       601
c        n  .318            4.45       218
c        o  .938           15.01       960
c      ---------------------------------------------------------
c      sum  7.87          229.13    341748
c
c              sqrt(weighted <z**2> )= 38.62
c              weigthted <z**2/a>=15.71  so that <a>=94.93
c
c brems:
c        electron energy:      1mev to 50tev
c        brems gamma energy:   .1mev or more
c           if electron energy is < 1mev,  sampled path is set to be
c        very large one so that real brems may not take place before
c        the death by energy loss.
c pair:
c        gamma energy:         3mev to 50tev
c           if gamma energy is < 3mev, sampled path is set to be
c        very large one so that real pair creation may not take place
c        before compton or another process takes place.
c
c
c
c
c   /usage/          call brmg5t(ee,ec,t)
c                    call brmg5e(ee,ec,beg)
c
c                    call prcg5t(eg,t)
c                    call prcg5e(eg,e1)
c
c      ee:  incident electron energy
c      ec:  cut-off energy of brems gamma (used if complete screening
c           cross section is to be used).
c       t:  sampled path
c     beg:  sampled gamma energy
c      eg:  incident gamma energy
c      e1:  sampled electron energy (higher energy in pair)
c
c  *** note ***
c
c          before calling brmg5e, brmg5t must have been called.
c          //             prcg5e, prcg5t //
c
c          by the parameters in $elmag the user can control:
c
c        ee  --------------10gev------->  (if usees=t, escb instead 5)
c     scorec=t       p.s    !
c     lcorec=t              !    l.c
c     scorec=f       c.s    !
c     lcorec=f              !    c.s
c
c        eg  --------------50gev--5tev---> (if usees=t, escp instead 50)
c     scorec=t       p.s    ! c.s !
c     lcorec=t              ! c.s ! l.c
c     scorec=f       c.s    ! c.s !
c     lcorec=f              !     ! c.s
c
c
c
c
      subroutine brmg5t(eein,ec,t)
       implicit none
c
c
#include  "Zelmag.h"
#include  "Zemdef.h"
c
c
c
      integer i
      logical screen,landau
      save screen,landau
      real*8 eein, egin
c
c
c ------------------------- partical screening ----------------------
c
c           *** electron ***
c
c           ! egmin (gev)  for brems.
      data egmnl/.1e-3/
c
      parameter (eblmin=1.e-3, eblmax=10.,  nbtcl=13)
      dimension tcbl(nbtcl)
c
c             brem:   region a
c
      parameter (eela1=eblmin, eela2=eblmax,neela=13,
     * uela1=.05, uela2=1., nuela=16, duela=(uela2-uela1)/(nuela-1) )
      dimension bla(nuela *neela)
c
c             brem:  region b  (sqrt(u))
      parameter (eelb1=eblmin, eelb2=eblmax, neelb=neela,
     * uelb1=0.,  uelb2=.2236068, nuelb=16,
     * duelb=(uelb2-uelb1)/(nuelb-1) )
      dimension blb(nuelb *neelb)
c           ** gamma ***
c
c                 total cross-section
      parameter (eplmin=3.e-3, eplmax=300., nptcl=16)
      dimension tcpl(nptcl)
c
c          pair: region a
      parameter ( egla1=eplmin,  egla2=eplmax, negla=16,
     *   ugla1=.05, ugla2=1., nugla=16,dugla=(ugla2-ugla1)/(nugla-1) )
      dimension pla(nugla* negla)
c
c            pair: region b     sqrt(log10(e)) sqrt(u)
      parameter (eglb1=eplmin, eglb2=eplmax, neglb=11,
     *  uglb1=0., uglb2=.2236068, nuglb=16,
     *  duglb=(uglb2-uglb1)/(nuglb-1))
      dimension plb(nuglb* neglb)
c
c      -------------------- landau ------------------------------
c
c          **** electron ****
c
      data egmnh/1.e-3/
      parameter ( eeh1=5., eeh2= 50.e3, neeh=11,dueh1=.1,
     *  ueh1=0., ueh2=.7, nueh1=(ueh2-ueh1+.00001)/dueh1+1)
      dimension  tcbh(neeh)
      dimension  be1(nueh1* neeh)
c
c                         sqrt(1-.7)
      parameter (ueh3=0., ueh4=0.5477225,
     *nueh2=11, dvueh2=nueh2-1, dueh2=(ueh4 - ueh3)/dvueh2)
      dimension be2(nueh2*neeh)
c
c
c         *** gamma ****
c
      parameter ( egh1=5000., egh2= 50.e3,negh=3, dugh2=.1,
     * ugh3=0., ugh4=1., nugh2=(ugh4-ugh3+.00001)/dugh2+1)
      dimension tcph(negh)
      dimension vp(nugh2* negh)
c
c
c     ---------------------------------------------------------
c
      data debtcl/ 0.333333/
      data deela/ 0.333333/
      data deelb/ 0.333333/
      data deptcl/ 0.333333/
      data degla/ 0.333333/
      data deglb/ 0.223607/
c
c        electron energy=
c      0.10000e-02 0.21544e-02 0.46416e-02 0.10000e-01 0.21544e-01
c      0.46416e-01 0.10000     0.21544     0.46416      1.0000
c       2.1544      4.6416      10.000
c       log10 step=  0.3333
c
c      log10 of electron energy boundary
      data  etcbl1/-3.000000/
c    *     ,etcbl2/ 1.000000/
c
      data (tcbl  (i),i=   1,  13)/
     1 1.5070, 2.7976, 3.9519, 5.0559, 6.1424, 7.2178, 8.2807, 9.3316,
     210.3723,11.4056,12.4342,13.4594,14.4830/
c
c       brem: region a
c        electron energy=
c      0.10000e-02 0.21544e-02 0.46416e-02 0.10000e-01 0.21544e-01
c      0.46416e-01 0.10000     0.21544     0.46416      1.0000
c       2.1544      4.6416      10.000
c       log10 step=  0.3333
c
c      log10 of electron energy boundary
      data  eela1l/-3.000000/
c    *     ,eela2l/ 1.000000/
c
c
c            bla(iu,ie)=log(v/vmin)/(1.-u)
c            u=0.050 to 1.000 step= 0.0633
c            log10(e)= -3.0000 to   1.0000 step= 0.3333
c
      data (bla   (i),i=   1,  72)/
     1 1.4794, 1.3924, 1.3296, 1.2802, 1.2393, 1.2046, 1.1745, 1.1476,
     2 1.1238, 1.1022, 1.0825, 1.0641, 1.0473, 1.0294, 1.0204, 1.0027,
     3 2.4858, 2.3217, 2.2145, 2.1344, 2.0718, 2.0214, 1.9776, 1.9399,
     4 1.9124, 1.8859, 1.8616, 1.8410, 1.8227, 1.8059, 1.7915, 1.7768,
     5 3.3574, 3.1757, 3.0615, 2.9794, 2.9201, 2.8707, 2.8296, 2.7971,
     6 2.7680, 2.7435, 2.7224, 2.7039, 2.6879, 2.6734, 2.6599, 2.6497,
     7 4.2108, 4.0342, 3.9250, 3.8455, 3.7870, 3.7412, 3.7050, 3.6761,
     8 3.6524, 3.6333, 3.6173, 3.6039, 3.5924, 3.5829, 3.5760, 3.5682,
     9 5.0515, 4.8829, 4.7735, 4.6978, 4.6439, 4.6035, 4.5727, 4.5492/
      data (bla   (i),i=  73, 144)/
     1 4.5306, 4.5161, 4.5046, 4.4951, 4.4880, 4.4819, 4.4775, 4.4725,
     2 5.8752, 5.7071, 5.5992, 5.5276, 5.4777, 5.4419, 5.4158, 5.3964,
     3 5.3821, 5.3710, 5.3624, 5.3559, 5.3508, 5.3467, 5.3445, 5.3414,
     4 6.6796, 6.5089, 6.4016, 6.3325, 6.2861, 6.2544, 6.2321, 6.2163,
     5 6.2048, 6.1964, 6.1903, 6.1857, 6.1822, 6.1802, 6.1791, 6.1765,
     6 7.4670, 7.2909, 7.1838, 7.1175, 7.0748, 7.0467, 7.0278, 7.0148,
     7 7.0061, 6.9996, 6.9953, 6.9925, 6.9902, 6.9881, 6.9866, 6.9864,
     8 8.2413, 8.0583, 7.9520, 7.8890, 7.8501, 7.8256, 7.8099, 7.7994,
     9 7.7925, 7.7881, 7.7851, 7.7827, 7.7814, 7.7806, 7.7787, 7.7793/
      data (bla   (i),i= 145, 208)/
     1 9.0059, 8.8162, 8.7120, 8.6528, 8.6179, 8.5966, 8.5838, 8.5754,
     2 8.5702, 8.5671, 8.5649, 8.5635, 8.5626, 8.5618, 8.5626, 8.5613,
     3 9.7644, 9.5696, 9.4680, 9.4130, 9.3819, 9.3639, 9.3534, 9.3469,
     4 9.3428, 9.3406, 9.3390, 9.3381, 9.3378, 9.3376, 9.3359, 9.3369,
     510.5190,10.3205,10.2226,10.1718,10.1442,10.1290,10.1204,10.1155,
     610.1125,10.1108,10.1101,10.1094,10.1092,10.1088,10.1098,10.1085,
     711.2716,11.0709,10.9771,10.9307,10.9064,10.8937,10.8868,10.8828,
     810.8809,10.8798,10.8789,10.8788,10.8784,10.8784,10.8786,10.8781/
c
c       brem: region b
c        electron energy=
c      0.10000e-02 0.21544e-02 0.46416e-02 0.10000e-01 0.21544e-01
c      0.46416e-01 0.10000     0.21544     0.46416      1.0000
c       2.1544      4.6416      10.000
c       log10 step=  0.3333
c
c      log10 of electron energy boundary
      data  eelb1l/-3.000000/
c    *     ,eelb2l/ 1.000000/
c
c
c            blb(iu,ie)=log(v/vmin)/(1.-u)
c            sqrt(u)=0.0   to 0.224 step= 0.0149
c            log10(e)= -3.0000 to   1.0000 step= 0.3333
c
      data (blb   (i),i=   1,  72)/
     1 1.5872, 1.5861, 1.5832, 1.5783, 1.5716, 1.5631, 1.5530, 1.5413,
     2 1.5281, 1.5137, 1.4981, 1.4813, 1.4637, 1.4451, 1.4256, 1.4055,
     3 2.7994, 2.7941, 2.7797, 2.7592, 2.7344, 2.7070, 2.6774, 2.6462,
     4 2.6138, 2.5803, 2.5457, 2.5102, 2.4741, 2.4370, 2.3996, 2.3615,
     5 3.7210, 3.7092, 3.6857, 3.6582, 3.6282, 3.5960, 3.5620, 3.5262,
     6 3.4889, 3.4498, 3.4095, 3.3678, 3.3248, 3.2809, 3.2357, 3.1896,
     7 4.5527, 4.5377, 4.5148, 4.4888, 4.4602, 4.4292, 4.3957, 4.3599,
     8 4.3216, 4.2814, 4.2390, 4.1948, 4.1486, 4.1007, 4.0512, 4.0003,
     9 5.3487, 5.3345, 5.3147, 5.2917, 5.2656, 5.2365, 5.2046, 5.1700/
      data (blb   (i),i=  73, 144)/
     1 5.1324, 5.0919, 5.0491, 5.0038, 4.9557, 4.9057, 4.8530, 4.7989,
     2 6.1292, 6.1171, 6.1002, 6.0798, 6.0561, 6.0290, 5.9987, 5.9651,
     3 5.9283, 5.8880, 5.8448, 5.7982, 5.7489, 5.6962, 5.6402, 5.5815,
     4 6.9026, 6.8927, 6.8781, 6.8599, 6.8380, 6.8124, 6.7832, 6.7502,
     5 6.7136, 6.6729, 6.6282, 6.5794, 6.5264, 6.4698, 6.4093, 6.3456,
     6 7.6729, 7.6648, 7.6520, 7.6353, 7.6146, 7.5900, 7.5611, 7.5276,
     7 7.4897, 7.4470, 7.3994, 7.3472, 7.2902, 7.2288, 7.1632, 7.0936,
     8 8.4417, 8.4349, 8.4234, 8.4078, 8.3876, 8.3629, 8.3331, 8.2982,
     9 8.2580, 8.2124, 8.1614, 8.1051, 8.0434, 7.9765, 7.9051, 7.8292/
      data (blb   (i),i= 145, 208)/
     1 9.2098, 9.2040, 9.1934, 9.1782, 9.1577, 9.1320, 9.1007, 9.0635,
     2 9.0205, 8.9714, 8.9163, 8.8550, 8.7881, 8.7156, 8.6380, 8.5556,
     3 9.9776, 9.9726, 9.9625, 9.9468, 9.9256, 9.8985, 9.8651, 9.8253,
     4 9.7789, 9.7257, 9.6661, 9.5997, 9.5272, 9.4487, 9.3649, 9.2762,
     510.7453,10.7407,10.7306,10.7145,10.6920,10.6631,10.6272,10.5844,
     610.5345,10.4771,10.4125,10.3410,10.2627,10.1782,10.0882, 9.9930,
     711.5129,11.5087,11.4982,11.4812,11.4574,11.4263,11.3881,11.3419,
     811.2881,11.2263,11.1568,11.0799,10.9959,10.9055,10.8094,10.7080/
c
c       pair: total x-section
c        gamm energy=
c      0.30000e-02 0.64633e-02 0.13925e-01 0.30000e-01 0.64633e-01
c      0.13925     0.30000     0.64633      1.3925      3.0000
c       6.4633      13.925      30.000      64.633      139.25
c       300.00
c       log10 step=  0.3333
c
c      log10 of gamma energy boundary
      data  etcpl1/-2.522879/
c    *     ,etcpl2/ 2.477121/
c
      data (tcpl  (i),i=   1,  16)/
     1 0.0431, 0.1505, 0.2724, 0.3949, 0.5101, 0.6019, 0.6642, 0.7034,
     2 0.7268, 0.7401, 0.7474, 0.7514, 0.7535, 0.7546, 0.7552, 0.7554/
c
c       pair: region a
c
c         energy of gamma=
c        0.300e-02   0.646e-02   0.139e-01   0.300e-01   0.646e-01
c        0.139       0.300       0.646        1.39        3.00
c         6.46        13.9        30.0        64.6        139.
c         300.
c         log10 step= 0.333333
c
c         log10 of eg boundary
      data  egla1l/-2.522879/
c    *     ,egla2l/ 2.477121/
c
c
c         pla(iu,ie)=(v-.5)/(1.-u)
c         u=0.050 to1.000   step= 0.0633
c            log10(e)= -2.5229 to   2.4771 step= 0.3333
c
      data (pla   (i),i=   1,  72)/
     1 0.2674, 0.2554, 0.2478, 0.2424, 0.2382, 0.2349, 0.2323, 0.2301,
     2 0.2283, 0.2269, 0.2258, 0.2248, 0.2243, 0.2240, 0.2230, 0.2234,
     3 0.3828, 0.3694, 0.3618, 0.3565, 0.3528, 0.3499, 0.3477, 0.3459,
     4 0.3446, 0.3436, 0.3429, 0.3422, 0.3416, 0.3412, 0.3416, 0.3411,
     5 0.4319, 0.4214, 0.4158, 0.4125, 0.4102, 0.4089, 0.4079, 0.4073,
     6 0.4071, 0.4070, 0.4070, 0.4070, 0.4069, 0.4070, 0.4067, 0.4071,
     7 0.4579, 0.4507, 0.4475, 0.4460, 0.4456, 0.4456, 0.4461, 0.4469,
     8 0.4478, 0.4485, 0.4492, 0.4503, 0.4507, 0.4512, 0.4519, 0.4517,
     9 0.4732, 0.4687, 0.4676, 0.4680, 0.4690, 0.4705, 0.4727, 0.4744/
      data (pla   (i),i=  73, 144)/
     1 0.4760, 0.4782, 0.4797, 0.4806, 0.4813, 0.4840, 0.4851, 0.4840,
     2 0.4832, 0.4819, 0.4832, 0.4857, 0.4887, 0.4922, 0.4956, 0.4990,
     3 0.5022, 0.5059, 0.5087, 0.5111, 0.5129, 0.5144, 0.5156, 0.5153,
     4 0.4905, 0.4922, 0.4959, 0.5003, 0.5049, 0.5097, 0.5145, 0.5190,
     5 0.5237, 0.5278, 0.5315, 0.5347, 0.5374, 0.5390, 0.5402, 0.5403,
     6 0.4958, 0.4999, 0.5050, 0.5105, 0.5163, 0.5220, 0.5276, 0.5332,
     7 0.5384, 0.5432, 0.5475, 0.5511, 0.5541, 0.5564, 0.5576, 0.5580,
     8 0.4995, 0.5050, 0.5111, 0.5174, 0.5238, 0.5301, 0.5364, 0.5423,
     9 0.5479, 0.5532, 0.5580, 0.5622, 0.5654, 0.5679, 0.5696, 0.5696/
      data (pla   (i),i= 145, 216)/
     1 0.5019, 0.5082, 0.5150, 0.5218, 0.5285, 0.5352, 0.5417, 0.5480,
     2 0.5542, 0.5596, 0.5643, 0.5686, 0.5721, 0.5744, 0.5766, 0.5768,
     3 0.5036, 0.5102, 0.5173, 0.5243, 0.5313, 0.5383, 0.5451, 0.5515,
     4 0.5576, 0.5632, 0.5683, 0.5726, 0.5760, 0.5789, 0.5805, 0.5810,
     5 0.5045, 0.5115, 0.5187, 0.5257, 0.5329, 0.5399, 0.5468, 0.5535,
     6 0.5596, 0.5655, 0.5707, 0.5751, 0.5783, 0.5813, 0.5825, 0.5833,
     7 0.5050, 0.5122, 0.5194, 0.5267, 0.5338, 0.5409, 0.5479, 0.5545,
     8 0.5607, 0.5665, 0.5718, 0.5760, 0.5797, 0.5823, 0.5845, 0.5846,
     9 0.5053, 0.5126, 0.5199, 0.5271, 0.5343, 0.5415, 0.5483, 0.5550/
      data (pla   (i),i= 217, 256)/
     1 0.5613, 0.5671, 0.5722, 0.5770, 0.5803, 0.5833, 0.5845, 0.5853,
     2 0.5056, 0.5128, 0.5200, 0.5274, 0.5347, 0.5417, 0.5488, 0.5555,
     3 0.5616, 0.5675, 0.5726, 0.5770, 0.5806, 0.5833, 0.5854, 0.5857,
     4 0.5056, 0.5129, 0.5202, 0.5275, 0.5347, 0.5419, 0.5488, 0.5555,
     5 0.5618, 0.5678, 0.5730, 0.5775, 0.5811, 0.5838, 0.5854, 0.5859/
c
c
c       pair: region b
c
c         energy of gamma=
c        0.300e-02   0.337e-02   0.475e-02   0.846e-02   0.189e-01
c        0.533e-01   0.189       0.846        4.75        33.7
c         300.
c         sqrt(log10) step= 0.223607
c
c         use 0 for e-side at interpolation
c         with sqrt(log10(e)-eglb1l)
      data  eglb1l/-2.522879/
c
c
c         plb(iu,ie)=v
c         sqrt(u)=0.0   to0.224   step= 0.0149
      data (plb   (i),i=   1,  72)/
     1 0.8297, 0.7889, 0.7881, 0.7869, 0.7853, 0.7833, 0.7810, 0.7786,
     2 0.7759, 0.7731, 0.7702, 0.7672, 0.7640, 0.7607, 0.7574, 0.7540,
     3 0.8482, 0.8227, 0.8215, 0.8195, 0.8171, 0.8145, 0.8115, 0.8084,
     4 0.8051, 0.8018, 0.7983, 0.7948, 0.7912, 0.7875, 0.7838, 0.7801,
     5 0.8925, 0.8872, 0.8839, 0.8803, 0.8767, 0.8729, 0.8692, 0.8654,
     6 0.8615, 0.8576, 0.8536, 0.8495, 0.8454, 0.8413, 0.8370, 0.8328,
     7 0.9396, 0.9379, 0.9349, 0.9315, 0.9280, 0.9244, 0.9207, 0.9170,
     8 0.9131, 0.9091, 0.9052, 0.9010, 0.8968, 0.8926, 0.8882, 0.8837,
     9 0.9730, 0.9716, 0.9689, 0.9660, 0.9630, 0.9598, 0.9565, 0.9531/
      data (plb   (i),i=  73, 144)/
     1 0.9496, 0.9459, 0.9422, 0.9384, 0.9345, 0.9303, 0.9262, 0.9219,
     2 0.9904, 0.9890, 0.9870, 0.9847, 0.9822, 0.9797, 0.9770, 0.9741,
     3 0.9711, 0.9680, 0.9647, 0.9614, 0.9579, 0.9542, 0.9504, 0.9465,
     4 0.9973, 0.9963, 0.9948, 0.9932, 0.9914, 0.9896, 0.9874, 0.9852,
     5 0.9829, 0.9804, 0.9777, 0.9749, 0.9719, 0.9688, 0.9656, 0.9620,
     6 0.9994, 0.9987, 0.9979, 0.9969, 0.9957, 0.9943, 0.9927, 0.9912,
     7 0.9893, 0.9874, 0.9852, 0.9830, 0.9806, 0.9780, 0.9753, 0.9724,
     8 0.9999, 0.9996, 0.9990, 0.9984, 0.9975, 0.9965, 0.9954, 0.9941,
     9 0.9926, 0.9910, 0.9893, 0.9874, 0.9852, 0.9830, 0.9804, 0.9779/
      data (plb   (i),i= 145, 176)/
     1 1.0000, 0.9998, 0.9994, 0.9989, 0.9983, 0.9975, 0.9965, 0.9953,
     2 0.9941, 0.9925, 0.9909, 0.9889, 0.9870, 0.9848, 0.9823, 0.9798,
     3 1.0000, 0.9999, 0.9996, 0.9992, 0.9986, 0.9977, 0.9969, 0.9957,
     4 0.9944, 0.9930, 0.9913, 0.9894, 0.9875, 0.9853, 0.9828, 0.9803/
c
c    ---------------     $$$   landau correction region $$$     ----
c
      data deelh/ 0.400000/
      data deghl/ 0.500000/
c
c          energy of electron
c        5.000       12.56       31.55       79.24       199.1
c        500.0       1256.       3155.       7924.      0.1991e+05
c       0.5000e+05
c         log10 step= 0.400000
c
c         log10 of electron energy boundary
      data eeh1l/ 0.698970/
c    *     ,eeh2l/ 4.698970/
c
      data (tcbh  (i),i=   1,  11)/
     1 10.5198, 11.2635, 11.1881, 10.5177,  9.5361,  8.4171,  7.2475,
     2  6.0733,  4.9355,  3.8782,  2.9415/
c
c          be1(iu,ie)= log(v/vmin)
c          from u=0.0   to 0.700 step=0.100
c          from log10(e)=  0.6990 to  4.6990 step  0.4000
c          dim. of u=  8 dim of e= 11
c
      data (   be1(i),i=   1,  54)/
     1  8.51719,  7.38708,  6.43279,  5.57703,  4.75936,  3.95767,
     2  3.16296,  2.36936,  9.43823,  8.23486,  7.22897,  6.32255,
     3  5.45263,  4.59728,  3.74422,  2.90899, 10.35926,  9.16326,
     4  8.16258,  7.26130,  6.39670,  5.54211,  4.71018,  3.86661,
     5 11.28029, 10.15039,  9.19626,  8.34064,  7.51936,  6.72673,
     6  5.93796,  5.09997, 12.20133, 11.16998, 10.28493,  9.49317,
     7  8.74862,  8.02722,  7.28619,  6.46897, 13.12236, 12.20609,
     8 11.40080, 10.68799, 10.02623,  9.36912,  8.67479,  7.88638,
     9 14.04340, 13.25060, 12.53280, 11.90766, 11.31529, 10.71294/
      data (   be1(i),i=  55,  88)/
     1 10.06098,  9.30326, 14.96443, 14.29730, 13.68008, 13.12824,
     2 12.59157, 12.03430, 11.41893, 10.69028, 15.88547, 15.34599,
     3 14.82372, 14.33132, 13.83930, 13.31804, 12.73304, 12.03001,
     4 16.80650, 16.38649, 15.94673, 15.50383, 15.04749, 14.55507,
     5 13.99442, 13.31279, 17.72754, 17.40863, 17.03979, 16.63873,
     6 16.21011, 15.73972, 15.19805, 14.53344/
c
c         be2(iu,ie)= (sqrt(v) -sqrtv)/(1.-u)
c          from sqrt(1-u)=0.0   to 0.548 step= 0.055
c          from log10(e)= 0.698970 to 4.698970 step  0.4000
c
      data (   be2(i),i=   1,  63)/
     1  0.0589,  0.0592,  0.0600,  0.0615,  0.0637,  0.0667,  0.0708,
     2  0.0763,  0.0837,  0.0936,  0.1070,  0.0595,  0.0597,  0.0604,
     3  0.0617,  0.0635,  0.0659,  0.0693,  0.0736,  0.0794,  0.0871,
     4  0.0976,  0.0726,  0.0728,  0.0737,  0.0750,  0.0770,  0.0796,
     5  0.0831,  0.0876,  0.0933,  0.1009,  0.1110,  0.0954,  0.0957,
     6  0.0969,  0.0987,  0.1012,  0.1045,  0.1087,  0.1139,  0.1205,
     7  0.1289,  0.1398,  0.1277,  0.1283,  0.1301,  0.1328,  0.1363,
     8  0.1407,  0.1460,  0.1524,  0.1603,  0.1700,  0.1822,  0.1702,
     9  0.1715,  0.1747,  0.1789,  0.1838,  0.1895,  0.1962,  0.2040/
      data (   be2(i),i=  64, 121)/
     1  0.2134,  0.2246,  0.2384,  0.2236,  0.2263,  0.2319,  0.2381,
     2  0.2449,  0.2522,  0.2604,  0.2698,  0.2806,  0.2934,  0.3086,
     3  0.2874,  0.2929,  0.3018,  0.3107,  0.3194,  0.3284,  0.3382,
     4  0.3489,  0.3611,  0.3751,  0.3915,  0.3688,  0.3713,  0.3832,
     5  0.3945,  0.4052,  0.4158,  0.4269,  0.4388,  0.4519,  0.4667,
     6  0.4837,  0.4591,  0.4598,  0.4722,  0.4854,  0.4977,  0.5096,
     7  0.5217,  0.5343,  0.5480,  0.5632,  0.5803,  0.5519,  0.5522,
     8  0.5626,  0.5769,  0.5903,  0.6031,  0.6158,  0.6288,  0.6426,
     9  0.6577,  0.6745/
c
c
c         energy of gamma
c        5000.      0.1581e+05  0.5000e+05
c       log10 step= 0.500000
c
c       log10 of gamma energy boundary
      data egh1l/ 3.698970/
c    *     ,egh1l/ 4.698970/
c
      data (tcph  (i),i=   1,   3)/
     1  0.7778,  0.7742,  0.7677/
c
c        table of v
c        from u= 0.0    to  1.0000 step  0.1000
c        from log10(e)= 3.698970 to 4.698970 step  0.5000
c
      data (   vp (i),i=   1,  33)/
     1 1.0000, 0.9601, 0.9180, 0.8736, 0.8267, 0.7774, 0.7257, 0.6716,
     2 0.6156, 0.5582, 0.5000, 1.0000, 0.9603, 0.9184, 0.8741, 0.8271,
     3 0.7775, 0.7255, 0.6713, 0.6152, 0.5581, 0.5000, 1.0000, 0.9606,
     4 0.9187, 0.8751, 0.8291, 0.7804, 0.7290, 0.6746, 0.6181, 0.5596,
     5 0.5000/
c
c       total prob. equivalenced to common
c
      equivalence (tprob,tp)
c

c
c                         complete screening pair x-sxec.
c                         0.703 =(7/9-b)*rx0 =.773*rx0
      data rx0/0.972/, ctpc/.751/,  cep/5.e3/
c       rx0=x0(true)/x0(in nishimura text)=5.82/6.4
c       cep:  minimum energy for landau correction for pair.
c          default esbc espc
      data esbin/10./,  espin/50./
c
c
      ee=eein
      if(ee .lt. eblmin) then
          t=1.e36
      else
          if(.not. usees) then
             esb=esbin
          else
             esb=min(escb, eblmax)
          endif
          if(ee .gt. esb) then
              screen=.false.
              if(lcorec .and. ee .gt. eeh1) then
                  if(ee .gt. eeh2) then
                       write(6,'('' ee > eeh2 in brmg5t: ee='',g12.4)')
     *                 ee
                       write(*,*) ' assume thin emulsion so that ',
     *                 ' exact cross-section not needed'
                       ee=eeh2
                  endif
                  landau=.true.
                  ale=log10(ee)
c                 tp=fintp3(tcbh, eeh1l, deelh, neeh, ale)*rx0
                  call kintp3(tcbh, 1, neeh, eeh1l, deelh, ale, tp)
                  tp=tp*rx0
              else
                  landau=.false.
c                     complete screening cross-section
                  vc=ec/ee
                  tp=(-1.3603*(log(vc)-vc)-vc*vc*.5-.8603 )*rx0
              endif
          else
              landau=.false.
              if(scorec) then
                  screen=.true.
                  ale=log10(ee)
c                 tp=fintp3(tcbl, etcbl1, debtcl, nbtcl,  ale)
                  call kintp3(tcbl, 1, nbtcl, etcbl1, debtcl,  ale, tp)
              else
                  screen=.false.
c                     complete screening cross-section
                  vc=ec/ee
                  tp=(-1.3603*(log(vc)-vc)-vc*vc*.5-.8603 )*rx0
              endif
          endif
c
          call rndc(u)
          t =-log(u)/tp
      endif
      return
c
c     ************
      entry brmg5e(eein,ec,beg)
c     ************
c
      ee=eein
      call rndc(u)
      if(screen) then
c           partial screening
         if(u .gt. uela1) then
c                  region a
c              beg=exp( tdint4(bla, nuela, neela, uela1, eela1l, duela,
c    *         deela, u,  ale)*(1.-u) ) *egmnl
               call k4ptdi(bla, nuela, neela, nuela, uela1, eela1l,
     *         duela, deela, u, ale, ans)
               beg=exp( ans*(1.-u))*egmnl
         else
c                  region b
               us=sqrt(u)
c              beg=exp( tdint4(blb, nuelb, neelb, uelb1, eelb1l,duelb,
c    *         deelb, us, ale)) * egmnl
               call k4ptdi(blb, nuelb, neelb, nuelb, uelb1, eelb1l,
     *         duelb, deelb, us, ale, ans)
               beg=exp(ans)*egmnl
         endif
      elseif(landau) then
         if(ee .gt. eeh2) then
             ee=eeh2
         endif
         if(u .lt. ueh2) then
c              beg=exp( tdint4(be1, nueh1, neeh, ueh1, eeh1l, dueh1,
c    *         deelh, u,  ale)  ) * egmnh
               call k4ptdi(be1, nueh1, neeh, nueh1,  ueh1, eeh1l,
     *         dueh1, deelh, u,  ale, ans)
               beg=exp( ans ) *egmnh
         else
               us=sqrt(1.-u)
c              beg=   ( tdint4(be2, nueh2, neeh, ueh3, eeh1l, dueh2,
c    *         deelh, us,  ale)*(1.-u)+ sqrt(egmnh/ee) )**2 *eein
               call k4ptdi(be2, nueh2, neeh, nueh2,  ueh3, eeh1l,
     *         dueh2, deelh, us,  ale, ans)
               beg=  (ans*(1.-u) + sqrt(egmnh/ee) )**2*ee
         endif
      else
c               complete screening
          a=u*tp
          if(a .le. 1.) then
             v=exp(-a)
             if(a .gt. .1) then
                 v=((.06366*a-.1447407)*a+1.014176)*v
             endif
          else
             v=exp(-(a+0.8603)/1.3603)
             if(a .le. 6.) then
                 v=((((2.050445e-3*a-3.53209e-2)*a+.228937)*a-.684076)*a
     *           +1.841734)*v
             endif
          endif
          beg=ee*v
      endif
      return
c
c
c     ***********
      entry prcg5t(egin,t)
c     ***********
c
c
      eg=egin
c
      if(eg .le. emass2) then
          t=1.e37
      elseif(eg .lt. eplmin .and. scorec) then
          tp=( (eg-emass2)/(eplmin-emass2) )**3 * tcpl(1)
          call rndc(u)
          t =-log(u)/tp
          landau=.false.
          screen=.true.
      else
          if(.not. usees) then
             esp=espin
          else
             esp=min(escp, eplmax)
          endif
          if(eg .gt. esp) then
              screen=.false.
              if(eg .gt. cep   .and. lcorec) then
                  landau=.true.
                  if(eg .gt. egh2) then
                       write(*,*)' too high eg. but if thin layer',
     *                 ' no problem (eg>', egh2,')'
                       eg=egh2
                  endif
                  ale=log10(eg)
c                 tp=fintp3(tcph, egh1l, deghl, negh, ale)*rx0
                  call kintp3(tcph, 1, negh,  egh1l,  deghl,   ale, tp)
                  tp=tp*rx0
              else
                  landau=.false.
c                     complete screening cross-section
                  tp=ctpc
              endif
          else
              landau=.false.
              if(scorec) then
                  screen=.true.
                  ale=log10(eg)
c                 tp=fintp3(tcpl, etcpl1, deptcl, nptcl, ale)
                  call kintp3(tcpl, 1,nptcl,  etcpl1, deptcl,  ale, tp)
              else
                  screen=.false.
c                     complete screening cross-section
                  tp=ctpc
              endif
          endif
          call rndc(u)
          t =-log(u)/tp
      endif
      return
c
c
c     ***********
      entry prcg5e(egin,e1)
c     ***********
c
c
c
      eg=egin
      call rndc(u)
      if(screen) then
c           partial screening
         if(u .ge. ugla1) then
c                   region a
c               e1=(tdint4(pla, nugla, negla, ugla1, egla1l, dugla,
c    *          degla, u,    ale) *(1.-u) + .5 )*eg
                call k4ptdi(pla, nugla, negla,nugla,  ugla1, egla1l,
     *          dugla, degla, u,   ale, ans)
                e1=(ans*(1.-u) + .5)*eg
         else
c                   region b
                us=sqrt(u)
                ex=sqrt(ale-eglb1l)
                call k4ptdi(plb, nuglb, neglb,nuglb,  uglb1, 0.d0,
     *          duglb, deglb, us,  ale, ans)
                e1=ans*eg
         endif
      elseif(landau) then
c        e1= tdint4(vp, nugh2, negh, ugh3, egh1l, dugh2,
c    *   deghl, u,  ale) * egin
         call k4ptdi(vp, nugh2, negh, nugh2, ugh3, egh1l,
     *   dugh2, deghl, u,  ale, ans)
         e1=ans*eg
      else
c                complete screening
         e1=(((.0441223*u-.173755)*u-.3708608)*u+1.)*eg
      endif
      return
c
c     ************
      entry emctg5(Knckon)
c     ************
c
c               cconst=for compton=3/8*thomson*n0*z/a*x0ing
c               to convert cross-section in compt into /(r.l).
      cconst=.675
      x0=2.893
      x0ing=11.075
      x0sq=8.369
      if(Knckon) then
          ecrit=13.1e-3
      else
          ecrit=15.0e-3
      endif
      constm=1.352
      rho = 3.828
c
      zchrg=35.8
      zchrg2 = 1491.
      amassn= 81.72
      ionizP = 299.7d-9
      end
