c     ************************ for Carbon*********************************
c     *                                                              *
c     *  brmCarbont:  samples path for brems                             *
c     *  brmCarbone:  samples energy of brems gamma                      *
c     *  prcCarbont:  samples path for pair creation                     *
c     *  prcCarbone:  samples energy of pair electron (higher energy)    *
c     *  emctCarbon:  set const in common for Carbon                         *
c     *                                                              *
c
c      material   z     a     rho     t0 (g/cm2)  t0 (cm)    ec
c      Carbon     6    12    2.2     42.7       19.4      75.0
c  actual carbon density may vary from this
c brems:
c        electron energy:      1 MeV to 5000TeV
c        brems gamma energy:   .1mev or more
c           if electron energy is < 1MeV,  sampled path is set to be
c        very large one so that real brems may not take place before
c        the death by energy loss.
c pair:
c        gamma energy:         3 MeV to 5000 TeV
c           if gamma energy is < 3MeV, sampled path is set to be
c        very large one so that real pair creation may not take place
c        before compton or another process takes place.
c
c
c
c
c   /usage/          call brmCarbont(ee,ec,t)
c                    call brmCarbone(ee,ec,beg)
c
c                    call prcCarbont(eg,t)
c                    call prcCarbone(eg,e1)
c
c      ee:  incident electron energy
c      ec:  cut-off energy of brems gamma (used if complete screening
c           cross section is to be used).
c       t:  sampled path
c     beg:  sampled gamma energy
c      eg:  incident gamma energy
c      e1:  sampled electron energy (higher energy in pair)
c
c  *** note ***
c
c          before calling brmCarbone, brmCarbont must have been called.
c          //             prcCarbone, prcCarbont //
c
c          by the parameters in $elmag the user can control:
cc
c
      subroutine brmCarbont(ee,ec,t)
      implicit none
c
c
#include  "Zelmag.h"
#include  "Zemdef.h"
c
      integer i
      logical screen,landau
      save screen,landau
c
c ------------------------- partical screening ----------------------
c           *** electron ***
c
c           ! egmin (gev)  for brems.
      data egmnl/.1e-3/
c
      parameter (eblmin=1.e-3, eblmax=50., nbtcl=40)
      dimension tcbl(nbtcl)
c
c             brem:   region a
c
      parameter (eela1=eblmin, eela2=eblmax,neela=20,
     * uela1=.05, uela2=1., nuela=20, duela=(uela2-uela1)/(nuela-1) )
      dimension bla(nuela * neela)
c
c             brem:  region b  (sqrt(u))
      parameter (eelb1=eblmin, eelb2=eblmax, neelb=neela,
     * uelb1=0.,  uelb2=.2236068, nuelb=20,
     * duelb=(uelb2-uelb1)/(nuelb-1) )
      dimension blb(nuelb * neelb)
c
c           ** gamma ***
c
c                 total cross-section
      parameter (eplmin=3.e-3, eplmax= 30., nptcl=16)
      dimension tcpl(nptcl)
c
c          pair: region a
      parameter ( egla1=eplmin,  egla2=eplmax, negla=16,
     *   ugla1=.05, ugla2=1., nugla=16,dugla=(ugla2-ugla1)/(nugla-1) )
      dimension pla(nugla * negla)
c
c            pair: region b     sqrt(log10(e)) sqrt(u)
      parameter (eglb1=eplmin, eglb2=eplmax, neglb=15,
     *  uglb1=0., uglb2=.2236068, nuglb=16,
     *  duglb=(uglb2-uglb1)/(nuglb-1))
      dimension plb(nuglb * neglb)
c
c
c      -------------------- landau ------------------------------

c          **** electron ****
c
      data egmnh/1.e-4/
      parameter (eeh1=20., eeh2 = 5000.e3, neeh=25, dueh1=.1,
     *  ueh1=0., ueh2=.7, nueh1=(ueh2-ueh1+.00001)/dueh1+1)
      dimension  tcbh(neeh)
      dimension  be1(nueh1 * neeh)
c
c                         sqrt(1-.7)
      parameter (ueh3=0., ueh4=0.5477225,
     *nueh2=11, dvueh2=nueh2-1, dueh2=(ueh4 - ueh3)/dvueh2)
      dimension be2(nueh2 * neeh)
c
c         *** gamma ****
c
       parameter ( egh1=10000., egh2= 5000.e3, negh=20, dugh2=.1,
     * ugh3=0., ugh4=1., nugh2=(ugh4-ugh3+.00001)/dugh2+1)
      dimension tcph(negh)
      dimension vp(nugh2 * negh)
c
c-----------------------------------------
c
      data debtcl/  .120486/
      data deela/  .247314/
      data deelb/  .247314/
      data deptcl/  .266667/
      data degla/  .266667/
      data deglb/  .142857/
c        electron energy=
c       .10000E-02  .13197E-02  .17417E-02  .22986E-02  .30335E-02
c       .40034E-02  .52835E-02  .69728E-02  .92022E-02  .12144E-01
c       .16027E-01  .21152E-01  .27915E-01  .36840E-01  .48619E-01
c       .64165E-01  .84680E-01  .11176      .14749      .19464    
c       .25688      .33901      .44741      .59046      .77925    
c       1.0284      1.3572      1.7912      2.3639      3.1197    
c       4.1171      5.4335      7.1708      9.4635      12.489    
c       16.483      21.753      28.708      37.887      50.000    
c       log10 step=   .1205
c
c      log10 of electron energy boundary
      data  etcbl1/-3.000000/
c    *     ,etcbl2/ 1.698970/
c
           data ( tcbl(i), i= 1,  40)/
     1  1.0209, 1.4324, 1.8611, 2.3158, 2.7785, 3.2473, 3.7163, 4.1835,
     2  4.6453, 5.1018, 5.5509, 5.9928, 6.4289, 6.8575, 7.2807, 7.6973,
     3  8.1091, 8.5157, 8.9178, 9.3163, 9.7114,10.1031,10.4925,10.8797,
     4 11.2648,11.6484,12.0307,12.4119,12.7922,13.1718,13.5507,13.9290,
     5 14.3069,14.6845,15.0618,15.4389,15.8159,16.1927,16.5694,16.9461  
     * /   
c
c       brem: region a
c        electron energy=
c       .10000E-02  .17673E-02  .31234E-02  .55200E-02  .97557E-02
c       .17241E-01  .30471E-01  .53852E-01  .95173E-01  .16820    
c       .29726      .52536      .92848      1.6409      2.9000    
c       5.1252      9.0579      16.008      28.292      50.000    
c       log10 step=   .2473
c
c      log10 of electron energy boundary
      data  eela1l/-3.000000/
c    *     ,eela2l/ 1.698970/
c
c
c            bla(iu,ie)=alog(v/vmin)/(1.-u)
c            u= .050 to 1.000 step=  .0500
c            log10(e)= -3.0000 to   1.6990 step=  .2473
c
           data ( bla(i), i= 1,  119)/
     1   1.4823,  1.4128,  1.3591,  1.3150,  1.2766,  1.2438,  1.2146,
     2   1.1905,  1.1691,  1.1465,  1.1263,  1.1107,  1.0936,  1.0802,
     3   1.0644,  1.0536,  1.0358,  1.0194,  1.0183,  1.0040,  2.2573,
     4   2.1278,  2.0360,  1.9659,  1.9076,  1.8587,  1.8160,  1.7777,
     5   1.7466,  1.7167,  1.6897,  1.6659,  1.6438,  1.6248,  1.6021,
     6   1.5863,  1.5654,  1.5466,  1.5346,  1.5203,  2.9041,  2.7494,
     7   2.6419,  2.5602,  2.4936,  2.4383,  2.3914,  2.3519,  2.3185,
     8   2.2869,  2.2601,  2.2362,  2.2176,  2.1984,  2.1817,  2.1632,
     9   2.1524,  2.1386,  2.1360,  2.1141,  3.5348,  3.3702,  3.2578,
     a   3.1732,  3.1072,  3.0546,  3.0117,  2.9765,  2.9458,  2.9195,
     b   2.8964,  2.8719,  2.8541,  2.8393,  2.8247,  2.8082,  2.7907,
     c   2.7865,  2.7789,  2.7668,  4.1581,  3.9949,  3.8856,  3.8052,
     d   3.7454,  3.6958,  3.6570,  3.6241,  3.5951,  3.5708,  3.5512,
     e   3.5312,  3.5176,  3.5044,  3.4918,  3.4809,  3.4679,  3.4672,
     f   3.4635,  3.4515,  4.7785,  4.6219,  4.5174,  4.4429,  4.3826,
     g   4.3380,  4.3014,  4.2707,  4.2488,  4.2284,  4.2098,  4.1972,
     h   4.1852,  4.1754,  4.1677,  4.1601,  4.1517,  4.1466,  4.1449   
     * /   
           data ( bla(i), i= 120,  238)/
     1   4.1380,  5.3933,  5.2445,  5.1438,  5.0686,  5.0135,  4.9721,
     2   4.9387,  4.9127,  4.8933,  4.8763,  4.8637,  4.8519,  4.8406,
     3   4.8345,  4.8289,  4.8241,  4.8196,  4.8151,  4.8155,  4.8090,
     4   6.0029,  5.8578,  5.7573,  5.6860,  5.6337,  5.5952,  5.5649,
     5   5.5432,  5.5243,  5.5110,  5.4993,  5.4891,  5.4822,  5.4773,
     6   5.4711,  5.4668,  5.4633,  5.4585,  5.4583,  5.4594,  6.6042,
     7   6.4573,  6.3588,  6.2901,  6.2408,  6.2035,  6.1778,  6.1572,
     8   6.1417,  6.1284,  6.1197,  6.1146,  6.1082,  6.1040,  6.1011,
     9   6.0985,  6.0958,  6.0905,  6.0940,  6.0900,  7.1947,  7.0478,
     a   6.9488,  6.8811,  6.8339,  6.8018,  6.7769,  6.7593,  6.7438,
     b   6.7347,  6.7257,  6.7229,  6.7165,  6.7114,  6.7087,  6.7046,
     c   6.7054,  6.6996,  6.7118,  6.7037,  7.7785,  7.6290,  7.5293,
     d   7.4632,  7.4185,  7.3864,  7.3637,  7.3478,  7.3363,  7.3295,
     e   7.3208,  7.3166,  7.3150,  7.3096,  7.3127,  7.3080,  7.3119,
     f   7.3067,  7.2919,  7.3047,  8.3557,  8.2001,  8.1020,  8.0374,
     g   7.9942,  7.9662,  7.9465,  7.9304,  7.9210,  7.9134,  7.9090,
     h   7.9031,  7.9007,  7.9004,  7.8966,  7.8958,  7.8976,  7.8951   
     * /   
           data ( bla(i), i= 239,  357)/
     1   7.8972,  7.8957,  8.9262,  8.7672,  8.6691,  8.6068,  8.5656,
     2   8.5388,  8.5207,  8.5080,  8.5004,  8.4925,  8.4903,  8.4858,
     3   8.4860,  8.4831,  8.4801,  8.4830,  8.4807,  8.4757,  8.4741,
     4   8.4794,  9.4916,  9.3301,  9.2317,  9.1710,  9.1329,  9.1076,
     5   9.0922,  9.0807,  9.0741,  9.0688,  9.0649,  9.0616,  9.0628,
     6   9.0598,  9.0584,  9.0572,  9.0595,  9.0519,  9.0464,  9.0583,
     7  10.0542,  9.8882,  9.7917,  9.7340,  9.6987,  9.6771,  9.6625,
     8   9.6514,  9.6471,  9.6422,  9.6380,  9.6392,  9.6382,  9.6381,
     9   9.6375,  9.6325,  9.6391,  9.6291,  9.6430,  9.6340, 10.6149,
     a  10.4472, 10.3514, 10.2977, 10.2644, 10.2428, 10.2300, 10.2230,
     b  10.2167, 10.2133, 10.2122, 10.2108, 10.2088, 10.2100, 10.2100,
     c  10.2071, 10.2109, 10.2108, 10.2255, 10.2073, 11.1740, 11.0052,
     d  10.9114, 10.8580, 10.8282, 10.8088, 10.7975, 10.7902, 10.7871,
     e  10.7830, 10.7833, 10.7816, 10.7820, 10.7799, 10.7811, 10.7814,
     f  10.7767, 10.7868, 10.7762, 10.7790, 11.7327, 11.5618, 11.4715,
     g  11.4205, 11.3918, 11.3749, 11.3664, 11.3584, 11.3547, 11.3543,
     h  11.3521, 11.3513, 11.3488, 11.3485, 11.3509, 11.3467, 11.3518   
     * /   
           data ( bla(i), i= 358,  400)/
     1  11.3495, 11.3573, 11.3499, 12.2910, 12.1198, 12.0306, 11.9831,
     2  11.9568, 11.9414, 11.9315, 11.9270, 11.9245, 11.9229, 11.9217,
     3  11.9216, 11.9199, 11.9175, 11.9226, 11.9237, 11.9214, 11.9254,
     4  11.9182, 11.9201, 12.8489, 12.6769, 12.5911, 12.5455, 12.5221,
     5  12.5077, 12.5005, 12.4966, 12.4951, 12.4903, 12.4928, 12.4928,
     6  12.4892, 12.4901, 12.4914, 12.4881, 12.4886, 12.4893, 12.4773,
     7  12.4901                                                         
     * /   
c
c       brem: region b
c        electron energy=
c       .10000E-02  .17673E-02  .31234E-02  .55200E-02  .97557E-02
c       .17241E-01  .30471E-01  .53852E-01  .95173E-01  .16820    
c       .29726      .52536      .92848      1.6409      2.9000    
c       5.1252      9.0579      16.008      28.292      50.000    
c       log10 step=   .2473
c
c      log10 of electron energy boundary
      data  eelb1l/-3.000000/
c    *     ,eelb2l/ 1.698970/
c
c
c            blb(iu,ie)=alog(v/vmin)/(1.-u)
c            sqrt(u)= .000 to  .224 step=  .0118
c            log10(e)= -3.0000 to   1.6990 step=  .2473
c
           data ( blb(i), i= 1,  119)/
     1   1.5872,-10.1959,  1.5844,  1.5813,  1.5781,  1.5719,  1.5655,
     2   1.5592,  1.5512,  1.5415,  1.5317,  1.5202,  1.5085,  1.4967,
     3   1.4831,  1.4692,  1.4551,  1.4409,  1.4246,  1.4099,  2.5308,
     4   2.5285,  2.5231,  2.5121,  2.4993,  2.4843,  2.4653,  2.4460,
     5   2.4263,  2.4036,  2.3809,  2.3566,  2.3318,  2.3074,  2.2812,
     6   2.2544,  2.2280,  2.2009,  2.1731,  2.1444,  3.2629,  3.2588,
     7   3.2456,  3.2282,  3.2086,  3.1851,  3.1604,  3.1352,  3.1082,
     8   3.0804,  3.0507,  3.0213,  2.9910,  2.9597,  2.9275,  2.8955,
     9   2.8624,  2.8282,  2.7944,  2.7593,  3.9138,  3.9060,  3.8905,
     a   3.8692,  3.8470,  3.8221,  3.7967,  3.7694,  3.7403,  3.7103,
     b   3.6793,  3.6474,  3.6144,  3.5803,  3.5450,  3.5084,  3.4719,
     c   3.4340,  3.3962,  3.3570,  4.5266,  4.5168,  4.5011,  4.4806,
     d   4.4581,  4.4341,  4.4094,  4.3819,  4.3537,  4.3234,  4.2909,
     e   4.2587,  4.2240,  4.1881,  4.1509,  4.1122,  4.0735,  4.0332,
     f   3.9929,  3.9509,  5.1198,  5.1100,  5.0942,  5.0756,  5.0552,
     g   5.0321,  5.0086,  4.9822,  4.9540,  4.9238,  4.8926,  4.8592,
     h   4.8234,  4.7875,  4.7489,  4.7102,  4.6685,  4.6265,  4.5827   
     * /   
           data ( blb(i), i= 120,  238)/
     1   4.5386,  5.7024,  5.6926,  5.6788,  5.6622,  5.6428,  5.6219,
     2   5.5985,  5.5734,  5.5465,  5.5165,  5.4855,  5.4524,  5.4168,
     3   5.3799,  5.3416,  5.3003,  5.2587,  5.2154,  5.1701,  5.1243,
     4   6.2793,  6.2714,  6.2576,  6.2431,  6.2247,  6.2050,  6.1827,
     5   6.1588,  6.1321,  6.1035,  6.0729,  6.0388,  6.0035,  5.9669,
     6   5.9275,  5.8866,  5.8423,  5.7976,  5.7509,  5.7035,  6.8529,
     7   6.8450,  6.8332,  6.8197,  6.8034,  6.7848,  6.7637,  6.7400,
     8   6.7146,  6.6862,  6.6546,  6.6220,  6.5858,  6.5482,  6.5077,
     9   6.4656,  6.4215,  6.3739,  6.3239,  6.2730,  7.4247,  7.4188,
     a   7.4070,  7.3955,  7.3793,  7.3618,  7.3408,  7.3183,  7.2930,
     b   7.2648,  7.2335,  7.1998,  7.1638,  7.1251,  7.0835,  7.0386,
     c   6.9916,  6.9423,  6.8904,  6.8357,  7.9955,  7.9896,  7.9797,
     d   7.9683,  7.9541,  7.9367,  7.9169,  7.8934,  7.8682,  7.8401,
     e   7.8089,  7.7742,  7.7358,  7.6958,  7.6514,  7.6049,  7.5547,
     f   7.5018,  7.4476,  7.3903,  8.5657,  8.5598,  8.5519,  8.5405,
     g   8.5264,  8.5100,  8.4902,  8.4668,  8.4406,  8.4115,  8.3791,
     h   8.3432,  8.3034,  8.2607,  8.2146,  8.1649,  8.1126,  8.0574   
     * /   
           data ( blb(i), i= 239,  357)/
     1   7.9990,  7.9369,  9.1356,  9.1316,  9.1238,  9.1119,  9.0983,
     2   9.0820,  9.0622,  9.0388,  9.0116,  8.9813,  8.9466,  8.9094,
     3   8.8682,  8.8226,  8.7733,  8.7216,  8.6654,  8.6059,  8.5444,
     4   8.4789,  9.7053,  9.7013,  9.6935,  9.6836,  9.6700,  9.6527,
     5   9.6319,  9.6075,  9.5802,  9.5476,  9.5116,  9.4717,  9.4276,
     6   9.3802,  9.3289,  9.2734,  9.2146,  9.1504,  9.0855,  9.0161,
     7  10.2749, 10.2709, 10.2650, 10.2532, 10.2396, 10.2223, 10.2004,
     8  10.1760, 10.1465, 10.1126, 10.0752, 10.0326,  9.9869,  9.9361,
     9   9.8813,  9.8217,  9.7600,  9.6942,  9.6238,  9.5515, 10.8444,
     a  10.8405, 10.8346, 10.8247, 10.8091, 10.7908, 10.7689, 10.7423,
     b  10.7116, 10.6764, 10.6364, 10.5922, 10.5420, 10.4891, 10.4318,
     c  10.3695, 10.3030, 10.2336, 10.1610, 10.0842, 11.4139, 11.4100,
     d  11.4041, 11.3942, 11.3786, 11.3593, 11.3363, 11.3085, 11.2755,
     e  11.2390, 11.1962, 11.1490, 11.0982, 11.0418, 10.9805, 10.9152,
     f  10.8453, 10.7721, 10.6956, 10.6154, 11.9834, 11.9814, 11.9736,
     g  11.9617, 11.9471, 11.9277, 11.9027, 11.8737, 11.8393, 11.8003,
     h  11.7560, 11.7057, 11.6515, 11.5927, 11.5287, 11.4586, 11.3869   
     * /   
           data ( blb(i), i= 358,  400)/
     1  11.3096, 11.2294, 11.1462, 12.5529, 12.5509, 12.5431, 12.5312,
     2  12.5156, 12.4951, 12.4689, 12.4377, 12.4020, 12.3615, 12.3144,
     3  12.2622, 12.2045, 12.1418, 12.0748, 12.0031, 11.9276, 11.8460,
     4  11.7630, 11.6766, 13.1224, 13.1204, 13.1125, 13.1006, 13.0840,
     5  13.0615, 13.0352, 13.0028, 12.9647, 12.9215, 12.8726, 12.8186,
     6  12.7573, 12.6919, 12.6220, 12.5469, 12.4675, 12.3838, 12.2975,
     7  12.2067                                                         
     * /   
c
c       pair: total x-section
c        gamm energy=
c       .30000E-02  .55435E-02  .10244E-01  .18929E-01  .34977E-01
c       .64633E-01  .11943      .22069      .40781      .75357    
c       1.3925      2.5731      4.7547      8.7859      16.235    
c       30.000    
c       log10 step=   .2667
c
c      log10 of gamma energy boundary
      data  etcpl1/-2.522879/
c    *     ,etcpl2/ 1.477121/
c
           data ( tcpl(i), i= 1,  16)/
     1    .0483,   .1238,   .2094,   .2996,   .3900,   .4773,   .5575,
     2    .6245,   .6742,   .7092,   .7327,   .7481,   .7579,   .7640,
     3    .7678,   .7701                                                
     * /   
c
c       pair: region a
c
c         energy of gamma=
c         .300E-02    .554E-02    .102E-01    .189E-01    .350E-01
c         .646E-01    .119        .221        .408        .754    
c         1.39        2.57        4.75        8.79        16.2    
c         30.0    
c         log10 step=  .266667
c
c         log10 of eg boundary
      data  egla1l/-2.522879/
c    *     ,egla2l/ 1.477121/
c
c
c         pla(iu,ie)=(v-.5)/(1.-u)
c         u= .050 to1.000   step=  .0633
c            log10(e)= -2.5229 to   1.4771 step=  .2667
c
           data ( pla(i), i= 1,  119)/
     1    .2908,   .2781,   .2698,   .2635,   .2597,   .2552,   .2525,
     2    .2510,   .2491,   .2465,   .2450,   .2453,   .2457,   .2415,
     3    .2389,   .2434,   .3765,   .3620,   .3546,   .3495,   .3447,
     4    .3427,   .3403,   .3388,   .3369,   .3364,   .3333,   .3349,
     5    .3333,   .3301,   .3333,   .3327,   .4211,   .4090,   .4020,
     6    .3985,   .3956,   .3935,   .3925,   .3913,   .3897,   .3898,
     7    .3901,   .3904,   .3910,   .3921,   .3956,   .3891,   .4459,
     8    .4371,   .4326,   .4297,   .4277,   .4267,   .4271,   .4276,
     9    .4261,   .4267,   .4274,   .4285,   .4303,   .4267,   .4303,
     a    .4284,   .4625,   .4560,   .4531,   .4509,   .4511,   .4513,
     b    .4516,   .4519,   .4544,   .4553,   .4566,   .4547,   .4566,
     c    .4603,   .4566,   .4580,   .4730,   .4688,   .4675,   .4673,
     d    .4684,   .4697,   .4713,   .4714,   .4737,   .4742,   .4780,
     e    .4799,   .4780,   .4818,   .4780,   .4801,   .4805,   .4777,
     f    .4780,   .4796,   .4816,   .4838,   .4867,   .4882,   .4903,
     g    .4930,   .4968,   .4988,   .4968,   .5007,   .4968,   .5007,
     h    .4865,   .4862,   .4870,   .4905,   .4932,   .4965,   .5005   
     * /   
           data ( pla(i), i= 120,  238)/
     1    .5036,   .5076,   .5103,   .5142,   .5161,   .5193,   .5180,
     2    .5142,   .5211,   .4917,   .4927,   .4963,   .5005,   .5041,
     3    .5099,   .5135,   .5181,   .5218,   .5268,   .5306,   .5326,
     4    .5358,   .5345,   .5460,   .5393,   .4953,   .4988,   .5028,
     5    .5088,   .5130,   .5197,   .5244,   .5303,   .5356,   .5402,
     6    .5436,   .5447,   .5518,   .5505,   .5466,   .5536,   .4977,
     7    .5024,   .5091,   .5142,   .5204,   .5262,   .5316,   .5383,
     8    .5426,   .5483,   .5532,   .5566,   .5624,   .5585,   .5624,
     9    .5641,   .5009,   .5059,   .5128,   .5183,   .5248,   .5325,
     a    .5386,   .5443,   .5494,   .5562,   .5595,   .5645,   .5677,
     b    .5664,   .5780,   .5716,   .5026,   .5082,   .5153,   .5222,
     c    .5291,   .5357,   .5421,   .5482,   .5539,   .5588,   .5658,
     d    .5685,   .5730,   .5742,   .5781,   .5767,   .5026,   .5104,
     e    .5165,   .5236,   .5305,   .5373,   .5439,   .5502,   .5561,
     f    .5615,   .5689,   .5724,   .5730,   .5743,   .5782,   .5801,
     g    .5047,   .5116,   .5177,   .5249,   .5319,   .5389,   .5456,
     h    .5522,   .5584,   .5641,   .5689,   .5724,   .5782,   .5820   
     * /   
           data ( pla(i), i= 239,  256)/
     1    .5782,   .5822,   .5047,   .5116,   .5189,   .5262,   .5334,
     2    .5404,   .5474,   .5541,   .5606,   .5666,   .5720,   .5763,
     3    .5782,   .5821,   .5782,   .5836                              
     * /   
c
c
c       pair: region b
c
c         energy of gamma=
c         .300E-02    .314E-02    .362E-02    .458E-02    .636E-02
c         .971E-02    .163E-01    .300E-01    .607E-01    .135    
c         .330        .884        2.61        8.44        30.0    
c         sqrt(log10) step=  .142857
c
c         use 0 for e-side at interpolation
c         with sqrt(log10(e)-eglb1l)
      data  eglb1l/-2.522879/
c
c
c         plb(iu,ie)=v
c         sqrt(u)= .000 to .224   step=  .0149
           data ( plb(i), i= 1,  119)/
     1    .8297,   .8264,   .8239,   .8200,   .8174,   .8136,   .8097,
     2    .8058,   .8033,   .7994,   .7955,   .7917,   .7878,   .7840,
     3    .7801,   .7762,   .8375,   .8355,   .8329,   .8289,   .8263,
     4    .8223,   .8197,   .8157,   .8118,   .8078,   .8052,   .8012,
     5    .7973,   .7933,   .7894,   .7854,   .8589,   .8582,   .8554,
     6    .8525,   .8497,   .8469,   .8427,   .8385,   .8357,   .8315,
     7    .8273,   .8245,   .8203,   .8161,   .8119,   .8077,   .8884,
     8    .8877,   .8861,   .8831,   .8801,   .8770,   .8740,   .8694,
     9    .8664,   .8619,   .8588,   .8543,   .8497,   .8467,   .8421,
     a    .8376,   .9197,   .9189,   .9172,   .9140,   .9123,   .9090,
     b    .9041,   .9008,   .8976,   .8943,   .8894,   .8861,   .8812,
     c    .8779,   .8730,   .8680,   .9474,   .9465,   .9448,   .9413,
     d    .9395,   .9360,   .9325,   .9290,   .9255,   .9220,   .9168,
     e    .9133,   .9098,   .9046,   .9011,   .8958,   .9686,   .9677,
     f    .9659,   .9640,   .9604,   .9567,   .9531,   .9512,   .9476,
     g    .9439,   .9402,   .9348,   .9311,   .9274,   .9238,   .9183,
     h    .9830,   .9820,   .9801,   .9783,   .9745,   .9726,   .9688   
     * /   
           data ( plb(i), i= 120,  238)/
     1    .9650,   .9632,   .9594,   .9556,   .9518,   .9481,   .9443,
     2    .9400,   .9363,   .9916,   .9906,   .9887,   .9868,   .9849,
     3    .9810,   .9791,   .9772,   .9733,   .9695,   .9676,   .9637,
     4    .9604,   .9565,   .9527,   .9489,   .9962,   .9952,   .9933,
     5    .9914,   .9894,   .9875,   .9856,   .9836,   .9797,   .9778,
     6    .9739,   .9720,   .9686,   .9657,   .9618,   .9579,   .9984,
     7    .9975,   .9955,   .9955,   .9936,   .9916,   .9897,   .9877,
     8    .9858,   .9838,   .9800,   .9780,   .9746,   .9717,   .9688,
     9    .9649,   .9994,   .9984,   .9984,   .9965,   .9965,   .9945,
     a    .9926,   .9906,   .9887,   .9867,   .9848,   .9828,   .9789,
     b    .9770,   .9745,   .9716,   .9998,   .9988,   .9988,   .9988,
     c    .9969,   .9949,   .9949,   .9930,   .9910,   .9891,   .9871,
     d    .9852,   .9832,   .9813,   .9774,   .9759,   .9999,   .9990,
     e    .9990,   .9990,   .9970,   .9970,   .9951,   .9951,   .9931,
     f    .9912,   .9892,   .9872,   .9853,   .9833,   .9814,   .9775,
     g   1.0000,   .9990,   .9990,   .9990,   .9990,   .9971,   .9971,
     h    .9951,   .9931,   .9931,   .9912,   .9892,   .9873,   .9853   
     * /   
           data ( plb(i), i= 239,  240)/
     1    .9814,   .9795                                                
     * /   


c
c
c    ---------------     $$$   landau correction region $$$     ----
c
c media=c    z=  6.00 a= 12.00 rho=     2.20    
c  constant used in landau effect
c z=   6.00 a=  12.00 rho=   2.20 x0= 19.294cm= 42.448g/cm**2 
c s1= .986E-04 ln(s1)=-9.22      const in eq.60 of migdal= .185E+05
c gamma cut off energy = .100E-03gev
      data deelh/  .224914/
      data deghl/  .142051/
c
c          energy of electron
c        20.00       33.57       56.35       94.57       158.7    
c        266.4       447.2       750.6       1260.       2115.    
c        3550.       5958.       .1000E+05   .1678E+05   .2817E+05
c        .4729E+05   .7937E+05   .1332E+06   .2236E+06   .3753E+06
c        .6300E+06   .1057E+07   .1775E+07   .2979E+07   .5000E+07
c         log10 step=  .224914
c
c         log10 of electron energy boundary
      data eeh1l/ 1.301030/
c    *     ,eeh2l/ 6.698970/
c
           data ( tcbh(i), i= 1,  25)/
     1  14.0039, 13.7543, 13.3491, 12.8362, 12.2570, 11.6359, 10.9878,
     2  10.3238,  9.6505,  8.9733,  8.2930,  7.6150,  6.9416,  6.2760,
     3   5.6230,  4.9889,  4.3806,  3.8039,  3.2676,  2.7755,  2.3325,
     4   1.9401,  1.5976,  1.3044,  1.0566                              
     * /   
c
c          be1(iu,ie)= alog(v/vmin)
c          from u= .000 to  .700 step= .100
c          from log10(e)=  1.3010 to  6.6990 step   .2249
c          dim. of u=  8 dim of e= 25
c
           data (   be1(i), i= 1,  102)/
     1  12.20607, 10.74215,  9.54873,  8.45351,  7.38826,  6.33175,
     2   5.27483,  4.23060, 12.72396, 11.28298, 10.10751,  9.02944,
     3   7.98220,  6.94469,  5.90689,  4.88051, 13.24184, 11.83881,
     4  10.69007,  9.63984,  8.62169,  7.61316,  6.61081,  5.60615,
     5  13.75972, 12.40515, 11.29202, 10.27728,  9.29552,  8.32122,
     6   7.36307,  6.38234, 14.27761, 12.97825, 11.90330, 10.92881,
     7   9.98914,  9.05878,  8.14249,  7.18793, 14.79549, 13.55523,
     8  12.52451, 11.59198, 10.69450,  9.81277,  8.93971,  8.01206,
     9  15.31338, 14.13686, 13.14994, 12.26283, 11.40766, 10.57829,
     a   9.74554,  8.84630, 15.83126, 14.72061, 13.77975, 12.93790,
     b  12.13048, 11.34959, 10.55432,  9.68172, 16.34914, 15.30586,
     c  14.41235, 13.61394, 12.85819, 12.12208, 11.36192, 10.51566,
     d  16.86703, 15.89334, 15.04830, 14.29467, 13.59027, 12.89550,
     e  12.16608, 11.34408, 17.38491, 16.48112, 15.68522, 14.97997,
     f  14.32138, 13.66290, 12.96469, 12.16598, 17.90280, 17.07108,
     g  16.32378, 15.66896, 15.05045, 14.42626, 13.75460, 12.97734,
     h  18.42068, 17.66039, 16.96724, 16.35770, 15.77538, 15.18043      
     * /   
           data (   be1(i), i= 103,  200)/
     1  14.53448, 13.77684, 18.93856, 18.25029, 17.61198, 17.04486,
     2  16.49503, 15.92597, 15.30119, 14.56299, 19.45645, 18.83943,
     3  18.25751, 17.72554, 17.20421, 16.65864, 16.05409, 15.33117,
     4  19.97433, 19.42890, 18.89722, 18.40004, 17.90364, 17.37770,
     5  16.79016, 16.08366, 20.49222, 20.01516, 19.53264, 19.06455,
     6  18.59037, 18.08321, 17.51019, 16.81704, 21.01010, 20.59704,
     7  20.16028, 19.71787, 19.26252, 18.77055, 18.21129, 17.52961,
     8  21.52798, 21.17368, 20.77705, 20.36092, 19.92257, 19.44365,
     9  18.89465, 18.22335, 22.04587, 21.74310, 21.38444, 20.99003,
     a  20.56490, 20.09715, 19.55925, 18.89788, 22.56375, 22.30495,
     b  21.97879, 21.60546, 21.19392, 20.73747, 20.20635, 19.55240,
     c  23.08164, 22.86130, 22.56444, 22.20870, 21.80878, 21.36033,
     d  20.83634, 20.18937, 23.59952, 23.41034, 23.13807, 22.79982,
     e  22.41025, 21.96699, 21.44979, 20.80820, 24.11740, 23.95500,
     f  23.70287, 23.37778, 22.99782, 22.56179, 22.04865, 21.41185,
     g  24.63529, 24.49335, 24.25989, 23.94701, 23.57382, 23.14353,
     h  22.63559, 22.00025                                              
     * /   
c
c         be2(iu,ie)= (sqrt(v) -sqrtv)/(1.-u)
c          from sqrt(1-u)= .000 to  .548 step=  .055
c          from log10(e)= 1.301030 to 6.698970 step   .2249
c
           data (   be2(i), i= 1,  119)/
     1    .0302,   .0302,   .0307,   .0315,   .0325,   .0340,   .0360,
     2    .0387,   .0423,   .0473,   .0544,   .0349,   .0351,   .0355,
     3    .0363,   .0375,   .0392,   .0413,   .0441,   .0479,   .0531,
     4    .0603,   .0411,   .0412,   .0419,   .0429,   .0442,   .0461,
     5    .0485,   .0516,   .0557,   .0612,   .0688,   .0489,   .0492,
     6    .0500,   .0511,   .0528,   .0549,   .0577,   .0612,   .0657,
     7    .0717,   .0799,   .0584,   .0589,   .0599,   .0614,   .0634,
     8    .0658,   .0690,   .0730,   .0781,   .0848,   .0936,   .0699,
     9    .0705,   .0719,   .0738,   .0762,   .0792,   .0829,   .0875,
     a    .0932,   .1006,   .1101,   .0836,   .0845,   .0864,   .0889,
     b    .0918,   .0953,   .0996,   .1047,   .1112,   .1193,   .1298,
     c    .0997,   .1010,   .1037,   .1068,   .1103,   .1145,   .1194,
     d    .1252,   .1324,   .1413,   .1528,   .1186,   .1206,   .1242,
     e    .1281,   .1323,   .1371,   .1427,   .1492,   .1573,   .1671,
     f    .1794,   .1404,   .1434,   .1482,   .1531,   .1581,   .1636,
     g    .1699,   .1772,   .1861,   .1967,   .2099,   .1654,   .1700,
     h    .1762,   .1820,   .1879,   .1941,   .2011,   .2095,   .2190   
     * /   
           data (   be2(i), i= 120,  238)/
     1    .2307,   .2447,   .1937,   .2004,   .2082,   .2152,   .2219,
     2    .2291,   .2369,   .2458,   .2564,   .2688,   .2836,   .2256,
     3    .2349,   .2446,   .2526,   .2603,   .2683,   .2770,   .2867,
     4    .2979,   .3110,   .3266,   .2642,   .2734,   .2848,   .2942,
     5    .3028,   .3116,   .3211,   .3315,   .3435,   .3572,   .3736,
     6    .3067,   .3158,   .3289,   .3396,   .3492,   .3590,   .3691,
     7    .3802,   .3927,   .4069,   .4235,   .3525,   .3616,   .3764,
     8    .3882,   .3989,   .4092,   .4200,   .4317,   .4447,   .4594,
     9    .4763,   .4010,   .4096,   .4261,   .4393,   .4507,   .4615,
     a    .4732,   .4852,   .4984,   .5135,   .5306,   .4511,   .4591,
     b    .4772,   .4911,   .5034,   .5151,   .5272,   .5394,   .5531,
     c    .5680,   .5848,   .5020,   .5091,   .5282,   .5434,   .5562,
     d    .5686,   .5810,   .5936,   .6070,   .6219,   .6386,   .5524,
     e    .6036,   .5782,   .5940,   .6078,   .6207,   .6328,   .6456,
     f    .6595,   .6741,   .6907,   .6015,   .6060,   .6262,   .6427,
     g    .6568,   .6701,   .6826,   .6957,   .7091,   .7235,   .7395,
     h    .6481,   .6513,   .6712,   .6885,   .7031,   .7161,   .7289   
     * /   
           data (   be2(i), i= 239,  275)/
     1    .7414,   .7549,   .7692,   .7849,   .6914,   .6931,   .7129,
     2    .7296,   .7443,   .7576,   .7704,   .7831,   .7960,   .8098,
     3    .8255,   .7314,   .7319,   .7495,   .7668,   .7818,   .7952,
     4    .8077,   .8201,   .8326,   .8466,   .8617,   .7676,   .7676,
     5    .7826,   .7999,   .8145,   .8280,   .8401,   .8524,   .8648,
     6    .8784,   .8926                                                
     * /   
c
c
c         energy of gamma
c        .1000E+05   .1387E+05   .1924E+05   .2668E+05   .3700E+05
c        .5132E+05   .7117E+05   .9871E+05   .1369E+06   .1899E+06
c        .2633E+06   .3652E+06   .5065E+06   .7025E+06   .9744E+06
c        .1351E+07   .1874E+07   .2599E+07   .3605E+07   .5000E+07
c       log10 step=  .142051
c
c       log10 of gamma energy boundary
      data egh1l/ 4.000000/
c    *     ,egh1l/ 6.698970/
c
           data (  tcph(i), i= 1,  20)/
     1    .7778,   .7778,   .7778,   .7778,   .7778,   .7838,   .7827,
     2    .7777,   .7780,   .7755,   .7708,   .7595,   .7426,   .7179,
     3    .6859,   .6478,   .6045,   .5577,   .5093,   .4605            
     * /   
c
c        table of v
c        from u=  .0000 to  1.0000 step   .1000
c        from log10(e)= 4.000000 to 6.698970 step   .1421
c
           data (   vp(i), i= 1,  119)/
     1   1.0000,   .9604,   .9185,   .8735,   .8267,   .7778,   .7261,
     2    .6714,   .6157,   .5581,   .5000,  1.0000,   .9604,   .9185,
     3    .8735,   .8267,   .7778,   .7261,   .6714,   .6157,   .5581,
     4    .5000,  1.0000,   .9604,   .9185,   .8735,   .8267,   .7778,
     5    .7261,   .6714,   .6157,   .5581,   .5000,  1.0000,   .9604,
     6    .9185,   .8735,   .8267,   .7778,   .7261,   .6714,   .6157,
     7    .5581,   .5000,  1.0000,   .9604,   .9185,   .8735,   .8267,
     8    .7778,   .7261,   .6714,   .6157,   .5581,   .5000,  1.0000,
     9    .9595,   .9175,   .8726,   .8257,   .7759,   .7241,   .6724,
     a    .6147,   .5591,   .5000,  1.0000,   .9595,   .9175,   .8726,
     b    .8257,   .7778,   .7261,   .6714,   .6157,   .5571,   .5000,
     c   1.0000,   .9604,   .9185,   .8745,   .8276,   .7788,   .7271,
     d    .6724,   .6167,   .5591,   .5000,  1.0000,   .9604,   .9185,
     e    .8745,   .8276,   .7778,   .7261,   .6714,   .6157,   .5591,
     f    .5000,  1.0000,   .9604,   .9185,   .8745,   .8276,   .7788,
     g    .7271,   .6733,   .6167,   .5591,   .5000,  1.0000,   .9604,
     h    .9185,   .8755,   .8286,   .7798,   .7280,   .6733,   .6177   
     * /   
           data (   vp(i), i= 120,  220)/
     1    .5591,   .5000,  1.0000,   .9614,   .9204,   .8765,   .8315,
     2    .7827,   .7310,   .6763,   .6196,   .5601,   .5000,  1.0000,
     3    .9624,   .9224,   .8794,   .8345,   .7866,   .7349,   .6792,
     4    .6216,   .5620,   .5000,  1.0000,   .9634,   .9243,   .8833,
     5    .8394,   .7915,   .7388,   .6841,   .6245,   .5630,   .5000,
     6   1.0000,   .9653,   .9282,   .8882,   .8442,   .7964,   .7446,
     7    .6890,   .6284,   .5649,   .5000,  1.0000,   .9673,   .9312,
     8    .8931,   .8501,   .8032,   .7515,   .6938,   .6323,   .5669,
     9    .5000,  1.0000,   .9692,   .9360,   .8989,   .8569,   .8101,
     a    .7573,   .6997,   .6372,   .5698,   .5000,  1.0000,   .9712,
     b    .9399,   .9038,   .8638,   .8169,   .7651,   .7065,   .6421,
     c    .5728,   .5000,  1.0000,   .9741,   .9438,   .9097,   .8696,
     d    .8247,   .7720,   .7134,   .6470,   .5747,   .5000,  1.0000,
     e    .9761,   .9487,   .9155,   .8765,   .8315,   .7798,   .7192,
     f    .6519,   .5776,   .5000                                       
     * /   

c
c       total prob. equivalenced to common
c
      equivalence (tprob,tp)
c

c
c                         complete screening pair x-sxec.
c                         0.778 =(7/9-b)*rx0 =.773*rx0
      data rx0/1.0/, ctpc/.778/,  cep/50.e3/
c       cep:  minimum energy for landau correction for pair.
c          default esbc espc
      data esbin/5./,  espin/50./
c
c
      if(ee .lt. eblmin) then
          t=1.e36
      else
          if(.not. usees) then
             esb=esbin
          else
             esb=min(escb, eblmax)
          endif
          if(ee .gt. esb) then
              screen=.false.
              if(lcorec .and. ee .gt. eeh1) then
                  if(ee .gt. eeh2) then
                      write(6,
     *                '('' ee > eeh2 in brmCarbont: ee='',g12.4)')
     *                ee
                      stop
                  endif
                  landau=.true.
                  ale=log10(ee)
c                 tp=fintp3(tcbh, eeh1l, deelh, neeh, ale)*rx0
                  call kintp3(tcbh, 1, neeh, eeh1l, deelh, ale, tp)
                  tp=tp*rx0
              else
                  landau=.false.
c                     complete screening cross-section
                  vc=ec/ee
                  tp=(-1.3603*(log(vc)-vc)-vc*vc*.5-.8603 )*rx0
              endif
          else
              landau=.false.
              if(scorec) then
                  screen=.true.
                  ale=log10(ee)
c                 tp=fintp3(tcbl, etcbl1, debtcl, nbtcl,  ale)
                  call kintp3(tcbl, 1, nbtcl, etcbl1, debtcl,  ale, tp)
              else
                  screen=.false.
c                     complete screening cross-section
                  vc=ec/ee
                  tp=(-1.3603*(log(vc)-vc)-vc*vc*.5-.8603 )*rx0
              endif
          endif
c
          call rndc(u)
          t =-log(u)/tp
      endif
      return
c
c     ************
      entry brmCarbone(ee,ec,beg)
c     ************
c
      call rndc(u)
      if(screen) then
c           partial screening
         if(u .gt. uela1) then
c                  region a
c              beg=exp( tdint4(bla, nuela, neela, uela1, eela1l, duela,
c    *         deela, u,  ale)*(1.-u) ) *egmnl
               call k4ptdi(bla, nuela, neela, nuela, uela1, eela1l,
     *         duela, deela, u, ale, ans)
               beg=exp( ans*(1.-u))*egmnl
         else
c                  region b
               us=sqrt(u)
c              beg=exp( tdint4(blb, nuelb, neelb, uelb1, eelb1l,duelb,
c    *         deelb, us, ale)) * egmnl
               call k4ptdi(blb, nuelb, neelb, nuelb, uelb1, eelb1l,
     *         duelb, deelb, us, ale, ans)
               beg=exp(ans)*egmnl
         endif
      elseif(landau) then
         if(u .lt. ueh2) then
c              beg=exp( tdint4(be1, nueh1, neeh, ueh1, eeh1l, dueh1,
c    *         deelh, u,  ale)  ) * egmnh
               call k4ptdi(be1, nueh1, neeh, nueh1,  ueh1, eeh1l,
     *         dueh1, deelh, u,  ale, ans)
               beg=exp( ans ) *egmnh
         else
               us=sqrt(1.-u)
c              beg=   ( tdint4(be2, nueh2, neeh, ueh3, eeh1l, dueh2,
c    *         deelh, us,  ale)*(1.-u)+ sqrt(egmnh/ee) )**2 *ee
               call k4ptdi(be2, nueh2, neeh, nueh2,  ueh3, eeh1l,
     *         dueh2, deelh, us,  ale, ans)
               beg=  (ans*(1.-u) + sqrt(egmnh/ee) )**2*ee
         endif
      else
c               complete screening
          a=u*tp
          if(a .le. 1.) then
             v=exp(-a)
             if(a .gt. .1) then
                 v=((.06366*a-.1447407)*a+1.014176)*v
             endif
          else
             v=exp(-(a+0.8603)/1.3603)
             if(a .le. 6.) then
                 v=((((2.050445e-3*a-3.53209e-2)*a+.228937)*a-.684076)*a
     *           +1.841734)*v
             endif
          endif
          beg=ee*v
      endif
      return
c
c
c     ***********
      entry prcCarbont(eg,t)
c     ***********
c
c
c
      if(eg .le. emass2) then
          t=1.e37
      elseif(eg .lt. eplmin .and. scorec) then
          tp=( (eg-emass2)/(eplmin-emass2) )**3 * tcpl(1)
          call rndc(u)
          t =-log(u)/tp
          landau=.false.
          screen=.true.
      else
          if(.not. usees) then
             esp=espin
          else
             esp=min(escp, eplmax)
          endif
          if(eg .gt. esp) then
              screen=.false.
              if(eg .gt. cep   .and. lcorec) then
                  landau=.true.
                  ale=log10(eg)
c                 tp=fintp3(tcph, egh1l, deghl, negh, ale)*rx0
                  call kintp3(tcph, 1, negh,  egh1l,  deghl,   ale, tp)
                  tp=tp*rx0
              else
                  landau=.false.
c                     complete screening cross-section
                  tp=ctpc
              endif
          else
              landau=.false.
              if(scorec) then
                  screen=.true.
                  ale=log10(eg)
c                 tp=fintp3(tcpl, etcpl1, deptcl, nptcl, ale)
                  call kintp3(tcpl, 1,nptcl,  etcpl1, deptcl,  ale, tp)
              else
                  screen=.false.
c                     complete screening cross-section
                  tp=ctpc
              endif
          endif
          call rndc(u)
          t =-log(u)/tp
      endif
      return
c
c
c     ***********
      entry prcCarbone(eg,e1)
c     ***********
c
c
c
      call rndc(u)
      if(screen) then
c           partial screening
         if(u .ge. ugla1) then
c                   region a
c               e1=(tdint4(pla, nugla, negla, ugla1, egla1l, dugla,
c    *          degla, u,    ale) *(1.-u) + .5 )*eg
                call k4ptdi(pla, nugla, negla,nugla,  ugla1, egla1l,
     *          dugla, degla, u,   ale, ans)
                e1=(ans*(1.-u) + .5)*eg
         else
c                   region b
                us=sqrt(u)
                ex=sqrt(ale-eglb1l)

                call k4ptdi(plb, nuglb, neglb,nuglb,  uglb1, 0.d0,
     *          duglb, deglb, us,  ale, ans)
                e1=ans*eg
         endif
      elseif(landau) then
c        e1= tdint4(vp, nugh2, negh, ugh3, egh1l, dugh2,
c    *   deghl, u,  ale) * eg
         call k4ptdi(vp, nugh2, negh, nugh2, ugh3, egh1l,
     *   dugh2, deghl, u,  ale, ans)
         e1=ans*eg
      else
c                complete screening
         e1=(((.0441223*u-.173755)*u-.3708608)*u+1.)*eg
      endif
      return
c
c     ************
      entry emctCarbon(Knckon)
c     ************
c
c               cconst=for compton=3/8*thomson*n0*z/a*x0ing
c               to convert cross-section in compt into /(r.l).
      cconst=3.203
      x0= 19.4
      x0ing= 42.7
      x0sq=1.823e3
      if(Knckon) then
         ecrit=75.e-3
      else
         ecrit=75.e-3
      endif 
c         moller scat    .3 z/a * x0ing
      constm=6.405
      rho = 2.2
c
      zchrg= 6.
      zchrg2 = 36.
      amassn= 12.0
      ionizP = 78.d-9
      end
