c     ************************ for Air*********************************
c     *                                                              *
c     *  brmAirt:  samples path for brems                             *
c     *  brmAire:  samples energy of brems gamma                      *
c     *  prcAirt:  samples path for pair creation                     *
c     *  prcAire:  samples energy of pair electron (higher energy)    *
c     *  emctAir:  set const in common for Air                         *
c     *                                                              *
c     *********************** tested 84.04.28 ********************k.k*
c
c      material   z     a     rho     t0 (g/cm2)  t0 (cm)    ec
c         Air     7.52  15.2   1.205e-3  36.5    3.e4        76.e-3

c brems:
c        electron energy:      1 MeV to 5000 TeV
c        brems gamma energy:   .1 MeV or more
c           if electron energy is < 1MeV,  sampled path is set to be
c        very large one so that real brems may not take place before
c        the death by energy loss.
c pair:
c        gamma energy:         3mev to  5000 TeV 
c           if gamma energy is < 3 MeV, sampled path is set to be
c        very large one so that real pair creation may not take place
c        before compton or another process takes place.
c
c
c
c
c   /usage/          call brmAirt(ee,ec,t)
c                    call brmAire(ee,ec,beg)
c
c                    call prcAirt(eg,t)
c                    call prcAire(eg,e1)
c
c      ee:  incident electron energy
c      ec:  cut-off energy of brems gamma (used if complete screening
c           cross section is to be used).
c       t:  sampled path
c     beg:  sampled gamma energy
c      eg:  incident gamma energy
c      e1:  sampled electron energy (higher energy in pair)
c
c  *** note ***
c
c          before calling brmAire, brmAirt must have been called.
c          //             prcAire, prcAirt //
c
c          by the parameters in $elmag the user can control:
c
c        ee  -------------- 5gev------->  (if usees=t, escb instead 5)
c     scorec=t       p.s    !
c     lcorec=t              !    l.c
c     scorec=f       c.s    !
c     lcorec=f              !    c.s
c
c        eg  --------------50gev--5tev---> (if usees=t, escp instead 50)
c     scorec=t       p.s    ! c.s !
c     lcorec=t              ! c.s ! l.c
c     scorec=f       c.s    ! c.s !
c     lcorec=f              !     ! c.s
c
c
c
c
      subroutine brmAirt(ee,ec,t)
       implicit none
c
c
#include  "Zelmag.h"
#include  "Zemdef.h"
c
      integer i
      logical screen,landau
      save screen,landau
c
c
c
c
c ------------------------- partical screening ----------------------

c           *** electron ***
c
c           ! egmin (gev)  for brems.
      data egmnl/.1e-3/
c
      parameter (eblmin=1.e-3, eblmax=50., nbtcl=40)
      dimension tcbl(nbtcl)
c
c             brem:   region a
c
      parameter (eela1=eblmin, eela2=eblmax,neela=20,
     * uela1=.05, uela2=1., nuela=20, duela=(uela2-uela1)/(nuela-1) )
      dimension bla(nuela * neela)
c
c             brem:  region b  (sqrt(u))
      parameter (eelb1=eblmin, eelb2=eblmax, neelb=neela,
     * uelb1=0.,  uelb2=.2236068, nuelb=20,
     * duelb=(uelb2-uelb1)/(nuelb-1) )
      dimension blb(nuelb * neelb)
c

c           ** gamma ***
c
c                 total cross-section
      parameter (eplmin=3.e-3, eplmax= 30., nptcl=16)
      dimension tcpl(nptcl)
c
c          pair: region a
      parameter ( egla1=eplmin,  egla2=eplmax, negla=16,
     *   ugla1=.05, ugla2=1., nugla=16,dugla=(ugla2-ugla1)/(nugla-1) )
      dimension pla(nugla * negla)
c
c            pair: region b     sqrt(log10(e)) sqrt(u)
      parameter (eglb1=eplmin, eglb2=eplmax, neglb=15,
     *  uglb1=0., uglb2=.2236068, nuglb=16,
     *  duglb=(uglb2-uglb1)/(nuglb-1))
      dimension plb(nuglb * neglb)
c

c      -------------------- landau ------------------------------
c
c          **** electron ****
c
      data egmnh/1.e-4/
      parameter (eeh1=50., eeh2 = 5000.e3, neeh=25, dueh1=.1,
     *  ueh1=0., ueh2=.7, nueh1=(ueh2-ueh1+.00001)/dueh1+1)
      dimension  tcbh(neeh)
      dimension  be1(nueh1* neeh)
c
c                         sqrt(1-.7)
      parameter (ueh3=0., ueh4=0.5477225,
     *nueh2=11, dvueh2=nueh2-1, dueh2=(ueh4 - ueh3)/dvueh2)
      dimension be2(nueh2  * neeh)
c
c         *** gamma ****
c
      parameter ( egh1=10000., egh2= 5000.e3, negh=20, dugh2=.1,
     * ugh3=0., ugh4=1., nugh2=(ugh4-ugh3+.00001)/dugh2+1)
      dimension tcph(negh)
      dimension vp(nugh2* negh)
c
c
c     ---------------------------------------------------------
      data debtcl/  .120486/
      data deela/  .247314/
      data deelb/  .247314/
      data deptcl/  .266667/
      data degla/  .266667/
      data deglb/  .142857/
c        electron energy=
c       .10000E-02  .13197E-02  .17417E-02  .22986E-02  .30335E-02
c       .40034E-02  .52835E-02  .69728E-02  .92022E-02  .12144E-01
c       .16027E-01  .21152E-01  .27915E-01  .36840E-01  .48619E-01
c       .64165E-01  .84680E-01  .11176      .14749      .19464    
c       .25688      .33901      .44741      .59046      .77925    
c       1.0284      1.3572      1.7912      2.3639      3.1197    
c       4.1171      5.4335      7.1708      9.4635      12.489    
c       16.483      21.753      28.708      37.887      50.000    
c       log10 step=   .1205
c
c      log10 of electron energy boundary
      data  etcbl1/-3.000000/
c    *     ,etcbl2/ 1.698970/
c
           data ( tcbl(i), i= 1,  40)/
     1  1.0646, 1.4842, 1.9199, 2.3736, 2.8346, 3.2995, 3.7647, 4.2265,
     2  4.6840, 5.1351, 5.5801, 6.0184, 6.4504, 6.8761, 7.2961, 7.7102,
     3  8.1201, 8.5247, 8.9253, 9.3228, 9.7164,10.1073,10.4960,10.8824,
     4 11.2670,11.6501,12.0321,12.4130,12.7931,13.1725,13.5512,13.9294,
     5 14.3072,14.6847,15.0619,15.4390,15.8159,16.1927,16.5694,16.9460  
     * /   
c
c       brem: region a
c        electron energy=
c       .10000E-02  .17673E-02  .31234E-02  .55200E-02  .97557E-02
c       .17241E-01  .30471E-01  .53852E-01  .95173E-01  .16820    
c       .29726      .52536      .92848      1.6409      2.9000    
c       5.1252      9.0579      16.008      28.292      50.000    
c       log10 step=   .2473
c
c      log10 of electron energy boundary
      data  eela1l/-3.000000/
c    *     ,eela2l/ 1.698970/
c
c
c            bla(iu,ie)=alog(v/vmin)/(1.-u)
c            u= .050 to 1.000 step=  .0500
c            log10(e)= -3.0000 to   1.6990 step=  .2473
c
           data ( bla(i), i= 1,  119)/
     1   1.4842,  1.4128,  1.3591,  1.3150,  1.2766,  1.2461,  1.2173,
     2   1.1905,  1.1691,  1.1486,  1.1289,  1.1107,  1.0936,  1.0802,
     3   1.0644,  1.0536,  1.0358,  1.0194,  1.0183,  1.0055,  2.2587,
     4   2.1278,  2.0371,  1.9659,  1.9094,  1.8587,  1.8186,  1.7809,
     5   1.7466,  1.7167,  1.6897,  1.6659,  1.6438,  1.6190,  1.6021,
     6   1.5811,  1.5728,  1.5587,  1.5346,  1.5239,  2.9074,  2.7528,
     7   2.6465,  2.5641,  2.4987,  2.4447,  2.3974,  2.3594,  2.3247,
     8   2.2947,  2.2675,  2.2456,  2.2256,  2.2090,  2.1888,  2.1731,
     9   2.1598,  2.1510,  2.1360,  2.1245,  3.5365,  3.3740,  3.2631,
     a   3.1803,  3.1150,  3.0647,  3.0221,  2.9873,  2.9565,  2.9278,
     b   2.9072,  2.8861,  2.8666,  2.8478,  2.8365,  2.8168,  2.8039,
     c   2.7979,  2.7789,  2.7790,  4.1618,  4.0003,  3.8914,  3.8145,
     d   3.7544,  3.7053,  3.6665,  3.6325,  3.6035,  3.5820,  3.5612,
     e   3.5447,  3.5269,  3.5174,  3.5011,  3.4948,  3.4789,  3.4672,
     f   3.4635,  3.4636,  4.7822,  4.6275,  4.5255,  4.4501,  4.3927,
     g   4.3463,  4.3109,  4.2811,  4.2559,  4.2357,  4.2200,  4.2067,
     h   4.1952,  4.1851,  4.1749,  4.1712,  4.1607,  4.1634,  4.1449   
     * /   
           data ( bla(i), i= 120,  238)/
     1   4.1486,  5.3987,  5.2503,  5.1503,  5.0765,  5.0225,  4.9801,
     2   4.9478,  4.9223,  4.9000,  4.8859,  4.8705,  4.8585,  4.8502,
     3   4.8416,  4.8344,  4.8328,  4.8269,  4.8291,  4.8155,  4.8175,
     4   6.0066,  5.8622,  5.7619,  5.6912,  5.6413,  5.6007,  5.5729,
     5   5.5491,  5.5299,  5.5172,  5.5054,  5.4981,  5.4890,  5.4825,
     6   5.4794,  5.4736,  5.4752,  5.4703,  5.4583,  5.4660,  6.6079,
     7   6.4619,  6.3637,  6.2939,  6.2450,  6.2099,  6.1826,  6.1620,
     8   6.1452,  6.1338,  6.1238,  6.1178,  6.1131,  6.1078,  6.1074,
     9   6.1039,  6.0958,  6.0905,  6.0940,  6.0949,  7.1984,  7.0510,
     a   6.9527,  6.8852,  6.8387,  6.8043,  6.7788,  6.7623,  6.7483,
     b   6.7382,  6.7312,  6.7229,  6.7200,  6.7171,  6.7135,  6.7129,
     c   6.7132,  6.7160,  6.7118,  6.7073,  7.7804,  7.6307,  7.5321,
     d   7.4655,  7.4203,  7.3893,  7.3660,  7.3515,  7.3392,  7.3318,
     e   7.3245,  7.3196,  7.3150,  7.3139,  7.3127,  7.3080,  7.3119,
     f   7.3067,  7.2919,  7.3070,  8.3557,  8.2018,  8.1035,  8.0386,
     g   7.9963,  7.9680,  7.9465,  7.9327,  7.9229,  7.9165,  7.9115,
     h   7.9073,  7.9043,  7.9004,  7.9021,  7.9010,  7.8976,  7.8951   
     * /   
           data ( bla(i), i= 239,  357)/
     1   7.8972,  7.8973,  8.9262,  8.7691,  8.6691,  8.6068,  8.5656,
     2   8.5388,  8.5207,  8.5080,  8.5004,  8.4945,  8.4903,  8.4887,
     3   8.4860,  8.4831,  8.4843,  8.4830,  8.4807,  8.4757,  8.4741,
     4   8.4804,  9.4916,  9.3301,  9.2317,  9.1726,  9.1343,  9.1100,
     5   9.0922,  9.0825,  9.0741,  9.0688,  9.0673,  9.0658,  9.0628,
     6   9.0598,  9.0584,  9.0572,  9.0595,  9.0519,  9.0713,  9.0590,
     7  10.0542,  9.8903,  9.7937,  9.7358,  9.6987,  9.6771,  9.6625,
     8   9.6536,  9.6471,  9.6422,  9.6413,  9.6392,  9.6382,  9.6381,
     9   9.6375,  9.6375,  9.6391,  9.6291,  9.6430,  9.6344, 10.6149,
     a  10.4472, 10.3514, 10.2977, 10.2644, 10.2428, 10.2300, 10.2230,
     b  10.2167, 10.2133, 10.2122, 10.2108, 10.2088, 10.2100, 10.2100,
     c  10.2071, 10.2109, 10.2108, 10.2255, 10.2074, 11.1752, 11.0052,
     d  10.9114, 10.8580, 10.8282, 10.8088, 10.7975, 10.7902, 10.7871,
     e  10.7830, 10.7833, 10.7816, 10.7820, 10.7799, 10.7811, 10.7814,
     f  10.7767, 10.7868, 10.7762, 10.7791, 11.7327, 11.5618, 11.4715,
     g  11.4205, 11.3918, 11.3749, 11.3664, 11.3584, 11.3547, 11.3543,
     h  11.3521, 11.3513, 11.3488, 11.3485, 11.3509, 11.3467, 11.3518   
     * /   
           data ( bla(i), i= 358,  400)/
     1  11.3495, 11.3573, 11.3499, 12.2910, 12.1198, 12.0306, 11.9831,
     2  11.9568, 11.9414, 11.9315, 11.9270, 11.9245, 11.9229, 11.9217,
     3  11.9216, 11.9199, 11.9175, 11.9226, 11.9237, 11.9214, 11.9254,
     4  11.9182, 11.9201, 12.8489, 12.6769, 12.5911, 12.5455, 12.5221,
     5  12.5077, 12.5005, 12.4966, 12.4951, 12.4903, 12.4928, 12.4887,
     6  12.4892, 12.4901, 12.4914, 12.4881, 12.4886, 12.4893, 12.4773,
     7  12.4900                                                         
     * /   
c
c       brem: region b
c        electron energy=
c       .10000E-02  .17673E-02  .31234E-02  .55200E-02  .97557E-02
c       .17241E-01  .30471E-01  .53852E-01  .95173E-01  .16820    
c       .29726      .52536      .92848      1.6409      2.9000    
c       5.1252      9.0579      16.008      28.292      50.000    
c       log10 step=   .2473
c
c      log10 of electron energy boundary
      data  eelb1l/-3.000000/
c    *     ,eelb2l/ 1.698970/
c
c
c            blb(iu,ie)=alog(v/vmin)/(1.-u)
c            sqrt(u)= .000 to  .224 step=  .0118
c            log10(e)= -3.0000 to   1.6990 step=  .2473
c
           data ( blb(i), i= 1,  119)/
     1   1.5872,-10.1959,  1.5844,  1.5813,  1.5781,  1.5719,  1.5655,
     2   1.5592,  1.5512,  1.5415,  1.5317,  1.5202,  1.5085,  1.4967,
     3   1.4831,  1.4692,  1.4551,  1.4409,  1.4246,  1.4099,  2.5308,
     4   2.5285,  2.5231,  2.5121,  2.4993,  2.4843,  2.4653,  2.4460,
     5   2.4263,  2.4036,  2.3809,  2.3566,  2.3329,  2.3074,  2.2812,
     6   2.2544,  2.2280,  2.2009,  2.1731,  2.1458,  3.2629,  3.2588,
     7   3.2456,  3.2282,  3.2086,  3.1851,  3.1615,  3.1352,  3.1082,
     8   3.0804,  3.0519,  3.0225,  2.9922,  2.9610,  2.9288,  2.8968,
     9   2.8638,  2.8297,  2.7959,  2.7608,  3.9138,  3.9060,  3.8905,
     a   3.8707,  3.8470,  3.8232,  3.7977,  3.7705,  3.7414,  3.7114,
     b   3.6805,  3.6487,  3.6157,  3.5817,  3.5464,  3.5113,  3.4749,
     c   3.4371,  3.3994,  3.3603,  4.5266,  4.5168,  4.5011,  4.4806,
     d   4.4592,  4.4352,  4.4094,  4.3831,  4.3548,  4.3246,  4.2934,
     e   4.2599,  4.2253,  4.1908,  4.1537,  4.1151,  4.0765,  4.0364,
     f   3.9962,  3.9543,  5.1198,  5.1100,  5.0942,  5.0756,  5.0552,
     g   5.0332,  5.0086,  4.9833,  4.9551,  4.9250,  4.8939,  4.8605,
     h   4.8260,  4.7902,  4.7517,  4.7132,  4.6715,  4.6297,  4.5876   
     * /   
           data ( blb(i), i= 120,  238)/
     1   4.5438,  5.7024,  5.6926,  5.6788,  5.6622,  5.6438,  5.6230,
     2   5.5996,  5.5745,  5.5476,  5.5176,  5.4867,  5.4536,  5.4194,
     3   5.3826,  5.3444,  5.3032,  5.2618,  5.2186,  5.1750,  5.1278,
     4   6.2793,  6.2714,  6.2576,  6.2431,  6.2257,  6.2060,  6.1838,
     5   6.1599,  6.1332,  6.1047,  6.0741,  6.0412,  6.0060,  5.9696,
     6   5.9303,  5.8894,  5.8469,  5.8008,  5.7558,  5.7070,  6.8529,
     7   6.8450,  6.8352,  6.8207,  6.8044,  6.7859,  6.7648,  6.7411,
     8   6.7157,  6.6874,  6.6570,  6.6233,  6.5883,  6.5508,  6.5105,
     9   6.4684,  6.4245,  6.3770,  6.3272,  6.2765,  7.4247,  7.4188,
     a   7.4089,  7.3955,  7.3803,  7.3618,  7.3419,  7.3194,  7.2941,
     b   7.2660,  7.2346,  7.2023,  7.1651,  7.1264,  7.0848,  7.0414,
     c   6.9931,  6.9439,  6.8921,  6.8375,  7.9955,  7.9896,  7.9797,
     d   7.9693,  7.9541,  7.9367,  7.9169,  7.8945,  7.8693,  7.8413,
     e   7.8101,  7.7754,  7.7370,  7.6971,  7.6528,  7.6064,  7.5562,
     f   7.5050,  7.4493,  7.3921,  8.5657,  8.5598,  8.5519,  8.5420,
     g   8.5274,  8.5100,  8.4902,  8.4679,  8.4417,  8.4126,  8.3803,
     h   8.3444,  8.3047,  8.2620,  8.2160,  8.1664,  8.1141,  8.0590   
     * /   
           data ( blb(i), i= 239,  357)/
     1   7.9990,  7.9387,  9.1356,  9.1316,  9.1238,  9.1119,  9.0993,
     2   9.0820,  9.0622,  9.0388,  9.0116,  8.9813,  8.9478,  8.9094,
     3   8.8682,  8.8226,  8.7747,  8.7216,  8.6654,  8.6076,  8.5444,
     4   8.4808,  9.7053,  9.7013,  9.6935,  9.6836,  9.6700,  9.6527,
     5   9.6319,  9.6085,  9.5802,  9.5488,  9.5127,  9.4729,  9.4289,
     6   9.3815,  9.3289,  9.2734,  9.2146,  9.1521,  9.0855,  9.0180,
     7  10.2749, 10.2709, 10.2650, 10.2532, 10.2406, 10.2223, 10.2015,
     8  10.1760, 10.1465, 10.1126, 10.0752, 10.0326,  9.9869,  9.9361,
     9   9.8813,  9.8217,  9.7600,  9.6942,  9.6238,  9.5515, 10.8444,
     a  10.8405, 10.8346, 10.8247, 10.8091, 10.7918, 10.7689, 10.7423,
     b  10.7116, 10.6764, 10.6364, 10.5922, 10.5433, 10.4891, 10.4318,
     c  10.3695, 10.3030, 10.2336, 10.1610, 10.0842, 11.4139, 11.4100,
     d  11.4041, 11.3942, 11.3786, 11.3593, 11.3363, 11.3085, 11.2755,
     e  11.2390, 11.1962, 11.1490, 11.0982, 11.0418, 10.9805, 10.9152,
     f  10.8453, 10.7721, 10.6956, 10.6154, 11.9834, 11.9814, 11.9736,
     g  11.9617, 11.9471, 11.9277, 11.9027, 11.8737, 11.8393, 11.8003,
     h  11.7560, 11.7057, 11.6515, 11.5927, 11.5287, 11.4586, 11.3869   
     * /   
           data ( blb(i), i= 358,  400)/
     1  11.3096, 11.2294, 11.1462, 12.5529, 12.5509, 12.5431, 12.5312,
     2  12.5156, 12.4951, 12.4689, 12.4377, 12.4020, 12.3615, 12.3144,
     3  12.2622, 12.2045, 12.1418, 12.0748, 12.0031, 11.9276, 11.8460,
     4  11.7630, 11.6766, 13.1224, 13.1204, 13.1125, 13.1006, 13.0840,
     5  13.0615, 13.0352, 13.0028, 12.9647, 12.9215, 12.8726, 12.8186,
     6  12.7573, 12.6919, 12.6220, 12.5469, 12.4675, 12.3838, 12.2975,
     7  12.2067                                                         
     * /   
c
c       pair: total x-section
c        gamm energy=
c       .30000E-02  .55435E-02  .10244E-01  .18929E-01  .34977E-01
c       .64633E-01  .11943      .22069      .40781      .75357    
c       1.3925      2.5731      4.7547      8.7859      16.235    
c       30.000    
c       log10 step=   .2667
c
c      log10 of gamma energy boundary
      data  etcpl1/-2.522879/
c    *     ,etcpl2/ 1.477121/
c
           data ( tcpl(i), i= 1,  16)/
     1    .0490,   .1256,   .2124,   .3038,   .3950,   .4831,   .5631,
     2    .6289,   .6774,   .7113,   .7340,   .7489,   .7583,   .7642,
     3    .7678,   .7699                                                
     * /   
c
c       pair: region a
c
c         energy of gamma=
c         .300E-02    .554E-02    .102E-01    .189E-01    .350E-01
c         .646E-01    .119        .221        .408        .754    
c         1.39        2.57        4.75        8.79        16.2    
c         30.0    
c         log10 step=  .266667
c
c         log10 of eg boundary
      data  egla1l/-2.522879/
c    *     ,egla2l/ 1.477121/
c
c
c         pla(iu,ie)=(v-.5)/(1.-u)
c         u= .050 to1.000   step=  .0633
c            log10(e)= -2.5229 to   1.4771 step=  .2667
c
           data ( pla(i), i= 1,  119)/
     1    .2908,   .2767,   .2682,   .2635,   .2579,   .2552,   .2525,
     2    .2497,   .2491,   .2465,   .2450,   .2453,   .2457,   .2415,
     3    .2389,   .2432,   .3748,   .3620,   .3546,   .3485,   .3447,
     4    .3415,   .3403,   .3372,   .3369,   .3343,   .3333,   .3349,
     5    .3333,   .3301,   .3333,   .3326,   .4192,   .4090,   .4020,
     6    .3985,   .3956,   .3935,   .3925,   .3913,   .3897,   .3898,
     7    .3901,   .3904,   .3910,   .3921,   .3956,   .3891,   .4459,
     8    .4371,   .4326,   .4297,   .4277,   .4281,   .4271,   .4276,
     9    .4261,   .4267,   .4274,   .4285,   .4303,   .4267,   .4303,
     a    .4286,   .4625,   .4560,   .4531,   .4522,   .4511,   .4513,
     b    .4516,   .4537,   .4544,   .4553,   .4566,   .4584,   .4566,
     c    .4603,   .4566,   .4584,   .4730,   .4688,   .4675,   .4673,
     d    .4684,   .4697,   .4713,   .4714,   .4737,   .4742,   .4780,
     e    .4761,   .4780,   .4818,   .4780,   .4811,   .4805,   .4788,
     f    .4780,   .4796,   .4816,   .4838,   .4867,   .4882,   .4925,
     g    .4930,   .4968,   .4988,   .5019,   .5007,   .4968,   .5015,
     h    .4865,   .4862,   .4882,   .4905,   .4946,   .4980,   .5022   
     * /   
           data ( pla(i), i= 120,  238)/
     1    .5055,   .5098,   .5129,   .5142,   .5161,   .5193,   .5180,
     2    .5295,   .5225,   .4917,   .4927,   .4963,   .5005,   .5055,
     3    .5099,   .5153,   .5201,   .5240,   .5268,   .5306,   .5364,
     4    .5358,   .5422,   .5460,   .5405,   .4953,   .4988,   .5040,
     5    .5088,   .5144,   .5197,   .5261,   .5303,   .5356,   .5402,
     6    .5436,   .5486,   .5518,   .5505,   .5620,   .5546,   .4987,
     7    .5035,   .5091,   .5142,   .5204,   .5277,   .5333,   .5383,
     8    .5448,   .5483,   .5532,   .5566,   .5624,   .5662,   .5624,
     9    .5649,   .5009,   .5059,   .5128,   .5196,   .5262,   .5325,
     a    .5386,   .5443,   .5494,   .5562,   .5595,   .5645,   .5677,
     b    .5664,   .5780,   .5722,   .5026,   .5082,   .5153,   .5222,
     c    .5291,   .5357,   .5421,   .5482,   .5539,   .5588,   .5658,
     d    .5685,   .5730,   .5742,   .5781,   .5771,   .5026,   .5104,
     e    .5177,   .5236,   .5305,   .5373,   .5439,   .5502,   .5561,
     f    .5640,   .5689,   .5724,   .5782,   .5820,   .5782,   .5804,
     g    .5047,   .5116,   .5177,   .5249,   .5319,   .5389,   .5456,
     h    .5522,   .5584,   .5641,   .5689,   .5724,   .5782,   .5820   
     * /   
           data ( pla(i), i= 239,  256)/
     1    .5782,   .5824,   .5047,   .5116,   .5189,   .5262,   .5334,
     2    .5404,   .5474,   .5541,   .5606,   .5666,   .5720,   .5763,
     3    .5782,   .5821,   .5782,   .5837                              
     * /   
c
c
c       pair: region b
c
c         energy of gamma=
c         .300E-02    .314E-02    .362E-02    .458E-02    .636E-02
c         .971E-02    .163E-01    .300E-01    .607E-01    .135    
c         .330        .884        2.61        8.44        30.0    
c         sqrt(log10) step=  .142857
c
c         use 0 for e-side at interpolation
c         with sqrt(log10(e)-eglb1l)
      data  eglb1l/-2.522879/
c
c
c         plb(iu,ie)=v
c         sqrt(u)= .000 to .224   step=  .0149
           data ( plb(i), i= 1,  119)/
     1    .8297,   .8264,   .8239,   .8200,   .8161,   .8136,   .8097,
     2    .8058,   .8033,   .7994,   .7955,   .7917,   .7878,   .7840,
     3    .7801,   .7762,   .8375,   .8355,   .8329,   .8289,   .8263,
     4    .8223,   .8184,   .8157,   .8118,   .8078,   .8039,   .8012,
     5    .7973,   .7933,   .7894,   .7854,   .8589,   .8582,   .8554,
     6    .8525,   .8497,   .8455,   .8427,   .8385,   .8357,   .8315,
     7    .8273,   .8245,   .8203,   .8161,   .8119,   .8077,   .8884,
     8    .8877,   .8861,   .8831,   .8801,   .8770,   .8740,   .8694,
     9    .8664,   .8619,   .8588,   .8543,   .8497,   .8467,   .8421,
     a    .8376,   .9197,   .9189,   .9172,   .9140,   .9123,   .9090,
     b    .9041,   .9008,   .8976,   .8943,   .8894,   .8861,   .8812,
     c    .8779,   .8730,   .8680,   .9474,   .9465,   .9448,   .9413,
     d    .9395,   .9360,   .9325,   .9290,   .9255,   .9220,   .9168,
     e    .9133,   .9098,   .9046,   .9011,   .8958,   .9686,   .9677,
     f    .9659,   .9622,   .9604,   .9567,   .9531,   .9512,   .9476,
     g    .9439,   .9402,   .9348,   .9311,   .9274,   .9238,   .9183,
     h    .9830,   .9820,   .9801,   .9783,   .9745,   .9726,   .9688   
     * /   
           data ( plb(i), i= 120,  238)/
     1    .9650,   .9632,   .9594,   .9556,   .9518,   .9481,   .9443,
     2    .9400,   .9363,   .9916,   .9906,   .9887,   .9868,   .9849,
     3    .9810,   .9791,   .9772,   .9733,   .9695,   .9676,   .9637,
     4    .9604,   .9565,   .9527,   .9489,   .9962,   .9952,   .9933,
     5    .9914,   .9894,   .9875,   .9856,   .9836,   .9797,   .9778,
     6    .9739,   .9720,   .9686,   .9657,   .9618,   .9579,   .9984,
     7    .9975,   .9955,   .9955,   .9936,   .9916,   .9897,   .9877,
     8    .9858,   .9838,   .9800,   .9780,   .9746,   .9717,   .9688,
     9    .9658,   .9994,   .9984,   .9984,   .9965,   .9965,   .9945,
     a    .9926,   .9906,   .9887,   .9867,   .9848,   .9828,   .9789,
     b    .9770,   .9745,   .9716,   .9998,   .9988,   .9988,   .9988,
     c    .9969,   .9949,   .9949,   .9930,   .9910,   .9891,   .9871,
     d    .9852,   .9832,   .9813,   .9793,   .9759,   .9999,   .9990,
     e    .9990,   .9990,   .9970,   .9970,   .9951,   .9951,   .9931,
     f    .9912,   .9892,   .9872,   .9853,   .9833,   .9814,   .9775,
     g   1.0000,   .9990,   .9990,   .9990,   .9990,   .9971,   .9971,
     h    .9951,   .9931,   .9931,   .9912,   .9892,   .9873,   .9853   
     * /   
           data ( plb(i), i= 239,  240)/
     1    .9814,   .9795                                                
     * /   

c
c    ---------------     $$$   landau correction region $$$     ----
c  media=Air  z=  7.52 a= 15.17 rho=     .120E-02
c  0*** constant used in landau effect
c z=   7.52 a=  15.17 rho=    .00 x0=*******cm= 36.085g/cm**2 
c    s1= .115E-03 ln(s1)=-9.07      const in eq.60 of migdal= .287E+08
c     gamma cut off energy = .100E-03gev
      data deelh/  .208333/
      data deghl/  .142051/
c
c          energy of electron
c        50.00       80.78       130.5       210.8       340.6    
c        550.3       889.1       1436.       2321.       3749.    
c        6058.       9787.       .1581E+05   .2554E+05   .4127E+05
c        .6668E+05   .1077E+06   .1740E+06   .2812E+06   .4543E+06
c        .7339E+06   .1186E+07   .1916E+07   .3095E+07   .5000E+07
c         log10 step=  .208333
c
c         log10 of electron energy boundary
      data eeh1l/ 1.698970/
c    *     ,eeh2l/ 6.698970/
c
           data ( tcbh(i), i= 1,  25)/
     1  16.6604, 17.3022, 17.9420, 18.4853, 18.8376, 18.9622, 18.8716,
     2  18.6057, 18.2154, 17.7387, 17.2037, 16.6290, 16.0326, 15.4193,
     3  14.7970, 14.1682, 13.5345, 12.8992, 12.2633, 11.6254, 10.9859,
     4  10.3500,  9.7121,  9.0762,  8.4412                              
     * /   
c
c          be1(iu,ie)= alog(v/vmin)
c          from u= .000 to  .700 step= .100
c          from log10(e)=  1.6990 to  6.6990 step   .2083
c          dim. of u=  8 dim of e= 25
c
           data (   be1(i), i= 1,  102)/
     1  13.12236, 11.41732, 10.04307,  8.76139,  7.50325,  6.25068,
     2   5.00033,  3.75125, 13.60207, 11.84038, 10.42233,  9.09454,
     3   7.78960,  6.48999,  5.19090,  3.89387, 14.08177, 12.26305,
     4  10.80179,  9.43005,  8.07701,  6.72954,  5.38321,  4.03703,
     5  14.56148, 12.69655, 11.19867,  9.78563,  8.39224,  7.00481,
     6   5.61758,  4.23123, 15.04118, 13.14585, 11.62220, 10.18626,
     7   8.76672,  7.35215,  5.93931,  4.52633, 15.52089, 13.61412,
     8  12.08309, 10.63663,  9.20923,  7.78578,  6.36299,  4.94050,
     9  16.00060, 14.10201, 12.57787, 11.13778,  9.71586,  8.29963,
     a   6.88307,  5.46457, 16.48030, 14.60428, 13.09791, 11.67688,
     b  10.27562,  8.87803,  7.48256,  6.08440, 16.96000, 15.11844,
     c  13.63861, 12.24553, 10.87278,  9.50484,  8.13836,  6.77055,
     d  17.43971, 15.63888, 14.19164, 12.83323, 11.49613, 10.16367,
     e   8.83245,  7.50361, 17.91942, 16.16621, 14.75566, 13.43504,
     f  12.13671, 10.84377,  9.55115,  8.26608, 18.39912, 16.69675,
     g  15.32508, 14.04514, 12.78889, 11.54016, 10.28799,  9.04784,
     h  18.87883, 17.22992, 15.89920, 14.66112, 13.44882, 12.24355      
     * /   
           data (   be1(i), i= 103,  200)/
     1  11.03631,  9.84074, 19.35853, 17.76520, 16.47503, 15.28119,
     2  14.11245, 12.95320, 11.79178, 10.63947, 19.83824, 18.30096,
     3  17.05485, 15.90328, 14.78037, 13.66695, 12.55524, 11.44284,
     4  20.31794, 18.83912, 17.63407, 16.52806, 15.44917, 14.38160,
     5  13.31933, 12.24725, 20.79765, 19.37708, 18.21565, 17.15329,
     6  16.12157, 15.09693, 14.08541, 13.05115, 21.27735, 19.91708,
     7  18.79804, 17.78037, 16.79432, 15.81552, 14.85338, 13.85456,
     8  21.75706, 20.45769, 19.38275, 18.40824, 17.46632, 16.53671,
     9  15.61989, 14.65395, 22.23676, 20.99818, 19.96696, 19.03624,
     a  18.13758, 17.25954, 16.38484, 15.44963, 22.71647, 21.53995,
     b  20.55409, 19.66591, 18.81226, 17.98135, 17.14707, 16.24185,
     c  23.19617, 22.08256, 21.14085, 20.29617, 19.48794, 18.70501,
     d  17.90718, 17.03035, 23.67588, 22.62703, 21.72887, 20.92550,
     e  20.16673, 19.42661, 18.66144, 17.81060, 24.15558, 23.17149,
     f  22.31863, 21.55731, 20.84595, 20.14610, 19.41174, 18.58519,
     g  24.63529, 23.71692, 22.90988, 22.19316, 21.52633, 20.86015,
     h  20.15496, 19.35082                                              
     * /   
c
c         be2(iu,ie)= (sqrt(v) -sqrtv)/(1.-u)
c          from sqrt(1-u)= .000 to  .548 step=  .055
c          from log10(e)= 1.698970 to 6.698970 step   .2083
c
           data (   be2(i), i= 1,  119)/
     1    .0089,   .0093,   .0092,   .0097,   .0104,   .0113,   .0126,
     2    .0145,   .0171,   .0208,   .0260,   .0071,   .0073,   .0074,
     3    .0078,   .0084,   .0093,   .0105,   .0121,   .0144,   .0176,
     4    .0223,   .0060,   .0061,   .0063,   .0065,   .0070,   .0077,
     5    .0086,   .0100,   .0120,   .0149,   .0190,   .0056,   .0057,
     6    .0057,   .0060,   .0063,   .0069,   .0076,   .0088,   .0105,
     7    .0130,   .0167,   .0056,   .0056,   .0057,   .0059,   .0062,
     8    .0067,   .0074,   .0084,   .0098,   .0121,   .0156,   .0060,
     9    .0060,   .0061,   .0063,   .0066,   .0071,   .0077,   .0086,
     a    .0100,   .0121,   .0154,   .0067,   .0067,   .0069,   .0071,
     b    .0074,   .0079,   .0085,   .0094,   .0108,   .0128,   .0161,
     c    .0077,   .0078,   .0079,   .0082,   .0085,   .0090,   .0097,
     d    .0107,   .0121,   .0143,   .0175,   .0091,   .0091,   .0093,
     e    .0096,   .0100,   .0106,   .0114,   .0125,   .0140,   .0163,
     f    .0197,   .0108,   .0108,   .0111,   .0114,   .0119,   .0126,
     g    .0135,   .0147,   .0164,   .0189,   .0226,   .0128,   .0130,
     h    .0133,   .0137,   .0143,   .0151,   .0162,   .0176,   .0195   
     * /   
           data (   be2(i), i= 120,  238)/
     1    .0222,   .0263,   .0154,   .0155,   .0159,   .0165,   .0172,
     2    .0182,   .0194,   .0210,   .0232,   .0262,   .0307,   .0184,
     3    .0187,   .0192,   .0199,   .0208,   .0219,   .0234,   .0252,
     4    .0277,   .0311,   .0361,   .0221,   .0225,   .0232,   .0241,
     5    .0252,   .0265,   .0281,   .0303,   .0331,   .0369,   .0424,
     6    .0265,   .0270,   .0280,   .0292,   .0304,   .0320,   .0339,
     7    .0364,   .0396,   .0439,   .0499,   .0317,   .0325,   .0339,
     8    .0352,   .0368,   .0386,   .0408,   .0436,   .0473,   .0521,
     9    .0588,   .0379,   .0392,   .0409,   .0426,   .0444,   .0465,
     a    .0491,   .0523,   .0564,   .0619,   .0692,   .0452,   .0471,
     b    .0493,   .0513,   .0534,   .0559,   .0589,   .0626,   .0672,
     c    .0733,   .0814,   .0539,   .0566,   .0593,   .0617,   .0642,
     d    .0671,   .0705,   .0747,   .0799,   .0867,   .0955,   .0646,
     e    .0682,   .0712,   .0741,   .0770,   .0804,   .0842,   .0889,
     f    .0948,   .1023,   .1119,   .0776,   .0812,   .0852,   .0886,
     g    .0920,   .0959,   .1003,   .1056,   .1122,   .1203,   .1309,
     h    .0929,   .0969,   .1017,   .1057,   .1097,   .1141,   .1191   
     * /   
           data (   be2(i), i= 239,  275)/
     1    .1251,   .1322,   .1413,   .1527,   .1109,   .1153,   .1209,
     2    .1256,   .1302,   .1352,   .1409,   .1475,   .1554,   .1652,
     3    .1775,   .1317,   .1366,   .1432,   .1486,   .1539,   .1595,
     4    .1659,   .1731,   .1819,   .1926,   .2057,   .1557,   .1612,
     5    .1687,   .1750,   .1810,   .1873,   .1944,   .2024,   .2120,
     6    .2234,   .2373                                                
     * /   
c
c
c         energy of gamma
c        .1000E+05   .1387E+05   .1924E+05   .2668E+05   .3700E+05
c        .5132E+05   .7117E+05   .9871E+05   .1369E+06   .1899E+06
c        .2633E+06   .3652E+06   .5065E+06   .7025E+06   .9744E+06
c        .1351E+07   .1874E+07   .2599E+07   .3605E+07   .5000E+07
c       log10 step=  .142051
c
c       log10 of gamma energy boundary
      data egh1l/ 4.000000/
c    *     ,egh1l/ 6.698970/
c
           data (  tcph(i), i= 1,  20)/
     1    .7778,   .7778,   .7778,   .7778,   .7778,   .7778,   .7778,
     2    .7778,   .7778,   .7778,   .7778,   .7778,   .7778,   .7778,
     3    .7778,   .7778,   .7778,   .7778,   .7778,   .7778            
     * /   
c
c        table of v
c        from u=  .0000 to  1.0000 step   .1000
c        from log10(e)= 4.000000 to 6.698970 step   .1421
c
           data (   vp(i), i= 1,  119)/
     1   1.0000,   .9604,   .9185,   .8735,   .8267,   .7778,   .7261,
     2    .6714,   .6157,   .5581,   .5000,  1.0000,   .9604,   .9185,
     3    .8735,   .8267,   .7778,   .7261,   .6714,   .6157,   .5581,
     4    .5000,  1.0000,   .9604,   .9185,   .8735,   .8267,   .7778,
     5    .7261,   .6714,   .6157,   .5581,   .5000,  1.0000,   .9604,
     6    .9185,   .8735,   .8267,   .7778,   .7261,   .6714,   .6157,
     7    .5581,   .5000,  1.0000,   .9604,   .9185,   .8735,   .8267,
     8    .7778,   .7261,   .6714,   .6157,   .5581,   .5000,  1.0000,
     9    .9604,   .9185,   .8735,   .8267,   .7778,   .7261,   .6714,
     a    .6157,   .5581,   .5000,  1.0000,   .9604,   .9185,   .8735,
     b    .8267,   .7778,   .7261,   .6714,   .6157,   .5581,   .5000,
     c   1.0000,   .9604,   .9185,   .8735,   .8267,   .7778,   .7261,
     d    .6714,   .6157,   .5581,   .5000,  1.0000,   .9604,   .9185,
     e    .8735,   .8267,   .7778,   .7261,   .6714,   .6157,   .5581,
     f    .5000,  1.0000,   .9604,   .9185,   .8735,   .8267,   .7778,
     g    .7261,   .6714,   .6157,   .5581,   .5000,  1.0000,   .9604,
     h    .9185,   .8735,   .8267,   .7778,   .7261,   .6714,   .6157   
     * /   
           data (   vp(i), i= 120,  220)/
     1    .5581,   .5000,  1.0000,   .9604,   .9185,   .8735,   .8267,
     2    .7778,   .7261,   .6714,   .6157,   .5581,   .5000,  1.0000,
     3    .9604,   .9185,   .8735,   .8267,   .7778,   .7261,   .6714,
     4    .6157,   .5581,   .5000,  1.0000,   .9604,   .9185,   .8735,
     5    .8267,   .7778,   .7261,   .6714,   .6157,   .5581,   .5000,
     6   1.0000,   .9604,   .9185,   .8735,   .8267,   .7778,   .7261,
     7    .6714,   .6157,   .5581,   .5000,  1.0000,   .9604,   .9185,
     8    .8735,   .8267,   .7778,   .7261,   .6714,   .6157,   .5581,
     9    .5000,  1.0000,   .9604,   .9185,   .8735,   .8267,   .7778,
     a    .7261,   .6714,   .6157,   .5581,   .5000,  1.0000,   .9604,
     b    .9185,   .8735,   .8267,   .7778,   .7261,   .6714,   .6157,
     c    .5581,   .5000,  1.0000,   .9604,   .9185,   .8735,   .8267,
     d    .7778,   .7261,   .6714,   .6157,   .5581,   .5000,  1.0000,
     e    .9604,   .9185,   .8735,   .8267,   .7778,   .7261,   .6714,
     f    .6157,   .5581,   .5000                                       
     * /   


c
c       total prob. equivalenced to common
c
      equivalence (tprob,tp)
c

c
c                         complete screening pair x-sxec.
c                         0.778 =(7/9-b)*rx0 =.773*rx0
      data rx0/1.0/, ctpc/.778/,  cep/5000.e3/
c       rx0=x0(true)/x0(in nishimura text)=5.82/6.4
c       cep:  minimum energy for landau correction for pair.
c          default esbc espc
      data esbin/5./,  espin/50./
c
c
      if(ee .lt. eblmin) then
          t=1.e36
      else
          if(.not. usees) then
             esb=esbin
          else
             esb=min(escb, eblmax)
          endif
          if(ee .gt. esb) then
              screen=.false.
              if(lcorec .and. ee .gt. eeh1) then
                  if(ee .gt. eeh2) then
                       write(6,'('' ee > eeh2 in brmAirt: ee='',g12.4)')
     *                 ee
                       stop
                  endif
                  landau=.true.
                  ale=log10(ee)
c                 tp=fintp3(tcbh, eeh1l, deelh, neeh, ale)*rx0
                  call kintp3(tcbh, 1, neeh, eeh1l, deelh, ale, tp)
                  tp=tp*rx0
              else
                  landau=.false.
c                     complete screening cross-section
                  vc=ec/ee
                  tp=(-1.3603*(log(vc)-vc)-vc*vc*.5-.8603 )*rx0
              endif
          else
              landau=.false.
              if(scorec) then
                  screen=.true.
                  ale=log10(ee)
c                 tp=fintp3(tcbl, etcbl1, debtcl, nbtcl,  ale)
                  call kintp3(tcbl, 1, nbtcl, etcbl1, debtcl,  ale, tp)
              else
                  screen=.false.
c                     complete screening cross-section
                  vc=ec/ee
                  tp=(-1.3603*(log(vc)-vc)-vc*vc*.5-.8603 )*rx0
              endif
          endif
c
          call rndc(u)
          t =-log(u)/tp
      endif
      return
c
c     ************
      entry brmAire(ee,ec,beg)
c     ************
c
      call rndc(u)
      if(screen) then
c           partial screening
         if(u .gt. uela1) then
c                  region a
c              beg=exp( tdint4(bla, nuela, neela, uela1, eela1l, duela,
c    *         deela, u,  ale)*(1.-u) ) *egmnl
               call k4ptdi(bla, nuela, neela, nuela, uela1, eela1l,
     *         duela, deela, u, ale, ans)
               beg=exp( ans*(1.-u))*egmnl
         else
c                  region b
               us=sqrt(u)
c              beg=exp( tdint4(blb, nuelb, neelb, uelb1, eelb1l,duelb,
c    *         deelb, us, ale)) * egmnl
               call k4ptdi(blb, nuelb, neelb, nuelb, uelb1, eelb1l,
     *         duelb, deelb, us, ale, ans)
               beg=exp(ans)*egmnl
         endif
      elseif(landau) then
         if(u .lt. ueh2) then
c              beg=exp( tdint4(be1, nueh1, neeh, ueh1, eeh1l, dueh1,
c    *         deelh, u,  ale)  ) * egmnh
               call k4ptdi(be1, nueh1, neeh, nueh1,  ueh1, eeh1l,
     *         dueh1, deelh, u,  ale, ans)
               beg=exp( ans ) *egmnh
         else
               us=sqrt(1.-u)
c              beg=   ( tdint4(be2, nueh2, neeh, ueh3, eeh1l, dueh2,
c    *         deelh, us,  ale)*(1.-u)+ sqrt(egmnh/ee) )**2 *ee
               call k4ptdi(be2, nueh2, neeh, nueh2,  ueh3, eeh1l,
     *         dueh2, deelh, us,  ale, ans)
               beg=  (ans*(1.-u) + sqrt(egmnh/ee) )**2*ee
         endif
      else
c               complete screening
          a=u*tp
          if(a .le. 1.) then
             v=exp(-a)
             if(a .gt. .1) then
                 v=((.06366*a-.1447407)*a+1.014176)*v
             endif
          else
             v=exp(-(a+0.8603)/1.3603)
             if(a .le. 6.) then
                 v=((((2.050445e-3*a-3.53209e-2)*a+.228937)*a-.684076)*a
     *           +1.841734)*v
             endif
          endif
          beg=ee*v
      endif
      return
c
c
c     ***********
      entry prcAirt(eg,t)
c     ***********
c
c
c
      if(eg .le. emass2) then
          t=1.e37
      elseif(eg .lt. eplmin .and. scorec) then
          tp=( (eg-emass2)/(eplmin-emass2) )**3 * tcpl(1)
          call rndc(u)
          t =-log(u)/tp
          landau=.false.
          screen=.true.
      else
          if(.not. usees) then
             esp=espin
          else
             esp=min(escp, eplmax)
          endif
          if(eg .gt. esp) then
              screen=.false.
              if(eg .gt. cep   .and. lcorec) then
                  landau=.true.
                  ale=log10(eg)
c                 tp=fintp3(tcph, egh1l, deghl, negh, ale)*rx0
                  call kintp3(tcph, 1, negh,  egh1l,  deghl,   ale, tp)
                  tp=tp*rx0
              else
                  landau=.false.
c                     complete screening cross-section
                  tp=ctpc
              endif
          else
              landau=.false.
              if(scorec) then
                  screen=.true.
                  ale=log10(eg)
c                 tp=fintp3(tcpl, etcpl1, deptcl, nptcl, ale)
                  call kintp3(tcpl, 1,nptcl,  etcpl1, deptcl,  ale, tp)
              else
                  screen=.false.
c                     complete screening cross-section
                  tp=ctpc
              endif
          endif
          call rndc(u)
          t =-log(u)/tp
      endif
      return
c
c
c     ***********
      entry prcAire(eg,e1)
c     ***********
c
c
c
      call rndc(u)
      if(screen) then
c           partial screening
         if(u .ge. ugla1) then
c                   region a
c               e1=(tdint4(pla, nugla, negla, ugla1, egla1l, dugla,
c    *          degla, u,    ale) *(1.-u) + .5 )*eg
                call k4ptdi(pla, nugla, negla,nugla,  ugla1, egla1l,
     *          dugla, degla, u,   ale, ans)
                e1=(ans*(1.-u) + .5)*eg
         else
c                   region b
                us=sqrt(u)
                ex=sqrt(ale-eglb1l)

                call k4ptdi(plb, nuglb, neglb,nuglb,  uglb1, 0.d0,
     *          duglb, deglb, us,  ale, ans)
                e1=ans*eg
         endif
      elseif(landau) then
c        e1= tdint4(vp, nugh2, negh, ugh3, egh1l, dugh2,
c    *   deghl, u,  ale) * eg
         call k4ptdi(vp, nugh2, negh, nugh2, ugh3, egh1l,
     *   dugh2, deghl, u,  ale, ans)
         e1=ans*eg
      else
c                complete screening
         e1=(((.0441223*u-.173755)*u-.3708608)*u+1.)*eg
      endif
      return
c
c     ************
      entry emctAir(Knckon)
c     ************
c
c               cconst=for compton=3/8*thomson*n0*z/a*x0ing
c               to convert cross-section in compt into /(r.l).
c               = 0.15 *z/a *x0ing
      cconst=2.71
      x0= 30000.
      x0ing= 36.5
      x0sq=9.e8
      if(Knckon) then
         ecrit=76.e-3
      else
         ecrit=81.e-3
      endif
c         moller scat  0.3 z/a * x0ing
      constm=5.417
      rho = 1.205e-3
c
      zchrg=7.52
      zchrg2 = 59.9
      amassn= 15.2
      ionizP = 95.77d-9
      end
