c     ****************************************************************
c     *
c     * bhabht: samples bhabha scattering path in r.l
c     * bhabhe: //      energy of survival and recoil electrons
c     * bhabha: //      angle of survival and recoil electrons
c     *
c     ************************ tested 87.02.13 ***********************
c
c   /usage/  call bhabht(ee, w, path)
c
c   --input--
c   ee:  position energy in gev
c    w: minimum kinetic energy of recoil position to be treated.
c       (around .25e-3 gev).
c
c   -- output --
c path: sampled path in r.l
c   e1: recoil electron   energy
c   epos: survaival positron energy
c
c cos1: cos  of recoil electron
c coss: cos of survaival positron
c
c  **** note ***
c            before calling bhabhe, bhabht must be called and
c            befroe calling bhabha, bhabhe must be called.
c
c            constm=.3*z/a*x0ing
c
c            in  $$elmag must have been fixed beforehand.
c
       subroutine bhabht(ee, w, path)
       implicit none
c
#include  "Zelmag.h"
c
      real*8 ee, w, path

        real*8  epos, e1
        real*8  epi, coss, cos1, tmp, cos12, ep, g, t0n, y, csc
        real*8 tp, em,  t0, t1, Beta2, tm4, tm3, tm2, tm1
        real*8 u, ge, e2, ts, eps
c
c            equivalenced to common
        equivalence (tp, tprob)
        save em, epi, t0, t1, tm4, tm3, tm2, tm1, Beta2
c
c
        real*8 gef

        gef(ep)=(1.-em)/Beta2 * (1. - Beta2*( ((-tm4*ep+tm3)*ep
     *  -tm2)*ep+tm1)*ep)
c
       g=emass/ee
       Beta2=1. - g**2
       t0=ee-emass
       if(t0 .le. w) then
           tp=0.
           path=1.e35
       else
           em= w/t0
           t0n=t0/emass
           y=1./(t0n+2.)
           tm1=2.-y**2
           tm2= ((-2.*y+1.)*y-6.)*y+3.
           tm3= ((-8.*y+16.)*y-10.)*y+2.
           tm4= (1.-2*y)**3
           csc= -1. -Beta2* (-tm2+tm3/2-tm4/3.) +1./em +Beta2*
     *     (   ((-tm4/3.*em +tm3/2)*em-tm2)*em+tm1*log(em) )
           tp=csc/Beta2/t0n *constm
           call rndc(u)
           path=-log(u) / tp
       endif
       return
c
c      ************
       entry bhabhe(ee, epos, e1)
c      ************
c                   rejection method
c       *** until loop*** 
       do while (.true.)
            call rndc(u)
            ep=1./ (  1. - (1.-1./em)*u )
            ge=gef(ep)
            call rndc(u)
            u=u*gef(em)
       if         ( u .lt. ge)
     *                    goto 100
       enddo
  100  continue
       t1=ep*t0
       e1=t1 + emass
       epos=ee-e1+emass
       if(e1 .lt. emass .or. epos .lt. emass) then
           t1=(ee-emass)/2
           e1=t1+emass
           epos=e1
       endif
       epi=epos
       return
c
c      ************
       entry bhabha(coss, cos1)
c      ************
c
       ts=epi-emass
       e2=emass*2
       eps=t0-ts
       if(eps/(t0+e2) .lt. 0.05) then
           coss=1.d0 - eps*emass/(t0*(t0+e2))
       else
           cos12=ts*(t0+e2)/( t0*(ts+e2))
           if(cos12 .lt. 0.) then
c             this is due to the change of energy by de/dx.  it may die
c             soon.
              coss=0.
           else
               coss=sqrt(cos12)
           endif
       endif
c
       tmp =t1*(t0+e2)/(t0*(t1+e2))
       if(tmp .lt. 0.) then
           cos1=0.
       else
           cos1=sqrt(tmp)
       endif
       return
       end
