#include "../main.f"
c        **************************************************************
c        *
c        * ephook:  collection of subroutines which should be managed by
c        *      the user.  This is a sample program to count the  energy
c        *      loss at given layers.
c        *  
c        **************************************************************
c         
c
c   +++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
c   +  Note that besides the subroutines listed below in this module,
c   +  the following inquirey subroutines are available for use:
c   +
c   +  call epqFirstI(pos);
c         #include "ZepPos.h"
c         record /epPos/ pos ; output.( pos.x, pos.y, pos.z )
c                              First interaction position
c
c   +  call epqmat(i, mat): i; integer input.  component number
c   +                       mat: characeter*8 output.  mediea
c   +                            such as 'Si' of  the i-th component.
c   +  call epqstn(n):  n; integer output.  get current stack depth
c
c   +  call epqsTrack(n, sTrack): inquire stacked track.
c                    n; integer input. stack depth
c                   record /epTrack/ sTrack. Energy=0 means n is invalid
c   +  call epqevn(nev):  nev; integer output. Event number already created
c                              in this run.
c   +  call epqinc(aTrack)
c                 inquire incident particle.
c   +         record /epTrack/ aTrack
c   +             if multiple particles are incident, the first one is obtained

c   +  call epqncp(ncomp) inquire the total number of components
c                   integer ncomp  output.
c
c   +  call sqtevn(nev): nev; integer output.  total number of events
c   +                                           created so far.
c   +
c   +  call sqcont(icon):  icon; integer output. 
c   +                            icon == 0 ==>  first job
c   +                            icon != 0 ==>  continued job
c   +++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
c        
c
c       *****************************
c       *        At this momemet, all the system level initialization 
c       *   has been ended.  Do your own initialization for all the
c       *   events.
c
        subroutine uiaev
        implicit none
        include 'Ztest2.h'

        character*150 filen
        call epqHookc(1, filen)
        open(15, file=filen, form='formatted')
        nread = 0
        naccepted = 0
        end

c       **************************************************
c       *  At this moment, all the system level initialization for
c       *  an event has been ended.  Do your own initializaiton for
c       *  the event.   Note, at this moment, no incident particle
c       *  has been made yet.
c       *
        subroutine ui1ev
        implicit none
        include 'Ztest2.h'
        integer i

        call epqncp(Ncomp)   ! inquire the number of components

        
        do i = 1,  Ncomp
           Eloss(i) = 0.
        enddo


        end
c       **************************************************
c       *  If the default incident particle treatment does not
c       *  suffice you, make your own incident particle here.
c       * (you can  make even multiple particles as  the incident).
c       *  If default is ok, don't touch this.
        subroutine usetip(icon)
        implicit none
#include "ZepTrack.h"
#include "Zcode.h"
        integer icon

        include 'Ztest2.h'

        record /epTrack/ aTrack
c            
c        If you make the incident yourself.
c             make icon = 0 on return, 
c             ^^^^^^^^^^^^^^^^^^^^^^^^
c        To make the incident, you may make the next call
c           as many times as you want.
c 
c        call epputTrack(aTrack)
c           record /epTrack/ aTrack
c              
        character*128 msg

        real*8  centx, centy, centz, radius, cs, sn, csz
        real*8  rx, ry, rz, mom, xin, yin, xot, yot, sinu
        real*8  zbottom, el, ztop, u
        logical ok
c             
c          by  hemisphere
        data centx/14.d0/, centy/14.d0/, centz/47.3d0/ 
c      
        data radius/88.640d0/   ! bit smaller
            
        data zbottom /40.075d0/, ztop/12.025d0/ ! with anti
c        data zbottom /40.325d0/, ztop/12.025d0/  ! no anti

c////////////
c        integer iii /0/
c        save iii
c        if(iii .eq. 0) then
c           open(22, file='data', form='formatted')
c           iii = 1
c        endif
c////////////
 10     continue
        ke = 10.d3
        do while( ke .gt. 2.0d3)
c            negletc  E> 2TeV
           read(15,*, end=100 ) code, subc, chg, ke, w1, w2, w3
c     *               pcode, pergpn, za
           nread = nread + 1
        enddo
        za = -w3
        call rndc(u)
        if(u .gt. (za+1.d0)/2.0d0 ) goto 10
        finish = 0
        w3 = -w3
        w2 = -w2
        w1 = -w1
        ok = .false.
        do while(.not. ok)
           call kcossn(cs, sn)
           call rndc(csz)
           csz = - csz
c           csz =2* csz -1.   !! ***************
           sinu = sqrt(1.d0 -csz**2)
           rx =  radius * sinu *cs
           ry =  radius * sinu *sn
           rz =  radius * csz
           call rndc(u)
           ok = (  -( rx * w1 + ry * w2 + rz*w3) /
     *                  radius) .gt. u
c             next is n.g, since position is not uniform
c          on the surface of sphere for directed beam.
c          beam is uniform on the projected surface
c
c           ok =  ( rx * w1 + ry * w2 + rz*w3) .lt. 0.d0
        enddo
        naccepted = naccepted + 1
        aTrack.pos.x = rx + centx
        aTrack.pos.y = ry + centy
        aTrack.pos.z = rz + centz
        aTrack.w.x = w1
        aTrack.w.y = w2
        aTrack.w.z = w3
c          crossing point at z=top
        el = (ztop- aTrack.pos.z) / w3
        xin = aTrack.pos.x + el * w1
        yin = aTrack.pos.y + el * w2
c          crossing point at bottom 
        el =( zbottom -  aTrack.pos.z) / w3
        xot = aTrack.pos.x + el * w1
        yot = aTrack.pos.y + el * w2
        if(xin .lt. 28.d0   .and. xin .gt. 0.  .and.
     *     yin .lt. 28.d0   .and. yin .gt. 0. ) then
           in =1
        else
           in = 0
        endif
        if(xot .lt. 28.d0   .and. xot .gt. 0.  .and.
     *      yot .lt. 28.d0   .and. yot .gt. 0. ) then
           ot =1
        else
           ot = 0
        endif

        if(code .eq. kkaon .and. chg .eq. 0) then
c            very  rare.
c            must be k0l. rarely subc is invalid;
c            (-1)--> crash.
c            adjust to be k0l
           if(abs(subc) .ne. k0l .or. abs(subc) .ne. k0s) then
              subc = k0l
           endif
        endif
        call cmkptc(code, subc, chg, aTrack.p)
        aTrack.p.fm.p(4) = ke   ! ke is total E.
        mom = sqrt(aTrack.p.fm.p(4)**2 - aTrack.p.mass**2)
        aTrack.p.fm.p(1) = mom *w1
        aTrack.p.fm.p(2) = mom *w2
        aTrack.p.fm.p(3) = mom *w3
        call epputTrack(aTrack)
        icon=0
        return
 100    continue
        write(msg, *) ' read=', nread, ' accpeted=',naccepted
        call cerrorMsg(msg, 1)
        stop
        end
        subroutine uafi1ev
c          this is called when all the initialization for
c         an event has been ended.  (incident particle has
c         set).  Do your own final init. for the event
        end

c       ***********************************************
c       *   This is called 
c       *     when a charged particle loses
c       *     energy in a component for which you have specifed to do
c       *     energy loss counting.
c       * Or
c       *     when a photon energy becomes lower than a given minimum
c       *     energy.  It's your decision whether you discard such 
c       *     a photon or count as energy lost here.
c  
        subroutine userde(info, aTrack, Move, media)
        implicit none
#include "ZepTrack.h"
#include "Zmove.h"
#include "Zmedia.h"

c          next is needed if you want to judge particle code.
c  #include "Zcode.h"     
        include 'Ztest2.h'

        integer info             ! input. 0--> particle is still active.
                                 !        1--> particle is dying.
                                 !        (i.e, after moving Move.dl, it 
                                 !         dies) .
        record /epTrack/ aTrack  ! input. current track. before it is moved.
        record /epmove/  Move      ! input. containes info of moved track.
c                                ! output. You have to set Move.Abort
c         Move.Abort = 0 if you want to continue the simulation of
c                           this event normally.
c                    = 1 if you want to discard this particle
c                        For example, you may use this if you use
c                        formula for further development due to this
c                        particle 
c                    = 2 if you want to abort the generation of 
c                           this event, but want to execute ue1ev.
c                    = 3 if you want to abort the genration of 
c                         this event, and skip ue1ev.
        record /epmedia/media

         
      Eloss(aTrack.cn) = Eloss(aTrack.cn) + Move.dEeff
      Move.Abort = 0


c          You can use the following info.
c   ================================================================
c     aTrack.p         : the same particle record as Cosmos, i.e.,
c     aTrack.p.fm.p(1), p(2), p(3): momentum of the particle in GeV
c     aTrack.p.fm.p(4)            : total energy of    //
c     aTrack.p.mass               : mass  //                 
c     aTrack.p.code               : particle code 
c     aTrack.p.subcode            : particle subcode 
c     aTrack.p.charge             : charge  //.
c     aTrack.pos.x, y, z          : local coordinate of the particle in cm
c                                   If you need world coordinate, use
c                          call epl2w(aTrack.cn, aTrack.pos, wpos) 
c                    where
c                   record /epPos/ wpos is the output  world coordinate
c     aTrack.w.x, y, z            : direction cosines in the local coordinate
c                                   If you need world coordinate values, use
c                          call epl2wd(aTrack.cn, aTrack.w, ww)     
c                    where
c                   record /epDirec/ ww is the output  values in world coord.
c
c     aTrack.t                    : time in sum of (cm/beta) 
c     aTrack.wgt                  : weight of the particle when thinning is
c                                   done (normall 1.0)
c     aTrack.cn                   : component number
c
c     Move.Track      :   Info of moved track.
c     Move.boundary   :   Component boundary position when the particle crosses
c                         the boundary. (Move.Cross =T)
c                         Move.boundary.x, y, z. in cm. 
c     Move.proc       :   If the particle is going to interact, the process
c                            name is set. proc= one of
c                        'brem': bremstralhng
c                        'knoc': knock on (bhabha or moller scattering)
c                                other heavy particle knock-on
c                        'anih': positron anihilation
c                        'pair' : pair creation
c                        'comp' : compton scattering
c                        'phot' : photo electric effect
c                        'photop': photo-hadron production
c                        'coll'  : hadron's nuclear interaction
c                        'decay' : decay 
c                        '    '  : no interaction yet.
c    Move.dl          :  Path length in cm
c    Move.dE          :  Energy loss during dl. in GeV
c    Move.dEeff       :  Effective energy loss (use this for counting) GeV
c    Move.dEion       :  Energy loss due to ionization loss (GeV)
c    Move.dx          :  path length in g/cm^2
c    Move.dt          :  path length in r.l
c    Move.Cross       :  Becomes T if the ptcl crosses the boundary.
c    Move.Trunc       :  Becomes T if the ptcl track is truncated.
c    Move.Abort       :  must be set by the user.
c    
c    If you want to use a particle code, like,
c        if(aTrack.p.code .eq.  kphoton) ...
c    You have to uncomment Zcode.h above; they are the same as
c    Cosmos. Some of popular ones are:
c         kphoton:  photon             kelec  :  electron
c         kmuon  :  muon               kpion  :  pion
c         kkaon  :  kaon               knuc   :  nucleon
c         kneue  :  electron neutrino  kneumu :  muon neutrino
c         kalfa  :  He                 klibe  :  LiBeB group
c         kcno   :  CNO   group        khvy   :  Na/Mg/Si group
c         kvhvy  :  S/Cl/Ar group      kiron  :  Fe group
c         kdmes  :  D  meson           keta   :  eta  meson
c    Subcode may sometimes be needed:
c         regptcl:  particle           antip  : anti-particle
c         k0s    :  k0short            k0l    : k0 long
c 
        end
c       ************************************************
c       *  This is called when a particle passes the boundary
c       *  of a component for which you have specifed to
c       *  count particle nubmer.
c
        subroutine userbd(info, aTrack, Move, media) 
        implicit none
#include "ZepTrack.h"
#include "Zmove.h"
#include "Zmedia.h"

c          next is needed if you want to judge particle code.
c  #include "Zcode.h"     

        integer info              ! 0--> ptcl is exiting to void
                                  ! <0 --> ptcl is exiting to |info| comp.
                                  ! >0 --> ptcl is entering from info comp.
        record /epTrack/aTrack    ! input. Current track before it is moved.
                                  !  If info <=0, the track position is 
                                  !  somewhere inside the component from which
                                  !  the track is existing.
                                  !  If info >0, aTrack.pos is the position 
                                  !  just before exiting the prvious component
        record /epmove/ Move        ! input/output. 
                                  ! Move.Track is the track
                                  ! infomation of the current particle
                                  ! moved to a new position.
                                  ! Say, Move.Track.cn is the  current
                                  ! comp. number.  For other details,
                                  ! see userde.
c
c                      comp.1    comp.2
c          info<0    |  *-----x|          |        
c                                                   * is aTrack.pos
c                                                   x is Move.Track.pos
c          info>0    |        *|x         |       
c  
        record /epmedia/media       ! input.
c///////////
c        write(*,*) ' info=',info, ' cn=', aTrack.cn,
c     *        ' media=',media.name
c////////////
        Move.Abort = 0
        end
c       **************************************************
c       *  This is called when all the system level "end process"
c       *  for the event has been ended.  Do your own end process
c       *  for the event.
c       *
        subroutine ue1ev
        implicit none

        include 'Ztest2.h'
        
        integer i
        integer s1, s2, s3, a1, a2, a3, a4
c              with antil
        parameter( s1 = 11, s2 = 105, s3= 171,
     *             a1 = 14, a2 = 16, a3 = 18, a4 = 20)
c             no anti
c        parameter( s1 = 11, s2 = 101, s3= 163)

c        write(*,*)  
        do i = 1, Ncomp
           if(Eloss(i) .gt. 0.) then
              if(i .eq. s1 .or. i .eq. s2 .or. i .eq. s3 ) then
c                       trigger horizontal 
c                 write(*, *)  i, sngl(Eloss(i)/0.00165)
                  Eloss(i) = Eloss(i)/0.00165d0
              elseif(i .eq. a1 .or. i .eq. a2 .or. i .eq. a3 .or.
     *               i .eq. a4) then
c                       trigger vertical
c                 write(*, *)  i, sngl(Eloss(i)/0.00258)
                  Eloss(i) = Eloss(i)/0.00258d0
              else
c                       scifi
c                 write(*, *)  i, sngl(Eloss(i)/0.000145)
                  Eloss(i) = Eloss(i)/0.000145d0
              endif
           endif
        enddo
c        if(Eloss(1) .ne. 0. .or.  Eloss(3) .ne. 0.
c     *     .or.  Eloss(5) .ne. 0. .or. Eloss(7).ne.0.
c     *     .or.  Eloss(9) .ne. 0. .or. Eloss(10).ne.0.
c     *     .or.  Eloss(165) .ne. 0. .or. in .ne. 0 .or.
c     *      ot .ne. 0) then
        if(Eloss(s3) .gt. 1.0) then
           write(*, '( 7f8.2, f8.2, f9.5, 4i3 )')
     *         sngl(Eloss(s1)), sngl(Eloss(s2)),
     *         sngl(Eloss(s3)), sngl(Eloss(a1)),
     *         sngl(Eloss(a2)), sngl(Eloss(a3)),
     *         sngl(Eloss(a4)), sngl(ke), sngl(w3),
     *         code, chg, in, ot
        endif
        end
c       *************************************************
c       *  This is called when all the system level "end process"
c       * for all the events has been  ended. Do your own end
c       * process for the events

      subroutine ueaev
      implicit none
      call cerrorMsg('all events finished', 1)
      end


