#include "ZsubstRec.h"
c        epifCross is changed radically.
c        epbndry; icon is changed to get el in real*8
c        *********************************************************
c        *
c        *  epgen:generate  showers until stack area becomes empty
c        *
c        *********************************************************
c
      subroutine epgen
      implicit none
#include  "ZepTrackv.h"
#include  "Zcnfig.h"
      integer icon

c         init. for 1 event has been finished, next is
c       to put other final init. for 1 event
      call epr1ev
c         *** until loop*** 
      icon =0
      do while (icon .eq. 0)
c                get 1 particle from stack area 
         call eppop(cTrack, icon)
c                icon=0: 1 ptcl gotten in cTrack
c                       -1: no more ptcl  in the stack
         if(icon .eq. 0) then
            call epfl1
         endif
      enddo
      end
      subroutine epicosmos(param)
      implicit none
c          read parameter file for Cosmos.
#include  "Zmanagerp.h"
      integer  icon
      character*(*) param       ! input. Cosmos param file path.
      call copenNLf(TempDev, param, icon)
      if(icon .ne. 0) then
         call cerrorMsg('epicosmos cannot open parameter file',0)
      endif
      call creadParam(TempDev)
      close(TempDev)
      end
      
      subroutine epiaev(dsn1, dsn2)
      implicit none
c             init for all event; read epics data and cofig data
#include  "ZepManager.h"
#include  "ZepTrackv.h"
#include  "ZepTrackp.h"
#include  "ZepStack.h"
#include  "Zcnfig.h"


      character*(*) dsn1        ! input epics data file path
      character*(*) dsn2        ! input config data file path

      integer klena
      character*8 uid

c
c                 open basic data residence file for epics
c              component # is undefined yet
      Cn=-1
      Stack_pos = 0
      StackDisk = 0
      Nevrun=0
c                read basic parameter
      call epprmr(dsn1)
c                compute something using basic parameters
      call epcmp1

c                read configuration

c     
       call eprcnf(dsn2)

c      *********************
c               init for nuclin, hadrin
cc       call haddenC
cc       call chanwnC
         call cintModels('epics')  

c       ################
c                user dependent init
       call uiaev
       if(MagField .eq. 1)then
          Bfield.x = Bxu
          Bfield.y = Byu
          Bfield.z = Bzu
       endif
       if(ElecField.eq. 1) then
          Efield.x = Exu
          Efield.y = Eyu
          Efield.z = Ezu
       endif
c
c          fix tracedir 
       if(Trace) then
          if(TraceDir .eq. ' ') then
             call cgetLoginN(uid) ! cosmos function
             TraceDir ='/tmp/' // uid(1:klena(uid))
          endif
       endif
       end
       subroutine  epi1ev(icon)
c             init for 1 event
       implicit  none
#include "ZepManager.h"
#include "ZepTrackp.h"
#include "ZepTrackv.h"
       integer icon ! output. if  0,  user has set ptcl in stack
                   !             1,  no ptcl has set in stack
      character*200 msg
      character*128 filen
      character*8 uid
      integer jcon, leng
      integer  klena

       Bndryerr = 0   ! counter for bundary search failures/ event
       Cn=-1
       Firsti=.true.
       FirstC=.true.
       Proc1 = '   '   ! first collision process.
       FirstInt.x = -100000
       FirstInt.y = -100000
       FirstInt.z = -100000
       pathInB=0.
       SumDe = 0.
       Move.Abort = 0     !  if this become non zero for an event, 
                     !  the particle is discarded or event is discarded
c                 user dependent init
       call ui1ev


c               next call sets to icon=1,    if usetip is not
c               user made.
       call usetip(icon)



c                 icon=0-->user routine already set prtcl
c                 icon=1-->no user routine for incident
       if(Trace) then
          write(filen, *) TraceDir(1:klena(TraceDir))//'/trace',
     *         Nevrun + 1
          call kseblk(filen, ' ', leng)
          call copenfw(abs(IoTrace), filen,  jcon)
          if(jcon .ne. 0) then
             call cerrorMsg('**************** Fatal error ', 1)
             call cerrorMsg(
     *       'You gave Trace=t in epicsfile, but the file ', 1)
             call cerrorMsg(filen, 1)
             write(msg, '(a,a,a)')
     *       ' cannot be opened: Probably you have to make', 
     *         uid, ' directory. Or if no need trace info, make'//
     *       ' Trace f in epicsfile ' 
              call cerrorMsg(msg, 0)
          endif
       endif

       end
c      *******************
       subroutine  epe1ev
c      ******************* end of 1 event
       implicit none
#include "ZepManager.h"
#include  "ZepTrackp.h"
#include "ZepTrackv.h"

       Nevrun = Nevrun + 1
c               user dependent end process
       if(Move.Abort .le. 1) call ue1ev
       if(Trace) then
          close(abs(IoTrace))
       endif
       end
c      *************  now 1 event is ready to start
       subroutine epr1ev
       implicit none
#include "ZepTrackv.h"

       integer icon

c          the procedures to be performed after the completion of
c          init. for 1 event must be placed here
c          save first stacked track as  incident
        call epgetTrack(1, Incident, icon)
c        if(icon .ne. 0) then
c           call cerrorMsg('no incident found in epr1ev', 0)
c        endif
c
        call uafi1ev            ! after init of 1 event
        end
c      ****************************
c                user dependent all event end
       subroutine epeaev
       implicit none

       call ueaev
       end
c      ****************************
      subroutine epqstn(n)
      implicit none
#include  "ZepTrack.h"
#include  "ZepStack.h"

       integer n
c               inquire current stack #
       n = Stack_pos
       end
c      *************************
       subroutine epqstt(n, aTrack)
       implicit none
#include  "ZepTrack.h"
#include  "ZepStack.h"
c        inquire a stacked particle in the n-th stack position
       integer  n  !  input. stackposition
       record /epTrack/  aTrack  !  output.  stacked track info.
                                 !  if n is invalid, aTrack.p.fm.p(4)=0

       if(n .ge. 1 .and. n .le. Stack_pos) then
          aTrack =  Stack(n)
       else
          aTrack.p.fm.p(4) = 0. 
       endif
       end
c      ***********************
       subroutine epqevn(nev)
      implicit none
#include  "ZepManager.h"
c            inquire  current event number created in this run
       integer nev
       nev = Nevrun
       end

       subroutine epfl1
       implicit none
c           follow 1 particle
c              until current partile dies or all are put into stack.
#include  "ZepTrackp.h"
#include  "ZepTrackv.h"
#include  "Zcnfig.h"
#include  "ZepManager.h"

      integer icon, info


      do while (.true.)
c                current track is in  cTrack
c          fix process and free path
c          and compute tentative new pos.--> Move

         call epnewp(icon)
         if(icon .ne. 0) goto 100 ! abort is specified by the user
c          energy loss count in user hook
         if(Det.cmp(Cn).CountDE .gt. 0 .and.
     *           cTrack.p.charge .ne. 0) then
            if( Move.Track.p.fm.p(4)-Move.Track.p.mass
     *                                     .le. KEmin ) then 
               info = 1
            else
               info = 0
            endif
            call userde(info, cTrack, Move, Media(MediaNo))
         endif
c          add  time  
         if(TimeStruc) then
            call epaddTime
         endif

c          energy check
         call epchckE(Move.Track, icon)



         if(icon .eq. 0 ) then
c           adjust momentum; because of  energy change
            if(cTrack.p.charge .ne. 0) then
               call epe2p(Move.Track.p)
            endif

c            if(.not. Move.Cross .and. cTrack.p.charge .ne. 0) then
c               we don't use above judgement; later at epCross, we use new
c               angle due to scattering at Move.boundary. (don't use
c               new  position due to scattering in epCross)
c           ++++++++++
            if(cTrack.p.charge .ne. 0) then
c                 multiple scattering, magnetic deflection
c                 electric deflection
               call epdeflection(icon)

            endif
c              take trace info.
            if(Trace) then
               if(IoTrace .lt. 0 .or. (IoTrace .gt. 0 
     *           .and. cTrack.p.charge .ne. 0)) then
                  call epTrace
               endif
            endif
c              really move
#ifdef  SUBSTREC
            cTrack = Move.Track
#else
            call epsubstTRK( cTrack, Move.Track)
#endif
            if(.not. Move.Trunc) then
                call epint(icon)       ! interaction routine
c                       icon =  1 always.
            elseif(Move.Cross) then
               call epCross(icon)
            endif
         else
c              take trace info. of dead particle.
            if(Trace) then
               if(IoTrace .lt. 0 .or. (IoTrace .gt. 0 
     *           .and. cTrack.p.charge .ne. 0)) then
                  call epTrace
               endif
            endif

         endif
         if         (icon .ne. 0)
     *                       goto 100
      enddo
 100  continue
      end
c     *****************
      subroutine epnewp(icon)
c     *****************
      implicit none
c      1)  sample the process and fix the path
c      2)  see if the  path is too long,
c            if so truncate the path
c      3)  see if the path crosses the boundary of the current
c            volume.  
c            if it crosses, truncate the path, set flag for
c            cross
c      4)  copmpute energy loss, and get new energy
c            if the energy becomes <=  mass, truncate path

c      5)  set new tentatvie position in Move.Track.pos
c
#include  "ZepTrackv.h"
#include  "ZepTrackp.h"
#include  "Zcode.h"

      integer icon


c     
c    *********************** sample interaction length ****************

c        copy current track  to Move
#ifdef  SUBSTREC
      Move.Track = cTrack
#else
      call epsubstTRK( Move.Track, cTrack)
#endif
c       do for each ptcl
      if(cTrack.p.code .eq. kphoton) then
         call epprog  ! Move.proc, Move.dt fixed
      elseif(cTrack.p.code .eq. kelec) then
         call epproe  ! Move.proc, Move.dt fixed
      else
         call epNonEleMag
      endif
      
      if(Firsti) then
         Firsti=.false.
         if(.not. FreeC) then
            Move.dt=0.
            Move.dl=0.
            Move.dx=0.
         endif
      endif
c     *************** truncate if too long  **********************
c              trancate if dt is too long (set Trunc=t/f)
      call eptrunc


c        move track tentatively
c              local. coord..
      Move.Track.pos.x = cTrack.pos.x + Move.dl * cTrack.w.x
      Move.Track.pos.y = cTrack.pos.y + Move.dl * cTrack.w.y
      Move.Track.pos.z = cTrack.pos.z + Move.dl * cTrack.w.z

c     *************** see if Move.Track crosses the boundary ******
c              set Cross=t/f, if t, adjust path and set Trunc=t
      call epifCross(icon)
                                                                           
      if(icon .eq. 2) return  !  ptcl went void by delicate boundary.
      icon = 0
cc      if(icon .eq. 0) then
c     
c     ************** energy loss consideration ******************
c        if E becomes <= m,  adjust path and set Trunc=t,
c        and reset Cross.

         if(cTrack.p.charge .ne. 0 .and. Move.dl .gt. 0.) then
            call epEloss
         else
            Move.dE = 0.
         endif
cc      endif
      end
c     *******************************
      subroutine epCross(icon)
      implicit none
c          manager when a particle crosses the boudarynon
#include "ZepTrackv.h"
#include "ZepTrackp.h"
#include "Zcnfig.h"
      integer icon ! input/ouptut  1--> discard this particle
c                                 other values are not given here
      integer cnx, info
      record /epPos/postemp
      record /epDirec/ dirtemp

      record /epTrack/ aTrack
      integer n

c
c      save the cTrack
      aTrack = cTrack
c       cross the boundary;  use  new angle at the boundary.
c      (not cTrack.w.x etc)
      cTrack.pos.x = Move.boundary.x +
     *     EpsLeng* Move.Track.w.x  
c          if EpsLeng and w.x are both small, and x is large
c          no move may happen, avoid such case.
c               You may give larger EpsLeng in input data.
c
      if( cTrack.w.x .ne. 0. ) then
         n = 2
         do while( cTrack.pos.x .eq. Move.boundary.x .and.
     *             n .lt. 10 ) 
            cTrack.pos.x = Move.boundary.x +
     *           n*EpsLeng* Move.Track.w.x
            n = n * 2
         enddo
      endif

      cTrack.pos.y = Move.boundary.y +
     *     EpsLeng* Move.Track.w.y
      if( cTrack.w.y .ne. 0.) then
         n = 2
         do while( cTrack.pos.y .eq. Move.boundary.y
     *             .and. n .lt. 10 ) 
            cTrack.pos.y = Move.boundary.y +
     *           n*EpsLeng*  Move.Track.w.y
            n = n * 2
         enddo
      endif

      cTrack.pos.z = Move.boundary.z +
     *     EpsLeng* Move.Track.w.z
      if(cTrack.w.z .ne. 0. ) then
         n = 2
         do while( cTrack.pos.z .eq. Move.boundary.z  .and.
     *          n .lt. 10 )
            cTrack.pos.z = Move.boundary.z +
     *           n*EpsLeng* Move.Track.w.z
            n = n * 2
         enddo
      endif

#ifdef  SUBSTREC
      cTrack.w = Move.Track.w
#else
      call epsubvec(Move.Track.w, cTrack.w)
#endif

c         new comp. number;  new position would be, in principle,
c         in a new component. but scattering at the boundary may
c         cause the new pos to be in the same component.
      call eppos2cn(Cn, cTrack, cnx)
      if(Cn .eq. cnx) then
         Move.Cross = .false.
      elseif(cnx .gt. Det.nct) then
         info = 0   ! exiting to void
      else
         info = -cnx   ! exiting to cnx
      endif
      cTrack.cn = cnx
      if(Det.cmp(Cn).CountIO .ge. 2 .and. Move.Cross) then
c          user hook for  counting exiting ptcls 
c                    exiting from Cn to cnx
         call userbd(info, aTrack, Move, Media(MediaNo))
         if(Move.Abort .ne. 0) then
            if(Move.Abort .eq. 3) then
               icon = 1         ! discard this particle
               Move.Abort = 0   ! but continue simulation
            else
               call  epempty    ! empty the sack. discard ev.
            endif
         endif
      endif
c ///////////
c      call debugpos('epCross; eppos2cn', Cn, cTrack.pos, cnx)
c////////////////

      if(cnx .gt. Det.nct) then
c          void
         icon = 1
      elseif(Move.Cross) then
         info = Cn            ! save the current cn
c         update coord. to local one in new  comp.
         call epl2w(Cn, cTrack.pos, postemp)
         call epw2l(cnx, postemp,  cTrack.pos)
         call epl2wd(Cn, cTrack.w,  dirtemp)
ccc         call epw2ld(cnx, dirtemp, cTrack.w)
         call epw2ldm(cnx, dirtemp, cTrack.w, cTrack.p)
         
c            update comp. info (Cn, MediaNo etc are updated)
         call epnewComp  
#ifdef  SUBSTREC
         aTrack = Move.Track
#else
         call epsubstTRK(aTrack, Move.Track)
#endif
#ifdef SUBSTREC         
         Move.Track = cTrack      ! copy the track which is  now in new comp.
#else
         call epsubstTRK(Move.Track, cTrack)
#endif

         if(Det.cmp(Cn).CountIO .eq. 1 .or.
     *      Det.cmp(Cn).CountIO .eq. 3 ) then
c             count entering ptcls;  from info to Move.Track.cn (=Cn)
            call userbd(info, aTrack, Move, Media(MediaNo)) 
            if(Move.Abort .ne. 0) then
               if(Move.Abort .eq. 3) then
                  icon = 1      ! discard this particle
                  Move.Abort = 0 ! but continue simulation
               else
                  call  epempty ! empty the sack. discard ev.
               endif
            endif
         endif
      endif                  
      end
c         for ibm
      subroutine epsubvec(inp,out)
      implicit none
#include "Zep3Vec.h"
      record /ep3Vec/  inp,out
      out = inp
      end
      subroutine epsubstTRK(left, right)
      implicit none
#include "ZepTrack.h"
      record /epTrack/left, right
      left = right
      end

c     **********************
      subroutine epNonEleMag
      implicit none
#include "ZepTrackp.h"
#include "ZepTrackv.h"
#include "Zcode.h"


c          sample interaction length for non-e/g
      real*8 prob, path, tokgpm2

c          set cosmos condition(TrackBefMove, TargetMassN)
      tokgpm2 = Media(MediaNo).X0g *10.d0 ! r.l --> kg/m^2
c                 target mass and Z; not used from v7.0
c         but projectile is set. 
c      call ep2cosCond(Media(MediaNo).Aeff, Media(MediaNo).Zeff)
      call ep2cosCond
      call cfixModel( cTrack.p )
      call ciniSmpIntL
c        call csampNEPIntL  before v7.0
      call epsmpNEPIntL(Media(MediaNo))
c         reset muon interaction conditions
      call ep2cosCondr
c
      if(cTrack.p.charge .ne. 0 .and. Knckon) then
c                add knock on 
         call epKnockp(Media(MediaNo), cTrack.p, prob, path)
         path = path * tokgpm2
         call csetIntInf(path, .false., 'knoc') ! cosmos
      endif
      if(cTrack.p.code .eq. kmuon) then
c            add muon pair, brems, n.i if requested.
c            this func for cosmos has been disabled  so that
c            treate it here.
         if( Media(MediaNo).mu.MuPr .ge. 2 .and. 
     *       cTrack.p.fm.p(4) .gt.  Media(MediaNo).cnst.muPrEmin ) then
            call epmuPrsmpP(Media(MediaNo),
     *                      cTrack.p.fm.p(4), prob, path)
c               path is in r.l. convert  it to kg/m2
            path = path * tokgpm2 
            call csetIntInf(path, .false., 'pair')
         endif
         if(Media(MediaNo).mu.MuBr  .ge. 2 .and.
     *       cTrack.p.fm.p(4) .gt.  Media(MediaNo).cnst.muBrEmin ) then
            call epmuBrsmpP(Media(MediaNo), 
     *                      cTrack.p.fm.p(4), prob, path)
c               path is in r.l. convert  it to kg/m2
            path = path*tokgpm2
            call csetIntInf(path, .false., 'brem')
         endif
         if( Media(MediaNo).mu.MuNI  .ge. 2 .and.
     *       cTrack.p.fm.p(4) .gt.  Media(MediaNo).cnst.muNEmin ) then
            call epmuNsmpP( Media(MediaNo),
     *           cTrack.p.fm.p(4), prob, path)
c               path is in r.l. convert  it to kg/m2
            path = path*tokgpm2
            call csetIntInf(path, .false., 'nuci')
         endif
      endif

      call epfixProc(Media(MediaNo).rho, Move.dx, Move.proc)
      Move.dt = Move.dx/Media(MediaNo).X0g ! in r.l
      Move.dl = Move.dx * Media(MediaNo).gtocm ! in cm
      end
c     ******************
      subroutine epEloss
      implicit none
#include "ZepTrackp.h"
#include "ZepTrackv.h"
#include "Zcnfig.h"
#include "Zcode.h"
               
      integer k
      
      real*8 dedx, dedl, dx, up, dedxmu, dedlmu,
     *      s1, s2, scol2, schg2, sigma
      real*8 cupsilon, csyncTELoss, cf
      logical lowehvyion

      k = cTrack.p.code
c              compute energy loss rate
      if(EdepdEdx) then
         if(cTrack.p.fm.p(4) .le. cTrack.p.mass) then
            dedx = 0.
            Move.dE = 0.
            Move.dEeff = 0.
            Move.dEioni = 0.
         else
            if(k .eq. kelec) then
c                            dedx is in GeV/(g/cm^2)
               call epdedxe(Media(MediaNo).sh, cTrack.p, dedx)
               dedxmu = 0.
               lowehvyion = .false.
            else
c                      heavy ion and ke/n is < 0.7 GeV
               lowehvyion = abs( cTrack.p.charge ) .gt. 1 .and.
     *            (cTrack.p.fm.p(4)-cTrack.p.mass) .lt.
     *             cTrack.p.subcode*0.7
               if(lowehvyion) then
                  call epdedxhvy(Media(MediaNo).sh, cTrack.p, dedx)
               else
                  call epdedxNone(Media(MediaNo).sh, cTrack.p, dedx)
               endif

               if(cTrack.p.code .eq. kmuon) then
                  call epmudEdx(Media(MediaNo).mu.MuNI, 
     *                 Media(MediaNo).mu.MuBr, 
     *                 Media(MediaNo).mu.MuPr, 
     *                 Media(MediaNo),
     *                 cTrack.p.fm.p(4), dedxmu)
               else
                  dedxmu = 0.
               endif
            endif

            if(Media(MediaNo).BirksC1 .gt. 0.) then
               if( abs(cTrack.p.charge) .gt. 1) then
c                   quenching effect
                  call epOrgCorrec(Media(MediaNo), cTrack.p, dedx, cf)
               else
                  cf = 1.
               endif
            else
               cf = 1.
            endif

            dedl = dedx /Media(MediaNo).gtocm  ! GeV/cm
            dedlmu = dedxmu /Media(MediaNo).gtocm  ! GeV/cm

            if( abs( Det.cmp(Cn).CountDE) .eq. 2) then
c                Enery loss fluctuation; use  Urban model for singl charge
c                 or  high energy
               if( lowehvyion ) then
                  call epdedxflhv(Media(MediaNo), cTrack.p,
     *                scol2, schg2)
                  sigma = sqrt( (scol2 + schg2)* Move.dx )
                  call kgauss(0.d0, sigma, s1, s2)
                  Move.dEioni = max(dedx*Move.dx + s1, 0.d0)
               else   
                  call epUrban(Media(MediaNo).urb, dedl, Move.dl,
     *                 cTrack.p,  Move.dEioni)
               endif
c                    Move.dEioni = GeV  in 'dl' cm
            else
               Move.dEioni = dedl * Move.dl
            endif
            Move.dE = Move.dEioni + dedlmu*Move.dl  ! total loss
            Move.dEeff = Move.dEioni * cf + dedlmu*Move.dl  ! effective loss
         endif
      else
c            use constant energy loss at minimum ionization
c            In this case, knock-on process should be prohibitted  by
c            giving large Tcut.   Birks correction not applied.
         dedx = Media(MediaNo).dEdxatp3m * cTrack.p.charge**2  ! GeV/(g/cm2)
         Move.dE = dedx * Move.dx
         Move.dEioni = Move.dE
         Move.dEeff = Move.dEioni
         SumDe = SumDe + Move.dE 
      endif
c    ****************** synchrotron loss; only in 'sp' and for electrons
c        This is normally completely negligible
      if(Sync .eq. 1) then
         if(Media(MediaNo).name .eq. 'sp' ) then
            if(MagField .gt. 0 .and. k .eq. kelec) then
               up = cupsilon(cTrack.p, Bfield) ! Upsilon value
               dedl = csyncTELoss(up) * 10.d-2
                               !  GeV/cm: dedl by cosmos is GeV/m
               Move.dE = Move.dE + dedl*Move.dl
            endif
         endif
      endif
c
c  
      Move.Track.p.fm.p(4) = cTrack.p.fm.p(4) - Move.dE
      if(Move.Track.p.fm.p(4) .le. Move.Track.p.mass) then
c          this will not happen if muon specific loss exists.
         Move.dE = max(cTrack.p.fm.p(4)- cTrack.p.mass, 0.d0)

         if(dedx .le. 0. .or. Move.dE .eq. 0.) then
            dx = 0.
            Move.Cross = .false.
            Move.Trunc = .false.
            Move.dE = 0.
            Move.dEeff = 0.
            Move.dEioni = 0.
         else
            dedx = Move.dE/(Move.dl/Media(MediaNo).gtocm)
            dx = max(Move.dE/dedx*0.99999d0, 0.d0)
            Move.Trunc=.true.
            Move.Cross = .false.   
            Move.dEeff = Move.dE*cf
            Move.dEioni = Move.dE
         endif

         Move.Track.p.fm.p(4) = Move.Track.p.mass
         Move.dl = dx * Media(MediaNo).gtocm
         Move.Track.pos.x = cTrack.pos.x + Move.dl* cTrack.w.x 
         Move.Track.pos.y = cTrack.pos.y + Move.dl* cTrack.w.y
         Move.Track.pos.z = cTrack.pos.z + Move.dl* cTrack.w.z

      endif

      SumDe = SumDe + Move.dE
      end

c     ******************
      subroutine epTrace
c     ******************
c         take trace of paritcles
       implicit none
#include  "ZepTrackp.h"
#include  "ZepTrackv.h"
#include  "Zcode.h"
#include  "ZepManager.h"
#if defined NEXT486
#define IMAG_P dimag
#elif defined PCLinux
#define IMAG_P dimag
#else
#define IMAG_P imag
#endif
      

c          standard Trace information
      record /epPos/ posbw, posw
      real*8 xxx/-1.d37/, yyy/-1.d36/, zzz/1.d34/ 
      integer kkk/-1000/, chkchg/-1000/
      real*8 erg
      integer k
      save xxx, yyy, zzz, kkk, chkchg

c
c          Trace informaion  ccc if for putting only electorns
c
c             convert to world coord. starting point of the segment

      erg= Move.Track.p.fm.p(4)-Move.Track.p.mass
      if( TraceErg(1) .le. erg .and.  erg .le. TraceErg(2) ) goto 100
      if( TraceErg(3) .le. erg .and.  erg .le. TraceErg(4) ) goto 100
      if( TraceErg(5) .le. erg .and.  erg .le. TraceErg(6) ) goto 100
      return  !  ***************
 100  continue
      call epl2w(Cn, cTrack.pos, posbw)
      
      k = cTrack.p.code
ccc      if(k .eq. kelec) then
         if(kkk .ne. k .or. xxx .ne. posbw.x .or. 
     *                      yyy .ne. posbw.y .or.
     *                      zzz .ne. posbw.z .or. 
     *                   chkchg .ne. cTrack.p.charge ) then
            if(xxx .ne. -1.d37) then
               write(abs(IoTrace), *)
               write(abs(IoTrace), *)
            endif
            if(TimeStruc) then
               write(abs(IoTrace),
     *          '(3g16.8, i4, g11.4, i4, g16.8)')
     *            posbw.x, posbw.y, posbw.z, k,
     *            erg,
     *            cTrack.p.charge,
     *            cTrack.t
            else
               write(abs(IoTrace),'(3g16.8,i4,g11.4, i4)')
     *            posbw.x, posbw.y, posbw.z, k,
     *            erg,               
     *            cTrack.p.charge
            endif
         endif
c            end point of  the segment
         call epl2w(Cn, Move.Track.pos, posw)
         if(TimeStruc) then
            write(abs(IoTrace),'(3g16.8,i4,g11.4, i4, 
     *         g16.8)')
     *           posw.x, posw.y, posw.z, k,
     *           erg,
     *           Move.Track.p.charge,
     *           Move.Track.t
         else
            write(abs(IoTrace),'(3g16.8,i4,g11.4, i4)')
     *           posw.x, posw.y, posw.z, k,
     *           erg, 
     *           Move.Track.p.charge
         endif
         xxx = posw.x
         yyy = posw.y
         zzz = posw.z
         kkk = k
         chkchg = Move.Track.p.charge
ccc      endif
       end
c      ****************************************
       subroutine epprog
       implicit none
c
c     5     processes, i.e, pair creation, compton, Photo-electric
c     effect, coherent scatt.
c      and Photo-production of pions are considered.
c
#include  "ZepTrackv.h"
#include  "ZepTrackp.h"

c
      real*8 tcomp, tphot, tpair, tgp, tcoh,  t
      real*8 E, prob, xprob(5), txray(5)
      real*8 xs
      real*8  pairmfp, dl, dx, tmpair, u
      real*4  xsec(5)  !  coh, incoh,  P.E  1/(g/cm2)
c      real*8  Excom1, Excom2  !now in ZepTrackp.h
      integer icon
c            where xcom data is used. 
c       Excom1: compton/photo abs/coherent scat
c       Excom2: pair; default is  not use xcom
c              both must be < 100 GeV
c      data Excom1/1.d-3/, Excom2/1.d-3/
c      save Excom1, Excom2

      E = cTrack.p.fm.p(4)
      if(E .le. EupperBndCS) then
         xprob(3)= 0.
         if( Media(MediaNo).xcom.size .gt. 0 .and.
     *        E .lt. Excom1 ) then
c               below 1MeV, use accurate xs.
            call epXrayp(Media(MediaNo), E,  3,  xprob, txray)
            tcomp=txray(2)
            tcoh = txray(1)
            tphot = txray(3)
         else
            tcoh = 1.e35
            call epcompp(Media(MediaNo), E, prob, tcomp)
         endif
         if(Photo) then
            if(xprob(3)  .eq. 0.) then
               call epphotoEp(Media(MediaNo),  E, prob, tphot) ! v8.0
            endif
         else
            tphot = 1.e35
         endif
      else
         tcomp =1.e35
         tphot= 1.e35
         tcoh = 1.e35
      endif
      if(E .gt. ElowerBndPair) then
         if( Media(MediaNo).xcom.size .gt. 0 .and.
     *        E .lt. Excom2 ) then
            call epXrayp(Media(MediaNo), E,  5,  xprob, txray)
            prob= xprob(4)+xprob(5)
            call rndc(u)
            tpair = -log(u)/prob
         else
            call epPrSampP(Media(MediaNo), E, prob, tpair)
         endif
      else
         tpair=1.e35
      endif
      if(IncGp .eq. 1 .and. E .gt. 150.d-3) then
         call ep2cosCond
         call cfixModel( cTrack.p )
         call cgpXsec(Media(MediaNo).A,  E, xs)    ! xs in mb
         prob = xs*Media(MediaNo).mbtoPX0   ! prob/r.l
         call rndc(u)
         tgp = -log(u)/prob          ! sampled path in r.l
      else
         tgp=1.e35
      endif

      if(MagPair .eq. 1) then
         call epmpairp(cTrack.p, Bfield, Xai, pairmfp, dl)
         dx = dl / Media(MediaNo).gtocm
         tmpair = dx / Media(MediaNo).X0g
      else
         tmpair = 1.e35
      endif
      t=min(tpair, tcomp, tphot, tgp, tmpair, tcoh)
      if(t .eq. tpair) then
         Move.proc='pair'
      elseif(t .eq. tcomp) then
         Move.proc='comp'
      elseif(t .eq. tphot) then
         Move.proc='phot'
      elseif(t .eq. tcoh) then
         Move.proc='coh'
      elseif(t .eq. tgp) then
         Move.proc='photop'
      else
         Move.proc='mpair'
      endif
      Move.dt = t   ! in r.l
      Move.dx = Move.dt * Media(MediaNo).X0g
      Move.dl = Move.dx * Media(MediaNo).gtocm
      end
c     *************
      subroutine  epproe
c     *************
      implicit none
c
c   electron:     brems, knock-on, and anihilation, synchrotron
c                 radiation are considered
c
#include  "ZepTrackv.h"
#include  "ZepTrackp.h"
c
      real*8 E, prob,  tbrem, tknock, tanihi, t, dt, dl, dx, syncmfp

       
      E = cTrack.p.fm.p(4)
c             sample path for brems
      call epBrSampP(Media(MediaNo),  E, prob, tbrem)

      if(Knckon) then
         if(cTrack.p.charge .eq. -1) then
            call epmollerp(Media(MediaNo), E, RecoilKEmin, prob, tknock)
         else
            call epbhabhap(Media(MediaNo), E, RecoilKEmin, prob, tknock)
         endif
         if(tbrem .le. tknock) then
            t = tbrem
            Move.proc='brem'
         else
            t = tknock
            Move.proc='knoc'
         endif
      else
         t = tbrem
         Move.proc='brem'
      endif
      if(cTrack.p.charge .eq. 1 .and. E .lt. Eanihi) then
         call epanihip(Media(MediaNo), E, prob, tanihi)
         if(tanihi .lt. t) then
            t = tanihi
            Move.proc='anih'
         endif
      endif
      Move.dt = t
      Move.dx = Move.dt * Media(MediaNo).X0g
      Move.dl = Move.dx * Media(MediaNo).gtocm

c                     only if X0 > 10 km; may be 30 km is o.k
      if(Sync .eq.  2 .and. Media(MediaNo).X0 .gt. 10.d5 ) then
c          sample synchrotron emission path
         call epsyncp(cTrack.p, Bfield, Upsilon, syncmfp, dl)
         dx = dl / Media(MediaNo).gtocm
         dt = dx / Media(MediaNo).X0g
         if(dt .lt.  t) then
            Move.dt = dt
            Move.dx = dx
            Move.dl = dl
            Move.proc = 'sync'
         endif
c      else
      endif
      end
c     ******************
      subroutine eptrunc
      implicit none
c          truncate path if it is too long.  
c          Move.dt,dx,dl is adjusted if truncated, and Trunc is set to T.
c
#include  "ZepTrackv.h"
#include  "ZepTrackp.h"

c           max length movable
      real*8 tmax, r

      if(cTrack.p.charge .eq. 0) then
c           neutral particle can move any length basically
         Move.Trunc = .false.
c      elseif(Move.proc .eq. 'no') then
c         Move.Trunc=.false.
c         if(MagField .gt. 0 .or.  ElecField .gt. 0) then
c            Move.dt = min( max( Tcoefx*cTrack.p.fm.p(4), Tminx), 
c     *           Move.dt, MaxPath )
c         endif
      else

         tmax = min(
     *     max( Tcoefx*(cTrack.p.fm.p(4)-cTrack.p.mass), Tminx), 
     *     MaxPath )



         if(Move.dt .lt. tmax) then
            Move.Trunc=.false.
         else
            Move.Trunc = .true.
            Move.dt = tmax
            Move.dx = Move.dt * Media(MediaNo).X0g
            Move.dl = Move.dx * Media(MediaNo).gtocm
         endif
         if(MagField .gt. 0 ) then
            call epGetB
            call epmagDefR(cTrack, Bfield, r)
c              assume we can go r/10 streight way.
            if(Move.dl .gt. r/10.d0) then
               Move.dl = r/10.d0
               Move.dx = Move.dl/Media(MediaNo).gtocm
               Move.dt = Move.dx/ Media(MediaNo).X0g
               Move.Trunc = .true.
            endif
         endif
         if(ElecField .gt. 0) then
            call epGetE
c                 to be implemented in future
         endif  
      endif
      end
c     ****************
      subroutine epGetB
      implicit none
#include "ZepTrackv.h"
#include "ZepTrackp.h"
c          if MagField=1, Bfield is unchanged from the start time
      if(MagField .eq. 2) then
         call eppos2B(cTrack, Bfield)
c             Bfield is in local coordinate
      endif
      end
c     *****************
      subroutine epGetE
      implicit none
#include "ZepTrackv.h"      
#include "ZepTrackp.h"      
c          if ElecField=1, Efield is unchanged from the start time
      if(ElecField .eq. 2) then
         call eppos2E(cTrack, Efield)
      endif
      end
c     *******************
      subroutine epifCross(kcon)
      implicit none
#include "ZepTrackv.h"
#include "ZepTrackp.h"
#include "Zcnfig.h"
c             see if Move.Track crosses a boundary and set Cross = t/f
c        If t, reset Move.Track.pos just before the boundary.
c        set exact boundary in Move.boundary.
c
      integer kcon, icon


      real*8 el

c         see if Move.Track is in Cn-th component.
c          coord is local coord.
      call epbndry(Move.boundary, el, icon)
                       
c       icon =1 indicates something wrong. but 
c       it should have been corrected safely so we don't
c       care.
c       icon =2  : fail to find boundary. due to delicate problem
      if(icon .ne.  2) then
         if(Move.dl .lt. el) then
            kcon = 0
            Move.Cross = .false.
         else
            kcon = 1
            Move.Cross = .true.
            Move.Trunc = .true.
            Move.Track.pos.x = Move.boundary.x -
     *           EpsLeng* cTrack.w.x
            Move.Track.pos.y = Move.boundary.y -
     *           EpsLeng* cTrack.w.y
            Move.Track.pos.z = Move.boundary.z -
     *           EpsLeng* cTrack.w.z
c            Move.dl = sqrt(
c     *          (Move.Track.pos.x-cTrack.pos.x)**2 +
c     *          (Move.Track.pos.y-cTrack.pos.y)**2 +
c     *          (Move.Track.pos.z-cTrack.pos.z)**2 )
            Move.dl = el - EpsLeng
            Move.dt = Move.dl/Media(MediaNo).X0
            Move.dx = Move.dl/Media(MediaNo).gtocm 
         endif
      else
         kcon = 2
      endif
      end
c
      subroutine epchckE(aTrack, icon)
      implicit none
#include "ZepTrackv.h"
#include "ZepTrackp.h"
#include "Zcnfig.h"
#include "Zcode.h"
#include "Zmass.h"
c            aTrack is examined if it's  energy is too low
c
      record /epTrack/ aTrack   ! input. this track's energy is examined
      integer icon              ! output. 0. the particle is still alive
                                !         1. death. 

      logical ok, kbtest
      integer k
      real*8 ke

      ke = aTrack.p.fm.p(4)- aTrack.p.mass
      k =  aTrack.p.code

      if(k .eq. kelec) then
          if(aTrack.p.charge .eq. -1) then
             ok=aTrack.p.fm.p(4) .gt. EminElec
             if(.not. ok .and. ke .gt. 0.) then
                if(kbtest(Eabsorb, BitElectron)) then
                   Move.dE = ke
                   Move.dEeff = ke
                   Move.dEioni= Move.dE  
                   SumDe = SumDe + Move.dE
                   if(Det.cmp(Cn).CountDE .ge. 1) then
                      call userde(1, aTrack, Move, Media(MediaNo))
                   endif
                endif
             endif
          else
c              positron
             ok=aTrack.p.fm.p(4) .gt. KEmin
             if(.not. ok) then
                if(kbtest(Eabsorb, BitPositron)) then
                   Move.dE = aTrack.p.fm.p(4) + masele

                   SumDe = SumDe + Move.dE
c /////            Move.dEeff = ke
                   Move.dEeff = Move.dE
c/////
                   Move.dEioni= Move.dE  
                   if(Det.cmp(Cn).CountDE .ge. 1) then
                      call userde(1, aTrack, Move, Media(MediaNo))
                   endif

                endif
             else
                if(aTrack.p.fm.p(4) .lt. masele*1.01d0 ) then
c                   if energy is very low, forced anihilation 
                   Move.proc='anih'
                   Move.Trunc=.false.
                endif
             endif
          endif
       elseif(k .eq. kphoton) then
          ok= aTrack.p.fm.p(4) .gt. EminGamma
          if(.not. ok) then
             if(kbtest(Eabsorb, BitPhoton)) then
                Move.dE = aTrack.p.fm.p(4)
                Move.dEeff = ke
                Move.dEioni= Move.dE  
                SumDe = SumDe + Move.dE
                if(Det.cmp(Cn).CountDE .ge. 1) then
                   call userde(1, aTrack, Move, Media(MediaNo))
                endif
             endif
          endif
       elseif(k .eq.  knuc) then
          if(aTrack.p.subcode  .eq. regptcl) then
             ok= ke .gt. KEmin
             if(.not. ok) then
                if( (aTrack.p.charge .eq. 1 .and. 
     *             kbtest(Eabsorb, BitProton)) .or.
     *              (aTrack.p.charge .eq. 0 .and.
     *             kbtest(Eabsorb, BitNeutron))) then
                   Move.dE = ke
                   Move.dEeff = ke
                   Move.dEioni= Move.dE  
                   SumDe = SumDe + Move.dE
                   if(Det.cmp(Cn).CountDE .ge. 1) then
                      call userde(1, aTrack, Move, Media(MediaNo))
                   endif
                endif
             endif
          else
c              anti particle
             ok=aTrack.p.fm.p(4) .gt. KEmin
             if(.not. ok) then
c                energy to be liberated further cannot be estimated.
c                (dependent on the ptcl type)
                if(kbtest(Eabsorb, BitAntiNuc)) then
                   Move.dE = aTrack.p.fm.p(4) + aTrack.p.mass
                   Move.dEeff = ke
                   Move.dEioni= Move.dE  
                   SumDe = SumDe + Move.dE
                   if(Det.cmp(Cn).CountDE .ge. 1) then
                      call userde(1, aTrack, Move, Media(MediaNo))
                   endif
                endif
             endif
          endif
       elseif( k .eq.  kpion .or.
     *         k .eq.  kkaon .or.
     *         k .eq.  kmuon ) then
c            can decay
          ok = aTrack.p.fm.p(4) .gt. KEmin
          if(.not.ok) then
             if(kbtest(Eabsorb,BitDecay)) then
                Move.dE = ke
                Move.dEeff = ke
                Move.dEioni= Move.dE  
                SumDe = SumDe + Move.dE
                if(Det.cmp(Cn).CountDE .ge. 1) then
                   call userde(1, aTrack, Move, Media(MediaNo) )
                endif
             endif
          endif
       else
          ok = ke .gt. KEmin
          if(.not.ok) then
             if(kbtest(Eabsorb, BitOther)) then
                Move.dE = ke
                Move.dEeff = ke
                Move.dEioni= Move.dE  
                SumDe = SumDe + Move.dE
                if(Det.cmp(Cn).CountDE .ge. 1) then
                   call userde(1, aTrack, Move, Media(MediaNo))
                endif
             endif
          endif
       endif
       if(ok) then
          icon=0
       else
          icon=1
       endif
       if(Move.Abort .ne. 0) then
          call epempty          ! empty the stack
          icon = 1
       endif
       end
c      *****************
       subroutine epaddTime
       implicit none
c        new position is assumed to be fixed.
c        (however, before scattering, and energy check).
c        update time and take trace
#include  "Zglobalc.h"
#include  "ZepTrackp.h"
#include  "ZepTrackv.h"

       real*8 ctau, u
       real*8 beta1, betaav
c
       if(Move.Track.p.mass .eq. 0.) then
          betaav=1.d0
       else
          call cgetBeta( Move.Track.p,  betaav)
          if(betaav .lt. 0.98) then
             call cgetBeta(cTrack.p, beta1)
             betaav = (betaav+beta1)/2.
          endif
       endif
       if(betaav .gt. 0.) then
          Move.Track.t = cTrack.t + Move.dl/betaav
       else
c               stopped one. add decay time if possible
          call cgetctau(cTrack.p, ctau)
          if(ctau .eq. Infty) then
c               If the particle is still to be treated
c               even after it stops, the ptcl 
c               should be antiprpton or anti-somthing to
c               anihilate in the next step. We assume
c               the anihilation takes place instantly
c               after stopping. so don't add any time
c               
c                Move.Track.t= cTrack.t+1.e8  ! version <= 8.62
                Move.Track.t = cTrack.t
          else
             call rndc(u)
             Move.Track.t = cTrack.t - log(u)*ctau
          endif
       endif
       end

c      ************************
       subroutine epint(icon)
       implicit none
#include  "ZepTrackv.h"
#include  "ZepTrackp.h"
#include  "Zcode.h"

      integer icon  ! output.  always 1

      character*100 msg
      integer k,  ia, iz


      record /epPos/temppos

      if(FirstC) then
         if(Incident.p.code .eq. kelec
     *        .or. Incident.p.code .eq. kphoton ) then
            FirstInt = cTrack.pos
            Proc1 = Move.proc
            FirstC=.false.
         elseif(Move.proc .eq. 'coll' .or.
     *           Move.proc .eq. 'decay') then
            FirstInt = cTrack.pos
            Proc1 = Move.proc
            FirstC=.false.
         elseif(cTrack.p.code .eq. kmuon .and.
     *         (  Move.proc .eq. 'pair' .or.
     *           Move.proc .eq. 'brem' .or.
     *           Move.proc .eq. 'nuci' ) ) then
            FirstInt = cTrack.pos
            Proc1 = Move.proc
            FirstC=.false.
         endif
         if(.not. FirstC) then
            call epl2w(cTrack.cn, FirstInt, temppos)
            FirstInt = temppos
         endif
      endif
c

      k = cTrack.p.code
      if(k .eq. kphoton) then
         if(Move.proc .eq. 'comp') then
            call epcmpt
         elseif(Move.proc .eq. 'pair') then
            call eppair
         elseif(Move.proc .eq. 'phot') then
            call epphot
         elseif(Move.proc .eq. 'coh') then
            call epcoher
         elseif(Move.proc .eq. 'photop') then
c
            call ep2cosPtcl( cTrack.p )
c              for small basic cross section case.
            call epfixTarget2(Media(MediaNo), ia, iz)
            call ep2cosCond2(ia, iz)
            call cphotop        ! Cosmos function
            call eppushPtcl(cTrack)  ! use pos. info from this ptcl
         elseif(Move.proc .eq. 'mpair') then
            call epmpair
         else
            write(msg,
     *       '('' proccess='',a4,'' for gamma undefined'')')
     *       Move.proc
            call cerrorMsg(msg,0)
         endif
      elseif(k .eq. kelec) then

         if(Move.proc .eq. 'brem') then
            call epbrem
         elseif(Move.proc .eq. 'knoc') then
            call epknoc
         elseif(Move.proc .eq. 'anih') then
            call epanih
         elseif(Move.proc .eq. 'sync') then
            call epsync
         else
            write(msg,
     *         '('' process='',a4, '' for e is undef.'')') Move.proc
            call cerrorMsg(msg, 0)
         endif
      else
         if(Move.proc .eq. 'knoc') then

            call epNEPknoc

         elseif(cTrack.p.code .eq. kmuon .and. 
     *        Move.proc .ne. 'decay') then
            if(Move.proc .eq.'pair') then
               call epmuInte
            elseif(Move.proc .eq.'brem') then
               call epmuInte
            elseif(Move.proc .eq.'nuci') then
               call epmuInte
            endif
         else
            call ep2cosPtcl( cTrack.p )
            if(cTrack.p.code .ne. kgnuc ) then
               call epfixTarget(Media(MediaNo), ia, iz)
            else
c               for heavey incident.  
               call epfixTarget3(cTrack.p, Media(MediaNo), ia, iz)
            endif
            call ep2cosCond2(ia, iz)
            call cinteNEP       ! cosmos eppp
            call eppushPtcl( cTrack )
         endif
      endif
      icon = 1
      end
c     ******************
      subroutine epcoher
c        coherent scattering
c           since coherent scattering is effective at
c           low energies where angular distribution can be
c           approximated by (1+cos^2) dcos, we simply use
       implicit none
#include  "ZepTrackv.h"
c
       record /epDirec/ w

       real*8  eg, tmp, cosg
       real*8  cs, sn, sing

c             sample scattering angle from (1+cos^2)dcos
       call ksampRSA(cosg)
       tmp=1.d0-cosg*cosg
       sing = sqrt(tmp)
       call kcossn(cs,sn)

       w.x = cs*sing
       w.y = sn*sing
       w.z = cosg
       call eptransVect(cTrack.w,  w, cTrack.w)
c        energy unchaged;  
       call epe2p(cTrack)
       call eppush(cTrack)
       end
c     ******************
      subroutine epcmpt
       implicit none
#include  "ZepTrackv.h"
#include  "Zcode.h"

c
       record /epTrack/ electron
       record /epDirec/ w

       real*8 e1, eg, tmp, cosg, cose
       real*8 sine, cs, sn, sing

c             sample energies of compton elec. and gamma
       call epcompea(cTrack.p.fm.p(4), eg, e1, cosg, cose)
       tmp=1.d0-cose*cose
       if(tmp .lt. 0.d0) then
          tmp=0.d0
          cose=-1.d0
       endif
       sine = sqrt(tmp)
       call kcossn(cs,sn)

       electron = cTrack        ! copy everything from cTrack 

       electron.w.x = cs*sine
       electron.w.y = sn*sine
       electron.w.z = cose
c            w  get new direc-cos
       call eptransVect(cTrack.w,  electron.w,  electron.w)

       call cmkptc(kelec, regptcl, -1, electron.p)
       electron.p.fm.p(4) = e1
       call epe2p(electron)
c
c                treat gamma as counterpart of electron (negative d.c)
c
       tmp=1.d0-cosg*cosg
       if(tmp .lt. 0.) then
          cosg=-1.
          tmp=0.
       endif
       sing=sqrt(tmp)
       w.x = -cs*sing
       w.y = -sn*sing
       w.z = cosg

       call eptransVect(cTrack.w,  w, cTrack.w)
       cTrack.p.fm.p(4) = eg
       call epe2p(cTrack)
c            since gamma is likely to have large energy, save first

       call eppush(cTrack)
       call eppush(electron)

       end
c
c     ************
      subroutine eppair
c     ************
       implicit none
#include  "ZepTrackv.h"
#include  "Zcode.h"
#include  "Zmass.h"

c
       record /epTrack/ elec1, elec2


       real*8  e1,  e2,  cos1, cos2
c       real*8 cs, sn,  u,  teta1, teta2
       real*8 cs, sn,  u,  teta2
       real*8 sin1, sin2
       
       integer ic
       
       real*8 Eg
c     
       Eg = cTrack.p.fm.p(4)
c           sample higher energy of pair
       call epPrSampE(Media(MediaNo),  Eg, e1)
c            assign charge
       call rndc(u)
       if(u .lt. .5) then
          ic=-1
       else
          ic=1
       endif
c            the other electron energy
       e2 = Eg - e1
c         sample angle; smaller enery electron must be put
c         last
       call epPairAng(e2, masele, teta2) ! teta2 < pi/2
       if(teta2 .lt. 0.03d0) then
          cos2 = 1. - teta2**2/2
          sin2 = teta2
       else
          cos2 = cos(teta2)
          sin2 = sin(teta2)
       endif

c
       sin1 = sin2 * sqrt(  (e2**2-masele**2)/(e1**2-masele**2) )
       if(sin1 .lt. 0.03d0) then
          cos1 = 1.- sin1**2/2
       else
          cos1 = sqrt(1.d0 - sin1**2)
       endif
c
c          the next simplified treatment is also no problem.
c       teta1=teta2 * e2/e1
c       if(teta1 .lt. 0.03d0) then
c          cos1 = 1. - teta1**2/2
c          sin1 = teta1
c       else
c          cos1 = cos(teta1)
c          sin1 = sin(teta1)
c       endif

       elec1 = cTrack           ! copy everything first
c               sample direction cos. of 1st

       call kcossn(cs,sn)
       elec1.w.x = cs*sin1
       elec1.w.y = sn*sin1
       elec1.w.z = cos1
c           
       call eptransVect(cTrack.w, elec1.w, elec1.w)

       call cmkptc(kelec, regptcl, ic, elec1.p)
       elec1.p.fm.p(4) = e1
       call epe2p(elec1)
c              push higher energy none
       call eppush(elec1)
c               lower energy electron

       elec2 = elec1
       elec2.p.fm.p(4) = e2
       call cmkptc(kelec, antip, -ic, elec2.p)

c           treat the other one as counter part    (negative d.c)
       elec2.w.x = -cs*sin2
       elec2.w.y = -sn*sin2
       elec2.w.z = cos2
       call eptransVect(cTrack.w, elec2.w, elec2.w)
       call epe2p(elec2)
       call eppush(elec2)
       end
c      ************
       subroutine epphot
c      ************
       implicit none
#include  "ZepTrackv.h"
#include  "ZepTrackp.h"
#include  "Zcode.h"
#include  "Zcnfig.h"
#include  "Zmass.h"           

       real*8 eout, cost, cs, sn, sint, Exray
       logical kbtest
       record /epTrack/ elec1, xray
c
c           get Photo-electron energy
c       call epphotoEe(Media(MediaNo).pe,   < v8.0
       call epphotoEe(Media(MediaNo),
     *      cTrack.p.fm.p(4), eout, cost)
       if(kbtest(Eabsorb, BitPhotoElec)) then
c            energy absorbed by atom is Eabs = Eshell= Eg-(Ee-Me)
          Move.dE = cTrack.p.fm.p(4) - (eout - masele)
          Move.dEeff= Move.dE
          Move.dEioni = Move.dE
          SumDe = SumDe + Move.dE
c                  regard it as deposited in the media
          if(Det.cmp(Cn).CountDE .ge. 1) then
             call userde(1, cTrack, Move, Media(MediaNo))
          endif
          Exray = 0.
       else
c             bit 1 is not on; characteristic x-ray emmission;
c             This was neglected in v8.71 or earlier.
c             we  assume 
c                1)  p.e effect takes place for the largest possible
c                    shell energy (Say, if Eg> K-shell energy, L-shell
c                    p.e effect is neglected and all p.e effect  is assumed
c                    to take for K-shell. 
c                2)  For such p.e effect, vacancy of electron level is 
c                    filled by X-ray emission ; No Auger electron emmission
c                    is considered. 1)+2) are good approximation.
         Exray = max( cTrack.p.fm.p(4) - (eout - masele), 0.d0)
c//////////
c         write(0,*) ' ----------Exray=',Exray, ' eout=',eout
c////////////
       endif
c         emitted electron
       elec1 = cTrack
       call cmkptc(kelec, regptcl, -1, elec1.p)
       call kcossn(cs,sn)
       sint = sqrt(1.-cost**2)
       elec1.w.x = cs*sint
       elec1.w.y = sn*sint
       elec1.w.z = cost
       elec1.p.fm.p(4) = eout 
       call eptransVect(cTrack.w, elec1.w, elec1.w)
       call epe2p(elec1)
       call eppush(elec1)
c         emitted xray; assume isotropic
       if( Exray  .gt.  0.) then
          xray = cTrack
          call cmkptc(kphoton, 0, 0, xray.p)
          call rndc(cost)
          cost = 2.0*cost-1.0
          call kcossn(cs,sn)
          sint = sqrt(1.-cost**2)
          xray.w.x = cs*sint
          xray.w.y = sn*sint
          xray.w.z = cost
          xray.p.fm.p(4) = Exray
          call eptransVect(cTrack.w, xray.w, xray.w)
          call epe2p(xray)
          call eppush(xray)
       endif
       end
c      ************
       subroutine epbrem
c      ************
       implicit none
#include  "ZepTrackv.h"
#include  "ZepTrackp.h"
#include  "Zcode.h"
#include  "Zmass.h"

c
       record /epDirec/ w
       real*8 e1, eg, theta, cs, sn, cost, sint

       e1 = cTrack.p.fm.p(4)
c             sample brems gamma energy
       call epBrSampE(Media(MediaNo), e1, eg)

c             electron energy
       cTrack.p.fm.p(4) =  e1 - eg
c          save electron. can assume electron dose not change angle
       call eppush(cTrack)
c         see if brem g angle needed
       if(AngleB) then
c          brems g angle relative to parent electron.
          call epBremAng(e1, masele, eg, Media(MediaNo).Zeff, theta)
          if(theta .lt. 0.03d0) then
             sint = theta
             cost = 1.- theta**2 / 2
          else
             sint = sin(theta)
             cost = cos(theta)
          endif
          call kcossn(cs,sn)
          w.x = cs*sint
          w.y = sn*sint
          w.z = cost
          call eptransVect(cTrack.w,  w, cTrack.w)
       endif
       cTrack.p.fm.p(4) = eg
       call cmkptc(kphoton, 0, 0, cTrack.p)
       call epe2p(cTrack)       
       call eppush(cTrack)
       end

c     ************
      subroutine epanih
c     ************
      implicit none
#include  "ZepTrackv.h"

#include  "Zcode.h"
#include  "Zmass.h"

c
      record /epTrack/  gamma
      record /epDirec/  w
      real*8 Ee, eg1, eg2, cos1, cosr, tmp, sine, sinr
      real*8 cs, sn 
c        cpy parent info.
      gamma = cTrack
      Ee = cTrack.p.fm.p(4)
      call epanihiea(Ee, eg1, eg2, cos1, cosr)
      tmp=1.d0-cos1*cos1
      if(tmp .lt. 0.d0) then
         tmp=0.d0
         cos1=-1.d0
      endif
      sine=sqrt(tmp)
      call kcossn(cs,sn)
      w.x = cs*sine
      w.y = sn*sine
      w.z = cos1
      call eptransVect(cTrack.w, w, w)
c        save hi gamma
      call cmkptc(kphoton, 0, 0, gamma.p)
      gamma.p.fm.p(4) = eg1
#ifdef SUBSTREC
      gamma.w = w
#else
      call epsubvec( w, gamma.w)
#endif
      call epe2p(gamma)
      call eppush(gamma)
c       low gamma
      tmp=1.d0-cosr*cosr
      if(tmp .lt. 0.d0) then
         tmp=0.d0
         cosr=-1.d0
      endif
      sinr=sqrt(tmp)
      gamma.w.x = -cs*sinr
      gamma.w.y = -sn*sinr
      gamma.w.z = cosr
      call eptransVect(cTrack.w, gamma.w, gamma.w)
      gamma.p.fm.p(4) = eg2
      call epe2p(gamma)
      call eppush(gamma)
      end

c     ************
      subroutine  epknoc
      implicit none
#include  "ZepTrackp.h"
#include  "ZepTrackv.h"
#include  "Zcode.h"
#include  "Zmass.h"
           
c
      integer ic
      record /epDirec/ w
      record /epTrack/ survival
      real*8 Ee, e1, er, cos1, cosr, sine, cs, sn, sinr, tmp
      character*80 msg

      ic = cTrack.p.charge
      Ee = cTrack.p.fm.p(4)

      if(ic .eq. -1) then
         call epmollerea(Ee, RecoilKEmin, e1, er, cos1, cosr)
c         call epmollerea(Ee,  e1, er, cos1, cosr)  ! old
      elseif(ic .eq. 1) then
         call epbhabhae(Ee, RecoilKEmin, e1, er, cos1, cosr)
c         call epbhabhae(Ee, e1, er, cos1, cosr)  ! old
      else
         write(msg,*) ' charge =',ic,' for knocon'
         call cerrorMsg(msg, 0)
      endif
      tmp=1.d0-cos1*cos1
      if(tmp .lt. 0.d0) then
         tmp=0.d0
         cos1=1.d0
      endif
      sine=sqrt(tmp)
      call kcossn(cs,sn)
      w.x = cs*sine
      w.y = sn*sine
      w.z = cos1
      call eptransVect(cTrack.w, w, w)
      survival = cTrack
      survival.p.fm.p(4) = e1
#ifdef SUBSTREC
      survival.w = w
#else
      call epsubvec(w, survival.w)
#endif
      call cmkptc(kelec, -ic, ic, survival.p)
      call epe2p(survival)
      call eppush(survival)
c                knock on electron
      tmp=1.d0-cosr*cosr
      if(tmp .lt. 0.d0) then
         tmp=0.d0
         cosr=1.d0
      endif
      sinr = sqrt(tmp)
      survival.w.x = -cs*sinr
      survival.w.y = -sn*sinr
      survival.w.z = cosr
      survival.p.fm.p(4) = er
      call cmkptc(kelec, regptcl, -1, survival.p)
      call eptransVect(cTrack.w, survival.w, survival.w)
      call epe2p(survival)
      call eppush(survival)
      end
c     ********************************
      subroutine epsync
      implicit none
#include  "ZepTrackv.h"
#include  "Zcode.h"

       real*8 e1, eg

       e1 = cTrack.p.fm.p(4)
c             sample sync photon  energy
       call epsynce(e1, Upsilon, eg)
c             electron energy
       cTrack.p.fm.p(4) =  e1 - eg
       call cadjm(cTrack.p, cTrack.p)  ! adjust momentum due to energy change
c          save electron. can assume electron dose not change angle
       call eppush(cTrack)
       cTrack.p.fm.p(4) = eg  ! no direction change
       call cmkptc(kphoton, 0, 0, cTrack.p)
       call epe2p(cTrack)       
       call eppush(cTrack)
       end
c     ********************************
      subroutine epmpair
c         magneic pair production
      implicit none
#include  "ZepTrackv.h"
#include  "Zcode.h"

       real*8 e1, eg, chg, u

       eg = cTrack.p.fm.p(4)
c             sample pair electron of higher energy
       call epmpaire(eg, Xai, e1)
c            higher energy electron
       cTrack.p.fm.p(4) =  e1
c          save  higher energy electron.
c          can assume electron dose not change angle
       call rndc(u)
       if(u .lt. 0.5) then
          chg = -1
       else
          chg = 1
       endif
       call cmkptc(kelec, -chg, chg, cTrack.p)
       call cadjm(cTrack.p, cTrack.p)
       call eppush(cTrack)
       cTrack.p.fm.p(4) = eg - e1  
       cTrack.p.charge = chg
       cTrack.p.subcode = -chg
       call cadjm(cTrack.p, cTrack.p) 
       call epe2p(cTrack)       
       call eppush(cTrack)
       end
c
c     ************
      subroutine epNEPknoc
c     ************
      implicit none
#include  "ZepTrackv.h"
#include  "Zcode.h"
c     
      record /epDirec/ w 
      record /epTrack/ aTrack
      real*8  e1,  er, cos1, cosr, tmp
      real*8 cs, sn, sinr


      call epKnockea(cTrack.p, e1, er, cos1, cosr)
c
c     We can neglect angle of survival particle completely
c      tmp=1.d0-cos1*cos1
c      if(tmp .lt. 0.d0) then
c         tmp=0.d0
c         cos1=1.d0
c      endif
c      sine=sqrt(tmp)

       call kcossn(cs,sn)

c      w.x = cs*sine
c      w.y = sn*sine
c      w.z = cos1
c           
      aTrack = cTrack
      aTrack.p.fm.p(4) = e1
      call epe2p(aTrack)
      call eppush(aTrack)
c                knock on electron
      tmp=1.d0-cosr*cosr
      if(tmp .lt. 0.d0) then
         tmp=0.d0
         cosr=1.d0
      endif
      sinr = sqrt(tmp)
      w.x = -cs*sinr
      w.y = -sn*sinr
      w.z = cosr
c           
      call eptransVect(cTrack.w, w, cTrack.w)
      call cmkptc(kelec, regptcl, -1, cTrack.p)
      cTrack.p.fm.p(4) = er
      call epe2p(cTrack)
      call eppush(cTrack)
      end
c        *************** inquire incident ptcl
      subroutine epqinc(aTrack)
      implicit none 
#include  "ZepTrackv.h"
      record /epTrack/ aTrack
      aTrack =  Incident
      end
c     **************  inquire the first collision point
      subroutine epqFirstI(firstpos)
      implicit none
#include "ZepTrackv.h"
      record /epPos/ firstpos  ! output.
      firstpos = FirstInt
      end
c     ***********************
      subroutine epe2p(aTrack)
c         E & direc cos  -->  px,py,pz
      implicit none
#include "ZepTrack.h"
      
      record /epTrack/ aTrack

      real*8 p

      p = aTrack.p.fm.p(4)**2 - aTrack.p.mass**2
      if(p .lt. 0.) then
         p = 0.
      else
         p = sqrt(p)
      endif

      aTrack.p.fm.p(1) = p * aTrack.w.x
      aTrack.p.fm.p(2) = p * aTrack.w.y
      aTrack.p.fm.p(3) = p * aTrack.w.z
      end
c    *************************************
      subroutine epmagDefR(aTrack, mag, r)
      implicit none
c       get magnetic deflecton radius.  This is
c       approximate one.

#include  "ZepTrack.h"

      record /epTrack/aTrack  ! input. charged particle
      record /epPos/ mag  !   innput. magnetic field vector in 
                          !           the local coordinate
                          ! field strength is in T.
      real*8  r   ! output. Radius of magnetic defletion.  cm 
                  !         rough value.

      real*8 maxb, temp

      maxb = max (abs(mag.x), abs(mag.y), abs(mag.z))
      if(maxb .ne. 0) then
         temp = aTrack.p.fm.p(4)**2-aTrack.p.mass**2
         if(temp .le. 0.) then
            r = 1.d-4
         else
            r = 333.d0* sqrt(temp)/maxb/
     *       abs(aTrack.p.charge)
            r= max(r, 1.d-4)
         endif
      else
         r = 1.d10
      endif
      end
c////////////////////////////
      subroutine debugm(msg)
      implicit none
#include "ZepTrackv.h"
      character*(*) msg
      logical strange
      character*16 trigger

      strange = .false.
      if( Media(MediaNo).noOfElem .le. 0 .or. 
     *    Media(MediaNo).noOfElem .gt. 5 ) then
         strange = .true.
         trigger='noOfElem'
      elseif(Media(MediaNo).A .lt. 1. .or.
     *   Media(MediaNo).A .gt. 1000.) then
         strange = .true.
         trigger='A'
      elseif(Media(MediaNo).Z .lt. 1. .or.
     *   Media(MediaNo).Z .gt. 1000.) then
         strange = .true.
         trigger='Z'
      elseif(Media(MediaNo).Aeff .lt.  1.) then
         strange = .true.
         trigger='Aeff'
      endif
c
      if(strange) then
         write(*,*) trigger, ' ***********', msg
         write(*,*) ' code=',cTrack.p.code,' proc=',Move.proc
         write(*,*) '      MediaNo=', MediaNo,
     *      ' noOfElem=',Media(MediaNo).noOfElem
         write(*,*)
     *         ' charge=',cTrack.p.charge, ' subcode=',cTrack.p.subcode,
     *         ' E=', cTrack.p.fm.p(4), ' Zeff=', Media(MediaNo).Zeff
         write(*, *) ' noOfElem=', Media(MediaNo).noOfElem,
     *         ' n, A, Z', Media(MediaNo).n,
     *          Media(MediaNo).A, Media(MediaNo).Z
         write(*,*)' mbtoPgrm=',Media(MediaNo).mbtoPgrm,
     *         ' mbtoPcm=',Media(MediaNo).mbtoPcm,
     *         ' mbtoPX0=',Media(MediaNo).mbtoPX0

         write(*,*)' mbtoPgrm2=',Media(MediaNo).mbtoPgrm2,
     *         ' mbtoPcm2=',Media(MediaNo).mbtoPcm2,
     *          ' mbtoPX02=',Media(MediaNo).mbtoPX02

         write(*,*)' Z2byAeff, Z5byA=', Media(MediaNo).Z2byAeff,
     *         Media(MediaNo).Z5byAeff 


         write(*,*)  ' A=', Media(MediaNo).A,
     *           ' Z=', Media(MediaNo).Z,
     *           ' Aeff=', Media(MediaNo).Aeff
      endif
      end
c//////////
      subroutine  debugpos(msg, compn, pos, icon)
      implicit none
#include "ZepTrackv.h"
      record /epPos/ pos
      character*(*) msg
      integer compn, icon


c////////////
c      include 'Zdebug.h'
c      if(dddd) then

         write(*,*) '--------------- ', msg, ' Cn=',Cn
         write(*,*) ' compn=',compn, ' pos.x,y,z=',
     *      pos.x, pos.y,  pos.z
         write(*,*) ' ctrackpos=',cTrack.pos.x, 
     *      cTrack.pos.y, cTrack.pos.z, ' wx,y,z=',
     *      cTrack.w.x, cTrack.w.y, cTrack.w.z
         write(*,*) ' M-w.x =',Move.Track.w.x, 
     *        Move.Track.w.y, Move.Track.w.z
         write(*,*) ' Move.track.pos=',Move.Track.pos.x,
     *     Move.Track.pos.y,  Move.Track.pos.z, ' dl=',
     *     Move.dl, Move.dE, Move.Track.p.mass,
     *    ' trucn=',Move.Trunc
         write(*,*)
     *     ' code=', cTrack.p.code,  ' chg=',cTrack.p.charge,
     *     ' E=',  cTrack.p.fm.p(4)
         write(*,*) ' cross=',Move.Cross, ' Trunc=',Move.Trunc
         write(*,*) ' icon=',icon
c      endif
      end





