      subroutine epPrSampP(media, Eg, prob, path)
c          generic brems sampling routine
      implicit none
#include "Zmedia.h"
#include "ZepTrackp.h"

      record /epmedia/media  ! input.
      real*8 Eg            ! input. Gamma energy in GeV
      real*8 prob          ! output. pair prob. per r.l
      real*8 path          ! output. sampled path in r.l

      real*8 u

      if( Eg .lt. media.cnst.PrScrE ) then
c          partial screeinig region
         call epPrLSampP(media, Eg,  prob)
      elseif(Eg .lt. media.cnst.PairEgmaxL) then
c            complete screeing region
         call epPrCSampP(media, Eg, prob)

      else
         if(LPMeffect) then
c            LPM region
            call epPrHSampP(media, Eg, prob)
         else
c           use  complete screeing region
            call epPrCSampP(media, Eg, prob)
         endif

      endif
      call rndc(u)
      path = -log(u)/prob
      end
c     *********************************** 
      subroutine epPrSampE(media, Eg, Ee)
      implicit none
#include "Zmedia.h"
#include "ZepTrackp.h"
      record /epmedia/media  ! input.
      real*8 Eg            ! input. gamma energy in GeV
      real*8 Ee            ! output. sampled Ee in GeV. higher energy of pair



      if(Eg .le. media.cnst.PairNonSc + 2.d-3) then
c          table in epPrLSampE is  used >  PairNonSc + 2 MeV
c          because of a glitch  around PairNonSc
c         (for Nelson's case, there is no glitch; glitch
c          comes from diff.  of dsigma/dx at x~xmax.
c
         call epPrTSampE(Eg, Ee)  ! media info not needed.

      elseif(Eg .le. media.cnst.PrScrE) then
c           partial screeinig region
         call epPrLSampE(media, Eg,  Ee)

      elseif(Eg .le. media.cnst.PairEgmaxL) then
c            complete screeing region
         call epPrCSampE(media, Eg, Ee)

      else
         if(LPMeffect) then
c            LPM region
            call epPrHSampE(media, Eg, Ee)
         else
c            use complete screeing region
            call epPrCSampE(media, Eg, Ee)
         endif
      endif
      end
