#if defined NEXT486
#define IMAG_P dimag
#elif defined PCLinux
#define IMAG_P dimag
#else
#define IMAG_P imag
#endif
      
c      kinout:  judge if a point is inside of a polygon
c      kxplbx:  box and line x-point
c      kxplcy:  cyl and line x-point
c      kxplp:   plane and line x-point
c      kxplsl:  line and segment of line x-point
c      kxplineseg: x-point of two line segments 
c      kxplPrism: line and prism x-point
c      k3dclp:  3d clipping
c      kfige:   find int data pos. >= a given value
c      ksetiv:  set an integer value in a given array
c      ksetrv:  set a real*8 value in a given array
c      k3inout: see if a point is inside of a triangle.
c      kxplsph: sphere and line x-point
c      kioPrism: judge if a given point is inside of a prism
c      kgetField:
c      kfindField:  similar to abvoe
c      kgetCpos:
c      kgetBpos:
c      kshiftB: shift blank until non blank appears
c      kshiftC: shift character until blank  appears
c      kDebye:  Debye function
c      kBern:   Bernuoulli number
c      kalpha:  see if string starts with a-z or A-Z
c      kxplellip: crossing point of a line with an ellipse
c      kgsub:  substitute string 
c      ****************************
      logical function kalpha(string)
c
c         see if first character of string is one of a-z or A-Z
c
      implicit none
      character*(*) string
      logical first/.true./
      integer a, z, CA, CZ, i
      save first, a, z, CA, CZ
      
      if(first) then
         a = ichar('a')
         z = ichar('z')
         CA = ichar('A')
         CZ = ichar('Z')
         first = .false.
      endif
     
      i = ichar(string(1:1))
      if(i .ge. a .and. i .le. z) then
         kalpha = .true.
      elseif(i .ge. CA .and. i .le. CZ) then
         kalpha = .true.
      else
         kalpha = .false.
      endif
      end
c          test kcplcy
c      real*8 l, m, n, x0, y0, z0, el
c      x0=-0.9
c      y0=-0.9
c      z0=-0.5d0
c      l=(1.41421356/2)**2
c      m=l
c      n= sqrt(1.d0- l**2 - m**2)
c      write(*,*) ' n=',n
c      r=1.
c      h=2.
c      call  kxplcy(x0, y0, z0, l, m, n,
c    *         r, h,  el, icon, icon2)
c              write(*,*) ' el=',el, ' icon=',icon, ' icon2=',icon2
c       end
c       ****************************************************************
c       *
c       *  kxplcy: crossing point of a line with a cylinder
c       *
c       ************************ tested 89.09.06 ***********************
c
c  call kxplcy(x0, y0, z0, l, m, n, r, h,  el,
c                icon, icon2)
c  input:
c     x0,y0,z0:  a point the line passes, real*8
c     l, m, n: (real)  direction cos of the line, real*8
c     r: radius of cylinder. real*8
c     h: height of //     bottom is assumed to be on z=0
c                         axis is assumed to be z- axis
c                         top is assumed to be z=h  real*8
c  output:
c     el: x-ssing point is at (x0,y0,z0)+el*(l,m,n)  el>0
c         only x-ssing point with el>0 is obtained.
c    From Dec.28.2004, el==0 case is omitted as crsossing case.
c
c         if there is two el>0 xssing points, nearer one is
c         taken.
c
c   icon : output. 0 the point is in the cyl. el is obtained
c                    if icon2 != -1. 
c                  1 the point is out side of the cyl. el is
c                     obtained.
c                 -1 no x-ing point
c   icon2: output. 1  x-ing point is on x-y  top plane.
c                  2  //             on the side.
c                  6  //             on      bottom.
c                 -1  no x-ing point
c
c   ****** note ******
c          this is designed to be fast if the x-ssing point is
c          at the top or bottom of the cylinder.
c
       subroutine  kxplcy(x0, y0, z0, l, m, n,
     *         r, h,  el, icon, icon2)
       implicit none
c
       real*8 x0,y0,z0, l, m, n, el, r, h
       integer*4 icon, icon2
c
       real*8  d, wxy, x0y0, rsq, x, y, b1, ds, z
c
           rsq=r**2
           x0y0=x0**2+ y0**2 - rsq
           if(z0 .ge. 0. .and.  z0 .le. h  .and.  x0y0 .le. 0.d0) then
               icon =0
           else
               icon =  -1   ! at least outside. may be changed later
           endif
           icon2 = -1
           if(n .gt. 0.d0 .and. icon .eq. 0) then
               el=(h-z0)/n
               x=x0+ el*l
               y=y0+ el*m
               if(x**2 + y**2 .le. rsq  .and. el .ge. 0.) then
                  icon2 = 1
               endif
           elseif(n .lt. 0.d0 .and. icon .eq. 0) then
               el=-z0/n
               x=x0+ el*l
               y=y0+ el*m
               if(x**2 + y**2 .le. rsq .and. el .ge. 0. ) then
                  icon2 = 6
               endif
           endif
           if(icon2 .eq. -1) then
              wxy=l**2 + m**2
              if(wxy .eq. 0.) then
c                  vertical. from outside
                 if(z0 .lt. 0. .and. n .gt. 0. .and.
     *               x0y0 .le. 0.) then
                    icon = 1
                    icon2= 6
                    el = -z0
                 elseif(z0 .gt. h .and. n .le. 0. .and.
     *               x0y0 .le. 0.) then
                    icon2 = 1
                    icon = 1
                    el = (h-z0)/n
                 endif
              endif
           endif

           if(icon2 .eq. -1 .and. wxy .ne. 0.) then
              b1=l*x0+m*y0
              d= b1**2 - wxy* x0y0

              if(d .ge. 0.d0)then
                 ds=sqrt(d)
                 if(x0y0 .le. 0.d0) then
c                       point is inner part of cylinder
                     el=  (-b1 + ds)/wxy
                     z=z0+el*n
                     if(z0 .ge. 0. .and. z0 .le. h 
     *                   .and. el .ge. 0.) then
                        icon = 0
                        icon2 = 2
                     elseif(z0 .gt. h .and. n .lt. 0.d0) then
                        el=(h-z0)/n
                        x=x0+el*l
                        y=y0+el*m
                        if(x**2+ y**2 .le. rsq .and.  el .ge. 0. ) then
                           icon = 1
                           icon2 = 1
                        endif
                     elseif(z0 .lt. 0.d0 .and. n .gt. 0.d0) then
                        el=-z0/n
                        x=x0+el*l
                        y=y0+el*m
                        if(x**2+ y**2 .le. rsq .and. el .ge. 0.) then
                           icon =  1
                           icon2 = 6
                        endif
                     endif
                 elseif(b1 .le. 0.) then
c                       point is outside.  x-ssing forward with cyl
                      el=  (-b1- ds)/wxy
                      z=z0+el*n
                      if(z .ge. 0. .and. z .le. h 
     *                   .and. el .ge. 0. ) then
                         icon = 1
                         icon2 = 2
                      elseif(n .lt. 0.d0) then
                         el=(h-z0)/n
                         x=x0+el*l
                         y=y0+el*m
                         if(x**2+ y**2 .le. rsq .and. el .ge. 0. ) then
                            icon = 1
                            icon2 = 1
                         endif
                      elseif(n .gt. 0.d0) then
                         el=-z0/n
                         x=x0+el*l
                         y=y0+el*m
                         if(x**2+ y**2 .le. rsq .and. el .ge. 0. ) then
                            icon = 1
                            icon2 = 6
                         endif
                      endif
                 endif
             endif
           endif
       end
c     ****************************************************************
c     *                                                              *
c     * kxplp: crossing point of a given line with a given plane     *
c     *                                                              *
c     *********************** tested 89.09.06 ************************
c
c /usage/        call kxplp(x0, y0, z0, l, m, n, a, b, c, d,
c         *      el, icon)
c
c
c -- input --
c    x0,y0,z0:  a point the line passes.  real*8
c    l, m, n : x,y,z componets of the dirction cosine of the line
c              (real*8) (unit vector)
c             ( line is expressed by  (x-x0)/l=(y-y0)/m=(z-z0)/n  )
c
c     a,b,c,d:  coefficients to express the plane.  ax+by+cz=d   is the
c               plane.  real*8.   a,b,c are the direction cos of a line
c               perpendicular to the plane, d is the distance to the
c               plane from the origin, if (a,b,c) is a unit vector.
c               (a,b,c) may not be unit vector.
c
c  -- output --
c      el:  real*8    crossing point is at  (x0,y0,z0)+el*(l,m,n)
c              el>=0 if xpoint is on the l,m,n direction
c                    else negative.
c       icon:  0 when a crossing point is obtained
c              1 when the line is on the plane
c              2 when the line is paralell to the plane but not on the
c                plane
c
c                when icon^=0, el is unchanged.
c
c    ** note ** no check is made on the consistency of l,m,n
c               and a,b,c
c
      subroutine kxplp(x0, y0, z0, l, m, n, a, b, c, d,
     *           el, icon)
       implicit none
c
c
      real*8 x0, y0, z0,  l, m, n, el, a, b, c, d
      integer icon
c
      real*8 div, g, an, bn, cn, dn, dist2

      if((abs(a)+abs(b)+abs(c)) .eq. 0.) then
          icon=3
      else
          div= a*l + b*m + c*n
          if(abs(div) .gt. 0.d0) then
c              crossing point exists
              el=(d- (a*x0+b*y0+c*z0) )  /  div
              icon=0
          else
c               // or one the plane.  comput distance from (x0,...)
c               to the plane
c                    normalize coeficient to avoid overflow
              g=max( abs(a), abs(b), abs(c) )
              an=a/g
              bn=b/g
              cn=c/g
              dn=d/g
              dist2= ( an*x0 + bn*y0 + cn*z0  -dn )**2  /
     *                       (an**2 + bn**2 + cn**2)
              if(dist2 .eq. 0.) then
c                  on the plane
                 icon=1
              else
c                 no cross
                 icon=2
              endif
          endif
      endif
      end
c*include kxplsl
c          test kinout
c      real xa(5), ya(5)
c      data xa/-1., 1., 1.5, 0.,  -1./, ya/-1., -1., 0., 1., 1./
c      x0=-0.5
c      y0=0.2
c      eps=1.e-5
c      call kinout(xa, 1, ya, 1, 5, x0, y0, eps, 'conv', icon)
c      write(*,*) ' icon=',icon
c      end
c     ****************************************************************
c     *                                                              *
c     *  kinout: judge whether a given point is in inner or outer    *
c     *          region of a given polygon.                          *
c     ****************************************************************
c
c /usage/  call kinout(xa, intvx, ya, intvy, n, x0, y0, eps,
c        *     convex, icon)
c    xa:   input.  real*8. array containe x values of a polygon
c    ya:   input.  real*8   //       y
c  intvx:  input.  integer*4.  interval of data in xa
c  intvy:  input.  //                              ya
c      n:  input.  # of polygon vertexes.
c  x0,y0:  input.  real*8 point to be judged whether it is inside
c                  of the polygon
c    eps:  input.  accuracy to judge //ity or coincident lines.
c convex:  input.  'conv'->polygon is assumed to be convex, else it
c                  may be convex or concave.
c   icon:  output.   1 if the point is in outer region
c                   -1                 in inner region
c                    0  on the edge of the polygon
c                   -2 input is invalid (n<=2)
c
c method:  draw an arbitrary half-line from (x0,y0), which does
c         not pass the vertex of the polygon.  if it crosses the
c         polygon edge odd TimeStruc, (x0,y0) is in inner part.
c
c        if two consEcutive points of polygon are same, one of them
c        will be ignored.  if resultant vertex points become <=2,
c        icon=-2 will result.
c
c  ***   kxplsl needed.   ***
c
c
c
c
       subroutine  kinout(xa, intvx, ya, intvy, n, x0, y0, eps,
     *         convex, icon)
       implicit none
c

       character*(*) convex
       integer intvx, intvy, n, icon
       real*8 xa, ya, x0, y0, eps
       dimension xa(intvx,n), ya(intvy,n)
c
      complex*16 expa
      complex*16 expaa(4)/ (1.,0.), (0., 1.), (0.,-1.), (-1., 0.)/
      integer j, ic, i
      real*8 angle
c
      if(n .le. 2 .or. intvx .le. 0 .or. intvy .le. 0)then
         icon=-2
      else
         j=1
c         *** until loop*** 
         do while (.true.)
c             choose angle of half-line starting from (x0,y0)
             expa=expaa(j)
             call kinoua(xa, intvx, ya, intvy, n, x0, y0, eps,
     *       convex, expa,  icon)
c             write(*,*) ' icon=',icon, ' j=',j
             j=j+1
         if         (icon .ge. -2 .or. j .gt. 4)
     *                      goto 200
         enddo
  200    continue
        if(icon .lt. -2) then
c               parallel to cordinate lines have been all tested,
c               so try inclined half-line starting from angle=10 deg.
c               with step 10 deg
             ic=0
c             *** until loop*** 
             do while (.true.)
                  if(mod(ic, 4) .eq. 0) then
                     angle=0.1745329*(ic+1)
                  endif
                  expa = exp((0.d0,1.d0)*angle)
                  call kinoua(xa, intvx, ya, intvy, n, x0, y0, eps,
     *            convex, expa,  icon)
                  angle=angle+3.14159265/2
                  ic=ic+1
             if         (icon .ge.-2 .or. ic .gt. 10)
     *                          goto 300
             enddo
  300        continue
             if(icon .lt. -2) then
             write(*,810) convex,x0, y0, (xa(1,i),ya(1,i), i=1,n)
  810          format('0***ill-condition input to kinout.  convex=',a4,
     1        '  x0,y0=',2g13.4, ' vertex points=',/(1h ,10g12.3))
               icon=-2
             endif
         endif
      endif
      end
      subroutine kinoua(xa, intvx, ya, intvy,n, x0, y0, eps,
     *  convex,  expa, icon)
       implicit none
       character*(*) convex
       integer intvx, intvy, n, icon
       real*8 xa, ya, x0, y0, eps
       dimension xa(intvx,n), ya(intvy,n)
       complex*16  z1, z2, expa, z00
       real*8 xx1(2), xx2(2)
       equivalence ( xx1(1), z1 ), ( xx1(1), x1 ), ( xx1(2), y1 ),
     1            ( xx2(1), z2 ), ( xx2(1), x2 ), ( xx2(2), y2 )
       integer nor
       real*8 x1, y1, x2, y2, p, q
       integer i, jcon, nn
c
       z00=cmplx(x0,y0)
c        clear no. of crossing points of this line with the polygon
       nor=0
c         vertex ponts counter
       nn=n
       i=1
       icon=-3
c       *** until loop*** 
       do while (.true.)
c          choose two points to form a segment
          x1=xa(1,i)
          y1=ya(1,i)
          if( i .eq. n) then
              x2=xa(1,1)
              y2=ya(1,1)
          else
              x2=xa(1,i+1)
              y2=ya(1,i+1)
          endif
c             see if two vertex points are same
          if(x1 .eq. x2 .and. y1 .eq. y2) then
c              reduce vertex points counter
             nn=nn-1
             if(nn .le. 2) then
                icon=-2
             endif
          else
c                obtaine cross point of two lines
             call kxplsl(z00, expa, z1, z2, eps, p, q, jcon)
c            write(*,*) ' kxplsl: jcon=',jcon, ' p=',p, ' q=',q
             if(jcon .eq. 0) then
c                   crossing point exist
c                    see if z0 is on the polygon edge
                   if( abs(q) .le. eps) then
c                           given point is on the polygon edge
                       icon=0
                   elseif( q .lt. 0.) then
c                       see if cross point is not on the half line
c                         try antther
                   elseif( p .eq. 0.  .or. p .eq. 1. ) then
c                    if cross point is on the vertex, take another line
                      i=n+1
                      icon=-3
                   else
                      nor=nor+1
                      if(convex .eq. 'conv'  .and. (nor .eq. 2) ) then
c                        if convex, max of nor is 2
                         icon=1
                      endif
                   endif
             elseif(jcon .eq. 1) then
c                  overlap
                 i=n+1
             elseif(jcon .ge. 2) then
c                // or no x on the seg.
             endif
          endif
          i=i+1
       if         (i .gt. n .or. icon .ge.-2)
     *                    goto 100
       enddo
  100  continue
c     write(*,*) ' nor=',nor
      if(nor .ge. 1 .and. mod(nor,2) .ne. 0) icon=-1
      end
c     complex zz0/(0., 0.)/
c     complex expa, zz1, zz2
c     expa=exp( cmplx(0., 1.)*(90.01 /180.*3.141592 ) )
c     zz1=cmplx(0., 1.)
c     zz2=cmplx(1., 0.)
c     eps=1.e-5
c     call kxplsl(zz0, expa, zz1, zz2, eps, p, q, icon)
c     write(*,*) ' icon=',icon, ' p=',p, ' q=',q
c     end
c     ****************************************************************
c     *                                                              *
c     * kxplsl:  get crossing point of a segment and a line          *
c     *                                                              *
c     ****************************************************************
c
c /usage/
c             call kxplsl(zz0,expa, zz1,zz2, eps, p,q, icon)
c
c               zz1 *
c                   p .
c                    /
c                   /       *
c                q /         zz2
c                 /  <---complex exp of this angle = expa
c               * ------------
c                zz0
c
c   zz0--given point in complex
c  expa--exp(i*angle) of a line which passes zz0
c   zz1, zz2-- given points in complex to denote a segment
c     p--distance from zz1 to the crossing point (singned)
c        this is the portion of the segment length.
c     q--distance from zz0 to    //
c   eps-->=0.  used to judge the parallity of two lines as well as
c        to judge the separation of two // lines.
c
c  __return condition__
c
c      icon=0:        crossing point found on the segment (0 <= p <= 1)
c           1         the line overlaps the segment.  the position of
c                     zz0 may be judged by q.  if q < 0, zz0 is 'left'
c                     to zz1,  if q > 1, zz0 is 'right' to zz2
c                     if q=0, zz0 is on the segment
c           2         crossing point is outside of the segment
c                     if p < 0, it is 'left' to zz1, if p > 1, it is
c                     'ritht' to zz2
c           3         no crossing point at all, i.e., they are parallel
c                     in this case q becomes distance between two lines
c
c *** note ***    they are // if the relative angle of both lines
c                 are < eps
c                 if the relative separtion of two // lines are
c                 less than eps, they are judeged to be the same
c
c
c      no sub needed
c
c
      subroutine   kxplsl(zz0,expa, zz1,zz2, eps, p,q, icon)
       implicit none
c
c
      complex*16 zz0, expa, zz1, zz2
      real*8 eps, p, q

c
      complex*16 z0, z1, z2, cexpa, z10, z20, z21
      integer icon, i200
      real*8 t, t1, t2
c
c       rotate zz0-line to be // to x-axis
      cexpa=conjg(expa)
      z0=zz0*cexpa
      z1=zz1*cexpa
      z2=zz2*cexpa
c
      z21=z2-z1
      z10=z1-z0
      z20=z2-z0
c        see if not right angle crossing
      if( real(z21) .ne. 0.) then
c           tan of relative angle
         t=IMAG_P(z21)/real(z21)
      else
         t=1.
      endif
c          see if they are //
      if( abs(t) .gt. eps )then
c              non //, so find + point
c          see if z1 = z2
          if(IMAG_P(z21) .eq. 0.) then
c              see if z0-line crosses the z1 and z2
             if(IMAG_P(z10) .eq. 0.) then
c                z1 is on the line
                q=real(z10)
                p=0.
                icon=0
             else
                 write(*, 320) zz1,zz2
  320            format('0*** error input to kxplsl;  z1=z2',4g13.3)
                 icon=2
             endif
         else
             p=- IMAG_P(z10)/IMAG_P(z21)
             q= real(z10) +  real(z21) * p
             if(p .lt.-eps .or.  p .gt. 1.+eps) then
                 icon=2
             else
                 icon=0
             endif
         endif
      else
c           if z0=z1  goto 200
         if(real(z10) .ne. 0.) then
             t1=z10*conjg(z10)
             t2=z20*conjg(z20)
             if( t1 .le. t2  ) then
c                z0 is closer to z1, so examine // of z0-line and z0-z2
                 t= IMAG_P(z20)/real(z20)
             else
                 t=IMAG_P(z10)/real(z10)
             endif
             if( abs(t) .gt. eps ) then
                 q=IMAG_P(z10)
                 icon=3
                 i200=0
             else
                 i200=1
             endif
         else
             if(abs(IMAG_P(z10)) .le. eps) then
                i200=1
             else
                i200=0
                q=IMAG_P(z10)
                icon=3
             endif
         endif
         if(i200 .eq. 1) then
              p=0.
              q= real(z10)
c                see if z0 is 'left' to z1
              if( q .gt. 0.) then
                  icon=1
              else
                  p=1.
                  q=real(z20)
c                  see if z0 is 'right' to z2
                  if( q .lt. 0. ) then
                      icon=1
                  else
c                         z0 is on the segment
                      q=0.
                      icon=1
                  endif
              endif
          endif
      endif
      if(icon .eq. 0) then
         if(p.gt. 1.) p=1.
         if(p .lt. 0.) p=0.
      endif
      end
c        test kxplbx: x-ssing point of a half line with a box
c
c        implicit  none
c        real*8 x0,y0,z0, l, m, n, el,a,b,c
c        integer icon
c
c        a=1.
c        b=1.
c        c=1.
c        x0= 0.5d0
c        y0= 2.5d0
c        z0=  1.d0
c        l  = 0.
c        m= 1.
c        n= 0.d0
c        write(*,*) ' enter x0,y0,z0, n,m '
c        read(*, *) x0,y0,z0, n,m
c        l = sqrt(1.d0-n**2- m**2)
c        write(*,*)  ' l=',l
c        call kxplbx(x0, y0, z0, l, m, n, a, b,c,el, icon)
c        write(*,*) ' icon=',icon, ' el=',el
c        end
c     ****************************************************************
c     *                                                              *
c     * kxplbx: crossing point of a line with a given box            *
c     *                                                              *
c     *********************** tested 89.09.06 ************************
c
c /usage/       call kxplbx(x0, y0, z0,  l, m, n, a, b, c,
c       *            el, icon)
c
c             z
c             !
c             !                  one corner of the box is at (0,0,0).
c             !                  the lengths of 3 sieds of the box are
c             !                  a, b, c and are on x,y,z axes, resp.
c             /-------------  y
c           /
c         /
c       /
c      x
c
c -- input --
c  x0,y0,z0:  the given line passes this point. real*8
c   l, m, n:  (x,y,z) components of the direction cosines of the line
c             real*8
c   a,b,c:    length of each side of the box
c
c
c  -- output --
c      el: crossing point is at (x0,y0,z0)+el*(l,m,n) real*8
c          only el>=0 is obtained.  if two such points exist,
c          nearest one is taken.
c   icon:  0 el is obtained. x0,y0,z0 is inside of the box
c          1 el is obtained. //       is outside of the box.
c         -1 no x-point el is undef.
c
      subroutine kxplbx(x0, y0, z0,  l, m, n,  a, b,  c,
     *            el,  icon)
       implicit none
c
      real*8 x0, y0, z0, l, m, n, el, a, b, c
      integer icon
c
      real*8 x1, y1, z1, x2, y2, z2, el1, el2,
     *       xo1, yo1, zo1, xo2, yo2, zo2
      real*8 eps
      data eps/1.d-6/
c
       if(abs(n) .ge. 1.d-1) then
            el1=(c-z0)/n
            el2= - z0/n
            x1= x0+ el1*l
            y1= y0+ el1*m
            z1= c
            x2= x0+ el2*l
            y2= y0+ el2*m
            z2= 0.
            call k3dclp(x1, y1, z1, x2, y2, z2, a, b, c,
     *      xo1, yo1, zo1, xo2, yo2, zo2, icon)
            if(icon .eq. 0) then
                el1=(zo1-z0)/n
                el2=(zo2-z0)/n
            endif
       elseif(abs(l) .ge. 1.d-1) then
            el1=(a-x0)/l
            el2= -x0/l
            x1=a
            y1=y0+ el1*m
            z1=z0+ el1*n
            x2=0.
            y2=y0+ el2*m
            z2=z0+ el2*n
            call k3dclp(x1, y1, z1, x2, y2, z2, a, b, c,
     *      xo1, yo1, zo1, xo2, yo2, zo2, icon)
            if(icon .eq. 0) then
                el1=(xo1-x0)/l
                el2=(xo2-x0)/l
            endif
        else
            el1=(b-y0)/m
            el2= -y0/m
            x1=x0+ el1*l
            y1=b
            z1=z0+ el1*n
            x2=x0+ el2*l
            y2=0.
            z2=z0+ el2*n
            call k3dclp(x1, y1, z1, x2, y2, z2, a, b, c,
     *      xo1, yo1, zo1, xo2, yo2, zo2, icon)

            if(icon .eq. 0) then
                el1=(yo1-y0)/m
                el2=(yo2-y0)/m
            endif
        endif
        if(icon .eq. 0) then
            if(el1 .gt. 0.) then
                if(el2 .gt. 0.) then
                   if(min(el1, el2)/max(el1, el2) .lt. eps) then
                      el = max(el1, el2)
                   else
                      el=min(el1, el2)
                      icon=1
                   endif
                elseif(el2 .le. 0.) then
                    el=el1
                    icon=0
                endif
            elseif(el1 .lt. 0.) then
                if(el2 .ge. 0.) then
                   icon=0
                   el=el2
                else
                   icon=-1
                endif
            else
                if(el2 .gt. 0.) then
                    el=el2
                    icon=0
                else
                    el=el1
                    icon=0
                endif
            endif
        endif
       end
c      
      subroutine kxplsph(x0, y0, z0, l, m, n, r, el, icon)
      implicit none
      real*8  x0, y0, z0 ! input. the line passes this point
      real*8  l, m, n  !  input.  direc cos.  of  the line
      real*8  r        !  input.  radius of the sphere
      real*8  el       !  output. el>=0 distance to the
                       !          sphere  from  x0,y0,z0
      integer icon    !  output. icon =0.  x-point exists 
                      !                  x0,.. is inside
                      !          icon = 1  x-point exists
                      !                  x0.. is outside
                      !                =-1.  no x-point

      real*8  rsqr, r0l, d
      integer icon1, icon2 
      
      rsqr = x0**2 + y0**2 + z0**2 -r**2
      if(rsqr .le. 0.) then
c          inside
         icon2 = 0
      else
         icon2 = 1
      endif
      r0l = x0*l + y0*m + z0*n
      d = r0l**2 - rsqr
      if(d .ge. 0.) then
         d = sqrt(d)
         el = -r0l - d
         if(el .ge. 0.) then
            icon1 = 0
         else
            el = -r0l + d
            if(el .ge. 0.) then
               icon1 = 0
            else
               icon1 = 1
            endif
         endif
      else
         icon1 = 1
      endif
c
      if(icon2 .eq. 0) then
         icon = 0
      elseif(icon1 .eq. 0) then
         icon = 1
      else
         icon = -1
      endif
      end

c        *********************************************************
c        *
c        * k3dclp: 3d clipping of a line segment by a box
c        *
c        *********************************************************
c
c /usage/  call k3dclp(xi0, yi0, zi0, xi1, yi1, zi1, a, b, c,
c         *            xo0, yo0, zo0, xo1, yo1, zo1, icon)
c
c       xi0, yi0, zi0: input.  1st point of the line segment
c       xi1, yi1, zi1: input.  2nd point of the line segment
c         a, b, c: input.  the lenght of three edges of the box.
c                   the three edges lie on (0,0,0)-(a,0,0)
c                                          (0,0,0)-(0,b,0)
c                                          (0,0,0)-(0,0,c)
c       xo0,yo0,zo0: output.  1st point of the segment
c       xo1,yo1,zo1: output.  2nd point of the segemnt
c                             these may be orignal points
c                             if points are contained in the
c                             box, or the point(s) on the surface
c                             of the box where the segment accrosses
c                             the box or not given.
c       icon: ouput.          =-1 --> no crossing point at all.
c                             = 0 --> crossing points exist or contained
c
       subroutine k3dclp(xi0, yi0, zi0, xi1, yi1, zi1, a, b, c,
     *                   xo0, yo0, zo0, xo1, yo1, zo1, icon)
       implicit none
c
c               ix : to set bit at x-th position  x=1,2, from right
c
       real*8 xi0, yi0, zi0, xi1, yi1, zi1, xo0, yo0, zo0,
     *        xo1, yo1, zo1, a, b, c
       integer icon
       
       integer i6, i5, i4, i3, i2, i1
       parameter (i6=5, i5=4, i4=3, i3=2, i2=1, i1=0)
       integer bp6, bp5, bp4, bp3, bp2, bp1
c              bit pattern whose x-th bit is on, where x is bpx)
       parameter (bp6=2**i6, bp5=2**i5, bp4=2**i4,
     *            bp3=2**i3, bp2=2**i2, bp1=2**i1)
       logical ok
       integer jc0, jc1, itmp
       real*8 x0, y0, z0, x1, y1, z1
       real*8 tmpx, tmpy, tmpz, t
c
       jc0=0
       jc1=0
c
       x0=xi0
       y0=yi0
       z0=zi0
       x1=xi1
       y1=yi1
       z1=zi1
c
       if(z0 .gt. c ) then
           jc0=ibset(jc0, i6)
       endif
       if(z0 .lt. 0.) then
           jc0=ibset(jc0, i5)
       endif
       if(y0 .gt. b) then
           jc0=ibset(jc0, i4)
       endif
       if(y0 .lt. 0.) then
           jc0=ibset(jc0, i3)
       endif
       if(x0 .gt. a) then
           jc0=ibset(jc0, i2)
       endif
       if(x0 .lt. 0.) then
           jc0=ibset(jc0, i1)
       endif
c
       if(z1 .gt. c ) then
           jc1=ibset(jc1, i6)
       endif
       if(z1 .lt. 0.) then
           jc1=ibset(jc1, i5)
       endif
       if(y1 .gt. b) then
           jc1=ibset(jc1, i4)
       endif
       if(y1 .lt. 0.) then
           jc1=ibset(jc1, i3)
       endif
       if(x1 .gt. a) then
           jc1=ibset(jc1, i2)
       endif
       if(x1 .lt. 0.) then
           jc1=ibset(jc1, i1)
       endif
c
c       *** until loop*** 
       do while (.true.)
           ok=jc0 .eq. 0 .and. jc1 .eq. 0
           if(ok) then
               icon=0
               xo0=x0
               yo0=y0
               zo0=z0
               xo1=x1
               yo1=y1
               zo1=z1
           else
               ok=iand(jc0, jc1) .ne. 0
               if(ok) then
                   icon=-1
               else
                   if(jc0 .eq. 0) then
                      tmpx=x0
                      tmpy=y0
                      tmpz=z0
                      x0=x1
                      y0=y1
                      z0=z1
                      x1=tmpx
                      y1=tmpy
                      z1=tmpz
                      itmp=jc0
                      jc0=jc1
                      jc1=itmp
                   endif
                   if(iand(jc0, bp6) .ne. 0) then
                       t=(c-z0)/(z1-z0)
                       z0=c
                       x0=x0 + (x1-x0) * t
                       y0=y0 + (y1-y0) * t
                   elseif(iand(jc0,bp5) .ne. 0) then
                       t=  -z0/(z1-z0)
                       z0=0.
                       x0=x0 + (x1-x0) * t
                       y0=y0 + (y1-y0) * t
                   elseif(iand(jc0, bp4) .ne. 0) then
                       t=(b-y0)/(y1-y0)
                       y0=b
                       x0=x0 + (x1-x0) * t
                       z0=z0 + (z1-z0) * t
                   elseif(iand(jc0, bp3) .ne. 0) then
                       t=  -y0/(y1-y0)
                       y0=0.
                       x0=x0 + (x1-x0) * t
                       z0=z0 + (z1-z0) * t
                   elseif(iand(jc0, bp2) .ne. 0) then
                       t=(a-x0)/(x1-x0)
                       x0=a
                       y0=y0 + (y1-y0) * t
                       z0=z0 + (z1-z0) * t
                   else
                       t=  -x0/(x1-x0)
                       x0=0.
                       y0=y0 + (y1-y0) * t
                       z0=z0 + (z1-z0) * t
                   endif
c
                   jc0=0
                   if(z0 .gt. c ) then
                       jc0=ibset(jc0, i6)
                   endif
                   if(z0 .lt. 0.) then
                       jc0=ibset(jc0, i5)
                   endif
                   if(y0 .gt. b) then
                       jc0=ibset(jc0, i4)
                   endif
                   if(y0 .lt. 0.) then
                       jc0=ibset(jc0, i3)
                   endif
                   if(x0 .gt. a) then
                       jc0=ibset(jc0, i2)
                   endif
                   if(x0 .lt. 0.) then
                       jc0=ibset(jc0, i1)
                   endif
               endif
           endif
       if         (ok)
     *                    goto 100
       enddo
  100  continue
      end
c      *********************************************************
c      *
c      * check if all the array elements are the same
c      *
c      *********************************************************
c
c  /usage/  call kcsame(x, intv, n, icon)
c
       subroutine kcsame(x, intv, n, icon)
       implicit none
       integer intv, n, icon
       real*8 x(intv, n)

       integer i
       real*8 s
          icon=0
          i=2
          s=x(1,1)
           do   i=2, n
              if(x(1,i) .ne. s) then
                 icon=1
                 goto 200
               endif
           enddo
  200     continue
        end
c      integer ia(2,10)
c     
c      do i = 1, 10
c         ia(1, i)= i
c      enddo
c      ia(1, 5) =9
c      call kfige(ia, 2, -10, 5, m, icon)
c      write(*, *) ' m=', m, ' icon=',icon, ' data=', ia(1, m)
c      end
c     ****************************************************************
c     *                                                              *
c     *  kfige: find integer data (position) .ge. given value        *
c     *                                                              *
c     ***********************  tested 81.04.10  **********************
c
c   /usage/
c          call kfige(x, intvx, n, c, m, icon)
c
c     x:  integer data array
c intvx:  interval of data in x
c     n:  !n! is no. of data in x
c     c:  given value.  x  .gt.  c is sought for.
c
c     m:  position of found data
c  icon:  0 if found else 1 results
c
c *** note ***
c         if n>0 search is made for from 1st, else from last
c
c
      subroutine kfige(x, intvx, n, c,  m, icon)
      implicit none
c
c
          integer x, intvx, n, c,  m, icon
c          dimension x(intvx,  n)
          dimension x(intvx,  *)
c
          integer istep, i1, i2, i

          if( n .eq. 0 ) then
             icon = 1
             return               !  **************
          elseif(n .gt. 0) then
             istep = 1
             i1 = 1
             i2 = n
          else
             istep = -1
             i1 = -n
             i2 = 1
          endif

          do i = i1, i2, istep
             if( x(1,i) .ge. c) then
                m = i
                icon = 0
                return       ! ********************
             endif
          enddo
          if(n .gt. 0) then
             m = n + 1
          else
             m = 0
          endif
          icon = 1
      end
c     ****************************************************************
c     *                                                              *
c     *  ksetrv: set given real*8 value in a given real array)       *
c     *                                                              *
c     *********************** tested 84.06.28 ************************
c
c   /usage/  call ksetrv(a, intv, n, v )
c
c   array positions of a(1), a(1+intv), ... a(1+(n-1)*intv) are
c   put the value of v.
c
c
      subroutine ksetrv(a, intv, n, v)
      implicit none
      
c
      real*8 a, v
      integer intv, n
      dimension a(intv, n)
c
      integer i 

           do   i=1, n
               a(1,i)=v
           enddo
      end
c     ****************************************************************
c     *                                                              *
c     *  ksetiv: set given interger value in a given interger array) *
c     *                                                              *
c     *********************** tested 84.06.28 ************************
c
c   /usage/  call ksetiv(a, intv, n, v )
c
c   array positions of a(1), a(1+intv), ... a(1+(n-1)*intv) are
c   put the value of v.
c
c
      subroutine ksetiv(a, intv, n, v)
      implicit none
c
          integer a, intv, n,  v
          dimension a(intv, n)
c
          integer i

           do   i=1, n
               a(1,i)=v
           enddo
      end
c	real*8 x, y, x1,y1, x2, y2, x3,  y3
c	integer inout
c	do while(.true.)
c	   write(*, *) ' x1,... y3'
c	   x1=0.
c	   y1 = 0.d0
c	   x2 = 1.d0
c	   y2 =  0.d0
c	   x3 =  .5d0
c	   y3 =  2.d0
c	   read(*, *) x1,y1, x2, y2, x3, y3
c	   x = 0.
c	   do  while (x .ne. -100.d0)
c	      write(*, *) 'x,y=' 
c	      read(*, *)  x, y
c	      call k3inout(x, y, x1, y1, x2, y2, x3, y3, inout)
c	      write(*, *) ' inout=', inout
c	   enddo
c	enddo
c	end

	subroutine k3inout(x, y, x1, y1, x2, y2, x3, y3, inout)
	implicit none
	real*8 x,y  ! input. some point to be judged if it is inside or
                    ! outsite of the triangle
        real*8 x1, y1 ! input.  1 point of the triangle
        real*8 x2, y2 ! input.  2nd point
        real*8 x3, y3 ! input.  3rd point
	integer inout ! output. 0--> in or on the line, 1 out
	logical anticw
c
	real*8  f, xa, ya, xb, yb, xc, yc
	f(xa, ya, xb, yb, xc, yc) = (xb- xa)*(yc-yb) - (yb-ya)*(xc-xb)

	inout = 1
	anticw = f(x1, y1, x2, y2, x3, y3) .gt. 0.d0

        if(anticw) then
           if( f(x1, y1, x2, y2, x, y) .lt. 0.d0) goto 10
           if( f(x2, y2, x3, y3, x, y) .lt. 0.d0) goto 10
           if( f(x3, y3, x1, y1, x, y) .lt. 0.d0) goto 10
           inout = 0
        else
           if( f(x1, y1, x2, y2, x, y) .gt. 0.d0) goto 10
           if( f(x2, y2, x3, y3, x, y) .gt. 0.d0) goto 10
           if( f(x3, y3, x1, y1, x, y) .gt. 0.d0) goto 10
           inout = 0
	endif
 10     continue
        end

c 
c       implicit none
c       character*15 field(100)
c       character*120 cdata
c       integer i, nf
c
c       do while (.true.)
c          read(*, '(a)',end=100) cdata
c          write(*,'(a)') cdata
c          call kgetField(cdata, field, nf)
c          do i = 1, nf
c             write(*,*) i, field(i)
c          enddo
c       enddo
c 100   continue
c       end

       subroutine kgetField(cdata, field, maxf, nf)
c          if cdata containes Tab, HP fortran
c             fails.
       implicit none
       character*(*) cdata
       character*(*) field(*)
       integer maxf  ! input. max of number of fields to be obtained
       integer nf    ! output. number of fields obtaiend

       integer klena
       integer nc, m1, m2

       nc = klena(cdata) 
       m2 = 1
       nf = 0
       do while (m2  .le.  nc)
          call kgetCpos(cdata(m2:nc), m1)
          m1 = m1 + m2 -1
          call kgetBpos(cdata(m1:nc), m2)
          m2 = m1 + m2 -1
          if(nf .lt. maxf) then
             nf = nf + 1
             field(nf) = cdata(m1:m2-1)
          else
             goto 10
          endif
       enddo
 10    continue
       end
       subroutine kgetCpos(ichrs,  idx)
       implicit none
c         shift ichrs to left until next non blank and
c         set its position in idx. 
       integer idx  ! = all + 1  if non blank is not found
       character*(*) ichrs  ! input characters
       integer k, i, klena
       character*1 tab

       tab = char(9)
       k = klena(ichrs)     ! effective length
       do i = 1, k
          if(ichrs(i:i) .ne. ' ' .and. ichrs(i:i) .ne. tab ) then
             idx = i
             goto 100
          endif
       enddo
       idx = k + 1
 100   continue
       end
       subroutine kgetBpos(ichrs, idx)
       implicit none
c         shift ichrs to left until next blank appear  and 
c         set its position in idx. 
       integer idx    ! = all+1 if blank is not found
       character*(*) ichrs
       integer k, i, klena

       character*1 tab

       tab = char(9)
       k = klena(ichrs)     ! effective length
       do i = 1, k
          if(ichrs(i:i) .eq. ' ' .or. ichrs(i:i) .eq. tab) then
             idx = i
             goto 100
          endif
       enddo
       idx = k + 1
 100   continue
       end
       subroutine kshiftB(ichrs,  ochrs, icon)
       implicit none
c        shift ichrs to left until next non blank and stores ochrs
       integer icon    ! = 0 ok.  1.  all blank. ochrs = ' '
       character*(*) ichrs, ochrs  ! ochrs can be ichrs
       integer k, i, klena
       character*1 tab

       tab = char(9)
       k = klena(ichrs)     ! effective length
       do i = 1, k
          if(ichrs(i:i) .ne. ' ' .and. ichrs(i:i) .ne. tab ) then

             ochrs = ichrs(i:k)
             icon = 0
             goto 100
          endif
       enddo
       ochrs=' '
       icon = 1
 100   continue
       end
       subroutine kshiftC(ichrs, ochrs, icon)
       implicit none
c      shift ichrs to left until next blank appear  and stores it into ochrs
       integer icon    ! = 0 ok.  1.  all non blank. ochrs = ' '
       character*(*) ichrs, ochrs  ! ochrs can be ichrs
       integer k, i, klena
       character*1 tab

       tab = char(9)
       k = klena(ichrs)     ! effective length
       do i = 1, k
          if(ichrs(i:i) .eq. ' ' .or. ichrs(i:i) .eq. tab) then
             ochrs = ichrs(i:k)
             icon = 0
             goto 100
          endif
       enddo
       ochrs = ' '
       icon = 1
 100   continue
       end
c      implicit none
c      real*8  x, y, z  
c      real*8  a, b, c, h 
c      integer  icon 
c                    
c
c      write(0, *) ' enter x,y,z, a, b, c, h'
c      read(*, *)  x,y,z, a, b, c, h
c      call kioPrism(x,y, z, a, b, c, h, icon)
c      write(*,*) icon
c      end
      subroutine kioPrism(x, y, z, a, b, c, h, icon)
c       judge if (x,y,z) is inside of a given prism
c       or not.
c
      implicit none
      real*8  x, y, z  ! input. a given point
      real*8  a, b, c, h ! input.  const to characterize a prism
      integer  icon  !  output.  icon =0.  the point is inside or
                     !            on the surface
                     !                +1   outside.

c          
c           | z
c           |           *
c           |         * |    + 
c           |       *   |         + 
c           |     *     h            +
c           |   *       |                 +
c           | *         |                      +
c           |___________|__________________________+   x
c           0           c                          a
c           
c          b is the depth on the y axis.
c  a, b,  c,  h can be negative.
c
c      
c
      integer jcon

c         see if y is inbetween 0,b
      if( (b-y)*y .ge.  0.d0) then
c           see if (x,z) is in the triagle
         call k3inout(x, z, 0.d0, 0.d0, a, 0.d0, c, h, jcon)

         if(jcon .eq. 0)  then
            icon = 0
         else
            icon = 1
         endif
      else
         icon = 1
      endif
      end
      subroutine kxplPrism(x0, y0, z0, l, m, n, 
     *            a, b, c, h , el, cond)
c         get the length to the nearest crossing point
c    of a given line with a given prism.
c
      real*8 x0, y0, z0  ! input.  the line passes this point
      real*8 l, m, n     ! input.  the line's direction cosine
      real*8 a, b, c, h  ! input.  prism parameter
      real*8 el          ! output. length to the crossing point
                         !         (only el>=0 is obtained)
      integer cond       ! output. =0, the point is inside or on 
                         !             the surface. el was obtained.
                         !         =1, the point is outside.
                         !             el was obtained.
c                        !         =-1  no crossing point.  el undef.
c     Z
c     |
c     |        *
c     |       *|    +
c     |      * |        + 
c     |     *  |            +
c     |    *   |                +
c     |   *    h                    + 
c     |  *     |                        +  
c     |________|___________________________+  X
c     0        c                           a 
c         b is depth along y.
c
c      a,b,c,h can be negative.
c
      real*8 x, y, z, el1, temp, eps
      integer inout
      character*120 msg


      data eps/-1.d-12/


c

c
c        x:  0~a is not necesarrily the range but x1~x2.
      x1 = min(0.d0, a, c)
      x2 = max(0.d0, a, c)
c         judge if (x0,.)  is inside
      call kioPrism(x0, y0, z0, a, b, c, h, cond)

      if(cond .eq. 0) then
c           inside
c          cross with the x-y plane ?
         if(n .ne.  0.d0) then
            el = -z0/n
         elseif(z0 .eq. 0.d0) then
            el = 0.
         else
            el = -1.    !  to skip next if
         endif
         if(el .ge. 0.d0) then
            x = x0 + el* l
            y = y0 + el* m
c             if (x,y) is inside the bottom, el obtained
            if( x*(a-x) .ge. eps  .and.
     *          (b-y)*y .ge. eps ) goto 10
         endif
c              cross with  / ?
         temp = c*n-h*l
         if(temp .ne. 0.d0) then
            el = (h*x0 - c*z0)/temp

         elseif( (h*x0 - c*z0) .eq. 0.d0) then
            el = 0.
         else
            el = -1.  ! this is to skip next if
         endif
         if(el .ge. 0.d0) then
            z = z0 + el * n
c               z : inbetween 0~h
            if( (h-z)*z .ge. 0.d0) then
               x = x0 + el * l
               if( x* (c - x) .ge. eps) then
                  y = y0 + el * m
                  if( (b-y)*y .ge. 0.) goto 10
               endif
            endif
         endif
c          cross with \ ?
         temp = h*l-(c-a)*n
         if(temp .ne. 0.d0) then
            el =(a*h- h*x0 + z0*(c-a))/temp
         elseif((a*h- h*x0 + z0*(c-a)) .eq. 0.d0) then
            el = 0.
         else
            el = -1.  ! to skip next
         endif
         if(el .ge. 0.d0) then
            z = z0 + el * n
            if( (h-z)*z .ge. eps) then
               x = x0 + el * l
               if( (c - x)* (x - a) .ge. 0.d0) then
                  y = y0 + el * m
                  if( (b-y)*y .ge. eps) goto 10
               endif
            endif
         endif
c           cross with x-z plane at y=0
         if(m .ne. 0.d0) then
            el = - y0/m
         elseif(y0 .eq. 0.d0) then
            el = 0.
         else
            el = -1.    ! to skip next if
         endif
         if(el .ge. 0.d0) then
            x = x0 + el * l
            z = z0 + el * n
            call k3inout(x, z, 0.d0, 0.d0, a, 0.d0, c, h, inout)
            if(inout .eq. 0) goto 10
         endif
c             cross with x-z plone at y=b  ?
         if(m .ne. 0.d0) then
            el = (b-y0)/m
         elseif(b .eq. y0)  then
            el = 0.
         else
            el  = -1.  ! to skip next if
         endif
         if(el .ge. 0.d0) then
            x = x0 + el * l
            z = z0 + el * n
            call k3inout(x, z, 0.d0, 0.d0, a, 0.d0, c, h, inout)
            if(inout .eq. 0) goto 10
         endif
c           error
         call 
     *   cerrorMsg('kxplPrism; point is inside but no x.p',1)
         write(msg, *) 'x0..=',x0,y0,z0, ' lmn=',l,m,n
         call cerrorMsg(msg, 0)
      else
c        ***********************************************
c         point is outside. firstly, judge no crossing
c         possiblity quickly
c
         cond = - 1

c            see if crossing point cannot be in the xrange.
c          For X point  to eixt inbetween x1,x2
c          f(el)=  (el*l - (x1-x0))(el*l -(x2-x0)) <= 0
c          must be sutisfied for some el >=0.
c          If there is no el >=0, there is no possibility of
c          crossing.
c          That  condtions is:
c                 for f(0) > 0 and  (x1-x0)/l < 0
c             (l !=0) .  if l=0,  f(0) > 0 is enough
         if((x1-x0)*(x2-x0) .gt. 0.d0 .and.
     *         (x1-x0)*l .le. 0.d0) goto 10
c            see if crossing point cannot be in the yrange
         if( (b-y0)*(-y0) .gt. 0.d0 .and.
     *       (b-y0)*m .le. 0.d0) goto 10
c            see if crossing point cannot be in the zrange
         if( (h -z0)*(-z0) .gt. 0.d0  .and.
     *              (h -z0)*n .le.0.d0) goto 10
c
c             there is a possibilty of crossing
         
         nc = 0          ! crossing point counter
c          see x.p on (x-y) 
         if(n .ne. 0.d0) then
            el = - z0/n
            if(el .ge. 0.d0) then
               x  = x0 + el *l
               y  = y0 + el *m
               if( x *(a-x) .ge. eps ) then
                  if( (b-y)* y .ge. eps ) then
                     nc = 1
                     el1 = el
                  endif
               endif
            endif
c        else
c            this case should be inside if x.p exists
         endif
c           see x.p on /
         temp = c*n - h*l
         if(temp .ne. 0.) then
            el =  (h*x0 - c*z0)/temp
            if(el .ge. 0.d0) then
               x = x0 + el*l
               y = y0 + el*m
               z = z0 + el*n
               if( x*(c-x) .ge. eps .and.
     *              y*(b-y) .ge.  eps  .and.
     *              z*(h-z) .ge.  eps ) then 

                  if(nc .eq. 0) then
                     el1 = el
                     nc = 1
                  else
                     el = min(el, el1)
                     cond = 1
                     goto 10
                  endif
               endif
            endif
c         else
c               this should not happen--> inside case
         endif
c
c              \ case
         temp = h*l -(c-a)*n
         if(temp .ne. 0.) then
            el =( a*h - h*x0 + (c-a)*z0 )/temp

            if(el .ge. 0.d0) then
               x = x0 + el*l
               y = y0 + el*m
               z = z0 + el*n
               if( (x-c)*(a-x) .ge. eps .and.
     *              y*(b-y) .ge.  eps  .and.
     *              z*(h-z) .ge.  eps ) then 

                  if(nc .eq. 0) then
                     nc = 1
                     el1 = el
                  else
                     el = min(el, el1)
                     cond = 1
                     goto 10
                  endif
               endif
            endif
c         else
c           this case; no need be checked.
         endif
c            cross with  x-z at y=0
         if(m .ne. 0.d0) then
            el = - y0/m
            if(el .ge. 0.d0) then
               x = x0 + el *l
               z = z0 + el *n
               call k3inout(x, z, 0.d0, 0.d0, a, 0.d0,
     *                     c, h, inout)
               if(inout .eq. 0) then
                  if(nc .eq. 0) then
                     nc = 1
                     el1 = el
                  else
                     el = min(el1, el)
                     cond = 1
                     goto 10
                  endif
               endif
            endif
c        else
c           not coming here 
         endif
c          cross with x-z y=b
         if(m .ne.  0.d0) then
            el = (b-y0)/m
            if(el .ge. 0.d0) then
               x = x0 + el *l
               z = z0 + el *n
               call k3inout(x, z, 0.d0, 0.d0,
     *         a, 0.d0, c, h, inout)
               if(nc .eq. 0) then
                  nc = 1
                  el1 =  el
               else
                  el = min(el1, el)
                  cond = 1
                  goto 10
               endif
            endif
c        else
c           not coming here 
         endif
         cond = -1
      endif
 10   continue
      end
c      real*8 kDebye, x
c      integer i
c      x = 0.
c      do i = 1, 100
c        write(*, *) x, kDebye(4, x)
c         x = x + 0.1d0
c      enddo
c      end
      
      real*8 function kDebye(n, x)
      implicit none
      integer n
      real*8 x
c          compute  Debye func* n/x**n
c          Debye function is defined by
c          Int(0:x) t**n/(e**t-1)
c          x >= 0.

c
      real*8 kDebye1, kDebye2
      real*8 zeta(5)
      real*8 pi,  zeta1, term
      integer i
      parameter (pi = 3.14159265358979, zeta1=pi**2/6.d0)
      data zeta(2)/zeta1/
      data zeta(3)/ 1.20205690315959d0/
      data zeta(4)/ 1.08232323371114d0/
      data zeta(5)/ 1.03692775514337d0/
c
      if(x .lt. 2.5) then
         kDebye = kDebye1(n, x)
      else
         term = 1.
         do  i = 1, n
            term = term * i
         enddo
         kDebye = ( term* zeta(n+1) - kDebye2(n, x))*n/x**n
      endif
      end

      real*8 function kDebye2(n, x)
      implicit none
      integer n
      real*8 x
c          for large x

      integer k, kmax, i
      real*8 sum, eps,  term, term2
      data eps/1.d-14/, kmax/20/

      sum = 0.
      
      do k = 1, kmax
         term2 = x**n/k
         term = term2
         do i = 1, n
            term2 =(term2/x*(n-i+1))/k
            term = term +  term2
         enddo
         term =  term*exp(-k*x)
         sum = sum + term

         if(abs(term/sum) .le. eps) goto 10
      enddo
 10   continue
      kDebye2 = sum
      end
      real*8 function kDebye1(n, x)
      implicit none
      real*8 x  !
      integer n
c 
      real*8 kBern, fac, sum, eps, xp, term
      integer k, kmax, k2
      parameter (kmax = 17)
c        (2k)! = (2k-2)! * (2k-1) * 2k
      data eps/1.d-14/

      fac = 1.
      sum = 0.
      xp = 1
      if(x .ne. 0d0) then
         do k = 1, kmax 
            k2 = k*2
            fac = fac * (k2-1) * k2 
            xp = xp * x * x
            term = kBern(k2)/fac*xp/(k2+n)
            sum = sum + term
c////////////
c            write(*,*)'----------', x, term/sum
c//////////////
            if(abs(term/sum) .lt. eps) goto 10
         enddo
 10      continue
      endif
      kDebye1 = (1.d0/n - x/(2*(n+1)) +  sum)*n

      end
c      integer i
c      real*8  kBern
c
c      write(*,*) kBern(0),kBern(1)
c      do i = 2, 34, 2
c         write(*, *) i, kBern(i)
c      enddo
c      end
      
      real*8 function kBern(n)
      implicit none
      integer n  ! input. one of 0,1,2,4,6,8... 34
c          compute Bernoulli's constant Bn
c
      integer     m, x, m1
      character*80 msg
      parameter ( m = 34, m1= m/2 )
      real*8 NM(m1), D(m1)

       data NM/
c           2            4                 6               8
     1     1d0,        -1d0,              1d0,           -1d0,     
c          10            12                14             16         
     2     5d0,       -691d0,              7d0,       -3617d0,
c          18            20                22             24 
     3    43867d0,   -174611d0,       854513d0,   -236364091d0,
c          26            28                30             32
     4 8553103d0, -23749461029d0, 8615841276005d0, -7709321041217d0,
c          34
     5 2577687858367d0/

       data D/
c         2         4       6     8       10     12
     1   6d0,    30d0,    42d0, 30d0,   66d0, 2730d0,
c        14        16       18    20      22     24
     2   6d0,   510d0,   798d0, 330d0,  138d0, 2730d0,
c        26        28       30    32      34  
     3   6d0,   870d0, 14322d0, 510d0,  6d0/        


           if(n .eq. 0) then
              kBern = 1.0
           elseif(n .eq.  1) then
              kBern = -5.d0
           else
              x = n/2
              if(x*2 .ne. n) then
                 write(msg, *) ' n=',n, ' to kBern must be even'
                 call cerrorMsg(msg, 0)
              elseif(x .gt. m1) then
                 write(msg, *) ' kBern: n=',n, 'must be <=', m
                 call cerrorMsg(msg, 0)
              endif
              kBern = NM(x)/D(x)
           endif
         end
c      real*8 x, kSpence, y
c      integer i
c      x = -10.
c      do i = 1, 200
c         y = kSpence(x)
c         write(*, *) x, 1-x, y
c         x = x + 0.1d0
c      enddo
c      end

      real*8 function kSpence(x)
      implicit none
      real*8 x   ! input
c
c        compute Spence function defined by sum of k=1,inf [x**k/k**2].
c        Let's denote it by P(x).  
c 
c        P(x) = x + x**2/4 + x**3/9 + x**4/16 + ...  |x| <= 1
c     
c        The function f(x) in p.1004 of
c        H.M.F is
c           f(x) = P(1-x) or P(x) = f(1-x)
c           P(x) + P(-x) = P(x**2)/2
c           P(1-x) + P(1-1/x) = -(log(x))**2/2
c           P(-x)  - P(1-x) =- log(x)log(1+x) - pi**2/12 - P(1-x**2)/2
c           P(x)  = -log(x)**2/2 + pi**2/3 - P(1/x)  (x > 1)
c           P(x)= -log(|x|)**2/2 - pi**2/6 - P(1/x)  (x< -1)
c  if x is near 1.0,  convergence of the series, P(x),  is slow.
c  So we use the Debye function.  
c       P(x) = f(1-x) and f(x) =D(t) with t = - log(x)
c       so P(x) =  D(t), t= - log(1-x).
c       When x = 1, P(x) = pi**2/6 = zeta(2)
c
c     
      real*8  kDebye, y, p1, p2, temp, t

      real*8 pi,  zeta1
      parameter (pi = 3.14159265358979, zeta1=pi**2/6.d0)

      if(x .le. 0.) then
c          P(x) = P(x**2)/2 - P(-x)
           y = x**2
           if(y .eq. 1.)  then
              p1 = zeta1
           elseif(y .lt. 1.) then
              t =  -  log(1.-y)
              p1 =  kDebye(1, t)*t
           else
c             p(y) =  -p(1/y) ...
              t = - log(1. - 1./y)
              temp = kDebye(1, t)*t  ! p(1/y)
              p1 = -log(y)**2/2 + pi**2/3 -temp
           endif
           y = -x
           if(y .eq. 1) then
              p2 = zeta1
           elseif(y .lt. 1.) then
              t =  -  log(1.-y)
              p2 =  kDebye(1, t)*t
           else
c             p(y) =  -p(1/y) ...
              t = - log(1. - 1./y)
              temp = kDebye(1, t)*t  ! p(1/y)
              p2 = -log(y)**2/2 + pi**2/3 -temp
           endif
c          P(x) = P(x**2)/2 - P(-x)
           kSpence = p1/2 - p2
        else
           if(x .eq. 1.)  then
              kSpence = zeta1
           elseif(x .lt. 1.) then
              t =  -  log(1.-x)
              kSpence =  kDebye(1, t)*t
           else
c             p(x) =  -p(1/x) ...
              t = - log(1. - 1./x)
              temp = kDebye(1, t)*t  ! p(1/y)
              kSpence = -log(x)**2/2 + pi**2/3 -temp
           endif
        endif
        end
      subroutine  kfindField(buf, leng, loc1, loc2,  cond)
      integer leng              ! input
      character*(leng)  buf     ! input
      integer  loc1             ! input.  
      integer  loc2             ! output  last non blank pos. in buf
                                !  after loc1 in buf.
c                                  if loc2 cannot be found loc2 = 0
      integer cond              !  input. if ==0 nothing happens
                                !   if ==1 and loc2==0; message is given
                                !   but execution contines
                                !   if  == 2 and loc2==0,   message is given
                                !  and execution stops

      integer i

      i = loc1
      loc2 = 0
      do while ( i .lt. leng )
         if( buf(i:i) .ne. ' '  .and. buf(i+1:i+1) .eq. ' ') then
            loc2=i
            goto 10
         endif
         i = i + 1
      enddo
      if(buf(leng:leng) .ne.  ' ' ) then
         loc2 = leng
         goto 10
      else
         loc2 = 0
      endif
 10   continue
      if( cond .gt.  0  .and. loc2 .eq. 0 ) then
         write(0, *) ' In kfindField: buf=',buf
         write(0, *) ' cannot find non blank after', loc1
         if(cond .eq. 2) stop 99999
      endif

      end
cc     test kxplineseg
c      real*8 x1, y1,x2,y2, x3, y3, x4, y4, eps
c      real*8 x,y, p, q
c      integer icon
c      eps  = 1.d-12
c      read(*,*) x1,y1
c      read(*,*) x2,y2
c      read(*,*) x3,y3
c      read(*,*) x4,y4
c
c      call kxplineseg(x1, y1, x2, y2, x3, y3, x4, y4, eps,
c     *     x, y, p, q, icon)
c      write(*,*) ' icon =', icon, 'p,q=',p,q
c      write(*,*) ' x,y=',x,y
c      end
c
c
c     get x-ssing point of two line segments on (x,y) plane
c
      subroutine kxplineseg(x1,y1, x2, y2, x3, y3, x4, y4, eps,
     *     x, y, p, q, icon)

      implicit none
      real*8 x1, y1, x2, y2  ! input one line segment. in complex ( z1, z2)
      real*8 x3, y3, x4, y4  !  input the other line segment. in complex  (z3, z4)
      real*8  eps            !  input. to judge the parallelity and/or
                             !         overlapping of two line segment
      real*8  x, y          ! output. obtained x-ssing point
      real*8  p             ! output. (z1 to the x-ppint)/(z1 to z2).  0<=p<=1. if not  outside
      real*8  q             ! output. (z3 to the x-point)/(z3 to z4).  0<=q<=1. if not  outside
      integer icon          ! output.  0, x,y obtained.
                            !          1, two segment overlap, (x,y) will 
                            !             be somewhere on the line
                            !          2, no x-ssing point 
      complex*16  expia, z1, z2, z3, z4
      real*8 cosa, sina
      real*8  length
      
      z1 = cmplx(x1, y1)
      z2 = cmplx(x2, y2)
      z3 = cmplx(x3, y3)
      z4 = cmplx(x4, y4)
      length = abs(z4-z3)
      if( length .le. eps )  then
         icon = 2
      else
         cosa = (x4-x3)/length
         sina = (y4-y3)/length
         expia = cmplx(cosa, sina)
         call kxplsl(z3, expia, z1 ,z2, eps, p, q, icon)
         if(icon  .eq. 0) then
c             see if x-point is within z3-z4.
            if(q .lt. 0.  .or. q .gt. length ) then
c                point is outside of the segment
               icon = 2
            else
               q = q/length
            endif
         elseif(icon .eq. 1 ) then
c///////
c            write(0,*) ' p,p=',p,q
            if( (x3-x1)*(x2-x3) .gt. 0.) then
               x = x3
               y = y3
            elseif( (x1-x3)*(x4-x1) .gt. 0.) then 
               if( (x2-x3)*(x4-x2) .gt. 0.) then 
                  if(abs(x1-x3) .lt. abs(x2-x3) ) then
                     x = x1
                     y = y1
                  else
                     x = x2
                     y = y2
                  endif
               else
                  x = x1
                  y = y1
               endif
            elseif( (x2-x3)*(x4-x2) .gt. 0.) then 
               x = x2
               y = y2
            else
               icon = 2 
            endif
         endif
      endif
      if(icon .eq. 0) then
         x = x1 +p*(x2-x1)
         y = y1 +p*(y2-y1)
      endif 
      end
c           test
c      implicit none
c      real*8 a, b, x0, y0, dirx, diry, x1, x2, y1, y2,l1,l2
c      integer cross
c      a = 2.
c      b = 1.
c      x0 = 0.5
c      y0 = -3.0
c      dirx = 0.1d0
c      diry = sqrt(1.d0-dirx**2)
c      call kxplellip(a, b, x0, y0, dirx, diry, l1, l2, cross)
c      write(0,*) ' cross=',cross, x0+l1*dirx,  y0+l1*diry,
c     *          x0+l2*dirx, y0+l2*diry
c      end
c
c
      subroutine kxplellip(a, b, x0, y0, dirx, diry, l1, l2, cross)
c         get crossing point of a line with an ellipse whose center is at (0,0)
c
      implicit none
      real*8 a  ! input   x radis of the ellipse
      real*8 b  ! input   y //
      real*8 x0 ! input   the line start from this x
      real*8 y0 ! input   the line start from this y
      real*8 dirx  ! input the line's direction cos to x
      real*8 diry  ! input the line's //               y
      real*8 l1    !  output.  a cross point ; x0+l1*dirx, y0+l1*diry
      real*8 l2    !  output.  the other cross point
                   !      0 <l1<l2 or l2 <0<l1 or l2<l1<0. or l1=l2
      integer cross ! output.  0--> the line cross the ellipse at two point
                    !          1--> the line is tangnetial to the ellipse
                    !          if two point are too near,  we regards them as one.
                    !          -1--> the line dose not cross the ellipse
      real*8   x, y, wx, wy, c0, c1h, c2, dq
      real*8   small, temp
      data small/1.d-8/
      

      x = x0/a
      y = y0/b
      wx = dirx/a
      wy = diry/b
      c2= wx**2 + wy**2
      c1h = x*wx+ y*wy
      c0 = x**2 + y**2 - 1.d0

      dq = c1h**2 - c0*c2
      
      if( dq .lt. 0.)  then
         cross = -1
      elseif( dq .le. small) then
         cross = 1
      else
         cross = 0
      endif
      if( cross .ge. 0 ) then
         dq =sqrt(dq)
         l1 = (-c1h - dq)/c2
         l2 = (-c1h + dq)/c2
         if(l1*l2 .lt. 0.) then
            if(l1 .lt. 0.) then
               temp = l1
               l1 = l2
               l2 = temp
            endif
         else
            if(abs(l1) .gt. abs(l2)) then
               temp = l1
               l1 = l2
               l2 = temp
            endif
         endif
      endif
      end
c      character*80 si, so  
c      character*4  t, r
c      read(*,'(a)') r
c      read(*,'(a)') t
c      read(*,'(a)') si
c      call kgsub(r, t, si, so)
c      write(*,*) so
c      end
c*****************************************
      subroutine kgsub(r, t, si, so)
      implicit none
c        replace stgring r in si by t and put so
c     
      character*(*)  r  ! input.
      character*(*)  t  ! input.
      character*(*)  si ! input.
      character*(*)  so ! output.

      integer klena, ir, it, isi, iso, i, j

      ir = klena(r)
      it = klena(t)
      isi = klena(si)
      iso = len(so)
      
      i = 1
      j = 0
      so = ' '
      do while ( i .le. isi )
         if(i+ir-1 .le. isi) then
            if( si(i:i+ir-1) .eq. r(1:ir)) then
               j = j + 1
               so(j:j+it-1) = t(1:it)
               j = j + it -1
               i = i + ir
            else
               j = j + 1
               so(j:j+it-1) = si(i:i)
               i = i + 1
            endif
         else
            j = j + 1 
            so(j:j+it-1) = si(i:i)
            i = i +1
         endif
         if(j .gt. iso) then
            write(0,*)
     *      ' output string length is too short: kgsub'
            stop 9999
         endif
      enddo
      end


      
      
